#!/usr/bin/env bash

## "PPHPC Java vs OpenCL-CPU Datasets"
## Copyright (c) 2017 Nuno Fachada
## MIT License

# ############################################# #
# Script used to create the OpenCL-CPU Datasets #
# ############################################# #

# Location of the OpenCL CPU PPHPC implementation
PPCMD="${HOME}/workspace/pphpc/opencl/build/pp/pp_cpu"

# Location of output files
OUTDIR="./OCLCPU_AMD_L1"

# Index of device to use
DEVICE=2

# Location of simulation configuration files
CFGDIR="${HOME}/workspace/pphpc-configs"

# Create output directory if it doesn't yet exist
mkdir -p ${OUTDIR}/simout
mkdir -p ${OUTDIR}/times

# Start runs
for RUN in {1..10}
do
    # Determine seed for this run
    SEED=`echo ${RUN} | md5sum | cut -f 1 -d ' '`
    SEED=`echo ${SEED} | awk '{print toupper($0)}'`
    SEED=`echo "ibase=16; ${SEED}" | bc`
    let "SEED=SEED%2147483647"

    # Cycle through model sizes
    for SIZE in 400 800 1600 3200 6400
    do

        # Cycle through parameter sets
        for VERS in 1 2
        do

            # Max. agents
            let "MAXAGENTS=(2 ** 17) * (($SIZE / 400) ** 2) * ($VERS ** 3)"
            # Output files
            OUTFILE="${OUTDIR}/simout/stats${SIZE}v${VERS}r${RUN}.txt"
            TIMEFILE="${OUTDIR}/times/time${SIZE}v${VERS}r${RUN}.txt"

            # Were the runs already performed?
            if [ ! -f ${OUTFILE} ] || [ ! -f ${TIMEFILE} ]; then

                # Print info about current run
                echo "Run #${RUN} | ${SIZE}@${VERS} | Max.Agents=${MAXAGENTS} | SEED=${SEED}"

                # Perform run
                /usr/bin/time -o ${TIMEFILE} ${PPCMD} \
                    -p ${CFGDIR}/config${SIZE}v${VERS}.txt -s ${OUTFILE} \
                    -r ${SEED} -n mwc64x -d ${DEVICE} -l 1 -m ${MAXAGENTS}

            fi

        done
    done
done
