## "PPHPC Java vs OpenCL-CPU Datasets"
## Copyright (c) 2017 Nuno Fachada
## MIT License

# ############################################# #
# Script used to perform statistical comparison #
# ############################################# #

# Load library for performing statistical comparison
library(micompr)

# Names of the PPHPC model outputs
outputs <- c("$P^s$", "$P^w$", "$P^c$", "$\\mean{E}^s$",
             "$\\mean{E}^w$", "$\\mean{C}$")

# Percentage of variance to explain
ve <- 0.9

# Location of simulation output data
java_dir <- "../java/simout/"
ocli_dir <- "../OCLCPU_Intel_L1/simout/"

# Perform statistical output comparison
mic1 <- micomp(outputs,
               ve,
               list(
                 list(name = "$400/1$",
                      folders = c(java_dir, ocli_dir),
                      files = rep(glob2rx("stats400v1r*.txt"), 2),
                      lvls = c("Java", "OpenCL")),
                 list(name = "$800/1$",
                      folders = c(java_dir, ocli_dir),
                      files = rep(glob2rx("stats800v1r*.txt"), 2),
                      lvls = c("Java", "OpenCL")),
                 list(name = "$1600/1$",
                      folders = c(java_dir, ocli_dir),
                      files = rep(glob2rx("stats1600v1r*.txt"), 2),
                      lvls = c("Java", "OpenCL")),
                 list(name = "$3200/1$",
                      folders = c(java_dir, ocli_dir),
                      files = rep(glob2rx("stats3200v1r*.txt"), 2),
                      lvls = c("Java", "OpenCL")),
                 list(name = "$6400/1$",
                      folders = c(java_dir, ocli_dir),
                      files = rep(glob2rx("stats6400v1r*.txt"), 2),
                      lvls = c("Java", "OpenCL")),
                 list(name = "$400$/2",
                      folders = c(java_dir, ocli_dir),
                      files = rep(glob2rx("stats400v2r*.txt"), 2),
                      lvls = c("Java", "OpenCL")),
                 list(name = "$800/2$",
                      folders = c(java_dir, ocli_dir),
                      files = rep(glob2rx("stats800v2r*.txt"), 2),
                      lvls = c("Java", "OpenCL")),
                 list(name = "$1600/2$",
                      folders = c(java_dir, ocli_dir),
                      files = rep(glob2rx("stats1600v2r*.txt"), 2),
                      lvls = c("Java", "OpenCL")),
                 list(name = "$3200/2$",
                      folders = c(java_dir, ocli_dir),
                      files = rep(glob2rx("stats3200v2r*.txt"), 2),
                      lvls = c("Java", "OpenCL")),
                 list(name = "$6400/2$",
                      folders = c(java_dir, ocli_dir),
                      files = rep(glob2rx("stats6400v2r*.txt"), 2),
                      lvls = c("Java", "OpenCL"))
               ),
               concat = F)

# Generate table with MANOVA test p-values
t1 <- toLatex(mic1, 
              data_show = c("mnvp-1"), 
              labels_col_show = F,
              tag_comp = "Size/set",
              booktabs = T,
              caption = "Statistics, param. set 1.",
              label = "tab:statv1")
