%% "PPHPC Java vs OpenCL-CPU Datasets"
%% Copyright (c) 2017 Nuno Fachada
%% MIT License

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
% Script used to perform performance comparison %
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %

% Important note:
% This script requires the PerfAndPubTools MATLAB/Octave package

% Location of simulation performance data
pathjava = '../java/times';
pathocli = '../OCLCPU_Intel_L1/times';
pathocla = '../OCLCPU_AMD_L1/times';

%%%%%%% JAVA %%%%%%%

% Setups
j400v1 = struct('sname', '400', 'csize', 400, 'folder', pathjava, 'files', 'time400v1r*.txt');
j400v2 = struct('sname', '400', 'csize', 400, 'folder', pathjava, 'files', 'time400v2r*.txt');
j800v1 = struct('sname', '800', 'csize', 800, 'folder', pathjava, 'files', 'time800v1r*.txt');
j800v2 = struct('sname', '800', 'csize', 800, 'folder', pathjava, 'files', 'time800v2r*.txt');
j1600v1 = struct('sname', '1600', 'csize', 1600, 'folder', pathjava, 'files', 'time1600v1r*.txt');
j1600v2 = struct('sname', '1600', 'csize', 1600, 'folder', pathjava, 'files', 'time1600v2r*.txt');
j3200v1 = struct('sname', '3200', 'csize', 3200, 'folder', pathjava, 'files', 'time3200v1r*.txt');
j3200v2 = struct('sname', '3200', 'csize', 3200, 'folder', pathjava, 'files', 'time3200v2r*.txt');
j6400v1 = struct('sname', '6400', 'csize', 6400, 'folder', pathjava, 'files', 'time6400v1r*.txt');
j6400v2 = struct('sname', '6400', 'csize', 6400, 'folder', pathjava, 'files', 'time6400v2r*.txt');

% Impl. specs.
jv1 = {j400v1, j800v1, j1600v1, j3200v1, j6400v1};
jv2 = {j400v2, j800v2, j1600v2, j3200v2, j6400v2};

%%%%%%% Intel OpenCL %%%%%%%

% Setups
oi400v1 = struct('sname', '400', 'csize', 400, 'folder', pathocli, 'files', 'time400v1r*.txt');
oi400v2 = struct('sname', '400', 'csize', 400, 'folder', pathocli, 'files', 'time400v2r*.txt');
oi800v1 = struct('sname', '800', 'csize', 800, 'folder', pathocli, 'files', 'time800v1r*.txt');
oi800v2 = struct('sname', '800', 'csize', 800, 'folder', pathocli, 'files', 'time800v2r*.txt');
oi1600v1 = struct('sname', '1600', 'csize', 1600, 'folder', pathocli, 'files', 'time1600v1r*.txt');
oi1600v2 = struct('sname', '1600', 'csize', 1600, 'folder', pathocli, 'files', 'time1600v2r*.txt');
oi3200v1 = struct('sname', '3200', 'csize', 3200, 'folder', pathocli, 'files', 'time3200v1r*.txt');
oi3200v2 = struct('sname', '3200', 'csize', 3200, 'folder', pathocli, 'files', 'time3200v2r*.txt');
oi6400v1 = struct('sname', '6400', 'csize', 6400, 'folder', pathocli, 'files', 'time6400v1r*.txt');
oi6400v2 = struct('sname', '6400', 'csize', 6400, 'folder', pathocli, 'files', 'time6400v2r*.txt');

% Impl. specs.
oiv1 = {oi400v1, oi800v1, oi1600v1, oi3200v1, oi6400v1};
oiv2 = {oi400v2, oi800v2, oi1600v2, oi3200v2, oi6400v2};

%%%%%%% AMD OpenCL %%%%%%%

% Setups
oa400v1 = struct('sname', '400', 'csize', 400, 'folder', pathocla, 'files', 'time400v1r*.txt');
oa400v2 = struct('sname', '400', 'csize', 400, 'folder', pathocla, 'files', 'time400v2r*.txt');
oa800v1 = struct('sname', '800', 'csize', 800, 'folder', pathocla, 'files', 'time800v1r*.txt');
oa800v2 = struct('sname', '800', 'csize', 800, 'folder', pathocla, 'files', 'time800v2r*.txt');
oa1600v1 = struct('sname', '1600', 'csize', 1600, 'folder', pathocla, 'files', 'time1600v1r*.txt');
oa1600v2 = struct('sname', '1600', 'csize', 1600, 'folder', pathocla, 'files', 'time1600v2r*.txt');
oa3200v1 = struct('sname', '3200', 'csize', 3200, 'folder', pathocla, 'files', 'time3200v1r*.txt');
oa3200v2 = struct('sname', '3200', 'csize', 3200, 'folder', pathocla, 'files', 'time3200v2r*.txt');
oa6400v1 = struct('sname', '6400', 'csize', 6400, 'folder', pathocla, 'files', 'time6400v1r*.txt');
oa6400v2 = struct('sname', '6400', 'csize', 6400, 'folder', pathocla, 'files', 'time6400v2r*.txt');

% Impl. specs.
oav1 = {oa400v1, oa800v1, oa1600v1, oa3200v1, oa6400v1};
oav2 = {oa400v2, oa800v2, oa1600v2, oa3200v2, oa6400v2};

%%%%%%%%% Plots %%%%%%%%%%%%%
[~,~,~,fid] = perfstats(4, 'Java', jv1, 'OpenCL Intel', oiv1, 'OpenCL AMD', oav1);
fidchilds = get(fid, 'Children');
lines = get(fidchilds(2), 'Children');
set(lines(1), 'Marker', 'o');
set(lines(2), 'Marker', 'd');
set(lines(3), 'Marker', 's');
set(gca, 'XTickLabel', [400 800 1600 3200 6400]);
grid minor;
cleanfigure();
matlab2tikz('standalone', true, 'filename', 'perf_v1.tex');
title('V1');

[~,~,~,fid] = perfstats(4, 'Java', jv2, 'OpenCL Intel', oiv2, 'OpenCL AMD', oav2);
fidchilds = get(fid, 'Children');
lines = get(fidchilds(2), 'Children');
set(lines(1), 'Marker', 'o');
set(lines(2), 'Marker', 'd');
set(lines(3), 'Marker', 's');
set(gca, 'XTickLabel', [400 800 1600 3200 6400]);
grid minor;
cleanfigure();
matlab2tikz('standalone', true, 'filename', 'perf_v2.tex');
title('V2');

speedup(-1, 1, 'Java', jv1, 'OpenCL Intel', oiv1, 'OpenCL AMD', oav1);
matlab2tikz('standalone', true, 'filename', 'speedup_v1.tex');
title('V1');

speedup(-1, 1, 'Java', jv2, 'OpenCL Intel', oiv2, 'OpenCL AMD', oav2);
matlab2tikz('standalone', true, 'filename', 'speedup_v2.tex');
title('V2');

%%%%%%% Tables %%%%%%%% 
tdata1 = times_table(1, 'Java', jv1, 'OpenCL Intel', oiv1, 'OpenCL AMD', oav1);
tdata2 = times_table(1, 'Java', jv2, 'OpenCL Intel', oiv2, 'OpenCL AMD', oav2);
tabl = times_table_f(1, 'v1', tdata1, 'v2', tdata2);

