% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dc_data_centers.R
\name{dc_data_centers}
\alias{dc_data_centers}
\title{DataCite REST API: data centers}
\usage{
dc_data_centers(query = NULL, member_id = NULL, offset = 0,
  rows = 25, include = NULL, ...)
}
\arguments{
\item{query}{(character) Query string, e.g., data center name}

\item{member_id}{(character) Member that the data center is associated with}

\item{offset}{(numeric/integer) result offset, the record to start at}

\item{rows}{(numeric/integer) results per page}

\item{include}{(character) vector of member fields to return}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
DataCite REST API: data centers
}
\examples{
\dontrun{
dc_data_centers(member_id = "delft")
dc_data_centers(member_id = "delft", include = "member")
}
}
\seealso{
\code{\link[=dc_data_center]{dc_data_center()}}

Other rest api methods: \code{\link{dc_data_center}},
  \code{\link{dc_members}}, \code{\link{dc_member}},
  \code{\link{dc_works}}, \code{\link{dc_work}}
}
\concept{rest api methods}
