% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.nex.R
\name{write.nex}
\alias{write.nex}
\title{Write a nexus data object to a file}
\usage{
write.nex(x, file, missing = NULL, gap = NULL, mrbayes = FALSE,
  ngen = NULL, phy = NULL, run = FALSE, format = c("nexus", "tnt"))
}
\arguments{
\item{x}{(required) nexus file (`nex`) object}

\item{file}{file patch for exported file}

\item{missing}{character representing missing data}

\item{gap}{character representing incomparable data}

\item{mrbayes}{whether to add mrbayes block to output}

\item{ngen}{number of generations to run in mrbyaes}

\item{phy}{input phylogeny for downstream analysis in mrbayes}

\item{run}{whether to run TNT analysis}

\item{format}{output formate}
}
\value{
an object of class \code{nex} for use in further \code{phenotools} functions
}
\description{
Function to write nexus file to data for, e.g., analysis in MESQUITE, etc.
}
\examples{
\dontrun{
x <- read.nex(file = system.file("extdata", "clarke_2006.nex",
package = "phenotools"))
write.nex(x, file='test.nex')
}

}
\author{
Chad Eliason \email{celiason@fieldmuseum.org}
}
