% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traitlink.R
\name{traitlink}
\alias{traitlink}
\title{Function to link character descriptions to a trait ontology}
\usage{
traitlink(tree, x)
}
\arguments{
\item{tree}{trait ontology (an `igraph` object produced, e.g., by \code{read_ontology})}

\item{x}{nexus file}
}
\value{
a list with character names (chars), distance matrix (dmat), trait
ontology links (ont), and node depths for each character(nodedepth)
}
\description{
Function uses fuzzy text matching to output a list of potentially redundant
characters in a `nex` object, waits for user input to confirm, and then
handles merging of characters and outputs a new `nex` object
}
\examples{
\dontrun{
x <- twig
ont <- read_ontology(file = system.file("extdata", "baumel_ontology.txt",
package = "phenotools"))
tl <- traitlink(tree=ont, x=x)
# first five characters, links to trait ontology:
tl$ont[1:5]
}

}
\author{
Chad M. Eliason
}
