% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchtree.R
\name{searchtree}
\alias{searchtree}
\title{Function to grep search labels in tree and plot all connected components}
\usage{
searchtree(graph, pattern, plot = TRUE, mode = "out", ...)
}
\arguments{
\item{graph}{(required) input graph of trait ontology generated by, e.g., read_ontology() or stemsearch()}

\item{pattern}{text to search for (regular expression)}

\item{plot}{whether to plot (logical)}

\item{mode}{whether to search for all edges to current node ("in") or away from ("out")}

\item{...}{additional arguments passed to the `plot.igraph` function}
}
\description{
Function to grep search labels in tree and plot all connected components
}
\examples{
\dontrun{
# load Baumel and Whitmer (1993) ontology:
ont <- read_ontology(file = system.file("extdata", "baumel_ontology.txt",
package = "phenotools"))
# show all traits in ontology under "orbita"
searchtree(ont, "\\\\borbita\\\\b")
}
}
\references{
Baumel, J. J., and L. M. Witmer. 1993. Osteologia. P. in
Handbook of avian anatomy: nomina anatomica avium. Publications of the
Nuttall Ornithological Club.
}
