% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printout.R
\name{printout}
\alias{printout}
\title{Function to print an html summary of clusters of similar characters}
\usage{
printout(x, maxsize = NULL, file, statelabels = TRUE)
}
\arguments{
\item{x}{= nexus object with clusters found}

\item{maxsize}{= maximum size of cluster of characters}

\item{file}{name of output file (html format)}

\item{statelabels}{whether to include state labels in output}
}
\description{
Function prints out a list of clusters of similar characters with terms color-
coded to illustrate overlap among similar characters
}
\examples{
\dontrun{
data(twig)
dups <- duplicated(twig, opt="terms")
printout(dups, maxsize=10, file="twig.html")
}

}
