% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.nex.R
\name{plot.nex}
\alias{plot.nex}
\title{plot data matrix and phylogeny}
\usage{
\method{plot}{nex}(x, phy = NULL, legend.pos = c("none", "left",
  "right", "bottom", "top"), bw = FALSE, na.value = "lightgray",
  fsize = 8, fill = c("statelabels", "charpartition", "charset",
  "file"))
}
\arguments{
\item{x}{a `nex` object for plotting}

\item{phy}{a phylogeny in `phylo` format}

\item{legend.pos}{position of legend}

\item{bw}{whether to plot in black (scoring present) and white (no scoring)}

\item{na.value}{color for NA values in matrix}

\item{fsize}{font size}

\item{fill}{how to color cells in matrix}
}
\description{
Plots a nexus dataset and optionally a tree
}
\examples{
\dontrun{
# load theropod dataset:
data(twig)
# plot data matrix
plot(twig[,1:10], fill="statelabels", legend.pos="top", na.value="black")
# plot matrix alongside phylogeny
library(ape)
s <- "(Tyrannosaurus_rex,(Archaeopteryx_lithographi,Anas_platyrhynchus));"
phy <- compute.brlen(read.tree(text=s))
plot(phy)
plot(x=twig[,1:20], phy=phy, fill="statelabels", legend.pos="top", na.value="white")
}
}
\references{
Brusatte, S. L., G. T. Lloyd, S. C. Wang, and M. A. Norell. 2014.
Gradual Assembly of Avian Body Plan Culminated in Rapid Rates of Evolution
across the Dinosaur-Bird Transition. Curr Biol 24:2386–2392.
(\href{https://www.ncbi.nlm.nih.gov/pubmed/25264248}{PubMed})
}
