% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_ontology.R
\name{generate_ontology}
\alias{generate_ontology}
\title{Generate a trait ontology from a nexus file}
\usage{
generate_ontology(x)
}
\arguments{
\item{x}{a `nex` object containing character descriptions}
}
\description{
Comma separated terms are used to define links among components of a nexus
character list
}
\examples{
\dontrun{
x <- read.nex(system.file("extdata", "clarke_2006.nex", package = "phenotools"))
# plot data matrix:
plot(x)
# generate ontology based on comma-separated terms in characters:
ont <- generate_ontology(x)
# plot ontology for humerus characters:
searchtree(ont$tree, pattern="humer")
}

}
