% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter}
\alias{filter}
\title{Filter duplicated characters in a nexus file}
\usage{
filter(x, dups = NULL)
}
\arguments{
\item{x}{(required) a nexus input file}

\item{dups}{an optional matrix or list specifying which character are duplicates (e.g., dups = list('1733' = c(1741,1745,1755)))}
}
\description{
Given a list of specified duplicates, drop and/or merge characters
}
\examples{
\dontrun{
x <- read.nex(system.file("extdata", "clarke_2006.nex", package = "phenotools"))
y <- read.nex(system.file("extdata", "nesbitt_2015.nex", package = "phenotools"))
xy <- concat(list(x,y))
dups <- duplicated(xy, opt="terms")
# a pair of duplicate characters
xy[,c(144,345)]$charlab
# drop from dataset
xy2 <- filter(xy, cbind(144,345))
xy
xy2
}

}
