% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicated.nex.R
\name{duplicated.nex}
\alias{duplicated.nex}
\title{Find duplicate or overlapping characters in nexus files}
\usage{
\method{duplicated}{nex}(x, opt = c("fuzzy", "terms", "comments",
  "traitcor"), method = NULL, within_dataset = FALSE,
  commasep = FALSE, weighting = c(1, 1, 1), K = 1,
  cluster = c("infomap", "fast_greedy", "walktrap", "label_prop",
  "leading_eigen", "louvain", "optimal", "spinglass"), cores = 1,
  latin = TRUE)
}
\arguments{
\item{x}{(required) a `nex` object}

\item{opt}{method to use for finding duplicates}

\item{method}{specific method arguments to pass to functions}

\item{within_dataset}{whether to limit search to only among-dataset characters (e.g., useful if you are certain the individual matrices do not contain duplicates)}

\item{commasep}{whether characters should be split into parts based on commas}

\item{weighting}{vector for parts of character (before comma, after comma, character states)}

\item{K}{number of clusters (if 1 cluster are found automatically according to method specified with `cluster=`)}

\item{cluster}{clustering algorithm to use for finding overlapping characters}

\item{cores}{how many cores to use (for parallel processing in traitcor option)}

\item{latin}{whether to use Schinke Latin stemmer (logical)}
}
\value{
an object of class \code{nex} for use in further \code{phenotools} functions
}
\description{
Function uses fuzzy text matching to output a list of potentially overlapping
characters in a `nex` object
}
\examples{
\dontrun{
x1 <- read.nex(system.file("extdata", "clarke_2006.nex", package = "phenotools"))
x2 <- read.nex(system.file("extdata", "nesbitt_2015.nex", package = "phenotools"))
x <- concat(list(x1, x2))
x.dup <- duplicated.nex(x, opt = "terms")
# printout(x.dup, file="testprintout.html")
}

}
\author{
Chad Eliason \email{celiason@fieldmuseum.org}
}
