% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concat.R
\name{concat}
\alias{concat}
\title{Merge a list of nexus files}
\usage{
concat(x, taxa = NULL)
}
\arguments{
\item{x}{(required) a list of `nex` objects to merge}

\item{taxa}{a character vector of names of taxa to include in concatenated nexus file (optional)}
}
\value{
an object of class `nex` for use in further `phenotools` functions
}
\description{
A function that combines nexus datasets
}
\examples{
\dontrun{
x <- read.nex(system.file("extdata", "clarke_2006.nex", package = "phenotools"))
y <- read.nex(system.file("extdata", "nesbitt_2015.nex", package = "phenotools"))
xy <- concat(list(x, y), taxa = c('Anas_platyrhynchos', 'Gallus_gallus', 'Crypturellus_undulatus'))
xy
}

}
\author{
Chad Eliason \email{celiason@fieldmuseum.org}
}
