#' Morphological character dataset for theropod dinosaurs
#'
#' Data assembled from assessment of study specimens
#'
#' @docType data
#'
#' @usage data(twig)
#'
#' @format An object of class \code{"nex"}; see \code{read.nex}.
#'
#' @keywords datasets
#'
#' @references Brusatte, S. L., G. T. Lloyd, S. C. Wang, and M. A. Norell. 2014.
#' Gradual Assembly of Avian Body Plan Culminated in Rapid Rates of Evolution
#' across the Dinosaur-Bird Transition. Curr Biol 24:2386–2392.
#' (\href{https://www.ncbi.nlm.nih.gov/pubmed/25264248}{PubMed})
#' 
#' @examples
#' data(twig)
#' plot(twig)
#' twig$taxlabels
"twig"