#use "utils/init.ml" ;;

open Frontend

let () = Arg.parse_argv Sys.argv speclist (fun _ -> ()) usage
let () = Compiler.Compmisc.init_path false
let () =
  (Lazy.force codebase)
    |> Codebase.iter @@ fun f
    -> let filename = f.Fileinfos.filename in
       if not (Filename.check_suffix filename !Compiler.Config.interface_suffix) then
         print_endline
           Filename.(concat (dirname filename) (Fileinfos.object_filename f))