open Containers
open Format

open Lib

open Refactoring
open Repr

open Elements.Base
open Identifier

let of_repr = function
| Identity ->
  (module Identity : S)
| Rename ((lib, Chain.Ex (Value, from)), _to) ->
  let module R = Rename_val.Make () in
  let () = R.init ((lib, from), _to) in
  (module R : S)
| _ ->
  not_implemented ()

let mk_repr (r, params) =
  match r with
  | "rename" ->
    begin match params with
    | [from; _to] ->
      let () = Logging.debug @@ fun _f -> _f
        "Creating representation of \"rename\" with parameters: \"%s\", \"%s\""
        from _to in
      Rename (of_string from, _to)
    | _ ->
      invalid_arg
        (Format.sprintf
          "Wrong number of arguments for [rename]: %a"
            (List.pp String.pp) params)
    end
  | _ when String.equal r Identity.name ->
    Identity
  | _ ->
    raise Not_found

let get (r, params) = of_repr (mk_repr (r, params))