open Containers

let out_file : string option ref = ref None

let set f =
  IO.with_out f (fun oc -> Pervasives.output oc Bytes.empty 0 0) ;
  out_file := Some f

let print_string s =
  match !out_file with
  | None ->
    Pervasives.print_string s
  | Some f ->
    IO.with_out_a f (fun oc -> Pervasives.output_string oc s)

let print_endline s =
  match !out_file with
  | None ->
    Pervasives.print_endline s
  | Some f ->
    IO.with_out_a f (fun oc -> Pervasives.output_string oc s) ;
    IO.with_out_a f (fun oc -> Pervasives.output_char oc '\n')