open Containers

open Compiler_import

include Compiler_import.Env

let rec normalize_mty_path ?(lax=true) env path =
  let path =
    match path with
    | Path.Pident _ ->
      path
    | Path.Pdot(p, s, pos) ->
      let loc = if lax then Some Location.none else None in
      Path.Pdot(normalize_path loc env p, s, pos)
    | Path.Papply(p1, p2) ->
      invalid_arg (Format.sprintf "%s.normalize_mty_env" __MODULE__) in
  try match find_modtype path env with
  | Types.{ mtd_type = Some Mty_alias _; _ } ->
    assert false
  | Types.{ mtd_type = Some Mty_ident path; _ } ->
    normalize_mty_path ~lax env path
  | _ ->
    path
  with
  | Not_found
      when
        lax ||
        (match path with
          | Path.Pident id -> not (Ident.persistent id)
          | _ -> true) ->
    path