Require Import AbstractRenaming.Renaming_operations AbstractRenaming.Semantics
               AbstractRenaming.Modules List AbstractRenaming.Default_renaming.

Set Implicit Arguments.

(** * Characterising Renaming *)

Module Characterising (Import L : LanguageSig).
Module Import SL := Semantics L.
Module Import SD := Correctness L SL.
Module Import RO := Renaming L (SL.ML).

(** Footprints are locations where value identifiers differ *)
(* begin hide *)
Lemma footprint_vid_v l v v': wf_v v -> is_renaming_v v v' ->
  In l (φv v v') <->
  exists v0 v1, value_identifier_v (v0, l) v /\
                value_identifier_v (v1, l) v' /\
                v0 <> v1.
Proof.
revert v'. induction v; intros v' Hwf Hr; destr_locs;
destruct v'; destr_locs; simpl in *; subst; try tauto;
try case val_eq_dec; intros; subst; simpl; split;
intuition; destr_pairs; subst; repeat rewrite in_app_iff in *;
repeat match goal with [H: exists _, _ |- _] =>
  let v1 := fresh v1 in let v2 := fresh v2 in destruct H as (v1&v2&Heq) end;
try erewrite IHv1 in * by eauto;
try erewrite IHv2 in * by eauto;
repeat match goal with [H: exists _, _ |- _] =>
  let v1 := fresh v1 in let v2 := fresh v2 in let Heq := fresh Heq in destruct H as (v1&v2&Heq) end;
intuition; destr_pairs; try tauto; try solve[eexists; eexists; intuition; eauto];
repeat match goal with [H: exists _, _ |- _] =>
  let v1 := fresh v1 in let v2 := fresh v2 in destruct H as (v1&v2&Heq) end;
intuition; try solve[eexists; eexists; intuition; eauto];
try solve[left; eauto]; try solve[right; eauto]; try solve[apply IHv; eauto];
try solve[right; left; eauto]; try solve[right; right; eauto];
(* impossible cases *)
try solve [repeat ((match goal with
  |[H: value_identifier_v _ _|- _] => apply value_identifier_locs_v in H
  | [H: disj ?a ?b |- _] => let H1 := fresh H in let H2 := fresh H in
                            assert(H1 := H l); assert(H2 := disj_sym H l); clear H
  | [H: is_renaming_v ?a ?b |- _] => apply renaming_locs_v in H; rewrite H in *
 end)); tauto];
try match goal with | [H: In _ (φv _ _) |- _] =>
  apply IHv in H; auto; decompose record H; eexists; eexists; eauto end.
right; apply IHv; eauto.
Qed.

Lemma footprint_vid_t l:
  (forall t t', wf_t t -> is_renaming_t t t' ->
  In l (φt t t') <->
  (exists v0 v1, value_identifier_t (v0, l) t /\
                 value_identifier_t (v1, l) t' /\
                 v0 <> v1)) *
  (forall ls ls', wf_list_S ls -> is_renaming_list_S ls ls' ->
    In l (φlist_S ls ls') <->
    exists v0 v1, value_identifier_S (v0, l) ls /\
                  value_identifier_S (v1, l) ls' /\
                  v0 <> v1).
Proof.
apply t_ind; intros; destr_locs; simpl in *; intuition;
intuition; try destruct t'; try destruct ls'; try destruct s; destr_locs; destr_pairs;
simpl in *; intuition; auto with *;
repeat rewrite in_app_iff in *; intuition; destr_pairs; subst;
fold is_renaming_list_S wf_list_S φlist_S in *;
(* apply induction hypothesis *)
repeat match goal with
| [Hind: forall _, _ -> _ -> In ?l (?f ?a _) <-> _, H: In ?l (?f ?a _) |- _] =>
  apply Hind in H; auto; clear Hind end;
repeat match goal with [H: exists _, _ |- _] =>
  let v1 := fresh v1 in let v2 := fresh v2 in destruct H as (v1&v2&Heq) end; intuition;
try solve [eexists; eexists; intuition; eauto];
try solve[left; eauto]; try solve[right; eauto]; try solve[apply IHv; eauto];
try solve[right; left; eauto]; try solve[right; right; eauto];
try fold (value_identifier_S (v2, l)) in *;
try fold (value_identifier_S (v1, l)) in *;
try case val_eq_dec in *; simpl in *; intuition; subst; destr_pairs; subst;
(* impossible cases *)
try solve [repeat ((match goal with
  |[H: value_identifier_t _ _|- _] => apply value_identifier_locs_t in H
  |[H: value_identifier_S _ _|- _] => apply value_identifier_locs_t in H
  | [H: disj ?a ?b|- _] => let H1 := fresh H in let H2 := fresh H in
                            assert(H1 := H l); assert(H2 := disj_sym H l); clear H
  | [H: disj ?a ?b|- _] => let H1 := fresh H in let H2 := fresh H in
                            assert(H1 := H v0l); assert(H2 := disj_sym H v0l); clear H
  | [H: is_renaming_t ?a ?b |- _] => apply renaming_locs_t in H; rewrite H in *
  | [H: is_renaming_list_S ?a ?b |- _] => apply renaming_locs_t in H; rewrite H in *
 end)); simpl in *; tauto];
try match goal with [H: In _ nil |- _] => inversion H end;
try solve[apply H; eauto];
fold is_renaming_list_S wf_list_S φlist_S in *;
try solve[eexists; eexists; intuition; eauto];
try solve [right; apply H; eauto]; try solve [left; apply H0; eauto].
- left; apply H; eauto.
- right; apply H0; eauto.
Qed.

Lemma footprint_vid_m l:
  (forall m m', wf_m m -> is_renaming_m m m' ->
    In l (φm m m') <->
    exists v0 v1, value_identifier_m (v0, l) m /\
                  value_identifier_m (v1, l) m' /\
                  v0 <> v1) *
  (forall ls ls', wf_list_s ls -> is_renaming_list_s ls ls' ->
    In l (φlist_s ls ls') <->
    exists v0 v1, value_identifier_s (v0, l) ls /\
                  value_identifier_s (v1, l) ls' /\
                  v0 <> v1).
Proof.
apply m_ind; intros; destr_locs; simpl in *; intuition;
intuition; try destruct m'; try destruct ls'; try destruct s; destr_locs; destr_pairs;
simpl in *; intuition; auto with *;
repeat rewrite in_app_iff in *; intuition; destr_pairs; subst;
try case val_eq_dec in *; simpl in *; intuition; subst; destr_pairs; subst;
fold is_renaming_list_s wf_list_s φlist_s in *;
(* apply induction hypothesis *)
repeat match goal with
| [H: In _ (φv _ _) |- _] => apply footprint_vid_v in H; auto
| [H: In _ (φt _ _) |- _] => apply footprint_vid_t in H; auto
| [Hind: forall _, _ -> _ -> In ?l (?f ?a _) <-> _, H: In ?l (?f ?a _) |- _] =>
  apply Hind in H; auto; clear Hind end;
repeat match goal with [H: exists _, _ |- _] =>
  let v1 := fresh v1 in let v2 := fresh v2 in destruct H as (v1&v2&Heq) end; intuition;
destr_pairs; subst;
try solve [eexists; eexists; intuition; eauto];
try solve[left; eauto]; try solve[right; eauto]; try solve[apply IHv; eauto];
try solve[right; left; eauto]; try solve[right; right; eauto];
try fold (value_identifier_S (v2, l)) in *;
try fold (value_identifier_S (v1, l)) in *;
(* impossible cases *)
try solve [repeat match goal with
  |[H: value_identifier_v _ _|- _] => apply value_identifier_locs_v in H
  |[H: value_identifier_t _ _|- _] => apply value_identifier_locs_t in H
  |[H: value_identifier_m _ _|- _] => apply value_identifier_locs_m in H
  |[H: value_identifier_s _ _|- _] => apply value_identifier_locs_m in H
  | [H: disj ?a ?b|- _] => let H1 := fresh H in let H2 := fresh H in
                            assert(H1 := H l); assert(H2 := disj_sym H l); clear H
  | [H: disj ?a ?b|- _] => let H1 := fresh H in let H2 := fresh H in
                            assert(H1 := H v0l); assert(H2 := disj_sym H v0l); clear H
  | [H: disj ?a ?b|- _] => let H1 := fresh H in let H2 := fresh H in
                            assert(H1 := H v1l); assert(H2 := disj_sym H v1l); clear H
  | [H: is_renaming_m ?a ?b |- _] => apply renaming_locs_m in H; rewrite H in *
  | [H: is_renaming_t ?a ?b |- _] => apply renaming_locs_t in H; rewrite H in *
  | [H: is_renaming_v ?a ?b |- _] => apply renaming_locs_v in H; rewrite H in *
  | [H: is_renaming_list_s ?a ?b |- _] => apply renaming_locs_m in H; rewrite H in *
 end; simpl in *; tauto];
try match goal with [H: In _ nil |- _] => inversion H end;
try solve[apply H; eauto];
fold is_renaming_list_s wf_list_s φlist_s in *;
try solve[eexists; eexists; intuition; eauto];
try solve [right; apply H; eauto]; try solve [left; apply H0; eauto];
try solve [right; apply H0; eauto]; try solve [left; apply H; eauto];
try solve[left; apply footprint_vid_v; eauto];
try solve[left; apply footprint_vid_t; eauto].
- left; right; apply footprint_vid_v; eauto.
Qed.
(* end hide *)

Lemma footprint_vid l P P':
  wf P -> is_renaming P P' ->
  In l (φ P P') <->
  exists v0 v1, value_identifier (v0, l) P /\
                value_identifier (v1, l) P' /\
                v0 <> v1.
Proof.
revert P'; induction P; intro P'; intros; simpl in *; destruct P';
repeat rewrite in_app_iff; try tauto.
- now apply footprint_vid_v.
- destr_locs; simpl in *; intuition; destr_pairs; subst.
  + match goal with | [H: In _ (φm _ _) |- _] =>
      apply footprint_vid_m in H; auto; destruct H as (v1&v2&H) end.
    eexists; eexists; intuition; eauto.
  + match goal with | [H: In _ (φ _ _) |- _] =>
      apply IHP in H; auto; destruct H as (v1&v2&H) end.
    eexists; eexists; intuition; eauto.
  + match goal with [H: exists _, _ |- _] => let v1 := fresh v1 in let v2 := fresh v2 in
     destruct H as (v1&v2&Heq) end; intuition;
     try solve[repeat match goal with
      |[H: value_identifier_m _ _|- _] => apply value_identifier_locs_m in H
      |[H: value_identifier _ _|- _] => apply value_identifier_locs in H
       | [H: disj ?a ?b|- _] => let H1 := fresh H in let H2 := fresh H in
                                assert(H1 := H l); assert(H2 := disj_sym H l); clear H
      | [H: is_renaming_m ?a ?b |- _] => apply renaming_locs_m in H; rewrite H in *
      | [H: is_renaming ?a ?b |- _] => apply renaming_locs in H; rewrite H in *
      end; simpl in *; tauto].
    * left; apply footprint_vid_m; eauto.
    * right; apply IHP; eauto.
Qed.

(** Semantic characterisation of footprints:
  the footprint of a renaming is the set of locations which are reified to different values *)
Lemma footprint_prop P l P' Σ' Γ' ΣP ΣP' Σ0 Γ0:
  wb_env Γ0 Σ0 -> wf P -> Γ0 ⊓ locs P -> Σ0 ⊔ locs P ->
  Σ0 ≡ Σ₀ -> Γ0 ≖ Γ₀ ->
  Σ0 / Γ0 ⊢ P ⇝ ΣP ->
  Σ' / Γ' ⊢ P' ⇝ ΣP' ->
  wb_env Γ' Σ' -> wf P' -> Γ' ⊓ locs P' -> Σ' ⊔ locs P' ->
  Σ' ≡ Σ₀ -> ΣP ≡ ΣP' -> Γ' ≖ Γ₀ ->
  is_renaming P P' ->
    (In l (φ P P') <-> ρ ΣP l <> ρ ΣP' l).
Proof.
intros; split.
- intro Hl.
  apply footprint_vid in Hl; auto. destruct Hl as (v0&v1&Hv0&Hv1&Hneq).
  eapply deterministic_semantics with (Σ := Σ0) (Γ := Γ0) (Σ' := ΣP) in Hv0; auto;
  [|eapply sem_eq_sr'; [symmetry; eauto | apply Σ₀_sr] ].
  eapply deterministic_semantics with (Σ := Σ') (Γ := Γ') (Σ' := ΣP') in Hv1; auto.
  + rewrite Hv0, Hv1. intro HF; inversion HF. subst; tauto.
  + apply sem_eq_sr' with (Σ := Σ₀); auto. now symmetry.
- intro Hneq. apply footprint_vid; auto.
  case_eq (ρ ΣP l); [intros v Hv; destruct v as [m|t|v]| intro Hv];
  assert(Hv' := Hv); eapply sem_eq_sr' in Hv'; eauto; try rewrite Hv, Hv' in Hneq; try tauto.
  destruct Hv' as (v'&Hv').
  exists v; exists v'. nsplit 2.
  + eapply deterministic_semantics with (Σ := Σ0) (Σ' := ΣP); eauto.
    eapply sem_eq_sr'; [symmetry; eauto | apply Σ₀_sr].
  + eapply deterministic_semantics with (Σ := Σ') (Σ' := ΣP'); eauto.
    apply sem_eq_sr' with (Σ := Σ₀); auto. now symmetry.
  + rewrite Hv, Hv' in Hneq. intro HF; apply Hneq; now subst.
Qed.

(** footprints are stable by binding resolution *)
Lemma footprint_br_closure P P' l l' (Hv: valid P P') ΣP:
  ΣP = projT1 Hv ->
  is_renaming P P' ->
  ↣ ΣP l = Some (Some l') ->
  In l' (φ P P') <->  In l (φ P P').
Proof.
intro; subst ΣP.
assert(Hv' := Hv). destruct Hv as ((ΣP&HP&Hc)&Σ0'&Γ'&(ΣP'&HP'&Hc')&Heq0&H&Hequiv).
intros Hv Hb. simpl in *.
erewrite footprint_prop with (ΣP := ΣP) (ΣP' := ΣP'); eauto; try tauto.
assert(Hp: proper ΣP) by (eapply deterministic_semantics; eauto; try tauto).
apply Σ₀_eq in Heq0.
assert(Hp': proper ΣP') by
 (eapply deterministic_semantics in HP'; eauto; try tauto;
  apply HP'; eapply sem_equal_proper; [symmetry; exact Heq0|auto]).
assert(Hb' : ↣ ΣP' l = Some (Some l')) by (erewrite <- sem_eq_br; eauto).
apply Hp in Hb. apply Hp' in Hb'.
erewrite footprint_prop; eauto; try tauto. now rewrite Hb, Hb'.
Qed.

(** "Proposition 5": the footprint is the closure by binding resolution of dependencies, and some unresolved references *)
Proposition conjecture1 P P' (Hv: valid P P') ΣP:
  ΣP = projT1 Hv ->
  is_renaming P P' ->
  let L l := (δ P P' l  \/ exists l', δ P P' l' /\ ↣ ΣP l = Some (Some l')) in
  (forall l, L l -> In l (φ P P')) /\
  (forall l, ~ L l -> In l (φ P P') ->  ↣ ΣP l = Some None).
Proof.
intros Heq Hr L; subst L. split.
- intros l [Hd|(l'&Hd'&Hl)].
  + apply Hd. (* dependencies are in the footprint *)
  + eapply footprint_br_closure in Hl; eauto. (* φ is closed by binding resolution *)
    rewrite <- Hl. apply Hd'.
- intros l HL Hl. assert(HP : proper ΣP) by apply sem_proper. case_eq (↣ ΣP l).
  + intros [l'|] Heql; trivial.
    contradict HL. right. exists l'. split; trivial. split.
    * eapply footprint_br_closure; eauto.
    * (* being in the codomain implies being a declaration *)
      destruct ΣP as (ΣP&HP'&Hc). simpl in *. clear Heq.
      apply deterministic_semantics in HP'; eauto; try tauto.
      destruct HP' as (_&_&_&_&HP'&_). destruct (HP' l') as (_&Hl').
      destruct Hl' as [Hl'|Hl']; [eapply br_cod; eauto| |]; trivial.
      contradict (cod_Σ₀ Hl').
  + intro Hnone. contradict HL. left. split; trivial.
    destruct Hv as ((ΣP'&HP'&Hc)&Σ0'&Γ'&(ΣP''&HP''&Hc')&Heq0&H&Hequiv).
    simpl in *. subst ΣP. simpl in *.
    apply deterministic_semantics in HP'; eauto; try tauto.
    apply footprint_vid in Hl; auto; try tauto. destruct Hl as (v&v'&Hv&Hv'&Hneq).
    assert(Hl : cod ΣP' l) by (exists v; split; trivial; apply HP'; auto).
    apply HP' in Hl. destruct Hl as [|Hl]; trivial. contradict (cod_Σ₀ Hl).
Qed.

(* begin hide *)
Lemma conjecture2' P P' l l' (Hv: valid P P') ΣP:
  ΣP = projT1 Hv ->
  is_renaming P P' ->
    In (l, l') (E ΣP) -> (In l (φ P P') <-> In l' (φ P P')).
Proof.
intro. subst ΣP.
destruct Hv as ((ΣP&HP&Hc)&Σ0'&Γ'&(ΣP'&HP'&Hc')&Heq0&H&Hequiv). simpl in *.
intros Hr HE.
assert(HE' : In (l, l') (E ΣP')) by (now rewrite <- (proj1 (proj2 Hequiv))).
assert(Hp: proper ΣP) by (eapply deterministic_semantics; eauto; try tauto).
apply Σ₀_eq in Heq0.
assert(Hp': proper ΣP') by
 (eapply deterministic_semantics in HP'; eauto; try tauto;
  apply HP'; eapply sem_equal_proper; [symmetry; exact Heq0|auto]).
apply Hp in HE. destruct HE as (_&_&v&H1&H2).
apply Hp' in HE'. destruct HE' as (_&_&v'&H1'&H2').
do 2 (erewrite footprint_prop; eauto; try tauto).
rewrite H1, H2, H1', H2'. tauto.
Qed.
(* end hide *)

(** "Proposition 6": footprints are stable by extension kernel *)
Proposition conjecture2 P P' l l' (Hv: valid P P') ΣP:
  ΣP = projT1 Hv ->
  is_renaming P P' ->
  Ê ΣP l l' -> (In l (φ P P') <-> In l' (φ P P')).
Proof.
intro; subst ΣP.
destruct Hv as (ΣP&Hv). intros Hr HE.
induction HE; [tauto|].
rewrite <- IHHE. destruct H as [H|H]; [|symmetry];
eapply conjecture2'; eauto.
Qed.

(** "Proposition 7": related locations stay in the footprint *)
Proposition conjecture3 P P' lx (Hv: valid P P') l ΣP:
  ΣP = projT1 Hv ->
  is_renaming P P' ->
  In lx (φ P P') ->
  (Ê ΣP lx l \/ (exists l', Ê ΣP lx l' /\ ↣ ΣP l = Some (Some l'))) ->
    In l (φ P P').
Proof.
intros Heq Hr Hlx [HE|(l'&HE&Hl')].
- eapply conjecture2; eauto.
  now apply Operators_Properties.clos_rst1n_sym.
- eapply conjecture2 in HE; eauto.
  eapply footprint_br_closure in Hl'; try eassumption.
  intuition.
Qed.

(** * Factorisation *)

(** The footprint of the default renaming function is the set L used to define it *)
Lemma rename_footprint P (ΣP : 〚 P 〛 Σ₀; Γ₀) vx lx l:
  In lx (decl P) ->
  ~ value_identifier' vx P ->
    In l (φ P (rename ΣP vx lx P)) <-> L ΣP lx l.
Proof.
intros Hlx Hvx.
assert(Hcod: cod ΣP lx) by
  (destruct ΣP as (Σ & H1 & Hc1); simpl in *;
   eapply deterministic_semantics; eauto; intuition).
assert(Hvx': forall l : ℒ, ρ ΣP l <> Some (IV vx)).
{
  intros l' Hl'. apply Hvx. exists l'.
  destruct ΣP as (Σf' & H1 & Hc1); simpl in *; subst;
  eapply deterministic_semantics; eauto. intuition.
}
destruct(L3 ΣP lx Hlx Hvx) as (ΣP'& HP'& Heq).
erewrite footprint_prop with (ΣP := ΣP) (ΣP' := ΣP'); try eassumption; auto;
try (destruct ΣP; simpl in *; tauto); eauto with *.
- rewrite (sem_equal_sr Heq). split.
  + intro. eapply Σr_v_L; eauto.
  + intro HL. erewrite (Σr_vy_vx vx Hcod); auto. apply L_values; auto.
- apply rename_wf. destruct ΣP. simpl in *. tauto.
- apply Σr_disj. auto.
- apply sem_equal_eq, Σr_Σ₀.
- symmetry. transitivity (Σr ΣP vx lx ΣP); eauto. apply Σr_eq; auto.
- apply is_renaming_rename.
Qed.


(** "Proposition 9": non-trivial renamings can be factorised into smaller renamings *)
Proposition factorisation P P' (Hv: valid P P') l l' vx:
  let (ΣP, Hv) := Hv in let (Σ0, Hv) := Hv in
  let (Γ0, Hv) := Hv in let (ΣP', Hv) := Hv in
  is_renaming P P' ->
  δ P P' l -> δ P P' l' ->
  (~ Ê ΣP l l') ->
  (ρ ΣP' l = Some (IV vx) /\ ~ value_identifier' vx P) ->
  {P'' & valid P P'' ∧ valid P'' P' ∧ (
     is_renaming P P'' /\ is_renaming P'' P' /\
     (incl (φ P P'') (φ P P') /\ ~ In l' (φ P P'') /\
      incl (φ P'' P') (φ P P') /\ ~ In l (φ P'' P')))}.
Proof.
assert(Hv' := Hv).
destruct Hv as (ΣP&(Σ0&Γ0&ΣP'&Heq)).
intros Hr (Hl&Hdl) (Hl'&Hdl') HE (Hx1&Hx2).
pose (P'' := rename (projT1 ΣP) vx l P).
exists P''.
assert (Hv : valid P P'') by (eapply P5; eauto; reflexivity).
assert (Hr' : is_renaming P P'') by (apply is_renaming_rename).
assert(Hr'': is_renaming P'' P') by
  (apply is_renaming_trans with P; trivial; apply is_renaming_sym; trivial).
nsplit 7; trivial.
- apply valid_trans with P; trivial.
  apply valid_sym; trivial.
- intros l0 Hl0.
  eapply conjecture3 with (lx := l) (Hv := existT _ ΣP _); eauto; simpl.
  eapply rename_footprint; eauto. Unshelve. simpl. eauto.
- intro HF.
  subst P''. eapply rename_footprint in HF; eauto.
  destruct HF as [HE'|(l1&HE'&Hl1)]; [tauto|].
  assert(Hcod: cod ΣP' l').
  {
    destruct ΣP' as (ΣP'&H'). simpl in *.
    eapply deterministic_semantics with (P := P') (Σ := Σ0) (Γ := Γ0); eauto; try tauto.
    erewrite renaming_decl; eauto; now apply is_renaming_sym.
  }
  destruct Hcod as (_&_&Hcod).
  erewrite sem_eq_br with (s2 := ΣP) in Hcod by (eauto; now symmetry) .
  simpl in *. destruct ΣP as (ΣP&HH). simpl in *.
  rewrite Hcod in Hl1. discriminate Hl1.
- eapply incl_tran;[apply renaming_φtrans; [apply is_renaming_sym; eassumption|trivial] |].
  intros l0. rewrite in_app_iff. intros [Hl0|Hl0]; trivial.
  eapply conjecture3 with (lx := l) (Hv := existT _ ΣP _); eauto; simpl.
  eapply rename_footprint; eauto. rewrite footprint_sym in Hl0; auto.
  now apply is_renaming_sym.
  Unshelve. simpl; eauto.
- intro HF.
  assert(Hcod : cod ΣP l).
  {
    destruct ΣP as (ΣP&HP&Hc). simpl in *.
    eapply deterministic_semantics; eauto; try tauto.
  }
  assert(Hp: proper ΣP) by apply sem_proper.
  assert(Hvx : forall l0 : ℒ, ρ ΣP l0 <> Some (IV vx)).
  {
    intros l0 Hl0. apply Hx2. exists l0.
    destruct ΣP as (ΣP&HP&Hc); simpl in *; subst;
    eapply deterministic_semantics; eauto. tauto.
  }
  assert(GG := P9 Hcod Hp Hvx ΣP (wb_env_Γ₀ _)).
  assert(Hdom: forall l0 : ℒ, In l0 (ve_locs P) -> ~ dom_rel (E ΣP) l0).
  {
    intros l0 Hl0 Hl0'.
    destruct ΣP as (ΣP&HP&Hc); simpl in *.
    eapply deterministic_semantics in HP; eauto; [|intuition].
    apply HP in Hl0';[|apply dom_rel₀].
    destruct Hl0' as [Hl0'|Hl0'].
    + eapply disj_ve_val_locs; eauto. intuition.
    + destruct Hl0' as [(x&Hl0')|(x&Hl0')]; inversion Hl0'.
  }
  destruct GG as (ΣP''&HP''&Heq''); auto.
  destruct ΣP' as (ΣP'&HP'&Hc''). simpl in *.
  eapply footprint_prop in HF; try apply HP''; try apply HP'; try tauto; auto.
  + apply HF. clear HF. simpl in *. rewrite Hx1.
    erewrite sem_equal_sr; [|exact Heq''].
    eapply Σr_vy_vx with Hcod; [| apply L_lx].
    apply L_values; trivial. apply L_lx.
  + destruct Hv as ((ΣP1&HP&Hc)&Σ0'&Γ'&(ΣP1'&HP0'&Hc')&Heq0&H0'&Hequiv).
    simpl in *. tauto.
  + apply Γr_disj; auto. apply Γ₀_disj.
  + apply Σr_disj, Σ₀_disj.
  + apply Σr_eq; auto.
  + transitivity (Σr ΣP vx l ΣP); auto.
    transitivity ΣP; [|now symmetry]. now apply Σr_eq.
Qed.

End Characterising.