      module test_xeon_phi_sample_mod
      use xeon_phi_sample_def
      use xeon_phi_sample_lib
      
      implicit none

      contains

      subroutine do_test
         integer :: foo, g
         integer, parameter :: sz = 3000
         integer, target :: a_target(sz)
         integer, pointer :: a(:)
         real, pointer :: p(:)
         integer :: i, knt=1, n, iters, k0, lo, hi, &
            NS, NE, sig1, mx1, mx2, ierr, val1, val2, foo2
         character (len=100) :: fname
         
         n=sz
         iters=5
         
         call do_init_xeon_phi_sample_def
         
         if (.true.) then
         
            ! allocate on host
            call alloc_phi_sample_p(n,ierr)
            if (ierr /= 0) then
               write(*,*) 'failed in allocate on host'
               stop 1
            end if
            
            ! allocate on target
            !dir$ offload target(mic:0) in(n) out(ierr)
            call alloc_phi_sample_p(n,ierr)
            if (ierr /= 0) then
               write(*,*) 'failed in allocate on target'
               stop 1
            end if
           
            ! set the host data
            do i=1,n
               phi_sample_p(i) = dble(i)
            end do
            
            ! copy to target
            p(1:n) => phi_sample_p(1:n)
            !dir$ offload target(mic:0) in(p)
            call in_phi_sample_p(p,1)
            
            ! change the host data
            phi_sample_p(1:n) = 0d0
            
            ! copy back from target
            !dir$ offload target(mic:0) out(p)
            call out_phi_sample_p(p,1)
            
            ! check that host data has been changed back to initial values
            do i=1,n
               if (phi_sample_p(i) /= dble(i)) then
                  write(*,*) 'bad value for phi_sample_p(i)', i, phi_sample_p(i)
                  stop 1
               end if
            end do
            
            ! zero on target
            !dir$ offload target(mic:0) in(n)
            call zero_phi_sample_p(1,n)
            
            ! change the host data
            phi_sample_p(1:n) = 1d0

            lo = 10; hi = 30
            ! partial copy back from target
            p(1:1+hi-lo) => phi_sample_p(lo:hi)
            !dir$ offload target(mic:0) in(lo) out(p)
            call out_phi_sample_p(p,lo)
            
            ! check that phi_sample_p(lo:hi) has been reset to 0's while rest is still 1's
            do i=1,n
               if (i >= lo .and. i <= hi) then
                  if (phi_sample_p(i) /= 0d0) then
                     write(*,*) '1. bad value for phi_sample_p(i)', i, phi_sample_p(i)
                     stop 1
                  end if
               else
                  if (phi_sample_p(i) /= 1d0) then
                     write(*,*) '2. bad value for phi_sample_p(i)', i, phi_sample_p(i)
                     stop 1
                  end if
               end if
            end do
            
            ! change the host data
            phi_sample_p(1:n) = 2d0
            
            ! partial copy to target
            p(1:1+hi-lo) => phi_sample_p(lo:hi)
            !dir$ offload target(mic:0) in(p,lo)
            call in_phi_sample_p(p,lo)
            
            ! change the host data
            phi_sample_p(1:n) = 0d0

            ! partial copy back from target
            p(1:1+hi-lo) => phi_sample_p(lo:hi)
            !dir$ offload target(mic:0) in(lo) out(p)
            call out_phi_sample_p(p,lo)
            
            ! check that phi_sample_p(lo:hi) has been reset to 2's while rest is still 0's
            do i=1,n
               if (i >= lo .and. i <= hi) then
                  if (phi_sample_p(i) /= 2d0) then
                     write(*,*) '3. bad value for phi_sample_p(i)', i, phi_sample_p(i)
                     stop 1
                  end if
               else
                  if (phi_sample_p(i) /= 0d0) then
                     write(*,*) '4. bad value for phi_sample_p(i)', i, phi_sample_p(i)
                     stop 1
                  end if
               end if
            end do

            ! deallocate on host
            call dealloc_phi_sample_p()

            ! deallocate on target
            !dir$ offload target(mic:0)
            call dealloc_phi_sample_p()

         end if
         
         
         
         
         if (.false.) then
            foo2 = eval_foo2()
            write(*,*) 'host foo2', foo2
            !dir$ offload target(mic:0)
            foo2 = eval_foo2()
            write(*,*) 'mic foo2', foo2
         end if
         
         
         if (.false.) then
            ! CPU globals can be accessed directly.  MIC globals cannot.
         
            write(*,*)
            write(*,*) 'host xeon_phi_sample_global', xeon_phi_sample_global
            call init_xeon_phi_sample
            write(*,*) 'host xeon_phi_sample_global', xeon_phi_sample_global
            write(*,*)
            !dir$ offload target(mic:0)
            g = eval_global()
            write(*,*) 'phi xeon_phi_sample_global', g
            !dir$ offload begin target(mic:0)
            call init_xeon_phi_sample
            g = eval_global()
            !dir$ end offload
            write(*,*) 'phi xeon_phi_sample_global', g
            write(*,*)
         
         end if
         
         
         if (.false.) then  ! test file read write 
           
            val1 = 55
            ierr = 0
            !fname = '/home/bpaxton/shared/myfile.txt'
            fname = './proxyfs/myfile.txt'
            
            if (.true.) then
            
               !dir$ offload begin target(mic) nocopy(ierr)
               open(33, FILE='./proxyfs/myfile.txt', IOSTAT=ierr)
               if (ierr /= 0) then
                  write(*,*) 'Failed to open myfile.txt for write'
                  stop 1
               end if
               write(33,*) 55
               close(33)
               !dir$ end offload
            
            else
            
               !dir$ offload target(mic) in(fname,val1) out(ierr)
               call write_file(fname,val1,ierr)
               if (ierr /= 0) then
                  write(*,*) 'write_file on phi failed'
                  stop 1
               end if
            
            end if
            
            val2 = 0
            !dir$ offload target(mic) in(fname) out(val2,ierr)
            call read_file(fname,val2,ierr)
            if (ierr /= 0) then
               write(*,*) 'read_file on phi failed'
               stop 1
            end if
            if (val2 /= val1) then
               write(*,*) 'read_file on phi returned bad value'
               stop 1
            end if
            
            val2 = 0
            call read_file(fname,val2,ierr)
            if (ierr /= 0) then
               write(*,*) 'read_file on host failed'
               stop 1
            end if
            if (val2 /= val1) then
               write(*,*) 'read_file on host returned bad value'
               stop 1
            end if
            write(*,*) 'ok'
            
         end if
         
         
         if (.false.) then         
         
            write(*,*)
            g = eval_max_num_threads()
            write(*,*) 'host eval_max_num_threads', g
            g = -1
            !dir$ offload target(mic:0) out(g)
            g = eval_max_num_threads()
            write(*,*) 'phi eval_max_num_threads', g
            write(*,*)
         
         end if
         
         
         if (.false.) then
         
            ! asynchronous computation on host and mic 
            a => a_target
            do i = 1,N; a(i) = i; end do
            do while (knt <= iters) 
               ! 1st part on MIC
               NS=1; NE=N/2 
               !dir$ offload target(mic:0) signal(sig1) &
                  in(knt,NS,NE) inout(a(1:N/2)) out(mx1)
               call work(knt,NS,NE,a,mx1)
               ! 2nd part on CPU
               NS=NE+1; NE=N 
               call work(knt,NS,NE,a,mx2)
               !dir$ offload_wait target(mic:0) wait(sig1)
               write(*,*) mx1, mx2
               knt=knt+1
            end do
            do i = 1,N 
               if (a(i) /= i+iters) then
                  print*, i, a(i)
                  stop
               end if
            end do 
            write(*,*) 'ok'
         
         end if
         
         
      end subroutine do_test 


      end module test_xeon_phi_sample_mod




      program test_xeon_phi_sample
      use test_xeon_phi_sample_mod
      implicit none
      call do_test
      !call _Offload_report(3)      ! http://software.intel.com/en-us/node/463218
      end program
