      module test_mod
      implicit none
      
      integer, parameter :: dp = selected_real_kind(p=15)
      
      !dir$ attributes offload : mic :: p1
      real(dp), pointer, dimension(:) :: p1
      
      !dir$ attributes offload : mic :: p2
      real(dp), pointer, dimension(:) :: p2
      
      contains
      
      subroutine do_test
         real(dp), pointer :: p_host(:)

         ! this fails in do_dealloc_p1 on target
         
         call do_alloc_p1
         p_host => p1
         nullify(p2)         
         
         write(*,*) 'on target'
         !dir$ offload begin target(mic:0)
         call do_alloc_p1
         call do_alloc_p2
         !dir$ end offload
         
         if (.true.) then ! this leads to later SIGSEGV in do_dealloc_p1
            !dir$ offload target(mic:0) in(p1)
            call do_associated_p(p1)
         else ! this doesn't lead to failure although p_host => p1
            !dir$ offload target(mic:0) in(p_host)
            call do_associated_p(p_host)
         end if
         
         !dir$ offload begin target(mic:0)
         call do_associated_p1
         call do_associated_p2
         
         call do_dealloc_p2         
         call do_associated_p1
         call do_associated_p2

         call do_dealloc_p1
         call do_associated_p1
         call do_associated_p2
         
         write(*,*) 'done with offload'
         flush(6)
         !dir$ end offload
         
         write(*,*) 'back on host'
         call do_associated_p(p1)
         call do_associated_p(p2)
         
      end subroutine do_test
      
      !dir$ attributes offload : mic :: do_alloc_p1
      subroutine do_alloc_p1
         write(*,*) 'do_alloc_p1 -- allocate(p1(100))'
         flush(6)
         allocate(p1(100))
      end subroutine do_alloc_p1
      
      !dir$ attributes offload : mic :: do_dealloc_p1
      subroutine do_dealloc_p1
         if (.not. associated(p1)) then
            write(*,*) 'do_dealloc_p1 -- .not. associated(p1)'
            flush(6)
            return
         end if
         write(*,*) 'do_dealloc_p1 -- associated(p1)', associated(p1)
         flush(6)
         write(*,*) 'do_dealloc_p1 -- deallocate p1'
         flush(6)
         deallocate(p1)
         write(*,*) 'do_dealloc_p1 -- nullify p1'
         flush(6)
         nullify(p1)
         write(*,*) 'done do_dealloc_p1'
         flush(6)
      end subroutine do_dealloc_p1
      
      !dir$ attributes offload : mic :: do_associated_p1
      subroutine do_associated_p1
         write(*,*) 'do_associated_p1'
         flush(6)
         write(*,*) 'associated(p1)', associated(p1)
         flush(6)
      end subroutine do_associated_p1
      
      !dir$ attributes offload : mic :: do_alloc_p2
      subroutine do_alloc_p2
         write(*,*) 'do_alloc_p2 -- allocate(p2(100))'
         flush(6)
         allocate(p2(100))
      end subroutine do_alloc_p2
      
      !dir$ attributes offload : mic :: do_dealloc_p2
      subroutine do_dealloc_p2
         if (.not. associated(p2)) then
            write(*,*) 'do_dealloc_p2 -- .not. associated(p2)'
            flush(6)
            return
         end if
         write(*,*) 'do_dealloc_p2 -- deallocate and nullify p2'
         flush(6)
         deallocate(p2)
         nullify(p2)
         write(*,*) 'done do_dealloc_p2'
         flush(6)
      end subroutine do_dealloc_p2
      
      !dir$ attributes offload : mic :: do_associated_p2
      subroutine do_associated_p2
         write(*,*) 'do_associated_p2'
         flush(6)
         write(*,*) 'associated(p2)', associated(p2)
         flush(6)
      end subroutine do_associated_p2
      
      !dir$ attributes offload : mic :: do_associated_p
      subroutine do_associated_p(p)
         real(dp), pointer, intent(in) :: p(:)
         write(*,*) 'do_associated_p'
         flush(6)
         write(*,*) 'associated(p)', associated(p)
         flush(6)
      end subroutine do_associated_p
      
      end module test_mod



      program test
      use test_mod, only: do_test
      implicit none
      
      call do_test
      write(*,*) 'done do_test'

      end program
