
      module xeon_phi_sample_lib
      
      implicit none


      contains
      
#ifdef offload
      !dir$ options /offload_attribute_target=mic
#endif
      
      subroutine write_file(fname,val,ierr)
         use xeon_phi_sample, only: do_write_file
         character (len=*), intent(in) :: fname
         integer, intent(in) :: val
         integer, intent(out) :: ierr
         call do_write_file(fname,val,ierr)
      end subroutine write_file
      
      
      subroutine read_file(fname,val,ierr)
         use xeon_phi_sample, only: do_read_file
         character (len=*), intent(in) :: fname
         integer, intent(out) :: val, ierr
         call do_read_file(fname,val,ierr)
      end subroutine read_file
      
      
      subroutine init_xeon_phi_sample
         use xeon_phi_sample_def, only: do_init_xeon_phi_sample_def
         call do_init_xeon_phi_sample_def
      end subroutine init_xeon_phi_sample


      integer function eval_foo()
         use xeon_phi_sample, only: foo
         eval_foo = foo()
      end function eval_foo


      integer function eval_foo2()
         use xeon_phi_sample, only: foo2
         eval_foo2 = foo2()
      end function eval_foo2


      integer function eval_global()
         use xeon_phi_sample_def, only: xeon_phi_sample_global
         eval_global = xeon_phi_sample_global
      end function eval_global


      integer function eval_max_num_threads()
         use omp_lib, only: OMP_GET_MAX_THREADS
         eval_max_num_threads = OMP_GET_MAX_THREADS()
      end function eval_max_num_threads


      subroutine work(knt, ns, ne, a, mx) 
         use xeon_phi_sample, only: do_work
         integer, intent(in) :: knt, ns, ne
         integer, pointer, intent(inout) :: a(:)
         integer, intent(out) :: mx
         call do_work(knt, ns, ne, a, mx) 
      end subroutine work

#ifdef offload
      !dir$ end options
#endif

      end module xeon_phi_sample_lib

