
      module xeon_phi_sample_def
      
      implicit none

#ifdef offload
      !dir$ options /offload_attribute_target=mic
#endif
            
      integer :: xeon_phi_sample_global
      
      real, pointer :: phi_sample_p(:)
      
      contains
      
      subroutine do_init_xeon_phi_sample_def()
         xeon_phi_sample_global = 1
         nullify(phi_sample_p)
      end subroutine do_init_xeon_phi_sample_def
      
      subroutine alloc_phi_sample_p(sz,ierr)
         integer, intent(in) :: sz
         integer, intent(out) :: ierr
         allocate(phi_sample_p(sz),stat=ierr)
      end subroutine alloc_phi_sample_p
      
      subroutine dealloc_phi_sample_p()
         if (.not. associated(phi_sample_p)) return
         deallocate(phi_sample_p)
         nullify(phi_sample_p)
      end subroutine dealloc_phi_sample_p
      
      subroutine zero_phi_sample_p(lo,hi)
         integer, intent(in) :: lo,hi
         phi_sample_p(lo:hi) = 0
      end subroutine zero_phi_sample_p
      
      subroutine in_phi_sample_p(p,k0)
         real, pointer, intent(in) :: p(:)
         integer, intent(in) :: k0
         integer :: k, n
         n = size(p,dim=1)
         do k=1,n
            phi_sample_p(k+k0-1) = p(k)
         end do
      end subroutine in_phi_sample_p
      
      subroutine out_phi_sample_p(p,k0)
         real, pointer, intent(out) :: p(:)
         integer, intent(in) :: k0
         integer :: k, n
         n = size(p,dim=1)
         do k=1,n
            p(k) = phi_sample_p(k+k0-1)
         end do
      end subroutine out_phi_sample_p

#ifdef offload
      !dir$ end options
#endif

      end module xeon_phi_sample_def

