
      module xeon_phi_sample
      
      implicit none
      
      contains

      
#ifdef offload
      !dir$ attributes offload : mic :: test_contained_routines
#endif
      subroutine test_contained_routines
         integer :: i, j
         
         i = 0
         call f1(i)
         
         contains
         
#ifdef offload
         !dir$ attributes offload : mic :: f1
#endif
         subroutine f1(i)
            integer, intent(in) :: i
            j = i+1
         end subroutine f1
      
      end subroutine test_contained_routines
      
      
#ifdef offload
      !dir$ options /offload_attribute_target=mic
#endif
      subroutine do_write_file(fname,val,ierr)
         character (len=*), intent(in) :: fname
         integer, intent(in) :: val
         integer, intent(out) :: ierr
         integer :: f
         ierr = 0
         f = 33
         open(f, FILE=trim(fname), IOSTAT=ierr)
         if (ierr /= 0) then
            write(*,*) 'failed to open for write: ' // trim(fname)
            flush(6)
            return
         end if
         write(f,*) val
         close(f)
      end subroutine do_write_file
      
      
      subroutine do_read_file(fname,val,ierr)
         character (len=*), intent(in) :: fname
         integer, intent(out) :: val, ierr
         integer :: f
         ierr = 0
         f = 33
         open(f, FILE=trim(fname), STATUS='OLD', IOSTAT=ierr)
         if (ierr /= 0) then
            write(*,*) 'failed to open for read: ' // trim(fname)
            flush(6)
            return
         end if
         read(f,fmt=*,IOSTAT=ierr) val
         if (ierr /= 0) then
            write(*,*) 'read failed for ' // trim(fname)
            flush(6)
         end if
         close(f)
      end subroutine do_read_file
      

      subroutine do_work(knt, ns, ne, a, mx) 
         use omp_lib
         integer, intent(in) :: knt, ns, ne
         integer, pointer, intent(inout) :: a(:)
         integer, intent(out) :: mx
         integer :: i, tn
         mx = -1
         !$omp parallel do private(i,tn)
         do i=ns,ne 
            a(i) = a(i) + 1
            tn = omp_get_thread_num()
            !omp atomic
            mx = max(mx,tn)
         end do 
         !$omp end parallel do
      end subroutine do_work

      integer function foo()
         implicit none
         foo = 1
      end function foo


      integer function foo2()
         implicit none
#ifdef __MIC__
         foo2 = 1 ! Code is running on MIC
#else
         foo2 = 0 ! Code is running on host
#endif
      end function foo2
      
#ifdef offload
      !dir$ end options
#endif
      
      end module xeon_phi_sample

