! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module utils_nan
      use const_def, only: dp, qp
      
      implicit none
      
#ifdef offload
      !dir$ options /offload_attribute_target=mic
#endif

      logical :: init = .false.
      real(dp) :: saved_nan
      

      contains
      
      
      real(dp) function create_nan(x)
         ! call this with a negative number
         real(dp), intent(in) :: x
         if (.not. init) then
            saved_nan = sqrt(x)
            !write(*,1) 'saved_nan', saved_nan
            init = .true.
         end if
         create_nan = saved_nan
      end function create_nan
      
            
      subroutine do_fill_quad_with_NaNs(ptr)
         real(qp) :: ptr(:)
         integer :: sz
         integer :: k1
         real(qp) :: nan
         nan = create_nan(-1d0)
         sz = size(ptr,dim=1)
         do k1=1,sz
            ptr(k1) = nan
         end do
      end subroutine do_fill_quad_with_NaNs
      
            
      subroutine do_fill_with_NaNs(ptr)
         real(dp) :: ptr(:)
         integer :: sz
         integer :: k1
         real(dp) :: nan
         nan = create_nan(-1d0)
         sz = size(ptr,dim=1)
         do k1=1,sz
            ptr(k1) = nan
         end do
      end subroutine do_fill_with_NaNs
      
      
      subroutine do_fill_with_NaNs_2D(ptr)
         real(dp) :: ptr(:,:)
         integer :: sz1,sz2
         integer :: k1,k2
         real(dp) :: nan
         nan = create_nan(-1d0)
         sz1 = size(ptr,dim=1)
         sz2 = size(ptr,dim=2)
         do k2=1,sz2
            do k1=1,sz1
               ptr(k1,k2) = nan
            end do
         end do
      end subroutine do_fill_with_NaNs_2D
      
      
      subroutine do_fill_with_NaNs_3D(ptr)
         real(dp) :: ptr(:,:,:)
         integer :: sz1,sz2,sz3
         integer :: k1,k2,k3
         real(dp) :: nan
         nan = create_nan(-1d0)
         sz1 = size(ptr,dim=1)
         sz2 = size(ptr,dim=2)
         sz3 = size(ptr,dim=3)
         do k3=1,sz3
            do k2=1,sz2
               do k1=1,sz1
                  ptr(k1,k2,k3) = nan
               end do
            end do
         end do
      end subroutine do_fill_with_NaNs_3D
      
      
      subroutine do_fill_with_NaNs_4D(ptr)
         real(dp) :: ptr(:,:,:,:)
         integer :: sz1,sz2,sz3,sz4
         integer :: k1,k2,k3,k4
         real(dp) :: nan
         nan = create_nan(-1d0)
         sz1 = size(ptr,dim=1)
         sz2 = size(ptr,dim=2)
         sz3 = size(ptr,dim=3)
         sz4 = size(ptr,dim=4)
         do k4=1,sz4
            do k3=1,sz3
               do k2=1,sz2
                  do k1=1,sz1
                     ptr(k1,k2,k3,k4) = nan
                  end do
               end do
            end do
         end do
      end subroutine do_fill_with_NaNs_4D

#ifdef offload
      !dir$ end options
#endif
      
      end module utils_nan

