# image_plot.rb

class Image_data

    include Tioga

        attr_accessor :image_Ys, :image_Xs
        attr_accessor :image_data_xlen, :image_data_ylen
        attr_accessor :image_xmin, :image_xmax
        attr_accessor :image_ymin, :image_ymax
        attr_accessor :image_zmin, :image_zmax, :image_data
        attr_accessor :xlabel, :ylabel
    
        def read_image_Xs(data_dir, name, label)
            data = Dvector.read(data_dir + '/' + name)
            @image_Xs = data[0]
            @image_data_xlen = @image_Xs.size
            @image_xmin = @image_Xs.min
            @image_xmax = @image_Xs.max
            @xlabel = label
            return data
        end
    
        def read_image_Ys(data_dir, name, label)
            data = Dvector.read(data_dir + '/' + name)
            @image_Ys = data[0]
            @image_data_ylen = @image_Ys.size
            @image_ymin = @image_Ys.min
            @image_ymax = @image_Ys.max
            @ylabel = label
            return data
        end
        
        def read_image_data(data_dir, name)
            data = Dtable.new(@image_data_xlen, @image_data_ylen)
            data.read(data_dir + '/' + name + '.data')
            return data
        end    
    
    
        def copy_sub_image(source, first_col, last_col, 
                first_row, last_row, xlabel, ylabel, image_Xs, image_Ys)
            # copy from source
            
            #puts "source.image_data_xlen #{source.image_data_xlen}"
            #puts "source.image_data_ylen #{source.image_data_ylen}"
        
            if last_col < 0
                last_col = last_col + source.image_data_xlen
            elsif last_col >= source.image_data_xlen
               last_col = source.image_data_xlen - 1
            end
            first_col = 0 if first_col > last_col
            
            if last_row < 0
                last_row = last_row + source.image_data_ylen
            elsif last_row >= source.image_data_ylen
               last_row = source.image_data_ylen - 1
            end
            first_row = 0 if first_row > last_row

            #puts "first_col #{first_col} last_col #{last_col}"
            #puts "first_row #{first_row} last_row #{last_row}"
        
            num_cols = last_col - first_col + 1
            num_rows = last_row - first_row + 1
            
            #puts "num_cols #{num_cols} num_rows #{num_rows}"
        
            @data = Dtable.new(num_cols,num_rows)
            source_data = source.data
        
            num_rows.times {|i|
                num_cols.times {|j| 
                   @data[i,j] = source_data[i+first_row,j+first_col] } }
        
            @image_data_xlen = num_cols
            @image_data_ylen = num_rows
        
            @image_Xs = Dvector.new(@image_data_xlen) { |i| image_Xs[i+first_col] }
            @image_Ys = Dvector.new(@image_data_ylen) { |i| image_Ys[i+first_row] }

            @image_xmin = @image_Xs.min
            @image_xmax = @image_Xs.max

            @image_ymin = @image_Ys.min
            @image_ymax = @image_Ys.max
        
            @xlabel = xlabel
            @ylabel = ylabel
        
            self
        
        end
    
end # class Image_data


module Image_plot

    include Math
    include Tioga
    include FigureConstants
    
    def color_bar(d, ylabel, levels = nil, color_bar_yshift = nil)
        xmin = 0; xmax = 1; xmid = 0.5
        t.rescale(0.8)
        t.xaxis_type = AXIS_LINE_ONLY
        t.xaxis_loc = BOTTOM
        t.top_edge_type = AXIS_LINE_ONLY
        t.yaxis_loc = t.ylabel_side = RIGHT
        t.yaxis_type = AXIS_WITH_TICKS_AND_NUMERIC_LABELS
        t.left_edge_type = AXIS_WITH_TICKS_ONLY
        #t.ylabel_shift += 0.4
        t.ylabel_shift = color_bar_yshift unless color_bar_yshift == nil
        #puts "color_bar ylabel #{ylabel}"
        #puts "color_bar_yshift #{color_bar_yshift}"
        t.yaxis_major_tick_length *= 0.4
        t.yaxis_minor_tick_length *= 0.5
        if (t.yaxis_numeric_label_angle < -89)
            t.yaxis_numeric_label_justification = LEFT_JUSTIFIED
            t.ylabel_shift = 4.5 if color_bar_yshift == nil
        else
            t.yaxis_numeric_label_justification = CENTERED
        end
        t.yaxis_numeric_label_scale = 1.1
        t.ylabel_scale = 1.5
        t.show_ylabel(ylabel); t.no_ylabel
        t.show_plot('boundaries' => [xmin, xmax, d.image_zmax, d.image_zmin]) do
            t.axial_shading(
                'start_point' => [xmid, d.image_zmin], 'end_point' => [xmid, d.image_zmax], 
                'colormap' => t.mellow_colormap )
            if levels != nil && levels != false
                t.stroke_color = SlateGray
                levels.each { |level| 
                    if level == levels[0] or level == levels[-1]
                        t.line_width = 3
                    else
                        t.line_width = 1.5
                    end
                    t.stroke_line(xmin, level, xmax, level)
                }
            end
        end
    end
    
    def clip_image
    end
    
    def do_contours(contours, contour_data)
        t.stroke_color = SlateGray
        dest_xs = Dvector.new; dest_ys = Dvector.new; gaps = Array.new
        dict = { 'dest_xs' => dest_xs, 
                'dest_ys' => dest_ys, 
                'gaps' => gaps,
                'xs' => d.image_Xs, 
                'ys' => d.image_Ys,
                'data' => contour_data }
        contours.each do |level|
            dict['level'] = level
            num_xs = d.image_Xs.length
            num_ys = d.image_Ys.length
            legit = Dtable.new(num_xs, num_ys)
            num_legit = 0
            num_xs.times do |ix|
              num_ys.times do |iy|
                if contour_data[ix,iy] < -1e-20
                  legit[ix,iy] = 0.0
                else
                  num_legit += 1
                  legit[ix,iy] = 1.0
                end
              end
            end
            dict['legit'] = legit
            #dict['method'] = 'conrec'
            t.make_contour(dict)
            t.append_points_with_gaps_to_path(dest_xs, dest_ys, gaps)
            #t.fill_color = Teal; t.fill_and_stroke
            t.stroke_color = Black; t.line_width = 0.5
            t.stroke
            if true || @write_contour0
                puts "write_contour0"
                f = File.new('contour0.data', 'w')
                dest_xs.length.times { |i| 
                    f.write sprintf("%g %g\n", dest_xs[i], dest_ys[i])
                    }
                f.close
            end
        end
    end
    
    def do_decorations(title)
    end
    
    def do_preplot
    end
    
    def do_image_plot_internal(boundaries, image_dict, contours, contour_data, title)
        t.show_plot('boundaries' => boundaries) {
            t.fill_color = @image_background_fill
            t.fill_frame
            t.context {
               clip_image
               t.show_image(image_dict)
               do_contours(contours, contour_data) unless contours == nil
            }
            #puts "image boundaries #{boundaries[0]} #{boundaries[1]} #{boundaries[2]} #{boundaries[3]}"
            do_decorations(title)
        }
    end
    
    
    def special_yaxis_for_image
    end

    
    def do_image_plot(title, d, zs, image_data, interpolate = true, contours = nil, 
            contour_data = nil, legend_dict = nil)
        special_yaxis_for_image
        t.show_title(title)
        t.show_xlabel(d.xlabel)
        t.show_ylabel(d.ylabel)
        if @reverse_x==true
           xleft = d.image_xmax
           xright = d.image_xmin
        else
           xleft = d.image_xmin
           xright = d.image_xmax
        end
        if @reverse_y==true
            ytop = d.image_ymin
            ybottom = d.image_ymax
        else
            ytop = d.image_ymax
            ybottom = d.image_ymin
        end
        if @image_aspect_ratio != nil
            t.set_aspect_ratio(@image_aspect_ratio)
        end
        do_preplot
        boundaries = [xleft, xright, ytop, ybottom]
        image_dict = Hash.new
        if @reverse_x==true
           image_dict['ll'] = [xright, d.image_ymax]
           image_dict['lr'] = [xleft, d.image_ymax]
           image_dict['ul'] = [xright, d.image_ymin]
        else
           image_dict['ll'] = [xleft, d.image_ymax]
           image_dict['lr'] = [xright, d.image_ymax]
           image_dict['ul'] = [xleft, d.image_ymin]
        end
        
        image_dict['color_space'] = t.mellow_colormap
        image_dict['data'] = image_data
        image_dict['value_mask'] = 255
        image_dict['w'] = d.image_data_xlen
        image_dict['h'] = d.image_data_ylen
        image_dict['interpolate'] = interpolate
        if legend_dict == nil
        then
            do_image_plot_internal(boundaries, image_dict, contours, contour_data, title)
        else
            t.show_plot_with_legend(legend_dict) { 
                do_image_plot_internal(boundaries, image_dict, contours, contour_data, title)
            }
        end
    end
    
    def image_plot(dict)
        data_name = dict['name']
        d = dict['image_data']
        d = dict['data'] if d == nil
        d = dict['d'] if d == nil
        zs = dict['zs']
        z_lower_limit = dict['z_lower']
        z_upper_limit = dict['z_upper']
        z_limits_symmetric = dict['z_limits_symmetric']
        title = dict['title']
        image_background_fill = dict['image_background_fill']
        image_background_fill = White if image_background_fill == nil
        @image_background_fill = image_background_fill
        adjust_limits = dict['adjust_limits']
        contours = dict['contours']
        legend_dict = dict['legend_dict']
        interpolate = dict['interpolate']
        interpolate = true if interpolate == nil
        title = data_name if title == nil
        title = title.tr("_", " ")
        color_bar_title = dict['color_bar_title']
        color_bar_title = title if color_bar_title == nil
        color_bar_contours = dict['color_bar_contours']
        color_bar_contours = contours if color_bar_contours == nil
        color_bar_yshift = dict['color_bar_yshift']
        color_bar_yshift = 2 if color_bar_yshift == nil
        if z_lower_limit != nil
            if adjust_limits
                d.image_zmin = zs.min_gt(z_lower_limit)
            else
                d.image_zmin = z_lower_limit
            end
        else
            d.image_zmin = zs.min
            d.image_zmin = zs.min_gt(-1e90) if d.image_zmin < -1e90
            d.image_zmin = -1e90 if d.image_zmin == nil
        end
        if z_upper_limit != nil
            if adjust_limits
                d.image_zmax = zs.max_lt(z_upper_limit)
            else
                d.image_zmax = z_upper_limit
            end
        else
            d.image_zmax = zs.max
        end
        d.image_zmax = 1+ d.image_zmin if d.image_zmax - d.image_zmin <= 1e-100
        if z_limits_symmetric == true
            if d.image_zmin.abs > d.image_zmax.abs
               zlim = d.image_zmin.abs
            else
               zlim = d.image_zmax.abs
            end
            d.image_zmax = zlim
            d.image_zmin = -zlim
        end
        
        @plot_data = zs
        d.image_data = t.create_image_data(@plot_data,
            'min_value' => d.image_zmin, 'max_value' => d.image_zmax, 'masking' => true)
            
        t.subplot('right_margin' => 0.05) do
            do_image_plot(title, d, zs, d.image_data, interpolate, contours, @plot_data, legend_dict)
            show_params
        end
        t.rescale(0.8)
        t.subplot('left_margin' => 0.97, 'top_margin' => 0.05, 'bottom_margin' => 0.05) do
            color_bar(d, color_bar_title, color_bar_contours, color_bar_yshift)
        end
    end
    
    def show_params
      
    end

end
