# image_log.rb

load "../../../utils/image_plot.rb"
    
class Image_Log_data < Image_data

    attr_accessor :step, :grid, :data
    

    def initialize(log_data_dir=nil, 
            log_data_filename=nil, xlabel=nil, ylabel=nil,
            image_Xs=nil, image_Ys=nil, numcols=0, numrows=0)
        
        return if log_data_dir == nil
        
        if numcols <= 0
            numcols = Dvector.read_row(log_data_dir + '/' + log_data_filename).length
            puts "numcols = #{numcols}"
        end
        
        if numrows <= 0
            numrows = IO.readlines(log_data_dir + '/' + log_data_filename).length
            puts "numrows = #{numrows}"
        end
        
        @data = Dtable.new(numcols,numrows)
        @data.read(log_data_dir + '/' + log_data_filename)
        
        @image_data_xlen = @data.num_cols
        @image_data_ylen = @data.num_rows
        
        if image_Xs == nil
            @image_Xs = Dvector.new(@image_data_xlen) { |i| i+1 }
        else
            @image_Xs = image_Xs
        end
        
        if image_Ys == nil
            @image_Ys = Dvector.new(@image_data_ylen) { |i| i+1 }
        else
            @image_Ys = image_Ys
        end
        
        @image_xmin = @image_Xs.min
        @image_xmax = @image_Xs.max

        @image_ymin = @image_Ys.min
        @image_ymax = @image_Ys.max
        
        @xlabel = xlabel
        @ylabel = ylabel

    end
    

end # class Image_Log_data


class Image_Log_plot

    include Math
    include Tioga
    include FigureConstants
    include Image_plot
        
    
    def initialize(
                log_data_dir, log_data_filename, 
                xlabel, ylabel, 
                first_col, last_col, 
                first_row, last_row,
                image_Xs, image_Ys, z_limits_symmetric = true)
                
        puts "first_col #{first_col}"
        puts "last_col #{last_col}"
        puts "first_row #{first_row}"
        puts "last_row #{last_row}"
               
        @data_dir = log_data_dir
        @figure_maker = FigureMaker.default
        t.def_eval_function { |str| eval(str) }
        t.save_dir = 'plot_out'
        @z_limits_symmetric = z_limits_symmetric

        full_image = Image_Log_data.new(
            log_data_dir, log_data_filename, xlabel, ylabel, image_Xs, image_Ys)
            
        @image_data = Image_Log_data.new.copy_sub_image(
            full_image, first_col, last_col, first_row, last_row, 
            xlabel, ylabel, full_image.image_Xs, full_image.image_Ys)
        
        @label_scale = 0.75
        
        @no_clipping = false        
        
        @reverse_x = true     

        t.def_figure('logfile') { logfile }
        
        t.def_enter_page_function { enter_page }   
         
    end
    
    
    def enter_page
        t.yaxis_numeric_label_angle = -90
        t.page_setup(11*72/2,8.5*72/2)
        t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords  
    end
    
    
    def t
        @figure_maker
    end
    
    
    def d
        @image_data
    end
    
    
    # plot routines
    
    def logfile
        image_plot('d' => d, 'zs' => d.data, 'title' => 'log file', 'z_limits_symmetric' => @z_limits_symmetric)
    end
    
end

