
class StarHistory
    include Tioga    
    
    def add_extras(coupled)
        puts "add extras"
        
        @coupled = coupled
        
        t.def_figure('x_HRs') { x_HRs }
        t.def_figure('x_TRhos') { x_TRhos }
        t.def_figure('x_log_center_T') { x_log_center_T }
        t.def_figure('x_log_center_Rho') { x_log_center_Rho }
        #t.def_figure('x_log_eps_burn_photo') { x_log_eps_burn_photo }
        t.def_figure('x_log_abs_eps_nuc') { x_log_abs_eps_nuc }
        #t.def_figure('x_log_center_P') { x_log_center_P }
        #t.def_figure('x_center_mu') { x_center_mu }
        #t.def_figure('x_center_abar') { x_center_abar }
        #t.def_figure('x_center_zbar') { x_center_zbar }
        t.def_figure('x_center_ye') { x_center_ye }
        t.def_figure('x_center_entropy') { x_center_entropy }
        t.def_figure('x_center_eps_grav') { x_center_eps_grav }
        #t.def_figure('x_sign_eps_nuc') { x_sign_eps_nuc }
        #t.def_figure('x_center_eps_nuc') { x_center_eps_nuc }
        #t.def_figure('x_d_center_eps_nuc_dlnT') { x_d_center_eps_nuc_dlnT }
        #t.def_figure('x_d_center_eps_nuc_dlnd') { x_d_center_eps_nuc_dlnd }
        t.def_figure('x_center_non_nuc_neu') { x_center_non_nuc_neu }
        t.def_figure('x_center_dL_dm') { x_center_dL_dm }

        t.def_figure('x_log_Teff') { x_log_Teff }
        t.def_figure('x_log_L') { x_log_L }
        t.def_figure('x_log_R') { x_log_R }
        t.def_figure('x_log_LH') { x_log_LH }
        t.def_figure('x_log_LHe') { x_log_LHe }
        t.def_figure('x_log_Lnuc') { x_log_Lnuc }
        t.def_figure('x_log_Lneu') { x_log_Lneu }

        t.def_figure('x_he4') { x_he4 }
        t.def_figure('x_o16') { x_o16 }
        t.def_figure('x_ne20') { x_ne20 }
        t.def_figure('x_mg24') { x_mg24 }
        t.def_figure('x_si28') { x_si28 }
        t.def_figure('x_s32') { x_s32 }
        t.def_figure('x_ar36') { x_ar36 }
        t.def_figure('x_ca40') { x_ca40 }
        t.def_figure('x_fe54') { x_fe54 }
        t.def_figure('x_fe56') { x_fe56 }
        t.def_figure('x_ni56') { x_ni56 }
        t.def_figure('x_cr56') { x_cr56 }
      
        t.def_figure('x_c_pp') { x_c_pp }
        t.def_figure('x_c_cno') { x_c_cno }
        t.def_figure('x_c_tri_alfa') { x_c_tri_alfa }
        t.def_figure('x_c_burn_c') { x_c_burn_c }
        t.def_figure('x_c_burn_n') { x_c_burn_n }
        t.def_figure('x_c_burn_o') { x_c_burn_o }
        t.def_figure('x_c_burn_ne') { x_c_burn_ne }
        t.def_figure('x_c_burn_na') { x_c_burn_na }
        t.def_figure('x_c_burn_mg') { x_c_burn_mg }
        t.def_figure('x_c_burn_si') { x_c_burn_si }
        t.def_figure('x_c_burn_s') { x_c_burn_s }
        t.def_figure('x_c_burn_ar') { x_c_burn_ar }
        t.def_figure('x_c_burn_ca') { x_c_burn_ca }
        t.def_figure('x_c_burn_ti') { x_c_burn_ti }
        t.def_figure('x_c_burn_cr') { x_c_burn_cr }
        t.def_figure('x_c_burn_fe') { x_c_burn_fe }
        t.def_figure('x_c_c12_c12') { x_c_c12_c12 }
        t.def_figure('x_c_c12_o16') { x_c_c12_o16 }
        t.def_figure('x_c_o16_o16') { x_c_o16_o16 }
        t.def_figure('x_c_photo') { x_c_photo }
        t.def_figure('x_c_pnhe4') { x_c_pnhe4 }
        

        t.def_figure('x_model_number') { x_model_number }


        @have_logs = false
    end    
    
    
    def set_logs_and_labels
    
        return if @have_logs == true
        
        if @coupled then

           @log_dirs = [ 
               '../LOGS_coupled',
               '../LOGS_split'
               ]    
               
           @labels = [ 
               'coupled',
               'split'
               ]
         
           @colors = [ 
               Goldenrod, BrightBlue, Teal, Coral, FireBrick, RoyalPurple, Lilac,
               Goldenrod, BrightBlue, Teal, Coral, FireBrick, RoyalPurple, Lilac,
               Goldenrod, BrightBlue, Teal, Coral, FireBrick, RoyalPurple, Lilac
               ]
               
            @line_type1 = Line_Type_Solid
            @line_type2 = Line_Type_Dash
            @line_type3 = Line_Type_Dot
            
        
        else

           @log_dirs = [ 
               '../LOGS_split',
               '../LOGS_logTc_9.5'
               ]    
               
           @labels = [ 
               'split',
               'coupled'
               ]
         
           @colors = [ 
               BrightBlue, Goldenrod, Teal, Coral, FireBrick, RoyalPurple, Lilac,
               BrightBlue, Goldenrod, Teal, Coral, FireBrick, RoyalPurple, Lilac,
               BrightBlue, Goldenrod, Teal, Coral, FireBrick, RoyalPurple, Lilac
               ]
               
            @line_type2 = Line_Type_Solid
            @line_type1 = Line_Type_Dash
            @line_type3 = Line_Type_Dot
        
        end
        
            
            

        @line_types = []
        @show_flags = []
        @change_line_type = 1
        
        @logs = []
        @log_dirs.each { |log_dir|
            @logs << HistoryLogs.new(
                log_dir + '/history.data', @first_model, @last_model, 
                @age_shift, @first_age, @last_age, 
                @discard_span, @age_span, @max_models, @log_cnt, @xaxis, nil)
            }
            
       @have_logs = true

    end
    
    
    def x_XH_ages(right_margin=0, left_margin=0)
        #t.set_aspect_ratio(0.8)
        xary = []
        yary = []
        set_logs_and_labels

        i = 1
        @logs.each { |log|
            xary << log.star_age
            yary << log.center_h1
            if i > 2*@change_line_type
               @line_types << Line_Type_Dot
            elsif i > @change_line_type
                @line_types << @line_type2
            else
                @line_types << @line_type1
            end
            @show_flags << true
            i = i+1
        }
        
        plot_many_A_vs_B(
            'xary' => xary,
            'yary' => yary,
            'xmin' => 0,
            'ymax' => 0.75,
            'title' => '',
            'ylabel' => 'X_c',
            'xlabel' => 'age (yr)',
            'decorate' => 'decorate_compare_XH_ages',
            'reverse_xaxis' => false
        )
    end
    
    def decorate_compare_XH_ages(ymin, ymax, xmin, xmax)
      t.show_label('text' => '$M=1.5 M_\odot$\quad$X=0.73$\quad$Z=0.02$', 'scale' => 0.7,
            'x' => 1.1e9, 'y' => 0.63, 'justification' => LEFT_JUSTIFIED)
    end
    
    
    def x_XHe_ages(right_margin=0, left_margin=0)
        #t.set_aspect_ratio(0.8)
        xary = []
        yary = []
        set_logs_and_labels

        i = 1
        @logs.each { |log|
            xary << log.star_age
            yary << log.center_he4
            if i > 2*@change_line_type
               @line_types << Line_Type_Dot
            elsif i > @change_line_type
                @line_types << @line_type2
            else
                @line_types << @line_type1
            end
            @show_flags << true
            i = i+1
        }
        
        plot_many_A_vs_B(
            'xary' => xary,
            'yary' => yary,
            'xmin' => 0,
            'ymax' => 0.98,
            'title' => '',
            'ylabel' => 'Y_c',
            'xlabel' => 'age (yr)',
            'decorate' => 'decorate_compare_XHe_ages',
            'reverse_xaxis' => false
        )
    end
    
    def decorate_compare_XHe_ages(ymin, ymax, xmin, xmax)
         t.show_label('text' => '$M=3.0 M_\odot$\quad$X=0.73$\quad$Z=0.02$', 'scale' => 0.7,
            'x' => 0.7e8, 'y' => 0.8, 'justification' => LEFT_JUSTIFIED)
    end
    
    
    
    
    
    def x_log_center_T(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.log_center_T }
        compare(yary, 'log center T', right_margin, left_margin)
    end
    
    
    def x_log_center_Rho(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.log_center_Rho }
        compare(yary, 'log center Rho', right_margin, left_margin)
    end
    
    
    def x_log_center_P(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.log_center_P }
        compare(yary, 'log center P', right_margin, left_margin)
    end
    
    
    def x_center_entropy(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_entropy }
        compare(yary, 'center entropy', right_margin, left_margin)
    end
    
    
    def x_center_abar(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_abar }
        compare(yary, 'center abar', right_margin, left_margin)
    end
    
    
    def x_center_zbar(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_zbar }
        compare(yary, 'center zbar', right_margin, left_margin)
    end
    
    
    def x_center_mu(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_mu }
        compare(yary, 'center mu', right_margin, left_margin)
    end
    
    
    def x_center_mu(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_mu }
        compare(yary, 'center mu', right_margin, left_margin)
    end
    
    
    def x_center_ye(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_ye }
        compare(yary, 'center ye', right_margin, left_margin)
    end
    
    
    def x_center_entropy(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_entropy }
        compare(yary, 'center entropy', right_margin, left_margin)
    end
    
    
    def x_center_eps_grav(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_eps_grav }
        compare(yary, 'center eps grav', right_margin, left_margin)
    end
    
    
    def x_sign_eps_nuc(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| 
            yary << log.center_eps_nuc.collect { |x| (x > 0)? 1 : -1 } }
        compare(yary, 'sign eps nuc', right_margin, left_margin)
    end
    
    
    def x_center_eps_nuc(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_eps_nuc }
        compare(yary, 'eps nuc', right_margin, left_margin)
    end
    
    
    def x_log_abs_eps_nuc(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_eps_nuc.abs.safe_log10 }
        compare(yary, 'log abs eps nuc', right_margin, left_margin)
    end

    
    
    def x_d_center_eps_nuc_dlnT(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.d_center_eps_nuc_dlnT }
        compare(yary, 'd center eps nuc dlnT', right_margin, left_margin)
    end
    
    
    def x_d_center_eps_nuc_dlnd(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.d_center_eps_nuc_dlnd }
        compare(yary, 'd center eps nuc dlnd', right_margin, left_margin)
    end

    
    
    def x_center_non_nuc_neu(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_non_nuc_neu }
        compare(yary, 'center non nuc neu', right_margin, left_margin)
    end
    
    
    def x_center_dL_dm(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_dL_dm }
        compare(yary, 'center dL/dm', right_margin, left_margin)
    end
    
    
    def x_log_eps_burn_photo(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_photo }
        compare(yary, 'center log eps burn photo', right_margin, left_margin)
    end

    
    
    def x_log_Teff(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.log_Teff }
        compare(yary, 'log Teff', right_margin, left_margin)
    end
    
    def x_log_L(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.log_L }
        compare(yary, 'log L', right_margin, left_margin)
    end
    
    
    def x_log_R(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.log_R }
        compare(yary, 'log R', right_margin, left_margin)
    end
    
    
    def x_log_Teff(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.log_Teff }
        compare(yary, 'log Teff', right_margin, left_margin)
    end
    
    
    def x_log_L(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.log_L }
        compare(yary, 'log L', right_margin, left_margin)
    end
    
    
    def x_log_LH(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.log_LH }
        compare(yary, 'log LH', right_margin, left_margin)
    end
    
    
    def x_log_LHe(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.log_LHe }
        compare(yary, 'log LHe', right_margin, left_margin)
    end
    
    
    def x_log_Lnuc(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.log_Lnuc }
        compare(yary, 'log Lnuc', right_margin, left_margin)
    end
    
    
    def x_log_Lneu(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.log_Lneu }
        compare(yary, 'log Lneu', right_margin, left_margin)
    end


    
    
    def x_he4(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_he4 }
        compare(yary, 'center he4', right_margin, left_margin)
    end
    
    
    def x_o16(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_o16 }
        compare(yary, 'center o16', right_margin, left_margin)
    end
    
    
    def x_ne20(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_ne20 }
        compare(yary, 'center ne20', right_margin, left_margin)
    end
    
    
    def x_mg24(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_mg24 }
        compare(yary, 'center mg24', right_margin, left_margin)
    end
    
    
    def x_si28(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_si28 }
        compare(yary, 'center si28', right_margin, left_margin)
    end
    
    
    def x_si28(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_si28 }
        compare(yary, 'center si28', right_margin, left_margin)
    end
    
    
    def x_s32(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_s32 }
        compare(yary, 'center s32', right_margin, left_margin)
    end
    
    
    def x_ar36(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_ar36 }
        compare(yary, 'center ar36', right_margin, left_margin)
    end
    
    
    def x_ca40(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_ca40 }
        compare(yary, 'center ca40', right_margin, left_margin)
    end
    
    
    def x_fe54(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_fe54 }
        compare(yary, 'center fe54', right_margin, left_margin)
    end
    
    
    def x_fe56(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_fe56 }
        compare(yary, 'center fe56', right_margin, left_margin)
    end
    
    
    def x_cr56(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_cr56 }
        compare(yary, 'center cr56', right_margin, left_margin)
    end
    
    
    def x_ni56(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_ni56 }
        compare(yary, 'center ni56', right_margin, left_margin)
    end
    
    
    def x_c_pp(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_pp }
        compare(yary, 'center log eps burn pp', right_margin, left_margin)
    end
    
    
    def x_c_cno(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_cno }
        compare(yary, 'center log eps burn cno', right_margin, left_margin)
    end
    
    
    def x_c_tri_alfa(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_tri_alfa }
        compare(yary, 'center log eps burn tri alfa', right_margin, left_margin)
    end
    
    
    def x_c_burn_c(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_c }
        compare(yary, 'center log eps burn c', right_margin, left_margin)
    end
    
    
    def x_c_burn_n(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_n }
        compare(yary, 'center log eps burn n', right_margin, left_margin)
    end
    
    
    def x_c_burn_o(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_o }
        compare(yary, 'center log eps burn o', right_margin, left_margin)
    end
    
    
    def x_c_burn_ne(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_ne }
        compare(yary, 'center log eps burn ne', right_margin, left_margin)
    end
    
    
    def x_c_burn_na(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_na }
        compare(yary, 'center log eps burn na', right_margin, left_margin)
    end
    
    
    def x_c_burn_mg(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_mg }
        compare(yary, 'center log eps burn mg', right_margin, left_margin)
    end
    
    
    def x_c_burn_si(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_si }
        compare(yary, 'center log eps burn si', right_margin, left_margin)
    end
    
    
    def x_c_burn_s(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_s }
        compare(yary, 'center log eps burn s', right_margin, left_margin)
    end
    
    
    def x_c_burn_ar(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_ar }
        compare(yary, 'center log eps burn ar', right_margin, left_margin)
    end
    
    
    def x_c_burn_ca(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_ca }
        compare(yary, 'center log eps burn ca', right_margin, left_margin)
    end
    
    
    def x_c_burn_ti(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_ti }
        compare(yary, 'center log eps burn ti', right_margin, left_margin)
    end
    
    
    def x_c_burn_cr(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_cr }
        compare(yary, 'center log eps burn cr', right_margin, left_margin)
    end
    
    
    def x_c_burn_fe(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_burn_fe }
        compare(yary, 'center log eps burn fe', right_margin, left_margin)
    end
    
    
    def x_c_c12_c12(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_c12_c12 }
        compare(yary, 'center log eps c12 c12', right_margin, left_margin)
    end
    
    
    def x_c_c12_o16(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_c12_o16 }
        compare(yary, 'center log eps c12 o16', right_margin, left_margin)
    end
    
    
    def x_c_o16_o16(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_o16_o16 }
        compare(yary, 'center log eps o16 o16', right_margin, left_margin)
    end
    
    
    def x_c_pnhe4(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_pnhe4 }
        compare(yary, 'center log eps pnhe4', right_margin, left_margin)
    end
    
    
    def x_c_photo(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_log_eps_burn_photo }
        compare(yary, 'center log eps photo', right_margin, left_margin)
    end
    
    
    def x_dlnd_pp(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_pp }
        compare(yary, 'center d epsnuc dlnd for burn pp', right_margin, left_margin)
    end
    
    
    def x_dlnd_cno(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_cno }
        compare(yary, 'center d epsnuc dlnd for burn cno', right_margin, left_margin)
    end
    
    
    def x_dlnd_tri_alfa(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_tri_alfa }
        compare(yary, 'center d epsnuc dlnd for burn tri alfa', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_c(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_c }
        compare(yary, 'center d epsnuc dlnd for burn c', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_n(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_n }
        compare(yary, 'center d epsnuc dlnd for burn n', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_o(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_o }
        compare(yary, 'center d epsnuc dlnd for burn o', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_ne(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_ne }
        compare(yary, 'center d epsnuc dlnd for burn ne', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_na(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_na }
        compare(yary, 'center d epsnuc dlnd for burn na', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_mg(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_mg }
        compare(yary, 'center d epsnuc dlnd for burn mg', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_si(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_si }
        compare(yary, 'center d epsnuc dlnd for burn si', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_s(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_s }
        compare(yary, 'center d epsnuc dlnd for burn s', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_ar(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_ar }
        compare(yary, 'center d epsnuc dlnd for burn ar', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_ca(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_ca }
        compare(yary, 'center d epsnuc dlnd for burn ca', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_ti(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_ti }
        compare(yary, 'center d epsnuc dlnd for burn ti', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_cr(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_cr }
        compare(yary, 'center d epsnuc dlnd for burn cr', right_margin, left_margin)
    end
    
    
    def x_dlnd_burn_fe(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_burn_fe }
        compare(yary, 'center d epsnuc dlnd for burn fe', right_margin, left_margin)
    end
    
    
    def x_dlnd_c12_c12(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_c12_c12 }
        compare(yary, 'center d epsnuc dlnd for c12 c12', right_margin, left_margin)
    end
    
    
    def x_dlnd_c12_o16(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_c12_o16 }
        compare(yary, 'center d epsnuc dlnd for c12 o16', right_margin, left_margin)
    end
    
    
    def x_dlnd_o16_o16(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_o16_o16 }
        compare(yary, 'center d epsnuc dlnd for o16 o16', right_margin, left_margin)
    end
    
    
    def x_dlnd_pnhe4(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_pnhe4 }
        compare(yary, 'center d epsnuc dlnd for pnhe4', right_margin, left_margin)
    end
    
    
    def x_dlnd_photo(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.c_d_eps_dlnd_photo }
        compare(yary, 'center d epsnuc dlnd for photo', right_margin, left_margin)
    end
    
    
    def x_model_number(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.model_number }
        compare(yary, 'model number', right_margin, left_margin)
    end
    
    
    
    
    def x_center_other(right_margin=0, left_margin=0)
        yary = []
        set_logs_and_labels
        @logs.each { |log| yary << log.center_log_eps_burn_other }
        compare(yary, 'center log eps other', right_margin, left_margin)
    end

    
    def compare(yary, ylabel, right_margin, left_margin)
        #t.set_aspect_ratio(0.8)
        xary = []
        set_logs_and_labels

        i = 1
        @logs.each { |log|
            xary << log.star_age
            #xary << log.model_number
            if i > 2*@change_line_type
               @line_types << Line_Type_Dot
            elsif i > @change_line_type
                @line_types << @line_type2
            else
                @line_types << @line_type1
            end
            @show_flags << true
            i = i+1
        }
        
        plot_many_A_vs_B(
            'xary' => xary,
            'yary' => yary,
            'title' => '',
            'ylabel' => ylabel,
            'xlabel' => 'age',
            #'xlabel' => 'model',
            'reverse_xaxis' => false
        )
    end
    
    
    def x_HRs(right_margin=0, left_margin=0)
        #t.set_aspect_ratio(0.8)
        xary = []
        yary = []
        set_logs_and_labels
        
        i = 1
        @logs.each { |log|
            xary << log.log_Teff
            yary << log.log_L
            if i > 2*@change_line_type
               @line_types << Line_Type_Dot
            elsif i > @change_line_type
                @line_types << @line_type2
            else
                @line_types << @line_type1
            end
            @show_flags << true
            i = i+1
        }
        
        plot_many_A_vs_B(
            'xary' => xary,
            'yary' => yary,
            'title' => '',
            'ylabel' => 'log L ($\mathrm{L_\odot}$)',
            'xlabel' => 'log $\mathrm{T_{eff}}$ (K)',
            'reverse_xaxis' => true,
            'decorate' => 'decorate_compare_HRs'
        )
    end
    
    def decorate_compare_HRs(ymin, ymax, xmin, xmax)
         t.show_label('text' => '$M=3.0 M_\odot$\quad$X=0.73$\quad$Z=0.02$', 'scale' => 0.7,
            'x' => 3.7, 'y' => 2.25, 'justification' => LEFT_JUSTIFIED)
    end
    
    
    def x_TRhos(right_margin=0, left_margin=0)
        #t.set_aspect_ratio(0.8)
        xary = []
        yary = []
        set_logs_and_labels
        
        i = 1
        @logs.each { |log|
            xary << log.log_center_Rho
            yary << log.log_center_T
            if i > 2*@change_line_type
               @line_types << Line_Type_Dot
            elsif i > @change_line_type
                @line_types << @line_type2
            else
                @line_types << @line_type1
            end
            @show_flags << true
            i = i+1
        }
        
        plot_many_A_vs_B(
            'xary' => xary,
            'yary' => yary,
            #'xmin' => 4,
            #'ymin' => 8.5,
            'title' => '',
            'ylabel' => 'log T_c \rm (K)',
            'xlabel' => 'log $\rho_{\rm c}$ (g cm^{-3})',
            'reverse_xaxis' => false,
            'decorate' => 'decorate_compare_TRhos'
        )
    end
    
    def decorate_compare_TRhos(ymin, ymax, xmin, xmax)
         t.show_label('text' => '$M=3.0 M_\odot$\quad$X=0.73$\quad$Z=0.02$', 'scale' => 0.7,
            'x' => 3.7, 'y' => 2.25, 'justification' => LEFT_JUSTIFIED)
    end

    
end # StarHistory

