# getname.rb

module GetModelName


def GetModelName.getlogname(num,dir = '../LOGS') # num is model_number for desired profile
    file = File.open(dir+'/profiles.index')
    fullname = nil
    line = file.readline.split
    if line == nil
      file.close
      return nil
    end
    numlogs = line[0].to_i
    cnt = 0
    numlogs.times do
        model = -1
        line = file.readline.split
        if line == nil
           file.close
           return nil
        end
        modnum = line[0].to_i
        if (modnum == num) || (num < 0 && numlogs+num == cnt)
          fullname = dir + '/profile' + line[2] + '.data'
        end
        cnt = cnt+1
    end
    file.close
    return fullname
end


def GetModelName.getnumprofiles(dir = '../LOGS', min_priority=0)
      file = File.open(dir+'/profiles.index')
      line = file.readline.split
      num_total = line[0].to_i
      if min_priority <= 1
         num = num_total
      else
         num = 0
         num_total.times {
            line = file.readline.split
            if line[1].to_i >= min_priority
               num = num+1
            end
         }
      end
      file.close
      return nil if line == nil
      return num
end


def GetModelName.getname(num,dir = '../LOGS') # num is number of desired profile (starting at 1)
      return nil if num <= 0
      file = File.open(dir+'/profiles.index')
      fullname = nil
      line = file.readline.split
      if line == nil
         file.close
         return nil
      end
      numlogs = line[0].to_i
      if numlogs < num
         line = nil
      else
         num.times { line = file.readline.split }
      end
      file.close
      return nil if line == nil
      fullname = dir + '/log' + line[2] + '.data'
      return fullname
end


def GetModelName.get_priority(num,dir = '../LOGS') 
      # num is number of desired profile (starting at 1)
      return nil if num <= 0
      file = File.open(dir+'/profiles.index')
      fullname = nil
      line = file.readline.split
      if line == nil
         file.close
         return nil
      end
      numlogs = line[0].to_i
      if numlogs < num
         line = nil
      else
         num.times { line = file.readline.split }
      end
      file.close
      return nil if line == nil
      return line[1].to_i
end


def GetModelName.get_model_number(num,dir = '../LOGS') 
      # num is number of desired profile (starting at 1)
      return nil if num <= 0
      file = File.open(dir+'/profiles.index')
      fullname = nil
      line = file.readline.split
      if line == nil
         file.close
         return nil
      end
      numlogs = line[0].to_i
      if numlogs < num
         line = nil
      else
         num.times { line = file.readline.split }
      end
      file.close
      return nil if line == nil
      return line[0].to_i
end


end
