# this is an example of making plots using information from multiple star log files

load 'load.rb'

log_dir = '../LOGS_es/'
   
star_hist = StarHistory.new(
    
    'save_dir' => 'multi_out',
   
   'filenames' => [ 
       log_dir + 'i001_star.log',
       log_dir + 'i002_star.log',
       log_dir + 'i003_star.log',
       log_dir + 'i004_star.log',
       log_dir + 'i005_star.log',
       log_dir + 'i006_star.log',
       log_dir + 'i007_star.log',
       log_dir + 'i008_star.log',
       log_dir + 'i009_star.log',
       log_dir + 'i010_star.log'
       ]
        
   )


class StarHistory
    include Tioga  
      
    def add_extras
        t.def_figure('zams') { zams }
        t.def_figure('l_vs_m') { l_vs_m }
    end    

    def zams
        title = 'zams (kap = es)'
        ytop = 5.5
        ybottom = 0.3
        xleft = 4.7
        xright = 4.0
        t.do_box_labels(title, 'log $\mathrm{T_{eff}}$ (K)', 'log L ($\mathrm{L_\odot}$)')    
        num_logs = @logs.size
        t.show_plot([xleft, xright, ytop, ybottom]) {
            num_logs.times do |i|
                d = @logs[i]
                m = d.star_mass[0]
                k = d.log_LH.sub(d.log_L).where_first_gt(0)
                if k == nil
                    puts "k nil for mass #{m}"
                else
                    x = d.log_Teff[k]
                    y = d.log_L[k]
                    #puts "x #{x} y #{y} mass #{m} m.to_i.to_s #{m.to_i.to_s}"
                    t.show_text(
                        'text' => m.to_i.to_s,
                        'x' => x,
                        'y' => y,
                        'scale' => 1,
                        'alignment' => ALIGNED_AT_MIDHEIGHT,
                        'justification' => CENTERED
                    )
                end
            end
        }
    end    

    def l_vs_m
        title = 'L vs M (kap = es)'
        ytop = 5.6
        ybottom = 0
        xleft = -0.15
        xright = 1.5
        t.do_box_labels(title, 'log M ($\mathrm{M_\odot}$)', 'log L ($\mathrm{L_\odot}$)')    
        t.show_plot([xleft, xright, ytop, ybottom]) {
            @logs.each { |d|
                m = d.star_mass[0]
                k = d.log_LH.sub(d.log_L).where_first_gt(0)
                if k == nil
                    puts "k nil for mass #{m}"
                else
                    x = log10(m)
                    y = d.log_L[k]
                    t.show_text(
                        'text' => m.to_i.to_s,
                        'x' => x,
                        'y' => y,
                        'scale' => 1,
                        'alignment' => ALIGNED_AT_MIDHEIGHT,
                        'justification' => CENTERED
                    )
                end
            }
            x0 = 0.1; y0 = 0.7
            x1 = 1.4; y1 = y0 + 3*(x1 - x0)
            x = 0.4; y = 0.9
            txt = '$\mathrm{L \sim M^3} $'
            t.stroke_line(x0, y0, x1, y1)
            t.show_text(
                'text' => txt, 
                'justification' => CENTERED,
                'x' => x, 'y' => y)
        }
    end
    
end # StarHistory

star_hist.add_extras

