# kipp.rb

class StarHistory

    include Math
    include FigureConstants



      def kippenhahn_burn_mix
        t.rescale(0.8)
        t.subplot('right_margin' => @image_right_margin) { 
            kippenhahn(true,true,true,false,false,false) 
        }
        t.subplot('left_margin' => 0.98, 
            'top_margin' => 0.05, 
            'bottom_margin' => 0.05) { 
            color_bar(
                '$\mathrm{sign(\epsilon_{\rm nuc}) log(max(1,\vert\epsilon_{\rm nuc}\vert))}$', -15, 15)
         }
      end


      def kippenhahn_burn_mix_simple_abundances
        t.rescale(1.3)
          kippenhahn(true,true,true,false,false,false) 
      end


      def kippenhahn_burn_mix_simple_no_abundances
        t.rescale(1.3)
          kippenhahn(false,true,true,false,false,false) 
      end


      def kippenhahn_burn_mix_no_abundances
        t.rescale(0.8)
        t.subplot('right_margin' => @image_right_margin) { 
            kippenhahn(false,true,true,false,false,false) 
        }
        t.subplot('left_margin' => 0.98, 
            'top_margin' => 0.05, 
            'bottom_margin' => 0.05) { 
            color_bar(
                '$\mathrm{sign(\epsilon_{\rm nuc}) log(max(1,\vert\epsilon_{\rm nuc}\vert))}$', -15, 15)
         }
      end
            

      def kippenhahn_no_mix
        t.rescale(0.8)
        t.subplot('right_margin' => @image_right_margin) { 
            kippenhahn(true,false,true,false,false,false) 
        }
        t.subplot('left_margin' => 0.98, 
            'top_margin' => 0.05, 
            'bottom_margin' => 0.05) { 
            color_bar('$\mathrm{sign(eps)*log(max(1,abs(eps)))}$', -15, 15)
         }
      end

      def kippenhahn_no_burn
         kippenhahn(true,true,false,true,false,false)
      end


      def kippenhahn_abundances
         kippenhahn(true,false,false,false,false,false)
      end


      def kippenhahn_no_abundances
        t.rescale(0.8)
        t.subplot('right_margin' => @image_right_margin) { 
            kippenhahn(false,true,true,false,false,false) 
        }
        t.subplot('left_margin' => 0.98, 
            'top_margin' => 0.05, 
            'bottom_margin' => 0.05) { 
            color_bar('$\mathrm{sign(eps)*log(max(1,abs(eps)))}$', -15, 15)
         }
      end


      def kippenhahn_luminosities
         t.rescale(0.8)
         legend_left_margin = @legend_left_margin
         legend_left_margin = 0.15 if legend_left_margin == nil
         legend_top_margin = @legend_top_margin
         legend_top_margin = 0.8 if legend_top_margin == nil
         t.legend_text_dy = 1.2
         t.legend_line_x1 = 3
         t.legend_text_xstart = 4
         t.ylabel_shift = 1.2
         legend_on_right = false
         legend_right = nil
         t.show_plot_with_legend(
            'legend_left_margin' => legend_left_margin,
            'legend_top_margin' => legend_top_margin,
            'plot_scale' => 1,
            'legend_scale' => 1.2,
            'plot_right_margin' => 0) { 

            t.subfigure('right_margin' => @image_right_margin) { 
                kippenhahn(false,true,true,false,true,false) 
            }
            t.subfigure('left_margin' => 0.98, 
                'top_margin' => 0.05, 
                'bottom_margin' => 0.05) { 
                color_bar('$\mathrm{sign(eps)*log(max(1,abs(eps)))}$', -15, 15)
             }
         }
      end





      def kippenhahn_mix_only
         kippenhahn(false,true,false,true,false,false)
      end
    
    



      def kippenhahn(
            with_abundances, show_convection, show_burn, mix_first, with_luminosities, with_color_bar)
         t.rescale(0.8)
         
         #t.set_aspect_ratio(1.2)
                  
         t.set_subframe('right_margin' => 0.12, 'left_margin' => 0.0)
         t.show_xlabel(@xaxis_label)
         xs = @xaxis_data[@track_first .. @track_last]
         legend_top_margin = 0.04
         legend_on_right = true
         legend_left_margin = 0.19
         legend_right = 0.23
         t.legend_text_dy = 1.2
         t.legend_line_x1 = 3
         t.legend_text_xstart = 4
         #t.ylabel_shift = 1.2
         t.xaxis_tick_interval = 2 if @xaxis == 'by_lg_ybp'
         @xaxis_left = @xaxis_data[@track_first]
         @xaxis_right = @xaxis_data[@track_last]
         @xaxis_right = @kipp_xright_for_by_lg_ybp if @xaxis == 'by_lg_ybp' && 
            @kipp_xright_for_by_lg_ybp != nil
         @xaxis_left = @kipp_xleft_for_by_lg_ybp if @xaxis == 'by_lg_ybp' && 
            @kipp_xleft_for_by_lg_ybp != nil
         @xaxis_right = @kipp_xright_for_by_lg_sbp if @xaxis == 'by_lg_sbp' && 
            @kipp_xright_for_by_lg_sbp != nil
         @xaxis_left = @kipp_xleft_for_by_lg_sbp if @xaxis == 'by_lg_sbp' && 
            @kipp_xleft_for_by_lg_sbp != nil
         if @kipp_legend
             t.show_plot_with_legend(
                'legend_left_margin' => legend_left_margin,
                'legend_top_margin' => legend_top_margin,
                'plot_scale' => 1,
                'legend_scale' => 0.84,
                'legend_background_function' => 
                    lambda { |bnds| 
                        do_legend_background(bnds,legend_on_right,legend_right)
                        },
                'plot_right_margin' => 0) { 
                    do_kipp(xs, with_abundances, show_convection, show_burn, mix_first, with_luminosities) 
                }
         else
            do_kipp(xs, with_abundances, show_convection, show_burn, mix_first, with_luminosities)
         end
      end
      
      
      def do_kipp(xs, with_abundances, show_convection, show_burn, mix_first, with_luminosities)
        t.subfigure {
           t.yaxis_loc = t.ylabel_side = LEFT
           t.right_edge_type = AXIS_HIDDEN if with_abundances
           plot_kipp(xs, show_convection, show_burn, mix_first)
           }
        if with_abundances
            t.subfigure {
               t.yaxis_loc = t.ylabel_side = RIGHT
               t.left_edge_type = AXIS_HIDDEN
               t.bottom_edge_type = AXIS_HIDDEN
               t.no_xlabel
               plot_core_abundances(xs)
            }
        end
        if with_luminosities
            t.subfigure {
               t.yaxis_loc = t.ylabel_side = RIGHT
               t.left_edge_type = AXIS_HIDDEN
               t.bottom_edge_type = AXIS_HIDDEN
               t.no_xlabel
               plot_lum_cno_tri_alfa_burn_c(xs)
            }
        end
      end
    
    
    def plot_lum_cno_tri_alfa_burn_c(xs)
         ylabel = 'log (L /$\mathrm{L_{\\odot}}$)'
         t.show_ylabel(ylabel); t.no_ylabel
         
         max_cno = d.cno[@track_first .. @track_last].max
         do_cno = max_cno > -1
         max_tri_alfa = d.tri_alfa[@track_first .. @track_last].max
         do_tri_alfa = max_tri_alfa > -1
         max_c = d.burn_c[@track_first .. @track_last].max
         do_c = max_c > -1
         
         ymax = d.log_L[@track_first .. @track_last].max
         ymax = max_cno if max_cno > ymax
         ymax = max_tri_alfa if max_tri_alfa > ymax
         ymax = max_c if max_c > ymax
         ymax = ymax*1.1
         ymax = 4.1 if ymax < 4.1
         #ymax = 11.1 if ymax > 11.1
         
         ymin = -0.51
         do_h = true
         
         ymin = -2.5 if @no_frills
         
         
         t.show_plot('boundaries' => [ @xaxis_left, @xaxis_right, ymax, ymin ]) do
            t.stroke_width = 1.5
            ys = d.log_L[@track_first .. @track_last]
            stroke_track(xs, ys, color=Coral, legend='L')
            if do_cno
               ys = d.cno[@track_first .. @track_last]
               stroke_track(xs, ys, color=Teal, legend='L_{\rm cno}', type=Line_Type_Dash)
            end
            if do_tri_alfa
               ys = d.tri_alfa[@track_first .. @track_last]
               stroke_track(xs, ys, color=CornflowerBlue, legend='L_{\rm tri_alpha}', type=Line_Type_Solid)
            end
            if do_c
               ys = d.burn_c[@track_first .. @track_last]
               stroke_track(xs, ys, color=RoyalPurple, legend='L_{\rm C+alpha}', type=Line_Type_Dash)
            end
         end
    end


      def plot_core_abundances(xs)
        t.show_ylabel('Central mass fraction'); t.no_ylabel
        ymax = 1.1
        ymin = -0.001
        
        colors = [ BrightBlue, Goldenrod, FireBrick, RoyalPurple, Teal, Coral, Lilac ]
        patterns = [ Line_Type_Solid, Line_Type_Dash, Line_Type_Dot, Line_Type_Dot_Dash, Line_Type_Dot_Long_Dash ]
        
        cnt = 0
        
        t.show_plot('boundaries' => [ @xaxis_left, @xaxis_right, ymax, ymin ]) do
            t.stroke_width = 1.5
            
            cnt = do1_abundance(xs, d.center_h1, cnt, colors, patterns, 'H')
            cnt = do1_abundance(xs, d.center_he4, cnt, colors, patterns, '$^{4}$\rm He')
            cnt = do1_abundance(xs, d.center_c12, cnt, colors, patterns, '$^{12}$\rm C')
            cnt = do1_abundance(xs, d.center_n14, cnt, colors, patterns, '$^{14}$\rm N')
            cnt = do1_abundance(xs, d.center_o16, cnt, colors, patterns, '$^{16}$\rm O')
            
            cnt = do1_abundance(xs, d.center_ne20, cnt, colors, patterns, '$^{20}$\rm Ne')   
            cnt = do1_abundance(xs, d.center_si28, cnt, colors, patterns, '$^{28}$\rm Si')
            cnt = do1_abundance(xs, d.center_s32, cnt, colors, patterns, '$^{32}$\rm S')
            cnt = do1_abundance(xs, d.center_ar36, cnt, colors, patterns, '$^{36}$\rm Ar')
            
            cnt = do1_abundance(xs, d.center_ca40, cnt, colors, patterns, '$^{40}$\rm Ca')
            cnt = do1_abundance(xs, d.center_ca42, cnt, colors, patterns, '$^{42}$\rm Ca')
            cnt = do1_abundance(xs, d.center_ca44, cnt, colors, patterns, '$^{44}$\rm Ca')
            cnt = do1_abundance(xs, d.center_ca46, cnt, colors, patterns, '$^{46}$\rm Ca')
            cnt = do1_abundance(xs, d.center_ca48, cnt, colors, patterns, '$^{48}$\rm Ca')

            cnt = do1_abundance(xs, d.center_ti44, cnt, colors, patterns, '$^{44}$\rm Ti')
            cnt = do1_abundance(xs, d.center_ti46, cnt, colors, patterns, '$^{46}$\rm Ti')
            cnt = do1_abundance(xs, d.center_ti48, cnt, colors, patterns, '$^{48}$\rm Ti')
            cnt = do1_abundance(xs, d.center_ti50, cnt, colors, patterns, '$^{50}$\rm Ti')
            cnt = do1_abundance(xs, d.center_ti52, cnt, colors, patterns, '$^{52}$\rm Ti')

            cnt = do1_abundance(xs, d.center_cr48, cnt, colors, patterns, '$^{48}$\rm Cr')
            cnt = do1_abundance(xs, d.center_cr50, cnt, colors, patterns, '$^{50}$\rm Cr')
            cnt = do1_abundance(xs, d.center_cr52, cnt, colors, patterns, '$^{52}$\rm Cr')
            cnt = do1_abundance(xs, d.center_cr54, cnt, colors, patterns, '$^{54}$\rm Cr')
            cnt = do1_abundance(xs, d.center_cr56, cnt, colors, patterns, '$^{56}$\rm Cr')
            
            cnt = do1_abundance(xs, d.center_fe52, cnt, colors, patterns, '$^{52}$\rm Fe')
            cnt = do1_abundance(xs, d.center_fe54, cnt, colors, patterns, '$^{54}$\rm Fe')
            cnt = do1_abundance(xs, d.center_fe56, cnt, colors, patterns, '$^{56}$\rm Fe')
            cnt = do1_abundance(xs, d.center_fe58, cnt, colors, patterns, '$^{58}$\rm Fe')
            cnt = do1_abundance(xs, d.center_fe60, cnt, colors, patterns, '$^{60}$\rm Fe')
            
            cnt = do1_abundance(xs, d.center_ni56, cnt, colors, patterns, '$^{56}$\rm Ni')
            cnt = do1_abundance(xs, d.center_ni58, cnt, colors, patterns, '$^{58}$\rm Ni')
            cnt = do1_abundance(xs, d.center_ni60, cnt, colors, patterns, '$^{60}$\rm Ni')
            cnt = do1_abundance(xs, d.center_ni62, cnt, colors, patterns, '$^{62}$\rm Ni')
            cnt = do1_abundance(xs, d.center_ni64, cnt, colors, patterns, '$^{64}$\rm Ni')
            cnt = do1_abundance(xs, d.center_ni66, cnt, colors, patterns, '$^{66}$\rm Ni')

            cnt = do1_abundance(xs, d.center_neut, cnt, colors, patterns, 'neut')
            cnt = do1_abundance(xs, d.center_prot, cnt, colors, patterns, 'prot')
            
        end
      end
      
      
      def do1_abundance(
          xs_plot, abundance, cnt, colors, patterns, label, 
          n=@num_abundance_line_labels,
          minmax=nil,
          type=Line_Type_Solid)
        
        return cnt if abundance == nil
        
        ys_plot = abundance[@track_first .. @track_last]
        unless minmax == nil
           return cnt if ys_plot.max < minmax
        end

        num_colors = colors.length
        color = colors[cnt - num_colors*(cnt/num_colors)]
        num_patterns = patterns.length
        pattern = patterns[cnt/num_colors]
        
        t.show_polyline(xs_plot, ys_plot, color, nil, pattern)

        xwidth = @xaxis_left - @xaxis_right
        dx = xwidth/n
        if xs_plot[0] < xs_plot[1]
            xs = xs_plot.reverse # need to reverse for use with linear_interpolate
            ys = ys_plot.reverse
        else
            xs = xs_plot
            ys = ys_plot
        end
        n.round.to_int.times do |j|
            x = @xaxis_right + dx*(j+0.5)
            if x > xs[0]
                y = ys[0]
            elsif x < xs[-1]
                y = ys[-1]
            else
                y = Dvector.linear_interpolate(x, xs, ys)
            end
            if y > 0.01
                y = y + 0.01 if y < 0.9
                y = y - 0.03 if y >= 0.9
                t.show_label(
                    'x' => x, 'y' => y, 
                    'text' => label, 'scale' => 0.85, 
                    'justification' => CENTERED,
                    'alignment' => ALIGNED_AT_BASELINE)
            end
        end
        return cnt+1
      end


      def plot_kipp(xs, show_convection, show_burn, mix_first)
        ylabel = 'm ($\mathrm{M_{\\odot}}$)'
        t.show_ylabel(ylabel)
        masses = d.star_mass[@track_first .. @track_last]
        if @max_mass != nil
            ymax = @max_mass
        else
            ymax = masses.max
        end
        ymax = ymax * 1.02
        if @min_mass != nil
            ymin = @min_mass
        else
            ymin = -0.00001
        end
        dx = (@xaxis_right - @xaxis_left)/2000
        @burn_width = 4
        @burn_colormap = t.intense_colormap
        
        #for i in 0..100
        #    clr = t.get_color_from_colormap(t.intense_colormap, i/100.0)
        #    puts "colormap(1:3,#{i+1}) = (/ #{clr[0]}, #{clr[1]}, #{clr[2]} /)"
        #end
        
        
        t.show_plot('boundaries' => [ @xaxis_left, @xaxis_right, ymax, ymin ]) do
            background
            t.no_xlabel
            if @kipp_legend
                t.stroke_width = 1
                t.stroke_color = Black
                t.save_legend_info('Total mass')
                t.stroke_width = 5
                t.stroke_color = @conv_color
                t.save_legend_info('Convective')
                t.stroke_color = @overshoot_color
                t.save_legend_info('Overshoot')
            end
            if dx > 0
                xprev = xs[0]-dx*2
            else
                xprev = xs[0]+dx*2
            end
            #draw_mix_regions(xs, dx, xprev, masses) if mix_first
            #draw_burn_regions(xs, dx, xprev, masses) if show_burn
            #draw_mix_regions(xs, dx, xprev, masses) unless mix_first
            
            if show_burn
                draw_burn_regions(xs, dx, xprev, masses)
                draw_mix_regions(
                    xs, dx*30, xprev, masses, 0.6) if show_convection
            elsif show_convection
                draw_mix_regions(xs, dx, xprev, masses)
            end
            
            draw_total_mass(xs)


            unless @kipp_label == nil 
                t.show_label(
                    'x' => @kipp_label_x, 'y' => @kipp_label_y, 
                    'text' => @kipp_label, 'scale' => @kipp_label_scale, 
                    'justification' => CENTERED,
                    'alignment' => ALIGNED_AT_BASELINE)
            end


        end
    end
    
    
    def draw_mix_regions(xs, dx, xprev, masses, width_factor = 1)
        xs.each_with_index do |x,i|
            if (dx > 0 && x >= xprev+dx) || (dx < 0 && x <= xprev+dx)
                #puts "i #{i} x #{x}"
                q = 0
                xprev = x
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_1, d.mix_qtop_1, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_2, d.mix_qtop_2, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_3, d.mix_qtop_3, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_4, d.mix_qtop_4, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_5, d.mix_qtop_5, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_6, d.mix_qtop_6, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_7, d.mix_qtop_7, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_8, d.mix_qtop_8, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_9, d.mix_qtop_9, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_10, d.mix_qtop_10, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_11, d.mix_qtop_11, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_12, d.mix_qtop_12, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_13, d.mix_qtop_13, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_14, d.mix_qtop_14, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_15, d.mix_qtop_15, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_16, d.mix_qtop_16, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_17, d.mix_qtop_17, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_18, d.mix_qtop_18, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_19, d.mix_qtop_19, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_20, d.mix_qtop_20, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_21, d.mix_qtop_21, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_22, d.mix_qtop_22, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_23, d.mix_qtop_23, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_24, d.mix_qtop_24, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_25, d.mix_qtop_25, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_26, d.mix_qtop_26, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_27, d.mix_qtop_27, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_28, d.mix_qtop_28, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_29, d.mix_qtop_29, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_30, d.mix_qtop_30, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_31, d.mix_qtop_31, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_32, d.mix_qtop_32, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_33, d.mix_qtop_33, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_34, d.mix_qtop_34, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_35, d.mix_qtop_35, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_36, d.mix_qtop_36, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_37, d.mix_qtop_37, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_38, d.mix_qtop_38, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_39, d.mix_qtop_39, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_40, d.mix_qtop_40, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_41, d.mix_qtop_41, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_42, d.mix_qtop_42, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_43, d.mix_qtop_43, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_44, d.mix_qtop_44, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_45, d.mix_qtop_45, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_46, d.mix_qtop_46, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_47, d.mix_qtop_47, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_48, d.mix_qtop_48, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_49, d.mix_qtop_49, width_factor)
                q = draw1_kipp_mix(x, q, masses, i, d.mix_type_50, d.mix_qtop_50, width_factor)
            end
        end
    end
    
    
    def draw1_kipp_mix(x, qbot, masses, i, mix_type, mix_qtop, width_factor)
        return -1 if mix_type == nil
        show_rotation_mixing = false
        max_type_to_show = 4
        max_type_to_show = 5 if show_rotation_mixing
        type = mix_type[i]
        return -1 if type == -1
        qtop = mix_qtop[i]
        if type == 0 || type > max_type_to_show
            return qtop
        end
        mass = masses[i]
        if type == 1
            t.stroke_color = @conv_color
            t.stroke_width = @conv_width*width_factor
        elsif type == 2
            t.stroke_color = @soft_conv_color
            t.stroke_width = @soft_conv_width*width_factor
        elsif type == 3
            t.stroke_color = @overshoot_color
            t.stroke_width = @overshoot_width*width_factor
        elsif type == 4
            t.stroke_color = @semiconvection_color
            t.stroke_width = @semiconvection_width*width_factor
        elsif type == 5
            t.stroke_color = @thermohaline_color
            t.stroke_width = @thermohaline_width*width_factor
        elsif type == 6 && show_rotation_mixing
            t.stroke_color = @rotation_color
            t.stroke_width = @rotation_width*width_factor
        end
        t.stroke_line(x, qbot*mass, x, qtop*mass)
        #puts "x #{x} qbot #{qbot} qtop #{qtop} mass #{mass}"
        return qtop
    end





    
    
    def draw_burn_regions(xs, dx, xprev, masses)
        xs.each_with_index do |x,i|
            if (dx > 0 && x >= xprev+dx) || (dx < 0 && x <= xprev+dx)
                #puts "i #{i} x #{x}"
                q = 0
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_1, d.burn_qtop_1)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_2, d.burn_qtop_2)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_3, d.burn_qtop_3)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_4, d.burn_qtop_4)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_5, d.burn_qtop_5)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_6, d.burn_qtop_6)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_7, d.burn_qtop_7)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_8, d.burn_qtop_8)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_9, d.burn_qtop_9)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_10, d.burn_qtop_10)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_11, d.burn_qtop_11)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_12, d.burn_qtop_12)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_13, d.burn_qtop_13)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_14, d.burn_qtop_14)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_15, d.burn_qtop_15)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_16, d.burn_qtop_16)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_17, d.burn_qtop_17)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_18, d.burn_qtop_18)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_19, d.burn_qtop_19)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_20, d.burn_qtop_20)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_21, d.burn_qtop_21)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_22, d.burn_qtop_22)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_23, d.burn_qtop_23)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_24, d.burn_qtop_24)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_25, d.burn_qtop_25)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_26, d.burn_qtop_26)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_27, d.burn_qtop_27)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_28, d.burn_qtop_28)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_29, d.burn_qtop_29)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_30, d.burn_qtop_30)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_31, d.burn_qtop_31)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_32, d.burn_qtop_32)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_33, d.burn_qtop_33)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_34, d.burn_qtop_34)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_35, d.burn_qtop_35)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_36, d.burn_qtop_36)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_37, d.burn_qtop_37)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_38, d.burn_qtop_38)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_39, d.burn_qtop_39)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_40, d.burn_qtop_40)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_41, d.burn_qtop_41)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_42, d.burn_qtop_42)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_43, d.burn_qtop_43)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_44, d.burn_qtop_44)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_45, d.burn_qtop_45)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_46, d.burn_qtop_46)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_47, d.burn_qtop_47)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_48, d.burn_qtop_48)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_49, d.burn_qtop_49)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_50, d.burn_qtop_50)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_51, d.burn_qtop_51)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_52, d.burn_qtop_52)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_53, d.burn_qtop_53)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_54, d.burn_qtop_54)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_55, d.burn_qtop_55)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_56, d.burn_qtop_56)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_57, d.burn_qtop_57)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_58, d.burn_qtop_58)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_59, d.burn_qtop_59)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_60, d.burn_qtop_60)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_61, d.burn_qtop_61)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_62, d.burn_qtop_62)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_63, d.burn_qtop_63)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_64, d.burn_qtop_64)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_65, d.burn_qtop_65)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_66, d.burn_qtop_66)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_67, d.burn_qtop_67)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_68, d.burn_qtop_68)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_69, d.burn_qtop_69)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_70, d.burn_qtop_70)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_71, d.burn_qtop_71)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_72, d.burn_qtop_72)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_73, d.burn_qtop_73)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_74, d.burn_qtop_74)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_75, d.burn_qtop_75)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_76, d.burn_qtop_76)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_77, d.burn_qtop_77)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_78, d.burn_qtop_78)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_79, d.burn_qtop_79)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_80, d.burn_qtop_80)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_81, d.burn_qtop_81)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_82, d.burn_qtop_82)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_83, d.burn_qtop_83)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_84, d.burn_qtop_84)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_85, d.burn_qtop_85)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_86, d.burn_qtop_86)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_87, d.burn_qtop_87)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_88, d.burn_qtop_88)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_89, d.burn_qtop_89)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_90, d.burn_qtop_90)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_91, d.burn_qtop_91)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_92, d.burn_qtop_92)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_93, d.burn_qtop_93)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_94, d.burn_qtop_94)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_95, d.burn_qtop_95)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_96, d.burn_qtop_96)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_97, d.burn_qtop_97)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_98, d.burn_qtop_98)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_99, d.burn_qtop_99)
                q = draw1_kipp_burn(x, q, masses, i, d.burn_type_100, d.burn_qtop_100)
                xprev = x
            end
        end
    end

    
    def draw1_kipp_burn(x, qbot, masses, i, burn_type, burn_qtop)
        return -1 if burn_type == nil
        type = burn_type[i]
        qtop = burn_qtop[i]
        return qtop if type <= -9999 || type == 0
        mass = masses[i]
        color_position = (@burn_max - type)/(@burn_max - @burn_min)
        color_position = 1 if color_position > 1
        color_position = 0 if color_position < 0
        color_position = 1 - color_position # flip it so burning is red
        #return qtop if color_position < 0.5
        t.stroke_color = t.get_color_from_colormap(@burn_colormap, color_position)
        t.stroke_width = @burn_width
        t.stroke_line(x, qbot*mass, x, qtop*mass)
        return qtop
    end

    
    
    def color_bar(ylabel, zmin, zmax, levels = nil)
        xmin = 0; xmax = 1; xmid = 0.5
        t.rescale(0.8)
        t.xaxis_type = AXIS_LINE_ONLY
        t.xaxis_loc = BOTTOM
        t.top_edge_type = AXIS_LINE_ONLY
        t.yaxis_loc = t.ylabel_side = RIGHT
        t.yaxis_type = AXIS_WITH_TICKS_AND_NUMERIC_LABELS
        t.left_edge_type = AXIS_WITH_TICKS_ONLY
        #t.ylabel_shift += 0.2
        t.yaxis_major_tick_length *= 0.6
        t.yaxis_minor_tick_length *= 0.4
        t.show_ylabel(ylabel); t.no_ylabel
        t.show_plot('boundaries' => [xmin, xmax, zmax, zmin]) do
            t.axial_shading(
                'start_point' => [xmid, @burn_min], 'end_point' => [xmid, @burn_max], 
                'colormap' => @burn_colormap )
            if levels != nil
                t.stroke_color = Gray
                t.line_width = 1.5
                levels.each { |level| t.stroke_line(xmin, level, xmax, level) }
            end
        end
    end
    
    

end
