
      integer :: version_number ! mesa version from file mesa/data/version_number
      
      
      integer, parameter :: star_def_version = 16
      
      integer, parameter :: nz_alloc_extra = 200
      
      
      integer, parameter :: XL = dp
      !integer, parameter :: XL = qp ! will need some code changes to use quad precision



      ! result codes for various evolution routines
      integer, parameter :: keep_going = 0
      integer, parameter :: redo = 1 
         ! repeat current step with same timestep
         ! for example, after changing a parameter such as mdot
      integer, parameter :: retry = 2
         ! repeat current step with smaller timestep
      integer, parameter :: backup = 3
         ! go back to previous model and retry with smaller timestep
      integer, parameter :: terminate = 4

      
      ! time_step limit identifiers
      integer, parameter :: Tlim_struc = 1
      integer, parameter :: Tlim_max_timestep_factor = Tlim_struc + 1
      integer, parameter :: Tlim_min_timestep_factor = Tlim_max_timestep_factor + 1
      integer, parameter :: Tlim_num_newton_iterations = Tlim_min_timestep_factor + 1
      integer, parameter :: Tlim_num_rotation_steps = Tlim_num_newton_iterations + 1
      integer, parameter :: Tlim_num_diff_solver_steps = Tlim_num_rotation_steps + 1
      integer, parameter :: Tlim_dX = Tlim_num_diff_solver_steps + 1
      integer, parameter :: Tlim_dH = Tlim_dX + 1
      integer, parameter :: Tlim_dHe = Tlim_dH + 1
      integer, parameter :: Tlim_dH_div_H = Tlim_dHe + 1
      integer, parameter :: Tlim_dHe_div_He = Tlim_dH_div_H + 1
      integer, parameter :: Tlim_dX_div_X = Tlim_dHe_div_He + 1
      integer, parameter :: Tlim_dL_div_L = Tlim_dX_div_X + 1
      integer, parameter :: Tlim_dlgP = Tlim_dL_div_L + 1
      integer, parameter :: Tlim_dlgRho = Tlim_dlgP + 1
      integer, parameter :: Tlim_dlgE = Tlim_dlgRho + 1
      integer, parameter :: Tlim_dlgT = Tlim_dlgE + 1
      integer, parameter :: Tlim_dlgR = Tlim_dlgT + 1
      integer, parameter :: Tlim_dlgL_nuc_cat = Tlim_dlgR + 1
      integer, parameter :: Tlim_dlgL_H = Tlim_dlgL_nuc_cat + 1
      integer, parameter :: Tlim_dlgL_He = Tlim_dlgL_H + 1
      integer, parameter :: Tlim_d_deltaR_shrink = Tlim_dlgL_He + 1
      integer, parameter :: Tlim_dlgL_z = Tlim_d_deltaR_shrink + 1
      integer, parameter :: Tlim_dlgL_nuc = Tlim_dlgL_z + 1
      integer, parameter :: Tlim_dlgTeff = Tlim_dlgL_nuc + 1
      integer, parameter :: Tlim_dlgRho_cntr = Tlim_dlgTeff + 1
      integer, parameter :: Tlim_dlgT_cntr = Tlim_dlgRho_cntr + 1
      integer, parameter :: Tlim_lg_XH_cntr = Tlim_dlgT_cntr + 1
      integer, parameter :: Tlim_dmstar = Tlim_lg_XH_cntr + 1
      integer, parameter :: Tlim_dt_div_dt_cell_collapse = Tlim_dmstar + 1
      integer, parameter :: Tlim_dt_div_dt_Courant = Tlim_dt_div_dt_cell_collapse + 1
      integer, parameter :: Tlim_dt_div_dt_thermal = Tlim_dt_div_dt_Courant + 1
      integer, parameter :: Tlim_dt_div_dt_dynamic = Tlim_dt_div_dt_thermal + 1
      integer, parameter :: Tlim_dt_div_dt_acoustic = Tlim_dt_div_dt_dynamic + 1
      integer, parameter :: Tlim_dt_div_dt_mass_loss = Tlim_dt_div_dt_acoustic + 1
      integer, parameter :: Tlim_lgL = Tlim_dt_div_dt_mass_loss + 1
      integer, parameter :: Tlim_max_timestep = Tlim_lgL + 1
      integer, parameter :: Tlim_timestep_hold = Tlim_max_timestep + 1
      integer, parameter :: Tlim_lg_XHe_cntr = Tlim_timestep_hold + 1
      integer, parameter :: Tlim_lg_XC_cntr = Tlim_lg_XHe_cntr + 1
      integer, parameter :: Tlim_lg_XNe_cntr = Tlim_lg_XC_cntr + 1
      integer, parameter :: Tlim_lg_XO_cntr = Tlim_lg_XNe_cntr + 1
      integer, parameter :: Tlim_lg_XSi_cntr = Tlim_lg_XO_cntr + 1
      integer, parameter :: Tlim_CpT_absMdot_div_L = Tlim_lg_XSi_cntr + 1
      integer, parameter :: Tlim_dX_nuc_drop = Tlim_CpT_absMdot_div_L + 1
      integer, parameter :: Tlim_neg_X = Tlim_dX_nuc_drop + 1
      integer, parameter :: Tlim_bad_Xsum = Tlim_neg_X + 1
      integer, parameter :: Tlim_deltaJ = Tlim_bad_Xsum + 1
      integer, parameter :: Tlim_delta_HR = Tlim_deltaJ + 1
      integer, parameter :: Tlim_dHe3 = Tlim_delta_HR + 1
      integer, parameter :: Tlim_dHe3_div_He3 = Tlim_dHe3 + 1
      integer, parameter :: Tlim_max_mix_fixup = Tlim_dHe3_div_He3 + 1
      integer, parameter :: Tlim_d_deltaR_grow = Tlim_max_mix_fixup + 1
      integer, parameter :: Tlim_dlog_eps_nuc_cntr = Tlim_d_deltaR_grow + 1
      integer, parameter :: Tlim_dlog_eps_nuc = Tlim_dlog_eps_nuc_cntr + 1
      integer, parameter :: Tlim_delta_Ye = Tlim_dlog_eps_nuc + 1
      integer, parameter :: Tlim_dlgT_max = Tlim_delta_Ye + 1
      integer, parameter :: Tlim_num_diff_solver_iters = Tlim_dlgT_max + 1
      integer, parameter :: Tlim_burn_max_num_substeps = Tlim_num_diff_solver_iters + 1
      integer, parameter :: Tlim_burn_max_num_iters = Tlim_burn_max_num_substeps + 1
      integer, parameter :: Tlim_dlgL_photo = Tlim_burn_max_num_iters + 1
      integer, parameter :: Tlim_dlgRho_max = Tlim_dlgL_photo + 1
      integer, parameter :: Tlim_delta_Ye_highT = Tlim_dlgRho_max + 1
      integer, parameter :: Tlim_del_mdot = Tlim_delta_Ye_highT + 1
      integer, parameter :: Tlim_truncation_ratio = Tlim_del_mdot + 1
      integer, parameter :: Tlim_v_div_v_crit = Tlim_truncation_ratio + 1
      integer, parameter :: Tlim_error_rate_energy_conservation = Tlim_v_div_v_crit + 1
      integer, parameter :: Tlim_max_E_residual = Tlim_error_rate_energy_conservation + 1
      integer, parameter :: Tlim_avg_E_residual = Tlim_max_E_residual + 1
      integer, parameter :: Tlim_error_in_energy_conservation = Tlim_avg_E_residual + 1
      integer, parameter :: Tlim_binary = Tlim_error_in_energy_conservation + 1
      integer, parameter :: Tlim_error_other = Tlim_binary + 1
      
      integer, parameter :: numTlim = Tlim_error_other
      
      character (len=24) :: dt_why_str(numTlim) ! indicates the reson for the timestep choice
      
   
      
      ! termination codes
      integer, parameter :: t_max_age = 1
      integer, parameter :: t_max_omega_div_omega_crit = t_max_age + 1
      integer, parameter :: t_peak_burn_vconv_div_cs_limit = t_max_omega_div_omega_crit + 1
      integer, parameter :: t_max_model_number = t_peak_burn_vconv_div_cs_limit + 1 
      integer, parameter :: t_eta_center_limit = t_max_model_number + 1 
      integer, parameter :: t_log_center_temp_limit = t_eta_center_limit + 1 
      integer, parameter :: t_log_center_temp_lower_limit = t_log_center_temp_limit + 1 
      integer, parameter :: t_log_center_density_lower_limit = t_log_center_temp_lower_limit + 1 
      integer, parameter :: t_log_center_density_limit = t_log_center_density_lower_limit + 1 
      integer, parameter :: t_gamma_center_limit = t_log_center_density_limit + 1 
      integer, parameter :: t_log_max_temp_upper_limit = t_gamma_center_limit + 1 
      integer, parameter :: t_log_max_temp_lower_limit = t_log_max_temp_upper_limit + 1 
      integer, parameter :: t_HB_limit = t_log_max_temp_lower_limit + 1 
      integer, parameter :: t_stop_at_TP = t_HB_limit + 1 
      integer, parameter :: t_star_mass_min_limit = t_stop_at_TP + 1 
      integer, parameter :: t_star_mass_max_limit = t_star_mass_min_limit + 1 
      integer, parameter :: t_star_H_mass_max_limit = t_star_mass_max_limit + 1 
      integer, parameter :: t_star_H_mass_min_limit = t_star_H_mass_max_limit + 1 
      integer, parameter :: t_star_He_mass_max_limit = t_star_H_mass_min_limit + 1 
      integer, parameter :: t_star_He_mass_min_limit = t_star_He_mass_max_limit + 1 
      integer, parameter :: t_star_C_mass_max_limit = t_star_He_mass_min_limit + 1 
      integer, parameter :: t_star_C_mass_min_limit = t_star_C_mass_max_limit + 1 
      integer, parameter :: t_xmstar_min_limit = t_star_C_mass_min_limit + 1 
      integer, parameter :: t_xmstar_max_limit = t_xmstar_min_limit + 1 
      integer, parameter :: t_envelope_mass_limit = t_xmstar_max_limit + 1 
      integer, parameter :: t_envelope_fraction_left_limit = t_envelope_mass_limit + 1 
      integer, parameter :: t_he_core_mass_limit = t_envelope_fraction_left_limit + 1 
      integer, parameter :: t_c_core_mass_limit = t_he_core_mass_limit + 1 
      integer, parameter :: t_o_core_mass_limit = t_c_core_mass_limit + 1 
      integer, parameter :: t_si_core_mass_limit = t_o_core_mass_limit + 1 
      integer, parameter :: t_fe_core_mass_limit = t_si_core_mass_limit + 1 
      integer, parameter :: t_neutron_rich_core_mass_limit = t_fe_core_mass_limit + 1 
      integer, parameter :: t_he_layer_mass_lower_limit = t_neutron_rich_core_mass_limit + 1 
      integer, parameter :: t_abs_diff_lg_LH_lg_Ls_limit = t_he_layer_mass_lower_limit + 1 
      integer, parameter :: t_Teff_lower_limit = t_abs_diff_lg_LH_lg_Ls_limit + 1 
      integer, parameter :: t_Teff_upper_limit = t_Teff_lower_limit + 1 
      integer, parameter :: t_delta_nu_lower_limit = t_Teff_upper_limit + 1 
      integer, parameter :: t_delta_nu_upper_limit = t_delta_nu_lower_limit + 1 
      integer, parameter :: t_delta_Pg_lower_limit = t_delta_nu_upper_limit + 1 
      integer, parameter :: t_delta_Pg_upper_limit = t_delta_Pg_lower_limit + 1 
      integer, parameter :: t_photosphere_r_lower_limit = t_delta_Pg_upper_limit + 1 
      integer, parameter :: t_photosphere_r_upper_limit = t_photosphere_r_lower_limit + 1 
      integer, parameter :: t_log_Teff_lower_limit = t_photosphere_r_upper_limit + 1 
      integer, parameter :: t_log_Teff_upper_limit = t_log_Teff_lower_limit + 1 
      integer, parameter :: t_log_Tsurf_lower_limit = t_log_Teff_upper_limit + 1 
      integer, parameter :: t_log_Tsurf_upper_limit = t_log_Tsurf_lower_limit + 1 
      integer, parameter :: t_log_Psurf_lower_limit = t_log_Tsurf_upper_limit + 1 
      integer, parameter :: t_log_Psurf_upper_limit = t_log_Psurf_lower_limit + 1 
      integer, parameter :: t_log_Dsurf_lower_limit = t_log_Psurf_upper_limit + 1 
      integer, parameter :: t_log_Dsurf_upper_limit = t_log_Dsurf_lower_limit + 1 
      integer, parameter :: t_log_L_lower_limit = t_log_Dsurf_upper_limit + 1 
      integer, parameter :: t_log_L_upper_limit = t_log_L_lower_limit + 1 
      integer, parameter :: t_log_g_lower_limit = t_log_L_upper_limit + 1 
      integer, parameter :: t_log_g_upper_limit = t_log_g_lower_limit + 1 
      integer, parameter :: t_power_nuc_burn_upper_limit = t_log_g_upper_limit + 1 
      integer, parameter :: t_power_h_burn_upper_limit = t_power_nuc_burn_upper_limit + 1 
      integer, parameter :: t_power_he_burn_upper_limit = t_power_h_burn_upper_limit + 1 
      integer, parameter :: t_power_c_burn_upper_limit = t_power_he_burn_upper_limit + 1 
      integer, parameter :: t_power_nuc_burn_lower_limit = t_power_c_burn_upper_limit + 1 
      integer, parameter :: t_power_h_burn_lower_limit = t_power_nuc_burn_lower_limit + 1 
      integer, parameter :: t_power_he_burn_lower_limit = t_power_h_burn_lower_limit + 1 
      integer, parameter :: t_power_c_burn_lower_limit = t_power_he_burn_lower_limit + 1 
      integer, parameter :: t_phase_of_evolution_stop = t_power_c_burn_lower_limit + 1 
      integer, parameter :: t_center_Ye_lower_limit = t_phase_of_evolution_stop + 1 
      integer, parameter :: t_fe_core_infall_limit = t_center_Ye_lower_limit + 1 
      integer, parameter :: t_non_fe_core_infall_limit = t_fe_core_infall_limit + 1 
      integer, parameter :: t_v_div_csound_surf_limit = t_non_fe_core_infall_limit + 1 
      integer, parameter :: t_Pgas_div_P_limit = t_v_div_csound_surf_limit + 1 
      integer, parameter :: t_Lnuc_div_L_lower_limit = t_Pgas_div_P_limit + 1 
      integer, parameter :: t_Lnuc_div_L_upper_limit = t_Lnuc_div_L_lower_limit + 1 
      integer, parameter :: t_v_surf_div_v_kh_lower_limit = t_Lnuc_div_L_upper_limit + 1 
      integer, parameter :: t_v_surf_div_v_kh_upper_limit = t_v_surf_div_v_kh_lower_limit + 1 
      integer, parameter :: t_v_surf_div_v_esc_limit = t_v_surf_div_v_kh_upper_limit + 1 
      integer, parameter :: t_Lnuc_div_L_zams_limit = t_v_surf_div_v_esc_limit + 1 
      integer, parameter :: t_logQ_limit = t_Lnuc_div_L_zams_limit + 1 
      integer, parameter :: t_xa_central_lower_limit = t_logQ_limit + 1 
      integer, parameter :: t_xa_central_upper_limit = t_xa_central_lower_limit + 1 
      integer, parameter :: t_xa_surface_lower_limit = t_xa_central_upper_limit + 1 
      integer, parameter :: t_xa_surface_upper_limit = t_xa_surface_lower_limit + 1 
      integer, parameter :: t_xa_average_lower_limit = t_xa_surface_upper_limit + 1 
      integer, parameter :: t_xa_average_upper_limit = t_xa_average_lower_limit + 1 
      integer, parameter :: t_surface_accel_div_grav_limit = t_xa_average_upper_limit + 1 
      integer, parameter :: t_stop_because_he_ignited = t_surface_accel_div_grav_limit + 1 
      integer, parameter :: t_adjust_mesh_failed = t_stop_because_he_ignited + 1 
      integer, parameter :: t_dt_is_zero = t_adjust_mesh_failed + 1 
      integer, parameter :: t_min_timestep_limit = t_dt_is_zero + 1 
      integer, parameter :: t_failed_prepare_for_new_try = t_min_timestep_limit + 1 
      integer, parameter :: t_negative_total_angular_momentum = t_failed_prepare_for_new_try + 1 
      integer, parameter :: t_max_number_retries = t_negative_total_angular_momentum + 1 
      integer, parameter :: t_max_number_backups = t_max_number_retries + 1 
      integer, parameter :: t_max_backups_in_a_row = t_max_number_backups + 1 
      integer, parameter :: t_solve_burn = t_max_backups_in_a_row + 1 
      integer, parameter :: t_solve_hydro = t_solve_burn + 1 
      integer, parameter :: t_solve_mix = t_solve_hydro + 1 
      integer, parameter :: t_solve_omega_mix = t_solve_mix + 1 
      integer, parameter :: t_timestep_controller = t_solve_omega_mix + 1 
      integer, parameter :: t_relax_finished_okay = t_timestep_controller + 1
      integer, parameter :: t_done_with_piston = t_relax_finished_okay + 1
      integer, parameter :: t_done_with_center_flash = t_done_with_piston + 1
      integer, parameter :: t_center_entropy_limit = t_done_with_center_flash + 1
      integer, parameter :: t_center_entropy_lower_limit = t_center_entropy_limit + 1
      integer, parameter :: t_max_entropy_limit = t_center_entropy_lower_limit + 1
      integer, parameter :: t_max_entropy_lower_limit = t_max_entropy_limit + 1

      integer, parameter :: t_extras_check_model = t_max_entropy_lower_limit + 1
      integer, parameter :: t_extras_finish_step = t_extras_check_model + 1

      integer, parameter :: t_xtra1 = t_extras_finish_step + 1
      integer, parameter :: t_xtra2 = t_xtra1 + 1
      integer, parameter :: t_xtra3 = t_xtra2 + 1
      integer, parameter :: t_xtra4 = t_xtra3 + 1
      integer, parameter :: t_xtra5 = t_xtra4 + 1
      integer, parameter :: t_xtra6 = t_xtra5 + 1
      integer, parameter :: t_xtra7 = t_xtra6 + 1
      integer, parameter :: t_xtra8 = t_xtra7 + 1
      integer, parameter :: t_xtra9 = t_xtra8 + 1

      integer, parameter :: num_termination_codes = t_xtra9
      
      character (len=128) :: termination_code_str(num_termination_codes)
      
      

      ! mesh cell types
      integer, parameter :: split_type = -1
      integer, parameter :: unchanged_type = 0
      integer, parameter :: merged_type = 1
      integer, parameter :: revised_type = 2
      
      
      ! solver operations
      integer, parameter :: struct_hydro_bit_pos = 0
      integer, parameter :: struct_thermo_bit_pos = 1
      integer, parameter :: burn_bit_pos = 2
      integer, parameter :: mix_bit_pos = 3

      
      ! values for result_reason
      integer, parameter :: result_reason_normal = 1
      integer, parameter :: dt_is_zero = 2 
         ! indicates that t+dt == t, perhaps because of round-off with tiny dt.
      integer, parameter :: nonzero_ierr = 3 ! some routine returned with ierr /= 0
      integer, parameter :: hydro_failed_to_converge = 4
      integer, parameter :: do_burn_failed = 5
      integer, parameter :: diffusion_failed = 6
      integer, parameter :: too_many_steps_for_burn = 7
      integer, parameter :: too_many_steps_for_diffusion = 8
      integer, parameter :: too_many_steps_for_hydro = 9
      integer, parameter :: adjust_mesh_failed = 10
      integer, parameter :: adjust_mass_failed = 11
      integer, parameter :: core_dump_model_number = 12
      integer, parameter :: timestep_limits = 13
      integer, parameter :: variable_change_limits = 14
      integer, parameter :: explicit_hydro_failed = 15
      integer, parameter :: done_with_piston = 15
      
      integer, parameter :: num_reasons = 16
      
      character (len=32) :: result_reason_str(num_reasons)
         
         
      character (len=strlen) :: rate_tables_dir_for_star, rates_cache_suffix_for_star
         



      ! debugging storage
      integer, parameter :: max_ndbg = 9
      
      ! bcyclic data
      type ulstore
         integer :: ul_size    ! size of umat1 & lmat1 (0 if not allocated)
         real(dp), pointer :: umat1(:), lmat1(:)
      end type ulstore
      
      type ulstore_qp
         integer :: ul_size    ! size of umat1 & lmat1 (0 if not allocated)
         real(qp), pointer :: umat1(:), lmat1(:)
      end type ulstore_qp
      
      ! sparse burn data
      type sparse_info
         integer :: sprs_nonzeros
         integer, pointer :: ia(:) ! (species+1)
         integer, pointer :: ja(:) ! (sprs_nonzeros)
         real(dp), pointer :: values(:) ! (sprs_nonzeros)
         real(qp), pointer :: values_qp(:) ! (sprs_nonzeros)
         real(dp) :: rpar_decsol(num_klu_rpar_decsol)
         integer :: ipar8_decsol(num_klu_ipar_decsol)
         logical :: have_Numeric
      end type sparse_info

      
      ! pgstar data

      abstract interface
      
         subroutine pgstar_plot_interface(id, device_id, ierr)
            integer, intent(in) :: id, device_id
            integer, intent(out) :: ierr
         end subroutine pgstar_plot_interface

         subroutine other_do_plot_in_grid_interface( &
               id, device_id, xleft, xright, ybot, ytop, txt_scale, ierr)
            integer, intent(in) :: id, device_id
            real, intent(in) :: xleft, xright, ybot, ytop, txt_scale
            integer, intent(out) :: ierr
         end subroutine other_do_plot_in_grid_interface

      end interface

      type pgstar_win_file_data
         integer :: id
         character (len=64) :: name
         logical :: win_flag, file_flag, do_win, do_file
         integer :: id_win, id_file, file_cnt
         real :: win_width, prev_win_width
         real :: win_aspect_ratio, prev_win_aspect_ratio
         real :: file_width, file_aspect_ratio
         character (len=strlen) :: file_dir, file_prefix, most_recent_filename
         character (len=strlen) :: file_dir_for_previous_mkdir
         logical :: have_called_mkdir
         procedure (pgstar_plot_interface), pointer, nopass :: plot => null()
         ! the following make it possible to use "other" plots in grids
         logical :: okay_to_call_do_plot_in_grid
         procedure (other_do_plot_in_grid_interface), pointer, nopass :: &
            do_plot_in_grid => null()
      end type pgstar_win_file_data

   	integer, parameter :: max_Abundance_num_isos_to_show = 1000
   	
   	integer, parameter :: max_num_Profile_Panels = 10
   	integer, parameter :: max_num_History_Panels = 10
   	integer, parameter :: max_num_Summary_Profile_Lines = 16
   	integer, parameter :: max_num_Summary_History_Lines = 16
      integer, parameter :: max_num_Other_plots = 10
      
      integer, parameter :: i_TRho_Profile = 1
      integer, parameter :: i_logg_logT = i_TRho_Profile + 1
      integer, parameter :: i_logg_Teff = i_logg_logT + 1
      integer, parameter :: i_dPg_dnu = i_logg_Teff + 1
      integer, parameter :: i_L_R = i_dPg_dnu + 1
      integer, parameter :: i_L_v = i_L_R + 1
      integer, parameter :: i_L_Teff = i_L_v + 1
      integer, parameter :: i_R_L = i_L_Teff + 1
      integer, parameter :: i_R_Teff = i_R_L + 1
      integer, parameter :: i_logL_Teff = i_R_Teff + 1
      integer, parameter :: i_HR = i_logL_Teff + 1
      integer, parameter :: i_TRho = i_HR + 1
      integer, parameter :: i_Dynamo = i_TRho + 1
      integer, parameter :: i_Mixing = i_Dynamo + 1
      integer, parameter :: i_Kipp = i_Mixing + 1
      integer, parameter :: i_Cntr_Hist = i_Kipp + 1
      integer, parameter :: i_Surf_Hist = i_Cntr_Hist + 1
      integer, parameter :: i_Mode_Prop = i_Surf_Hist + 1
      integer, parameter :: i_Power = i_Mode_Prop + 1
      integer, parameter :: i_Abundance = i_Power + 1
      integer, parameter :: i_Summary_History = i_Abundance + 1
      integer, parameter :: i_Summary_Burn = i_Summary_History + 1
      integer, parameter :: i_Summary_Profile = i_Summary_Burn + 1

      integer, parameter :: i_Text_Summary1 = i_Summary_Profile + 1
      integer, parameter :: i_Text_Summary2 = i_Text_Summary1 + 1
      integer, parameter :: i_Text_Summary3 = i_Text_Summary2 + 1
      integer, parameter :: i_Text_Summary4 = i_Text_Summary3 + 1
      integer, parameter :: i_Text_Summary5 = i_Text_Summary4 + 1
      integer, parameter :: i_Text_Summary6 = i_Text_Summary5 + 1
      integer, parameter :: i_Text_Summary7 = i_Text_Summary6 + 1
      integer, parameter :: i_Text_Summary8 = i_Text_Summary7 + 1
      integer, parameter :: i_Text_Summary9 = i_Text_Summary8 + 1

      integer, parameter :: i_Profile_Panels1 = i_Text_Summary9 + 1
      integer, parameter :: i_Profile_Panels2 = i_Profile_Panels1 + 1
      integer, parameter :: i_Profile_Panels3 = i_Profile_Panels2 + 1
      integer, parameter :: i_Profile_Panels4 = i_Profile_Panels3 + 1
      integer, parameter :: i_Profile_Panels5 = i_Profile_Panels4 + 1
      integer, parameter :: i_Profile_Panels6 = i_Profile_Panels5 + 1
      integer, parameter :: i_Profile_Panels7 = i_Profile_Panels6 + 1
      integer, parameter :: i_Profile_Panels8 = i_Profile_Panels7 + 1
      integer, parameter :: i_Profile_Panels9 = i_Profile_Panels8 + 1
      
      integer, parameter :: i_Hist_Track1 = i_Profile_Panels9 + 1
      integer, parameter :: i_Hist_Track2 = i_Hist_Track1 + 1
      integer, parameter :: i_Hist_Track3 = i_Hist_Track2 + 1
      integer, parameter :: i_Hist_Track4 = i_Hist_Track3 + 1
      integer, parameter :: i_Hist_Track5 = i_Hist_Track4 + 1
      integer, parameter :: i_Hist_Track6 = i_Hist_Track5 + 1
      integer, parameter :: i_Hist_Track7 = i_Hist_Track6 + 1
      integer, parameter :: i_Hist_Track8 = i_Hist_Track7 + 1
      integer, parameter :: i_Hist_Track9 = i_Hist_Track8 + 1
      
      integer, parameter :: i_Hist_Panels1 = i_Hist_Track9 + 1
      integer, parameter :: i_Hist_Panels2 = i_Hist_Panels1 + 1
      integer, parameter :: i_Hist_Panels3 = i_Hist_Panels2 + 1
      integer, parameter :: i_Hist_Panels4 = i_Hist_Panels3 + 1
      integer, parameter :: i_Hist_Panels5 = i_Hist_Panels4 + 1
      integer, parameter :: i_Hist_Panels6 = i_Hist_Panels5 + 1
      integer, parameter :: i_Hist_Panels7 = i_Hist_Panels6 + 1
      integer, parameter :: i_Hist_Panels8 = i_Hist_Panels7 + 1
      integer, parameter :: i_Hist_Panels9 = i_Hist_Panels8 + 1
      
      integer, parameter :: i_Grid1 = i_Hist_Panels9 + 1
      integer, parameter :: i_Grid2 = i_Grid1 + 1
      integer, parameter :: i_Grid3 = i_Grid2 + 1
      integer, parameter :: i_Grid4 = i_Grid3 + 1
      integer, parameter :: i_Grid5 = i_Grid4 + 1
      integer, parameter :: i_Grid6 = i_Grid5 + 1
      integer, parameter :: i_Grid7 = i_Grid6 + 1
      integer, parameter :: i_Grid8 = i_Grid7 + 1
      integer, parameter :: i_Grid9 = i_Grid8 + 1
      integer, parameter :: i_Other = i_Grid9 + 1
      
      integer, parameter :: num_pgstar_plots = i_Other + max_num_Other_plots

      integer, parameter :: max_num_pgstar_grid_plots = 10
      integer, parameter :: max_num_rows_Text_Summary = 20
      integer, parameter :: max_num_cols_Text_Summary = 20
      
      
      ! some Tioga colors for pgstar
      integer :: clr_Black
      integer :: clr_Blue
      integer :: clr_BrightBlue
      integer :: clr_Goldenrod
      integer :: clr_Lilac
      integer :: clr_Coral
      integer :: clr_FireBrick
      integer :: clr_RoyalPurple
      integer :: clr_Gold
      integer :: clr_Crimson
      integer :: clr_SlateGray
      integer :: clr_Teal
      integer :: clr_LightSteelBlue
      integer :: clr_MediumSlateBlue
      integer :: clr_MediumSpringGreen
      integer :: clr_MediumBlue
      integer :: clr_RoyalBlue
      integer :: clr_LightGray
      integer :: clr_Silver
      integer :: clr_DarkGray
      integer :: clr_Gray
      integer :: clr_LightSkyBlue
      integer :: clr_LightSkyGreen
      integer :: clr_SeaGreen
      integer :: clr_Tan
      integer :: clr_IndianRed
      integer :: clr_LightOliveGreen
      integer :: clr_CadetBlue
      integer :: clr_Beige

      integer, parameter :: max_num_pgstar_trace_history_values = 20

      
      type pgstar_hist_node
         real(dp) :: age
         integer :: step
         real(dp), pointer :: vals(:) ! values of items in history_columns list
         type (pgstar_hist_node), pointer :: next 
            ! list kept in strictly decreasing order by age & step
      end type pgstar_hist_node



      integer, parameter :: max_generations = 3
      integer, parameter :: net_name_len = strlen
      integer, parameter :: name_len = 80           
      integer, parameter :: max_num_mixing_regions = 100
      integer, parameter :: maxlen_history_column_name = 80
      integer, parameter :: maxlen_profile_column_name = maxlen_history_column_name

      integer, parameter :: max_num_accretion_species = 50

      integer, parameter :: max_num_diffusion_classes = 20      
      
      integer, parameter :: num_xa_function = 9           
      integer, parameter :: num_mesh_logX = 9
      
      integer, parameter :: num_xa_central_limits = 9
      integer, parameter :: num_xa_surface_limits = 9
      integer, parameter :: num_xa_average_limits = 9
      
      integer, parameter :: terminal_iounit = 6

      integer, parameter :: max_num_profile_mass_points = 10

      integer, parameter :: max_num_profile_extras = 100
      integer, parameter :: max_num_history_extras = 100

      integer, parameter :: num_x_ctrls = 100
      
      
      ! interfaces for procedure pointers
      abstract interface
      
      
      
      
         integer function id_only_function_interface(id)
            integer, intent(in) :: id
         end function id_only_function_interface
      
         subroutine id_only_subroutine_interface(id)
            integer, intent(in) :: id
         end subroutine id_only_subroutine_interface
      
      
         subroutine how_many_extra_header_items_interface( &
               id, id_extra, num_extra_header_items)
            integer, intent(in) :: id, id_extra
            integer, intent(out) :: num_extra_header_items
         end subroutine how_many_extra_header_items_interface
      
      
         subroutine extra_header_items_data_interface( &
               id, id_extra, num_extra_header_items, &
               extra_header_item_names, extra_header_item_vals, ierr)
            use const_def, only: dp
            integer, intent(in) :: id, id_extra, num_extra_header_items
            character (len=*), pointer :: extra_header_item_names(:)
            real(dp), pointer :: extra_header_item_vals(:)
            integer, intent(out) :: ierr
         end subroutine extra_header_items_data_interface
      
      
         subroutine other_wind_interface(id, Lsurf, Msurf, Rsurf, Tsurf, w, ierr)
            use const_def, only: dp
            integer, intent(in) :: id
            real(dp), intent(in) :: Lsurf, Msurf, Rsurf, Tsurf ! surface values (cgs)
            real(dp), intent(out) :: w ! wind in units of Msun/year (value is >= 0)
            integer, intent(out) :: ierr
         end subroutine other_wind_interface
      
      
         subroutine other_before_struct_burn_mix_interface(id, dt, res)
            use const_def, only: dp
            integer, intent(in) :: id
            real(dp), intent(in) :: dt
            integer, intent(out) :: res ! keep_going, redo, retry, backup, terminate
         end subroutine other_before_struct_burn_mix_interface
      
      
         subroutine other_after_struct_burn_mix_interface(id, dt, res)
            use const_def, only: dp
            integer, intent(in) :: id
            real(dp), intent(in) :: dt
            integer, intent(out) :: res ! keep_going, redo, retry, backup, terminate
         end subroutine other_after_struct_burn_mix_interface
      
      
         subroutine other_adjust_net_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_adjust_net_interface
      
      
         subroutine other_adjust_mdot_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_adjust_mdot_interface
      
      
         subroutine other_split_mix_interface( &
               id, dt_total, species, pass, num_passes, result_code, ierr)
            use const_def, only: dp
            integer, intent(in) :: id
            real(dp), intent(in) :: dt_total 
            integer, intent(in) :: species, pass, num_passes
            integer, intent(out) :: result_code, ierr
            ! result_code is keep_going, retry, or terminate
            ! ierr /= 0 is equivalent to result_code = terminate
         end subroutine other_split_mix_interface
      
      
         subroutine other_D_mix_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_D_mix_interface
      
      
         subroutine other_am_mixing_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_am_mixing_interface


         subroutine other_paquette_coefficients_interface( &
               id, k, nc, m, rho, T, A, X, Z, C, charge, na, &
               Ddiff, Kdiff, Zdiff, Zdiff1, Zdiff2, Ath)
            use const_def, only: dp
            integer, intent(in) :: id, k, nc, m  
            real(dp), intent(in) :: rho, T, charge(m), na(m)
            real(dp), intent(in), dimension(:) :: A, X, Z, C ! (m)
            real(dp), intent(inout), dimension(m,m) :: &
               Ddiff, Kdiff, Zdiff, Zdiff1, Zdiff2, Ath
         end subroutine other_paquette_coefficients_interface
      
      
         subroutine other_momentum_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_momentum_interface
      
      
         subroutine other_energy_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_energy_interface
      
      
         subroutine other_energy_implicit_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_energy_implicit_interface
      
      
         subroutine other_brunt_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_brunt_interface
      
      
         subroutine other_brunt_smoothing_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_brunt_smoothing_interface
      
      
         subroutine other_build_initial_model_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_build_initial_model_interface
      
      
         subroutine other_torque_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_torque_interface
      
      
         subroutine other_torque_implicit_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_torque_implicit_interface
      
      
         subroutine other_cgrav_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_cgrav_interface
      
      
         subroutine other_eps_grav_interface(id, k, dt, ierr)
            use const_def, only: dp
            integer, intent(in) :: id, k
            real(dp), intent(in) :: dt
            integer, intent(out) :: ierr
         end subroutine other_eps_grav_interface
      
      
         subroutine other_opacity_factor_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_opacity_factor_interface
      
      
         subroutine other_newton_monitor_interface( &
               id, iter, passed_tol_tests, &
               correction_norm, max_correction, &
               residual_norm, max_residual, ierr)
            use const_def, only: dp
            integer, intent(in) :: id, iter 
            logical, intent(in) :: passed_tol_tests
            real(dp), intent(in) :: correction_norm, max_correction, &
               residual_norm, max_residual
            integer, intent(out) :: ierr
         end subroutine other_newton_monitor_interface


         subroutine other_neu_interface(  &
               id, k, T, log10_T, Rho, log10_Rho, abar, zbar, z2bar, log10_Tlim, flags, &
               loss, sources, ierr)
            use const_def, only: dp
            use neu_def, only: num_neu_types, num_neu_rvs
            integer, intent(in) :: id ! id for star         
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            real(dp), intent(in) :: T ! temperature
            real(dp), intent(in) :: log10_T ! log10 of temperature
            real(dp), intent(in) :: Rho ! density
            real(dp), intent(in) :: log10_Rho ! log10 of density
            real(dp), intent(in) :: abar ! mean atomic weight
            real(dp), intent(in) :: zbar ! mean charge
            real(dp), intent(in) :: z2bar ! mean charge squared
            real(dp), intent(in) :: log10_Tlim 
            logical, intent(inout) :: flags(num_neu_types) ! true if should include the type of loss
            real(dp), intent(out) :: loss(num_neu_rvs) ! total from all sources
            real(dp), intent(out) :: sources(num_neu_types, num_neu_rvs)
            integer, intent(out) :: ierr
         end subroutine other_neu_interface
      
      
         subroutine other_mlt_interface( &
               id, k, cgrav, m, r, T, rho, L, P, &
               chiRho, chiT, Cp, Cv, csound, X, opacity, grada, &
               gradr_factor, gradL_composition_term, &
               alpha_semiconvection, semiconvection_option, &
               thermohaline_coeff, thermohaline_option, &
               dominant_iso_for_thermohaline, &
               mixing_length_alpha, alt_scale_height, remove_small_D_limit, &
               MLT_option, Henyey_y_param, Henyey_nu_param, &
               prev_conv_vel, max_conv_vel, g_theta, dt, tau, MLT_dbg, &
               mixing_type, mlt_basics, mlt_partials1, ierr)
            use const_def, only: dp
            integer, intent(in) :: id ! id for star         
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            real(dp), intent(in) :: cgrav, m, r, T, Rho, L, P
            real(dp), intent(in) :: chiRho, chiT, Cp, Cv, csound, X, opacity, grada, gradr_factor
            real(dp), intent(in) :: gradL_composition_term
            real(dp), intent(in) :: alpha_semiconvection, thermohaline_coeff
            real(dp), intent(in) :: mixing_length_alpha
            logical, intent(in) :: alt_scale_height
            character (len=*), intent(in) :: &
               semiconvection_option, thermohaline_option, MLT_option
            integer, intent(in) :: dominant_iso_for_thermohaline
            real(dp), intent(in) :: Henyey_y_param, Henyey_nu_param, &
               prev_conv_vel, max_conv_vel, g_theta, dt, tau, remove_small_D_limit
            logical, intent(in) :: MLT_dbg
            integer, intent(out) :: mixing_type ! none, convective, semiconvective, or salt finger
            real(dp), intent(out) :: mlt_basics(:) ! (num_mlt_results)
            real(dp), intent(out), pointer :: mlt_partials1(:) ! =(num_mlt_partials, num_mlt_results)
               ! e.g., mlt_partials(mlt_dlnT,mlt_gradT) has partial wrt lnT of gradT
            integer, intent(out) :: ierr
         end subroutine other_mlt_interface
      
      
         subroutine other_atm_interface( &
               id, M, R, L, X, Z, kap, Teff, &
               lnT, dlnT_dL, dlnT_dlnR, dlnT_dlnM, dlnT_dlnkap, &
               lnP, dlnP_dL, dlnP_dlnR, dlnP_dlnM, dlnP_dlnkap, &
               which_atm_option, switch_to_grey_as_backup, ierr)
            use const_def, only: dp
            integer, intent(in) :: id ! star id if available; 0 otherwise
            ! cgs units
            real(dp), intent(in) :: M ! enclosed mass at photosphere
            real(dp), intent(in) :: R ! radius at photosphere
            real(dp), intent(in) :: L ! luminosity at photosphere
            real(dp), intent(in) :: X ! hydrogen mass fraction
            real(dp), intent(in) :: Z ! metallicity
            real(dp), intent(in) :: kap 
               ! opacity above photosphere (average by mass)
               ! only used for grey atm approximation.
            real(dp), intent(out) :: Teff ! temperature at photosphere
            real(dp), intent(out) :: lnT ! natural log of temperature at base of atmosphere
            real(dp), intent(out) :: lnP ! natural log of pressure at base of atmosphere (Pgas + Prad)
            ! partial derivatives of lnT and lnP
            real(dp), intent(out) :: dlnT_dL, dlnT_dlnR, dlnT_dlnM, dlnT_dlnkap
            real(dp), intent(out) :: dlnP_dL, dlnP_dlnR, dlnP_dlnM, dlnP_dlnkap
            integer, intent(in) :: which_atm_option
               ! atm_simple_photosphere or one of the options for tables
               ! T(tau) integration is not supported in this routine -- call atm_int_T_tau instead
            logical, intent(in) :: switch_to_grey_as_backup
               ! if you select a table option, but the args are out of the range of the tables,
               ! then this flag determines whether you get an error or the code automatically
               ! switches to option = atm_simple_photosphere as a backup.
            integer, intent(out) :: ierr  ! == 0 means AOK
         end subroutine other_atm_interface
      
      
         subroutine other_adjust_mlt_gradT_fraction_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_adjust_mlt_gradT_fraction_interface
      
      
         subroutine other_after_set_mixing_info_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_after_set_mixing_info_interface
      
      
         subroutine other_diffusion_interface(id, dt, ierr)
            use const_def, only: dp
            integer, intent(in) :: id
            real(dp), intent(in) :: dt 
            integer, intent(out) :: ierr
         end subroutine other_diffusion_interface


         subroutine other_eosDT_get_interface( &
                 id, k, handle, Z, X, abar, zbar, & 
                 species, chem_id, net_iso, xa, &
                 Rho, log10Rho, T, log10T, & 
                 res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                 d_dabar_const_TRho, d_dzbar_const_TRho, ierr)
            use const_def, only: dp

            ! INPUT
         
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle ! eos handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: Rho, log10Rho ! the density
               ! provide both if you have them.  else pass one and set the other to arg_not_provided
               ! "arg_not_provided" is defined in mesa const_def
            
            real(dp), intent(in) :: T, log10T ! the temperature
               ! provide both if you have them.  else pass one and set the other to arg_not_provided
                     
            ! OUTPUT
         
            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            ! partial derivatives of the basic results wrt lnd and lnT
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results)  
            ! d_dlnRho_c_T(i) = d(res(i))/dlnd|T
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results) 
            ! d_dlnT(i) = d(res(i))/dlnT|Rho
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 
         
            integer, intent(out) :: ierr ! 0 means AOK.
         
         end subroutine other_eosDT_get_interface
      
      
         subroutine other_eosPT_get_interface(&
                  id, k, handle, Z, X, abar, zbar, &
                  species, chem_id, net_iso, xa,&
                  Pgas, log10Pgas, T, log10T, &
                  Rho, log10Rho, dlnRho_dlnPgas_const_T, dlnRho_dlnT_const_Pgas, &
                  res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, ierr)
            use const_def, only: dp

            ! INPUT
         
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: Pgas, log10Pgas ! the gas pressure
               ! provide both if you have them.  else pass one and set the other to arg_not_provided
               ! "arg_not_provided" is defined in mesa const_def
            
            real(dp), intent(in) :: T, log10T ! the temperature
               ! provide both if you have them.  else pass one and set the other to arg_not_provided
                     
            ! OUTPUT
         
            real(dp), intent(out) :: Rho, log10Rho ! density
            real(dp), intent(out) :: dlnRho_dlnPgas_const_T
            real(dp), intent(out) :: dlnRho_dlnT_const_Pgas
            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            ! partial derivatives of the basic results wrt lnd and lnT
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results) 
            ! d_dlnRho_const_T(i) = d(res(i))/dlnd|T
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results) 
            ! d_dlnT_const_Rho(i) = d(res(i))/dlnT|Rho
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 
         
            integer, intent(out) :: ierr ! 0 means AOK.
         
         end subroutine other_eosPT_get_interface
         
         
         subroutine other_eosDE_get_interface( &
                  handle, Z, X, abar, zbar,  &
                  species, chem_id, net_iso, xa, &
                  energy, log10E, rho, log10Rho, log10T_guess, &
                  T, log10T, res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, ierr)

            use eos_def

            ! INPUT
         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: energy, log10E ! the internal energy
               ! provide both if you have them.  else pass one and set the other to arg_not_provided
               ! "arg_not_provided" is defined in mesa const_def
            
            real(dp), intent(in) :: Rho, log10Rho ! the density
               ! provide both if you have them.  else pass one and set the other to arg_not_provided
            
            real(dp), intent(in) :: log10T_guess ! guess for logT to use if off table
                     
            ! OUTPUT
         
            real(dp), intent(out) :: T, log10T
         
            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
         
            ! partial derivatives of the basic results
         
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results) 
            ! d_dlnRho_const_T(i) = d(res(i))/dlnd|T,X where X = composition
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results) 
            ! d_dlnT(i) = d(res(i))/dlnT|Rho,X where X = composition

            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            ! d_dabar(i) = d(res(i))/dabar|TRho,zbar
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 
            ! d_dzbar(i) = d(res(i))/dzbar|TRho,abar
         
            integer, intent(out) :: ierr ! 0 means AOK.

         end subroutine other_eosDE_get_interface
      
      
         subroutine other_eosDT_get_T_interface( &
                  id, k, handle, Z, X, abar, zbar, &
                  species, chem_id, net_iso, xa, &
                  logRho, which_other, other_value, &
                  logT_tol, other_tol, max_iter, logT_guess, & 
                  logT_bnd1, logT_bnd2, other_at_bnd1, other_at_bnd2, &
                  logT_result, res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, &
                  eos_calls, ierr)
     
            ! finds log10 T given values for density and 'other', and initial guess for temperature.
            ! does up to max_iter attempts until logT changes by less than tol.
         
            ! 'other' can be any of the basic result variables for the eos
            ! specify 'which_other' by means of the definitions in eos_def (e.g., i_lnE)
         
            use const_def, only: dp

            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: logRho ! log10 of density
            integer, intent(in) :: which_other ! from eos_def.  e.g., i_lnE
            real(dp), intent(in) :: other_value ! desired value for the other variable
            real(dp), intent(in) :: other_tol
         
            real(dp), intent(in) :: logT_tol
            integer, intent(in) :: max_iter ! max number of iterations        

            real(dp), intent(in) :: logT_guess ! log10 of temperature
            real(dp), intent(in) :: logT_bnd1, logT_bnd2 ! bounds for logT
               ! if don't know bounds, just set to arg_not_provided (defined in const_def)
            real(dp), intent(in) :: other_at_bnd1, other_at_bnd2 ! values at bounds
               ! if don't know these values, just set to arg_not_provided (defined in const_def)

            real(dp), intent(out) :: logT_result ! log10 of temperature
            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 
         
            integer, intent(out) :: eos_calls
            integer, intent(out) :: ierr ! 0 means AOK.

         end subroutine other_eosDT_get_T_interface
      

         subroutine other_eosDT_get_Rho_interface( &
                  id, k, handle, Z, X, abar, zbar, &
                  species, chem_id, net_iso, xa, &
                  logT, which_other, other_value, &
                  logRho_tol, other_tol, max_iter, logRho_guess,  &
                  logRho_bnd1, logRho_bnd2, other_at_bnd1, other_at_bnd2, &
                  logRho_result, res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, &
                  eos_calls, ierr)
     
            ! finds log10 Rho given values for temperature and 'other', and initial guess for density.
            ! does up to max_iter attempts until logRho changes by less than tol.
         
            ! 'other' can be any of the basic result variables for the eos
            ! specify 'which_other' by means of the definitions in eos_def (e.g., i_lnE)
         
            use const_def, only: dp
         
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: logT ! log10 of temperature

            integer, intent(in) :: which_other ! from eos_def.  e.g., i_lnE
            real(dp), intent(in) :: other_value ! desired value for the other variable
            real(dp), intent(in) :: other_tol
         
            real(dp), intent(in) :: logRho_tol

            integer, intent(in) :: max_iter ! max number of Newton iterations        

            real(dp), intent(in) :: logRho_guess ! log10 of density
            real(dp), intent(in) :: logRho_bnd1, logRho_bnd2 ! bounds for logRho
               ! if don't know bounds, just set to arg_not_provided (defined in const_def)
            real(dp), intent(in) :: other_at_bnd1, other_at_bnd2 ! values at bounds
               ! if don't know these values, just set to arg_not_provided (defined in const_def)

            real(dp), intent(out) :: logRho_result ! log10 of density

            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 

            integer, intent(out) :: eos_calls
            integer, intent(out) :: ierr ! 0 means AOK.

         end subroutine other_eosDT_get_Rho_interface
      
      
         subroutine other_eosPT_get_T_interface( &
                  id, k, handle, Z, X, abar, zbar, &
                  species, chem_id, net_iso, xa,&
                  logPgas, which_other, other_value,&
                  logT_tol, other_tol, max_iter, logT_guess, &
                  logT_bnd1, logT_bnd2, other_at_bnd1, other_at_bnd2,&
                  logT_result, Rho, log10Rho, dlnRho_dlnPgas_const_T, dlnRho_dlnT_const_Pgas, &
                  res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, eos_calls, ierr)
     
            ! finds log10 T given values for gas pressure and 'other',
            ! and initial guess for temperature.
            ! does up to max_iter attempts until logT changes by less than tol.
         
            ! 'other' can be any of the basic result variables for the eos
            ! specify 'which_other' by means of the definitions in eos_def (e.g., i_lnE)
         
            use const_def, only: dp
         
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: logPgas ! log10 of gas pressure
            integer, intent(in) :: which_other ! from eos_def.  e.g., i_lnE
            real(dp), intent(in) :: other_value ! desired value for the other variable
            real(dp), intent(in) :: other_tol
         
            real(dp), intent(in) :: logT_tol
            integer, intent(in) :: max_iter ! max number of iterations        

            real(dp), intent(in) :: logT_guess ! log10 of temperature
            real(dp), intent(in) :: logT_bnd1, logT_bnd2 ! bounds for logT
               ! if don't know bounds, just set to arg_not_provided (defined in const_def)
            real(dp), intent(in) :: other_at_bnd1, other_at_bnd2 ! values at bounds
               ! if don't know these values, just set to arg_not_provided (defined in const_def)

            real(dp), intent(out) :: logT_result ! log10 of temperature
            real(dp), intent(out) :: Rho, log10Rho ! density
            real(dp), intent(out) :: dlnRho_dlnPgas_const_T
            real(dp), intent(out) :: dlnRho_dlnT_const_Pgas

            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 
         
            integer, intent(out) :: eos_calls
            integer, intent(out) :: ierr ! 0 means AOK.

         end subroutine other_eosPT_get_T_interface
      
      
         subroutine other_eosPT_get_Pgas_interface(&
                  id, k, handle, Z, X, abar, zbar, &
                  species, chem_id, net_iso, xa,&
                  logT, which_other, other_value,&
                  logPgas_tol, other_tol, max_iter, logPgas_guess, &
                  logPgas_bnd1, logPgas_bnd2, other_at_bnd1, other_at_bnd2,&
                  logPgas_result, Rho, log10Rho, dlnRho_dlnPgas_const_T, dlnRho_dlnT_const_Pgas, &
                  res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, eos_calls, ierr)
     
            ! finds log10 Pgas given values for temperature and 'other', and initial guess for gas pressure.
            ! does up to max_iter attempts until logPgas changes by less than tol.
         
            ! 'other' can be any of the basic result variables for the eos
            ! specify 'which_other' by means of the definitions in eos_def (e.g., i_lnE)
         
            use const_def, only: dp
         
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: logT ! log10 of temperature

            integer, intent(in) :: which_other ! from eos_def.  e.g., i_lnE
            real(dp), intent(in) :: other_value ! desired value for the other variable
            real(dp), intent(in) :: other_tol
         
            real(dp), intent(in) :: logPgas_tol

            integer, intent(in) :: max_iter ! max number of Newton iterations        

            real(dp), intent(in) :: logPgas_guess ! log10 of gas pressure
            real(dp), intent(in) :: logPgas_bnd1, logPgas_bnd2 ! bounds for logPgas
               ! if don't know bounds, just set to arg_not_provided (defined in const_def)
            real(dp), intent(in) :: other_at_bnd1, other_at_bnd2 ! values at bounds
               ! if don't know these values, just set to arg_not_provided (defined in const_def)

            real(dp), intent(out) :: logPgas_result ! log10 of gas pressure
            real(dp), intent(out) :: Rho, log10Rho ! density
            real(dp), intent(out) :: dlnRho_dlnPgas_const_T
            real(dp), intent(out) :: dlnRho_dlnT_const_Pgas

            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 

            integer, intent(out) :: eos_calls
            integer, intent(out) :: ierr
         
         end subroutine other_eosPT_get_Pgas_interface


         subroutine other_eosPT_get_Pgas_for_Rho_interface(&
                  id, k, handle, Z, X, abar, zbar, &
                  species, chem_id, net_iso, xa,&
                  logT, logRho_want,&
                  logPgas_tol, logRho_tol, max_iter, logPgas_guess, &
                  logPgas_bnd1, logPgas_bnd2, logRho_at_bnd1, logRho_at_bnd2,&
                  logPgas_result, Rho, logRho, dlnRho_dlnPgas_const_T, dlnRho_dlnT_const_Pgas, &
                  res, d_dlnRho_const_T, d_dlnT_const_Rho, &
                  d_dabar_const_TRho, d_dzbar_const_TRho, eos_calls, ierr)
     
            ! finds log10 Pgas given values for temperature and density, and initial guess for gas pressure.
            ! does up to max_iter attempts until logPgas changes by less than tol.
         
            use const_def, only: dp
         
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle

            real(dp), intent(in) :: Z ! the metals mass fraction
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            
            real(dp), intent(in) :: abar
               ! mean atomic number (nucleons per nucleus; grams per mole)
            real(dp), intent(in) :: zbar ! mean charge per nucleus
         
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            real(dp), intent(in) :: logT ! log10 of temperature

            real(dp), intent(in) :: logRho_want ! log10 of desired density
            real(dp), intent(in) :: logRho_tol
         
            real(dp), intent(in) :: logPgas_tol

            integer, intent(in) :: max_iter ! max number of Newton iterations        

            real(dp), intent(in) :: logPgas_guess ! log10 of gas pressure
            real(dp), intent(in) :: logPgas_bnd1, logPgas_bnd2 ! bounds for logPgas
               ! if don't know bounds, just set to arg_not_provided (defined in const_def)
            real(dp), intent(in) :: logRho_at_bnd1, logRho_at_bnd2 ! values at bounds
               ! if don't know these values, just set to arg_not_provided (defined in const_def)

            real(dp), intent(out) :: logPgas_result ! log10 of gas pressure
            real(dp), intent(out) :: Rho, logRho ! density corresponding to logPgas_result
            real(dp), intent(out) :: dlnRho_dlnPgas_const_T
            real(dp), intent(out) :: dlnRho_dlnT_const_Pgas

            real(dp), intent(out) :: res(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnRho_const_T(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dlnT_const_Rho(:) ! (num_eos_basic_results)
            real(dp), intent(out) :: d_dabar_const_TRho(:) ! (num_eos_basic_results) 
            real(dp), intent(out) :: d_dzbar_const_TRho(:) ! (num_eos_basic_results) 

            integer, intent(out) :: eos_calls
            integer, intent(out) :: ierr
         
         end subroutine other_eosPT_get_Pgas_for_Rho_interface
      

         subroutine other_kap_get_Type1_interface( &
               id, k, handle, zbar, X, Zbase, log10_rho, log10_T,  &
               species, chem_id, net_iso, xa, &
               lnfree_e, d_lnfree_e_dlnRho, d_lnfree_e_dlnT, &
               kap, dln_kap_dlnRho, dln_kap_dlnT, ierr)
         
            use const_def, only: dp
 
            ! INPUT
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle ! from alloc_kap_handle
            real(dp), intent(in) :: zbar ! average ion charge
            real(dp), intent(in) :: X ! the hydrogen mass fraction
            real(dp), intent(in) :: Zbase ! the metallicity
            real(dp), intent(in) :: log10_rho ! the density
            real(dp), intent(in) :: log10_T ! the temperature
            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
            double precision, intent(in) :: lnfree_e, d_lnfree_e_dlnRho, d_lnfree_e_dlnT
               ! free_e := total combined number per nucleon of free electrons and positrons
         
            ! OUTPUT
            real(dp), intent(out) :: kap ! opacity
            real(dp), intent(out) :: dln_kap_dlnRho ! partial derivative at constant T
            real(dp), intent(out) :: dln_kap_dlnT   ! partial derivative at constant Rho
            integer, intent(out) :: ierr

         end subroutine other_kap_get_Type1_interface
           

         subroutine other_kap_get_Type2_interface( &
               id, k, handle, zbar, X, Z, Zbase, XC, XN, XO, XNe, &
               log10_rho, log10_T, species, chem_id, net_iso, xa, &
               lnfree_e, d_lnfree_e_dlnRho, d_lnfree_e_dlnT, &
               frac_Type2, kap, dln_kap_dlnRho, dln_kap_dlnT, ierr)
      
            use const_def, only: dp
 
            ! INPUT
            integer, intent(in) :: id ! star id if available; 0 otherwise
            integer, intent(in) :: k ! cell number or 0 if not for a particular cell         
            integer, intent(in) :: handle ! from alloc_kap_handle
            real(dp), intent(in) :: zbar ! average ion charge
            real(dp), intent(in) :: X, Z, Zbase, XC, XN, XO, XNe ! composition    
            real(dp), intent(in) :: log10_rho ! density
            real(dp), intent(in) :: log10_T ! temperature
            real(dp), intent(in) :: lnfree_e, d_lnfree_e_dlnRho, d_lnfree_e_dlnT
               ! free_e := total combined number per nucleon of free electrons and positrons

            integer, intent(in) :: species
            integer, pointer :: chem_id(:) ! maps species to chem id
               ! index from 1 to species
               ! value is between 1 and num_chem_isos         
            integer, pointer :: net_iso(:) ! maps chem id to species number
               ! index from 1 to num_chem_isos (defined in chem_def)
               ! value is 0 if the iso is not in the current net
               ! else is value between 1 and number of species in current net
            real(dp), intent(in) :: xa(:) ! mass fractions
         
            ! OUTPUT
            real(dp), intent(out) :: frac_Type2
            real(dp), intent(out) :: kap ! opacity
            real(dp), intent(out) :: dln_kap_dlnRho ! partial derivative at constant T
            real(dp), intent(out) :: dln_kap_dlnT   ! partial derivative at constant Rho
            integer, intent(out) :: ierr ! 0 means AOK.

         end subroutine other_kap_get_Type2_interface
      
      
         subroutine other_kap_get_op_mono_interface( &
               handle, zbar, log10_rho, log10_T, &
               lnfree_e, d_lnfree_e_dlnRho, d_lnfree_e_dlnT, &
               ! args for op_mono
               use_op_mono_alt_get_kap, &
               nel, izzp, fap, screening, umesh, ff, rs, ss, &
               ! output
               kap, dlnkap_dlnRho, dlnkap_dlnT, ierr)
            use const_def, only: dp
            integer, intent(in) :: handle ! from alloc_kap_handle
            real(dp), intent(in) :: zbar
            real(dp), intent(in) :: log10_rho ! the density
            real(dp), intent(in) :: log10_T ! the temperature
            real(dp), intent(in) :: lnfree_e, d_lnfree_e_dlnRho, d_lnfree_e_dlnT
            ! args for op_mono_get_kap
            logical, intent(in) :: use_op_mono_alt_get_kap
            integer, intent(in) :: nel
            integer, intent(in) :: izzp(:) ! (nel)
            real(dp), intent(in) :: fap(:) ! (nel)
            logical, intent(in) :: screening
            ! work arrays
            real, pointer :: umesh(:), ff(:,:,:,:), rs(:,:,:), ss(:,:,:,:)
               ! umesh(nptot)
               ! ff(nptot, ipe, 4, 4)
               ! rs(nptot, 4, 4)
               ! ss(nptot, nrad, 4, 4)
            ! output
            real(dp), intent(out) :: kap ! opacity
            real(dp), intent(out) :: dlnkap_dlnRho
            real(dp), intent(out) :: dlnkap_dlnT
            integer, intent(out) :: ierr ! 0 means AOK.
         end subroutine other_kap_get_op_mono_interface
      
      
         subroutine other_pgstar_plots_info_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_pgstar_plots_info_interface

      
         subroutine how_many_other_mesh_fcns_interface(id, n)
            integer, intent(in) :: id
            integer, intent(out) :: n
         end subroutine how_many_other_mesh_fcns_interface
      
      
         subroutine other_mesh_fcn_data_interface( &
               id, nfcns, names, gval_is_xa_function, vals1, ierr)
            use const_def, only: dp
            integer, intent(in) :: id
            integer, intent(in) :: nfcns
            character (len=*) :: names(:)
            logical, intent(out) :: gval_is_xa_function(:) ! (nfcns)
            real(dp), pointer :: vals1(:) ! =(nz, nfcns)
            integer, intent(out) :: ierr
         end subroutine other_mesh_fcn_data_interface
      
      
         subroutine other_write_pulsation_info_interface( &
               id, add_center_point, keep_surface_point, &
               add_atmosphere, filename, ierr)
            integer, intent(in) :: id
            logical, intent(in) :: &
               add_center_point, keep_surface_point, &
               add_atmosphere
            character (len=*), intent(in) :: filename
            integer, intent(out) :: ierr 
         end subroutine other_write_pulsation_info_interface
      
      
         subroutine other_get_pulsation_info_interface(id, &
               add_center_point, keep_surface_point, &
               add_atmosphere, nn, iconst, ivar, glob, var, ierr)
            use const_def, only: dp
            integer, intent(in) :: id
            logical, intent(in) :: &
               add_center_point, keep_surface_point, &
               add_atmosphere
            integer, intent(out) :: nn, iconst, ivar
            real(dp), pointer :: glob(:) ! (iconst) -- will be allocated
            real(dp), pointer :: var(:,:) ! (ivar,nn) -- will be allocated
            integer, intent(out) :: ierr
         end subroutine other_get_pulsation_info_interface
      
      
         subroutine other_surface_PT_interface(id, &
               which_atm_option, off_table_option, r_phot, L_surf, skip_partials, &
               Teff, lnT_surf, dlnT_dL, dlnT_dlnR, dlnT_dlnM, dlnT_dlnkap, &
               lnP_surf, dlnP_dL, dlnP_dlnR, dlnP_dlnM, dlnP_dlnkap, ierr)
            use const_def, only: dp
            integer, intent(in) :: id, which_atm_option, off_table_option
            real(dp), intent(in) :: r_phot, L_surf
            logical, intent(in) :: skip_partials
            real(dp), intent(out) :: Teff, &
               lnT_surf, dlnT_dL, dlnT_dlnR, dlnT_dlnM, dlnT_dlnkap, &
               lnP_surf, dlnP_dL, dlnP_dlnR, dlnP_dlnM, dlnP_dlnkap
            integer, intent(out) :: ierr
         end subroutine other_surface_PT_interface
      
      
         subroutine other_history_data_initialize_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_history_data_initialize_interface
      
      
         subroutine other_history_data_add_model_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_history_data_add_model_interface
      
      
         subroutine other_photo_write_interface(id, iounit)
            integer, intent(in) :: id, iounit
         end subroutine other_photo_write_interface
      
      
         subroutine other_photo_read_interface(id, iounit, ierr)
            integer, intent(in) :: id, iounit
            integer, intent(out) :: ierr
         end subroutine other_photo_read_interface
      
      
         subroutine other_new_generation_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_new_generation_interface
      
      
         subroutine other_restore_older_interface(id)
            integer, intent(in) :: id
         end subroutine other_restore_older_interface
      
      
         subroutine other_set_current_to_old_interface(id)
            integer, intent(in) :: id
         end subroutine other_set_current_to_old_interface
      
      
         subroutine other_astero_freq_corr_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine other_astero_freq_corr_interface

      
         integer function how_many_extra_history_columns_interface(id, id_extra)
            integer, intent(in) :: id, id_extra
         end function how_many_extra_history_columns_interface
      
      
         subroutine data_for_extra_history_columns_interface( &
               id, id_extra, n, names, vals, ierr)
            use const_def, only: dp
            integer, intent(in) :: id, id_extra, n
            character (len=80) :: names(n)
            real(dp) :: vals(n)
            integer, intent(out) :: ierr
         end subroutine data_for_extra_history_columns_interface

      
         integer function how_many_extra_profile_columns_interface(id, id_extra)
            integer, intent(in) :: id, id_extra
         end function how_many_extra_profile_columns_interface
      
      
         subroutine data_for_extra_profile_columns_interface( &
               id, id_extra, n, nz, names, vals, ierr)
            use const_def, only: dp
            integer, intent(in) :: id, id_extra, n, nz
            character (len=80) :: names(n)
            real(dp) :: vals(nz,n)
            integer, intent(out) :: ierr
         end subroutine data_for_extra_profile_columns_interface

      
         integer function how_many_binary_history_columns_interface(binary_id)
            integer, intent(in) :: binary_id
         end function how_many_binary_history_columns_interface
      
      
         subroutine data_for_binary_history_columns_interface( &
               binary_id, n, names, vals, ierr)
            use const_def, only: dp
            integer, intent(in) :: binary_id, n
            character (len=80) :: names(n)
            real(dp) :: vals(n)
            integer, intent(out) :: ierr
         end subroutine data_for_binary_history_columns_interface
           

         subroutine get_gyre_model_interface( &
               id, keep_surface_point, add_atmosphere, &
               M_star, R_star, L_star, r, w, L, p, rho, T, &
               N2, Gamma_1, nabla_ad, delta, nabla,  &
               kappa, kappa_rho, kappa_T, &
               epsilon, epsilon_rho, epsilon_T, omega, ierr)
            use const_def, only: dp
            integer, intent(in) :: id
            logical, intent(in) :: keep_surface_point, add_atmosphere
            real(dp), intent(out) :: M_star, R_star, L_star
            ! arrays will be allocated; caller must deallocate when done with them
            real(dp), dimension(:), pointer :: &
               r, w, L, p, rho, T, &
               N2, Gamma_1, nabla_ad, delta, nabla,  &
               kappa, kappa_rho, kappa_T, &
               epsilon, epsilon_rho, epsilon_T, omega
            integer, intent(out) :: ierr
         end subroutine get_gyre_model_interface
           

         subroutine edit_gyre_info_interface( &
               id, nn, keep_surface_point, add_atmosphere, &
               M_star, R_star, L_star, r, w, L, p, rho, T, &
               N2, Gamma_1, nabla_ad, delta, nabla,  &
               kappa, kappa_rho, kappa_T, &
               epsilon, epsilon_rho, epsilon_T, omega, ierr)
            use const_def, only: dp
            integer, intent(in) :: id, nn ! nn is number of points
            logical, intent(in) :: keep_surface_point, add_atmosphere
            real(dp), intent(in) :: M_star, R_star, L_star
            real(dP), intent(inout), dimension(:) :: &
               r, w, L, p, rho, T, &
               N2, Gamma_1, nabla_ad, delta, nabla,  &
               kappa, kappa_rho, kappa_T, &
               epsilon, epsilon_rho, epsilon_T, omega
            integer, intent(out) :: ierr
         end subroutine edit_gyre_info_interface
           

         subroutine edit_pulsation_info_interface( &
               id, nn, iconst, ivar, &
               add_center_point, keep_surface_point, add_atmosphere, &
               glob, var, ierr)
            use const_def, only: dp
            integer, intent(in) :: id, nn, iconst, ivar
            logical, intent(in) :: &
               add_center_point, keep_surface_point, add_atmosphere
            real(dP), intent(inout) :: glob(:), var(:,:)
            integer, intent(out) :: ierr
         end subroutine edit_pulsation_info_interface
      
      
         subroutine binary_other_torque_implicit_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine binary_other_torque_implicit_interface
      
      
         subroutine binary_other_torque_interface(id, ierr)
            integer, intent(in) :: id
            integer, intent(out) :: ierr
         end subroutine binary_other_torque_interface
         
         
      end interface

