! ***********************************************************************
!
!   Copyright (C) 2014  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module star_profile_def
      
      use star_def
      use crlibm_lib

      implicit none
      
   ! profile column options

      ! abundances -- names from chem_Name array in chem_def
      ! nuclear reaction eps - names from reaction_Name array in rates_def
      ! nuclear reaction category eps - names from category_name array in net_def
      ! items specified in another file - include 'filename'
      ! star_data items from the following list

      integer, parameter :: p_zone = 1
      integer, parameter :: p_log_Lrad_div_Ledd = p_zone + 1
      integer, parameter :: p_log_Lrad_div_L = p_log_Lrad_div_Ledd + 1
      integer, parameter :: p_log_Lconv = p_log_Lrad_div_L + 1
      integer, parameter :: p_log_Lrad = p_log_Lconv + 1
      integer, parameter :: p_lum_conv = p_log_Lrad + 1
      integer, parameter :: p_lum_conv_div_lum_Edd = p_lum_conv + 1
      integer, parameter :: p_lum_rad_div_L_Edd = p_lum_conv_div_lum_Edd + 1
      integer, parameter :: p_lum_rad_div_L_Edd_div_phi_Joss = p_lum_rad_div_L_Edd + 1
      integer, parameter :: p_lum_rad_div_L = p_lum_rad_div_L_Edd_div_phi_Joss + 1
      integer, parameter :: p_lum_conv_div_L = p_lum_rad_div_L + 1
      integer, parameter :: p_lum_conv_div_lum_rad = p_lum_conv_div_L + 1
      integer, parameter :: p_lum_rad = p_lum_conv_div_lum_rad + 1
      integer, parameter :: p_luminosity = p_lum_rad + 1
      integer, parameter :: p_log_g = p_luminosity + 1
      integer, parameter :: p_grav = p_log_g + 1
      integer, parameter :: p_r_div_g = p_grav + 1
      integer, parameter :: p_g_div_r = p_r_div_g + 1
      integer, parameter :: p_log_abs_eps_nuc_div_non_nuc_neu = p_g_div_r + 1
      integer, parameter :: p_eps_nuc_plus_nuc_neu = p_log_abs_eps_nuc_div_non_nuc_neu + 1
      integer, parameter :: p_eps_nuc_minus_non_nuc_neu = p_eps_nuc_plus_nuc_neu + 1
      integer, parameter :: p_net_nuclear_energy = p_eps_nuc_minus_non_nuc_neu + 1
      integer, parameter :: p_net_energy = p_net_nuclear_energy + 1
      integer, parameter :: p_logL = p_net_energy + 1
      integer, parameter :: p_log_Ledd = p_logL + 1
      integer, parameter :: p_log_L_div_Ledd = p_log_Ledd + 1
      integer, parameter :: p_signed_log_power = p_log_L_div_Ledd + 1
      integer, parameter :: p_vel_km_per_s = p_signed_log_power + 1
      integer, parameter :: p_velocity = p_vel_km_per_s + 1
      integer, parameter :: p_rmid = p_velocity + 1
      integer, parameter :: p_logR_cm = p_rmid + 1
      integer, parameter :: p_radius_cm = p_logR_cm + 1
      integer, parameter :: p_radius = p_radius_cm + 1
      integer, parameter :: p_logR = p_radius + 1
      integer, parameter :: p_log_q = p_logR + 1
      integer, parameter :: p_q = p_log_q + 1
      integer, parameter :: p_dq = p_q + 1
      
      integer, parameter :: p_avg_charge_H = p_dq + 1
      integer, parameter :: p_avg_charge_He = p_avg_charge_H + 1
      integer, parameter :: p_avg_charge_C = p_avg_charge_He + 1
      integer, parameter :: p_avg_charge_N = p_avg_charge_C + 1
      integer, parameter :: p_avg_charge_O = p_avg_charge_N + 1
      integer, parameter :: p_avg_charge_Ne = p_avg_charge_O + 1
      integer, parameter :: p_avg_charge_Mg = p_avg_charge_Ne + 1
      integer, parameter :: p_avg_charge_Si = p_avg_charge_Mg + 1
      integer, parameter :: p_avg_charge_Fe = p_avg_charge_Si + 1
      
      integer, parameter :: p_neutral_fraction_H = p_avg_charge_Fe + 1
      integer, parameter :: p_neutral_fraction_He = p_neutral_fraction_H + 1
      integer, parameter :: p_neutral_fraction_C = p_neutral_fraction_He + 1
      integer, parameter :: p_neutral_fraction_N = p_neutral_fraction_C + 1
      integer, parameter :: p_neutral_fraction_O = p_neutral_fraction_N + 1
      integer, parameter :: p_neutral_fraction_Ne = p_neutral_fraction_O + 1
      integer, parameter :: p_neutral_fraction_Mg = p_neutral_fraction_Ne + 1
      integer, parameter :: p_neutral_fraction_Si = p_neutral_fraction_Mg + 1
      integer, parameter :: p_neutral_fraction_Fe = p_neutral_fraction_Si + 1
      
      integer, parameter :: p_lum_rad_div_L_Edd_sub_fourPrad_div_PchiT = p_neutral_fraction_Fe + 1
      integer, parameter :: p_fourPrad_div_PchiT = p_lum_rad_div_L_Edd_sub_fourPrad_div_PchiT + 1
      integer, parameter :: p_conv_dP_term = p_fourPrad_div_PchiT + 1
      integer, parameter :: p_pturb_div_pgas_plus_prad = p_conv_dP_term + 1
      integer, parameter :: p_pgas_div_p = p_pturb_div_pgas_plus_prad + 1
      integer, parameter :: p_pgas_div_ptotal = p_pgas_div_p + 1

      integer, parameter :: p_dlnT_dlnE_c_Rho = p_pgas_div_ptotal + 1
      integer, parameter :: p_dlnPgas_dlnE_c_Rho = p_dlnT_dlnE_c_Rho + 1
      integer, parameter :: p_dlnP_dlnE_c_Rho = p_dlnPgas_dlnE_c_Rho + 1
      integer, parameter :: p_dlnT_dlnd_c_E = p_dlnP_dlnE_c_Rho + 1
      integer, parameter :: p_dlnPgas_dlnd_c_E = p_dlnT_dlnd_c_E + 1
      integer, parameter :: p_dlnP_dlnd_c_E = p_dlnPgas_dlnd_c_E + 1
      
      integer, parameter :: p_log_dmbar_m_div_r = p_dlnP_dlnd_c_E + 1
      integer, parameter :: p_dmbar_m_div_r = p_log_dmbar_m_div_r + 1
      integer, parameter :: p_m_div_r = p_dmbar_m_div_r + 1
      integer, parameter :: p_mass_grams = p_m_div_r + 1
      integer, parameter :: p_mass = p_mass_grams + 1
      integer, parameter :: p_mmid = p_mass + 1

      integer, parameter :: p_dm = p_mmid + 1
      integer, parameter :: p_dm_bar = p_dm + 1

      integer, parameter :: p_m_grav = p_dm_bar + 1
      integer, parameter :: p_mass_correction_factor = p_m_grav + 1
      integer, parameter :: p_m_grav_div_m_baryonic = p_mass_correction_factor + 1

      integer, parameter :: p_xm = p_m_grav_div_m_baryonic + 1
      integer, parameter :: p_logxq = p_xm + 1
      integer, parameter :: p_logxm = p_logxq + 1
      
      integer, parameter :: p_log_radial_depth = p_logxm + 1
      integer, parameter :: p_log_column_depth = p_log_radial_depth + 1
      integer, parameter :: p_rmid_div_R = p_log_column_depth + 1
      integer, parameter :: p_r_div_R = p_rmid_div_R + 1
      integer, parameter :: p_log_dr_div_rmid = p_r_div_R + 1
      integer, parameter :: p_dr_div_rmid = p_log_dr_div_rmid + 1
      integer, parameter :: p_log_dr = p_dr_div_rmid + 1

      integer, parameter :: p_sum_lnR_residual = p_log_dr + 1
      integer, parameter :: p_sum_lnd_residual = p_sum_lnR_residual + 1
      integer, parameter :: p_sum_E_residual = p_sum_lnd_residual + 1
      integer, parameter :: p_sum_v_residual = p_sum_E_residual + 1
      integer, parameter :: p_sum_structure_residuals = p_sum_v_residual + 1

      integer, parameter :: p_lnR_residual = p_sum_structure_residuals + 1
      integer, parameter :: p_lnd_residual = p_lnR_residual + 1
      integer, parameter :: p_dlnTdm_residual = p_lnd_residual + 1
      integer, parameter :: p_E_residual = p_dlnTdm_residual + 1
      integer, parameter :: p_v_residual = p_E_residual + 1
      
      integer, parameter :: p_log_lnR_residual = p_v_residual + 1
      integer, parameter :: p_log_lnd_residual = p_log_lnR_residual + 1
      integer, parameter :: p_log_dlnTdm_residual = p_log_lnd_residual + 1
      integer, parameter :: p_log_E_residual = p_log_dlnTdm_residual + 1
      integer, parameter :: p_log_v_residual = p_log_E_residual + 1
      
      integer, parameter :: p_dEdt_actual = p_log_v_residual + 1
      integer, parameter :: p_sum_check_dEdt_actual = p_dEdt_actual + 1
      integer, parameter :: p_check_dEdt_actual = p_sum_check_dEdt_actual + 1
      integer, parameter :: p_dEdt_expected = p_check_dEdt_actual + 1
      integer, parameter :: p_sum_check_dEdt_expected = p_dEdt_expected + 1
      integer, parameter :: p_check_dEdt_expected = p_sum_check_dEdt_expected + 1
      
      integer, parameter :: p_d_IE_dt_residual = p_check_dEdt_expected + 1
      integer, parameter :: p_log_d_IE_dt_residual = p_d_IE_dt_residual + 1
      integer, parameter :: p_d_KE_dt_residual = p_log_d_IE_dt_residual + 1
      integer, parameter :: p_log_d_KE_dt_residual = p_d_KE_dt_residual + 1
      integer, parameter :: p_d_PE_dt_residual = p_log_d_KE_dt_residual + 1
      integer, parameter :: p_log_d_PE_dt_residual = p_d_PE_dt_residual + 1
      integer, parameter :: p_sum_from_cntr_dEdt_residuals = p_log_d_PE_dt_residual + 1
      integer, parameter :: p_log_sum_from_cntr_dEdt_residuals = &
         p_sum_from_cntr_dEdt_residuals + 1

      integer, parameter :: p_dr_div_cs = p_log_sum_from_cntr_dEdt_residuals + 1
      integer, parameter :: p_log_dr_div_cs = p_dr_div_cs + 1
      integer, parameter :: p_dr_div_cs_yr = p_log_dr_div_cs + 1
      integer, parameter :: p_log_dr_div_cs_yr = p_dr_div_cs_yr + 1

      integer, parameter :: p_cell_collapse_time = p_log_dr_div_cs_yr + 1
      integer, parameter :: p_log_cell_collapse_time = p_cell_collapse_time + 1

      integer, parameter :: p_log_acoustic_depth = p_log_cell_collapse_time + 1
      integer, parameter :: p_log_acoustic_radius = p_log_acoustic_depth + 1
      integer, parameter :: p_acoustic_depth = p_log_acoustic_radius + 1
      integer, parameter :: p_acoustic_radius = p_acoustic_depth + 1
      integer, parameter :: p_acoustic_r_div_R_phot = p_acoustic_radius + 1
      
      integer, parameter :: p_grav_gr_factor = p_acoustic_r_div_R_phot + 1
      integer, parameter :: p_log_grav_gr_factor = p_grav_gr_factor + 1

      integer, parameter :: p_x = p_log_grav_gr_factor + 1
      integer, parameter :: p_log_x = p_x + 1
      integer, parameter :: p_y = p_log_x + 1
      integer, parameter :: p_log_y = p_y + 1
      integer, parameter :: p_z = p_log_y + 1
      integer, parameter :: p_log_z = p_z + 1
      
      integer, parameter :: p_logdq = p_log_z + 1
      integer, parameter :: p_dq_ratio = p_logdq + 1
      integer, parameter :: p_tau = p_dq_ratio + 1
      integer, parameter :: p_kap_frac_Type2 = p_tau + 1
      integer, parameter :: p_log_opacity = p_kap_frac_Type2 + 1
      integer, parameter :: p_energy = p_log_opacity + 1
      integer, parameter :: p_logM = p_energy + 1
      integer, parameter :: p_logtau = p_logM + 1
      integer, parameter :: p_temperature = p_logtau + 1
      integer, parameter :: p_logT = p_temperature + 1
      integer, parameter :: p_density = p_logT + 1
      integer, parameter :: p_rho = p_density + 1
      integer, parameter :: p_logRho = p_rho + 1
      integer, parameter :: p_pgas = p_logRho+ 1
      integer, parameter :: p_logPgas = p_pgas + 1
      integer, parameter :: p_prad = p_logPgas + 1
      integer, parameter :: p_pressure = p_prad + 1
      integer, parameter :: p_logP = p_pressure + 1
      integer, parameter :: p_logE = p_logP + 1
      integer, parameter :: p_grada = p_logE + 1
      integer, parameter :: p_dE_dRho = p_grada + 1
      integer, parameter :: p_cv = p_dE_dRho + 1
      integer, parameter :: p_cp = p_cv + 1
      integer, parameter :: p_thermal_time_to_surface = p_cp + 1
      integer, parameter :: p_log_thermal_time_to_surface = p_thermal_time_to_surface + 1
      integer, parameter :: p_log_CpT = p_log_thermal_time_to_surface + 1
      integer, parameter :: p_log_CpT_absMdot_div_L = p_log_CpT + 1
      integer, parameter :: p_logS = p_log_CpT_absMdot_div_L + 1
      integer, parameter :: p_logS_per_baryon = p_logS + 1
      integer, parameter :: p_gamma1 = p_logS_per_baryon + 1
      integer, parameter :: p_gamma3 = p_gamma1 + 1
      integer, parameter :: p_eta = p_gamma3 + 1
      integer, parameter :: p_theta_e = p_eta + 1
      integer, parameter :: p_gam = p_theta_e + 1
      integer, parameter :: p_mu = p_gam + 1
      integer, parameter :: p_v_div_r = p_mu + 1
      integer, parameter :: p_v_div_cs = p_v_div_r + 1
      integer, parameter :: p_v_div_csound = p_v_div_cs + 1
      integer, parameter :: p_csound_at_face = p_v_div_csound + 1
      integer, parameter :: p_csound = p_csound_at_face + 1
      integer, parameter :: p_dt_div_conv_tau = p_csound + 1
      integer, parameter :: p_scale_height = p_dt_div_conv_tau + 1

      integer, parameter :: p_omega_start = p_scale_height + 1
      integer, parameter :: p_omega = p_omega_start + 1
      integer, parameter :: p_log_omega = p_omega + 1
      integer, parameter :: p_log_dr_div_scale_height = p_log_omega + 1
      integer, parameter :: p_log_j_rot = p_log_dr_div_scale_height + 1
      integer, parameter :: p_log_J_inside = p_log_j_rot + 1
      integer, parameter :: p_log_J_div_M53 = p_log_J_inside + 1
      integer, parameter :: p_log_abs_shear = p_log_J_div_M53 + 1
      integer, parameter :: p_shear = p_log_abs_shear + 1
      integer, parameter :: p_i_rot = p_shear + 1
      integer, parameter :: p_j_rot = p_i_rot + 1
      integer, parameter :: p_v_rot = p_j_rot + 1
      integer, parameter :: p_fp_rot_minus_1 = p_v_rot + 1
      integer, parameter :: p_ft_rot_minus_1 = p_fp_rot_minus_1 + 1
      integer, parameter :: p_fp_rot = p_ft_rot_minus_1 + 1
      integer, parameter :: p_ft_rot = p_fp_rot + 1
      integer, parameter :: p_ft_rot_div_fp_rot = p_ft_rot + 1
      integer, parameter :: p_log_am_nu_rot = p_ft_rot_div_fp_rot + 1
      integer, parameter :: p_log_am_nu_non_rot = p_log_am_nu_rot + 1
      integer, parameter :: p_log_am_nu = p_log_am_nu_non_rot + 1

      integer, parameter :: p_log_e_field = p_log_am_nu + 1
      integer, parameter :: p_e_field = p_log_e_field + 1
      integer, parameter :: p_log_g_field_element_diffusion = p_e_field + 1
      integer, parameter :: p_g_field_element_diffusion = p_log_g_field_element_diffusion + 1

      integer, parameter :: p_log_e_div_g_element_diffusion = p_g_field_element_diffusion + 1
      integer, parameter :: p_e_div_g_element_diffusion = p_log_e_div_g_element_diffusion + 1
      
      integer, parameter :: p_sum_x_advection = p_e_div_g_element_diffusion + 1

      integer, parameter :: p_r_polar = p_sum_x_advection + 1
      integer, parameter :: p_log_r_polar = p_r_polar + 1
      integer, parameter :: p_r_equatorial = p_log_r_polar + 1
      integer, parameter :: p_log_r_equatorial = p_r_equatorial + 1
      integer, parameter :: p_r_e_div_r_p = p_log_r_equatorial + 1

      integer, parameter :: p_omega_crit = p_r_e_div_r_p + 1
      integer, parameter :: p_omega_div_omega_crit = p_omega_crit + 1

      integer, parameter :: p_am_log_sig = p_omega_div_omega_crit + 1
      integer, parameter :: p_am_log_sig_omega = p_am_log_sig + 1
      integer, parameter :: p_am_log_sig_j = p_am_log_sig_omega + 1

      integer, parameter :: p_am_log_nu_omega = p_am_log_sig_j + 1
      integer, parameter :: p_am_log_nu_j = p_am_log_nu_omega + 1
      integer, parameter :: p_am_log_nu_rot = p_am_log_nu_j + 1
      integer, parameter :: p_am_log_nu_non_rot = p_am_log_nu_rot + 1
      
      integer, parameter :: p_richardson_number = p_am_log_nu_non_rot + 1
      integer, parameter :: p_am_domega_dlnR = p_richardson_number + 1
      integer, parameter :: p_am_log_D_visc = p_am_domega_dlnR + 1
      integer, parameter :: p_am_log_D_DSI = p_am_log_D_visc + 1
      integer, parameter :: p_am_log_D_SH = p_am_log_D_DSI + 1
      integer, parameter :: p_am_log_D_SSI = p_am_log_D_SH + 1
      integer, parameter :: p_am_log_D_ES = p_am_log_D_SSI + 1
      integer, parameter :: p_am_log_D_GSF = p_am_log_D_ES + 1
      integer, parameter :: p_am_log_D_ST = p_am_log_D_GSF + 1
      integer, parameter :: p_am_log_nu_ST = p_am_log_D_ST + 1

      integer, parameter :: p_dynamo_log_B_r = p_am_log_nu_ST + 1
      integer, parameter :: p_dynamo_log_B_phi = p_dynamo_log_B_r + 1

      integer, parameter :: p_scale_height_start = p_dynamo_log_B_phi + 1
      integer, parameter :: p_gradr_start = p_scale_height_start + 1
      integer, parameter :: p_grada_at_face_start = p_gradr_start + 1
      integer, parameter :: p_gradL_start = p_grada_at_face_start + 1
      integer, parameter :: p_gradr_sub_gradL_start = p_gradL_start + 1
      integer, parameter :: p_gradr_sub_grada_start = p_gradr_sub_gradL_start + 1
      integer, parameter :: p_grada_at_face = p_gradr_sub_grada_start + 1
      
      integer, parameter :: p_gradr_div_grada = p_grada_at_face + 1
      integer, parameter :: p_gradr_sub_grada = p_gradr_div_grada + 1
      integer, parameter :: p_entropy = p_gradr_sub_grada + 1
      integer, parameter :: p_free_e = p_entropy + 1
      integer, parameter :: p_logfree_e = p_free_e + 1
      integer, parameter :: p_dlnRho_dlnT_const_Pgas = p_logfree_e + 1
      integer, parameter :: p_dlnRho_dlnPgas_const_T = p_dlnRho_dlnT_const_Pgas + 1
      integer, parameter :: p_chiRho = p_dlnRho_dlnPgas_const_T + 1
      integer, parameter :: p_chiT = p_chiRho + 1
      
      integer, parameter :: p_x_mass_fraction_H = p_chiT + 1
      integer, parameter :: p_y_mass_fraction_He = p_x_mass_fraction_H + 1
      integer, parameter :: p_z_mass_fraction_metals = p_y_mass_fraction_He + 1
      
      integer, parameter :: p_abar = p_z_mass_fraction_metals + 1
      integer, parameter :: p_zbar = p_abar + 1
      integer, parameter :: p_z2bar = p_zbar + 1
      integer, parameter :: p_ye = p_z2bar + 1

      integer, parameter :: p_dkap_dlnrho_at_face = p_ye + 1
      integer, parameter :: p_dkap_dlnt_at_face = p_dkap_dlnrho_at_face + 1
      integer, parameter :: p_opacity = p_dkap_dlnt_at_face + 1

      integer, parameter :: p_deps_dlnd_at_face = p_opacity + 1
      integer, parameter :: p_deps_dlnT_at_face = p_deps_dlnd_at_face + 1
      integer, parameter :: p_d_epsnuc_dlnd = p_deps_dlnT_at_face + 1
      integer, parameter :: p_d_lnepsnuc_dlnd = p_d_epsnuc_dlnd + 1
      integer, parameter :: p_d_lnepsnuc_dlnT = p_d_lnepsnuc_dlnd + 1
      integer, parameter :: p_d_epsnuc_dlnT = p_d_lnepsnuc_dlnT + 1
      integer, parameter :: p_eps_nuc_start = p_d_epsnuc_dlnT + 1
      integer, parameter :: p_log_abs_eps_nuc = p_eps_nuc_start + 1
      integer, parameter :: p_eps_nuc = p_log_abs_eps_nuc + 1
      
      integer, parameter :: p_burn_num_substeps = p_eps_nuc + 1
      integer, parameter :: p_burn_num_iters = p_burn_num_substeps + 1

      integer, parameter :: p_eps_nuc_neu_total = p_burn_num_iters + 1
      
      
      integer, parameter :: p_d_nonnucneu_dlnd = p_eps_nuc_neu_total + 1
      integer, parameter :: p_d_nonnucneu_dlnT = p_d_nonnucneu_dlnd + 1
      integer, parameter :: p_non_nuc_neu = p_d_nonnucneu_dlnT + 1
      integer, parameter :: p_nonnucneu_plas = p_non_nuc_neu + 1
      integer, parameter :: p_nonnucneu_brem = p_nonnucneu_plas + 1
      integer, parameter :: p_nonnucneu_phot = p_nonnucneu_brem + 1
      integer, parameter :: p_nonnucneu_pair = p_nonnucneu_phot + 1
      integer, parameter :: p_nonnucneu_reco = p_nonnucneu_pair + 1
      integer, parameter :: p_log_irradiation_heat = p_nonnucneu_reco + 1
      integer, parameter :: p_cgrav_factor = p_log_irradiation_heat + 1
      integer, parameter :: p_log_extra_L = p_cgrav_factor + 1
      integer, parameter :: p_extra_L = p_log_extra_L + 1
      integer, parameter :: p_extra_jdot = p_extra_L + 1
      integer, parameter :: p_extra_omegadot = p_extra_jdot + 1
      integer, parameter :: p_extra_dPdm = p_extra_omegadot + 1
      integer, parameter :: p_extra_heat = p_extra_dPdm + 1
      integer, parameter :: p_area = p_extra_heat + 1
      integer, parameter :: p_area_times_v = p_area + 1
      integer, parameter :: p_div_v = p_area_times_v + 1
      integer, parameter :: p_dm_div_4pi_rmid2_rho_dr = p_div_v + 1
      integer, parameter :: p_d_v_div_r_dm = p_dm_div_4pi_rmid2_rho_dr + 1
      integer, parameter :: p_d_v_div_r_dr = p_d_v_div_r_dm + 1
      integer, parameter :: p_eta_visc = p_d_v_div_r_dr + 1
      integer, parameter :: p_dlnP_dm_visc = p_eta_visc + 1
      
      integer, parameter :: p_dP_dm_visc = p_dlnP_dm_visc + 1
      integer, parameter :: p_dvdt_grav = p_dP_dm_visc + 1
      integer, parameter :: p_dvdt_dPdm = p_dvdt_grav + 1
      integer, parameter :: p_dvdt_visc = p_dvdt_dPdm + 1
      integer, parameter :: p_qvisc = p_dvdt_visc + 1
      integer, parameter :: p_log_rmid3_rho = p_qvisc + 1
      integer, parameter :: p_rmid3_rho = p_log_rmid3_rho + 1
      integer, parameter :: p_eps_visc = p_rmid3_rho + 1
      integer, parameter :: p_rp_div_GMrho_face = p_eps_visc + 1
      integer, parameter :: p_env_eps_grav = p_rp_div_GMrho_face + 1
      
      integer, parameter :: p_log_abs_eps_grav_dm_div_L = p_env_eps_grav + 1
      integer, parameter :: p_eps_grav_composition_term = p_log_abs_eps_grav_dm_div_L + 1

      integer, parameter :: p_eps_grav_dm_term_const_q = p_eps_grav_composition_term + 1
      integer, parameter :: p_eps_grav_dt_term_const_q = p_eps_grav_dm_term_const_q + 1
      integer, parameter :: p_dm_eps_grav = p_eps_grav_dt_term_const_q + 1
      integer, parameter :: p_eps_grav = p_dm_eps_grav + 1
      integer, parameter :: p_signed_log_eps_grav = p_eps_grav + 1
      integer, parameter :: p_log_conv_L_div_L = p_signed_log_eps_grav + 1
      integer, parameter :: p_conv_L_div_L = p_log_conv_L_div_L + 1
      integer, parameter :: p_mlt_Zeta = p_conv_L_div_L + 1
      integer, parameter :: p_mlt_Gamma = p_mlt_Zeta + 1
      integer, parameter :: p_mlt_mixing_length = p_mlt_Gamma + 1
      
      integer, parameter :: p_adjust_mlt_gradT_fraction = p_mlt_mixing_length + 1
      integer, parameter :: p_mlt_mixing_type = p_adjust_mlt_gradT_fraction + 1
      
      integer, parameter :: p_grada_sub_gradT = p_mlt_mixing_type + 1
      integer, parameter :: p_gradT_sub_a = p_grada_sub_gradT + 1
      integer, parameter :: p_gradT_sub_grada = p_gradT_sub_a + 1
      integer, parameter :: p_gradT_div_grada = p_gradT_sub_grada + 1
      
      integer, parameter :: p_gradr_sub_gradT = p_gradT_div_grada + 1
      integer, parameter :: p_gradT_sub_gradr = p_gradr_sub_gradT + 1
      integer, parameter :: p_gradT_div_gradr = p_gradT_sub_gradr + 1
      integer, parameter :: p_log_gradT_div_gradr = p_gradT_div_gradr + 1
      
      integer, parameter :: p_log_mlt_Gamma = p_log_gradT_div_gradr + 1
      integer, parameter :: p_mlt_mixing_length_start = p_log_mlt_Gamma + 1
      integer, parameter :: p_mlt_mixing_type_start = p_mlt_mixing_length_start + 1
      integer, parameter :: p_mlt_D_start = p_mlt_mixing_type_start + 1
      integer, parameter :: p_mlt_vc_start = p_mlt_D_start + 1
      integer, parameter :: p_mlt_Gamma_start = p_mlt_vc_start + 1
      integer, parameter :: p_mlt_cdc_start = p_mlt_Gamma_start + 1
      
      integer, parameter :: p_super_ad = p_mlt_cdc_start + 1

      integer, parameter :: p_delta_r = p_super_ad + 1
      integer, parameter :: p_delta_L = p_delta_r + 1
      integer, parameter :: p_delta_cell_vol = p_delta_L + 1
      integer, parameter :: p_delta_entropy = p_delta_cell_vol + 1
      integer, parameter :: p_delta_T = p_delta_entropy + 1
      integer, parameter :: p_delta_rho = p_delta_T + 1
      integer, parameter :: p_delta_eps_nuc = p_delta_rho + 1
      integer, parameter :: p_delta_mu = p_delta_eps_nuc + 1

      integer, parameter :: p_dlnR_dk = p_delta_mu + 1
      
      integer, parameter :: p_log_D_conv = p_dlnR_dk + 1
      integer, parameter :: p_log_D_soft = p_log_D_conv + 1
      integer, parameter :: p_log_D_semi = p_log_D_soft + 1
      integer, parameter :: p_log_D_anon = p_log_D_semi + 1
      integer, parameter :: p_log_D_ovr = p_log_D_anon + 1
      integer, parameter :: p_log_D_thrm = p_log_D_ovr + 1
      integer, parameter :: p_log_D_minimum = p_log_D_thrm + 1
      
      integer, parameter :: p_log_D_mix_non_rotation = p_log_D_minimum + 1
      integer, parameter :: p_log_D_mix = p_log_D_mix_non_rotation + 1
      integer, parameter :: p_conv_vel = p_log_D_mix + 1
      integer, parameter :: p_log_conv_vel_old = p_conv_vel + 1
      integer, parameter :: p_sig_raw_div_sig = p_log_conv_vel_old + 1

      integer, parameter :: p_d_ln_sig_dlnd00 = p_sig_raw_div_sig + 1
      integer, parameter :: p_d_ln_sig_dlnT00 = p_d_ln_sig_dlnd00 + 1
      integer, parameter :: p_d_ln_sig_dlndm1 = p_d_ln_sig_dlnT00 + 1
      integer, parameter :: p_d_ln_sig_dlnTm1 = p_d_ln_sig_dlndm1 + 1
      integer, parameter :: p_d_ln_sig_dlnR = p_d_ln_sig_dlnTm1 + 1
      integer, parameter :: p_d_ln_sig_dL = p_d_ln_sig_dlnR + 1

      integer, parameter :: p_d_ln_D_mix_dlnd00 = p_d_ln_sig_dL + 1
      integer, parameter :: p_d_ln_D_mix_dlnT00 = p_d_ln_D_mix_dlnd00 + 1
      integer, parameter :: p_d_ln_D_mix_dlndm1 = p_d_ln_D_mix_dlnT00 + 1
      integer, parameter :: p_d_ln_D_mix_dlnTm1 = p_d_ln_D_mix_dlndm1 + 1
      integer, parameter :: p_d_ln_D_mix_dlnR = p_d_ln_D_mix_dlnTm1 + 1
      integer, parameter :: p_d_ln_D_mix_dL = p_d_ln_D_mix_dlnR + 1

      integer, parameter :: p_d_ln_mlt_D_dlnd00 = p_d_ln_D_mix_dL + 1
      integer, parameter :: p_d_ln_mlt_D_dlnT00 = p_d_ln_mlt_D_dlnd00 + 1
      integer, parameter :: p_d_ln_mlt_D_dlndm1 = p_d_ln_mlt_D_dlnT00 + 1
      integer, parameter :: p_d_ln_mlt_D_dlnTm1 = p_d_ln_mlt_D_dlndm1 + 1
      integer, parameter :: p_d_ln_mlt_D_dlnR = p_d_ln_mlt_D_dlnTm1 + 1
      integer, parameter :: p_d_ln_mlt_D_dL = p_d_ln_mlt_D_dlnR + 1

      integer, parameter :: p_log_sig_mix = p_d_ln_mlt_D_dL + 1
      integer, parameter :: p_log_conv_vel = p_log_sig_mix + 1
      integer, parameter :: p_newly_nonconvective = p_log_conv_vel + 1
      integer, parameter :: p_conv_vel_div_L_vel = p_newly_nonconvective + 1
      integer, parameter :: p_conv_vel_div_csound = p_conv_vel_div_L_vel + 1
      integer, parameter :: p_log_tau_conv_yrs = p_conv_vel_div_csound + 1
      integer, parameter :: p_mixing_type = p_log_tau_conv_yrs + 1
      integer, parameter :: p_conv_mixing_type = p_mixing_type + 1

      integer, parameter :: p_log_mlt_D_mix = p_conv_mixing_type + 1
      integer, parameter :: p_pressure_scale_height = p_log_mlt_D_mix + 1

      integer, parameter :: p_grada_sub_actual_gradT = p_pressure_scale_height + 1
      integer, parameter :: p_gradT_sub_actual_gradT = p_grada_sub_actual_gradT + 1
      integer, parameter :: p_actual_gradT = p_gradT_sub_actual_gradT + 1
      integer, parameter :: p_gradT = p_actual_gradT + 1
      integer, parameter :: p_gradr = p_gradT + 1

      integer, parameter :: p_d_gradT_dlnd00 = p_gradr + 1
      integer, parameter :: p_d_gradT_dlnT00 = p_d_gradT_dlnd00 + 1
      integer, parameter :: p_d_gradT_dlndm1 = p_d_gradT_dlnT00 + 1
      integer, parameter :: p_d_gradT_dlnTm1 = p_d_gradT_dlndm1 + 1
      integer, parameter :: p_d_gradT_dlnR = p_d_gradT_dlnTm1 + 1
      integer, parameter :: p_d_gradT_dL = p_d_gradT_dlnR + 1

      integer, parameter :: p_accel_div_grav = p_d_gradT_dL + 1
      
      integer, parameter :: p_dlnd_dt_const_q = p_accel_div_grav + 1
      integer, parameter :: p_dlnPgas_dt_const_q = p_dlnd_dt_const_q + 1
      integer, parameter :: p_dlnT_dt_const_q = p_dlnPgas_dt_const_q + 1
      
      integer, parameter :: p_dlnd = p_dlnT_dt_const_q + 1
      integer, parameter :: p_dlnPgas = p_dlnd + 1
      integer, parameter :: p_dlnT = p_dlnPgas + 1
      integer, parameter :: p_dlnR = p_dlnT + 1
      
      integer, parameter :: p_dlnd_dt = p_dlnR + 1
      integer, parameter :: p_dlnPgas_dt = p_dlnd_dt + 1
      integer, parameter :: p_dlnT_dt = p_dlnPgas_dt + 1
      integer, parameter :: p_dlnR_dt = p_dlnT_dt + 1
      integer, parameter :: p_dr_dt = p_dlnR_dt + 1
      integer, parameter :: p_dv_dt = p_dr_dt + 1
      
      integer, parameter :: p_lnd_truncation_ratio = p_dv_dt + 1
      integer, parameter :: p_lnT_truncation_ratio = p_lnd_truncation_ratio + 1
      integer, parameter :: p_e_truncation_ratio = p_lnT_truncation_ratio + 1
      integer, parameter :: p_lnR_truncation_ratio = p_e_truncation_ratio + 1
      integer, parameter :: p_lnPgas_truncation_ratio = p_lnR_truncation_ratio + 1
      integer, parameter :: p_v_truncation_ratio = p_lnPgas_truncation_ratio + 1
      integer, parameter :: p_lum_truncation_ratio = p_v_truncation_ratio + 1
      
      integer, parameter :: p_signed_dlnd = p_lum_truncation_ratio + 1
      integer, parameter :: p_signed_dlnT = p_signed_dlnd + 1
      
      integer, parameter :: p_energy_check = p_signed_dlnT + 1
      integer, parameter :: p_vcheck = p_energy_check + 1
      integer, parameter :: p_echeck = p_vcheck + 1
      integer, parameter :: p_sum_echeck_from_surf = p_echeck + 1
      
      integer, parameter :: p_sum_check_eps_grav_from_surf = p_sum_echeck_from_surf + 1
      integer, parameter :: p_check_eps_grav = p_sum_check_eps_grav_from_surf + 1
      integer, parameter :: p_dt_dm_eps_grav = p_check_eps_grav + 1
      integer, parameter :: p_minus_dm_de_plus_dtPdvA = p_dt_dm_eps_grav + 1
      
      integer, parameter :: p_dm_eps_grav_plus_eps_visc = p_minus_dm_de_plus_dtPdvA + 1
      integer, parameter :: p_minus_dm_eps_visc = p_dm_eps_grav_plus_eps_visc + 1
      integer, parameter :: p_dm_eps_visc = p_minus_dm_eps_visc + 1
      integer, parameter :: p_dm_de = p_dm_eps_visc + 1
      integer, parameter :: p_dt_dL = p_dm_de + 1
      integer, parameter :: p_dt_PdvA = p_dt_dL + 1

      integer, parameter :: p_ds_from_eps_grav = p_dt_PdvA + 1
      integer, parameter :: p_del_entropy = p_ds_from_eps_grav + 1
      integer, parameter :: p_cno_div_z = p_del_entropy + 1

      integer, parameter :: p_dE = p_cno_div_z + 1
      integer, parameter :: p_dr = p_dE + 1
      integer, parameter :: p_dv = p_dr + 1
      
      integer, parameter :: p_dt_dv_div_dr = p_dv + 1

      integer, parameter :: p_dlnH1_dlnP = p_dt_dv_div_dr + 1
      integer, parameter :: p_dlnHe3_dlnP = p_dlnH1_dlnP + 1
      integer, parameter :: p_dlnHe4_dlnP = p_dlnHe3_dlnP + 1
      integer, parameter :: p_dlnC12_dlnP = p_dlnHe4_dlnP + 1
      integer, parameter :: p_dlnC13_dlnP = p_dlnC12_dlnP + 1
      integer, parameter :: p_dlnN14_dlnP = p_dlnC13_dlnP + 1
      integer, parameter :: p_dlnO16_dlnP = p_dlnN14_dlnP + 1
      integer, parameter :: p_dlnNe20_dlnP = p_dlnO16_dlnP + 1
      integer, parameter :: p_dlnMg24_dlnP = p_dlnNe20_dlnP + 1
      integer, parameter :: p_dlnSi28_dlnP = p_dlnMg24_dlnP + 1

      integer, parameter :: p_dlog_pp_dlogP = p_dlnSi28_dlnP + 1
      integer, parameter :: p_dlog_cno_dlogP = p_dlog_pp_dlogP + 1
      integer, parameter :: p_dlog_3alf_dlogP = p_dlog_cno_dlogP + 1
         
      integer, parameter :: p_dlog_burn_c_dlogP = p_dlog_3alf_dlogP + 1
      integer, parameter :: p_dlog_burn_n_dlogP = p_dlog_burn_c_dlogP + 1
      integer, parameter :: p_dlog_burn_o_dlogP = p_dlog_burn_n_dlogP + 1
         
      integer, parameter :: p_dlog_burn_ne_dlogP = p_dlog_burn_o_dlogP + 1
      integer, parameter :: p_dlog_burn_na_dlogP = p_dlog_burn_ne_dlogP + 1
      integer, parameter :: p_dlog_burn_mg_dlogP = p_dlog_burn_na_dlogP + 1
         
      integer, parameter :: p_dlog_cc_dlogP = p_dlog_burn_mg_dlogP + 1
      integer, parameter :: p_dlog_co_dlogP = p_dlog_cc_dlogP + 1
      integer, parameter :: p_dlog_oo_dlogP = p_dlog_co_dlogP + 1
         
      integer, parameter :: p_dlog_burn_si_dlogP = p_dlog_oo_dlogP + 1
      integer, parameter :: p_dlog_burn_s_dlogP = p_dlog_burn_si_dlogP + 1
      integer, parameter :: p_dlog_burn_ar_dlogP = p_dlog_burn_s_dlogP + 1
      integer, parameter :: p_dlog_burn_ca_dlogP = p_dlog_burn_ar_dlogP + 1
      integer, parameter :: p_dlog_burn_ti_dlogP = p_dlog_burn_ca_dlogP + 1
      integer, parameter :: p_dlog_burn_cr_dlogP = p_dlog_burn_ti_dlogP + 1
      integer, parameter :: p_dlog_burn_fe_dlogP = p_dlog_burn_cr_dlogP + 1
         
      integer, parameter :: p_dlog_pnhe4_dlogP = p_dlog_burn_fe_dlogP + 1
      integer, parameter :: p_dlog_photo_dlogP = p_dlog_pnhe4_dlogP + 1
      integer, parameter :: p_dlog_other_dlogP = p_dlog_photo_dlogP + 1

      integer, parameter :: p_dlnX_dr = p_dlog_other_dlogP + 1
      integer, parameter :: p_dlnY_dr = p_dlnX_dr + 1
      integer, parameter :: p_dlnRho_dr = p_dlnY_dr + 1
      
      integer, parameter :: p_logQ = p_dlnRho_dr + 1
      integer, parameter :: p_log_mdot_cs = p_logQ + 1
      integer, parameter :: p_log_mdot_v = p_log_mdot_cs + 1
      integer, parameter :: p_log_L_div_CpTMdot = p_log_mdot_v + 1
      integer, parameter :: p_cs_at_cell_bdy = p_log_L_div_CpTMdot + 1
      
      integer, parameter :: p_total_energy_integral = p_cs_at_cell_bdy + 1
      integer, parameter :: p_total_energy = p_total_energy_integral + 1
      
      integer, parameter :: p_grada_sub_gradr = p_total_energy + 1
      integer, parameter :: p_gradL_sub_gradr = p_grada_sub_gradr + 1
      integer, parameter :: p_gradL = p_gradL_sub_gradr + 1
      integer, parameter :: p_sch_stable = p_gradL + 1
      integer, parameter :: p_ledoux_stable = p_sch_stable + 1
      integer, parameter :: p_grad_density = p_ledoux_stable + 1
      integer, parameter :: p_grad_temperature = p_grad_density + 1
      
      integer, parameter :: p_log_maxabs_dt_d_dxdt_dt = p_grad_temperature + 1
      
      integer, parameter :: p_dominant_isoA_for_thermohaline = p_log_maxabs_dt_d_dxdt_dt + 1
      integer, parameter :: p_dominant_isoZ_for_thermohaline = p_dominant_isoA_for_thermohaline + 1
      integer, parameter :: p_gradL_composition_term = p_dominant_isoZ_for_thermohaline + 1

      integer, parameter :: p_brunt_g_r_div_cs2 = p_gradL_composition_term + 1
      integer, parameter :: p_log_brunt_nonB = p_brunt_g_r_div_cs2 + 1
      integer, parameter :: p_log_brunt_B = p_log_brunt_nonB + 1
      integer, parameter :: p_brunt_nonB = p_log_brunt_B + 1
      integer, parameter :: p_brunt_B = p_brunt_nonB + 1
      integer, parameter :: p_lamb_S2 = p_brunt_B + 1
      integer, parameter :: p_lamb_S = p_lamb_S2 + 1
      integer, parameter :: p_lamb_Sl1 = p_lamb_S + 1
      integer, parameter :: p_lamb_Sl2 = p_lamb_Sl1 + 1
      integer, parameter :: p_lamb_Sl3 = p_lamb_Sl2 + 1
      integer, parameter :: p_sign_brunt_N2 = p_lamb_Sl3 + 1
      integer, parameter :: p_brunt_A_div_x2 = p_sign_brunt_N2 + 1
      integer, parameter :: p_brunt_A = p_brunt_A_div_x2 + 1
      
      integer, parameter :: p_brunt_N2 = p_brunt_A + 1
      integer, parameter :: p_brunt_N2_structure_term = p_brunt_N2 + 1
      integer, parameter :: p_brunt_N2_composition_term = p_brunt_N2_structure_term + 1
      integer, parameter :: p_log_brunt_N2_structure_term = p_brunt_N2_composition_term + 1
      integer, parameter :: p_log_brunt_N2_composition_term = p_log_brunt_N2_structure_term + 1
      integer, parameter :: p_log_brunt_N2_dimensionless = p_log_brunt_N2_composition_term + 1
      integer, parameter :: p_brunt_N2_dimensionless = p_log_brunt_N2_dimensionless + 1
      integer, parameter :: p_brunt_N_dimensionless = p_brunt_N2_dimensionless + 1
      integer, parameter :: p_brunt_N = p_brunt_N_dimensionless + 1
      integer, parameter :: p_brunt_frequency = p_brunt_N + 1
      integer, parameter :: p_log_brunt_N2 = p_brunt_frequency + 1
      integer, parameter :: p_log_brunt_N = p_log_brunt_N2 + 1
      integer, parameter :: p_brunt_N_div_r_integral = p_log_brunt_N + 1
      integer, parameter :: p_brunt_nu = p_brunt_N_div_r_integral + 1
      integer, parameter :: p_log_brunt_nu = p_brunt_nu + 1
      integer, parameter :: p_log_lamb_Sl1 = p_log_brunt_nu + 1
      integer, parameter :: p_log_lamb_Sl2 = p_log_lamb_Sl1 + 1
      integer, parameter :: p_log_lamb_Sl3 = p_log_lamb_Sl2 + 1
      integer, parameter :: p_log_lamb_Sl10 = p_log_lamb_Sl3 + 1      
      integer, parameter :: p_brunt_N2_sub_omega2 = p_log_lamb_Sl10 + 1      
      integer, parameter :: p_sl2_sub_omega2 = p_brunt_N2_sub_omega2 + 1      
      integer, parameter :: p_k_r_integral = p_sl2_sub_omega2 + 1      

      integer, parameter :: p_num_steps = p_k_r_integral + 1      
      integer, parameter :: p_mtx_solve = p_num_steps + 1      
      integer, parameter :: p_mtx_factor = p_mtx_solve + 1      
      integer, parameter :: p_avg_order = p_mtx_factor + 1   

      integer, parameter :: p_col_id_max = p_avg_order
      
      character (len=maxlen_profile_column_name) :: profile_column_name(p_col_id_max)
      type (integer_dict), pointer :: profile_column_names_dict


      
   

         

      contains



      
      subroutine profile_column_names_init(ierr)
         use utils_lib, only: integer_dict_define
         integer, intent(out) :: ierr
         integer :: i, cnt
         
         ierr = 0
         
         cnt = 0
         profile_column_name(:) = ''

         profile_column_name(p_zone) = 'zone'
         profile_column_name(p_luminosity) = 'luminosity'
         profile_column_name(p_log_Lrad_div_Ledd) = 'log_Lrad_div_Ledd'
         profile_column_name(p_log_Lrad_div_L) = 'log_Lrad_div_L'
         profile_column_name(p_lum_rad) = 'lum_rad'
         profile_column_name(p_lum_conv) = 'lum_conv'
         
         profile_column_name(p_lum_conv_div_lum_Edd) = 'lum_conv_div_lum_Edd'
         profile_column_name(p_lum_rad_div_L_Edd) = 'lum_rad_div_L_Edd'
         profile_column_name(p_lum_rad_div_L_Edd_div_phi_Joss) = 'lum_rad_div_L_Edd_div_phi_Joss'
         profile_column_name(p_lum_rad_div_L) = 'lum_rad_div_L'
         profile_column_name(p_lum_conv_div_L) = 'lum_conv_div_L'
         profile_column_name(p_lum_conv_div_lum_rad) = 'lum_conv_div_lum_rad'
         profile_column_name(p_log_Lrad) = 'log_Lrad'
         profile_column_name(p_log_Lconv) = 'log_Lconv'
         profile_column_name(p_grav) = 'grav'
         profile_column_name(p_log_g) = 'log_g'
         profile_column_name(p_r_div_g) = 'r_div_g'
         profile_column_name(p_g_div_r) = 'g_div_r'
         profile_column_name(p_net_nuclear_energy) = 'net_nuclear_energy'
         profile_column_name(p_eps_nuc_plus_nuc_neu) = 'eps_nuc_plus_nuc_neu'
         profile_column_name(p_eps_nuc_minus_non_nuc_neu) = 'eps_nuc_minus_non_nuc_neu'
         profile_column_name(p_log_abs_eps_nuc_div_non_nuc_neu) = 'log_abs_eps_nuc_div_non_nuc_neu'
         profile_column_name(p_net_energy) = 'net_energy'
         profile_column_name(p_logL) = 'logL'
         profile_column_name(p_log_Ledd) = 'log_Ledd'
         profile_column_name(p_log_L_div_Ledd) = 'log_L_div_Ledd'
         profile_column_name(p_signed_log_power) = 'signed_log_power'
         profile_column_name(p_velocity) = 'velocity'
         profile_column_name(p_vel_km_per_s) = 'vel_km_per_s'
         profile_column_name(p_radius_cm) = 'radius_cm'
         profile_column_name(p_radius) = 'radius'
         profile_column_name(p_rmid) = 'rmid'
         profile_column_name(p_logR_cm) = 'logR_cm'
         profile_column_name(p_logR) = 'logR'
         profile_column_name(p_log_q) = 'log_q'
         profile_column_name(p_q) = 'q'
         profile_column_name(p_dq) = 'dq'
         profile_column_name(p_logtau) = 'logtau'
         profile_column_name(p_lum_rad_div_L_Edd_sub_fourPrad_div_PchiT) = &
            'lum_rad_div_L_Edd_sub_fourPrad_div_PchiT'
         profile_column_name(p_fourPrad_div_PchiT) = 'fourPrad_div_PchiT'
         profile_column_name(p_pturb_div_pgas_plus_prad) = 'pturb_div_pgas_plus_prad'
         profile_column_name(p_conv_dP_term) = 'conv_dP_term'
         profile_column_name(p_pgas_div_p) = 'pgas_div_p'
         profile_column_name(p_pgas_div_ptotal) = 'pgas_div_ptotal'

         profile_column_name(p_m_div_r) = 'm_div_r'
         profile_column_name(p_dmbar_m_div_r) = 'dmbar_m_div_r'
         profile_column_name(p_log_dmbar_m_div_r) = 'log_dmbar_m_div_r'
         
         profile_column_name(p_mass) = 'mass'
         profile_column_name(p_mass_grams) = 'mass_grams'
         profile_column_name(p_mmid) = 'mmid'

         profile_column_name(p_dm) = 'dm'
         profile_column_name(p_dm_bar) = 'dm_bar'

         profile_column_name(p_m_grav) = 'm_grav'
         profile_column_name(p_mass_correction_factor) = 'mass_correction_factor'
         profile_column_name(p_m_grav_div_m_baryonic) = 'm_grav_div_m_baryonic'

         profile_column_name(p_avg_charge_H) = 'avg_charge_H'
         profile_column_name(p_avg_charge_He) = 'avg_charge_He'
         profile_column_name(p_avg_charge_C) = 'avg_charge_C'
         profile_column_name(p_avg_charge_N) = 'avg_charge_N'
         profile_column_name(p_avg_charge_O) = 'avg_charge_O'
         profile_column_name(p_avg_charge_Ne) = 'avg_charge_Ne'
         profile_column_name(p_avg_charge_Mg) = 'avg_charge_Mg'
         profile_column_name(p_avg_charge_Si) = 'avg_charge_Si'
         profile_column_name(p_avg_charge_Fe) = 'avg_charge_Fe'
         profile_column_name(p_neutral_fraction_H) = 'neutral_fraction_H'
         profile_column_name(p_neutral_fraction_He) = 'neutral_fraction_He'
         profile_column_name(p_neutral_fraction_C) = 'neutral_fraction_C'
         profile_column_name(p_neutral_fraction_N) = 'neutral_fraction_N'
         profile_column_name(p_neutral_fraction_O) = 'neutral_fraction_O'
         profile_column_name(p_neutral_fraction_Ne) = 'neutral_fraction_Ne'
         profile_column_name(p_neutral_fraction_Mg) = 'neutral_fraction_Mg'
         profile_column_name(p_neutral_fraction_Si) = 'neutral_fraction_Si'
         profile_column_name(p_neutral_fraction_Fe) = 'neutral_fraction_Fe'
         
         profile_column_name(p_log_x) = 'log_x'
         profile_column_name(p_x) = 'x'
         profile_column_name(p_log_y) = 'log_y'
         profile_column_name(p_y) = 'y'
         profile_column_name(p_log_z) = 'log_z'
         profile_column_name(p_z) = 'z'

         profile_column_name(p_xm) = 'xm'
         profile_column_name(p_logxm) = 'logxm'
         profile_column_name(p_logxq) = 'logxq'
         profile_column_name(p_logdq) = 'logdq'
         
         profile_column_name(p_log_radial_depth) = 'log_radial_depth'
         profile_column_name(p_log_column_depth) = 'log_column_depth'
         profile_column_name(p_rmid_div_R) = 'rmid_div_R'
         profile_column_name(p_r_div_R) = 'r_div_R'
         profile_column_name(p_dr_div_rmid) = 'dr_div_rmid'
         profile_column_name(p_log_dr_div_rmid) = 'log_dr_div_rmid'
         profile_column_name(p_log_dr) = 'log_dr'

         profile_column_name(p_dEdt_actual) = 'dEdt_actual'
         profile_column_name(p_sum_check_dEdt_actual) = 'sum_check_dEdt_actual'
         profile_column_name(p_check_dEdt_actual) = 'check_dEdt_actual'

         profile_column_name(p_dEdt_expected) = 'dEdt_expected'
         profile_column_name(p_sum_check_dEdt_expected) = 'sum_check_dEdt_expected'
         profile_column_name(p_check_dEdt_expected) = 'check_dEdt_expected'

         profile_column_name(p_d_IE_dt_residual) = 'd_IE_dt_residual'
         profile_column_name(p_d_KE_dt_residual) = 'd_KE_dt_residual'
         profile_column_name(p_d_PE_dt_residual) = 'd_PE_dt_residual'
         profile_column_name(p_sum_from_cntr_dEdt_residuals) = &
            'sum_from_cntr_dEdt_residuals'
         
         profile_column_name(p_log_d_IE_dt_residual) = 'log_d_IE_dt_residual'
         profile_column_name(p_log_d_KE_dt_residual) = 'log_d_KE_dt_residual'
         profile_column_name(p_log_d_PE_dt_residual) = 'log_d_PE_dt_residual'
         profile_column_name(p_log_sum_from_cntr_dEdt_residuals) = &
            'log_sum_from_cntr_dEdt_residuals'

         profile_column_name(p_sum_lnR_residual) = 'sum_lnR_residual'
         profile_column_name(p_sum_lnd_residual) = 'sum_lnd_residual'
         profile_column_name(p_sum_E_residual) = 'sum_E_residual'
         profile_column_name(p_sum_v_residual) = 'sum_v_residual'
         profile_column_name(p_sum_structure_residuals) = 'sum_structure_residuals'

         profile_column_name(p_lnR_residual) = 'lnR_residual'
         profile_column_name(p_lnd_residual) = 'lnd_residual'
         profile_column_name(p_E_residual) = 'E_residual'
         profile_column_name(p_dlnTdm_residual) = 'dlnTdm_residual'
         profile_column_name(p_v_residual) = 'v_residual'
         
         profile_column_name(p_log_lnR_residual) = 'log_lnR_residual'
         profile_column_name(p_log_lnd_residual) = 'log_lnd_residual'
         profile_column_name(p_log_dlnTdm_residual) = 'log_dlnTdm_residual'
         profile_column_name(p_log_E_residual) = 'log_E_residual'
         profile_column_name(p_log_v_residual) = 'log_v_residual'
         
         profile_column_name(p_dr_div_cs) = 'dr_div_cs'
         profile_column_name(p_log_dr_div_cs) = 'log_dr_div_cs'
         profile_column_name(p_dr_div_cs_yr) = 'dr_div_cs_yr'
         profile_column_name(p_log_dr_div_cs_yr) = 'log_dr_div_cs_yr'

         profile_column_name(p_cell_collapse_time) = 'cell_collapse_time'
         profile_column_name(p_log_cell_collapse_time) = 'log_cell_collapse_time'

         profile_column_name(p_log_acoustic_depth) = 'log_acoustic_depth'
         profile_column_name(p_log_acoustic_radius) = 'log_acoustic_radius'
         profile_column_name(p_acoustic_depth) = 'acoustic_depth'
         profile_column_name(p_acoustic_radius) = 'acoustic_radius'
         profile_column_name(p_acoustic_r_div_R_phot) = 'acoustic_r_div_R_phot'
         
         profile_column_name(p_grav_gr_factor) = 'grav_gr_factor'
         profile_column_name(p_log_grav_gr_factor) = 'log_grav_gr_factor'

         profile_column_name(p_dq_ratio) = 'dq_ratio'
         profile_column_name(p_tau) = 'tau'
         profile_column_name(p_log_opacity) = 'log_opacity'
         profile_column_name(p_kap_frac_Type2) = 'kap_frac_Type2'
         profile_column_name(p_energy) = 'energy'
         profile_column_name(p_logM) = 'logM'
         profile_column_name(p_temperature) = 'temperature'
         profile_column_name(p_logT) = 'logT'
         profile_column_name(p_rho) = 'rho'
         profile_column_name(p_density) = 'density'
         profile_column_name(p_logRho) = 'logRho'
         profile_column_name(p_pgas) = 'pgas'
         profile_column_name(p_logPgas) = 'logPgas'
         profile_column_name(p_prad) = 'prad'
         profile_column_name(p_pressure) = 'pressure'
         profile_column_name(p_logP) = 'logP'
         profile_column_name(p_logE) = 'logE'
         profile_column_name(p_grada) = 'grada'
         profile_column_name(p_dE_dRho) = 'dE_dRho'
         profile_column_name(p_cv) = 'cv'
         profile_column_name(p_thermal_time_to_surface) = 'thermal_time_to_surface'
         profile_column_name(p_log_thermal_time_to_surface) = 'log_thermal_time_to_surface'
         profile_column_name(p_cp) = 'cp'
         profile_column_name(p_log_CpT) = 'log_CpT'
         profile_column_name(p_log_CpT_absMdot_div_L) = 'log_CpT_absMdot_div_L'
         profile_column_name(p_logS) = 'logS'
         profile_column_name(p_logS_per_baryon) = 'logS_per_baryon'
         profile_column_name(p_gamma1) = 'gamma1'
         profile_column_name(p_gamma3) = 'gamma3'
         profile_column_name(p_eta) = 'eta'
         profile_column_name(p_theta_e) = 'theta_e'
         profile_column_name(p_gam) = 'gam'
         profile_column_name(p_mu) = 'mu'
         profile_column_name(p_v_div_r) = 'v_div_r'
         profile_column_name(p_v_div_cs) = 'v_div_cs'
         profile_column_name(p_v_div_csound) = 'v_div_csound'
         profile_column_name(p_csound) = 'csound'
         profile_column_name(p_csound_at_face) = 'csound_at_face'

         profile_column_name(p_log_dr_div_scale_height) = 'log_dr_div_scale_height'
         profile_column_name(p_omega_start) = 'omega_start'
         profile_column_name(p_omega) = 'omega'
         profile_column_name(p_log_omega) = 'log_omega'
         profile_column_name(p_log_j_rot) = 'log_j_rot'
         profile_column_name(p_log_J_div_M53) = 'log_J_div_M53'
         profile_column_name(p_log_J_inside) = 'log_J_inside'
         profile_column_name(p_shear) = 'shear'
         profile_column_name(p_log_abs_shear) = 'log_abs_shear'
         profile_column_name(p_i_rot) = 'i_rot'
         profile_column_name(p_j_rot) = 'j_rot'
         profile_column_name(p_v_rot) = 'v_rot'
         profile_column_name(p_fp_rot_minus_1) = 'fp_rot_minus_1'
         profile_column_name(p_ft_rot_minus_1) = 'ft_rot_minus_1'
         profile_column_name(p_fp_rot) = 'fp_rot'
         profile_column_name(p_ft_rot) = 'ft_rot'
         profile_column_name(p_ft_rot_div_fp_rot) = 'ft_rot_div_fp_rot'
         profile_column_name(p_log_am_nu_rot) = 'log_am_nu_rot'
         profile_column_name(p_log_am_nu_non_rot) = 'log_am_nu_non_rot'
         profile_column_name(p_log_am_nu) = 'log_am_nu'

         profile_column_name(p_log_e_field) = 'log_e_field'
         profile_column_name(p_e_field) = 'e_field'
         profile_column_name(p_log_g_field_element_diffusion) = 'log_g_field_element_diffusion'
         profile_column_name(p_g_field_element_diffusion) = 'g_field_element_diffusion'
         profile_column_name(p_log_e_div_g_element_diffusion) = 'log_e_div_g_element_diffusion'
         profile_column_name(p_e_div_g_element_diffusion) = 'e_div_g_element_diffusion'
         
         profile_column_name(p_sum_x_advection) = 'sum_x_advection'

         profile_column_name(p_r_polar) = 'r_polar'
         profile_column_name(p_log_r_polar) = 'log_r_polar'
         profile_column_name(p_r_equatorial) = 'r_equatorial'
         profile_column_name(p_log_r_equatorial) = 'log_r_equatorial'
         profile_column_name(p_r_e_div_r_p) = 'r_e_div_r_p'
         profile_column_name(p_omega_crit) = 'omega_crit'
         profile_column_name(p_omega_div_omega_crit) = 'omega_div_omega_crit'

         profile_column_name(p_am_log_sig) = 'am_log_sig'
         profile_column_name(p_am_log_sig_omega) = 'am_log_sig_omega'
         profile_column_name(p_am_log_sig_j) = 'am_log_sig_j'

         profile_column_name(p_am_log_nu_omega) = 'am_log_nu_omega'
         profile_column_name(p_am_log_nu_j) = 'am_log_nu_j'
         profile_column_name(p_am_log_nu_rot) = 'am_log_nu_rot'
         profile_column_name(p_am_log_nu_non_rot) = 'am_log_nu_non_rot'

         profile_column_name(p_am_domega_dlnR) = 'am_domega_dlnR'
         profile_column_name(p_richardson_number) = 'richardson_number'
         profile_column_name(p_am_log_D_visc) = 'am_log_D_visc'
         profile_column_name(p_am_log_D_DSI) = 'am_log_D_DSI'
         profile_column_name(p_am_log_D_SH) = 'am_log_D_SH'
         profile_column_name(p_am_log_D_SSI) = 'am_log_D_SSI'
         profile_column_name(p_am_log_D_ES) = 'am_log_D_ES'
         profile_column_name(p_am_log_D_GSF) = 'am_log_D_GSF'
         profile_column_name(p_am_log_D_ST) = 'am_log_D_ST'
         profile_column_name(p_am_log_nu_ST) = 'am_log_nu_ST'

         profile_column_name(p_dynamo_log_B_r) = 'dynamo_log_B_r'
         profile_column_name(p_dynamo_log_B_phi) = 'dynamo_log_B_phi'

         profile_column_name(p_scale_height_start) = 'scale_height_start'
         profile_column_name(p_gradr_start) = 'gradr_start'
         profile_column_name(p_grada_at_face_start) = 'grada_at_face_start'
         profile_column_name(p_gradL_start) = 'gradL_start'
         profile_column_name(p_gradr_sub_gradL_start) = 'gradr_sub_gradL_start'
         profile_column_name(p_gradr_sub_grada_start) = 'gradr_sub_grada_start'
         
         profile_column_name(p_dlnT_dlnE_c_Rho) = 'dlnT_dlnE_c_Rho'
         profile_column_name(p_dlnPgas_dlnE_c_Rho) = 'dlnPgas_dlnE_c_Rho'
         profile_column_name(p_dlnP_dlnE_c_Rho) = 'dlnP_dlnE_c_Rho'
         profile_column_name(p_dlnT_dlnd_c_E) = 'dlnT_dlnd_c_E'
         profile_column_name(p_dlnPgas_dlnd_c_E) = 'dlnPgas_dlnd_c_E'
         profile_column_name(p_dlnP_dlnd_c_E) = 'dlnP_dlnd_c_E'
         
         profile_column_name(p_grada_at_face) = 'grada_at_face'
         profile_column_name(p_gradr_div_grada) = 'gradr_div_grada'
         profile_column_name(p_gradr_sub_grada) = 'gradr_sub_grada'
         profile_column_name(p_scale_height) = 'scale_height'
         profile_column_name(p_dt_div_conv_tau) = 'dt_div_conv_tau'
         
         profile_column_name(p_entropy) = 'entropy'
         profile_column_name(p_free_e) = 'free_e'
         profile_column_name(p_logfree_e) = 'logfree_e'
         profile_column_name(p_chiRho) = 'chiRho'
         profile_column_name(p_chiT) = 'chiT'
         profile_column_name(p_dlnRho_dlnT_const_Pgas) = 'dlnRho_dlnT_const_Pgas'
         profile_column_name(p_dlnRho_dlnPgas_const_T) = 'dlnRho_dlnPgas_const_T'
         
         profile_column_name(p_x_mass_fraction_H) = 'x_mass_fraction_H'
         profile_column_name(p_y_mass_fraction_He) = 'y_mass_fraction_He'
         profile_column_name(p_z_mass_fraction_metals) = 'z_mass_fraction_metals'

         profile_column_name(p_abar) = 'abar'
         profile_column_name(p_zbar) = 'zbar'
         profile_column_name(p_z2bar) = 'z2bar'
         profile_column_name(p_ye) = 'ye'
         profile_column_name(p_opacity) = 'opacity'
         profile_column_name(p_dkap_dlnrho_at_face) = 'dkap_dlnrho_at_face'
         profile_column_name(p_dkap_dlnt_at_face) = 'dkap_dlnt_at_face'
         profile_column_name(p_eps_nuc_start) = 'eps_nuc_start'
         profile_column_name(p_eps_nuc) = 'eps_nuc'
         profile_column_name(p_log_abs_eps_nuc) = 'log_abs_eps_nuc'
         profile_column_name(p_burn_num_iters) = 'burn_num_iters'
         profile_column_name(p_burn_num_substeps) = 'burn_num_substeps'

         profile_column_name(p_d_epsnuc_dlnd) = 'd_epsnuc_dlnd'
         profile_column_name(p_d_epsnuc_dlnT) = 'd_epsnuc_dlnT'
         profile_column_name(p_d_lnepsnuc_dlnd) = 'd_lnepsnuc_dlnd'
         profile_column_name(p_d_lnepsnuc_dlnT) = 'd_lnepsnuc_dlnT'
         profile_column_name(p_deps_dlnd_at_face) = 'deps_dlnd_at_face'
         profile_column_name(p_deps_dlnT_at_face) = 'deps_dlnT_at_face'
         profile_column_name(p_eps_nuc_neu_total) = 'eps_nuc_neu_total'
         
         profile_column_name(p_non_nuc_neu) = 'non_nuc_neu'
         profile_column_name(p_nonnucneu_plas) = 'nonnucneu_plas'
         profile_column_name(p_nonnucneu_brem) = 'nonnucneu_brem'
         profile_column_name(p_nonnucneu_phot) = 'nonnucneu_phot'
         profile_column_name(p_nonnucneu_pair) = 'nonnucneu_pair'
         profile_column_name(p_nonnucneu_reco) = 'nonnucneu_reco'
         profile_column_name(p_d_nonnucneu_dlnd) = 'd_nonnucneu_dlnd'
         profile_column_name(p_d_nonnucneu_dlnT) = 'd_nonnucneu_dlnT'
         
         profile_column_name(p_log_irradiation_heat) = 'log_irradiation_heat'
         profile_column_name(p_extra_L) = 'extra_L'
         profile_column_name(p_log_extra_L) = 'log_extra_L'
         profile_column_name(p_extra_jdot) = 'extra_jdot'
         profile_column_name(p_extra_omegadot) = 'extra_omegadot'
         profile_column_name(p_extra_dPdm) = 'extra_dPdm'
         profile_column_name(p_extra_heat) = 'extra_heat'
         profile_column_name(p_cgrav_factor) = 'cgrav_factor'
         profile_column_name(p_dP_dm_visc) = 'dP_dm_visc'
         profile_column_name(p_div_v) = 'div_v'
         profile_column_name(p_area) = 'area'
         profile_column_name(p_area_times_v) = 'area_times_v'
         
         profile_column_name(p_dm_div_4pi_rmid2_rho_dr) = 'dm_div_4pi_rmid2_rho_dr'
         profile_column_name(p_log_rmid3_rho) = 'log_rmid3_rho'
         profile_column_name(p_rmid3_rho) = 'rmid3_rho'
         profile_column_name(p_d_v_div_r_dm) = 'd_v_div_r_dm'
         profile_column_name(p_d_v_div_r_dr) = 'd_v_div_r_dr'
         profile_column_name(p_eta_visc) = 'eta_visc'
         profile_column_name(p_dvdt_visc) = 'dvdt_visc'
         profile_column_name(p_dvdt_grav) = 'dvdt_grav'
         profile_column_name(p_dvdt_dPdm) = 'dvdt_dPdm'
         profile_column_name(p_eps_visc) = 'eps_visc'
         profile_column_name(p_qvisc) = 'qvisc'
         
         profile_column_name(p_log_abs_eps_grav_dm_div_L) = 'log_abs_eps_grav_dm_div_L'
         profile_column_name(p_eps_grav_composition_term) = 'eps_grav_composition_term'
         
         profile_column_name(p_minus_dm_de_plus_dtPdvA) = 'minus_dm_de_plus_dtPdvA'
         profile_column_name(p_dt_dm_eps_grav) = 'dt_dm_eps_grav'
         profile_column_name(p_sum_echeck_from_surf) = 'sum_echeck_from_surf'
         profile_column_name(p_sum_check_eps_grav_from_surf) = 'sum_check_eps_grav_from_surf'
         profile_column_name(p_check_eps_grav) = 'check_eps_grav'
         profile_column_name(p_dm_eps_grav) = 'dm_eps_grav'
         profile_column_name(p_dm_eps_grav_plus_eps_visc) = 'dm_eps_grav_plus_eps_visc'
         profile_column_name(p_minus_dm_eps_visc) = 'minus_dm_eps_visc'
         profile_column_name(p_dm_eps_visc) = 'dm_eps_visc'
         profile_column_name(p_dm_de) = 'dm_de'
         profile_column_name(p_dt_dL) = 'dt_dL'
         profile_column_name(p_dt_PdvA) = 'dt_PdvA'

         profile_column_name(p_eps_grav) = 'eps_grav'
         profile_column_name(p_eps_grav_dm_term_const_q) = 'eps_grav_dm_term_const_q'
         profile_column_name(p_eps_grav_dt_term_const_q) = 'eps_grav_dt_term_const_q'

         profile_column_name(p_env_eps_grav) = 'env_eps_grav'
         profile_column_name(p_rp_div_GMrho_face) = 'rp_div_GMrho_face'
         profile_column_name(p_signed_log_eps_grav) = 'signed_log_eps_grav'
         profile_column_name(p_mlt_mixing_length) = 'mlt_mixing_length'
         profile_column_name(p_log_conv_L_div_L) = 'log_conv_L_div_L'
         profile_column_name(p_conv_L_div_L) = 'conv_L_div_L'
         profile_column_name(p_mlt_Zeta) = 'mlt_Zeta'
         profile_column_name(p_mlt_Gamma) = 'mlt_Gamma'
         profile_column_name(p_mlt_mixing_type) = 'mlt_mixing_type'
         profile_column_name(p_adjust_mlt_gradT_fraction) = 'adjust_mlt_gradT_fraction'
         
         profile_column_name(p_grada_sub_gradT) = 'grada_sub_gradT'
         profile_column_name(p_gradT_sub_grada) = 'gradT_sub_grada'
         profile_column_name(p_gradT_sub_a) = 'gradT_sub_a'
         profile_column_name(p_gradT_div_grada) = 'gradT_div_grada'
         
         profile_column_name(p_gradr_sub_gradT) = 'gradr_sub_gradT'
         profile_column_name(p_gradT_sub_gradr) = 'gradT_sub_gradr'
         profile_column_name(p_gradT_div_gradr) = 'gradT_div_gradr'
         profile_column_name(p_log_gradT_div_gradr) = 'log_gradT_div_gradr'
         
         profile_column_name(p_log_mlt_Gamma) = 'log_mlt_Gamma'
         profile_column_name(p_mlt_mixing_length_start) = 'mlt_mixing_length_start'
         profile_column_name(p_mlt_mixing_type_start) = 'mlt_mixing_type_start'
         profile_column_name(p_mlt_D_start) = 'mlt_D_start'
         profile_column_name(p_mlt_vc_start) = 'mlt_vc_start' 
         profile_column_name(p_mlt_Gamma_start) = 'mlt_Gamma_start' 
         profile_column_name(p_mlt_cdc_start) = 'mlt_cdc_start' 
         
         profile_column_name(p_super_ad) = 'super_ad'         

         profile_column_name(p_delta_r) = 'delta_r'
         profile_column_name(p_delta_L) = 'delta_L'
         profile_column_name(p_delta_cell_vol) = 'delta_cell_vol'
         profile_column_name(p_delta_entropy) = 'delta_entropy'
         profile_column_name(p_delta_T) = 'delta_T'
         profile_column_name(p_delta_rho) = 'delta_rho'
         profile_column_name(p_delta_eps_nuc) = 'delta_eps_nuc'
         profile_column_name(p_delta_mu) = 'delta_mu'

         profile_column_name(p_dlnR_dk) = 'dlnR_dk'
         
         profile_column_name(p_log_D_conv) = 'log_D_conv'
         profile_column_name(p_log_D_soft) = 'log_D_soft'
         profile_column_name(p_log_D_semi) = 'log_D_semi'
         profile_column_name(p_log_D_ovr) = 'log_D_ovr'
         profile_column_name(p_log_D_anon) = 'log_D_anon'
         profile_column_name(p_log_D_thrm) = 'log_D_thrm'
         profile_column_name(p_log_D_minimum) = 'log_D_minimum'
         profile_column_name(p_log_D_mix_non_rotation) = 'log_D_mix_non_rotation'
         
         profile_column_name(p_log_D_mix) = 'log_D_mix'
         profile_column_name(p_d_ln_sig_dlnd00) = 'd_ln_sig_dlnd00'
         profile_column_name(p_d_ln_sig_dlnT00) = 'd_ln_sig_dlnT00'
         profile_column_name(p_d_ln_sig_dlndm1) = 'd_ln_sig_dlndm1'
         profile_column_name(p_d_ln_sig_dlnTm1) = 'd_ln_sig_dlnTm1'
         profile_column_name(p_d_ln_sig_dlnR) = 'd_ln_sig_dlnR'
         profile_column_name(p_d_ln_sig_dL) = 'd_ln_sig_dL'
         profile_column_name(p_d_ln_D_mix_dlnd00) = 'd_ln_D_mix_dlnd00'
         profile_column_name(p_d_ln_D_mix_dlnT00) = 'd_ln_D_mix_dlnT00'
         profile_column_name(p_d_ln_D_mix_dlndm1) = 'd_ln_D_mix_dlndm1'
         profile_column_name(p_d_ln_D_mix_dlnTm1) = 'd_ln_D_mix_dlnTm1'
         profile_column_name(p_d_ln_D_mix_dlnR) = 'd_ln_D_mix_dlnR'
         profile_column_name(p_d_ln_D_mix_dL) = 'd_ln_D_mix_dL'
         profile_column_name(p_d_ln_mlt_D_dlnd00) = 'd_ln_mlt_D_dlnd00'
         profile_column_name(p_d_ln_mlt_D_dlnT00) = 'd_ln_mlt_D_dlnT00'
         profile_column_name(p_d_ln_mlt_D_dlndm1) = 'd_ln_mlt_D_dlndm1'
         profile_column_name(p_d_ln_mlt_D_dlnTm1) = 'd_ln_mlt_D_dlnTm1'
         profile_column_name(p_d_ln_mlt_D_dlnR) = 'd_ln_mlt_D_dlnR'
         profile_column_name(p_d_ln_mlt_D_dL) = 'd_ln_mlt_D_dL'
         
         profile_column_name(p_log_sig_mix) = 'log_sig_mix'
         
         profile_column_name(p_sig_raw_div_sig) = 'sig_raw_div_sig'
         profile_column_name(p_log_conv_vel_old) = 'log_conv_vel_old'
         profile_column_name(p_conv_vel) = 'conv_vel'
         profile_column_name(p_log_conv_vel) = 'log_conv_vel'
         profile_column_name(p_conv_vel_div_csound) = 'conv_vel_div_csound'
         profile_column_name(p_conv_vel_div_L_vel) = 'conv_vel_div_L_vel'
         profile_column_name(p_newly_nonconvective) = 'newly_nonconvective'
         profile_column_name(p_conv_mixing_type) = 'conv_mixing_type'
         profile_column_name(p_log_tau_conv_yrs) = 'log_tau_conv_yrs'
         profile_column_name(p_mixing_type) = 'mixing_type'
         profile_column_name(p_log_mlt_D_mix) = 'log_mlt_D_mix'
         profile_column_name(p_pressure_scale_height) = 'pressure_scale_height'
         profile_column_name(p_actual_gradT) = 'actual_gradT'
         profile_column_name(p_gradT_sub_actual_gradT) = 'gradT_sub_actual_gradT'
         profile_column_name(p_grada_sub_actual_gradT) = 'grada_sub_actual_gradT'

         profile_column_name(p_d_gradT_dlnd00) = 'd_gradT_dlnd00'
         profile_column_name(p_d_gradT_dlnT00) = 'd_gradT_dlnT00'
         profile_column_name(p_d_gradT_dlndm1) = 'd_gradT_dlndm1'
         profile_column_name(p_d_gradT_dlnTm1) = 'd_gradT_dlnTm1'
         profile_column_name(p_d_gradT_dlnR) = 'd_gradT_dlnR'
         profile_column_name(p_d_gradT_dL) = 'd_gradT_dL'

         profile_column_name(p_gradT) = 'gradT'
         profile_column_name(p_gradr) = 'gradr'
         
         profile_column_name(p_dlnP_dm_visc) = 'dlnP_dm_visc'
         profile_column_name(p_accel_div_grav) = 'accel_div_grav'
         
         profile_column_name(p_dlnd_dt_const_q) = 'dlnd_dt_const_q'         
         profile_column_name(p_dlnPgas_dt_const_q) = 'dlnPgas_dt_const_q'
         profile_column_name(p_dlnT_dt_const_q) = 'dlnT_dt_const_q'
         
         profile_column_name(p_dlnd_dt) = 'dlnd_dt'         
         profile_column_name(p_dlnPgas_dt) = 'dlnPgas_dt'
         profile_column_name(p_dlnT_dt) = 'dlnT_dt'
         profile_column_name(p_dlnR_dt) = 'dlnR_dt'
         profile_column_name(p_dr_dt) = 'dr_dt'
         profile_column_name(p_dv_dt) = 'dv_dt'
         
         profile_column_name(p_dlnd) = 'dlnd'         
         profile_column_name(p_dlnPgas) = 'dlnPgas'
         profile_column_name(p_dlnT) = 'dlnT'
         profile_column_name(p_dlnR) = 'dlnR'
         
         
         profile_column_name(p_del_entropy) = 'del_entropy'
         profile_column_name(p_ds_from_eps_grav) = 'ds_from_eps_grav'
         
         profile_column_name(p_energy_check) = 'energy_check'
         profile_column_name(p_vcheck) = 'vcheck'
         profile_column_name(p_echeck) = 'echeck'
         
         profile_column_name(p_cno_div_z) = 'cno_div_z'
         
         profile_column_name(p_lnd_truncation_ratio) = 'lnd_truncation_ratio'
         profile_column_name(p_lnT_truncation_ratio) = 'lnT_truncation_ratio'
         profile_column_name(p_e_truncation_ratio) = 'e_truncation_ratio'
         profile_column_name(p_lnR_truncation_ratio) = 'lnR_truncation_ratio'
         profile_column_name(p_lnPgas_truncation_ratio) = 'lnPgas_truncation_ratio'
         profile_column_name(p_v_truncation_ratio) = 'v_truncation_ratio'
         profile_column_name(p_lum_truncation_ratio) = 'lum_truncation_ratio'
         
         profile_column_name(p_signed_dlnd) = 'signed_dlnd'
         profile_column_name(p_signed_dlnT) = 'signed_dlnT'

         profile_column_name(p_dE) = 'dE'
         profile_column_name(p_dr) = 'dr'
         profile_column_name(p_dv) = 'dv'
         profile_column_name(p_dt_dv_div_dr) = 'dt_dv_div_dr'
         
         profile_column_name(p_dlnH1_dlnP) = 'dlog_h1_dlogP'
         profile_column_name(p_dlnHe3_dlnP) = 'dlog_he3_dlogP'
         profile_column_name(p_dlnHe4_dlnP) = 'dlog_he4_dlogP'
         profile_column_name(p_dlnC12_dlnP) = 'dlog_c12_dlogP'
         profile_column_name(p_dlnC13_dlnP) = 'dlog_c13_dlogP'
         profile_column_name(p_dlnN14_dlnP) = 'dlog_n14_dlogP'
         profile_column_name(p_dlnO16_dlnP) = 'dlog_o16_dlogP'
         profile_column_name(p_dlnNe20_dlnP) = 'dlog_ne20_dlogP'
         profile_column_name(p_dlnMg24_dlnP) = 'dlog_mg24_dlogP'
         profile_column_name(p_dlnSi28_dlnP) = 'dlog_si28_dlogP'

         profile_column_name(p_dlog_pp_dlogP) = 'dlog_pp_dlogP'
         profile_column_name(p_dlog_cno_dlogP) = 'dlog_cno_dlogP'
         profile_column_name(p_dlog_3alf_dlogP) = 'dlog_3alf_dlogP'
         
         profile_column_name(p_dlog_burn_c_dlogP) = 'dlog_burn_c_dlogP'
         profile_column_name(p_dlog_burn_n_dlogP) = 'dlog_burn_n_dlogP'
         profile_column_name(p_dlog_burn_o_dlogP) = 'dlog_burn_o_dlogP'
         
         profile_column_name(p_dlog_burn_ne_dlogP) = 'dlog_burn_ne_dlogP'
         profile_column_name(p_dlog_burn_na_dlogP) = 'dlog_burn_na_dlogP'
         profile_column_name(p_dlog_burn_mg_dlogP) = 'dlog_burn_mg_dlogP'
         
         profile_column_name(p_dlog_cc_dlogP) = 'dlog_cc_dlogP'
         profile_column_name(p_dlog_co_dlogP) = 'dlog_co_dlogP'
         profile_column_name(p_dlog_oo_dlogP) = 'dlog_oo_dlogP'
         
         profile_column_name(p_dlog_burn_si_dlogP) = 'dlog_burn_si_dlogP'
         profile_column_name(p_dlog_burn_s_dlogP) = 'dlog_burn_s_dlogP'
         profile_column_name(p_dlog_burn_ar_dlogP) = 'dlog_burn_ar_dlogP'
         profile_column_name(p_dlog_burn_ca_dlogP) = 'dlog_burn_ca_dlogP'
         profile_column_name(p_dlog_burn_ti_dlogP) = 'dlog_burn_ti_dlogP'
         profile_column_name(p_dlog_burn_cr_dlogP) = 'dlog_burn_cr_dlogP'
         profile_column_name(p_dlog_burn_fe_dlogP) = 'dlog_burn_fe_dlogP'
         
         profile_column_name(p_dlog_pnhe4_dlogP) = 'dlog_pnhe4_dlogP'
         profile_column_name(p_dlog_photo_dlogP) = 'dlog_photo_dlogP'
         profile_column_name(p_dlog_other_dlogP) = 'dlog_other_dlogP'

         profile_column_name(p_total_energy) = 'total_energy'
         profile_column_name(p_total_energy_integral) = 'total_energy_integral'

         profile_column_name(p_log_L_div_CpTMdot) = 'log_L_div_CpTMdot'
         profile_column_name(p_log_mdot_cs) = 'log_mdot_cs'
         profile_column_name(p_log_mdot_v) = 'log_mdot_v'
         profile_column_name(p_cs_at_cell_bdy) = 'cs_at_cell_bdy'
         profile_column_name(p_grad_density) = 'grad_density'
         profile_column_name(p_grad_temperature) = 'grad_temperature'

         profile_column_name(p_log_maxabs_dt_d_dxdt_dt) = 'log_maxabs_dt_d_dxdt_dt'

         profile_column_name(p_gradL) = 'gradL'
         profile_column_name(p_grada_sub_gradr) = 'grada_sub_gradr'
         profile_column_name(p_gradL_sub_gradr) = 'gradL_sub_gradr'
         profile_column_name(p_sch_stable) = 'sch_stable'
         profile_column_name(p_ledoux_stable) = 'ledoux_stable'

         profile_column_name(p_dominant_isoA_for_thermohaline) = 'dominant_isoA_for_thermohaline'
         profile_column_name(p_dominant_isoZ_for_thermohaline) = 'dominant_isoZ_for_thermohaline'
         profile_column_name(p_gradL_composition_term) = 'gradL_composition_term'

         profile_column_name(p_log_brunt_B) = 'log_brunt_B'
         profile_column_name(p_log_brunt_nonB) = 'log_brunt_nonB'
         profile_column_name(p_brunt_B) = 'brunt_B'
         profile_column_name(p_brunt_nonB) = 'brunt_nonB'
         profile_column_name(p_brunt_g_r_div_cs2) = 'brunt_g_r_div_cs2'
         
         profile_column_name(p_brunt_N2) = 'brunt_N2'
         profile_column_name(p_brunt_N2_structure_term) = 'brunt_N2_structure_term'
         profile_column_name(p_brunt_N2_composition_term) = 'brunt_N2_composition_term'
         profile_column_name(p_log_brunt_N2_structure_term) = 'log_brunt_N2_structure_term'
         profile_column_name(p_log_brunt_N2_composition_term) = 'log_brunt_N2_composition_term'
         
         profile_column_name(p_brunt_A_div_x2) = 'brunt_A_div_x2'
         profile_column_name(p_brunt_A) = 'brunt_A'
         profile_column_name(p_log_brunt_N2_dimensionless) = 'log_brunt_N2_dimensionless'
         profile_column_name(p_brunt_N2_dimensionless) = 'brunt_N2_dimensionless'
         profile_column_name(p_brunt_N_dimensionless) = 'brunt_N_dimensionless'
         profile_column_name(p_brunt_N) = 'brunt_N'
         profile_column_name(p_brunt_frequency) = 'brunt_frequency'
         profile_column_name(p_brunt_nu) = 'brunt_nu'
         profile_column_name(p_log_brunt_N) = 'log_brunt_N'
         profile_column_name(p_log_brunt_N2) = 'log_brunt_N2'
         profile_column_name(p_sign_brunt_N2) = 'sign_brunt_N2'
         profile_column_name(p_lamb_S2) = 'lamb_S2'
         profile_column_name(p_lamb_S) = 'lamb_S'
         profile_column_name(p_lamb_Sl1) = 'lamb_Sl1'
         profile_column_name(p_lamb_Sl2) = 'lamb_Sl2'
         profile_column_name(p_lamb_Sl3) = 'lamb_Sl3'
         profile_column_name(p_brunt_N_div_r_integral) = 'brunt_N_div_r_integral'
         profile_column_name(p_brunt_N2_sub_omega2) = 'brunt_N2_sub_omega2'
         profile_column_name(p_sl2_sub_omega2) = 'sl2_sub_omega2'
         profile_column_name(p_k_r_integral) = 'k_r_integral'

         profile_column_name(p_num_steps) = 'num_steps'
         profile_column_name(p_mtx_solve) = 'mtx_solve'
         profile_column_name(p_mtx_factor) = 'mtx_factor'
         profile_column_name(p_avg_order) = 'avg_order'

         profile_column_name(p_log_brunt_nu) = 'log_brunt_nu'
         profile_column_name(p_log_lamb_Sl1) = 'log_lamb_Sl1'
         profile_column_name(p_log_lamb_Sl2) = 'log_lamb_Sl2'
         profile_column_name(p_log_lamb_Sl3) = 'log_lamb_Sl3'
         profile_column_name(p_log_lamb_Sl10) = 'log_lamb_Sl10'

         profile_column_name(p_logQ) = 'logQ'

         profile_column_name(p_dlnX_dr) = 'dlnX_dr'
         profile_column_name(p_dlnY_dr) = 'dlnY_dr'
         profile_column_name(p_dlnRho_dr) = 'dlnRho_dr'
         
         cnt = 0
         do i=1,p_col_id_max
            if (len_trim(profile_column_name(i)) == 0) then
               write(*,*) 'missing name for profile column id', i
               if (i > 1) write(*,*) 'following ' // trim(profile_column_name(i-1))
               write(*,*) 
               cnt = cnt+1
            end if
         end do

         if (cnt > 0) then
            ierr = -1
            return
         end if
         
         nullify(profile_column_names_dict)
         do i=1,p_col_id_max
            call integer_dict_define(profile_column_names_dict, profile_column_name(i), i, ierr)
            if (ierr /= 0) then
               write(*,*) 'FATAL ERROR: profile_column_names_init failed in integer_dict_define'
               return
            end if
         end do

      end subroutine profile_column_names_init         
            
      
		integer function do_get_profile_id(cname)
         use utils_lib
			character (len=*), intent(in)  :: cname 
			! returns id for the profile column if there is a matching name
			! returns 0 otherwise.
			integer :: ierr, value
			call integer_dict_lookup(profile_column_names_dict, cname, value, ierr)
			if (ierr /= 0) value = 0
			do_get_profile_id = value
		end function do_get_profile_id
      


      end module star_profile_def

