


      ! starting specifications
      
         real(dp) :: initial_mass
         real(dp) :: initial_z
         real(dp) :: initial_y
         
      ! definition of core boundaries
         real(dp) :: &
            he_core_boundary_h1_fraction, &
            c_core_boundary_he4_fraction, &
            o_core_boundary_c12_fraction, &
            si_core_boundary_o16_fraction, &
            fe_core_boundary_si28_fraction, &
            neutron_rich_core_boundary_Ye_max, &
            min_boundary_fraction

      ! when to stop
      
         integer :: max_model_number
         real(dp) :: when_to_stop_atol
         real(dp) :: when_to_stop_rtol

         real(dp) :: max_age, max_age_in_seconds, &
            dt_years_for_steps_before_max_age, &
            reduction_factor_for_max_timestep
         integer :: num_adjusted_dt_steps_before_max_age
         real(dp) :: gamma_center_limit
         real(dp) :: eta_center_limit
         real(dp) :: log_center_temp_limit
         real(dp) :: log_center_temp_lower_limit
         real(dp) :: log_center_density_limit, log_center_density_lower_limit
         real(dp) :: log_max_temp_upper_limit, log_max_temp_lower_limit
         real(dp) :: surface_accel_div_grav_limit
         real(dp) :: center_entropy_limit, center_entropy_lower_limit
         real(dp) :: max_entropy_limit, max_entropy_lower_limit
         
   		character (len=iso_name_length) :: &
   		   xa_central_lower_limit_species(num_xa_central_limits)
   		real(dp) :: xa_central_lower_limit(num_xa_central_limits)
         
   		character (len=iso_name_length) :: &
   		   xa_central_upper_limit_species(num_xa_central_limits)
   		real(dp) :: xa_central_upper_limit(num_xa_central_limits)
         
   		character (len=iso_name_length) :: &
   		   xa_surface_lower_limit_species(num_xa_surface_limits)
   		real(dp) :: xa_surface_lower_limit(num_xa_surface_limits)
         
   		character (len=iso_name_length) :: &
   		   xa_surface_upper_limit_species(num_xa_surface_limits)
   		real(dp) :: xa_surface_upper_limit(num_xa_surface_limits)
         
   		character (len=iso_name_length) :: &
   		   xa_average_lower_limit_species(num_xa_average_limits)
   		real(dp) :: xa_average_lower_limit(num_xa_average_limits)
         
   		character (len=iso_name_length) :: &
   		   xa_average_upper_limit_species(num_xa_average_limits)
   		real(dp) :: xa_average_upper_limit(num_xa_average_limits)
         
         real(dp) :: HB_limit
         logical :: stop_at_TP
         real(dp) :: TP_he_shell_max
         
         real(dp) :: star_mass_min_limit, star_mass_max_limit
         real(dp) :: star_H_mass_min_limit, star_H_mass_max_limit
         real(dp) :: star_He_mass_min_limit, star_He_mass_max_limit
         real(dp) :: star_C_mass_min_limit, star_C_mass_max_limit
         real(dp) :: xmstar_min_limit, xmstar_max_limit
         
         real(dp) :: envelope_mass_limit
         real(dp) :: envelope_fraction_left_limit

         real(dp) :: he_core_mass_limit
         real(dp) :: c_core_mass_limit
         real(dp) :: o_core_mass_limit
         real(dp) :: si_core_mass_limit
         real(dp) :: fe_core_mass_limit
         real(dp) :: neutron_rich_core_mass_limit
         
         real(dp) :: he_layer_mass_lower_limit
            
         real(dp) :: abs_diff_lg_LH_lg_Ls_limit
                     
         real(dp) :: Teff_upper_limit
         real(dp) :: Teff_lower_limit
                     
         real(dp) :: photosphere_r_upper_limit
         real(dp) :: photosphere_r_lower_limit
                     
         real(dp) :: log_Teff_upper_limit
         real(dp) :: log_Teff_lower_limit
                     
         real(dp) :: log_Tsurf_upper_limit
         real(dp) :: log_Tsurf_lower_limit
            
         real(dp) :: log_L_upper_limit
         real(dp) :: log_L_lower_limit
            
         real(dp) :: log_g_upper_limit
         real(dp) :: log_g_lower_limit
                     
         real(dp) :: log_Psurf_upper_limit
         real(dp) :: log_Psurf_lower_limit
                     
         real(dp) :: log_Dsurf_upper_limit
         real(dp) :: log_Dsurf_lower_limit
            
         real(dp) :: power_nuc_burn_upper_limit 
         real(dp) :: power_h_burn_upper_limit 
         real(dp) :: power_he_burn_upper_limit 
         real(dp) :: power_c_burn_upper_limit 
            
         real(dp) :: power_nuc_burn_lower_limit 
         real(dp) :: power_h_burn_lower_limit 
         real(dp) :: power_he_burn_lower_limit 
         real(dp) :: power_c_burn_lower_limit 
      
         integer :: max_backups_in_a_row, &
            max_number_backups, max_number_retries, &
            relax_max_number_backups, relax_max_number_retries
            
         real(dp) :: min_timestep_limit, logQ_limit
         real(dp) :: center_Ye_lower_limit, &
            fe_core_infall_limit, non_fe_core_infall_limit
         real(dp) :: v_div_csound_surf_limit
         real(dp) :: Lnuc_div_L_upper_limit, Lnuc_div_L_lower_limit
         real(dp) :: v_surf_div_v_kh_upper_limit, v_surf_div_v_kh_lower_limit
         real(dp) :: v_surf_div_v_esc_limit, Lnuc_div_L_zams_limit
         logical :: stop_near_zams
         real(dp) :: Pgas_div_P_limit, Pgas_div_P_limit_max_q
         real(dp) :: peak_burn_vconv_div_cs_limit, omega_div_omega_crit_limit
         real(dp) :: delta_nu_lower_limit, delta_nu_upper_limit
         real(dp) :: delta_Pg_lower_limit, delta_Pg_upper_limit
         logical :: stop_when_done_with_piston, stop_when_piston_v_goes_negative, &
            stop_when_done_with_center_flash

      ! output of "snapshots" for restarts
      
         integer :: photostep, photo_digits
         character (len=strlen) :: photo_directory


      ! output of logs and profiles
      
         logical :: do_history_file, terminal_show_age_in_years
         integer :: history_interval
         integer :: terminal_interval, terminal_cnt ! cnt is obsolete synomyn
         integer :: write_header_frequency
         character (len=strlen) :: extra_terminal_output_file 
         integer :: num_trace_history_values
         character (len=maxlen_history_column_name) :: trace_history_value_name(50)

         character (len=strlen) :: log_directory 
         character (len=strlen) :: star_history_name
         character (len=strlen) :: star_history_header_name     
         character (len=strlen) :: star_history_dbl_format, &
            star_history_int_format, star_history_txt_format     
               
         logical :: write_profiles_flag
         integer :: profile_interval, priority_profile_interval
         character (len=strlen) :: profiles_index_name
         character (len=strlen) :: profile_data_prefix
         character (len=strlen) :: profile_data_suffix
         character (len=strlen) :: profile_data_header_suffix     
         character (len=strlen) :: profile_dbl_format, profile_int_format, profile_txt_format     
            
         integer :: profile_model
         integer :: max_num_profile_models, max_num_profile_zones

         logical :: write_controls_info_with_profile
         character (len=strlen) :: controls_data_prefix, controls_data_suffix

         logical :: write_model_with_profile
         character (len=strlen) :: model_data_prefix, model_data_suffix

         real(dp) :: mass_loc_for_extra_log_info

         logical :: write_pulse_info_with_profile
         character (len=strlen) :: pulse_info_format, &
            format_for_FGONG_data, format_for_OSC_data
         logical :: &
            add_atmosphere_to_pulse_info, &
            add_center_point_to_pulse_info, &
            keep_surface_point_for_pulse_info
         
         logical :: write_pulsation_plot_data
         integer :: max_num_gyre_points
         
         real(dp) :: fgong_zero_A_inside_r
         real(dp) :: trace_mass_location, &
            min_tau_for_max_abs_v_location, min_q_for_inner_mach1_location, &
            max_q_for_outer_mach1_location
         real(dp) :: mixing_D_limit_for_log
         
      ! burn zone eps definitions for use in logs and profiles
      
         real(dp) :: burn_min1
         real(dp) :: burn_min2
         
      ! limit for max conv vel div csound
      
         real(dp) :: max_conv_vel_div_csound_maxq, max_q_for_limit_conv_vel, &
            max_mass_in_gm_for_limit_conv_vel, max_r_in_cm_for_limit_conv_vel
         integer :: width_for_limit_conv_vel
         
      ! for reported averages

         real(dp) :: surface_avg_abundance_dq
         real(dp) :: center_avg_value_dq

      ! mach1 location offsets
         real(dp) :: mach1_plus_dr_factor
         real(dp) :: mach1_minus_dr_factor
         
      ! definition of core overshooting boundary
         real(dp) :: alpha_bdy_core_overshooting
      
      ! mixing regions
      
         logical :: remove_mixing_glitches, okay_to_remove_mixing_singleton, &
            redo_conv_for_dr_lt_mixing_length, redo_mlt_for_OPEC
         real(dp) :: limit_mixing_length_by_dist_to_bdy, &
            conv_bdy_mix_softening_f0, &
            conv_bdy_mix_softening_f, &
            conv_bdy_mix_softening_min_D_mix
         real(dp) :: min_convective_gap
         real(dp) :: min_thermohaline_gap
         real(dp) :: min_semiconvection_gap
         real(dp) :: min_thermohaline_dropout
         real(dp) :: max_dropout_gradL_sub_grada
         logical :: remove_embedded_semiconvection
         real(dp) :: prune_bad_cz_min_Hp_height
         real(dp) :: prune_bad_cz_min_log_eps_nuc
         
      ! mixing parameters
      
         real(dp) :: alpha_semiconvection, semiconvection_upper_limit_center_h1 
         real(dp) :: thermohaline_coeff
         character (len=32) :: &
            thermohaline_option, MLT_option, semiconvection_option
         real(dp) :: mixing_length_alpha, remove_small_D_limit
         logical :: use_Ledoux_criterion, redo_mix_info_at_each_iteration
         integer :: num_cells_for_smooth_gradL_composition_term
         real(dp) :: clip_D_limit
         logical :: alt_scale_height_flag
         real(dp) :: Henyey_MLT_y_param 
         real(dp) :: Henyey_MLT_nu_param 
         logical :: mlt_use_rotation_correction
            
         real(dp) :: T_mix_limit
         
         logical :: okay_to_reduce_gradT_excess
         real(dp) :: &
            gradT_excess_f1, &
            gradT_excess_f2, &
            gradT_excess_age_fraction, &
            gradT_excess_max_change, &
            gradT_excess_lambda1, &
            gradT_excess_beta1, &
            gradT_excess_lambda2, &
            gradT_excess_beta2, &
            gradT_excess_dlambda, &
            gradT_excess_dbeta, &
            gradT_excess_max_center_h1, &
            gradT_excess_min_center_he4, &
            gradT_excess_max_logT, &
            gradT_excess_min_log_tau_full_on, &
            gradT_excess_max_log_tau_full_off
            
         real(dp) :: conv_dP_term_factor

      ! overshooting parameters
               
         real(dp) :: min_overshoot_q, D_mix_ov_limit, &
            overshoot_alpha, max_brunt_B_for_overshoot

         real(dp) :: overshoot_f_above_nonburn_core
         real(dp) :: overshoot_f_above_nonburn_shell
         real(dp) :: overshoot_f_below_nonburn_shell
         real(dp) :: overshoot_f_above_burn_h_core
         real(dp) :: overshoot_f_above_burn_h_shell
         real(dp) :: overshoot_f_below_burn_h_shell
         real(dp) :: overshoot_f_above_burn_he_core
         real(dp) :: overshoot_f_above_burn_he_shell
         real(dp) :: overshoot_f_below_burn_he_shell
         real(dp) :: overshoot_f_above_burn_z_core
         real(dp) :: overshoot_f_above_burn_z_shell
         real(dp) :: overshoot_f_below_burn_z_shell      
         
         real(dp) :: overshoot_f0_above_nonburn_core
         real(dp) :: overshoot_f0_above_nonburn_shell
         real(dp) :: overshoot_f0_below_nonburn_shell
         real(dp) :: overshoot_f0_above_burn_h_core
         real(dp) :: overshoot_f0_above_burn_h_shell
         real(dp) :: overshoot_f0_below_burn_h_shell
         real(dp) :: overshoot_f0_above_burn_he_core
         real(dp) :: overshoot_f0_above_burn_he_shell
         real(dp) :: overshoot_f0_below_burn_he_shell       
         real(dp) :: overshoot_f0_above_burn_z_core
         real(dp) :: overshoot_f0_above_burn_z_shell
         real(dp) :: overshoot_f0_below_burn_z_shell       

         real(dp) :: step_overshoot_f_above_nonburn_core
         real(dp) :: step_overshoot_f_above_nonburn_shell
         real(dp) :: step_overshoot_f_below_nonburn_shell
         real(dp) :: step_overshoot_f_above_burn_h_core
         real(dp) :: step_overshoot_f_above_burn_h_shell
         real(dp) :: step_overshoot_f_below_burn_h_shell
         real(dp) :: step_overshoot_f_above_burn_he_core
         real(dp) :: step_overshoot_f_above_burn_he_shell
         real(dp) :: step_overshoot_f_below_burn_he_shell
         real(dp) :: step_overshoot_f_above_burn_z_core
         real(dp) :: step_overshoot_f_above_burn_z_shell
         real(dp) :: step_overshoot_f_below_burn_z_shell
         
         real(dp) :: step_overshoot_D
         real(dp) :: step_overshoot_D0_coeff

         real(dp) :: overshoot_below_noburn_shell_factor         
         integer :: max_DUP_counter         

         real(dp) :: ovr_below_burn_he_shell_factor         
         
         real(dp) :: overshoot_D2_above_nonburn
         real(dp) :: overshoot_D2_below_nonburn
         real(dp) :: overshoot_D2_above_burn_h
         real(dp) :: overshoot_D2_below_burn_h
         real(dp) :: overshoot_D2_above_burn_he
         real(dp) :: overshoot_D2_below_burn_he       
         real(dp) :: overshoot_D2_above_burn_z
         real(dp) :: overshoot_D2_below_burn_z       

         
         real(dp) :: overshoot_f2_above_nonburn
         real(dp) :: overshoot_f2_below_nonburn
         real(dp) :: overshoot_f2_above_burn_h
         real(dp) :: overshoot_f2_below_burn_h
         real(dp) :: overshoot_f2_above_burn_he
         real(dp) :: overshoot_f2_below_burn_he       
         real(dp) :: overshoot_f2_above_burn_z
         real(dp) :: overshoot_f2_below_burn_z       

         real(dp) :: mass_for_overshoot_full_on         
         real(dp) :: mass_for_overshoot_full_off     

         real(dp) :: radiation_turbulence_coeff, &
            turbulent_diffusion_D0, turbulent_diffusion_rho_max, &
            min_T_for_acceleration_limited_conv_velocity, max_conv_vel_div_csound, &
            mlt_accel_g_theta

         logical :: smooth_convective_bdy
         real(dp) :: max_delta_limit_for_smooth, max_dR_div_Hp_for_smooth
      
      ! brunt
         logical :: calculate_Brunt_N2, use_brunt_dlnRho_form, &
            use_brunt_gradmuX_form, interpolate_rho_for_pulsation_info
         real(dp) :: min_magnitude_brunt_B, brunt_N2_coefficient
         integer :: num_cells_for_smooth_brunt_B
         
      ! atmosphere -- surface boundary conditions
      
         character (len=strlen) :: which_atm_option, which_atm_off_table_option
         logical :: atm_switch_to_grey_as_backup
         real(dp) :: Pextra_factor
         real(dp) :: atm_fixed_Teff, atm_fixed_Tsurf, atm_fixed_Psurf
         real(dp) :: atm_grey_and_kap_atol
         real(dp) :: atm_grey_and_kap_rtol
         integer :: atm_grey_and_kap_max_tries
         logical :: trace_atm_grey_and_kap
         
         real(dp) :: atm_grey_irradiated_atol
         real(dp) :: atm_grey_irradiated_rtol
         real(dp) :: atm_grey_irradiated_T_eq
         real(dp) :: atm_grey_irradiated_kap_v
         real(dp) :: atm_grey_irr_kap_v_div_kap_th
         real(dp) :: atm_grey_irradiated_P_surf
         integer :: atm_grey_irradiated_max_tries
         logical :: atm_grey_irradiated_simple_kap_th
         logical :: trace_atm_grey_irradiated
         
         real(dp) :: atm_int_errtol
         integer :: dump_int_atm_info_model_number
         
         logical :: trace_atm_Paczynski_grey
         real(dp) :: Paczynski_atm_R_surf_errtol

         real(dp) :: surface_extra_Pgas
         
         logical :: use_atm_PT_at_center_of_surface_cell, &
            use_hydrodynamic_surface_BCs, use_momentum_eqn_outer_BC
         
      ! create atmosphere

         real(dp) :: create_atm_max_step_size


      ! mass gain or loss
      
         real(dp) :: mass_change
         
         real(dp) :: mass_change_full_on_dt, mass_change_full_off_dt
         logical :: trace_dt_control_mass_change

         logical :: use_accreted_material_j
         real(dp) :: accreted_material_j
         
         real(dp) :: min_wind, max_wind
         real(dp) :: min_abs_mdot_for_change_limits, max_abs_mdot_factor, min_abs_mdot_factor

         real(dp) :: mdot_omega_power, max_rotational_mdot_boost, lim_trace_rotational_mdot_boost, &
            rotational_mdot_boost_fac, rotational_mdot_kh_fac, surf_avg_tau, surf_avg_tau_min, &
            max_mdot_jump_for_rotation
         
         real(dp) :: remove_H_wind_mdot, remove_H_wind_H_mass_limit

         real(dp) :: super_eddington_wind_eta, super_eddington_wind_Ledd_factor, &
            wind_boost_full_off_L_div_Ledd, wind_boost_full_on_L_div_Ledd, &
            super_eddington_wind_max_boost
         logical :: trace_super_eddington_wind_boost
         
         character (len=strlen) :: RGB_wind_scheme
         character (len=strlen) :: AGB_wind_scheme
         real(dp) :: RGB_to_AGB_wind_switch
            
         real(dp) :: Reimers_wind_eta  
         real(dp) :: Blocker_wind_eta  
         real(dp) :: de_Jager_wind_eta  
         real(dp) :: van_Loon_wind_eta
         real(dp) :: Nieuwenhuijzen_wind_eta
         real(dp) :: Vink_wind_eta
         real(dp) :: Grafener_wind_eta
         real(dp) :: Kudritzki_wind_eta
         real(dp) :: Dutch_wind_eta  
         character (len=strlen) :: Dutch_wind_lowT_scheme
         real(dp) :: Stern51_wind_eta  

         real(dp) :: wind_envelope_limit
            
         ! composition of accreted material
         logical :: accrete_same_as_surface
         
         logical :: accrete_given_mass_fractions
         integer :: num_accretion_species
         character (len=iso_name_length) :: accretion_species_id(max_num_accretion_species)
         real(dp) :: accretion_species_xa(max_num_accretion_species)

         real(dp) :: accretion_h1, accretion_h2, accretion_he3, accretion_he4
         integer :: accretion_zfracs
         logical :: accretion_dump_missing_metals_into_heaviest

         ! special list of z fractions
         real(dp) :: z_fraction_li
         real(dp) :: z_fraction_be
         real(dp) :: z_fraction_b
         real(dp) :: z_fraction_c
         real(dp) :: z_fraction_n
         real(dp) :: z_fraction_o
         real(dp) :: z_fraction_f
         real(dp) :: z_fraction_ne
         real(dp) :: z_fraction_na
         real(dp) :: z_fraction_mg
         real(dp) :: z_fraction_al
         real(dp) :: z_fraction_si
         real(dp) :: z_fraction_p
         real(dp) :: z_fraction_s
         real(dp) :: z_fraction_cl
         real(dp) :: z_fraction_ar
         real(dp) :: z_fraction_k
         real(dp) :: z_fraction_ca
         real(dp) :: z_fraction_sc
         real(dp) :: z_fraction_ti
         real(dp) :: z_fraction_v
         real(dp) :: z_fraction_cr
         real(dp) :: z_fraction_mn
         real(dp) :: z_fraction_fe
         real(dp) :: z_fraction_co
         real(dp) :: z_fraction_ni
         real(dp) :: z_fraction_cu
         real(dp) :: z_fraction_zn
         
         real(dp) :: lgT_hi_for_set_new_abundances, lgT_lo_for_set_new_abundances
         real(dp) :: pure_fe56_limit

         ! automatic stops for mass loss/gain
         
         real(dp) :: max_star_mass_for_gain, min_star_mass_for_loss
         real(dp) :: max_T_center_for_any_mass_loss, max_T_center_for_full_mass_loss
         
         
      ! extra power source
         
         real(dp) :: extra_power_source
         
      
      ! relaxation parameters
      
         real(dp) :: relax_dY
         real(dp) :: relax_dlnZ


      ! mesh adjustment controls
   
         real(dp) :: mesh_delta_coeff
         real(dp) :: mesh_Pgas_div_P_exponent
         real(dp) :: mesh_delta_coeff_pre_ms
         real(dp) :: mesh_delta_coeff_for_highT
         real(dp) :: logT_max_for_standard_mesh_delta_coeff
         real(dp) :: logT_min_for_highT_mesh_delta_coeff
         real(dp) :: remesh_dt_limit
         real(dp) :: remesh_log_L_nuc_burn_min
         
         logical :: okay_to_remesh, trace_mesh_adjust_error_in_conservation
         real(dp) :: remesh_max_brunt_N2_composition_term
         integer :: remesh_cnt
         integer :: max_allowed_nz
         
         real(dp) :: mesh_max_allowed_ratio, remesh_max_allowed_logT
         
         real(dp) :: max_delta_x_for_merge
         
         logical :: show_mesh_changes
         
         logical :: mesh_adjust_use_quadratic, &
            mesh_adjust_get_T_from_E
         
         integer :: mesh_dump_call_number

         real(dp) :: max_dq, min_dq, min_dq_for_xa
         real(dp) :: mesh_min_dlnR
         logical :: merge_if_dlnR_too_small
         real(dp) :: mesh_min_dr_div_cs
         logical :: merge_if_dr_div_cs_too_small
                  
         real(dp) :: max_center_cell_dq
         real(dp) :: max_surface_cell_dq
         integer :: max_num_subcells
         integer :: max_num_merge_cells
   		   		
         real(dp) :: xtra_coef_above_xtrans
         real(dp) :: xtra_coef_below_xtrans
         real(dp) :: xtra_dist_above_xtrans
         real(dp) :: xtra_dist_below_xtrans
   		   		
         real(dp) :: xtra_coef_czb_full_on
         real(dp) :: xtra_coef_czb_full_off
   		   		
         real(dp) :: xtra_coef_a_l_nb_czb
         real(dp) :: xtra_coef_a_l_hb_czb
         real(dp) :: xtra_coef_a_l_heb_czb
         real(dp) :: xtra_coef_a_l_zb_czb
         real(dp) :: xtra_coef_b_l_nb_czb
         real(dp) :: xtra_coef_b_l_hb_czb
         real(dp) :: xtra_coef_b_l_heb_czb
         real(dp) :: xtra_coef_b_l_zb_czb
         real(dp) :: xtra_coef_a_u_nb_czb
         real(dp) :: xtra_coef_a_u_hb_czb
         real(dp) :: xtra_coef_a_u_heb_czb
         real(dp) :: xtra_coef_a_u_zb_czb
         real(dp) :: xtra_coef_b_u_nb_czb
         real(dp) :: xtra_coef_b_u_hb_czb
         real(dp) :: xtra_coef_b_u_heb_czb
         real(dp) :: xtra_coef_b_u_zb_czb

         real(dp) :: xtra_dist_a_l_nb_czb
         real(dp) :: xtra_dist_a_l_hb_czb
         real(dp) :: xtra_dist_a_l_heb_czb
         real(dp) :: xtra_dist_a_l_zb_czb
         real(dp) :: xtra_dist_b_l_nb_czb
         real(dp) :: xtra_dist_b_l_hb_czb
         real(dp) :: xtra_dist_b_l_heb_czb
         real(dp) :: xtra_dist_b_l_zb_czb
         real(dp) :: xtra_dist_a_u_nb_czb
         real(dp) :: xtra_dist_a_u_hb_czb
         real(dp) :: xtra_dist_a_u_heb_czb
         real(dp) :: xtra_dist_a_u_zb_czb
         real(dp) :: xtra_dist_b_u_nb_czb
         real(dp) :: xtra_dist_b_u_hb_czb
         real(dp) :: xtra_dist_b_u_heb_czb
         real(dp) :: xtra_dist_b_u_zb_czb
   		   		
         real(dp) :: xtra_coef_os_full_on
         real(dp) :: xtra_coef_os_full_off
   		
         real(dp) :: xtra_coef_os_above_nonburn
         real(dp) :: xtra_coef_os_below_nonburn
         real(dp) :: xtra_coef_os_above_burn_h
         real(dp) :: xtra_coef_os_below_burn_h
         real(dp) :: xtra_coef_os_above_burn_he
         real(dp) :: xtra_coef_os_below_burn_he
         real(dp) :: xtra_coef_os_above_burn_z
         real(dp) :: xtra_coef_os_below_burn_z
         
         real(dp) :: xtra_dist_os_above_nonburn
         real(dp) :: xtra_dist_os_below_nonburn
         real(dp) :: xtra_dist_os_above_burn_h
         real(dp) :: xtra_dist_os_below_burn_h
         real(dp) :: xtra_dist_os_above_burn_he
         real(dp) :: xtra_dist_os_below_burn_he
         real(dp) :: xtra_dist_os_above_burn_z
         real(dp) :: xtra_dist_os_below_burn_z
         
         real(dp) :: xtra_coef_scz_above_nb_cz
         real(dp) :: xtra_coef_scz_above_hb_cz
         real(dp) :: xtra_coef_scz_above_heb_cz
         real(dp) :: xtra_coef_scz_above_zb_cz

         
   		character (len=iso_name_length) :: mesh_logX_species(num_mesh_logX)
         real(dp) :: mesh_logX_min_for_extra(num_mesh_logX)
         real(dp) :: mesh_dlogX_dlogP_extra(num_mesh_logX)
         real(dp) :: mesh_dlogX_dlogP_full_on(num_mesh_logX)
         real(dp) :: mesh_dlogX_dlogP_full_off(num_mesh_logX)

         real(dp) :: convective_bdy_weight, &
            convective_bdy_dq_limit, convective_bdy_min_dt_yrs

         real(dp) :: mesh_dlog_eps_min_for_extra
         real(dp) :: mesh_dlog_eps_dlogP_full_on
         real(dp) :: mesh_dlog_eps_dlogP_full_off

         real(dp) :: mesh_dlog_pp_dlogP_extra
         real(dp) :: mesh_dlog_cno_dlogP_extra
         real(dp) :: mesh_dlog_3alf_dlogP_extra
         
         real(dp) :: mesh_dlog_burn_c_dlogP_extra
         real(dp) :: mesh_dlog_burn_n_dlogP_extra
         real(dp) :: mesh_dlog_burn_o_dlogP_extra
         real(dp) :: mesh_dlog_burn_ne_dlogP_extra
         real(dp) :: mesh_dlog_burn_na_dlogP_extra
         real(dp) :: mesh_dlog_burn_mg_dlogP_extra
         real(dp) :: mesh_dlog_burn_si_dlogP_extra
         real(dp) :: mesh_dlog_burn_s_dlogP_extra
         real(dp) :: mesh_dlog_burn_ar_dlogP_extra
         real(dp) :: mesh_dlog_burn_ca_dlogP_extra
         real(dp) :: mesh_dlog_burn_ti_dlogP_extra
         real(dp) :: mesh_dlog_burn_cr_dlogP_extra
         real(dp) :: mesh_dlog_burn_fe_dlogP_extra
         
         real(dp) :: mesh_dlog_cc_dlogP_extra
         real(dp) :: mesh_dlog_co_dlogP_extra
         real(dp) :: mesh_dlog_oo_dlogP_extra
         
         real(dp) :: mesh_dlog_pnhe4_dlogP_extra
         real(dp) :: mesh_dlog_photo_dlogP_extra
         real(dp) :: mesh_dlog_other_dlogP_extra

   		real(dp) :: P_function_weight
         
   		real(dp) :: T_function1_weight
   		real(dp) :: T_function2_weight
   		real(dp) :: T_function2_param
                  
   		real(dp) :: R_function_weight
   		real(dp) :: R_function_param
                  
   		real(dp) :: R_function2_weight
   		real(dp) :: R_function2_param1
   		real(dp) :: R_function2_param2
         
   		real(dp) :: M_function_weight
   		real(dp) :: M_function_param
   		
   		real(dp) :: gradT_function_weight
   		real(dp) :: log_tau_function_weight
   		real(dp) :: log_kap_function_weight
   		real(dp) :: omega_function_weight

   		real(dp) :: gam_function_weight, gam_function_param1, gam_function_param2
         
   		character (len=iso_name_length) :: xa_function_species(num_xa_function)
   		real(dp) :: xa_function_weight(num_xa_function)
   		real(dp) :: xa_function_param(num_xa_function)
   		real(dp) :: xa_mesh_delta_coeff(num_xa_function)
         

      ! nuclear reaction parameters
      
         character (len=strlen) :: screening_mode, default_net_name
         real(dp) :: net_logTcut_lo, net_logTcut_lim
         
         real(dp) :: reaction_neuQs_factor

         real(dp) :: weak_rate_factor, mix_factor, dxdt_nuc_factor, &
            fe56ec_fake_factor, max_abar_for_burning

      
      ! extra heat near surface to model irradiation
         
         real(dp) :: column_depth_for_irradiation
         real(dp) :: irradiation_flux
         
         
      ! extra heat
      
         real(dp) :: inject_uniform_extra_heat, &
            min_q_for_uniform_extra_heat, &
            max_q_for_uniform_extra_heat
      
         real(dp) :: inject_extra_ergs_sec, &
            base_of_inject_extra_ergs_sec, &
            total_mass_for_inject_extra_ergs_sec, &
            start_time_for_inject_extra_ergs_sec, &
            duration_for_inject_extra_ergs_sec, &
            inject_until_reach_delta_total_energy
         
         
      ! element diffusion parameters

         logical :: show_diffusion_info, show_diffusion_substep_info, &
            show_diffusion_timing

         logical :: do_element_diffusion
         logical :: diffusion_use_iben_macdonald
         real(dp) :: diffusion_dt_limit
         real(dp) :: diffusion_min_dq_at_surface, diffusion_dt_div_timescale, &
            diffusion_min_T_at_surface, diffusion_min_dq_ratio_at_surface
         integer :: diffusion_min_num_substeps
         
         real(dp) :: diffusion_min_X_hard_limit
         real(dp) :: diffusion_X_total_atol, diffusion_X_total_rtol
         real(dp) :: diffusion_v_max, diffusion_upwind_abs_v_limit
         real(dp) :: diffusion_gamma_full_off
         real(dp) :: diffusion_gamma_full_on
         real(dp) :: diffusion_T_full_on
         real(dp) :: diffusion_T_full_off

         real(dp) :: diffusion_Vlimit_dm_full_on
         real(dp) :: diffusion_Vlimit_dm_full_off
         real(dp) :: diffusion_Vlimit
         
         logical :: diffusion_calculates_ionization
         integer :: diffusion_nsmooth_typical_charge, &
            diffusion_max_iters_per_substep, &
            diffusion_max_retries_per_substep
         real(dp) :: &
            diffusion_tol_correction_max, diffusion_tol_correction_norm
         
         real(dp) :: diffusion_AD_dm_full_on
         real(dp) :: diffusion_AD_dm_full_off
         real(dp) :: diffusion_AD_boost_factor
         
         real(dp) :: diffusion_GT_factor, diffusion_SIG_factor
         
         real(dp) :: diffusion_max_T_for_radaccel, diffusion_min_T_for_radaccel
         logical :: diffusion_screening_for_radaccel
         character (len=strlen) :: op_mono_data_path, op_mono_data_cache_filename
         
         integer :: diffusion_num_classes
   		character (len=iso_name_length) :: &
   		   diffusion_class_representative(max_num_diffusion_classes)
         real(dp) :: diffusion_class_A_max(max_num_diffusion_classes)
         real(dp) :: diffusion_class_typical_charge(max_num_diffusion_classes)
         real(dp) :: diffusion_class_factor(max_num_diffusion_classes)
         
         logical :: diffusion_use_isolve
         real(dp) :: diffusion_rtol_for_isolve
         real(dp) :: diffusion_atol_for_isolve
         integer :: diffusion_maxsteps_for_isolve
         character(len=64) :: diffusion_isolve_solver


      ! eos controls
         logical :: &
            use_eosDT_ideal_gas, &
            use_eosDT_HELMEOS, &       
            eosDT_HELMEOS_include_radiation, &
            eosDT_HELMEOS_always_skip_elec_pos, &
            use_fixed_XZ_for_eos, use_eosDE_get
         real(dp) :: fixed_X_for_eos, fixed_Z_for_eos
         
      
      ! opacity controls
         
         logical :: cubic_interpolation_in_X
         logical :: cubic_interpolation_in_Z
         logical :: include_electron_conduction
      
         logical :: use_simple_es_for_kap

         logical :: use_Type2_opacities
         real(dp) :: Zbase
         real(dp) :: kap_Type2_full_off_X, kap_Type2_full_on_X
         real(dp) :: kap_Type2_full_off_dZ, kap_Type2_full_on_dZ

         real(dp) :: opacity_max, opacity_factor
         real(dp) :: min_logT_for_opacity_factor_off
         real(dp) :: min_logT_for_opacity_factor_on
         real(dp) :: max_logT_for_opacity_factor_on
         real(dp) :: max_logT_for_opacity_factor_off
         real(dp) :: &
            low_logT_op_mono_full_off, low_logT_op_mono_full_on, &
            high_logT_op_mono_full_off, high_logT_op_mono_full_on, &
            op_mono_min_X_to_include
         logical :: use_op_mono_alt_get_kap

            
      ! asteroseismology controls
         
         logical :: get_delta_nu_from_scaled_solar
         real(dp) :: nu_max_sun, delta_nu_sun, Teff_sun, delta_Pg_mode_freq

         
      ! hydro parameters

         real(dp) :: eps_nuc_factor, max_abs_eps_nuc
         real(dp) :: non_nuc_neu_factor         
         real(dp) :: eps_grav_factor
         real(dp) :: accel_factor

         logical :: eps_grav_dt_use_start_values, &
            use_gr_factors, use_mass_corrections, &
            use_dP_dm_rotation_correction, use_sr_sound_speed, &
            use_dvdt_form_of_momentum_eqn, &
            use_dlnddt_form_of_density_eqn, use_dedt_form_of_energy_eqn
         
         logical :: use_dPrad_dm_form_of_T_gradient_eqn
               
         logical :: use_artificial_viscosity, &
            hold_artificial_viscosity_const_during_step
         real(dp) :: qmin_freeze_non_radiative_luminosity, &
            qmax_zero_non_radiative_luminosity, &
            artificial_viscosity_Q_shift, &
            art_visc_full_off_logRho_le_this, &
            art_visc_full_on_logRho_ge_this, &
            post_shock_viscosity_decay_factor, &
            pre_shock_viscosity_decay_factor
         real(dp) :: eps_visc_factor, dvdt_visc_factor
         real(dp) :: shock_spread_quadratic, shock_spread_linear

         real(dp) :: &
            center_flash_total_time, &
            center_flash_ramp_up_duration, &
            center_flash_ramp_down_duration, &
            center_flash_total_ergs
         
         logical :: use_energy_conservation_form, use_ODE_var_eqn_pairing, &
            trace_truncation_ratio, &
            ebdf_redo_mix_coeffs_other_stages, &
            ebdf_redo_mix_for_comparison_stage, &
            ebdf_redo_mix_for_final_stage, &
            use_bdf_instead_of_ebdf, &
            use_sdirk_instead_of_ebdf, &
            use_symplectic_instead_of_ebdf
            
         real(dp) :: theta_P
         
         integer :: &
            max_ebdf_order, &
            min_ebdf_order, &
            steps_before_try_higher_ebdf_order
         real(dp) :: factor_for_ebdf_order_tests
            
         logical :: use_piston, reset_total_energy_initial_when_done_with_piston
         real(dp) :: piston_inward_time, &
            piston_Rmin, piston_v0, piston_Rmax, &
            piston_period, &
            periodic_piston_max_displacement, &
            periodic_piston_number_of_cycles, &
            periodic_piston_done_delay

         logical :: use_lnS_for_eps_grav, &
            use_dEdRho_form_for_eps_grav, &
            use_dlnd_dt_form_for_eps_grav, &
            use_PdVdt_form_for_eps_grav, &
            include_dmu_dt_in_eps_grav, zero_eps_grav_in_just_added_material
         real(dp) :: min_del_T_div_dt, accretion_entropy_at_surface, &
            velocity_logT_lower_bound, factor_for_test_CpT_absMdot_div_L, &
            max_dt_yrs_for_velocity_logT_lower_bound, velocity_q_upper_bound
         real(dp) :: eps_grav_time_deriv_separation
         real(dp) :: Gamma_lnS_eps_grav_full_on, Gamma_lnS_eps_grav_full_off
         integer :: max_num_surf_revisions
         real(dp) :: max_abs_rel_change_surf_lnS
         
         real(dp) :: &
            max_logT_for_k_below_Eulerian_eps_grav, &
            max_q_for_k_below_Eulerian_eps_grav, &
            min_q_for_k_below_Eulerian_eps_grav, &
            min_dxm_Eulerian_div_dxm_CpTMdot_lt_L, &
            min_dxm_Eulerian_div_dxm_removed, &
            min_dxm_Eulerian_div_dxm_added, &
            max_logT_for_k_Lagrangian_eps_grav, &
            max_q_for_k_Lagrangian_eps_grav, &
            min_q_for_k_Lagrangian_eps_grav
            
         integer :: min_cells_for_Eulerian_to_Lagrangian_transition

         integer :: split_mixing_choice, op_split_burn_mix_num_passes
         logical :: op_split_newton_do_substep_burns, split_mix_do_burn

         real(dp) :: op_split_burn_use_quad_min_T
         real(dp) :: op_split_burn_use_DGESVX_min_T
         real(dp) :: op_split_burn_refine_min_T
         real(dp) :: op_split_mix_atol, op_split_mix_rtol
         integer :: op_split_burn_max_iterations
         logical :: burn_pause_for_failure
         logical :: burn_reuse_given_rates
         logical :: burn_try_substeps_if_BE_fails
         real(dp) :: burn_maxabs_dt_d_dxdt_dt
         real(dp) :: op_split_burn_tol_max_correction
         real(dp) :: op_split_burn_tol_avg_correction
         real(dp) :: op_split_burn_lambda_undercorrection
         real(dp) :: op_split_burn_tol_hi_logT_limit
         real(dp) :: op_split_burn_tol_hi_logT_factor
         real(dp) :: op_split_burn_refine_maxerr_limit
         
         integer :: op_split_do_burn_mix_before_struct
         integer :: op_split_do_burn_mix_after_struct
         logical :: op_split_do_hydro_prediction
         logical :: op_split_do_burn_mix_half_and_half
         logical :: op_split_mix_trace
         logical :: op_split_burn_mix_trace
         logical :: op_split_burn_trace
         integer :: op_split_burn_sparse_limit
         logical :: op_split_burn_use_net_info_for_sparsity, &
            op_split_burn_use_pivoting, reset_mixing_info_before_final_mix
         real(dp) :: op_split_burn_min_lambda
         real(dp) :: op_split_burn_min_logT_for_partials
         real(dp) :: op_split_burn_partials_dlogRho
         real(dp) :: op_split_burn_partials_dlogT
         
         real(dp) :: substep_min_T
         real(dp) :: burn_stptry, burn_eps, burn_odescal
         integer :: burn_max_steps

         character(len=64) :: substep_burn_solver
         character(len=64) :: substep_burn_decsol
         integer :: substep_burn_max_steps
         real(dp) :: substep_burn_rtol
         real(dp) :: substep_burn_atol
         real(dp) :: substep_burn_xmin
         real(dp) :: substep_burn_xmax
         logical :: substep_burn_clip
         logical :: substep_burn_use_eps_binding
         
         integer :: op_split_burn_k_dbg, op_split_burn_dbg_model_number

         logical :: include_L_in_error_est
         logical :: include_v_in_error_est
         logical :: just_use_energy_resid
         
         logical :: trace_newton_damping
         
         real(dp) :: tol_correction_norm, tol_correction_norm_alt
         real(dp) :: tol_max_correction, tol_max_correction_alt
         real(dp) :: sizeB_gam0, size_del_gam
         real(dp) :: correction_xa_limit
         real(dp) :: tol_correction_high_T_limit, &
            tol_correction_norm_high_T, tol_max_correction_high_T
         real(dp) :: tol_correction_extreme_T_limit, &
            tol_correction_norm_extreme_T, tol_max_correction_extreme_T
         
         real(dp) :: tol_residual_norm1, tol_max_residual1
         real(dp) :: tol_residual_norm2, tol_max_residual2
         real(dp) :: tol_residual_norm3, tol_max_residual3
         integer :: max_iterations_for_jacobian
         logical :: refine_solution, refine_mtx_solution
         
         logical :: star_bcyclic_do_pivot
         real(dp) :: sparse_min_refactor_rgrowth

         integer :: hydro_decsol_switch
         character (len=32) :: small_mtx_decsol, large_mtx_decsol
         
         real(dp) :: sparse_non_zero_max_factor, thomas_blck_sprs_clip_lim

         integer :: iter_for_resid_tol2, iter_for_resid_tol3
         
         integer :: newton_itermin, newton_itermin_until_reduce_min_corr_coeff
         logical :: do_newton_damping_for_neg_xa
         real(dp) :: hydro_mtx_max_allowed_abs_dlogT, &
            hydro_mtx_max_allowed_abs_dlogRho, &
            hydro_mtx_max_allowed_abs_dlogPgas, &
            min_logT_for_hydro_mtx_max_allowed, &
            hydro_mtx_max_allowed_logT, &
            hydro_mtx_max_allowed_logRho, &
            hydro_mtx_max_allowed_logPgas, &
            newton_reduced_min_corr_coeff
                  
         character (len=32) :: hydro_solver_name

         integer :: tiny_corr_coeff_limit
         real(dp) :: scale_correction_norm
         real(dp) :: corr_param_factor
         real(dp) :: scale_max_correction
         real(dp) :: corr_norm_jump_limit
         real(dp) :: max_corr_jump_limit
         real(dp) :: resid_norm_jump_limit
         real(dp) :: max_resid_jump_limit
         real(dp) :: corr_coeff_limit
         real(dp) :: tiny_corr_factor

         integer :: max_tries, max_tries1
         integer :: max_tries_for_retry, max_tries_after_5_retries, &
            max_tries_after_10_retries, max_tries_after_20_retries
         integer :: max_tries_after_backup, max_tries_after_backup2
      
         integer :: retry_limit, redo_limit

         real(dp) :: sig_term_limit, sig_min_factor_for_high_Tcenter, &
            Tcenter_min_for_sig_min_factor_full_on, &
            Tcenter_max_for_sig_min_factor_full_off, &
            max_delta_m_to_bdy_for_sig_min_factor, &
            delta_m_lower_for_sig_min_factor, &
            delta_m_upper_for_sig_min_factor, &
            Tcenter_max_for_dble_bcyclic
                  
         ! rotation
         logical :: set_uniform_am_nu_non_rot
         real(dp) :: uniform_am_nu_non_rot         

         logical :: set_min_am_nu_non_rot
         real(dp) :: min_am_nu_non_rot, min_center_Ye_for_min_am_nu_non_rot
         
         logical :: set_min_D_mix
         real(dp) :: min_D_mix, min_center_Ye_for_min_D_mix    
         
         logical :: op_split_gradT_fraction_grada 

         real(dp) :: smooth_outer_xa_big, smooth_outer_xa_small
         
         real(dp) :: am_sig_term_limit
         real(dp) :: am_D_mix_factor, am_gradmu_factor, &
            am_nu_factor, am_nu_non_rotation_factor
         logical :: skip_rotation_in_convection_zones
         
         real(dp) :: am_nu_DSI_factor, am_nu_SH_factor, am_nu_SSI_factor, &
            am_nu_ES_factor, am_nu_GSF_factor, am_nu_ST_factor, am_nu_visc_factor
            
         real(dp) :: &
            am_nu_omega_rot_factor, am_nu_omega_non_rot_factor, &
            am_nu_j_rot_factor, am_nu_j_non_rot_factor
         
         real(dp) :: D_visc_factor, D_DSI_factor, D_SH_factor, D_SSI_factor, &
            D_ES_factor, D_GSF_factor, D_ST_factor
         
         integer :: smooth_D_DSI, smooth_D_SH, smooth_D_SSI, &
            smooth_D_ES, smooth_D_GSF, smooth_D_ST, smooth_nu_ST
         
         real(dp) :: angsmt_D_DSI, angsmt_D_SH, angsmt_D_SSI, &
            angsmt_D_ES, angsmt_D_GSF, angsmt_D_ST, angsmt_nu_ST

         real(dp) :: angsml, adjust_J_fraction
         logical :: simple_i_rot_flag, do_adjust_J_lost, &
            premix_omega, am_time_average
         integer :: max_mdot_redo_cnt
         real(dp) :: min_years_dt_for_redo_mdot, mdot_crit_boost_factor, &
            mdot_revise_factor, implicit_mdot_boost
         real(dp) :: surf_w_div_w_crit_limit, surf_w_div_w_crit_tol
         real(dp) :: fp_min, ft_min, fp_error_limit, ft_error_limit

         real(dp) :: D_mix_rotation_max_logT_full_on, &
            D_mix_rotation_min_logT_full_off
            

         real(dp) :: jacobian_clip_limit
         real(dp) :: sum_xa_tolerance, xa_clip_limit
         
         real(dp) :: min_xa_hard_limit, min_xa_hard_limit_for_highT
         real(dp) :: logT_max_for_min_xa_hard_limit, &
            logT_min_for_min_xa_hard_limit_for_highT
         
         real(dp) :: sum_xa_hard_limit, sum_xa_hard_limit_for_highT
         real(dp) :: logT_max_for_sum_xa_hard_limit, &
            logT_min_for_sum_xa_hard_limit_for_highT
         
         logical :: report_hydro_solver_progress
         logical :: report_ierr

         integer :: hydro_dump_call_number, hydro_dump_iter_number
         logical :: hydro_numerical_jacobian
         integer :: hydro_jacobian_nzlo, hydro_jacobian_nzhi
         logical :: hydro_check_everything
         logical :: hydro_show_correction_info
         logical :: hydro_inspectB_flag
         logical :: hydro_save_numjac_plot_data
         integer :: trace_k
            

      ! timestep parameters
      
         real(dp) :: max_timestep
         real(dp) :: max_years_for_timestep
         real(dp) :: hi_T_max_years_for_timestep
         real(dp) :: max_timestep_hi_T_limit
      
         real(dp) :: min_timestep_factor
         real(dp) :: max_timestep_factor
         real(dp) :: timestep_factor_for_retries, timestep_factor_for_backups
         integer :: backup_hold 
         integer :: retry_hold
         integer :: neg_mass_fraction_hold
      
         real(dp) :: timestep_dt_factor
         real(dp) :: dt_limit_ratio_target
         logical :: use_dt_low_pass_controller
         
         real(dp) :: varcontrol_target, varcontrol_dt_limit_ratio_hard_max
         real(dp) :: DUP_varcontrol_factor  
         
         real(dp) :: &
            truncation_ratio_xh_atol, &
            truncation_ratio_xh_rtol, &
            truncation_ratio_xa_atol, &
            truncation_ratio_xa_rtol, &
            truncation_ratio_limit, &
            truncation_ratio_hard_limit
         logical :: eval_truncation_ratio_do_max, use_truncation_ratio_limit

         real(dp) :: xa_scale
         
         integer :: newton_iterations_limit
         integer :: newton_iterations_hard_limit

         integer :: rotation_steps_limit
         integer :: rotation_steps_hard_limit

         integer :: diffusion_steps_limit
         integer :: diffusion_steps_hard_limit

         integer :: diffusion_iters_limit
         integer :: diffusion_iters_hard_limit

         real(dp) :: &
            dt_div_dt_cell_collapse_limit, &
            dt_div_dt_cell_collapse_hard_limit, &
            dt_div_dt_Courant_limit, &
            dt_div_dt_Courant_hard_limit, &
            dt_div_dt_thermal_limit, & 
            dt_div_dt_thermal_hard_limit, & 
            dt_div_dt_dynamic_limit, & 
            dt_div_dt_dynamic_hard_limit, & 
            dt_div_dt_acoustic_limit, & 
            dt_div_dt_acoustic_hard_limit, & 
            dt_div_dt_mass_loss_limit, & 
            dt_div_dt_mass_loss_hard_limit
            
         integer :: burn_max_substeps_limit, burn_max_substeps_hard_limit

         integer :: burn_max_iters_limit, burn_max_iters_hard_limit
         real(dp) :: max_fixup_for_mix_limit, max_fixup_for_mix_hard_limit
         
         real(dp) :: dX_mix_dist_limit
         
         real(dp) :: dH_limit_min_H
         real(dp) :: dH_limit
         real(dp) :: dH_hard_limit
         logical :: dH_decreases_only
         
         real(dp) :: dH_div_H_limit_min_H
         real(dp) :: dH_div_H_limit
         real(dp) :: dH_div_H_hard_limit
         
         real(dp) :: dHe_limit_min_He
         real(dp) :: dHe_limit
         real(dp) :: dHe_hard_limit
         logical :: dHe_decreases_only
         
         real(dp) :: dHe_div_He_limit_min_He
         real(dp) :: dHe_div_He_limit
         real(dp) :: dHe_div_He_hard_limit
         
         real(dp) :: dHe3_limit_min_He3
         real(dp) :: dHe3_limit
         real(dp) :: dHe3_hard_limit
         logical :: dHe3_decreases_only
         
         real(dp) :: dHe3_div_He3_limit_min_He3
         real(dp) :: dHe3_div_He3_limit
         real(dp) :: dHe3_div_He3_hard_limit
         
         real(dp) :: dX_limit_min_X
         real(dp) :: dX_limit
         real(dp) :: dX_hard_limit
         logical :: dX_decreases_only
         
         real(dp) :: dX_div_X_limit_min_X
         real(dp) :: dX_div_X_limit
         real(dp) :: dX_div_X_hard_limit
         
         real(dp) :: dX_nuc_drop_min_X_limit
         real(dp) :: dX_nuc_drop_max_A_limit
         real(dp) :: dX_nuc_drop_limit, dX_nuc_drop_limit_at_high_T
         real(dp) :: dX_nuc_drop_hard_limit
         real(dp) :: dX_nuc_drop_min_yrs_for_dt
         

         real(dp) :: dL_div_L_limit_min_L
         real(dp) :: dL_div_L_limit
         real(dp) :: dL_div_L_hard_limit

         real(dp) :: delta_lgP_limit      
         real(dp) :: delta_lgP_hard_limit, delta_lgP_limit_min_lgP

         real(dp) :: delta_lgRho_limit      
         real(dp) :: delta_lgRho_hard_limit, delta_lgRho_limit_min_lgRho  
         
         real(dp) :: delta_lgT_limit
         real(dp) :: delta_lgT_hard_limit, delta_lgT_limit_min_lgT
         
         real(dp) :: delta_lgE_limit
         real(dp) :: delta_lgE_hard_limit, delta_lgE_limit_min_lgE
         
         real(dp) :: delta_lgR_limit  
         real(dp) :: delta_lgR_hard_limit, delta_lgR_limit_min_lgR 
         
         real(dp) :: d_deltaR_shrink_limit  
         real(dp) :: d_deltaR_shrink_hard_limit 
         
         real(dp) :: d_deltaR_grow_limit  
         real(dp) :: d_deltaR_grow_hard_limit 
         
         real(dp) :: delta_Ye_limit
         real(dp) :: delta_Ye_hard_limit  
         
         real(dp) :: delta_Ye_highT_limit
         real(dp) :: delta_Ye_highT_hard_limit  
         real(dp) :: minT_for_highT_Ye_limit  

         real(dp) :: delta_lgL_nuc_cat_limit
         real(dp) :: delta_lgL_nuc_cat_hard_limit
         real(dp) :: lgL_nuc_cat_burn_min
         real(dp) :: lgL_nuc_mix_dist_limit
         
         logical :: check_delta_lgL_pp ! pp chains
         logical :: check_delta_lgL_cno ! cno cycles
         logical :: check_delta_lgL_3alf ! triple alpha
         logical :: check_delta_lgL_burn_c
         logical :: check_delta_lgL_burn_n
         logical :: check_delta_lgL_burn_o
         logical :: check_delta_lgL_burn_ne
         logical :: check_delta_lgL_burn_na
         logical :: check_delta_lgL_burn_mg
         logical :: check_delta_lgL_burn_si
         logical :: check_delta_lgL_burn_s
         logical :: check_delta_lgL_burn_ar
         logical :: check_delta_lgL_burn_ca
         logical :: check_delta_lgL_burn_ti
         logical :: check_delta_lgL_burn_cr
         logical :: check_delta_lgL_burn_fe
         logical :: check_delta_lgL_cc ! c12 + c12
         logical :: check_delta_lgL_co ! c12 + o16
         logical :: check_delta_lgL_oo ! o16 + o16

         real(dp) :: delta_lgL_nuc_limit
         real(dp) :: delta_lgL_nuc_hard_limit
         real(dp) :: lgL_nuc_burn_min, lgL_nuc_drop_factor

         real(dp) :: delta_lgL_H_limit
         real(dp) :: delta_lgL_H_hard_limit, lgL_H_burn_relative_limit
         real(dp) :: lgL_H_burn_min, lgL_H_drop_factor

         real(dp) :: delta_lgL_He_limit
         real(dp) :: delta_lgL_He_hard_limit, lgL_He_burn_relative_limit
         real(dp) :: lgL_He_burn_min, lgL_He_drop_factor

         real(dp) :: delta_lgL_z_limit
         real(dp) :: delta_lgL_z_hard_limit, lgL_z_burn_relative_limit
         real(dp) :: lgL_z_burn_min, lgL_z_drop_factor

         real(dp) :: delta_lgL_photo_limit
         real(dp) :: delta_lgL_photo_hard_limit
         real(dp) :: lgL_photo_burn_min, lgL_photo_drop_factor
         
         real(dp) :: delta_lgRho_cntr_limit  
         real(dp) :: delta_lgRho_cntr_hard_limit 
         
         real(dp) :: delta_lgRho_max_limit  
         real(dp) :: delta_lgRho_max_hard_limit 
         
         real(dp) :: delta_lgT_max_limit  
         real(dp) :: delta_lgT_max_hard_limit 
         
         real(dp) :: delta_lgT_cntr_limit  
         real(dp) :: delta_lgT_cntr_hard_limit 
         
         real(dp) :: delta_log_eps_nuc_cntr_limit  
         real(dp) :: delta_log_eps_nuc_cntr_hard_limit 
         
         real(dp) :: delta_log_eps_nuc_limit  
         real(dp) :: delta_log_eps_nuc_hard_limit 
         
         real(dp) :: delta_lg_XH_cntr_limit
         real(dp) :: delta_lg_XH_cntr_hard_limit
         real(dp) :: delta_lg_XH_cntr_min 
         real(dp) :: delta_lg_XH_cntr_max          
         
         real(dp) :: delta_lg_XHe_cntr_limit
         real(dp) :: delta_lg_XHe_cntr_hard_limit
         real(dp) :: delta_lg_XHe_cntr_min 
         real(dp) :: delta_lg_XHe_cntr_max          
         
         real(dp) :: delta_lg_XC_cntr_limit
         real(dp) :: delta_lg_XC_cntr_hard_limit
         real(dp) :: delta_lg_XC_cntr_min 
         real(dp) :: delta_lg_XC_cntr_max          
         
         real(dp) :: delta_lg_XNe_cntr_limit
         real(dp) :: delta_lg_XNe_cntr_hard_limit
         real(dp) :: delta_lg_XNe_cntr_min 
         real(dp) :: delta_lg_XNe_cntr_max          
         
         real(dp) :: delta_lg_XO_cntr_limit
         real(dp) :: delta_lg_XO_cntr_hard_limit
         real(dp) :: delta_lg_XO_cntr_min 
         real(dp) :: delta_lg_XO_cntr_max          
         
         real(dp) :: delta_lg_XSi_cntr_limit
         real(dp) :: delta_lg_XSi_cntr_hard_limit
         real(dp) :: delta_lg_XSi_cntr_min 
         real(dp) :: delta_lg_XSi_cntr_max          
                
         real(dp) :: delta_lgTeff_limit
         real(dp) :: delta_lgTeff_hard_limit 
                
         real(dp) :: v_div_v_crit_limit
         real(dp) :: v_div_v_crit_hard_limit 
                
         real(dp) :: delta_lgR_phot_limit
         real(dp) :: delta_lgR_phot_hard_limit 
                
         real(dp) :: delta_lgL_limit, delta_lgL_limit_L_min
         real(dp) :: delta_lgL_hard_limit 
                
         real(dp) :: delta_HR_ds_L
         real(dp) :: delta_HR_ds_Teff 
         real(dp) :: delta_HR_limit
         real(dp) :: delta_HR_hard_limit 
                
         real(dp) :: delta_lg_star_mass_limit
         real(dp) :: delta_lg_star_mass_hard_limit 
                
         real(dp) :: delta_mdot_atol, delta_mdot_rtol
         real(dp) :: delta_mdot_limit, delta_mdot_hard_limit 
                
         real(dp) :: CpT_absMdot_div_L_limit
         real(dp) :: CpT_absMdot_div_L_hard_limit 
         
         logical :: trace_force_another_iteration
                
         real(dp) :: delta_lg_total_J_limit
         real(dp) :: delta_lg_total_J_hard_limit 
                
         real(dp) :: delta_op_split_limit, delta_op_split_hard_limit 
         real(dp) :: delta_op_split_Lnuc_limit, delta_op_split_center_h1_limit

         real(dp) :: &
            limit_for_avg_E_residual, &
            hard_limit_for_avg_E_residual
         real(dp) :: &
            limit_for_max_E_residual, &
            hard_limit_for_max_E_residual
         real(dp) :: &
            limit_for_rel_error_in_energy_conservation, &
            hard_limit_for_rel_error_in_energy_conservation
         real(dp) :: &
            limit_for_rel_rate_in_energy_conservation, &
            hard_limit_for_rel_rate_in_energy_conservation
         integer :: min_k_for_max_dlnd_residual, &
            min_k_for_max_dE_residual, min_k_for_max_dvdt_residual
                      
         logical :: relax_hard_limits_after_backup, relax_hard_limits_after_retry
         
         logical :: report_all_dt_limits, report_dX_nuc_drop_dt_limits
         logical :: report_why_dt_limits, report_hydro_dt_info
         logical :: trace_newton_bcyclic_solve_input, trace_newton_bcyclic_solve_output
         logical :: trace_newton_bcyclic_matrix_input, trace_newton_bcyclic_matrix_output
         integer :: &
            trace_newton_bcyclic_steplo, &
            trace_newton_bcyclic_stephi, &
            trace_newton_bcyclic_iterlo, &
            trace_newton_bcyclic_iterhi, &
            trace_newton_bcyclic_nzlo, &
            trace_newton_bcyclic_nzhi, &
            trace_newton_bcyclic_jlo, &
            trace_newton_bcyclic_jhi
         
         integer :: write_varcontrol_internals
         
         logical :: trace_evolve, trace_solar_neutrinos
         integer :: min_times_redo_cdc, max_times_redo_cdc
         integer :: redo_cdc_iters_okay
         
      ! misc
         
         real(dp) :: min_logT_for_quad
         
         character (len=strlen) :: zams_filename 
         
         logical :: use_other_eos
         logical :: use_other_surface_PT
         logical :: use_other_kap
         logical :: use_other_atm
         logical :: use_other_diffusion
         logical :: use_other_mlt
         logical :: use_other_adjust_mdot
         logical :: use_other_am_mixing
         logical :: use_other_brunt, use_other_brunt_smoothing
         logical :: use_other_newton_monitor
         logical :: use_other_build_initial_model
         logical :: use_other_cgrav
         logical :: use_other_momentum
         logical :: use_other_energy_implicit
         logical :: use_other_energy
         logical :: use_other_mesh_functions
         logical :: use_other_eps_grav
         logical :: use_other_split_mix
         logical :: use_other_D_mix
         logical :: use_other_neu
         logical :: use_other_opacity_factor
         logical :: use_other_paquette_coefficients
         logical :: use_other_pgstar_plots
         logical :: use_other_torque
         logical :: use_other_torque_implicit
         logical :: use_other_wind
         logical :: use_other_after_struct_burn_mix, use_other_before_struct_burn_mix
         logical :: use_other_get_pulsation_info
         logical :: use_other_write_pulsation_info
         logical :: use_other_edit_pulsation_info
         logical :: use_other_edit_gyre_info
         logical :: use_other_get_gyre_model
         logical :: use_other_adjust_net
         logical :: use_other_astero_freq_corr
         
         real(dp) :: x_ctrl(num_x_ctrls)
         integer :: x_integer_ctrl(num_x_ctrls)
         logical :: x_logical_ctrl(num_x_ctrls)
         character (len=strlen) :: x_character_ctrl(num_x_ctrls)


      ! the following control parameters are not intended for general use


      ! mass gain or loss

         logical :: clip_small_mdots ! set them to zero.
         
         logical :: no_wind_if_no_rotation

         real(dp) :: max_logT_for_k_below_const_q, max_logT_for_k_const_mass
         real(dp) :: min_q_for_k_below_const_q, max_q_for_k_below_const_q
         real(dp) :: min_q_for_k_const_mass, max_q_for_k_const_mass
         
         real(dp) :: rlo_wind_eta, rlo_wind_min_L, rlo_wind_max_Teff
         real(dp) :: rlo_wind_roche_lobe_radius, rlo_wind_base_mdot
         real(dp) :: roche_lobe_xfer_full_on, roche_lobe_xfer_full_off
         real(dp) :: rlo_wind_scale_height
         
         real(dp) :: nova_wind_eta, nova_wind_b
         real(dp) :: nova_wind_max_Teff, nova_wind_min_L
         real(dp) :: nova_min_Teff_for_accretion, nova_roche_lobe_radius, nova_RLO_mdot
         
         real(dp) :: flash_wind_mdot, flash_wind_starts
         real(dp) :: flash_wind_declines, flash_wind_full_off
         

      ! info for debugging
         logical :: stop_for_bugs
         
         integer :: diffusion_dump_call_number
         
         integer :: matrix_type
         
         integer :: phase_of_evolution_stop


