! ***********************************************************************
!
!   Copyright (C) 2011  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module solve_burn_mix

      use star_private_def
      use const_def

      implicit none

      
      contains


      subroutine do_mix_burn(s, dt, ierr) 

         use solve_mix, only: do_solve_mix
         use solve_burn, only: do_one_zone_burns

         type (star_info), pointer :: s
         real(dp), intent(in) :: dt
         integer, intent(out) :: ierr
         
         integer :: nz, species, k_bad, res, pass, num_passes
         logical, parameter :: skip_partials = .false.
         
         include 'formats'
         
         nz = s% nz
         species = s% species
         ierr = 0

         call do_alloc(ierr)
         if (ierr /= 0) then
            write(*,*) 'allocate failed in do_mix_burn'
            return
         end if

         s% avg_burn_dxdt(:,1:nz) = 0d0
         s% avg_mix_dxdt(:,1:nz) = 0d0

         s% num_burn_max_iters = 0
         s% max_fixup_for_mix = 0
         
         num_passes = s% op_split_burn_mix_num_passes
         do pass = 1, num_passes
         
            if (s% op_split_burn_mix_trace) write(*,2) 'do_mix_burn pass', pass
            res = do_solve_mix( &
               s, dt, s% avg_burn_dxdt, s% avg_mix_dxdt, s% species, &
               pass, num_passes)
            if (res /= keep_going) then
               ierr = -1
               write(*,2) 'split mix failed: model', s% model_number
               write(*,*)
               return
            end if
      
            res = do_one_zone_burns( &
               s, dt, s% avg_mix_dxdt, s% avg_burn_dxdt, &
               pass, num_passes, k_bad)
            if (res /= keep_going) then
               ierr = -1
               write(*,3) 'split burn failed: model, k_bad, T', &
                  s% model_number, k_bad, s% T(k_bad)
               write(*,*)
               return
            end if
         
         end do
         
         !if (s% op_split_burn_mix_trace) write(*,*) 'done do_mix_burn'
         
         contains
         
         
         subroutine do_alloc(ierr)
            use alloc, only: non_crit_do1_alloc_if_necessary
            integer, intent(out) :: ierr
            integer :: sz
            sz = nz*species
            ierr = 0
            call non_crit_do1_alloc_if_necessary( &
               s, s% avg_burn_dxdt1, sz, 'solve_burn_mix', ierr)
            if (ierr /= 0) return            
            s% avg_burn_dxdt(1:species,1:nz) => s% avg_burn_dxdt1(1:sz)
            call non_crit_do1_alloc_if_necessary( &
               s, s% avg_mix_dxdt1, sz, 'solve_burn_mix', ierr)
            if (ierr /= 0) return            
            s% avg_mix_dxdt(1:species,1:nz) => s% avg_mix_dxdt1(1:sz)
         end subroutine do_alloc

         
      end subroutine do_mix_burn


      end module solve_burn_mix
      
