! ***********************************************************************
!
!   Copyright (C) 2013  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module pgstar_profile_panels

      use star_private_def
      use const_def
      use pgstar_support
      use pgstar_trho_profile

      implicit none


      contains


      subroutine Profile_Panels1_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()                     
         call do_profile_panels1_plot(s, id, device_id, &
            s% Profile_Panels1_xleft, s% Profile_Panels1_xright, &
            s% Profile_Panels1_ybot, s% Profile_Panels1_ytop, .false., &
            s% Profile_Panels1_title, s% Profile_Panels1_txt_scale, ierr)
         if (ierr /= 0) return         
         call pgebuf()         
      end subroutine Profile_Panels1_plot
      

      subroutine do_profile_panels1_plot(s, id, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, ierr)         
         type (star_info), pointer :: s
         integer, intent(in) :: id, device_id
         real, intent(in) :: vp_xleft, vp_xright, vp_ybot, vp_ytop, txt_scale
         logical, intent(in) :: subplot
         character (len=*), intent(in) :: title
         integer, intent(out) :: ierr
         call Pro_panels_plot(s, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, &
            s% Profile_Panels1_xaxis_reversed, &
            s% Profile_Panels1_yaxis_reversed, &
            s% Profile_Panels1_other_yaxis_reversed, &
            s% Profile_Panels1_yaxis_log, &
            s% Profile_Panels1_other_yaxis_log, &
            s% Profile_Panels1_xaxis_name, &
            s% Profile_Panels1_yaxis_name, &
            s% Profile_Panels1_other_yaxis_name, &
            s% Profile_Panels1_xmin, s% Profile_Panels1_xmax, &
            s% Profile_Panels1_xmargin, s% Profile_Panels1_show_mix_regions_on_xaxis, &
            s% Profile_Panels1_ymin, s% Profile_Panels1_other_ymin, &
            s% Profile_Panels1_ymax, s% Profile_Panels1_other_ymax, &
            s% Profile_Panels1_ymargin, s% Profile_Panels1_other_ymargin, &
            s% Profile_Panels1_dymin, s% Profile_Panels1_other_dymin, &
            s% Profile_Panels1_show_grid, &
            s% Profile_Panels1_num_panels, ierr)
      end subroutine do_profile_panels1_plot


      subroutine Profile_Panels2_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()                     
         call do_profile_Panels2_plot(s, id, device_id, &
            s% Profile_Panels2_xleft, s% Profile_Panels2_xright, &
            s% Profile_Panels2_ybot, s% Profile_Panels2_ytop, .false., &
            s% Profile_Panels2_title, s% Profile_Panels2_txt_scale, ierr)
         if (ierr /= 0) return         
         call pgebuf()         
      end subroutine Profile_Panels2_plot
      

      subroutine do_profile_Panels2_plot(s, id, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, ierr)         
         type (star_info), pointer :: s
         integer, intent(in) :: id, device_id
         real, intent(in) :: vp_xleft, vp_xright, vp_ybot, vp_ytop, txt_scale
         logical, intent(in) :: subplot
         character (len=*), intent(in) :: title
         integer, intent(out) :: ierr
         call Pro_panels_plot(s, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, &
            s% Profile_Panels2_xaxis_reversed, &
            s% Profile_Panels2_yaxis_reversed, &
            s% Profile_Panels2_other_yaxis_reversed, &
            s% Profile_Panels2_yaxis_log, &
            s% Profile_Panels2_other_yaxis_log, &
            s% Profile_Panels2_xaxis_name, &
            s% Profile_Panels2_yaxis_name, &
            s% Profile_Panels2_other_yaxis_name, &
            s% Profile_Panels2_xmin, s% Profile_Panels2_xmax, &
            s% Profile_Panels2_xmargin, s% Profile_Panels2_show_mix_regions_on_xaxis, &
            s% Profile_Panels2_ymin, s% Profile_Panels2_other_ymin, &
            s% Profile_Panels2_ymax, s% Profile_Panels2_other_ymax, &
            s% Profile_Panels2_ymargin, s% Profile_Panels2_other_ymargin, &
            s% Profile_Panels2_dymin, s% Profile_Panels2_other_dymin, &
            s% Profile_Panels2_show_grid, &
            s% Profile_Panels2_num_panels, ierr)
      end subroutine do_profile_Panels2_plot


      subroutine Profile_Panels3_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()                     
         call do_profile_Panels3_plot(s, id, device_id, &
            s% Profile_Panels3_xleft, s% Profile_Panels3_xright, &
            s% Profile_Panels3_ybot, s% Profile_Panels3_ytop, .false., &
            s% Profile_Panels3_title, s% Profile_Panels3_txt_scale, ierr)
         if (ierr /= 0) return         
         call pgebuf()         
      end subroutine Profile_Panels3_plot
      

      subroutine do_profile_Panels3_plot(s, id, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, ierr)         
         type (star_info), pointer :: s
         integer, intent(in) :: id, device_id
         real, intent(in) :: vp_xleft, vp_xright, vp_ybot, vp_ytop, txt_scale
         logical, intent(in) :: subplot
         character (len=*), intent(in) :: title
         integer, intent(out) :: ierr
         call Pro_panels_plot(s, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, &
            s% Profile_Panels3_xaxis_reversed, &
            s% Profile_Panels3_yaxis_reversed, &
            s% Profile_Panels3_other_yaxis_reversed, &
            s% Profile_Panels3_yaxis_log, &
            s% Profile_Panels3_other_yaxis_log, &
            s% Profile_Panels3_xaxis_name, &
            s% Profile_Panels3_yaxis_name, &
            s% Profile_Panels3_other_yaxis_name, &
            s% Profile_Panels3_xmin, s% Profile_Panels3_xmax, &
            s% Profile_Panels3_xmargin, s% Profile_Panels3_show_mix_regions_on_xaxis, &
            s% Profile_Panels3_ymin, s% Profile_Panels3_other_ymin, &
            s% Profile_Panels3_ymax, s% Profile_Panels3_other_ymax, &
            s% Profile_Panels3_ymargin, s% Profile_Panels3_other_ymargin, &
            s% Profile_Panels3_dymin, s% Profile_Panels3_other_dymin, &
            s% Profile_Panels3_show_grid, &
            s% Profile_Panels3_num_panels, ierr)
      end subroutine do_profile_Panels3_plot


      subroutine Profile_Panels4_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()                     
         call do_profile_Panels4_plot(s, id, device_id, &
            s% Profile_Panels4_xleft, s% Profile_Panels4_xright, &
            s% Profile_Panels4_ybot, s% Profile_Panels4_ytop, .false., &
            s% Profile_Panels4_title, s% Profile_Panels4_txt_scale, ierr)
         if (ierr /= 0) return         
         call pgebuf()         
      end subroutine Profile_Panels4_plot
      

      subroutine do_Profile_Panels4_plot(s, id, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, ierr)         
         type (star_info), pointer :: s
         integer, intent(in) :: id, device_id
         real, intent(in) :: vp_xleft, vp_xright, vp_ybot, vp_ytop, txt_scale
         logical, intent(in) :: subplot
         character (len=*), intent(in) :: title
         integer, intent(out) :: ierr
         call Pro_panels_plot(s, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, &
            s% Profile_Panels4_xaxis_reversed, &
            s% Profile_Panels4_yaxis_reversed, &
            s% Profile_Panels4_other_yaxis_reversed, &
            s% Profile_Panels4_yaxis_log, &
            s% Profile_Panels4_other_yaxis_log, &
            s% Profile_Panels4_xaxis_name, &
            s% Profile_Panels4_yaxis_name, &
            s% Profile_Panels4_other_yaxis_name, &
            s% Profile_Panels4_xmin, s% Profile_Panels4_xmax, &
            s% Profile_Panels4_xmargin, s% Profile_Panels4_show_mix_regions_on_xaxis, &
            s% Profile_Panels4_ymin, s% Profile_Panels4_other_ymin, &
            s% Profile_Panels4_ymax, s% Profile_Panels4_other_ymax, &
            s% Profile_Panels4_ymargin, s% Profile_Panels4_other_ymargin, &
            s% Profile_Panels4_dymin, s% Profile_Panels4_other_dymin, &
            s% Profile_Panels4_show_grid, &
            s% Profile_Panels4_num_panels, ierr)
      end subroutine do_profile_Panels4_plot


      subroutine Profile_Panels5_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()                     
         call do_Profile_Panels5_plot(s, id, device_id, &
            s% Profile_Panels5_xleft, s% Profile_Panels5_xright, &
            s% Profile_Panels5_ybot, s% Profile_Panels5_ytop, .false., &
            s% Profile_Panels5_title, s% Profile_Panels5_txt_scale, ierr)
         if (ierr /= 0) return         
         call pgebuf()         
      end subroutine Profile_Panels5_plot
      

      subroutine do_Profile_Panels5_plot(s, id, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, ierr)         
         type (star_info), pointer :: s
         integer, intent(in) :: id, device_id
         real, intent(in) :: vp_xleft, vp_xright, vp_ybot, vp_ytop, txt_scale
         logical, intent(in) :: subplot
         character (len=*), intent(in) :: title
         integer, intent(out) :: ierr
         call Pro_panels_plot(s, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, &
            s% Profile_Panels5_xaxis_reversed, &
            s% Profile_Panels5_yaxis_reversed, &
            s% Profile_Panels5_other_yaxis_reversed, &
            s% Profile_Panels5_yaxis_log, &
            s% Profile_Panels5_other_yaxis_log, &
            s% Profile_Panels5_xaxis_name, &
            s% Profile_Panels5_yaxis_name, &
            s% Profile_Panels5_other_yaxis_name, &
            s% Profile_Panels5_xmin, s% Profile_Panels5_xmax, &
            s% Profile_Panels5_xmargin, s% Profile_Panels5_show_mix_regions_on_xaxis, &
            s% Profile_Panels5_ymin, s% Profile_Panels5_other_ymin, &
            s% Profile_Panels5_ymax, s% Profile_Panels5_other_ymax, &
            s% Profile_Panels5_ymargin, s% Profile_Panels5_other_ymargin, &
            s% Profile_Panels5_dymin, s% Profile_Panels5_other_dymin, &
            s% Profile_Panels5_show_grid, &
            s% Profile_Panels5_num_panels, ierr)
      end subroutine do_Profile_Panels5_plot


      subroutine Profile_Panels6_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()                     
         call do_Profile_Panels6_plot(s, id, device_id, &
            s% Profile_Panels6_xleft, s% Profile_Panels6_xright, &
            s% Profile_Panels6_ybot, s% Profile_Panels6_ytop, .false., &
            s% Profile_Panels6_title, s% Profile_Panels6_txt_scale, ierr)
         if (ierr /= 0) return         
         call pgebuf()         
      end subroutine Profile_Panels6_plot
      

      subroutine do_Profile_Panels6_plot(s, id, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, ierr)         
         type (star_info), pointer :: s
         integer, intent(in) :: id, device_id
         real, intent(in) :: vp_xleft, vp_xright, vp_ybot, vp_ytop, txt_scale
         logical, intent(in) :: subplot
         character (len=*), intent(in) :: title
         integer, intent(out) :: ierr
         call Pro_panels_plot(s, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, &
            s% Profile_Panels6_xaxis_reversed, &
            s% Profile_Panels6_yaxis_reversed, &
            s% Profile_Panels6_other_yaxis_reversed, &
            s% Profile_Panels6_yaxis_log, &
            s% Profile_Panels6_other_yaxis_log, &
            s% Profile_Panels6_xaxis_name, &
            s% Profile_Panels6_yaxis_name, &
            s% Profile_Panels6_other_yaxis_name, &
            s% Profile_Panels6_xmin, s% Profile_Panels6_xmax, &
            s% Profile_Panels6_xmargin, s% Profile_Panels6_show_mix_regions_on_xaxis, &
            s% Profile_Panels6_ymin, s% Profile_Panels6_other_ymin, &
            s% Profile_Panels6_ymax, s% Profile_Panels6_other_ymax, &
            s% Profile_Panels6_ymargin, s% Profile_Panels6_other_ymargin, &
            s% Profile_Panels6_dymin, s% Profile_Panels6_other_dymin, &
            s% Profile_Panels6_show_grid, &
            s% Profile_Panels6_num_panels, ierr)
      end subroutine do_Profile_Panels6_plot


      subroutine Profile_Panels7_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()                     
         call do_Profile_Panels7_plot(s, id, device_id, &
            s% Profile_Panels7_xleft, s% Profile_Panels7_xright, &
            s% Profile_Panels7_ybot, s% Profile_Panels7_ytop, .false., &
            s% Profile_Panels7_title, s% Profile_Panels7_txt_scale, ierr)
         if (ierr /= 0) return         
         call pgebuf()         
      end subroutine Profile_Panels7_plot
      

      subroutine do_Profile_Panels7_plot(s, id, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, ierr)         
         type (star_info), pointer :: s
         integer, intent(in) :: id, device_id
         real, intent(in) :: vp_xleft, vp_xright, vp_ybot, vp_ytop, txt_scale
         logical, intent(in) :: subplot
         character (len=*), intent(in) :: title
         integer, intent(out) :: ierr
         call Pro_panels_plot(s, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, &
            s% Profile_Panels7_xaxis_reversed, &
            s% Profile_Panels7_yaxis_reversed, &
            s% Profile_Panels7_other_yaxis_reversed, &
            s% Profile_Panels7_yaxis_log, &
            s% Profile_Panels7_other_yaxis_log, &
            s% Profile_Panels7_xaxis_name, &
            s% Profile_Panels7_yaxis_name, &
            s% Profile_Panels7_other_yaxis_name, &
            s% Profile_Panels7_xmin, s% Profile_Panels7_xmax, &
            s% Profile_Panels7_xmargin, s% Profile_Panels7_show_mix_regions_on_xaxis, &
            s% Profile_Panels7_ymin, s% Profile_Panels7_other_ymin, &
            s% Profile_Panels7_ymax, s% Profile_Panels7_other_ymax, &
            s% Profile_Panels7_ymargin, s% Profile_Panels7_other_ymargin, &
            s% Profile_Panels7_dymin, s% Profile_Panels7_other_dymin, &
            s% Profile_Panels7_show_grid, &
            s% Profile_Panels7_num_panels, ierr)
      end subroutine do_Profile_Panels7_plot


      subroutine Profile_Panels8_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()                     
         call do_Profile_Panels8_plot(s, id, device_id, &
            s% Profile_Panels8_xleft, s% Profile_Panels8_xright, &
            s% Profile_Panels8_ybot, s% Profile_Panels8_ytop, .false., &
            s% Profile_Panels8_title, s% Profile_Panels8_txt_scale, ierr)
         if (ierr /= 0) return         
         call pgebuf()         
      end subroutine Profile_Panels8_plot
      

      subroutine do_Profile_Panels8_plot(s, id, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, ierr)         
         type (star_info), pointer :: s
         integer, intent(in) :: id, device_id
         real, intent(in) :: vp_xleft, vp_xright, vp_ybot, vp_ytop, txt_scale
         logical, intent(in) :: subplot
         character (len=*), intent(in) :: title
         integer, intent(out) :: ierr
         call Pro_panels_plot(s, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, &
            s% Profile_Panels8_xaxis_reversed, &
            s% Profile_Panels8_yaxis_reversed, &
            s% Profile_Panels8_other_yaxis_reversed, &
            s% Profile_Panels8_yaxis_log, &
            s% Profile_Panels8_other_yaxis_log, &
            s% Profile_Panels8_xaxis_name, &
            s% Profile_Panels8_yaxis_name, &
            s% Profile_Panels8_other_yaxis_name, &
            s% Profile_Panels8_xmin, s% Profile_Panels8_xmax, &
            s% Profile_Panels8_xmargin, s% Profile_Panels8_show_mix_regions_on_xaxis, &
            s% Profile_Panels8_ymin, s% Profile_Panels8_other_ymin, &
            s% Profile_Panels8_ymax, s% Profile_Panels8_other_ymax, &
            s% Profile_Panels8_ymargin, s% Profile_Panels8_other_ymargin, &
            s% Profile_Panels8_dymin, s% Profile_Panels8_other_dymin, &
            s% Profile_Panels8_show_grid, &
            s% Profile_Panels8_num_panels, ierr)
      end subroutine do_Profile_Panels8_plot


      subroutine Profile_Panels9_plot(id, device_id, ierr)
         integer, intent(in) :: id, device_id
         integer, intent(out) :: ierr         
         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call pgslct(device_id)
         call pgbbuf()
         call pgeras()                     
         call do_Profile_Panels9_plot(s, id, device_id, &
            s% Profile_Panels9_xleft, s% Profile_Panels9_xright, &
            s% Profile_Panels9_ybot, s% Profile_Panels9_ytop, .false., &
            s% Profile_Panels9_title, s% Profile_Panels9_txt_scale, ierr)
         if (ierr /= 0) return         
         call pgebuf()         
      end subroutine Profile_Panels9_plot
      

      subroutine do_Profile_Panels9_plot(s, id, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, ierr)         
         type (star_info), pointer :: s
         integer, intent(in) :: id, device_id
         real, intent(in) :: vp_xleft, vp_xright, vp_ybot, vp_ytop, txt_scale
         logical, intent(in) :: subplot
         character (len=*), intent(in) :: title
         integer, intent(out) :: ierr
         call Pro_panels_plot(s, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, &
            s% Profile_Panels9_xaxis_reversed, &
            s% Profile_Panels9_yaxis_reversed, &
            s% Profile_Panels9_other_yaxis_reversed, &
            s% Profile_Panels9_yaxis_log, &
            s% Profile_Panels9_other_yaxis_log, &
            s% Profile_Panels9_xaxis_name, &
            s% Profile_Panels9_yaxis_name, &
            s% Profile_Panels9_other_yaxis_name, &
            s% Profile_Panels9_xmin, s% Profile_Panels9_xmax, &
            s% Profile_Panels9_xmargin, s% Profile_Panels9_show_mix_regions_on_xaxis, &
            s% Profile_Panels9_ymin, s% Profile_Panels9_other_ymin, &
            s% Profile_Panels9_ymax, s% Profile_Panels9_other_ymax, &
            s% Profile_Panels9_ymargin, s% Profile_Panels9_other_ymargin, &
            s% Profile_Panels9_dymin, s% Profile_Panels9_other_dymin, &
            s% Profile_Panels9_show_grid, &
            s% Profile_Panels9_num_panels, ierr)
      end subroutine do_Profile_Panels9_plot


      subroutine Pro_panels_plot(s, device_id, &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, subplot, title, txt_scale, &
            panels_xaxis_reversed, &
            panels_yaxis_reversed, &
            panels_other_yaxis_reversed, &
            panels_yaxis_log, &
            panels_other_yaxis_log, &
            panels_xaxis_name, &
            panels_yaxis_name, &
            panels_other_yaxis_name, &
            panels_xmin_in, panels_xmax_in, &
            panels_xmargin_in, show_mix_regions, &
            panels_ymin, panels_other_ymin, &
            panels_ymax, panels_other_ymax, &
            panels_ymargin, panels_other_ymargin, &
            panels_dymin, panels_other_dymin, &
            panels_show_grid, &
            panels_num_panels, ierr)
            
         use pgstar_abundance, only: do_abundance_panel
         use pgstar_power, only: do_power_panel
         use pgstar_dynamo, only: do_Dynamo_panel
         use pgstar_mixing_Ds, only: do_Mixing_panel
         use pgstar_mode_prop, only: do_mode_propagation_panel
         use pgstar_summary_profile, only: do_summary_profile_panel
         use num_lib, only: find0
         use utils_lib
         use profile, only : get_profile_val,get_profile_id

         type (star_info), pointer :: s
         integer, intent(in) :: &
            device_id, panels_num_panels         
         real, intent(in) :: &
            vp_xleft, vp_xright, vp_ybot, vp_ytop, txt_scale, &
            panels_xmin_in, panels_xmax_in, panels_xmargin_in
         logical, intent(in) :: subplot, show_mix_regions
         logical, intent(in), dimension(:) :: &
            panels_yaxis_log, &
            panels_other_yaxis_log
         real, intent(in), dimension(:) :: &
            panels_ymin, panels_other_ymin, &
            panels_ymax, panels_other_ymax, &
            panels_ymargin, panels_other_ymargin, &
            panels_dymin, panels_other_dymin
         character (len=*), intent(in) :: &
            title, panels_xaxis_name
         character (len=*), intent(in), dimension(:) :: &
            panels_yaxis_name, &
            panels_other_yaxis_name
         logical, intent(in) :: &
            panels_xaxis_reversed
         logical, intent(in), dimension(:) :: &
            panels_yaxis_reversed, &
            panels_other_yaxis_reversed
         logical, intent(in) :: panels_show_grid
         integer, intent(out) :: ierr
         
         integer :: &
            j, k, k0, k_max, i, nz, kmin, kmax, cnt, y_color, clr_sav, id, &
            other_y_color, grid_min, grid_max, npts, yaxis_id, other_yaxis_id, ishape
         real :: del, xpos, ypos, panel_dy, panel_ybot, panel_ytop, &
            dx, dy, xpos0, dxpos, dypos, dxval, other_ytop, other_ybot, &
            ybot, ytop, xmin, xmax, xleft, xright, xshock, xwidth, panels_xmargin, &
            panels_xmin, panels_xmax, xwidth_left_frac, xwidth_right_frac, &
            xwidth_left_of_shock, xwidth_right_of_shock, shock_xmin, shock_xmax
         real(dp) :: cs, x00, xp1, ms
         character (len=strlen) :: str, xname, yname, other_yname
         logical :: found_shock
         real, pointer, dimension(:) :: xvec, yvec, other_yvec, unshifted_xvec
         real, pointer, dimension(:) :: yfile_xdata, other_yfile_xdata
         real, pointer, dimension(:) :: yfile_ydata, other_yfile_ydata
         integer :: yfile_data_len, other_yfile_data_len, xaxis_id
      
         include 'formats'

         ierr = 0
         
         id = s% id

         call pgsave
         call pgsch(txt_scale)

         y_color = clr_Goldenrod
         other_y_color = clr_LightSkyBlue
         
         panel_dy = (vp_ytop - vp_ybot)/real(panels_num_panels)

         nz = s% nz        
         allocate (xvec(nz), yvec(nz), other_yvec(nz), unshifted_xvec(nz))
         
         panels_xmin = panels_xmin_in
         panels_xmax = panels_xmax_in
         panels_xmargin = panels_xmargin_in
         
         xwidth_left_frac = s% Profile_Panels_xwidth_left_div_shock_value
         xwidth_right_frac = s% Profile_Panels_xwidth_right_div_shock_value
         xwidth_left_of_shock = s% Profile_Panels_xwidth_left_of_shock
         xwidth_right_of_shock = s% Profile_Panels_xwidth_right_of_shock
         
         xshock = 0
         found_shock = .false.

         xaxis_id = get_profile_id(s, panels_xaxis_name)
         if (xaxis_id > 0 .and. s% v_center >= 0 .and. ( &
               s% Profile_Panels_show_Mach_1_location .or. &
               xwidth_left_frac > 0 .or. xwidth_right_frac > 0 .or. &
               xwidth_left_of_shock > 0 .or. xwidth_right_of_shock > 0)) then
            ! search in from surface
            do k=1,nz-1
               cs = s% csound(k) ! cell center
               if (s% v(k+1) >= cs .and. s% v(k) < cs) then
                  found_shock = .true.
                  exit
               end if
            end do
            if (.not. found_shock) then
               ! search out from center
               do k=nz-1,1,-1
                  cs = s% csound(k) ! cell center
                  if (s% v(k+1) >= -cs .and. s% v(k) < -cs) then
                     found_shock = .true.
                     exit
                  end if
               end do
            end if
            if (found_shock) then
               x00 = get_profile_val(s, xaxis_id, k)
               xp1 = get_profile_val(s, xaxis_id, k+1)
               cs = s% csound(k)
               ms = find0(0d0, s% dm(k), s% v(k+1)-cs, s% v(k)-cs)
               xshock = xp1 + (x00 - xp1)*ms/s% dm(k)
               if (xshock <= 0) then
                  write(*,*) 'shock location on xaxis must be positive for tracking location in plot.'
                  if (panels_xaxis_name == 'logR') write(*,*) 'perhaps use logR_cm instead of logR?'
                  write(*,*)
                  found_shock = .false.
               end if
            end if

         end if
         
         if (found_shock .and. ( &
               xwidth_left_frac > 0 .or. xwidth_right_frac > 0 .or. &
               xwidth_left_of_shock > 0 .or. xwidth_right_of_shock > 0)) then
               
            xmin = get_profile_val(s, xaxis_id, nz)
            xmax = get_profile_val(s, xaxis_id, 1)
            if (xmin > xmax) then ! switch
               dx = xmin; xmin = xmax; xmax = dx
            end if
            
            shock_xmin = -1d99
            if (xwidth_left_frac > 0) &
               shock_xmin = xshock*(1.0 - xwidth_left_frac)
            if (xwidth_left_of_shock > 0) &
               shock_xmin = max(shock_xmin, xshock - xwidth_left_of_shock)
            if (shock_xmin > xmin) then
               panels_xmin = shock_xmin
               panels_xmargin = 0
            end if
            
            shock_xmax = 1d99
            if (xwidth_right_frac > 0) &
               shock_xmax = xshock*(1.0 + xwidth_right_frac)
            if (xwidth_right_of_shock > 0) &
               shock_xmax = min(shock_xmax, xshock + xwidth_right_of_shock)
            if (shock_xmax < xmax) then
               panels_xmax = shock_xmax
               panels_xmargin = 0
            end if
            
         end if
         
         call set_xaxis_bounds( &
            s, panels_xaxis_name, panels_xmin, &
            panels_xmax, panels_xaxis_reversed, panels_xmargin, &
            xvec, xmin, xmax, xleft, xright, dx, &
            grid_min, grid_max, npts, ierr)
         if (ierr /= 0 .or. xleft == xright) then
            write(*,*) 'set_xaxis_bounds error in Profile panels -- please check '
            write(*,1) 'xleft', xleft
            write(*,1) 'xright', xright
            stop
            return
         end if

         if (found_shock .and. s% Profile_Panels_show_Mach_1_location) then 
            ! mark shock location
            call pgsave
            call pgsvp(vp_xleft, vp_xright, vp_ybot, vp_ytop)
            call pgswin(0.0, 1.0, 0.0, 1.0)
            call pgsci(clr_Gray)
            call pgsls(Line_Type_Dash)
            call pgslw(1)
            dx = (xshock - xmin)/(xmax - xmin)
            call pgmove(dx, 0.0)
            call pgdraw(dx, 1.0)
            call pgunsa            
         end if
         
         do k=1,nz
            unshifted_xvec(k) = xvec(k)
         end do
         if (grid_min > 1) then
            do k=1,npts
               xvec(k) = xvec(k+grid_min-1)
            end do
         end if

         do j = 1, panels_num_panels
            
            panel_ytop = vp_ytop - real(j-1)*panel_dy
            panel_ybot = panel_ytop - panel_dy
      
            call pgsvp(vp_xleft, vp_xright, panel_ybot, panel_ytop)
            
            if (j == 1) then
               if (.not. subplot) then
                  call show_model_number_pgstar(s)
                  call show_age_pgstar(s)
               end if
               call show_title_pgstar(s, title, 0.4)
            end if
      
            yname = panels_yaxis_name(j)
            
            if (trim(yname) == 'Abundance') then
            
               call do_abundance_panel(s, id, device_id, &
                  vp_xleft, vp_xright, panel_ybot, panel_ytop, .true., '', txt_scale, &
                  panels_xaxis_name, xmin, xmax, panels_xaxis_reversed, &
                  .true., (j == panels_num_panels), ierr)
               if (ierr /= 0) then
                  stop 'panels failed in do_abundance_panel'
               end if
               cycle
            
            else if (trim(yname) == 'Power') then
            
               call do_power_panel(s, id, device_id, &
                  vp_xleft, vp_xright, panel_ybot, panel_ytop, .true., '', txt_scale, &
                  panels_xaxis_name, xmin, xmax, panels_xaxis_reversed, &
                  .true., (j == panels_num_panels), ierr)
               if (ierr /= 0) then
                  stop 'panels failed in do_power_panel'
               end if
               cycle
            
            else if (trim(yname) == 'Dynamo') then
            
               call do_Dynamo_panel(s, id, device_id, &
                  vp_xleft, vp_xright, panel_ybot, panel_ytop, .true., '', txt_scale, &
                  panels_xaxis_name, xmin, xmax, panels_xaxis_reversed, &
                  .true., (j == panels_num_panels), ierr)
               if (ierr /= 0) then
                  stop 'panels failed in do_Dynamo_panel'
               end if
               cycle
            
            else if (trim(yname) == 'Mixing') then
            
               call do_Mixing_panel(s, id, device_id, &
                  vp_xleft, vp_xright, panel_ybot, panel_ytop, .true., '', txt_scale, &
                  panels_xaxis_name, xmin, xmax, panels_xaxis_reversed, &
                  .true., (j == panels_num_panels), ierr)
               if (ierr /= 0) then
                  stop 'panels failed in do_Mixing_panel'
               end if
               cycle
            
            else if (trim(yname) == 'Mode_Prop') then
            
               call do_mode_propagation_panel(s, id, device_id, &
                  vp_xleft, vp_xright, panel_ybot, panel_ytop, .true., '', txt_scale, &
                  panels_xaxis_name, xmin, xmax, panels_xaxis_reversed, &
                  .true., (j == panels_num_panels), ierr)
               if (ierr /= 0) then
                  stop 'panels failed in do_mode_propagation_panel'
               end if
               cycle
            
            else if (trim(yname) == 'Summary_Profile') then
            
               call do_summary_profile_panel(s, id, device_id, &
                  vp_xleft, vp_xright, panel_ybot, panel_ytop, .true., '', txt_scale, &
                  panels_xaxis_name, xmin, xmax, panels_xaxis_reversed, &
                  .true., (j == panels_num_panels), ierr)
               if (ierr /= 0) then
                  stop 'panels failed in do_summary_profile_panel'
               end if
               cycle
            
            end if 
            
            other_yaxis_id = 0
            yfile_data_len = 0
            other_yfile_data_len = 0
            
            if (len_trim(panels_other_yaxis_name(j)) > 0) then
               other_yname = panels_other_yaxis_name(j)
               other_yaxis_id = get_profile_id(s, other_yname)
               if (other_yaxis_id <= 0) then
                  if (.not. read_values_from_file(other_yname, &
                        other_yfile_xdata, other_yfile_ydata, other_yfile_data_len)) then
                     write(*,*) &
                        'bad other yaxis for Profile panels plot ' // trim(other_yname)
                     return
                  end if
                  if (panels_other_yaxis_log(j)) then
                     do k=1,other_yfile_data_len
                        other_yfile_ydata(k) = log10(max(1e-50,abs(other_yfile_ydata(k))))
                     end do
                  end if
                  call set_ytop_ybot( &
                     other_yfile_data_len, other_yfile_ydata, panels_other_ymin(j), &
                     panels_other_ymax(j), panels_other_ymargin(j), panels_other_yaxis_reversed(j), &
                     panels_other_dymin(j), other_ybot, other_ytop)              
               else
                  do k=1,npts
                     other_yvec(k) = get_profile_val(s, other_yaxis_id, k+grid_min-1)
                  end do
                  if (panels_other_yaxis_log(j)) then
                     do k=1,npts
                        other_yvec(k) = log10(max(1e-50,abs(other_yvec(k))))
                     end do
                  end if
                  call set_ytop_ybot( &
                     npts, other_yvec, panels_other_ymin(j), panels_other_ymax(j), &
                     panels_other_ymargin(j), panels_other_yaxis_reversed(j), &
                     panels_other_dymin(j), other_ybot, other_ytop)              
               end if
               call pgswin(xleft, xright, other_ybot, other_ytop)
               call pgscf(1)
               call pgsci(1)
               call show_box_pgstar(s,'','CMSTV')
               call pgsci(other_y_color)
               if (panels_other_yaxis_log(j)) then
                  call show_right_yaxis_label_pgstar(s,'log ' // other_yname)
               else
                  call show_right_yaxis_label_pgstar(s,other_yname)
               end if
               call pgslw(s% pgstar_lw)
               if (other_yfile_data_len > 0) then
                  call pgline( &
                     other_yfile_data_len, other_yfile_xdata, other_yfile_ydata)
                  deallocate(other_yfile_xdata, other_yfile_ydata)
                  nullify(other_yfile_xdata, other_yfile_ydata)
               else
                  call pgline(npts, xvec, other_yvec)
                  if (panels_show_grid) then
                     ishape = 21
                     do k=1,npts
                        call pgpt1(xvec(k),other_yvec(k),ishape)
                     end do
                  end if
               end if
               call pgslw(1)
            end if
            
            yaxis_id = get_profile_id(s, yname)
            if (yaxis_id <= 0) then
               if (.not. read_values_from_file( &
                     yname, yfile_xdata, yfile_ydata, yfile_data_len)) then
                  write(*,*) &
                     'bad yaxis for Profile panels plot ' // trim(yname)
                  return
               end if
               if (panels_yaxis_log(j)) then
                  do k=1,yfile_data_len
                     yfile_ydata(k) = log10(max(1e-50,abs(yfile_ydata(k))))
                  end do
               end if
               call set_ytop_ybot( &
                  yfile_data_len, yfile_xdata, panels_ymin(j), panels_ymax(j), &
                  panels_ymargin(j), panels_yaxis_reversed(j), panels_dymin(j), ybot, ytop)
            else
               do k=1,npts
                  yvec(k) = get_profile_val(s, yaxis_id, k+grid_min-1)
               end do
               if (panels_yaxis_log(j)) then
                  do k=1,npts
                     yvec(k) = log10(max(1e-50,abs(yvec(k))))
                  end do
               end if
               call set_ytop_ybot( &
                  npts, yvec, panels_ymin(j), panels_ymax(j), panels_ymargin(j), &
                  panels_yaxis_reversed(j), panels_dymin(j), ybot, ytop)
            end if
            call pgswin(xleft, xright, ybot, ytop)
            call pgscf(1)
            call pgsci(1)
            if (j < panels_num_panels) then
               if (other_yaxis_id <= 0 .and. other_yfile_data_len <= 0) then
                  call show_box_pgstar(s,'BCST1','BCMNSTV1')
               else
                  call show_box_pgstar(s,'BCST','BNSTV')
               end if
            else
               if (other_yaxis_id <= 0 .and. other_yfile_data_len <= 0) then
                  call show_box_pgstar(s,'BCNST1','BCMNSTV1')
               else
                  call show_box_pgstar(s,'BCNST','BNSTV')
               end if
            end if
         
            call pgqci(clr_sav)
            call pgsci(y_color)
            if (panels_yaxis_log(j)) then
               call show_left_yaxis_label_pgstar(s,'log ' // yname)
            else
               call show_left_yaxis_label_pgstar(s,yname)
            end if
            call pgsci(clr_sav)
            call pgsci(y_color)
            call pgslw(s% pgstar_lw)            
            if (yfile_data_len > 0) then
               call pgline(yfile_data_len, yfile_xdata, yfile_ydata)
               deallocate(yfile_xdata, yfile_ydata)
               nullify(yfile_xdata, yfile_ydata)
            else
               call pgline(npts, xvec, yvec)
               if (panels_show_grid) then
                  ishape = 21
                  do k=1,npts
                     call pgpt1(xvec(k),yvec(k),ishape)
                  end do
               end if
            end if
            call pgslw(1)
            call pgsci(1)
         end do
         
         xname = trim(panels_xaxis_name)
         call show_xaxis_label_pgstar(s,xname)

         if (show_mix_regions) then ! show mix regions at bottom of plot
            call pgslw(10)
            call show_mix_regions_on_xaxis( &
               s,ybot,ytop,grid_min,grid_max,unshifted_xvec)
         end if

         deallocate(xvec, yvec, other_yvec, unshifted_xvec)

         call pgunsa
         
         
      end subroutine Pro_panels_plot

      

      end module pgstar_profile_panels

