! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************


! this code is based on subroutine gtrs from Dave Arnett's TYCHO


      module hydro_gr_factors
      
      use star_private_def
      use const_def
      
      implicit none

      logical, parameter :: dbg = .false.      

      contains
            
      
      subroutine set_gr_factors(s, ierr)
         type (star_info), pointer :: s         
         integer, intent(out) :: ierr
         
         integer :: k, nz
         real(dp) :: crad2, fpast, f2, dpq, fact, dphi, dm, bk, thek, &
            gmcenter, twoGmrc2
            
         include 'formats'

         ierr = 0
         
         return ! not yet

         nz = s% nz
         crad2 = clight*clight
         
         
         ! gr_w --- at cell edge
         fpast = 0; f2 = 0
         do k = 1, nz
            f2 = 1d0 + (s% energy(k) + s% P(k)/s% rho(k))/crad2
            if (k == 1) then
               s% gr_w(k) = f2
            else
               s% gr_w(k) = (f2 + fpast)*0.5d0
            end if
            fpast = f2
         end do
         
         ! gr_efi --- at cell edge
         s% gr_efi(1) = 1
         do k = 2, nz ! synchronize clocks with co-moving observer at edge 1
            if (k == 2) then
               dpq = s% P(k-1) - s% P(k)
            else
               dpq = (s% P(k-2) - s% P(k))*0.5d0
            end if
            fact = crad2*0.5d0*(s% gr_w(k) + s% gr_w(k-1))
            dphi = -dpq/(fact*s% rho(k-1))
            s% gr_efi(k) = s% gr_efi(k-1)*exp_cr(-dphi)
         end do
         

         ! gr_gam and gr_m --- at cell edge
         if (s% M_center == 0) then
            gmcenter = 0
         else ! GR gravity factor = 1/sqrt(1-2Gm/(rc^2))
            twoGmrc2 = 2*s% cgrav(nz)*s% M_center/(s% R_center*crad2)
            gmcenter = s% M_center/sqrt(1d0 - twoGmrc2)
         end if
         do k = nz, 1, -1
            dm = s% dm(k)
            bk = 1d0 + s% energy(k)/crad2 ! + zeta   ! eqn A5
            thek = s% cgrav(k)*bk*dm/(2*crad2*s% r(k))  ! eqn A9
            ! eqn A10
            fact = 1 + thek*thek
            if (s% v_flag) fact = fact + s% v(k)*s% v(k)/crad2
            if (k == nz) then ! use gr_m(nz+1) = gmcenter and gr_gam(nz+1) = 1
               fact = fact - 2d0*s% cgrav(k)*gmcenter/(crad2*s% r(k))
               fact = fact - 2d0*thek
            else
               fact = fact - 2d0*s% cgrav(k)*s% gr_m(k+1)/(crad2*s% r(k))
               fact = fact - 2d0*s% gr_gam(k+1)*thek
            end if
            if (fact <= 0) then
               write(*,2) 'coordinate singularity at', k, fact
               ierr = -1
               return
            endif
            s% gr_gam(k) = sqrt(fact) - thek ! eqn A8
            if (k == nz) then ! eqns A4 & A7
               s% gr_m(k) = 0.5d0*(1 + s% gr_gam(k))*dm*bk + gmcenter
            else
               s% gr_m(k) = s% gr_m(k+1) + &
                  0.5d0*(s% gr_gam(k+1) + s% gr_gam(k))*dm*bk
            end if
         end do
         
      end subroutine set_gr_factors


      end module hydro_gr_factors










