! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module ctrls_io
      
      use const_def
      use star_private_def

      implicit none
      
      include "star_controls.inc"      
      
      logical :: read_extra_controls_inlist1
      character (len=strlen) :: extra_controls_inlist1_name 
   
      logical :: read_extra_controls_inlist2
      character (len=strlen) :: extra_controls_inlist2_name 
   
      logical :: read_extra_controls_inlist3
      character (len=strlen) :: extra_controls_inlist3_name 
   
      logical :: read_extra_controls_inlist4
      character (len=strlen) :: extra_controls_inlist4_name 
   
      logical :: read_extra_controls_inlist5
      character (len=strlen) :: extra_controls_inlist5_name 
      

      namelist /controls/ &
         
      ! where to start
         initial_mass, &
         initial_z, &
         initial_y, &

      ! definition of core boundaries
         he_core_boundary_h1_fraction, &
         c_core_boundary_he4_fraction, &
         o_core_boundary_c12_fraction, &
         si_core_boundary_o16_fraction, &
         fe_core_boundary_si28_fraction, &
         neutron_rich_core_boundary_Ye_max, &
         min_boundary_fraction, &
         
      ! when to stop
         max_model_number, &
         max_number_backups, &
         max_backups_in_a_row, &
         relax_max_number_backups, &
         relax_max_number_retries, &
         max_number_retries, &
         max_age, &
         max_age_in_seconds, &
         num_adjusted_dt_steps_before_max_age, &
         dt_years_for_steps_before_max_age, &
         reduction_factor_for_max_timestep, &
         when_to_stop_rtol, &
         when_to_stop_atol, & 
         gamma_center_limit, &
         eta_center_limit, &
         log_center_temp_limit, &
         log_max_temp_upper_limit, &
         log_max_temp_lower_limit , &
         log_center_temp_lower_limit, &
         log_center_density_limit, &
         log_center_density_lower_limit, &
         center_entropy_limit, center_entropy_lower_limit, &
         max_entropy_limit, max_entropy_lower_limit, &
         min_timestep_limit, &
         logQ_limit, &
         fe_core_infall_limit, &
         center_Ye_lower_limit, &
         non_fe_core_infall_limit, &
         v_div_csound_surf_limit, &
         Lnuc_div_L_upper_limit, &
         Lnuc_div_L_lower_limit, &
         v_surf_div_v_kh_upper_limit, &
         v_surf_div_v_kh_lower_limit, &
         v_surf_div_v_esc_limit, &
         stop_near_zams, &
         Lnuc_div_L_zams_limit, &
         Pgas_div_P_limit, &
         Pgas_div_P_limit_max_q, &
         peak_burn_vconv_div_cs_limit, &
         omega_div_omega_crit_limit, &
         delta_nu_lower_limit, &
         delta_nu_upper_limit, &
         delta_Pg_lower_limit, &
         delta_Pg_upper_limit, &
         
         stop_when_done_with_piston, &
         stop_when_piston_v_goes_negative, &
         stop_when_done_with_center_flash, &

         surface_accel_div_grav_limit, &
         
         xa_central_lower_limit_species, &
         xa_central_lower_limit, &
         
         xa_central_upper_limit_species, &
         xa_central_upper_limit, &
         
         xa_surface_lower_limit_species, &
         xa_surface_lower_limit, &
         
         xa_surface_upper_limit_species, &
         xa_surface_upper_limit, &
         
         HB_limit, &
         stop_at_TP, &
         TP_he_shell_max, &
         
         star_mass_min_limit, &
         star_mass_max_limit, &
         star_H_mass_min_limit, &
         star_H_mass_max_limit, &
         star_He_mass_min_limit, &
         star_He_mass_max_limit, &
         star_C_mass_min_limit, &
         star_C_mass_max_limit, &
         xmstar_min_limit, &
         xmstar_max_limit, &
         envelope_mass_limit, &
         envelope_fraction_left_limit, &
         
         he_core_mass_limit, &
         c_core_mass_limit, &
         o_core_mass_limit, &
         si_core_mass_limit, &
         fe_core_mass_limit, &
         neutron_rich_core_mass_limit, &
         
         he_layer_mass_lower_limit, &
         abs_diff_lg_LH_lg_Ls_limit, &
         Teff_upper_limit, &
         Teff_lower_limit, &
         photosphere_r_upper_limit, &
         photosphere_r_lower_limit, &
         log_Teff_upper_limit, &
         log_Teff_lower_limit, &
         log_Tsurf_upper_limit, &
         log_Tsurf_lower_limit, &
         log_Psurf_upper_limit, &
         log_Psurf_lower_limit, &
         log_Dsurf_upper_limit, &
         log_Dsurf_lower_limit, &
         log_L_upper_limit, &
         log_L_lower_limit, &
         log_g_upper_limit, &
         log_g_lower_limit, &
         power_nuc_burn_upper_limit, &
         power_h_burn_upper_limit, &
         power_he_burn_upper_limit, &
         power_c_burn_upper_limit, &
         power_nuc_burn_lower_limit, &
         power_h_burn_lower_limit, &
         power_he_burn_lower_limit, &
         power_c_burn_lower_limit, &
         phase_of_evolution_stop, &
         
      ! max timesteps
         max_timestep, &
         max_years_for_timestep, &

         hi_T_max_years_for_timestep, &
         max_timestep_hi_T_limit, &
         
      ! output of "snapshots" for restarts
         photostep, &
         photo_digits, &
         photo_directory, &
         
      ! output of logs and profiles
         do_history_file, &
         history_interval, &
         write_header_frequency, &
         terminal_interval, &
         terminal_cnt, &
         terminal_show_age_in_years, &
         extra_terminal_output_file, &
         num_trace_history_values, &
         trace_history_value_name, &
         write_profiles_flag, &
         profile_interval, &
         priority_profile_interval, &
         log_directory, &
         star_history_name, &
         star_history_header_name, &
         star_history_dbl_format, &
         star_history_int_format, &
         star_history_txt_format, &
         
         profiles_index_name, &
         profile_data_prefix, &
         profile_data_suffix, &
         profile_data_header_suffix, &
         profile_int_format, &
         profile_txt_format, &
         profile_dbl_format, &
         
         profile_model, &
         max_num_profile_models, &
         max_num_profile_zones, &
         mass_loc_for_extra_log_info, &
         
         write_controls_info_with_profile, &
         controls_data_prefix, &
         controls_data_suffix, &
         
         write_pulse_info_with_profile, &
         pulse_info_format, &
         add_atmosphere_to_pulse_info, &
         add_center_point_to_pulse_info, &
         keep_surface_point_for_pulse_info, &
         write_pulsation_plot_data, &
         max_num_gyre_points, &
         format_for_FGONG_data, &
         format_for_OSC_data, &
         fgong_zero_A_inside_r, &
         
         write_model_with_profile, &
         model_data_prefix, &
         model_data_suffix, &
         
         
         mixing_D_limit_for_log, &
         trace_mass_location, &
         min_tau_for_max_abs_v_location, &
         min_q_for_inner_mach1_location, &
         max_q_for_outer_mach1_location, &
         
         
      ! burn zone eps definitions for use in logs and profiles
         burn_min1, &
         burn_min2, &
         
         max_conv_vel_div_csound_maxq, &
         width_for_limit_conv_vel, &
         max_q_for_limit_conv_vel, &
         max_mass_in_gm_for_limit_conv_vel, &
         max_r_in_cm_for_limit_conv_vel, &
         
      ! for reported surface/center abundances
         surface_avg_abundance_dq, &
         center_avg_value_dq, &
         
      ! mach1 location offsets
         mach1_plus_dr_factor, &
         mach1_minus_dr_factor, &
         
      ! definition of core overshooting boundary
         alpha_bdy_core_overshooting, &
         
      ! mixing parameters
         min_convective_gap, &
         min_thermohaline_gap, &
         min_semiconvection_gap, &
         min_thermohaline_dropout, &
         max_dropout_gradL_sub_grada, &
         remove_embedded_semiconvection, &
         remove_mixing_glitches, &
         okay_to_remove_mixing_singleton, &
         prune_bad_cz_min_Hp_height, &
         prune_bad_cz_min_log_eps_nuc, &
         redo_conv_for_dr_lt_mixing_length, &
         redo_mlt_for_OPEC, &
         limit_mixing_length_by_dist_to_bdy, &
         conv_bdy_mix_softening_f0, &
         conv_bdy_mix_softening_f, &
         conv_bdy_mix_softening_min_D_mix, &
         alpha_semiconvection, &
         semiconvection_upper_limit_center_h1, &
         semiconvection_option, &
         use_Ledoux_criterion, &
         redo_mix_info_at_each_iteration, &
         num_cells_for_smooth_gradL_composition_term, &
         clip_D_limit, &
         
         okay_to_reduce_gradT_excess, &
         gradT_excess_f1, &
         gradT_excess_f2, &
         gradT_excess_age_fraction, &
         gradT_excess_max_change, &
         gradT_excess_lambda1, &
         gradT_excess_beta1, &
         gradT_excess_lambda2, &
         gradT_excess_beta2, &
         gradT_excess_dlambda, &
         gradT_excess_dbeta, &
         gradT_excess_max_center_h1, &
         gradT_excess_min_center_he4, &
         gradT_excess_max_logT, &
         gradT_excess_min_log_tau_full_on, &
         gradT_excess_max_log_tau_full_off, &
         
         thermohaline_coeff, &
         thermohaline_option, &
         mixing_length_alpha, &
         remove_small_D_limit, &
         alt_scale_height_flag, &
         Henyey_MLT_y_param, &
         Henyey_MLT_nu_param, &
         MLT_option, &
         mlt_use_rotation_correction, &

         overshoot_f_above_nonburn_core, &
         overshoot_f_above_nonburn_shell, &
         overshoot_f_below_nonburn_shell, &
         overshoot_f_above_burn_h_core, &
         overshoot_f_above_burn_h_shell, &
         overshoot_f_below_burn_h_shell, &
         overshoot_f_above_burn_he_core, &
         overshoot_f_above_burn_he_shell, &
         overshoot_f_below_burn_he_shell, &
         overshoot_f_above_burn_z_core, &
         overshoot_f_above_burn_z_shell, &
         overshoot_f_below_burn_z_shell, &

         step_overshoot_f_above_nonburn_core, &
         step_overshoot_f_above_nonburn_shell, &
         step_overshoot_f_below_nonburn_shell, &
         step_overshoot_f_above_burn_h_core, &
         step_overshoot_f_above_burn_h_shell, &
         step_overshoot_f_below_burn_h_shell, &
         step_overshoot_f_above_burn_he_core, &
         step_overshoot_f_above_burn_he_shell, &
         step_overshoot_f_below_burn_he_shell, &
         step_overshoot_f_above_burn_z_core, &
         step_overshoot_f_above_burn_z_shell, &
         step_overshoot_f_below_burn_z_shell, &

         overshoot_f0_above_nonburn_core, &
         overshoot_f0_above_nonburn_shell, &
         overshoot_f0_below_nonburn_shell, &
         overshoot_f0_above_burn_h_core, &
         overshoot_f0_above_burn_h_shell, &
         overshoot_f0_below_burn_h_shell, &
         overshoot_f0_above_burn_he_core, &
         overshoot_f0_above_burn_he_shell, &
         overshoot_f0_below_burn_he_shell, &
         overshoot_f0_above_burn_z_core, &
         overshoot_f0_above_burn_z_shell, &
         overshoot_f0_below_burn_z_shell, &
         
         step_overshoot_D, &
         step_overshoot_D0_coeff,&
         
         overshoot_below_noburn_shell_factor, &
         max_DUP_counter, &
         
         ovr_below_burn_he_shell_factor, &
         
         mass_for_overshoot_full_on, &
         mass_for_overshoot_full_off, &
         
         smooth_convective_bdy, &
         max_dR_div_Hp_for_smooth, &
         max_delta_limit_for_smooth, &
         min_T_for_acceleration_limited_conv_velocity, &
         mlt_accel_g_theta, &
         max_conv_vel_div_csound, &
         
         calculate_Brunt_N2, &
         brunt_N2_coefficient, &
         num_cells_for_smooth_brunt_B, &
         use_brunt_dlnRho_form, &
         use_brunt_gradmuX_form, &
         interpolate_rho_for_pulsation_info, &
         min_magnitude_brunt_B, &

         min_overshoot_q, &
         D_mix_ov_limit, &
         max_brunt_B_for_overshoot, &
         overshoot_alpha, &
         
         radiation_turbulence_coeff, &
         turbulent_diffusion_D0, &
         turbulent_diffusion_rho_max, &
         
         T_mix_limit, &
         conv_dP_term_factor, &

      ! mass gain or loss
         mass_change, &
         mass_change_full_on_dt, &
         mass_change_full_off_dt, &
         trace_dt_control_mass_change, &
         
         min_abs_mdot_for_change_limits, &
         max_abs_mdot_factor, &
         min_abs_mdot_factor, &
         min_wind, &
         max_wind, &
         use_accreted_material_j, &
         accreted_material_j, &
         mdot_omega_power, &
         max_rotational_mdot_boost, &
         max_mdot_jump_for_rotation, &
         lim_trace_rotational_mdot_boost, &
         rotational_mdot_boost_fac, &
         rotational_mdot_kh_fac, &
         surf_avg_tau, &
         surf_avg_tau_min, &
         
         remove_H_wind_mdot, &
         remove_H_wind_H_mass_limit, &
         super_eddington_wind_eta, &
         super_eddington_wind_Ledd_factor, &
         wind_boost_full_off_L_div_Ledd, &
         wind_boost_full_on_L_div_Ledd, &
         super_eddington_wind_max_boost, &
         trace_super_eddington_wind_boost, &
         
         flash_wind_mdot, &
         flash_wind_starts, &
         flash_wind_declines, &
         flash_wind_full_off, &
         
         rlo_wind_eta, &
         rlo_wind_min_L, &
         rlo_wind_max_Teff, &
         rlo_wind_roche_lobe_radius, &
         roche_lobe_xfer_full_on, &
         roche_lobe_xfer_full_off, &
         rlo_wind_base_mdot, &
         rlo_wind_scale_height, &

         nova_wind_eta, &
         nova_wind_b, &
         nova_wind_max_Teff, &
         nova_wind_min_L, &
         nova_min_Teff_for_accretion, &
         nova_roche_lobe_radius, &
         nova_RLO_mdot, &
         
         RGB_wind_scheme, &
         AGB_wind_scheme, &
         RGB_to_AGB_wind_switch, &
         Reimers_wind_eta, &
         Blocker_wind_eta, &
         de_Jager_wind_eta, &
         van_Loon_wind_eta, &
         Nieuwenhuijzen_wind_eta, &
         Vink_wind_eta, &
         Grafener_wind_eta, &
         Kudritzki_wind_eta, &
         Dutch_wind_eta, &
         Dutch_wind_lowT_scheme, &
         Stern51_wind_eta, &
         wind_envelope_limit, &
         
      ! composition of added mass
         accrete_same_as_surface, &
         
         accrete_given_mass_fractions, &
         num_accretion_species, &
         accretion_species_id, &
         accretion_species_xa, &
         
         accretion_h1, &
         accretion_h2, &
         accretion_he3, &
         accretion_he4, &
         accretion_zfracs, &
         accretion_dump_missing_metals_into_heaviest, &

         ! special list of z fractions
         z_fraction_li, &
         z_fraction_be, &
         z_fraction_b, &
         z_fraction_c, &
         z_fraction_n, &
         z_fraction_o, &
         z_fraction_f, &
         z_fraction_ne, &
         z_fraction_na, &
         z_fraction_mg, &
         z_fraction_al, &
         z_fraction_si, &
         z_fraction_p, &
         z_fraction_s, &
         z_fraction_cl, &
         z_fraction_ar, &
         z_fraction_k, &
         z_fraction_ca, &
         z_fraction_sc, &
         z_fraction_ti, &
         z_fraction_v, &
         z_fraction_cr, &
         z_fraction_mn, &
         z_fraction_fe, &
         z_fraction_co, &
         z_fraction_ni, &
         z_fraction_cu, &
         z_fraction_zn, &
         
         pure_fe56_limit, &
         lgT_lo_for_set_new_abundances, &
         lgT_hi_for_set_new_abundances, &
         
      ! automatic stops for mass loss/gain
         max_star_mass_for_gain, &
         min_star_mass_for_loss, &
         max_T_center_for_any_mass_loss, &
         max_T_center_for_full_mass_loss, &
         
      ! extra power source
         extra_power_source, &

      ! relaxation parameters
         relax_dlnZ, &
         relax_dY, &
         
      ! mesh adjustment
         remesh_log_L_nuc_burn_min, &
         show_mesh_changes, &
         okay_to_remesh, &
         trace_mesh_adjust_error_in_conservation, &
         remesh_max_brunt_N2_composition_term, &
         remesh_cnt, &
         max_allowed_nz, &
         mesh_max_allowed_ratio, &
         remesh_max_allowed_logT, &
         max_delta_x_for_merge, &
         mesh_dump_call_number, &
         
         mesh_adjust_use_quadratic, &
         
         mesh_adjust_get_T_from_E, &

         max_dq, &
         min_dq, &
         min_dq_for_xa, &
         mesh_min_dlnR, &
         merge_if_dlnR_too_small, &
         mesh_min_dr_div_cs, &
         merge_if_dr_div_cs_too_small, &

         max_center_cell_dq, &
         max_surface_cell_dq, &
         max_num_subcells, &
         max_num_merge_cells, &
         
         mesh_delta_coeff, &
         mesh_delta_coeff_pre_ms, &
         mesh_delta_coeff_for_highT, &
         logT_max_for_standard_mesh_delta_coeff, &
         logT_min_for_highT_mesh_delta_coeff, &
         
         mesh_Pgas_div_P_exponent, &
         
         remesh_dt_limit, &

   		P_function_weight, &
         
         xtra_coef_above_xtrans, &
         xtra_coef_below_xtrans, &
         xtra_dist_above_xtrans, &
         xtra_dist_below_xtrans, &
         
         xtra_coef_czb_full_on, &
         xtra_coef_czb_full_off, &
   		   		
         xtra_coef_a_l_nb_czb, &
         xtra_coef_a_l_hb_czb, &
         xtra_coef_a_l_heb_czb, &
         xtra_coef_a_l_zb_czb, &
         
         xtra_coef_b_l_nb_czb, &
         xtra_coef_b_l_hb_czb, &
         xtra_coef_b_l_heb_czb, &
         xtra_coef_b_l_zb_czb, &
         
         xtra_coef_a_u_nb_czb, &
         xtra_coef_a_u_hb_czb, &
         xtra_coef_a_u_heb_czb, &
         xtra_coef_a_u_zb_czb, &
         
         xtra_coef_b_u_nb_czb, &
         xtra_coef_b_u_hb_czb, &
         xtra_coef_b_u_heb_czb, &
         xtra_coef_b_u_zb_czb, &

         xtra_dist_a_l_nb_czb, &
         xtra_dist_a_l_hb_czb, &
         xtra_dist_a_l_heb_czb, &
         xtra_dist_a_l_zb_czb, &
         
         xtra_dist_b_l_nb_czb, &
         xtra_dist_b_l_hb_czb, &
         xtra_dist_b_l_heb_czb, &
         xtra_dist_b_l_zb_czb, &
         
         xtra_dist_a_u_nb_czb, &
         xtra_dist_a_u_hb_czb, &
         xtra_dist_a_u_heb_czb, &
         xtra_dist_a_u_zb_czb, &
         
         xtra_dist_b_u_nb_czb, &
         xtra_dist_b_u_hb_czb, &
         xtra_dist_b_u_heb_czb, &
         xtra_dist_b_u_zb_czb, &
         
         xtra_coef_scz_above_nb_cz, &
         xtra_coef_scz_above_hb_cz, &
         xtra_coef_scz_above_heb_cz, &
         xtra_coef_scz_above_zb_cz, &
         
         xtra_coef_os_full_on, &
         xtra_coef_os_full_off, &

         xtra_coef_os_above_nonburn, &
         xtra_coef_os_below_nonburn, &
         xtra_coef_os_above_burn_h, &
         xtra_coef_os_below_burn_h, &
         xtra_coef_os_above_burn_he, &
         xtra_coef_os_below_burn_he, &
         xtra_coef_os_above_burn_z, &
         xtra_coef_os_below_burn_z, &
         
         xtra_dist_os_above_nonburn, &
         xtra_dist_os_below_nonburn, &
         xtra_dist_os_above_burn_h, &
         xtra_dist_os_below_burn_h, &
         xtra_dist_os_above_burn_he, &
         xtra_dist_os_below_burn_he, &
         xtra_dist_os_above_burn_z, &
         xtra_dist_os_below_burn_z, &

         mesh_logX_species, &
         mesh_logX_min_for_extra, &
         mesh_dlogX_dlogP_extra, &
         mesh_dlogX_dlogP_full_on, &
         mesh_dlogX_dlogP_full_off, &

         convective_bdy_min_dt_yrs, &
         convective_bdy_dq_limit, &
         convective_bdy_weight, &


         mesh_dlog_eps_min_for_extra, &
         mesh_dlog_eps_dlogP_full_on, &
         mesh_dlog_eps_dlogP_full_off, &

         mesh_dlog_pp_dlogP_extra, &
         mesh_dlog_cno_dlogP_extra, &
         mesh_dlog_3alf_dlogP_extra, &
         
         mesh_dlog_burn_c_dlogP_extra, &
         mesh_dlog_burn_n_dlogP_extra, &
         mesh_dlog_burn_o_dlogP_extra, &
         mesh_dlog_burn_ne_dlogP_extra, &
         mesh_dlog_burn_na_dlogP_extra, &
         mesh_dlog_burn_mg_dlogP_extra, &
         mesh_dlog_burn_si_dlogP_extra, &
         mesh_dlog_burn_s_dlogP_extra, &
         mesh_dlog_burn_ar_dlogP_extra, &
         mesh_dlog_burn_ca_dlogP_extra, &
         mesh_dlog_burn_ti_dlogP_extra, &
         mesh_dlog_burn_cr_dlogP_extra, &
         mesh_dlog_burn_fe_dlogP_extra, &
         
         mesh_dlog_cc_dlogP_extra, &
         mesh_dlog_co_dlogP_extra, &
         mesh_dlog_oo_dlogP_extra, &
         
         mesh_dlog_pnhe4_dlogP_extra, &
         mesh_dlog_photo_dlogP_extra, &
         mesh_dlog_other_dlogP_extra, &
         
   		T_function1_weight, &
   		T_function2_weight, &
   		T_function2_param, &
         
   		R_function_weight, &
   		R_function_param, &
         
   		R_function2_weight, &
   		R_function2_param1, &
   		R_function2_param2, &
         
   		M_function_weight, &
   		M_function_param, &
   		
   		gradT_function_weight, &
   		log_tau_function_weight, &
   		log_kap_function_weight, &
   		omega_function_weight, &

   		gam_function_weight, &
   		gam_function_param1, &
   		gam_function_param2, &
         
         xa_function_species, &
   		xa_function_weight, &
   		xa_function_param, &   
   		xa_mesh_delta_coeff, &      

      ! nuclear reaction parameters
         screening_mode, &
         default_net_name, &
         
         net_logTcut_lo, &
         net_logTcut_lim, &
         
         eps_nuc_factor, &
         max_abs_eps_nuc, &
         dxdt_nuc_factor, &
         max_abar_for_burning, &
         mix_factor, &
         fe56ec_fake_factor, &
         weak_rate_factor, &
         
         sig_term_limit, &

         sig_min_factor_for_high_Tcenter, &
         Tcenter_min_for_sig_min_factor_full_on, &
         Tcenter_max_for_sig_min_factor_full_off, &
         max_delta_m_to_bdy_for_sig_min_factor, &
         delta_m_lower_for_sig_min_factor, &
         delta_m_upper_for_sig_min_factor, &
         Tcenter_max_for_dble_bcyclic, &
         
         am_sig_term_limit, &
         am_D_mix_factor, &
         am_gradmu_factor, &
         am_nu_factor, &

         D_visc_factor, &
         D_DSI_factor, &
         D_SH_factor, &
         D_SSI_factor, &
         D_ES_factor, &
         D_GSF_factor, &
         D_ST_factor, &

         am_nu_non_rotation_factor, &
         skip_rotation_in_convection_zones, &
         am_nu_DSI_factor, &
         am_nu_SH_factor, &
         am_nu_SSI_factor, &
         am_nu_ES_factor, &
         am_nu_GSF_factor, &
         am_nu_ST_factor, &
         am_nu_visc_factor, &
         
         am_nu_omega_rot_factor, &
         am_nu_omega_non_rot_factor, &
         am_nu_j_rot_factor, &
         am_nu_j_non_rot_factor, &
         
         smooth_nu_ST, &
         smooth_D_ST, &
         smooth_D_SH, &
         smooth_D_DSI, &
         smooth_D_ES, &
         smooth_D_SSI, &
         smooth_D_GSF, &
         
         angsmt_D_DSI, &
         angsmt_D_SH, &
         angsmt_D_SSI, &
         angsmt_D_ES, &
         angsmt_D_GSF, &
         angsmt_D_ST, &
         angsmt_nu_ST, &
         angsml, &
         am_time_average, &
         simple_i_rot_flag, &
         do_adjust_J_lost, &
         premix_omega, &
         adjust_J_fraction, &
         max_mdot_redo_cnt, &
         mdot_revise_factor, &
         implicit_mdot_boost, &
         min_years_dt_for_redo_mdot, &
         surf_w_div_w_crit_limit, &
         surf_w_div_w_crit_tol, &
         
         fp_min, &
         ft_min, &
         fp_error_limit, &
         ft_error_limit, &

         D_mix_rotation_max_logT_full_on, &
         D_mix_rotation_min_logT_full_off, &
         
         set_uniform_am_nu_non_rot, &
         uniform_am_nu_non_rot, &
         
         set_min_am_nu_non_rot, &
         min_am_nu_non_rot, &
         min_center_Ye_for_min_am_nu_non_rot, &
         
         set_min_D_mix, &
         min_D_mix, &
         min_center_Ye_for_min_D_mix, &
         
         op_split_gradT_fraction_grada, &

         smooth_outer_xa_big, &
         smooth_outer_xa_small, &
         
         reaction_neuQs_factor, &
         
      ! element diffusion parameters
         diffusion_use_iben_macdonald, &
         do_element_diffusion, &
         diffusion_min_dq_at_surface, &
         diffusion_min_T_at_surface, &
         diffusion_min_dq_ratio_at_surface, &
         diffusion_dt_limit, &

         diffusion_min_X_hard_limit, &
         diffusion_X_total_atol, &
         diffusion_X_total_rtol, &
         diffusion_upwind_abs_v_limit, &
         diffusion_dt_div_timescale, &
         diffusion_min_num_substeps, &
         diffusion_max_iters_per_substep, &
         diffusion_max_retries_per_substep, &
         diffusion_v_max, &
         diffusion_gamma_full_off, &
         diffusion_gamma_full_on, &
         diffusion_T_full_on, &
         diffusion_T_full_off, &
         diffusion_calculates_ionization, &
         diffusion_nsmooth_typical_charge, &
         diffusion_tol_correction_max, &
         diffusion_tol_correction_norm, &
         
         diffusion_AD_dm_full_on, &
         diffusion_AD_dm_full_off, &
         diffusion_AD_boost_factor, &
         
         diffusion_SIG_factor, &
         diffusion_GT_factor, &
         
         diffusion_Vlimit_dm_full_on, &
         diffusion_Vlimit_dm_full_off, &
         diffusion_Vlimit, &
         
         diffusion_max_T_for_radaccel, &
         diffusion_min_T_for_radaccel, &
         diffusion_screening_for_radaccel, &
         op_mono_data_path, &
         op_mono_data_cache_filename, &
         
         show_diffusion_info, &
         show_diffusion_substep_info, &
         show_diffusion_timing, &
         
         diffusion_num_classes, &
         diffusion_class_representative, &
         diffusion_class_A_max, &
         diffusion_class_typical_charge, &
         diffusion_class_factor, &
         
         diffusion_use_isolve, &
         diffusion_rtol_for_isolve, &
         diffusion_atol_for_isolve, &
         diffusion_maxsteps_for_isolve, &
         diffusion_isolve_solver, &

      ! eos controls
         use_fixed_XZ_for_eos, &
         fixed_X_for_eos, &
         fixed_Z_for_eos, &
         
         use_eosDE_get, &
         
         use_eosDT_ideal_gas, &
         use_eosDT_HELMEOS, &       
         eosDT_HELMEOS_include_radiation, &
         eosDT_HELMEOS_always_skip_elec_pos, &

      ! opacity controls
         cubic_interpolation_in_X, &
         cubic_interpolation_in_Z, &
         include_electron_conduction, &

         use_simple_es_for_kap, &
         Zbase, &
         use_Type2_opacities, &
         kap_Type2_full_off_X, &
         kap_Type2_full_on_X, &
         kap_Type2_full_off_dZ, &
         kap_Type2_full_on_dZ, &
         low_logT_op_mono_full_off, &
         low_logT_op_mono_full_on, &
         high_logT_op_mono_full_off, &
         high_logT_op_mono_full_on, &
         op_mono_min_X_to_include, &
         use_op_mono_alt_get_kap, &

         include_L_in_error_est, &
         include_v_in_error_est, &
         just_use_energy_resid, &
            
         ! asteroseismology controls
         
         get_delta_nu_from_scaled_solar, &
         nu_max_sun, &
         delta_nu_sun, &
         Teff_sun, &
         delta_Pg_mode_freq, &
         
         ! hydro parameters
         opacity_factor, &
         opacity_max, &
         min_logT_for_opacity_factor_off, &
         min_logT_for_opacity_factor_on, &
         max_logT_for_opacity_factor_on, &
         max_logT_for_opacity_factor_off, &

         non_nuc_neu_factor, &
         accel_factor, &
         use_gr_factors, &
         use_dvdt_form_of_momentum_eqn, &
         use_dlnddt_form_of_density_eqn, &
         use_dedt_form_of_energy_eqn, &
         use_sr_sound_speed, &
         use_mass_corrections, &
         use_dP_dm_rotation_correction, &
         eps_grav_factor, &
         eps_grav_dt_use_start_values, &
         use_lnS_for_eps_grav, &
         use_dEdRho_form_for_eps_grav, &
         use_dlnd_dt_form_for_eps_grav, &
         use_PdVdt_form_for_eps_grav, &
         include_dmu_dt_in_eps_grav, &
         factor_for_test_CpT_absMdot_div_L, &
         eps_grav_time_deriv_separation, &
         zero_eps_grav_in_just_added_material, &
         min_del_T_div_dt, &
         max_abs_rel_change_surf_lnS, &
         trace_force_another_iteration, &
         max_num_surf_revisions, &
         Gamma_lnS_eps_grav_full_off, &
         Gamma_lnS_eps_grav_full_on, &
         use_artificial_viscosity, &
         hold_artificial_viscosity_const_during_step, &
         artificial_viscosity_Q_shift, &
         art_visc_full_off_logRho_le_this, &
         art_visc_full_on_logRho_ge_this, &
         post_shock_viscosity_decay_factor, &
         pre_shock_viscosity_decay_factor, &
         use_dPrad_dm_form_of_T_gradient_eqn, &
         use_energy_conservation_form, &
         theta_P, &
         use_ODE_var_eqn_pairing, &
         use_bdf_instead_of_ebdf, &
         use_sdirk_instead_of_ebdf, &
         use_symplectic_instead_of_ebdf, &
         max_ebdf_order, &
         min_ebdf_order, &
         steps_before_try_higher_ebdf_order, &
         factor_for_ebdf_order_tests, &
         ebdf_redo_mix_coeffs_other_stages, &
         ebdf_redo_mix_for_comparison_stage, &
         ebdf_redo_mix_for_final_stage, &
         trace_truncation_ratio, &
         qmin_freeze_non_radiative_luminosity, &
         qmax_zero_non_radiative_luminosity, &
         eps_visc_factor, &
         dvdt_visc_factor, &
         shock_spread_quadratic, &
         shock_spread_linear, &

         center_flash_total_time, &
         center_flash_ramp_up_duration, &
         center_flash_ramp_down_duration, &
         center_flash_total_ergs, &
         
         use_piston, &
         piston_period, &
         periodic_piston_max_displacement, &
         periodic_piston_number_of_cycles, &
         periodic_piston_done_delay, &
         piston_inward_time, &
         piston_Rmin, &
         piston_v0, &
         piston_Rmax, &
         reset_total_energy_initial_when_done_with_piston, &
         
         velocity_logT_lower_bound, &
         max_dt_yrs_for_velocity_logT_lower_bound, &
         velocity_q_upper_bound, &
         
         min_dxm_Eulerian_div_dxm_CpTMdot_lt_L, &
         min_dxm_Eulerian_div_dxm_removed, &
         min_dxm_Eulerian_div_dxm_added, &
         min_cells_for_Eulerian_to_Lagrangian_transition, &

         
         ! hydro solver
         
         split_mixing_choice, &
         split_mix_do_burn, &
         op_split_burn_mix_num_passes, &

         op_split_mix_trace, &
         op_split_mix_atol, &
         op_split_mix_rtol, &
         
         op_split_burn_trace, &
         op_split_burn_tol_max_correction, &
         op_split_burn_tol_avg_correction, &
         op_split_burn_lambda_undercorrection, &
         op_split_burn_tol_hi_logT_limit, &
         op_split_burn_tol_hi_logT_factor, &
         
         op_split_burn_sparse_limit, &
         op_split_burn_use_net_info_for_sparsity, &
         op_split_burn_min_lambda, &
         op_split_burn_use_pivoting, &
         reset_mixing_info_before_final_mix, &
         
         op_split_burn_max_iterations, &
         burn_maxabs_dt_d_dxdt_dt, &
         burn_try_substeps_if_BE_fails, &
         burn_reuse_given_rates, &
         burn_pause_for_failure, &
         op_split_burn_mix_trace, &
         op_split_burn_use_quad_min_T, &
         op_split_burn_refine_min_T, &
         op_split_burn_refine_maxerr_limit, &
         op_split_burn_use_DGESVX_min_T, &

         op_split_burn_k_dbg, &
         op_split_burn_dbg_model_number, &

         op_split_burn_min_logT_for_partials, &
         op_split_burn_partials_dlogRho, &
         op_split_burn_partials_dlogT, &
         
         substep_min_T, &
         burn_stptry, &
         burn_max_steps, &
         burn_eps, &
         burn_odescal, &

         substep_burn_solver, &
         substep_burn_decsol, &
         substep_burn_max_steps, &
         substep_burn_rtol, &
         substep_burn_atol, &
         substep_burn_xmin, &
         substep_burn_xmax, &
         substep_burn_clip, &
         substep_burn_use_eps_binding, &

         tol_correction_norm, &
         tol_max_correction, &
         tol_correction_norm_alt, &
         tol_max_correction_alt, &
         sizeB_gam0, &
         size_del_gam, &
         correction_xa_limit, &
         
         tol_correction_high_T_limit, &
         tol_correction_norm_high_T, &
         tol_max_correction_high_T, &
         
         tol_correction_extreme_T_limit, &
         tol_correction_norm_extreme_T, &
         tol_max_correction_extreme_T, &
         
         tol_max_residual1, tol_residual_norm1, &
         tol_max_residual2, tol_residual_norm2, &
         tol_max_residual3, tol_residual_norm3, &
         trace_newton_damping, &
         
         max_iterations_for_jacobian, &
         refine_solution, &
         refine_mtx_solution, &
         
         star_bcyclic_do_pivot, &
         sparse_min_refactor_rgrowth, &

         small_mtx_decsol, &
         large_mtx_decsol, &
         hydro_decsol_switch, &
         sparse_non_zero_max_factor, &

         iter_for_resid_tol2, &
         iter_for_resid_tol3, &
         
         newton_itermin, &
         newton_itermin_until_reduce_min_corr_coeff, &
         newton_reduced_min_corr_coeff, &
         do_newton_damping_for_neg_xa, &
         hydro_mtx_max_allowed_abs_dlogT, &
         hydro_mtx_max_allowed_abs_dlogRho, &
         hydro_mtx_max_allowed_abs_dlogPgas, &
         min_logT_for_hydro_mtx_max_allowed, &
         hydro_mtx_max_allowed_logT, &
         hydro_mtx_max_allowed_logRho, &
         hydro_mtx_max_allowed_logPgas, &
         
         hydro_solver_name, &
         
         tiny_corr_coeff_limit, &
         scale_correction_norm, &
         corr_param_factor, &
         scale_max_correction, &
         
         corr_norm_jump_limit, &
         max_corr_jump_limit, &
         resid_norm_jump_limit, &
         max_resid_jump_limit, &
         
         corr_coeff_limit, &
         tiny_corr_factor, &
         matrix_type, &
         
         max_tries1, &
         max_tries, &
         max_tries_for_retry, &
         max_tries_after_5_retries, &
         max_tries_after_10_retries, &
         max_tries_after_20_retries, &
         max_tries_after_backup, &
         max_tries_after_backup2, &
         retry_limit, &
         redo_limit, &
         
         min_xa_hard_limit, &
         min_xa_hard_limit_for_highT, &
         logT_max_for_min_xa_hard_limit, &
         logT_min_for_min_xa_hard_limit_for_highT, &
         
         sum_xa_hard_limit, &
         sum_xa_hard_limit_for_highT, &
         logT_max_for_sum_xa_hard_limit, &
         logT_min_for_sum_xa_hard_limit_for_highT, &
         
         xa_clip_limit, &
         report_hydro_solver_progress, &
         hydro_dump_call_number, &
         hydro_dump_iter_number, &
         hydro_numerical_jacobian, &
         hydro_jacobian_nzlo, &
         hydro_jacobian_nzhi, &
         hydro_check_everything, &
         hydro_inspectB_flag, &
         hydro_show_correction_info, &
         hydro_save_numjac_plot_data, &
         trace_k, &
         
      ! timestep
         DUP_varcontrol_factor, &
         min_timestep_factor, &
         max_timestep_factor, &
         timestep_factor_for_backups, &
         timestep_factor_for_retries, &
         backup_hold, &
         retry_hold, &     
         neg_mass_fraction_hold, &
         timestep_dt_factor, &  
         dt_limit_ratio_target, &         
         use_dt_low_pass_controller, &

         varcontrol_target, &
         varcontrol_dt_limit_ratio_hard_max, &
         xa_scale, &

         truncation_ratio_xh_atol, &
         truncation_ratio_xh_rtol, &
         truncation_ratio_xa_atol, &
         truncation_ratio_xa_rtol, &
         truncation_ratio_limit, &
         truncation_ratio_hard_limit, &
         eval_truncation_ratio_do_max, &
         use_truncation_ratio_limit, &
         
         newton_iterations_limit, &
         newton_iterations_hard_limit, &
         
         rotation_steps_limit, &
         rotation_steps_hard_limit, &
         
         diffusion_steps_limit, &
         diffusion_steps_hard_limit, &  
         diffusion_iters_limit, &
         diffusion_iters_hard_limit, &
         
         dt_div_dt_cell_collapse_limit, &
         dt_div_dt_cell_collapse_hard_limit, & 
         dt_div_dt_Courant_limit, &
         dt_div_dt_Courant_hard_limit, & 
         dt_div_dt_thermal_limit, & 
         dt_div_dt_thermal_hard_limit, & 
         dt_div_dt_dynamic_limit, & 
         dt_div_dt_dynamic_hard_limit, & 
         dt_div_dt_acoustic_limit, & 
         dt_div_dt_acoustic_hard_limit, & 
         dt_div_dt_mass_loss_limit, & 
         dt_div_dt_mass_loss_hard_limit, & 
         
         burn_max_iters_limit, &
         burn_max_iters_hard_limit, &

         burn_max_substeps_limit, &
         burn_max_substeps_hard_limit, &
         
         max_fixup_for_mix_limit, &
         max_fixup_for_mix_hard_limit, &
         
         dX_mix_dist_limit, &
         
         dH_limit_min_H, & 
         dH_limit, & 
         dH_hard_limit, & 
         dH_div_H_limit_min_H, & 
         dH_div_H_limit, & 
         dH_div_H_hard_limit, &
         dH_decreases_only, &
         
         dHe_limit_min_He, & 
         dHe_limit, & 
         dHe_hard_limit, & 
         dHe_div_He_limit_min_He, & 
         dHe_div_He_limit, & 
         dHe_div_He_hard_limit, & 
         dHe_decreases_only, &
         
         dHe3_limit_min_He3, & 
         dHe3_limit, & 
         dHe3_hard_limit, & 
         dHe3_div_He3_limit_min_He3, & 
         dHe3_div_He3_limit, & 
         dHe3_div_He3_hard_limit, & 
         dHe3_decreases_only, &
         
         dX_limit_min_X, & 
         dX_limit, & 
         dX_hard_limit, & 
         dX_div_X_limit_min_X, & 
         dX_div_X_limit, & 
         dX_div_X_hard_limit, & 
         dX_decreases_only, &
         
         dX_nuc_drop_min_X_limit, &
         dX_nuc_drop_max_A_limit, &
         dX_nuc_drop_limit, &
         dX_nuc_drop_limit_at_high_T, &
         dX_nuc_drop_hard_limit, &
         dX_nuc_drop_min_yrs_for_dt, &
         
         dL_div_L_limit_min_L, &
         dL_div_L_limit, &
         dL_div_L_hard_limit, &
         
         delta_lgP_limit, &   
         delta_lgP_hard_limit, &    
         delta_lgP_limit_min_lgP, &
                
         delta_lgRho_limit, &   
         delta_lgRho_hard_limit, & 
         delta_lgRho_limit_min_lgRho, &  
             
         delta_lgT_limit, & 
         delta_lgT_hard_limit, &     
         delta_lgT_limit_min_lgT, &
             
         delta_lgE_limit, & 
         delta_lgE_hard_limit, &     
         delta_lgE_limit_min_lgE, &
               
         delta_lgR_limit, &
         delta_lgR_hard_limit, &
         delta_lgR_limit_min_lgR, &
         
         delta_Ye_limit, &
         delta_Ye_hard_limit, &
         delta_Ye_highT_limit, &
         delta_Ye_highT_hard_limit, &
         minT_for_highT_Ye_limit, &
         
         d_deltaR_shrink_limit, &
         d_deltaR_shrink_hard_limit, &
         d_deltaR_grow_limit, &
         d_deltaR_grow_hard_limit, &

         delta_lgL_nuc_cat_limit, &
         delta_lgL_nuc_cat_hard_limit, &
         lgL_nuc_cat_burn_min, &
         lgL_nuc_mix_dist_limit, &

         check_delta_lgL_pp, &
         check_delta_lgL_cno, &
         check_delta_lgL_3alf, &
         
         check_delta_lgL_burn_c, &
         check_delta_lgL_burn_n, &
         check_delta_lgL_burn_o, &
         check_delta_lgL_burn_ne, &
         check_delta_lgL_burn_na, &
         check_delta_lgL_burn_mg, &
         check_delta_lgL_burn_si, &
         check_delta_lgL_burn_s, &
         check_delta_lgL_burn_ar, &
         check_delta_lgL_burn_ca, &
         check_delta_lgL_burn_ti, &
         check_delta_lgL_burn_cr, &
         check_delta_lgL_burn_fe, &
         
         check_delta_lgL_cc, &
         check_delta_lgL_co, &
         check_delta_lgL_oo, &

         delta_lgL_H_limit, &
         delta_lgL_H_hard_limit, &
         lgL_H_burn_min, &
         lgL_H_drop_factor, &
         lgL_H_burn_relative_limit, &

         delta_lgL_He_limit, &
         delta_lgL_He_hard_limit, &
         lgL_He_burn_min, &
         lgL_He_drop_factor, &
         lgL_He_burn_relative_limit, &

         delta_lgL_z_limit, &
         delta_lgL_z_hard_limit, &
         lgL_z_burn_min, &
         lgL_z_drop_factor, &
         lgL_z_burn_relative_limit, &

         delta_lgL_photo_limit, &
         delta_lgL_photo_hard_limit, &
         lgL_photo_burn_min, &
         lgL_photo_drop_factor, &

         delta_lgL_nuc_limit, &
         delta_lgL_nuc_hard_limit, &
         lgL_nuc_burn_min, &
         lgL_nuc_drop_factor, &

         delta_lgRho_cntr_limit, &   
         delta_lgRho_cntr_hard_limit, &  
                  
         delta_lgT_cntr_limit, & 
         delta_lgT_cntr_hard_limit, &
         
         delta_lgT_max_limit, &
         delta_lgT_max_hard_limit, &
         
         delta_lgRho_max_limit, &
         delta_lgRho_max_hard_limit, &
         
         delta_log_eps_nuc_cntr_limit, &
         delta_log_eps_nuc_cntr_hard_limit, &
         
         delta_log_eps_nuc_limit, &
         delta_log_eps_nuc_hard_limit, &

         delta_lg_XH_cntr_min, &
         delta_lg_XH_cntr_max, &
         delta_lg_XH_cntr_limit, &
         delta_lg_XH_cntr_hard_limit, &

         delta_lg_XHe_cntr_min, &
         delta_lg_XHe_cntr_max, &
         delta_lg_XHe_cntr_limit, &
         delta_lg_XHe_cntr_hard_limit, &

         delta_lg_XC_cntr_min, &
         delta_lg_XC_cntr_max, &
         delta_lg_XC_cntr_limit, &
         delta_lg_XC_cntr_hard_limit, &
         
         delta_lg_XNe_cntr_limit, &
         delta_lg_XNe_cntr_hard_limit, &
         delta_lg_XNe_cntr_min, &
         delta_lg_XNe_cntr_max, &          
         
         delta_lg_XO_cntr_limit, &
         delta_lg_XO_cntr_hard_limit, &
         delta_lg_XO_cntr_min, & 
         delta_lg_XO_cntr_max, &          
         
         delta_lg_XSi_cntr_limit, &
         delta_lg_XSi_cntr_hard_limit, &
         delta_lg_XSi_cntr_min, & 
         delta_lg_XSi_cntr_max, &          

         delta_lgTeff_limit, & 
         delta_lgTeff_hard_limit, & 
         
         v_div_v_crit_limit, &
         v_div_v_crit_hard_limit, &
               
         delta_lgL_limit, & 
         delta_lgL_limit_L_min, &
         delta_lgL_hard_limit, &         
         
         delta_HR_ds_L, &
         delta_HR_ds_Teff, &  
         delta_HR_limit, &
         delta_HR_hard_limit, &

         delta_lg_star_mass_limit, &
         delta_lg_star_mass_hard_limit, & 
         
         delta_mdot_atol, &
         delta_mdot_rtol, &
         delta_mdot_limit, &
         delta_mdot_hard_limit, &
         
         delta_lg_total_J_limit, &
         delta_lg_total_J_hard_limit, &
         
         CpT_absMdot_div_L_limit, &
         CpT_absMdot_div_L_hard_limit, &
                   
         relax_hard_limits_after_backup, &   
         relax_hard_limits_after_retry, &
         report_all_dt_limits, &   
         report_why_dt_limits, &   
         report_hydro_dt_info, &
         report_dX_nuc_drop_dt_limits, &
         min_k_for_max_dE_residual, &

         limit_for_rel_error_in_energy_conservation, &
         hard_limit_for_rel_error_in_energy_conservation, &
         limit_for_rel_rate_in_energy_conservation, &
         hard_limit_for_rel_rate_in_energy_conservation, &
         limit_for_avg_E_residual, &
         hard_limit_for_avg_E_residual, &
         limit_for_max_E_residual, &
         hard_limit_for_max_E_residual, &
         
         trace_newton_bcyclic_solve_input, &
         trace_newton_bcyclic_solve_output, &
         trace_newton_bcyclic_matrix_input, &
         trace_newton_bcyclic_matrix_output, &
         trace_newton_bcyclic_steplo, &
         trace_newton_bcyclic_stephi, &
         trace_newton_bcyclic_iterlo, &
         trace_newton_bcyclic_iterhi, &
         trace_newton_bcyclic_nzlo, &
         trace_newton_bcyclic_nzhi, &
         trace_newton_bcyclic_jlo, &
         trace_newton_bcyclic_jhi, &
         write_varcontrol_internals, &
         
         
      ! atmosphere -- surface boundary conditions
         which_atm_option, &
         which_atm_off_table_option, &
         atm_switch_to_grey_as_backup, &
         Pextra_factor, &
         atm_fixed_Teff, &
         atm_fixed_Psurf, &
         atm_fixed_Tsurf, &
         
         atm_grey_and_kap_atol, &
         atm_grey_and_kap_rtol, &
         atm_grey_and_kap_max_tries, &
         trace_atm_grey_and_kap, &

         atm_grey_irradiated_atol, &
         atm_grey_irradiated_rtol, &
         atm_grey_irradiated_T_eq, &
         atm_grey_irradiated_kap_v, &
         atm_grey_irr_kap_v_div_kap_th, &
         atm_grey_irradiated_P_surf, &
         atm_grey_irradiated_max_tries, &
         atm_grey_irradiated_simple_kap_th, &
         trace_atm_grey_irradiated, &
         
         surface_extra_Pgas, &
         use_atm_PT_at_center_of_surface_cell, &
         use_hydrodynamic_surface_BCs, &
         use_momentum_eqn_outer_BC, &
         
         atm_int_errtol, &
         dump_int_atm_info_model_number, &
         
         create_atm_max_step_size, &
         Paczynski_atm_R_surf_errtol, &
         trace_atm_Paczynski_grey, &

      ! extra heat near surface to model irradiation         
         irradiation_flux, &
         column_depth_for_irradiation, &
         
      ! uniform extra heat
         inject_uniform_extra_heat, &
         min_q_for_uniform_extra_heat, &
         max_q_for_uniform_extra_heat, &
         inject_extra_ergs_sec, &
         base_of_inject_extra_ergs_sec, &
         total_mass_for_inject_extra_ergs_sec, &
         start_time_for_inject_extra_ergs_sec, &
         duration_for_inject_extra_ergs_sec, &
         inject_until_reach_delta_total_energy, &

      ! mass gain or loss
         no_wind_if_no_rotation, &
         clip_small_mdots, &
         max_logT_for_k_below_const_q, &
         max_q_for_k_below_const_q, &
         min_q_for_k_below_const_q, &
         max_logT_for_k_const_mass, &
         min_q_for_k_const_mass, &
         max_q_for_k_const_mass, &
         
      ! info for debugging
         stop_for_bugs, &
         report_ierr, &
         diffusion_dump_call_number, &
      
      ! controls for the evolve routine
         trace_evolve, &

         
      ! misc
         min_logT_for_quad, &
         zams_filename, &
         
         use_other_eos, &
         use_other_surface_PT, &
         use_other_kap, &
         use_other_atm, &
         use_other_diffusion, &
         use_other_mlt, &
         use_other_adjust_mdot, &
         use_other_am_mixing, &
         use_other_brunt, &
         use_other_brunt_smoothing, &
         use_other_newton_monitor, &
         use_other_build_initial_model, &
         use_other_cgrav, &
         use_other_energy_implicit, &
         use_other_momentum, &
         use_other_energy, &
         use_other_mesh_functions, &
         use_other_eps_grav, &
         use_other_D_mix, &
         use_other_split_mix, &
         use_other_neu, &
         use_other_opacity_factor, &
         use_other_paquette_coefficients, &
         use_other_pgstar_plots, &
         use_other_torque, &
         use_other_torque_implicit, &
         use_other_wind, &
         use_other_after_struct_burn_mix, &
         use_other_before_struct_burn_mix, &
         use_other_get_pulsation_info, &
         use_other_write_pulsation_info, &
         use_other_edit_pulsation_info, &
         use_other_edit_gyre_info, &
         use_other_get_gyre_model, &
         use_other_adjust_net, &
         use_other_astero_freq_corr, &
         
         x_ctrl, &
         x_integer_ctrl, &
         x_logical_ctrl, &
         x_character_ctrl, &
         
         trace_solar_neutrinos, &
         
      ! extra files
         read_extra_controls_inlist1, extra_controls_inlist1_name, &
         read_extra_controls_inlist2, extra_controls_inlist2_name, &
         read_extra_controls_inlist3, extra_controls_inlist3_name, &
         read_extra_controls_inlist4, extra_controls_inlist4_name, &
         read_extra_controls_inlist5, extra_controls_inlist5_name



      contains
      
      
      subroutine do_one_setup(id, inlist, ierr)
         use utils_lib
         character (len=*), intent(in) :: inlist
         integer, intent(in) :: id
         integer, intent(out) :: ierr
         type (star_info), pointer :: s
         include 'formats'
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call set_default_controls
         call read_controls(id, inlist, ierr)
         if (ierr /= 0) return
         if (len_trim(s% extra_terminal_output_file) == 0) return
         s% extra_terminal_iounit = alloc_iounit(ierr)
         if (ierr /= 0) then
            write(*,*) 'failed to allocate io unit for ' // trim(s% extra_terminal_output_file)
            return
         end if
         open(unit=s% extra_terminal_iounit, file=trim(s% extra_terminal_output_file), &
               action='write', status='replace',iostat=ierr)
         if (ierr /= 0) then
            write(*,*) 'failed to open ' // trim(s% extra_terminal_output_file)
            call free_iounit(s% extra_terminal_iounit)
            return
         end if
      end subroutine do_one_setup


      subroutine read_controls(id, filename, ierr)
         use star_private_def
         use utils_lib
         character(*), intent(in) :: filename
         integer, intent(in) :: id
         integer, intent(out) :: ierr

         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         
         call read_controls_file(s, filename, 1, ierr)
         
      end subroutine read_controls
         
         
      recursive subroutine read_controls_file(s, filename, level, ierr)
         use star_private_def
         use utils_lib
         character(*), intent(in) :: filename
         type (star_info), pointer :: s
         integer, intent(in) :: level  
         integer, intent(out) :: ierr
         logical :: read_extra1, read_extra2, read_extra3, read_extra4, read_extra5
         character (len=strlen) :: message, extra1, extra2, extra3, extra4, extra5
         integer :: unit 
         
         ierr = 0        
         
         if (level >= 10) then
            write(*,*) 'ERROR: too many levels of nested extra controls inlist files'
            ierr = -1
            return
         end if

         if (len_trim(filename) > 0) then
            unit=alloc_iounit(ierr); if (ierr /= 0) return
            open(unit=unit, file=trim(filename), action='read', delim='quote', status='old', iostat=ierr)
            if (ierr /= 0) then
               write(*, *) 'Failed to open control namelist file ', trim(filename)
               return
            end if
            read(unit, nml=controls, iostat=ierr)  
            close(unit)
            if (ierr /= 0) then
               write(*, *) 
               write(*, *) 
               write(*, *) 
               write(*, *) 
               write(*, '(a)') &
                  'Failed while trying to read control namelist file: ' // trim(filename)
               write(*, '(a)') &
                  'Perhaps the following runtime error message will help you find the problem.'
               write(*, *) 
               open(unit=unit, file=trim(filename), action='read', delim='quote', status='old', iostat=ierr)
               read(unit, nml=controls)
               close(unit)
               call free_iounit(unit)
               return
            end if
            call free_iounit(unit)
         end if
         
         call store_controls(s, ierr)
         
         ! recursive calls to read other inlists
         
         read_extra1 = read_extra_controls_inlist1
         read_extra_controls_inlist1 = .false.
         extra1 = extra_controls_inlist1_name
         extra_controls_inlist1_name = 'undefined'
         
         read_extra2 = read_extra_controls_inlist2
         read_extra_controls_inlist2 = .false.
         extra2 = extra_controls_inlist2_name
         extra_controls_inlist2_name = 'undefined'
         
         read_extra3 = read_extra_controls_inlist3
         read_extra_controls_inlist3 = .false.
         extra3 = extra_controls_inlist3_name
         extra_controls_inlist3_name = 'undefined'
         
         read_extra4 = read_extra_controls_inlist4
         read_extra_controls_inlist4 = .false.
         extra4 = extra_controls_inlist4_name
         extra_controls_inlist4_name = 'undefined'
         
         read_extra5 = read_extra_controls_inlist5
         read_extra_controls_inlist5 = .false.
         extra5 = extra_controls_inlist5_name
         extra_controls_inlist5_name = 'undefined'
         
         if (read_extra1) then
            write(*,*) 'read ' // trim(extra1)
            call read_controls_file(s, extra1, level+1, ierr)
            if (ierr /= 0) return
         end if
         
         if (read_extra2) then
            write(*,*) 'read ' // trim(extra2)
            call read_controls_file(s, extra2, level+1, ierr)
            if (ierr /= 0) return
         end if
         
         if (read_extra3) then
            write(*,*) 'read ' // trim(extra3)
            call read_controls_file(s, extra3, level+1, ierr)
            if (ierr /= 0) return
         end if
         
         if (read_extra4) then
            write(*,*) 'read ' // trim(extra4)
            call read_controls_file(s, extra4, level+1, ierr)
            if (ierr /= 0) return
         end if
         
         if (read_extra5) then
            write(*,*) 'read ' // trim(extra5)
            call read_controls_file(s, extra5, level+1, ierr)
            if (ierr /= 0) return
         end if
         
      end subroutine read_controls_file


      subroutine set_default_controls
         include 'controls.defaults'
         include 'private_defaults.inc'
      end subroutine set_default_controls


      subroutine store_controls(s, ierr)
         use star_private_def
         use chem_def ! categories
         use utils_lib, only: mkdir
         type (star_info), pointer :: s
         integer, intent(out) :: ierr
         
         ierr = 0
         
         ! where to start
         s% initial_mass = initial_mass
         s% initial_z = initial_z
         s% initial_y = initial_y

         ! definition of core boundaries
         s% he_core_boundary_h1_fraction = he_core_boundary_h1_fraction 
         s% c_core_boundary_he4_fraction = c_core_boundary_he4_fraction
         s% o_core_boundary_c12_fraction = o_core_boundary_c12_fraction
         s% si_core_boundary_o16_fraction = si_core_boundary_o16_fraction
         s% fe_core_boundary_si28_fraction = fe_core_boundary_si28_fraction
         s% neutron_rich_core_boundary_Ye_max = neutron_rich_core_boundary_Ye_max
         s% min_boundary_fraction = min_boundary_fraction

         ! when to stop
         s% max_model_number = max_model_number
         s% max_backups_in_a_row = max_backups_in_a_row
         s% max_number_backups = max_number_backups
         s% max_number_retries = max_number_retries
         s% relax_max_number_retries = relax_max_number_retries
         s% relax_max_number_backups = relax_max_number_backups
         s% max_age = max_age
         s% max_age_in_seconds = max_age_in_seconds
         s% num_adjusted_dt_steps_before_max_age = num_adjusted_dt_steps_before_max_age
         s% dt_years_for_steps_before_max_age = dt_years_for_steps_before_max_age
         s% reduction_factor_for_max_timestep = reduction_factor_for_max_timestep
         s% when_to_stop_rtol = when_to_stop_rtol
         s% when_to_stop_atol = when_to_stop_atol
         s% gamma_center_limit = gamma_center_limit
         s% eta_center_limit = eta_center_limit
         s% log_center_temp_limit = log_center_temp_limit
         s% log_max_temp_upper_limit = log_max_temp_upper_limit
         s% log_max_temp_lower_limit = log_max_temp_lower_limit
         s% log_center_temp_lower_limit = log_center_temp_lower_limit
         s% log_center_density_limit = log_center_density_limit
         s% log_center_density_lower_limit = log_center_density_lower_limit
         s% min_timestep_limit = min_timestep_limit

         s% center_entropy_limit = center_entropy_limit
         s% center_entropy_lower_limit = center_entropy_lower_limit
         s% max_entropy_limit = max_entropy_limit
         s% max_entropy_lower_limit = max_entropy_lower_limit

         s% logQ_limit = logQ_limit
         s% fe_core_infall_limit = fe_core_infall_limit
         s% center_Ye_lower_limit = center_Ye_lower_limit
         s% non_fe_core_infall_limit = non_fe_core_infall_limit
         s% v_div_csound_surf_limit = v_div_csound_surf_limit
         s% Lnuc_div_L_upper_limit = Lnuc_div_L_upper_limit
         s% Lnuc_div_L_lower_limit = Lnuc_div_L_lower_limit
         s% v_surf_div_v_kh_upper_limit = v_surf_div_v_kh_upper_limit
         s% v_surf_div_v_kh_lower_limit = v_surf_div_v_kh_lower_limit
         s% v_surf_div_v_esc_limit = v_surf_div_v_esc_limit
         s% stop_near_zams = stop_near_zams
         s% Lnuc_div_L_zams_limit = Lnuc_div_L_zams_limit
         s% Pgas_div_P_limit = Pgas_div_P_limit
         s% Pgas_div_P_limit_max_q = Pgas_div_P_limit_max_q
         s% peak_burn_vconv_div_cs_limit = peak_burn_vconv_div_cs_limit
         s% omega_div_omega_crit_limit = omega_div_omega_crit_limit
         s% delta_nu_lower_limit = delta_nu_lower_limit
         s% delta_nu_upper_limit = delta_nu_upper_limit
         s% delta_Pg_lower_limit = delta_Pg_lower_limit
         s% delta_Pg_upper_limit = delta_Pg_upper_limit
         
         s% stop_when_done_with_piston = stop_when_done_with_piston
         s% stop_when_piston_v_goes_negative = stop_when_piston_v_goes_negative
         s% stop_when_done_with_center_flash = stop_when_done_with_center_flash

         s% surface_accel_div_grav_limit = surface_accel_div_grav_limit
         
         s% xa_central_lower_limit_species = xa_central_lower_limit_species
         s% xa_central_lower_limit = xa_central_lower_limit
         
         s% xa_central_upper_limit_species = xa_central_upper_limit_species
         s% xa_central_upper_limit = xa_central_upper_limit
         
         s% xa_surface_lower_limit_species = xa_surface_lower_limit_species
         s% xa_surface_lower_limit = xa_surface_lower_limit
         
         s% xa_surface_upper_limit_species = xa_surface_upper_limit_species
         s% xa_surface_upper_limit = xa_surface_upper_limit
         
         s% xa_average_lower_limit_species = xa_average_lower_limit_species
         s% xa_average_lower_limit = xa_average_lower_limit
         
         s% xa_average_upper_limit_species = xa_average_upper_limit_species
         s% xa_average_upper_limit = xa_average_upper_limit
         
         s% HB_limit = HB_limit
         s% stop_at_TP = stop_at_TP
         s% TP_he_shell_max = TP_he_shell_max
         
         s% star_mass_max_limit = star_mass_max_limit
         s% star_mass_min_limit = star_mass_min_limit
         s% star_H_mass_max_limit = star_H_mass_max_limit
         s% star_H_mass_min_limit = star_H_mass_min_limit
         s% star_He_mass_max_limit = star_He_mass_max_limit
         s% star_He_mass_min_limit = star_He_mass_min_limit
         s% star_C_mass_min_limit = star_C_mass_min_limit
         s% star_C_mass_max_limit = star_C_mass_max_limit
         s% xmstar_min_limit = xmstar_min_limit
         s% xmstar_max_limit = xmstar_max_limit
         s% envelope_mass_limit = envelope_mass_limit
         s% envelope_fraction_left_limit = envelope_fraction_left_limit
         
         s% he_core_mass_limit = he_core_mass_limit
         s% c_core_mass_limit = c_core_mass_limit
         s% o_core_mass_limit = o_core_mass_limit
         s% si_core_mass_limit = si_core_mass_limit
         s% fe_core_mass_limit = fe_core_mass_limit
         s% neutron_rich_core_mass_limit = neutron_rich_core_mass_limit
         
         s% he_layer_mass_lower_limit = he_layer_mass_lower_limit
         s% abs_diff_lg_LH_lg_Ls_limit = abs_diff_lg_LH_lg_Ls_limit
         s% Teff_upper_limit = Teff_upper_limit
         s% Teff_lower_limit = Teff_lower_limit
         s% photosphere_r_upper_limit = photosphere_r_upper_limit
         s% photosphere_r_lower_limit = photosphere_r_lower_limit
         s% log_Teff_upper_limit = log_Teff_upper_limit
         s% log_Teff_lower_limit = log_Teff_lower_limit
         s% log_Tsurf_upper_limit = log_Tsurf_upper_limit
         s% log_Tsurf_lower_limit = log_Tsurf_lower_limit
         s% log_Psurf_upper_limit = log_Psurf_upper_limit
         s% log_Psurf_lower_limit = log_Psurf_lower_limit
         s% log_Dsurf_upper_limit = log_Dsurf_upper_limit
         s% log_Dsurf_lower_limit = log_Dsurf_lower_limit
         s% log_L_upper_limit = log_L_upper_limit
         s% log_L_lower_limit = log_L_lower_limit
         s% log_g_upper_limit = log_g_upper_limit
         s% log_g_lower_limit = log_g_lower_limit
         
         s% power_nuc_burn_upper_limit = power_nuc_burn_upper_limit
         s% power_h_burn_upper_limit = power_h_burn_upper_limit
         s% power_he_burn_upper_limit = power_he_burn_upper_limit 
         s% power_c_burn_upper_limit = power_c_burn_upper_limit 
         s% power_nuc_burn_lower_limit = power_nuc_burn_lower_limit
         s% power_h_burn_lower_limit = power_h_burn_lower_limit
         s% power_he_burn_lower_limit = power_he_burn_lower_limit 
         s% power_c_burn_lower_limit = power_c_burn_lower_limit 
         
         s% phase_of_evolution_stop = phase_of_evolution_stop
         
         ! output of "snapshots" for restarts
         s% photostep = photostep
         s% photo_digits = photo_digits
         s% photo_directory = photo_directory
         call mkdir(s% photo_directory)
         ! output of history and profiles.
         s% do_history_file = do_history_file
         s% history_interval = history_interval
         
         s% write_header_frequency = write_header_frequency
         s% terminal_interval = terminal_interval
         s% terminal_cnt = terminal_cnt
         s% terminal_show_age_in_years = terminal_show_age_in_years
         s% extra_terminal_output_file = extra_terminal_output_file
         s% num_trace_history_values = num_trace_history_values
         s% trace_history_value_name = trace_history_value_name
         
         s% log_directory = log_directory
         call mkdir(s% log_directory)
         s% star_history_name = star_history_name
         s% star_history_header_name = star_history_header_name
         s% star_history_dbl_format = star_history_dbl_format
         s% star_history_int_format = star_history_int_format
         s% star_history_txt_format = star_history_txt_format
         
         s% profiles_index_name = profiles_index_name
         s% profile_data_prefix = profile_data_prefix
         s% profile_data_suffix = profile_data_suffix
         s% profile_data_header_suffix = profile_data_header_suffix
         s% profile_int_format = profile_int_format
         s% profile_txt_format = profile_txt_format
         s% profile_dbl_format = profile_dbl_format
         s% write_profiles_flag = write_profiles_flag
         s% profile_interval = profile_interval
         s% priority_profile_interval = priority_profile_interval
         s% profile_model = profile_model
         s% max_num_profile_models = max_num_profile_models
         s% max_num_profile_zones = max_num_profile_zones
         s% mass_loc_for_extra_log_info = mass_loc_for_extra_log_info
         
         s% write_controls_info_with_profile = write_controls_info_with_profile
         s% controls_data_prefix = controls_data_prefix
         s% controls_data_suffix = controls_data_suffix
         
         s% write_pulse_info_with_profile = write_pulse_info_with_profile
         s% pulse_info_format = pulse_info_format
         s% add_atmosphere_to_pulse_info = add_atmosphere_to_pulse_info
         s% add_center_point_to_pulse_info = add_center_point_to_pulse_info
         s% keep_surface_point_for_pulse_info = keep_surface_point_for_pulse_info
         s% write_pulsation_plot_data = write_pulsation_plot_data
         s% max_num_gyre_points = max_num_gyre_points
         s% format_for_FGONG_data = format_for_FGONG_data
         s% format_for_OSC_data = format_for_OSC_data
         s% fgong_zero_A_inside_r = fgong_zero_A_inside_r
         
         s% write_model_with_profile = write_model_with_profile
         s% model_data_prefix = model_data_prefix
         s% model_data_suffix = model_data_suffix
         
         s% mixing_D_limit_for_log = mixing_D_limit_for_log
         s% trace_mass_location = trace_mass_location
         s% min_tau_for_max_abs_v_location = min_tau_for_max_abs_v_location
         s% min_q_for_inner_mach1_location = min_q_for_inner_mach1_location
         s% max_q_for_outer_mach1_location = max_q_for_outer_mach1_location
         
         
         ! burn zone eps definitions for use in logs and profiles
         s% burn_min1 = burn_min1
         s% burn_min2 = burn_min2
         
         s% max_conv_vel_div_csound_maxq = max_conv_vel_div_csound_maxq
         s% width_for_limit_conv_vel = width_for_limit_conv_vel
         s% max_q_for_limit_conv_vel = max_q_for_limit_conv_vel
         s% max_mass_in_gm_for_limit_conv_vel = max_mass_in_gm_for_limit_conv_vel
         s% max_r_in_cm_for_limit_conv_vel = max_r_in_cm_for_limit_conv_vel
         
         ! for reported average values
         s% surface_avg_abundance_dq = surface_avg_abundance_dq
         s% center_avg_value_dq = center_avg_value_dq
         
         ! mach1 location offsets
         s% mach1_plus_dr_factor = mach1_plus_dr_factor
         s% mach1_minus_dr_factor = mach1_minus_dr_factor
         
         ! definition of core overshooting boundary
         s% alpha_bdy_core_overshooting = alpha_bdy_core_overshooting
         
         ! mixing parameters
         s% min_convective_gap = min_convective_gap
         s% min_thermohaline_gap = min_thermohaline_gap
         s% min_semiconvection_gap = min_semiconvection_gap
         s% min_thermohaline_dropout = min_thermohaline_dropout
         s% max_dropout_gradL_sub_grada = max_dropout_gradL_sub_grada
         s% remove_embedded_semiconvection = remove_embedded_semiconvection
         s% remove_mixing_glitches = remove_mixing_glitches
         s% okay_to_remove_mixing_singleton = okay_to_remove_mixing_singleton
         s% prune_bad_cz_min_Hp_height = prune_bad_cz_min_Hp_height
         s% prune_bad_cz_min_log_eps_nuc = prune_bad_cz_min_log_eps_nuc
         s% redo_conv_for_dr_lt_mixing_length = redo_conv_for_dr_lt_mixing_length
         s% redo_mlt_for_OPEC = redo_mlt_for_OPEC
         s% limit_mixing_length_by_dist_to_bdy = limit_mixing_length_by_dist_to_bdy

         s% conv_bdy_mix_softening_f0 = conv_bdy_mix_softening_f0
         s% conv_bdy_mix_softening_f = conv_bdy_mix_softening_f
         s% conv_bdy_mix_softening_min_D_mix = conv_bdy_mix_softening_min_D_mix

         s% alpha_semiconvection = alpha_semiconvection
         s% semiconvection_upper_limit_center_h1 = semiconvection_upper_limit_center_h1
         s% semiconvection_option = semiconvection_option
         s% use_Ledoux_criterion = use_Ledoux_criterion
         s% redo_mix_info_at_each_iteration = redo_mix_info_at_each_iteration
         s% num_cells_for_smooth_gradL_composition_term = num_cells_for_smooth_gradL_composition_term
         s% clip_D_limit = clip_D_limit

         s% okay_to_reduce_gradT_excess = okay_to_reduce_gradT_excess
         s% gradT_excess_f1 = gradT_excess_f1
         s% gradT_excess_f2 = gradT_excess_f2
         s% gradT_excess_age_fraction = gradT_excess_age_fraction
         s% gradT_excess_max_change = gradT_excess_max_change
         s% gradT_excess_lambda1 = gradT_excess_lambda1
         s% gradT_excess_beta1 = gradT_excess_beta1
         s% gradT_excess_lambda2 = gradT_excess_lambda2
         s% gradT_excess_beta2 = gradT_excess_beta2
         s% gradT_excess_dlambda = gradT_excess_dlambda
         s% gradT_excess_dbeta = gradT_excess_dbeta
         s% gradT_excess_max_center_h1 = gradT_excess_max_center_h1
         s% gradT_excess_min_center_he4 = gradT_excess_min_center_he4
         s% gradT_excess_max_logT = gradT_excess_max_logT
         s% gradT_excess_min_log_tau_full_on = gradT_excess_min_log_tau_full_on
         s% gradT_excess_max_log_tau_full_off = gradT_excess_max_log_tau_full_off
         
         s% thermohaline_coeff = thermohaline_coeff
         s% thermohaline_option = thermohaline_option
         s% mixing_length_alpha = mixing_length_alpha
         s% remove_small_D_limit = remove_small_D_limit
         s% alt_scale_height_flag = alt_scale_height_flag
         s% Henyey_MLT_y_param = Henyey_MLT_y_param
         s% Henyey_MLT_nu_param = Henyey_MLT_nu_param
         s% MLT_option = MLT_option
         s% mlt_use_rotation_correction = mlt_use_rotation_correction

         s% overshoot_f_above_nonburn_core = overshoot_f_above_nonburn_core
         s% overshoot_f_above_nonburn_shell = overshoot_f_above_nonburn_shell
         s% overshoot_f_below_nonburn_shell = overshoot_f_below_nonburn_shell
         s% overshoot_f_above_burn_h_core = overshoot_f_above_burn_h_core
         s% overshoot_f_above_burn_h_shell = overshoot_f_above_burn_h_shell
         s% overshoot_f_below_burn_h_shell = overshoot_f_below_burn_h_shell
         s% overshoot_f_above_burn_he_core = overshoot_f_above_burn_he_core
         s% overshoot_f_above_burn_he_shell = overshoot_f_above_burn_he_shell
         s% overshoot_f_below_burn_he_shell = overshoot_f_below_burn_he_shell
         s% overshoot_f_above_burn_z_core = overshoot_f_above_burn_z_core
         s% overshoot_f_above_burn_z_shell = overshoot_f_above_burn_z_shell
         s% overshoot_f_below_burn_z_shell = overshoot_f_below_burn_z_shell

         s% step_overshoot_f_above_nonburn_core = step_overshoot_f_above_nonburn_core
         s% step_overshoot_f_above_nonburn_shell = step_overshoot_f_above_nonburn_shell
         s% step_overshoot_f_below_nonburn_shell = step_overshoot_f_below_nonburn_shell
         s% step_overshoot_f_above_burn_h_core = step_overshoot_f_above_burn_h_core
         s% step_overshoot_f_above_burn_h_shell = step_overshoot_f_above_burn_h_shell
         s% step_overshoot_f_below_burn_h_shell = step_overshoot_f_below_burn_h_shell
         s% step_overshoot_f_above_burn_he_core = step_overshoot_f_above_burn_he_core
         s% step_overshoot_f_above_burn_he_shell = step_overshoot_f_above_burn_he_shell
         s% step_overshoot_f_below_burn_he_shell = step_overshoot_f_below_burn_he_shell
         s% step_overshoot_f_above_burn_z_core = step_overshoot_f_above_burn_z_core
         s% step_overshoot_f_above_burn_z_shell = step_overshoot_f_above_burn_z_shell
         s% step_overshoot_f_below_burn_z_shell = step_overshoot_f_below_burn_z_shell

         s% overshoot_f0_above_nonburn_core = overshoot_f0_above_nonburn_core
         s% overshoot_f0_above_nonburn_shell = overshoot_f0_above_nonburn_shell
         s% overshoot_f0_below_nonburn_shell = overshoot_f0_below_nonburn_shell
         s% overshoot_f0_above_burn_h_core = overshoot_f0_above_burn_h_core
         s% overshoot_f0_above_burn_h_shell = overshoot_f0_above_burn_h_shell
         s% overshoot_f0_below_burn_h_shell = overshoot_f0_below_burn_h_shell
         s% overshoot_f0_above_burn_he_core = overshoot_f0_above_burn_he_core
         s% overshoot_f0_above_burn_he_shell = overshoot_f0_above_burn_he_shell
         s% overshoot_f0_below_burn_he_shell = overshoot_f0_below_burn_he_shell
         s% overshoot_f0_above_burn_z_core = overshoot_f0_above_burn_z_core
         s% overshoot_f0_above_burn_z_shell = overshoot_f0_above_burn_z_shell
         s% overshoot_f0_below_burn_z_shell = overshoot_f0_below_burn_z_shell
         
         s% step_overshoot_D = step_overshoot_D
         s% step_overshoot_D0_coeff = step_overshoot_D0_coeff
         
         s% overshoot_below_noburn_shell_factor = overshoot_below_noburn_shell_factor
         s% max_DUP_counter = max_DUP_counter
         
         s% ovr_below_burn_he_shell_factor = ovr_below_burn_he_shell_factor

         s% overshoot_D2_above_nonburn = overshoot_D2_above_nonburn
         s% overshoot_D2_below_nonburn = overshoot_D2_below_nonburn
         s% overshoot_D2_above_burn_h = overshoot_D2_above_burn_h
         s% overshoot_D2_below_burn_h = overshoot_D2_below_burn_h
         s% overshoot_D2_above_burn_he = overshoot_D2_above_burn_he
         s% overshoot_D2_below_burn_he = overshoot_D2_below_burn_he
         s% overshoot_D2_above_burn_z = overshoot_D2_above_burn_z
         s% overshoot_D2_below_burn_z = overshoot_D2_below_burn_z

         s% overshoot_f2_above_nonburn = overshoot_f2_above_nonburn
         s% overshoot_f2_below_nonburn = overshoot_f2_below_nonburn
         s% overshoot_f2_above_burn_h = overshoot_f2_above_burn_h
         s% overshoot_f2_below_burn_h = overshoot_f2_below_burn_h
         s% overshoot_f2_above_burn_he = overshoot_f2_above_burn_he
         s% overshoot_f2_below_burn_he = overshoot_f2_below_burn_he
         s% overshoot_f2_above_burn_z = overshoot_f2_above_burn_z
         s% overshoot_f2_below_burn_z = overshoot_f2_below_burn_z
         
         s% mass_for_overshoot_full_on = mass_for_overshoot_full_on
         s% mass_for_overshoot_full_off = mass_for_overshoot_full_off
         
         s% smooth_convective_bdy = smooth_convective_bdy
         s% max_dR_div_Hp_for_smooth = max_dR_div_Hp_for_smooth
         s% max_delta_limit_for_smooth = max_delta_limit_for_smooth
         s% min_T_for_acceleration_limited_conv_velocity = min_T_for_acceleration_limited_conv_velocity
         s% mlt_accel_g_theta = mlt_accel_g_theta
         s% max_conv_vel_div_csound = max_conv_vel_div_csound

         s% calculate_Brunt_N2 = calculate_Brunt_N2
         s% brunt_N2_coefficient = brunt_N2_coefficient
         s% num_cells_for_smooth_brunt_B = num_cells_for_smooth_brunt_B
         s% use_brunt_dlnRho_form = use_brunt_dlnRho_form
         s% use_brunt_gradmuX_form = use_brunt_gradmuX_form
         s% interpolate_rho_for_pulsation_info = interpolate_rho_for_pulsation_info
         s% min_magnitude_brunt_B = min_magnitude_brunt_B

         s% min_overshoot_q = min_overshoot_q
         s% D_mix_ov_limit = D_mix_ov_limit
         s% max_brunt_B_for_overshoot = max_brunt_B_for_overshoot
         s% overshoot_alpha = overshoot_alpha
         
         s% radiation_turbulence_coeff = radiation_turbulence_coeff
         s% turbulent_diffusion_D0 = turbulent_diffusion_D0
         s% turbulent_diffusion_rho_max = turbulent_diffusion_rho_max
         
         s% T_mix_limit = T_mix_limit
         s% conv_dP_term_factor = conv_dP_term_factor
         
         ! atmosphere -- surface boundary conditions
         s% which_atm_option = which_atm_option
         s% which_atm_off_table_option = which_atm_off_table_option
         s% atm_switch_to_grey_as_backup = atm_switch_to_grey_as_backup
         s% Pextra_factor = Pextra_factor
         s% atm_fixed_Teff = atm_fixed_Teff
         s% atm_fixed_Psurf = atm_fixed_Psurf
         s% atm_fixed_Tsurf = atm_fixed_Tsurf
         
         s% atm_grey_and_kap_atol = atm_grey_and_kap_atol
         s% atm_grey_and_kap_rtol = atm_grey_and_kap_rtol
         s% atm_grey_and_kap_max_tries = atm_grey_and_kap_max_tries
         s% trace_atm_grey_and_kap = trace_atm_grey_and_kap

         s% atm_grey_irradiated_atol = atm_grey_irradiated_atol
         s% atm_grey_irradiated_rtol = atm_grey_irradiated_rtol
         s% atm_grey_irradiated_T_eq = atm_grey_irradiated_T_eq
         s% atm_grey_irradiated_kap_v = atm_grey_irradiated_kap_v
         s% atm_grey_irradiated_simple_kap_th = atm_grey_irradiated_simple_kap_th
         s% atm_grey_irr_kap_v_div_kap_th = atm_grey_irr_kap_v_div_kap_th
         s% atm_grey_irradiated_P_surf = atm_grey_irradiated_P_surf
         s% atm_grey_irradiated_max_tries = atm_grey_irradiated_max_tries
         s% trace_atm_grey_irradiated = trace_atm_grey_irradiated
         
         s% atm_int_errtol = atm_int_errtol
         s% dump_int_atm_info_model_number = dump_int_atm_info_model_number
         
         s% surface_extra_Pgas = surface_extra_Pgas
         s% use_atm_PT_at_center_of_surface_cell = use_atm_PT_at_center_of_surface_cell
         s% use_hydrodynamic_surface_BCs = use_hydrodynamic_surface_BCs
         s% use_momentum_eqn_outer_BC = use_momentum_eqn_outer_BC
         
         s% create_atm_max_step_size = create_atm_max_step_size
         s% Paczynski_atm_R_surf_errtol = Paczynski_atm_R_surf_errtol
         s% trace_atm_Paczynski_grey = trace_atm_Paczynski_grey

         
         ! extra heat near surface to model irradiation         
         s% irradiation_flux = irradiation_flux
         s% column_depth_for_irradiation = column_depth_for_irradiation
         
         ! extra heat
         s% inject_uniform_extra_heat = inject_uniform_extra_heat
         s% min_q_for_uniform_extra_heat = min_q_for_uniform_extra_heat
         s% max_q_for_uniform_extra_heat = max_q_for_uniform_extra_heat
         s% inject_extra_ergs_sec = inject_extra_ergs_sec
         s% base_of_inject_extra_ergs_sec = base_of_inject_extra_ergs_sec
         s% total_mass_for_inject_extra_ergs_sec = total_mass_for_inject_extra_ergs_sec
         s% start_time_for_inject_extra_ergs_sec = start_time_for_inject_extra_ergs_sec
         s% duration_for_inject_extra_ergs_sec = duration_for_inject_extra_ergs_sec
         s% inject_until_reach_delta_total_energy = inject_until_reach_delta_total_energy
         
         ! mass gain or loss
         s% mass_change = mass_change
         s% mass_change_full_off_dt = mass_change_full_off_dt
         s% mass_change_full_on_dt = mass_change_full_on_dt
         s% trace_dt_control_mass_change = trace_dt_control_mass_change
         s% no_wind_if_no_rotation = no_wind_if_no_rotation
         
         s% min_abs_mdot_for_change_limits = min_abs_mdot_for_change_limits
         s% max_abs_mdot_factor = max_abs_mdot_factor
         s% min_abs_mdot_factor = min_abs_mdot_factor
         s% min_wind = min_wind
         s% max_wind = max_wind
         s% use_accreted_material_j = use_accreted_material_j
         s% accreted_material_j = accreted_material_j
         s% mdot_omega_power = mdot_omega_power
         s% max_rotational_mdot_boost = max_rotational_mdot_boost
         s% max_mdot_jump_for_rotation = max_mdot_jump_for_rotation
         s% lim_trace_rotational_mdot_boost = lim_trace_rotational_mdot_boost
         s% rotational_mdot_boost_fac = rotational_mdot_boost_fac
         s% rotational_mdot_kh_fac = rotational_mdot_kh_fac
         s% surf_avg_tau = surf_avg_tau
         s% surf_avg_tau_min = surf_avg_tau_min
         
         s% remove_H_wind_mdot = remove_H_wind_mdot
         s% remove_H_wind_H_mass_limit = remove_H_wind_H_mass_limit
         s% super_eddington_wind_eta = super_eddington_wind_eta
         s% super_eddington_wind_Ledd_factor = super_eddington_wind_Ledd_factor
         s% wind_boost_full_off_L_div_Ledd = wind_boost_full_off_L_div_Ledd
         s% wind_boost_full_on_L_div_Ledd = wind_boost_full_on_L_div_Ledd
         s% super_eddington_wind_max_boost = super_eddington_wind_max_boost
         s% trace_super_eddington_wind_boost = trace_super_eddington_wind_boost
         
         s% flash_wind_mdot = flash_wind_mdot
         s% flash_wind_starts = flash_wind_starts
         s% flash_wind_declines = flash_wind_declines
         s% flash_wind_full_off = flash_wind_full_off

         s% rlo_wind_eta = rlo_wind_eta
         s% rlo_wind_min_L = rlo_wind_min_L
         s% rlo_wind_max_Teff = rlo_wind_max_Teff
         s% rlo_wind_roche_lobe_radius = rlo_wind_roche_lobe_radius
         s% roche_lobe_xfer_full_on = roche_lobe_xfer_full_on
         s% roche_lobe_xfer_full_off = roche_lobe_xfer_full_off
         s% rlo_wind_base_mdot = rlo_wind_base_mdot
         s% rlo_wind_scale_height = rlo_wind_scale_height
         
         s% nova_wind_eta = nova_wind_eta
         s% nova_wind_b = nova_wind_b
         s% nova_wind_max_Teff = nova_wind_max_Teff
         s% nova_wind_min_L = nova_wind_min_L
         s% nova_min_Teff_for_accretion = nova_min_Teff_for_accretion
         s% nova_roche_lobe_radius = nova_roche_lobe_radius
         s% nova_RLO_mdot = nova_RLO_mdot
         
         s% RGB_wind_scheme = RGB_wind_scheme
         s% AGB_wind_scheme = AGB_wind_scheme
         s% RGB_to_AGB_wind_switch = RGB_to_AGB_wind_switch
         s% Reimers_wind_eta = Reimers_wind_eta
         s% Blocker_wind_eta = Blocker_wind_eta
         s% de_Jager_wind_eta = de_Jager_wind_eta
         s% van_Loon_wind_eta = van_Loon_wind_eta
         s% Nieuwenhuijzen_wind_eta = Nieuwenhuijzen_wind_eta
         s% Vink_wind_eta = Vink_wind_eta
         s% Grafener_wind_eta = Grafener_wind_eta
         s% Kudritzki_wind_eta = Kudritzki_wind_eta
         s% Dutch_wind_eta = Dutch_wind_eta
         s% Dutch_wind_lowT_scheme = Dutch_wind_lowT_scheme
         s% Stern51_wind_eta = Stern51_wind_eta
         
         s% wind_envelope_limit = wind_envelope_limit
         s% clip_small_mdots = clip_small_mdots
         s% max_logT_for_k_below_const_q = max_logT_for_k_below_const_q
         s% max_q_for_k_below_const_q = max_q_for_k_below_const_q
         s% min_q_for_k_below_const_q = min_q_for_k_below_const_q
         s% max_logT_for_k_const_mass = max_logT_for_k_const_mass
         s% min_q_for_k_const_mass = min_q_for_k_const_mass
         s% max_q_for_k_const_mass = max_q_for_k_const_mass
         
         ! composition of added mass
         s% accrete_same_as_surface = accrete_same_as_surface
         
         s% accrete_given_mass_fractions = accrete_given_mass_fractions
         s% num_accretion_species = num_accretion_species
         s% accretion_species_id = accretion_species_id
         s% accretion_species_xa = accretion_species_xa
         
         s% accretion_h1 = accretion_h1
         s% accretion_h2 = accretion_h2
         s% accretion_he3 = accretion_he3
         s% accretion_he4 = accretion_he4
         s% accretion_zfracs = accretion_zfracs
         s% accretion_dump_missing_metals_into_heaviest = accretion_dump_missing_metals_into_heaviest
         
         ! special list of z fractions
         s% z_fraction_li = z_fraction_li
         s% z_fraction_be = z_fraction_be
         s% z_fraction_b  = z_fraction_b
         s% z_fraction_c  = z_fraction_c
         s% z_fraction_n  = z_fraction_n
         s% z_fraction_o  = z_fraction_o
         s% z_fraction_f  = z_fraction_f
         s% z_fraction_ne = z_fraction_ne
         s% z_fraction_na = z_fraction_na
         s% z_fraction_mg = z_fraction_mg
         s% z_fraction_al = z_fraction_al
         s% z_fraction_si = z_fraction_si
         s% z_fraction_p  = z_fraction_p
         s% z_fraction_s  = z_fraction_s
         s% z_fraction_cl = z_fraction_cl
         s% z_fraction_ar = z_fraction_ar
         s% z_fraction_k  = z_fraction_k
         s% z_fraction_ca = z_fraction_ca
         s% z_fraction_sc = z_fraction_sc
         s% z_fraction_ti = z_fraction_ti
         s% z_fraction_v  = z_fraction_v
         s% z_fraction_cr = z_fraction_cr
         s% z_fraction_mn = z_fraction_mn
         s% z_fraction_fe = z_fraction_fe
         s% z_fraction_co = z_fraction_co
         s% z_fraction_ni = z_fraction_ni
         s% z_fraction_cu = z_fraction_cu
         s% z_fraction_zn = z_fraction_zn
         
         s% pure_fe56_limit = pure_fe56_limit
         s% lgT_lo_for_set_new_abundances = lgT_lo_for_set_new_abundances
         s% lgT_hi_for_set_new_abundances = lgT_hi_for_set_new_abundances
   
         ! automatic stops for mass loss/gain
         s% max_star_mass_for_gain = max_star_mass_for_gain
         s% min_star_mass_for_loss = min_star_mass_for_loss
         s% max_T_center_for_any_mass_loss = max_T_center_for_any_mass_loss
         s% max_T_center_for_full_mass_loss = max_T_center_for_full_mass_loss
         
         ! extra power source
         s% extra_power_source = extra_power_source
         
         ! relaxation parameters
         s% relax_dlnZ = relax_dlnZ
         s% relax_dY = relax_dY
         
         ! mesh adjustment
         s% remesh_log_L_nuc_burn_min = remesh_log_L_nuc_burn_min
         s% show_mesh_changes = show_mesh_changes
         s% okay_to_remesh = okay_to_remesh
         s% trace_mesh_adjust_error_in_conservation = &
            trace_mesh_adjust_error_in_conservation
         s% remesh_max_brunt_N2_composition_term = remesh_max_brunt_N2_composition_term
         s% remesh_cnt = remesh_cnt
         s% max_allowed_nz = max_allowed_nz
         s% mesh_max_allowed_ratio = mesh_max_allowed_ratio
         s% remesh_max_allowed_logT = remesh_max_allowed_logT
         s% max_delta_x_for_merge = max_delta_x_for_merge
         s% mesh_dump_call_number = mesh_dump_call_number
         
         s% mesh_adjust_use_quadratic = mesh_adjust_use_quadratic
         s% mesh_adjust_get_T_from_E = mesh_adjust_get_T_from_E

         s% max_dq = max_dq
         s% min_dq = min_dq
         s% min_dq_for_xa = min_dq_for_xa
         s% mesh_min_dlnR = mesh_min_dlnR
         s% merge_if_dlnR_too_small = merge_if_dlnR_too_small
         s% mesh_min_dr_div_cs = mesh_min_dr_div_cs
         s% merge_if_dr_div_cs_too_small = merge_if_dr_div_cs_too_small

         s% max_center_cell_dq = max_center_cell_dq
         s% max_surface_cell_dq = max_surface_cell_dq
         s% max_num_subcells = max_num_subcells
         s% max_num_merge_cells = max_num_merge_cells

         s% mesh_delta_coeff = mesh_delta_coeff
         s% mesh_delta_coeff_pre_ms = mesh_delta_coeff_pre_ms
         s% mesh_delta_coeff_for_highT = mesh_delta_coeff_for_highT
         s% logT_max_for_standard_mesh_delta_coeff = logT_max_for_standard_mesh_delta_coeff
         s% logT_min_for_highT_mesh_delta_coeff = logT_min_for_highT_mesh_delta_coeff
         
         s% mesh_Pgas_div_P_exponent = mesh_Pgas_div_P_exponent
         
         s% remesh_dt_limit = remesh_dt_limit

   		s% P_function_weight = P_function_weight
         
         s% xtra_coef_above_xtrans = xtra_coef_above_xtrans
         s% xtra_coef_below_xtrans = xtra_coef_below_xtrans
         s% xtra_dist_above_xtrans = xtra_dist_above_xtrans
         
         s% xtra_coef_czb_full_on = xtra_coef_czb_full_on
         s% xtra_coef_czb_full_off = xtra_coef_czb_full_off         
   		   		
         s% xtra_coef_a_l_nb_czb = xtra_coef_a_l_nb_czb
         s% xtra_coef_a_l_hb_czb = xtra_coef_a_l_hb_czb
         s% xtra_coef_a_l_heb_czb = xtra_coef_a_l_heb_czb
         s% xtra_coef_a_l_zb_czb = xtra_coef_a_l_zb_czb

         s% xtra_coef_b_l_nb_czb = xtra_coef_b_l_nb_czb
         s% xtra_coef_b_l_hb_czb = xtra_coef_b_l_hb_czb
         s% xtra_coef_b_l_heb_czb = xtra_coef_b_l_heb_czb
         s% xtra_coef_b_l_zb_czb = xtra_coef_b_l_zb_czb

         s% xtra_coef_a_u_nb_czb = xtra_coef_a_u_nb_czb
         s% xtra_coef_a_u_hb_czb = xtra_coef_a_u_hb_czb
         s% xtra_coef_a_u_heb_czb = xtra_coef_a_u_heb_czb
         s% xtra_coef_a_u_zb_czb = xtra_coef_a_u_zb_czb

         s% xtra_coef_b_u_nb_czb = xtra_coef_b_u_nb_czb
         s% xtra_coef_b_u_hb_czb = xtra_coef_b_u_hb_czb
         s% xtra_coef_b_u_heb_czb = xtra_coef_b_u_heb_czb
         s% xtra_coef_b_u_zb_czb = xtra_coef_b_u_zb_czb

         s% xtra_dist_a_l_nb_czb = xtra_dist_a_l_nb_czb
         s% xtra_dist_a_l_hb_czb = xtra_dist_a_l_hb_czb
         s% xtra_dist_a_l_heb_czb = xtra_dist_a_l_heb_czb
         s% xtra_dist_a_l_zb_czb = xtra_dist_a_l_zb_czb

         s% xtra_dist_b_l_nb_czb = xtra_dist_b_l_nb_czb
         s% xtra_dist_b_l_hb_czb = xtra_dist_b_l_hb_czb
         s% xtra_dist_b_l_heb_czb = xtra_dist_b_l_heb_czb
         s% xtra_dist_b_l_zb_czb = xtra_dist_b_l_zb_czb

         s% xtra_dist_a_u_nb_czb = xtra_dist_a_u_nb_czb
         s% xtra_dist_a_u_hb_czb = xtra_dist_a_u_hb_czb
         s% xtra_dist_a_u_heb_czb = xtra_dist_a_u_heb_czb
         s% xtra_dist_a_u_zb_czb = xtra_dist_a_u_zb_czb

         s% xtra_dist_b_u_nb_czb = xtra_dist_b_u_nb_czb
         s% xtra_dist_b_u_hb_czb = xtra_dist_b_u_hb_czb
         s% xtra_dist_b_u_heb_czb = xtra_dist_b_u_heb_czb
         s% xtra_dist_b_u_zb_czb = xtra_dist_b_u_zb_czb
         
         s% xtra_coef_scz_above_nb_cz = xtra_coef_scz_above_nb_cz
         s% xtra_coef_scz_above_hb_cz = xtra_coef_scz_above_hb_cz
         s% xtra_coef_scz_above_heb_cz = xtra_coef_scz_above_heb_cz
         s% xtra_coef_scz_above_zb_cz = xtra_coef_scz_above_zb_cz
         
         s% xtra_coef_os_full_on = xtra_coef_os_full_on
         s% xtra_coef_os_full_off = xtra_coef_os_full_off

         s% xtra_coef_os_above_nonburn = xtra_coef_os_above_nonburn
         s% xtra_coef_os_below_nonburn = xtra_coef_os_below_nonburn
         s% xtra_coef_os_above_burn_h = xtra_coef_os_above_burn_h
         s% xtra_coef_os_below_burn_h = xtra_coef_os_below_burn_h
         s% xtra_coef_os_above_burn_he = xtra_coef_os_above_burn_he
         s% xtra_coef_os_below_burn_he = xtra_coef_os_below_burn_he
         s% xtra_coef_os_above_burn_z = xtra_coef_os_above_burn_z
         s% xtra_coef_os_below_burn_z = xtra_coef_os_below_burn_z
         
         s% xtra_dist_os_above_nonburn = xtra_dist_os_above_nonburn
         s% xtra_dist_os_below_nonburn = xtra_dist_os_below_nonburn
         s% xtra_dist_os_above_burn_h = xtra_dist_os_above_burn_h
         s% xtra_dist_os_below_burn_h = xtra_dist_os_below_burn_h
         s% xtra_dist_os_above_burn_he = xtra_dist_os_above_burn_he
         s% xtra_dist_os_below_burn_he = xtra_dist_os_below_burn_he
         s% xtra_dist_os_above_burn_z = xtra_dist_os_above_burn_z
         s% xtra_dist_os_below_burn_z = xtra_dist_os_below_burn_z


         s% mesh_logX_species = mesh_logX_species
         s% mesh_logX_min_for_extra = mesh_logX_min_for_extra
         s% mesh_dlogX_dlogP_extra = mesh_dlogX_dlogP_extra
         s% mesh_dlogX_dlogP_full_on = mesh_dlogX_dlogP_full_on
         s% mesh_dlogX_dlogP_full_off = mesh_dlogX_dlogP_full_off

         s% convective_bdy_min_dt_yrs = convective_bdy_min_dt_yrs
         s% convective_bdy_weight = convective_bdy_weight
         s% convective_bdy_dq_limit = convective_bdy_dq_limit
         
         s% mesh_dlog_eps_min_for_extra = mesh_dlog_eps_min_for_extra
         s% mesh_dlog_eps_dlogP_full_on = mesh_dlog_eps_dlogP_full_on
         s% mesh_dlog_eps_dlogP_full_off = mesh_dlog_eps_dlogP_full_off

         s% mesh_dlog_pp_dlogP_extra = mesh_dlog_pp_dlogP_extra
         s% mesh_dlog_cno_dlogP_extra = mesh_dlog_cno_dlogP_extra
         s% mesh_dlog_3alf_dlogP_extra = mesh_dlog_3alf_dlogP_extra
      
         s% mesh_dlog_burn_c_dlogP_extra = mesh_dlog_burn_c_dlogP_extra
         s% mesh_dlog_burn_n_dlogP_extra = mesh_dlog_burn_n_dlogP_extra
         s% mesh_dlog_burn_o_dlogP_extra = mesh_dlog_burn_o_dlogP_extra
         s% mesh_dlog_burn_ne_dlogP_extra = mesh_dlog_burn_ne_dlogP_extra
         s% mesh_dlog_burn_na_dlogP_extra = mesh_dlog_burn_na_dlogP_extra
         s% mesh_dlog_burn_mg_dlogP_extra = mesh_dlog_burn_mg_dlogP_extra
         s% mesh_dlog_burn_si_dlogP_extra = mesh_dlog_burn_si_dlogP_extra
         s% mesh_dlog_burn_s_dlogP_extra = mesh_dlog_burn_s_dlogP_extra
         s% mesh_dlog_burn_ar_dlogP_extra = mesh_dlog_burn_ar_dlogP_extra
         s% mesh_dlog_burn_ca_dlogP_extra = mesh_dlog_burn_ca_dlogP_extra
         s% mesh_dlog_burn_ti_dlogP_extra = mesh_dlog_burn_ti_dlogP_extra
         s% mesh_dlog_burn_cr_dlogP_extra = mesh_dlog_burn_cr_dlogP_extra
         s% mesh_dlog_burn_fe_dlogP_extra = mesh_dlog_burn_fe_dlogP_extra
      
         s% mesh_dlog_cc_dlogP_extra = mesh_dlog_cc_dlogP_extra
         s% mesh_dlog_co_dlogP_extra = mesh_dlog_co_dlogP_extra
         s% mesh_dlog_oo_dlogP_extra = mesh_dlog_oo_dlogP_extra
      
         s% mesh_dlog_pnhe4_dlogP_extra = mesh_dlog_pnhe4_dlogP_extra
         s% mesh_dlog_photo_dlogP_extra = mesh_dlog_photo_dlogP_extra
         s% mesh_dlog_other_dlogP_extra = mesh_dlog_other_dlogP_extra

   		s% T_function1_weight = T_function1_weight
   		s% T_function2_weight = T_function2_weight
   		s% T_function2_param = T_function2_param
      
   		s% R_function_weight = R_function_weight
   		s% R_function_param = R_function_param
      
   		s% R_function2_weight = R_function2_weight
   		s% R_function2_param1 = R_function2_param1
   		s% R_function2_param2 = R_function2_param2
      
   		s% M_function_weight = M_function_weight
   		s% M_function_param = M_function_param
   		
   		s% gradT_function_weight = gradT_function_weight
   		s% log_tau_function_weight = log_tau_function_weight
   		s% log_kap_function_weight = log_kap_function_weight
   		s% omega_function_weight = omega_function_weight

   		s% gam_function_weight = gam_function_weight
   		s% gam_function_param1 = gam_function_param1
   		s% gam_function_param2 = gam_function_param2
         
   		s% xa_function_species = xa_function_species
   		s% xa_function_weight = xa_function_weight
   		s% xa_function_param = xa_function_param
   		s% xa_mesh_delta_coeff = xa_mesh_delta_coeff


         ! nuclear reaction parameters
         s% screening_mode = screening_mode
         s% default_net_name = default_net_name
         
         s% net_logTcut_lo = net_logTcut_lo
         s% net_logTcut_lim = net_logTcut_lim

         s% eps_nuc_factor = eps_nuc_factor
         s% max_abs_eps_nuc = max_abs_eps_nuc
         s% dxdt_nuc_factor = dxdt_nuc_factor
         s% max_abar_for_burning = max_abar_for_burning
         s% fe56ec_fake_factor = fe56ec_fake_factor
         s% weak_rate_factor = weak_rate_factor

         ! mixing
         s% mix_factor = mix_factor
         
         s% sig_term_limit = sig_term_limit

         s% sig_min_factor_for_high_Tcenter = sig_min_factor_for_high_Tcenter
         s% Tcenter_min_for_sig_min_factor_full_on = Tcenter_min_for_sig_min_factor_full_on
         s% Tcenter_max_for_sig_min_factor_full_off = Tcenter_max_for_sig_min_factor_full_off
         s% max_delta_m_to_bdy_for_sig_min_factor = max_delta_m_to_bdy_for_sig_min_factor
         s% delta_m_lower_for_sig_min_factor = delta_m_lower_for_sig_min_factor
         s% delta_m_upper_for_sig_min_factor = delta_m_upper_for_sig_min_factor
         s% Tcenter_max_for_dble_bcyclic = Tcenter_max_for_dble_bcyclic
         
         s% am_sig_term_limit = am_sig_term_limit
         s% am_D_mix_factor = am_D_mix_factor
         s% am_gradmu_factor = am_gradmu_factor
         s% am_nu_factor = am_nu_factor

         s% D_visc_factor = D_visc_factor
         s% D_DSI_factor = D_DSI_factor
         s% D_SH_factor = D_SH_factor
         s% D_SSI_factor = D_SSI_factor
         s% D_ES_factor = D_ES_factor
         s% D_GSF_factor = D_GSF_factor
         s% D_ST_factor = D_ST_factor

         s% am_nu_non_rotation_factor = am_nu_non_rotation_factor
         s% skip_rotation_in_convection_zones = skip_rotation_in_convection_zones
         s% am_nu_DSI_factor = am_nu_DSI_factor
         s% am_nu_SH_factor = am_nu_SH_factor
         s% am_nu_SSI_factor = am_nu_SSI_factor
         s% am_nu_ES_factor = am_nu_ES_factor
         s% am_nu_GSF_factor = am_nu_GSF_factor
         s% am_nu_ST_factor = am_nu_ST_factor
         s% am_nu_visc_factor = am_nu_visc_factor
         
         s% am_nu_omega_rot_factor = am_nu_omega_rot_factor
         s% am_nu_omega_non_rot_factor = am_nu_omega_non_rot_factor
         s% am_nu_j_rot_factor = am_nu_j_rot_factor
         s% am_nu_j_non_rot_factor = am_nu_j_non_rot_factor
         
         s% smooth_nu_ST = smooth_nu_ST
         s% smooth_D_ST = smooth_D_ST
         s% smooth_D_DSI = smooth_D_DSI
         s% smooth_D_SSI = smooth_D_SSI
         s% smooth_D_SH = smooth_D_SH
         s% smooth_D_GSF = smooth_D_GSF
         s% smooth_D_ES = smooth_D_ES
         
         s% angsmt_D_DSI = angsmt_D_DSI
         s% angsmt_D_SH = angsmt_D_SH
         s% angsmt_D_SSI = angsmt_D_SSI
         s% angsmt_D_ES = angsmt_D_ES
         s% angsmt_D_GSF = angsmt_D_GSF
         s% angsmt_D_ST = angsmt_D_ST
         s% angsmt_nu_ST = angsmt_nu_ST
         s% angsml = angsml
         s% am_time_average = am_time_average
         s% simple_i_rot_flag = simple_i_rot_flag
         s% do_adjust_J_lost = do_adjust_J_lost
         s% premix_omega = premix_omega
         s% adjust_J_fraction = adjust_J_fraction
         s% max_mdot_redo_cnt = max_mdot_redo_cnt
         s% mdot_revise_factor = mdot_revise_factor
         s% implicit_mdot_boost = implicit_mdot_boost
         s% min_years_dt_for_redo_mdot = min_years_dt_for_redo_mdot
         s% surf_w_div_w_crit_limit = surf_w_div_w_crit_limit
         s% surf_w_div_w_crit_tol = surf_w_div_w_crit_tol
         s% fp_min = fp_min
         s% ft_min = ft_min
         s% fp_error_limit = fp_error_limit
         s% ft_error_limit = ft_error_limit

         s% D_mix_rotation_max_logT_full_on = D_mix_rotation_max_logT_full_on
         s% D_mix_rotation_min_logT_full_off = D_mix_rotation_min_logT_full_off
         
         s% set_uniform_am_nu_non_rot = set_uniform_am_nu_non_rot
         s% uniform_am_nu_non_rot = uniform_am_nu_non_rot
         
         s% set_min_am_nu_non_rot = set_min_am_nu_non_rot
         s% min_am_nu_non_rot = min_am_nu_non_rot
         s% min_center_Ye_for_min_am_nu_non_rot = min_center_Ye_for_min_am_nu_non_rot
         
         s% set_min_D_mix = set_min_D_mix
         s% min_D_mix = min_D_mix
         s% min_center_Ye_for_min_D_mix = min_center_Ye_for_min_D_mix
         s% reaction_neuQs_factor = reaction_neuQs_factor
         
         s% op_split_gradT_fraction_grada = op_split_gradT_fraction_grada

         s% smooth_outer_xa_big = smooth_outer_xa_big
         s% smooth_outer_xa_small = smooth_outer_xa_small
         
         ! element diffusion parameters
         s% diffusion_use_iben_macdonald = diffusion_use_iben_macdonald         
         s% do_element_diffusion = do_element_diffusion
         s% diffusion_min_dq_at_surface = diffusion_min_dq_at_surface
         s% diffusion_min_T_at_surface = diffusion_min_T_at_surface
         s% diffusion_min_dq_ratio_at_surface = diffusion_min_dq_ratio_at_surface
         s% diffusion_dt_limit = diffusion_dt_limit

         s% diffusion_min_X_hard_limit = diffusion_min_X_hard_limit
         s% diffusion_X_total_atol = diffusion_X_total_atol
         s% diffusion_X_total_rtol = diffusion_X_total_rtol
         s% diffusion_upwind_abs_v_limit = diffusion_upwind_abs_v_limit
         s% diffusion_dt_div_timescale = diffusion_dt_div_timescale
         s% diffusion_min_num_substeps = diffusion_min_num_substeps
         s% diffusion_max_iters_per_substep = diffusion_max_iters_per_substep
         s% diffusion_max_retries_per_substep = diffusion_max_retries_per_substep
         s% diffusion_v_max = diffusion_v_max
         s% diffusion_gamma_full_off = diffusion_gamma_full_off
         s% diffusion_gamma_full_on = diffusion_gamma_full_on
         s% diffusion_T_full_off = diffusion_T_full_off
         s% diffusion_T_full_on = diffusion_T_full_on
         s% diffusion_calculates_ionization = diffusion_calculates_ionization
         s% diffusion_nsmooth_typical_charge = diffusion_nsmooth_typical_charge
         s% diffusion_tol_correction_max = diffusion_tol_correction_max
         s% diffusion_tol_correction_norm = diffusion_tol_correction_norm
         
         s% diffusion_AD_dm_full_on = diffusion_AD_dm_full_on
         s% diffusion_AD_dm_full_off = diffusion_AD_dm_full_off
         s% diffusion_AD_boost_factor = diffusion_AD_boost_factor
         
         s% diffusion_SIG_factor = diffusion_SIG_factor
         s% diffusion_GT_factor = diffusion_GT_factor
         
         s% diffusion_Vlimit_dm_full_on = diffusion_Vlimit_dm_full_on
         s% diffusion_Vlimit_dm_full_off = diffusion_Vlimit_dm_full_off
         s% diffusion_Vlimit = diffusion_Vlimit

         s% diffusion_max_T_for_radaccel = diffusion_max_T_for_radaccel
         s% diffusion_min_T_for_radaccel = diffusion_min_T_for_radaccel
         s% diffusion_screening_for_radaccel = diffusion_screening_for_radaccel
         s% op_mono_data_path = op_mono_data_path
         s% op_mono_data_cache_filename = op_mono_data_cache_filename
         
         s% show_diffusion_info = show_diffusion_info
         s% show_diffusion_substep_info = show_diffusion_substep_info
         s% show_diffusion_timing = show_diffusion_timing
         
         s% diffusion_num_classes = diffusion_num_classes
         s% diffusion_class_representative = diffusion_class_representative
         s% diffusion_class_A_max = diffusion_class_A_max
         s% diffusion_class_typical_charge = diffusion_class_typical_charge
         s% diffusion_class_factor = diffusion_class_factor
         
         s% diffusion_use_isolve = diffusion_use_isolve
         s% diffusion_rtol_for_isolve = diffusion_rtol_for_isolve
         s% diffusion_atol_for_isolve = diffusion_atol_for_isolve
         s% diffusion_maxsteps_for_isolve = diffusion_maxsteps_for_isolve
         s% diffusion_isolve_solver = diffusion_isolve_solver

         ! eos controls
         s% use_fixed_XZ_for_eos = use_fixed_XZ_for_eos
         s% fixed_X_for_eos = fixed_X_for_eos
         s% fixed_Z_for_eos = fixed_Z_for_eos
         
         s% use_eosDE_get = use_eosDE_get
         
         s% use_eosDT_ideal_gas = use_eosDT_ideal_gas
         s% use_eosDT_HELMEOS = use_eosDT_HELMEOS        
         s% eosDT_HELMEOS_include_radiation = eosDT_HELMEOS_include_radiation
         s% eosDT_HELMEOS_always_skip_elec_pos = eosDT_HELMEOS_always_skip_elec_pos

         ! opacity controls
         s% cubic_interpolation_in_X = cubic_interpolation_in_X
         s% cubic_interpolation_in_Z = cubic_interpolation_in_Z
         s% include_electron_conduction = include_electron_conduction


         s% use_simple_es_for_kap = use_simple_es_for_kap
         s% Zbase = Zbase
         s% use_Type2_opacities = use_Type2_opacities
         s% kap_Type2_full_off_X = kap_Type2_full_off_X
         s% kap_Type2_full_on_X = kap_Type2_full_on_X
         s% kap_Type2_full_off_dZ = kap_Type2_full_off_dZ
         s% kap_Type2_full_on_dZ = kap_Type2_full_on_dZ
         s% low_logT_op_mono_full_off = low_logT_op_mono_full_off
         s% low_logT_op_mono_full_on = low_logT_op_mono_full_on
         s% high_logT_op_mono_full_off = high_logT_op_mono_full_off
         s% high_logT_op_mono_full_on = high_logT_op_mono_full_on
         s% op_mono_min_X_to_include = op_mono_min_X_to_include
         s% use_op_mono_alt_get_kap = use_op_mono_alt_get_kap
         
         s% include_L_in_error_est = include_L_in_error_est
         s% include_v_in_error_est = include_v_in_error_est
         s% just_use_energy_resid = just_use_energy_resid

            
         ! asteroseismology controls
         
         s% get_delta_nu_from_scaled_solar = get_delta_nu_from_scaled_solar
         s% nu_max_sun = nu_max_sun
         s% delta_nu_sun = delta_nu_sun
         s% Teff_sun = Teff_sun
         s% delta_Pg_mode_freq = delta_Pg_mode_freq
                  
                  
         ! hydro parameters
         s% opacity_factor = opacity_factor
         s% opacity_max = opacity_max
         s% min_logT_for_opacity_factor_off = min_logT_for_opacity_factor_off
         s% min_logT_for_opacity_factor_on = min_logT_for_opacity_factor_on
         s% max_logT_for_opacity_factor_on = max_logT_for_opacity_factor_on
         s% max_logT_for_opacity_factor_off = max_logT_for_opacity_factor_off

         s% dxdt_nuc_factor = dxdt_nuc_factor
         s% non_nuc_neu_factor = non_nuc_neu_factor
         s% accel_factor = accel_factor
         s% use_gr_factors = use_gr_factors
         s% use_dvdt_form_of_momentum_eqn = use_dvdt_form_of_momentum_eqn
         s% use_dlnddt_form_of_density_eqn = use_dlnddt_form_of_density_eqn
         s% use_dedt_form_of_energy_eqn = use_dedt_form_of_energy_eqn
         s% use_sr_sound_speed = use_sr_sound_speed
         s% use_mass_corrections = use_mass_corrections
         s% use_dP_dm_rotation_correction = use_dP_dm_rotation_correction
         s% eps_grav_factor = eps_grav_factor
         s% eps_grav_dt_use_start_values = eps_grav_dt_use_start_values
         s% use_lnS_for_eps_grav = use_lnS_for_eps_grav
         s% use_dEdRho_form_for_eps_grav = use_dEdRho_form_for_eps_grav
         s% use_dlnd_dt_form_for_eps_grav = use_dlnd_dt_form_for_eps_grav
         s% use_PdVdt_form_for_eps_grav = use_PdVdt_form_for_eps_grav
         s% include_dmu_dt_in_eps_grav = include_dmu_dt_in_eps_grav
         s% factor_for_test_CpT_absMdot_div_L = factor_for_test_CpT_absMdot_div_L
         s% eps_grav_time_deriv_separation = eps_grav_time_deriv_separation 
         s% zero_eps_grav_in_just_added_material = zero_eps_grav_in_just_added_material
         s% min_del_T_div_dt = min_del_T_div_dt
         s% max_abs_rel_change_surf_lnS = max_abs_rel_change_surf_lnS
         s% trace_force_another_iteration = trace_force_another_iteration
         s% max_num_surf_revisions = max_num_surf_revisions
         s% Gamma_lnS_eps_grav_full_off = Gamma_lnS_eps_grav_full_off
         s% Gamma_lnS_eps_grav_full_on = Gamma_lnS_eps_grav_full_on
         s% use_artificial_viscosity = use_artificial_viscosity
         s% hold_artificial_viscosity_const_during_step = &
            hold_artificial_viscosity_const_during_step
         s% artificial_viscosity_Q_shift = artificial_viscosity_Q_shift
         s% art_visc_full_off_logRho_le_this = art_visc_full_off_logRho_le_this
         s% art_visc_full_on_logRho_ge_this = art_visc_full_on_logRho_ge_this
         s% post_shock_viscosity_decay_factor = post_shock_viscosity_decay_factor
         s% pre_shock_viscosity_decay_factor = pre_shock_viscosity_decay_factor
         s% use_dPrad_dm_form_of_T_gradient_eqn = use_dPrad_dm_form_of_T_gradient_eqn
         s% use_energy_conservation_form = use_energy_conservation_form
         s% theta_P = theta_P
         s% use_ODE_var_eqn_pairing = use_ODE_var_eqn_pairing
         s% use_bdf_instead_of_ebdf = use_bdf_instead_of_ebdf
         s% use_sdirk_instead_of_ebdf = use_sdirk_instead_of_ebdf
         s% use_symplectic_instead_of_ebdf = use_symplectic_instead_of_ebdf
         s% max_ebdf_order = max_ebdf_order
         s% min_ebdf_order = min_ebdf_order
         s% steps_before_try_higher_ebdf_order = steps_before_try_higher_ebdf_order
         s% factor_for_ebdf_order_tests = factor_for_ebdf_order_tests
         s% ebdf_redo_mix_coeffs_other_stages = ebdf_redo_mix_coeffs_other_stages
         s% ebdf_redo_mix_for_comparison_stage = ebdf_redo_mix_for_comparison_stage
         s% ebdf_redo_mix_for_final_stage = ebdf_redo_mix_for_final_stage
         s% trace_truncation_ratio = trace_truncation_ratio
         s% qmin_freeze_non_radiative_luminosity = qmin_freeze_non_radiative_luminosity
         s% qmax_zero_non_radiative_luminosity = qmax_zero_non_radiative_luminosity
         s% eps_visc_factor = eps_visc_factor
         s% dvdt_visc_factor = dvdt_visc_factor
         s% shock_spread_quadratic = shock_spread_quadratic
         s% shock_spread_linear = shock_spread_linear

         s% center_flash_total_time = center_flash_total_time
         s% center_flash_ramp_up_duration = center_flash_ramp_up_duration
         s% center_flash_ramp_down_duration = center_flash_ramp_down_duration
         s% center_flash_total_ergs = center_flash_total_ergs
         
         s% use_piston = use_piston
         s% piston_period = piston_period
         s% periodic_piston_max_displacement = periodic_piston_max_displacement
         s% periodic_piston_number_of_cycles = periodic_piston_number_of_cycles
         s% periodic_piston_done_delay = periodic_piston_done_delay
         s% piston_inward_time = piston_inward_time
         s% piston_Rmin = piston_Rmin
         s% piston_v0 = piston_v0
         s% piston_Rmax = piston_Rmax
         s% reset_total_energy_initial_when_done_with_piston = &
            reset_total_energy_initial_when_done_with_piston
         
         s% velocity_logT_lower_bound = velocity_logT_lower_bound
         s% max_dt_yrs_for_velocity_logT_lower_bound = max_dt_yrs_for_velocity_logT_lower_bound
         s% velocity_q_upper_bound = velocity_q_upper_bound

         s% min_dxm_Eulerian_div_dxm_CpTMdot_lt_L = min_dxm_Eulerian_div_dxm_CpTMdot_lt_L
         s% min_dxm_Eulerian_div_dxm_removed = min_dxm_Eulerian_div_dxm_removed
         s% min_dxm_Eulerian_div_dxm_added = min_dxm_Eulerian_div_dxm_added
         s% min_cells_for_Eulerian_to_Lagrangian_transition = &
            min_cells_for_Eulerian_to_Lagrangian_transition

         ! solvers
         s% split_mixing_choice = split_mixing_choice
         s% split_mix_do_burn = split_mix_do_burn
         s% op_split_burn_mix_num_passes = op_split_burn_mix_num_passes
         
         s% op_split_burn_trace = op_split_burn_trace
         s% op_split_burn_tol_max_correction = op_split_burn_tol_max_correction
         s% op_split_burn_tol_avg_correction = op_split_burn_tol_avg_correction
         s% op_split_burn_lambda_undercorrection = op_split_burn_lambda_undercorrection
         s% op_split_burn_tol_hi_logT_limit = op_split_burn_tol_hi_logT_limit
         s% op_split_burn_tol_hi_logT_factor = op_split_burn_tol_hi_logT_factor
         
         s% op_split_burn_refine_min_T = op_split_burn_refine_min_T
         s% op_split_burn_refine_maxerr_limit = op_split_burn_refine_maxerr_limit
         s% op_split_burn_use_quad_min_T = op_split_burn_use_quad_min_T
         s% op_split_burn_use_DGESVX_min_T = op_split_burn_use_DGESVX_min_T
         
         s% op_split_burn_max_iterations = op_split_burn_max_iterations
         s% burn_maxabs_dt_d_dxdt_dt = burn_maxabs_dt_d_dxdt_dt
         s% burn_try_substeps_if_BE_fails = burn_try_substeps_if_BE_fails
         s% burn_reuse_given_rates = burn_reuse_given_rates
         s% burn_pause_for_failure = burn_pause_for_failure
         s% op_split_burn_sparse_limit = op_split_burn_sparse_limit
         s% op_split_burn_use_net_info_for_sparsity = op_split_burn_use_net_info_for_sparsity
         s% op_split_burn_min_lambda = op_split_burn_min_lambda
         s% op_split_burn_use_pivoting = op_split_burn_use_pivoting
         s% reset_mixing_info_before_final_mix = reset_mixing_info_before_final_mix

         s% op_split_mix_trace = op_split_mix_trace
         s% op_split_mix_atol = op_split_mix_atol
         s% op_split_mix_rtol = op_split_mix_rtol

         s% op_split_burn_mix_trace = op_split_burn_mix_trace
         s% op_split_burn_k_dbg = op_split_burn_k_dbg
         s% op_split_burn_dbg_model_number = op_split_burn_dbg_model_number

         s% op_split_burn_min_logT_for_partials = op_split_burn_min_logT_for_partials
         s% op_split_burn_partials_dlogRho = op_split_burn_partials_dlogRho
         s% op_split_burn_partials_dlogT = op_split_burn_partials_dlogT
         
         s% substep_min_T = substep_min_T
         s% burn_stptry = burn_stptry
         s% burn_max_steps = burn_max_steps
         s% burn_eps = burn_eps
         s% burn_odescal = burn_odescal
         
         s% substep_burn_solver = substep_burn_solver
         s% substep_burn_decsol = substep_burn_decsol
         s% substep_burn_max_steps = substep_burn_max_steps
         s% substep_burn_rtol = substep_burn_rtol
         s% substep_burn_atol = substep_burn_atol
         s% substep_burn_xmin = substep_burn_xmin
         s% substep_burn_xmax = substep_burn_xmax
         s% substep_burn_clip = substep_burn_clip
         s% substep_burn_use_eps_binding = substep_burn_use_eps_binding

         s% tol_correction_norm = tol_correction_norm
         s% tol_max_correction = tol_max_correction
         s% tol_correction_norm_alt = tol_correction_norm_alt
         s% tol_max_correction_alt = tol_max_correction_alt
         s% sizeB_gam0 = sizeB_gam0
         s% size_del_gam = size_del_gam
         s% correction_xa_limit = correction_xa_limit
         
         s% tol_correction_high_T_limit = tol_correction_high_T_limit
         s% tol_correction_norm_high_T = tol_correction_norm_high_T
         s% tol_max_correction_high_T = tol_max_correction_high_T
         
         s% tol_correction_extreme_T_limit = tol_correction_extreme_T_limit
         s% tol_correction_norm_extreme_T = tol_correction_norm_extreme_T
         s% tol_max_correction_extreme_T = tol_max_correction_extreme_T
         
         s% tol_residual_norm1 = tol_residual_norm1
         s% tol_max_residual1 = tol_max_residual1
         s% tol_residual_norm2 = tol_residual_norm2
         s% tol_max_residual2 = tol_max_residual2
         s% tol_residual_norm3 = tol_residual_norm3
         s% tol_max_residual3 = tol_max_residual3
         
         s% trace_newton_damping = trace_newton_damping
         
         s% max_iterations_for_jacobian = max_iterations_for_jacobian
         s% refine_solution = refine_solution
         s% refine_mtx_solution = refine_mtx_solution
         
         s% star_bcyclic_do_pivot = star_bcyclic_do_pivot
         s% sparse_min_refactor_rgrowth = sparse_min_refactor_rgrowth

         s% small_mtx_decsol = small_mtx_decsol
         s% large_mtx_decsol = large_mtx_decsol
         s% hydro_decsol_switch = hydro_decsol_switch
         s% sparse_non_zero_max_factor = sparse_non_zero_max_factor

         s% iter_for_resid_tol2 = iter_for_resid_tol2
         s% iter_for_resid_tol3 = iter_for_resid_tol3
         
         s% newton_itermin = newton_itermin
         s% newton_itermin_until_reduce_min_corr_coeff = &
            newton_itermin_until_reduce_min_corr_coeff
         s% newton_reduced_min_corr_coeff = newton_reduced_min_corr_coeff
         s% do_newton_damping_for_neg_xa = do_newton_damping_for_neg_xa
         s% hydro_mtx_max_allowed_abs_dlogT = hydro_mtx_max_allowed_abs_dlogT
         s% hydro_mtx_max_allowed_abs_dlogRho = hydro_mtx_max_allowed_abs_dlogRho
         s% hydro_mtx_max_allowed_abs_dlogPgas = hydro_mtx_max_allowed_abs_dlogPgas
         s% min_logT_for_hydro_mtx_max_allowed = min_logT_for_hydro_mtx_max_allowed
         s% hydro_mtx_max_allowed_logT = hydro_mtx_max_allowed_logT
         s% hydro_mtx_max_allowed_logRho = hydro_mtx_max_allowed_logRho
         s% hydro_mtx_max_allowed_logPgas = hydro_mtx_max_allowed_logPgas
         
         s% hydro_solver_name = hydro_solver_name

         s% tiny_corr_coeff_limit = tiny_corr_coeff_limit
         s% scale_correction_norm = scale_correction_norm
         s% corr_param_factor = corr_param_factor
         s% scale_max_correction = scale_max_correction
         
         s% corr_norm_jump_limit = corr_norm_jump_limit
         s% max_corr_jump_limit = max_corr_jump_limit
         s% resid_norm_jump_limit = resid_norm_jump_limit
         s% max_resid_jump_limit = max_resid_jump_limit
         
         s% corr_coeff_limit = corr_coeff_limit
         s% tiny_corr_factor = tiny_corr_factor
         s% matrix_type = matrix_type

         s% max_tries = max_tries
         s% max_tries1 = max_tries1
         s% max_tries_for_retry = max_tries_for_retry
         s% max_tries_after_5_retries = max_tries_after_5_retries
         s% max_tries_after_10_retries = max_tries_after_10_retries
         s% max_tries_after_20_retries = max_tries_after_20_retries
         s% max_tries_after_backup = max_tries_after_backup
         s% max_tries_after_backup2 = max_tries_after_backup2
         s% retry_limit = retry_limit
         s% redo_limit = redo_limit
         
         s% min_xa_hard_limit = min_xa_hard_limit
         s% min_xa_hard_limit_for_highT = min_xa_hard_limit_for_highT
         s% logT_max_for_min_xa_hard_limit = logT_max_for_min_xa_hard_limit
         s% logT_min_for_min_xa_hard_limit_for_highT = logT_min_for_min_xa_hard_limit_for_highT
         
         s% sum_xa_hard_limit = sum_xa_hard_limit
         s% sum_xa_hard_limit_for_highT = sum_xa_hard_limit_for_highT
         s% logT_max_for_sum_xa_hard_limit = logT_max_for_sum_xa_hard_limit
         s% logT_min_for_sum_xa_hard_limit_for_highT = logT_min_for_sum_xa_hard_limit_for_highT
         
         s% xa_clip_limit = xa_clip_limit
         s% report_hydro_solver_progress = report_hydro_solver_progress
         s% hydro_dump_call_number = hydro_dump_call_number
         s% hydro_dump_iter_number = hydro_dump_iter_number
         s% hydro_numerical_jacobian = hydro_numerical_jacobian
         s% hydro_jacobian_nzlo = hydro_jacobian_nzlo
         s% hydro_jacobian_nzhi = hydro_jacobian_nzhi
         s% hydro_check_everything = hydro_check_everything
         s% hydro_inspectB_flag = hydro_inspectB_flag
         s% hydro_show_correction_info = hydro_show_correction_info
         s% hydro_save_numjac_plot_data = hydro_save_numjac_plot_data
         s% trace_k = trace_k

         ! timestep
         s% max_timestep = max_timestep
         s% max_years_for_timestep = max_years_for_timestep

         s% hi_T_max_years_for_timestep = hi_T_max_years_for_timestep
         s% max_timestep_hi_T_limit = max_timestep_hi_T_limit
         
         s% min_timestep_factor = min_timestep_factor
         s% max_timestep_factor = max_timestep_factor
         s% timestep_factor_for_backups = timestep_factor_for_backups
         s% timestep_factor_for_retries = timestep_factor_for_retries
         s% backup_hold = backup_hold
         s% retry_hold = retry_hold
         s% neg_mass_fraction_hold = neg_mass_fraction_hold
         s% DUP_varcontrol_factor = DUP_varcontrol_factor
         s% timestep_dt_factor = timestep_dt_factor
         s% dt_limit_ratio_target = dt_limit_ratio_target
         s% use_dt_low_pass_controller = use_dt_low_pass_controller

         s% varcontrol_target = varcontrol_target
         s% varcontrol_dt_limit_ratio_hard_max = varcontrol_dt_limit_ratio_hard_max
         s% xa_scale = xa_scale

         s% truncation_ratio_xh_atol = truncation_ratio_xh_atol
         s% truncation_ratio_xh_rtol = truncation_ratio_xh_rtol
         s% truncation_ratio_xa_atol = truncation_ratio_xa_atol
         s% truncation_ratio_xa_rtol = truncation_ratio_xa_rtol
         s% truncation_ratio_limit = truncation_ratio_limit
         s% truncation_ratio_hard_limit = truncation_ratio_hard_limit
         s% eval_truncation_ratio_do_max = eval_truncation_ratio_do_max
         s% use_truncation_ratio_limit = use_truncation_ratio_limit
         
         s% newton_iterations_limit = newton_iterations_limit
         s% newton_iterations_hard_limit = newton_iterations_hard_limit
         
         s% rotation_steps_limit = rotation_steps_limit
         s% rotation_steps_hard_limit = rotation_steps_hard_limit
         
         s% diffusion_steps_limit = diffusion_steps_limit
         s% diffusion_steps_hard_limit = diffusion_steps_hard_limit
         s% diffusion_iters_limit = diffusion_iters_limit
         s% diffusion_iters_hard_limit = diffusion_iters_hard_limit
         
         s% dt_div_dt_Courant_limit = dt_div_dt_Courant_limit
         s% dt_div_dt_Courant_hard_limit = dt_div_dt_Courant_hard_limit
         s% dt_div_dt_cell_collapse_limit = dt_div_dt_cell_collapse_limit
         s% dt_div_dt_cell_collapse_hard_limit = dt_div_dt_cell_collapse_hard_limit
         s% dt_div_dt_thermal_limit = dt_div_dt_thermal_limit
         s% dt_div_dt_thermal_hard_limit = dt_div_dt_thermal_hard_limit
         s% dt_div_dt_dynamic_limit = dt_div_dt_dynamic_limit
         s% dt_div_dt_dynamic_hard_limit = dt_div_dt_dynamic_hard_limit
         s% dt_div_dt_acoustic_limit = dt_div_dt_acoustic_limit
         s% dt_div_dt_acoustic_hard_limit = dt_div_dt_acoustic_hard_limit
         s% dt_div_dt_mass_loss_limit = dt_div_dt_mass_loss_limit
         s% dt_div_dt_mass_loss_hard_limit = dt_div_dt_mass_loss_hard_limit
         
         s% burn_max_iters_limit = burn_max_iters_limit
         s% burn_max_iters_hard_limit = burn_max_iters_hard_limit

         s% burn_max_substeps_limit = burn_max_substeps_limit
         s% burn_max_substeps_hard_limit = burn_max_substeps_hard_limit
         
         s% max_fixup_for_mix_limit = max_fixup_for_mix_limit
         s% max_fixup_for_mix_hard_limit = max_fixup_for_mix_hard_limit
         
         s% dX_mix_dist_limit = dX_mix_dist_limit
         
         s% dH_limit_min_H = dH_limit_min_H
         s% dH_limit = dH_limit
         s% dH_hard_limit = dH_hard_limit
         s% dH_div_H_limit_min_H = dH_div_H_limit_min_H
         s% dH_div_H_limit = dH_div_H_limit
         s% dH_div_H_hard_limit = dH_div_H_hard_limit
         s% dH_decreases_only = dH_decreases_only

         s% dHe_limit_min_He = dHe_limit_min_He
         s% dHe_limit = dHe_limit
         s% dHe_hard_limit = dHe_hard_limit
         s% dHe_div_He_limit_min_He = dHe_div_He_limit_min_He
         s% dHe_div_He_limit = dHe_div_He_limit
         s% dHe_div_He_hard_limit = dHe_div_He_hard_limit
         s% dHe_decreases_only = dHe_decreases_only

         s% dHe3_limit_min_He3 = dHe3_limit_min_He3
         s% dHe3_limit = dHe3_limit
         s% dHe3_hard_limit = dHe3_hard_limit
         s% dHe3_div_He3_limit_min_He3 = dHe3_div_He3_limit_min_He3
         s% dHe3_div_He3_limit = dHe3_div_He3_limit
         s% dHe3_div_He3_hard_limit = dHe3_div_He3_hard_limit
         s% dHe3_decreases_only = dHe3_decreases_only

         s% dX_limit_min_X = dX_limit_min_X
         s% dX_limit = dX_limit
         s% dX_hard_limit = dX_hard_limit
         s% dX_div_X_limit_min_X = dX_div_X_limit_min_X
         s% dX_div_X_limit = dX_div_X_limit
         s% dX_div_X_hard_limit = dX_div_X_hard_limit
         s% dX_decreases_only = dX_decreases_only
         
         s% dX_nuc_drop_min_X_limit = dX_nuc_drop_min_X_limit
         s% dX_nuc_drop_max_A_limit = dX_nuc_drop_max_A_limit
         s% dX_nuc_drop_limit = dX_nuc_drop_limit
         s% dX_nuc_drop_limit_at_high_T = dX_nuc_drop_limit_at_high_T
         s% dX_nuc_drop_hard_limit = dX_nuc_drop_hard_limit
         s% dX_nuc_drop_min_yrs_for_dt = dX_nuc_drop_min_yrs_for_dt
         
         s% dL_div_L_limit_min_L = dL_div_L_limit_min_L
         s% dL_div_L_limit = dL_div_L_limit
         s% dL_div_L_hard_limit = dL_div_L_hard_limit

         s% delta_lgP_limit = delta_lgP_limit
         s% delta_lgP_hard_limit = delta_lgP_hard_limit
         s% delta_lgP_limit_min_lgP = delta_lgP_limit_min_lgP
         
         s% delta_lgRho_limit = delta_lgRho_limit
         s% delta_lgRho_hard_limit = delta_lgRho_hard_limit
         s% delta_lgRho_limit_min_lgRho = delta_lgRho_limit_min_lgRho
         
         s% delta_lgT_limit = delta_lgT_limit
         s% delta_lgT_hard_limit = delta_lgT_hard_limit
         s% delta_lgT_limit_min_lgT = delta_lgT_limit_min_lgT
         
         s% delta_lgE_limit = delta_lgE_limit
         s% delta_lgE_hard_limit = delta_lgE_hard_limit
         s% delta_lgE_limit_min_lgE = delta_lgE_limit_min_lgE
         
         s% delta_lgR_limit = delta_lgR_limit
         s% delta_lgR_hard_limit = delta_lgR_hard_limit
         s% delta_lgR_limit_min_lgR = delta_lgR_limit_min_lgR
         
         s% delta_Ye_limit = delta_Ye_limit
         s% delta_Ye_hard_limit = delta_Ye_hard_limit
         s% delta_Ye_highT_limit = delta_Ye_highT_limit
         s% delta_Ye_highT_hard_limit = delta_Ye_highT_hard_limit
         s% minT_for_highT_Ye_limit = minT_for_highT_Ye_limit
         
         s% d_deltaR_shrink_limit = d_deltaR_shrink_limit
         s% d_deltaR_shrink_hard_limit = d_deltaR_shrink_hard_limit
         s% d_deltaR_grow_limit = d_deltaR_grow_limit
         s% d_deltaR_grow_hard_limit = d_deltaR_grow_hard_limit

         s% delta_lgL_nuc_cat_limit = delta_lgL_nuc_cat_limit
         s% delta_lgL_nuc_cat_hard_limit = delta_lgL_nuc_cat_hard_limit
         s% lgL_nuc_cat_burn_min = lgL_nuc_cat_burn_min
         s% lgL_nuc_mix_dist_limit = lgL_nuc_mix_dist_limit
         
         s% check_delta_lgL_pp = check_delta_lgL_pp
         s% check_delta_lgL_cno = check_delta_lgL_cno
         s% check_delta_lgL_3alf = check_delta_lgL_3alf
            
         s% check_delta_lgL_burn_c = check_delta_lgL_burn_c
         s% check_delta_lgL_burn_n = check_delta_lgL_burn_n
         s% check_delta_lgL_burn_o = check_delta_lgL_burn_o
         s% check_delta_lgL_burn_ne = check_delta_lgL_burn_ne
         s% check_delta_lgL_burn_na = check_delta_lgL_burn_na
         s% check_delta_lgL_burn_mg = check_delta_lgL_burn_mg
         s% check_delta_lgL_burn_si = check_delta_lgL_burn_si
         s% check_delta_lgL_burn_s = check_delta_lgL_burn_s
         s% check_delta_lgL_burn_ar = check_delta_lgL_burn_ar
         s% check_delta_lgL_burn_ca = check_delta_lgL_burn_ca
         s% check_delta_lgL_burn_ti = check_delta_lgL_burn_ti
         s% check_delta_lgL_burn_cr = check_delta_lgL_burn_cr
         s% check_delta_lgL_burn_fe = check_delta_lgL_burn_fe
         
         s% check_delta_lgL_cc = check_delta_lgL_cc
         s% check_delta_lgL_co = check_delta_lgL_co
         s% check_delta_lgL_oo = check_delta_lgL_oo

         s% delta_lgL_H_limit = delta_lgL_H_limit
         s% delta_lgL_H_hard_limit = delta_lgL_H_hard_limit
         s% lgL_H_burn_min = lgL_H_burn_min
         s% lgL_H_drop_factor = lgL_H_drop_factor
         s% lgL_H_burn_relative_limit = lgL_H_burn_relative_limit

         s% delta_lgL_He_limit = delta_lgL_He_limit
         s% delta_lgL_He_hard_limit = delta_lgL_He_hard_limit
         s% lgL_He_burn_min = lgL_He_burn_min
         s% lgL_He_drop_factor = lgL_He_drop_factor
         s% lgL_He_burn_relative_limit = lgL_He_burn_relative_limit

         s% delta_lgL_z_limit = delta_lgL_z_limit
         s% delta_lgL_z_hard_limit = delta_lgL_z_hard_limit
         s% lgL_z_burn_min = lgL_z_burn_min
         s% lgL_z_drop_factor = lgL_z_drop_factor
         s% lgL_z_burn_relative_limit = lgL_z_burn_relative_limit

         s% delta_lgL_photo_limit = delta_lgL_photo_limit
         s% delta_lgL_photo_hard_limit = delta_lgL_photo_hard_limit
         s% lgL_photo_burn_min = lgL_photo_burn_min
         s% lgL_photo_drop_factor = lgL_photo_drop_factor

         s% delta_lgL_nuc_limit = delta_lgL_nuc_limit
         s% delta_lgL_nuc_hard_limit = delta_lgL_nuc_hard_limit
         s% lgL_nuc_burn_min = lgL_nuc_burn_min
         s% lgL_nuc_drop_factor = lgL_nuc_drop_factor
                   
         s% delta_lgRho_cntr_limit = delta_lgRho_cntr_limit
         s% delta_lgRho_cntr_hard_limit = delta_lgRho_cntr_hard_limit
         
         s% delta_lgT_cntr_limit = delta_lgT_cntr_limit
         s% delta_lgT_cntr_hard_limit = delta_lgT_cntr_hard_limit
         
         s% delta_lgT_max_limit = delta_lgT_max_limit
         s% delta_lgT_max_hard_limit = delta_lgT_max_hard_limit
         
         s% delta_lgRho_max_limit = delta_lgRho_max_limit
         s% delta_lgRho_max_hard_limit = delta_lgRho_max_hard_limit
         
         s% delta_log_eps_nuc_cntr_limit = delta_log_eps_nuc_cntr_limit
         s% delta_log_eps_nuc_cntr_hard_limit = delta_log_eps_nuc_cntr_hard_limit
         
         s% delta_log_eps_nuc_limit = delta_log_eps_nuc_limit
         s% delta_log_eps_nuc_hard_limit = delta_log_eps_nuc_hard_limit
                   
         s% delta_lg_XH_cntr_min = delta_lg_XH_cntr_min
         s% delta_lg_XH_cntr_max = delta_lg_XH_cntr_max
         s% delta_lg_XH_cntr_limit = delta_lg_XH_cntr_limit
         s% delta_lg_XH_cntr_hard_limit = delta_lg_XH_cntr_hard_limit
                   
         s% delta_lg_XHe_cntr_min = delta_lg_XHe_cntr_min
         s% delta_lg_XHe_cntr_max = delta_lg_XHe_cntr_max
         s% delta_lg_XHe_cntr_limit = delta_lg_XHe_cntr_limit
         s% delta_lg_XHe_cntr_hard_limit = delta_lg_XHe_cntr_hard_limit
                   
         s% delta_lg_XC_cntr_min = delta_lg_XC_cntr_min
         s% delta_lg_XC_cntr_max = delta_lg_XC_cntr_max
         s% delta_lg_XC_cntr_limit = delta_lg_XC_cntr_limit
         s% delta_lg_XC_cntr_hard_limit = delta_lg_XC_cntr_hard_limit
         
         s% delta_lg_XNe_cntr_limit = delta_lg_XNe_cntr_limit
         s% delta_lg_XNe_cntr_hard_limit = delta_lg_XNe_cntr_hard_limit
         s% delta_lg_XNe_cntr_min = delta_lg_XNe_cntr_min
         s% delta_lg_XNe_cntr_max = delta_lg_XNe_cntr_max
         
         s% delta_lg_XO_cntr_limit = delta_lg_XO_cntr_limit
         s% delta_lg_XO_cntr_hard_limit = delta_lg_XO_cntr_hard_limit
         s% delta_lg_XO_cntr_min = delta_lg_XO_cntr_min 
         s% delta_lg_XO_cntr_max = delta_lg_XO_cntr_max          
         
         s% delta_lg_XSi_cntr_limit = delta_lg_XSi_cntr_limit
         s% delta_lg_XSi_cntr_hard_limit = delta_lg_XSi_cntr_hard_limit
         s% delta_lg_XSi_cntr_min = delta_lg_XSi_cntr_min 
         s% delta_lg_XSi_cntr_max = delta_lg_XSi_cntr_max
      
         s% delta_lgTeff_limit = delta_lgTeff_limit
         s% delta_lgTeff_hard_limit = delta_lgTeff_hard_limit
         
         s% v_div_v_crit_limit = v_div_v_crit_limit
         s% v_div_v_crit_hard_limit = v_div_v_crit_hard_limit
         
         s% delta_lgL_limit = delta_lgL_limit
         s% delta_lgL_limit_L_min = delta_lgL_limit_L_min
         s% delta_lgL_hard_limit = delta_lgL_hard_limit
         
         s% delta_HR_ds_L = delta_HR_ds_L
         s% delta_HR_ds_Teff = delta_HR_ds_Teff
         s% delta_HR_limit = delta_HR_limit
         s% delta_HR_hard_limit = delta_HR_hard_limit
         
         s% delta_lg_total_J_limit = delta_lg_total_J_limit
         s% delta_lg_total_J_hard_limit = delta_lg_total_J_hard_limit

         s% delta_lg_star_mass_limit = delta_lg_star_mass_limit
         s% delta_lg_star_mass_hard_limit = delta_lg_star_mass_hard_limit 
         
         s% delta_mdot_atol = delta_mdot_atol
         s% delta_mdot_rtol = delta_mdot_rtol
         s% delta_mdot_limit = delta_mdot_limit
         s% delta_mdot_hard_limit = delta_mdot_hard_limit
         
         s% CpT_absMdot_div_L_limit = CpT_absMdot_div_L_limit 
         s% CpT_absMdot_div_L_hard_limit = CpT_absMdot_div_L_hard_limit

         s% relax_hard_limits_after_backup = relax_hard_limits_after_backup
         s% relax_hard_limits_after_retry = relax_hard_limits_after_retry
         s% report_all_dt_limits = report_all_dt_limits
         s% report_why_dt_limits = report_why_dt_limits
         s% report_hydro_dt_info = report_hydro_dt_info
         s% report_dX_nuc_drop_dt_limits = report_dX_nuc_drop_dt_limits

         s% limit_for_rel_error_in_energy_conservation =  &
            limit_for_rel_error_in_energy_conservation
         s% hard_limit_for_rel_error_in_energy_conservation =  &
            hard_limit_for_rel_error_in_energy_conservation

         s% limit_for_rel_rate_in_energy_conservation =  &
            limit_for_rel_rate_in_energy_conservation
         s% hard_limit_for_rel_rate_in_energy_conservation =  &
            hard_limit_for_rel_rate_in_energy_conservation

         s% limit_for_avg_E_residual = limit_for_avg_E_residual
         s% hard_limit_for_avg_E_residual = hard_limit_for_avg_E_residual
         s% limit_for_max_E_residual = limit_for_max_E_residual
         s% hard_limit_for_max_E_residual = hard_limit_for_max_E_residual

         s% trace_newton_bcyclic_solve_input = trace_newton_bcyclic_solve_input
         s% trace_newton_bcyclic_solve_output = trace_newton_bcyclic_solve_output
         s% trace_newton_bcyclic_matrix_input = trace_newton_bcyclic_matrix_input
         s% trace_newton_bcyclic_matrix_output = trace_newton_bcyclic_matrix_output
         s% trace_newton_bcyclic_steplo = trace_newton_bcyclic_steplo
         s% trace_newton_bcyclic_stephi = trace_newton_bcyclic_stephi
         s% trace_newton_bcyclic_iterlo = trace_newton_bcyclic_iterlo
         s% trace_newton_bcyclic_iterhi = trace_newton_bcyclic_iterhi
         s% trace_newton_bcyclic_nzlo = trace_newton_bcyclic_nzlo
         s% trace_newton_bcyclic_nzhi = trace_newton_bcyclic_nzhi
         s% trace_newton_bcyclic_jlo = trace_newton_bcyclic_jlo
         s% trace_newton_bcyclic_jhi = trace_newton_bcyclic_jhi
         s% write_varcontrol_internals = write_varcontrol_internals
         
         s% min_logT_for_quad = min_logT_for_quad
         
         s% trace_evolve = trace_evolve

         
         ! misc
         s% zams_filename = zams_filename
         
         s% use_other_eos = use_other_eos
         s% use_other_surface_PT = use_other_surface_PT
         s% use_other_kap = use_other_kap
         s% use_other_atm = use_other_atm
         s% use_other_diffusion = use_other_diffusion
         s% use_other_mlt = use_other_mlt
         s% use_other_adjust_mdot = use_other_adjust_mdot
         s% use_other_am_mixing = use_other_am_mixing
         s% use_other_brunt = use_other_brunt
         s% use_other_brunt_smoothing = use_other_brunt_smoothing
         s% use_other_newton_monitor = use_other_newton_monitor
         s% use_other_build_initial_model = use_other_build_initial_model
         s% use_other_cgrav = use_other_cgrav
         s% use_other_energy_implicit = use_other_energy_implicit
         s% use_other_momentum = use_other_momentum
         s% use_other_energy = use_other_energy
         s% use_other_mesh_functions = use_other_mesh_functions
         s% use_other_eps_grav = use_other_eps_grav
         s% use_other_D_mix = use_other_D_mix
         s% use_other_split_mix = use_other_split_mix
         s% use_other_neu = use_other_neu
         s% use_other_opacity_factor = use_other_opacity_factor
         s% use_other_paquette_coefficients = use_other_paquette_coefficients
         s% use_other_pgstar_plots = use_other_pgstar_plots
         s% use_other_torque = use_other_torque
         s% use_other_torque_implicit = use_other_torque_implicit
         s% use_other_wind = use_other_wind
         s% use_other_after_struct_burn_mix = use_other_after_struct_burn_mix
         s% use_other_before_struct_burn_mix = use_other_before_struct_burn_mix
         s% use_other_get_pulsation_info = use_other_get_pulsation_info
         s% use_other_write_pulsation_info = use_other_write_pulsation_info
         s% use_other_edit_pulsation_info = use_other_edit_pulsation_info
         s% use_other_edit_gyre_info = use_other_edit_gyre_info
         s% use_other_get_gyre_model = use_other_get_gyre_model
         s% use_other_adjust_net = use_other_adjust_net
         s% use_other_astero_freq_corr = use_other_astero_freq_corr

         s% trace_solar_neutrinos = trace_solar_neutrinos
         
         s% x_ctrl = x_ctrl
         s% x_integer_ctrl = x_integer_ctrl
         s% x_logical_ctrl = x_logical_ctrl
         s% x_character_ctrl = x_character_ctrl
         
         ! info for debugging
         s% stop_for_bugs = stop_for_bugs
         s% report_ierr = report_ierr

         s% diffusion_dump_call_number = diffusion_dump_call_number

         
      end subroutine store_controls


      subroutine set_controls_for_writing(s, ierr)
         use star_private_def
         use chem_def ! categories
         type (star_info), pointer :: s
         integer, intent(out) :: ierr
         
         ierr = 0
         
         ! where to start
         initial_mass = s% initial_mass
         initial_z = s% initial_z
         initial_y = s% initial_y

         ! definition of core boundaries
         he_core_boundary_h1_fraction = s% he_core_boundary_h1_fraction 
         c_core_boundary_he4_fraction = s% c_core_boundary_he4_fraction
         o_core_boundary_c12_fraction = s% o_core_boundary_c12_fraction
         si_core_boundary_o16_fraction = s% si_core_boundary_o16_fraction
         fe_core_boundary_si28_fraction = s% fe_core_boundary_si28_fraction
         neutron_rich_core_boundary_Ye_max = s% neutron_rich_core_boundary_Ye_max
         min_boundary_fraction = s% min_boundary_fraction

         ! when to stop
         max_model_number = s% max_model_number
         max_backups_in_a_row = s% max_backups_in_a_row
         max_number_backups = s% max_number_backups
         max_number_retries = s% max_number_retries
         relax_max_number_retries = s% relax_max_number_retries
         relax_max_number_backups = s% relax_max_number_backups
         max_age = s% max_age
         max_age_in_seconds = s% max_age_in_seconds
         num_adjusted_dt_steps_before_max_age = s% num_adjusted_dt_steps_before_max_age
         dt_years_for_steps_before_max_age = s% dt_years_for_steps_before_max_age
         reduction_factor_for_max_timestep = s% reduction_factor_for_max_timestep
         when_to_stop_rtol = s% when_to_stop_rtol
         when_to_stop_atol = s% when_to_stop_atol
         gamma_center_limit = s% gamma_center_limit
         eta_center_limit = s% eta_center_limit
         log_center_temp_limit = s% log_center_temp_limit
         log_max_temp_upper_limit = s% log_max_temp_upper_limit
         log_max_temp_lower_limit = s% log_max_temp_lower_limit
         log_center_temp_lower_limit = s% log_center_temp_lower_limit
         log_center_density_limit = s% log_center_density_limit
         log_center_density_lower_limit = s% log_center_density_lower_limit
         min_timestep_limit = s% min_timestep_limit

         center_entropy_limit = s% center_entropy_limit
         center_entropy_lower_limit = s% center_entropy_lower_limit
         max_entropy_limit = s% max_entropy_limit
         max_entropy_lower_limit = s% max_entropy_lower_limit

         logQ_limit = s% logQ_limit
         fe_core_infall_limit = s% fe_core_infall_limit
         center_Ye_lower_limit = s% center_Ye_lower_limit
         non_fe_core_infall_limit = s% non_fe_core_infall_limit
         v_div_csound_surf_limit = s% v_div_csound_surf_limit
         Lnuc_div_L_upper_limit = s% Lnuc_div_L_upper_limit
         Lnuc_div_L_lower_limit = s% Lnuc_div_L_lower_limit
         v_surf_div_v_kh_upper_limit = s% v_surf_div_v_kh_upper_limit
         v_surf_div_v_kh_lower_limit = s% v_surf_div_v_kh_lower_limit
         v_surf_div_v_esc_limit = s% v_surf_div_v_esc_limit
         stop_near_zams = s% stop_near_zams
         Lnuc_div_L_zams_limit = s% Lnuc_div_L_zams_limit
         Pgas_div_P_limit = s% Pgas_div_P_limit
         Pgas_div_P_limit_max_q = s% Pgas_div_P_limit_max_q
         peak_burn_vconv_div_cs_limit = s% peak_burn_vconv_div_cs_limit
         omega_div_omega_crit_limit = s% omega_div_omega_crit_limit
         delta_nu_lower_limit = s% delta_nu_lower_limit
         delta_nu_upper_limit = s% delta_nu_upper_limit
         delta_Pg_lower_limit = s% delta_Pg_lower_limit
         delta_Pg_upper_limit = s% delta_Pg_upper_limit
         
         stop_when_done_with_piston = s% stop_when_done_with_piston
         stop_when_piston_v_goes_negative = s% stop_when_piston_v_goes_negative
         stop_when_done_with_center_flash = s% stop_when_done_with_center_flash

         surface_accel_div_grav_limit = s% surface_accel_div_grav_limit
         
         xa_central_lower_limit_species = s% xa_central_lower_limit_species
         xa_central_lower_limit = s% xa_central_lower_limit
         
         xa_central_upper_limit_species = s% xa_central_upper_limit_species
         xa_central_upper_limit = s% xa_central_upper_limit
         
         xa_surface_lower_limit_species = s% xa_surface_lower_limit_species
         xa_surface_lower_limit = s% xa_surface_lower_limit
         
         xa_surface_upper_limit_species = s% xa_surface_upper_limit_species
         xa_surface_upper_limit = s% xa_surface_upper_limit
         
         xa_average_lower_limit_species = s% xa_average_lower_limit_species
         xa_average_lower_limit = s% xa_average_lower_limit
         
         xa_average_upper_limit_species = s% xa_average_upper_limit_species
         xa_average_upper_limit = s% xa_average_upper_limit
         
         HB_limit = s% HB_limit
         stop_at_TP = s% stop_at_TP
         TP_he_shell_max = s% TP_he_shell_max
         
         star_mass_max_limit = s% star_mass_max_limit
         star_mass_min_limit = s% star_mass_min_limit
         star_H_mass_max_limit = s% star_H_mass_max_limit
         star_H_mass_min_limit = s% star_H_mass_min_limit
         star_He_mass_max_limit = s% star_He_mass_max_limit
         star_He_mass_min_limit = s% star_He_mass_min_limit
         star_C_mass_min_limit = s% star_C_mass_min_limit
         star_C_mass_max_limit = s% star_C_mass_max_limit
         xmstar_min_limit = s% xmstar_min_limit
         xmstar_max_limit = s% xmstar_max_limit
         envelope_mass_limit = s% envelope_mass_limit
         envelope_fraction_left_limit = s% envelope_fraction_left_limit
         
         he_core_mass_limit = s% he_core_mass_limit
         c_core_mass_limit = s% c_core_mass_limit
         o_core_mass_limit = s% o_core_mass_limit
         si_core_mass_limit = s% si_core_mass_limit
         fe_core_mass_limit = s% fe_core_mass_limit
         neutron_rich_core_mass_limit = s% neutron_rich_core_mass_limit
         
         he_layer_mass_lower_limit = s% he_layer_mass_lower_limit
         abs_diff_lg_LH_lg_Ls_limit = s% abs_diff_lg_LH_lg_Ls_limit
         Teff_upper_limit = s% Teff_upper_limit
         Teff_lower_limit = s% Teff_lower_limit
         photosphere_r_upper_limit = s% photosphere_r_upper_limit
         photosphere_r_lower_limit = s% photosphere_r_lower_limit
         log_Teff_upper_limit = s% log_Teff_upper_limit
         log_Teff_lower_limit = s% log_Teff_lower_limit
         log_Tsurf_upper_limit = s% log_Tsurf_upper_limit
         log_Tsurf_lower_limit = s% log_Tsurf_lower_limit
         log_Psurf_upper_limit = s% log_Psurf_upper_limit
         log_Psurf_lower_limit = s% log_Psurf_lower_limit
         log_Dsurf_upper_limit = s% log_Dsurf_upper_limit
         log_Dsurf_lower_limit = s% log_Dsurf_lower_limit
         log_L_upper_limit = s% log_L_upper_limit
         log_L_lower_limit = s% log_L_lower_limit
         log_g_upper_limit = s% log_g_upper_limit
         log_g_lower_limit = s% log_g_lower_limit
         
         power_nuc_burn_upper_limit = s% power_nuc_burn_upper_limit
         power_h_burn_upper_limit = s% power_h_burn_upper_limit
         power_he_burn_upper_limit = s% power_he_burn_upper_limit 
         power_c_burn_upper_limit = s% power_c_burn_upper_limit 
         power_nuc_burn_lower_limit = s% power_nuc_burn_lower_limit
         power_h_burn_lower_limit = s% power_h_burn_lower_limit
         power_he_burn_lower_limit = s% power_he_burn_lower_limit 
         power_c_burn_lower_limit = s% power_c_burn_lower_limit 
         
         phase_of_evolution_stop = s% phase_of_evolution_stop
         

         ! output of "snapshots" for restarts
         photostep = s% photostep
         photo_digits = s% photo_digits
         photo_directory = s% photo_directory
         ! output of history and profiles.
         do_history_file = s% do_history_file
         history_interval = s% history_interval
         
         write_header_frequency = s% write_header_frequency
         terminal_interval = s% terminal_interval
         terminal_cnt = s% terminal_cnt
         terminal_show_age_in_years = s% terminal_show_age_in_years
         extra_terminal_output_file = s% extra_terminal_output_file
         num_trace_history_values = s% num_trace_history_values
         trace_history_value_name = s% trace_history_value_name
         
         log_directory = s% log_directory
         
         star_history_name = s% star_history_name
         star_history_header_name = s% star_history_header_name
         star_history_dbl_format = s% star_history_dbl_format
         star_history_int_format = s% star_history_int_format
         star_history_txt_format = s% star_history_txt_format
         
         profiles_index_name = s% profiles_index_name
         profile_data_prefix = s% profile_data_prefix
         profile_data_suffix = s% profile_data_suffix
         profile_data_header_suffix = s% profile_data_header_suffix
         profile_int_format = s% profile_int_format
         profile_txt_format = s% profile_txt_format
         profile_dbl_format = s% profile_dbl_format
         write_profiles_flag = s% write_profiles_flag
         profile_interval = s% profile_interval
         priority_profile_interval = s% priority_profile_interval
         profile_model = s% profile_model
         max_num_profile_models = s% max_num_profile_models
         max_num_profile_zones = s% max_num_profile_zones
         mass_loc_for_extra_log_info = s% mass_loc_for_extra_log_info
         
         write_controls_info_with_profile = s% write_controls_info_with_profile
         controls_data_prefix = s% controls_data_prefix
         controls_data_suffix = s% controls_data_suffix
         
         write_pulse_info_with_profile = s% write_pulse_info_with_profile
         pulse_info_format = s% pulse_info_format
         add_atmosphere_to_pulse_info = s% add_atmosphere_to_pulse_info
         add_center_point_to_pulse_info = s% add_center_point_to_pulse_info
         keep_surface_point_for_pulse_info = s% keep_surface_point_for_pulse_info
         write_pulsation_plot_data = s% write_pulsation_plot_data
         max_num_gyre_points = s% max_num_gyre_points
         format_for_FGONG_data = s% format_for_FGONG_data
         format_for_OSC_data = s% format_for_OSC_data
         fgong_zero_A_inside_r = s% fgong_zero_A_inside_r
         
         write_model_with_profile = s% write_model_with_profile
         model_data_prefix = s% model_data_prefix
         model_data_suffix = s% model_data_suffix
         

         
         mixing_D_limit_for_log = s% mixing_D_limit_for_log
         trace_mass_location = s% trace_mass_location
         min_tau_for_max_abs_v_location = s% min_tau_for_max_abs_v_location
         min_q_for_inner_mach1_location = s% min_q_for_inner_mach1_location
         max_q_for_outer_mach1_location = s% max_q_for_outer_mach1_location
         
         ! burn zone eps definitions for use in logs and profiles
         burn_min1 = s% burn_min1
         burn_min2 = s% burn_min2
         
         max_conv_vel_div_csound_maxq = s% max_conv_vel_div_csound_maxq
         width_for_limit_conv_vel = s% width_for_limit_conv_vel
         max_q_for_limit_conv_vel = s% max_q_for_limit_conv_vel
         max_mass_in_gm_for_limit_conv_vel = s% max_mass_in_gm_for_limit_conv_vel
         max_r_in_cm_for_limit_conv_vel = s% max_r_in_cm_for_limit_conv_vel
         
         ! for reported average values
         surface_avg_abundance_dq = s% surface_avg_abundance_dq
         center_avg_value_dq = s% center_avg_value_dq
         
         ! mach1 location offsets
         mach1_plus_dr_factor = s% mach1_plus_dr_factor
         mach1_minus_dr_factor = s% mach1_minus_dr_factor
         
         ! definition of core overshooting boundary
         alpha_bdy_core_overshooting = s% alpha_bdy_core_overshooting
         
         ! mixing parameters
         min_convective_gap = s% min_convective_gap
         min_thermohaline_gap = s% min_thermohaline_gap
         min_semiconvection_gap = s% min_semiconvection_gap
         min_thermohaline_dropout = s% min_thermohaline_dropout
         max_dropout_gradL_sub_grada = s% max_dropout_gradL_sub_grada
         remove_embedded_semiconvection = s% remove_embedded_semiconvection
         remove_mixing_glitches = s% remove_mixing_glitches
         okay_to_remove_mixing_singleton = s% okay_to_remove_mixing_singleton
         prune_bad_cz_min_Hp_height = s% prune_bad_cz_min_Hp_height
         prune_bad_cz_min_log_eps_nuc = s% prune_bad_cz_min_log_eps_nuc
         redo_conv_for_dr_lt_mixing_length = s% redo_conv_for_dr_lt_mixing_length
         redo_mlt_for_OPEC = s% redo_mlt_for_OPEC
         limit_mixing_length_by_dist_to_bdy = s% limit_mixing_length_by_dist_to_bdy


         conv_bdy_mix_softening_f0 = s% conv_bdy_mix_softening_f0
         conv_bdy_mix_softening_f = s% conv_bdy_mix_softening_f
         conv_bdy_mix_softening_min_D_mix = s% conv_bdy_mix_softening_min_D_mix

         alpha_semiconvection = s% alpha_semiconvection
         semiconvection_upper_limit_center_h1 = s% semiconvection_upper_limit_center_h1
         semiconvection_option = s% semiconvection_option
         use_Ledoux_criterion = s% use_Ledoux_criterion
         redo_mix_info_at_each_iteration = s% redo_mix_info_at_each_iteration
         num_cells_for_smooth_gradL_composition_term = s% num_cells_for_smooth_gradL_composition_term
         clip_D_limit = s% clip_D_limit

         okay_to_reduce_gradT_excess = s% okay_to_reduce_gradT_excess
         gradT_excess_f1 = s% gradT_excess_f1
         gradT_excess_f2 = s% gradT_excess_f2
         gradT_excess_age_fraction = s% gradT_excess_age_fraction
         gradT_excess_max_change = s% gradT_excess_max_change
         gradT_excess_max_center_h1 = s% gradT_excess_max_center_h1
         gradT_excess_min_center_he4 = s% gradT_excess_min_center_he4
         gradT_excess_max_logT = s% gradT_excess_max_logT
         gradT_excess_min_log_tau_full_on = s% gradT_excess_min_log_tau_full_on
         gradT_excess_max_log_tau_full_off = s% gradT_excess_max_log_tau_full_off
         
         gradT_excess_lambda1 = s% gradT_excess_lambda1
         gradT_excess_beta1 = s% gradT_excess_beta1
         gradT_excess_lambda2 = s% gradT_excess_lambda2
         gradT_excess_beta2 = s% gradT_excess_beta2
         gradT_excess_dlambda = s% gradT_excess_dlambda
         gradT_excess_dbeta = s% gradT_excess_dbeta
         
         thermohaline_coeff = s% thermohaline_coeff
         thermohaline_option = s% thermohaline_option
         mixing_length_alpha = s% mixing_length_alpha
         remove_small_D_limit = s% remove_small_D_limit
         alt_scale_height_flag = s% alt_scale_height_flag
         Henyey_MLT_y_param = s% Henyey_MLT_y_param
         Henyey_MLT_nu_param = s% Henyey_MLT_nu_param
         MLT_option = s% MLT_option
         mlt_use_rotation_correction = s% mlt_use_rotation_correction

         overshoot_f_above_nonburn_core = s% overshoot_f_above_nonburn_core
         overshoot_f_above_nonburn_shell = s% overshoot_f_above_nonburn_shell
         overshoot_f_below_nonburn_shell = s% overshoot_f_below_nonburn_shell
         overshoot_f_above_burn_h_core = s% overshoot_f_above_burn_h_core
         overshoot_f_above_burn_h_shell = s% overshoot_f_above_burn_h_shell
         overshoot_f_below_burn_h_shell = s% overshoot_f_below_burn_h_shell
         overshoot_f_above_burn_he_core = s% overshoot_f_above_burn_he_core
         overshoot_f_above_burn_he_shell = s% overshoot_f_above_burn_he_shell
         overshoot_f_below_burn_he_shell = s% overshoot_f_below_burn_he_shell
         overshoot_f_above_burn_z_core = s% overshoot_f_above_burn_z_core
         overshoot_f_above_burn_z_shell = s% overshoot_f_above_burn_z_shell
         overshoot_f_below_burn_z_shell = s% overshoot_f_below_burn_z_shell

         step_overshoot_f_above_nonburn_core = s% step_overshoot_f_above_nonburn_core
         step_overshoot_f_above_nonburn_shell = s% step_overshoot_f_above_nonburn_shell
         step_overshoot_f_below_nonburn_shell = s% step_overshoot_f_below_nonburn_shell
         step_overshoot_f_above_burn_h_core = s% step_overshoot_f_above_burn_h_core
         step_overshoot_f_above_burn_h_shell = s% step_overshoot_f_above_burn_h_shell
         step_overshoot_f_below_burn_h_shell = s% step_overshoot_f_below_burn_h_shell
         step_overshoot_f_above_burn_he_core = s% step_overshoot_f_above_burn_he_core
         step_overshoot_f_above_burn_he_shell = s% step_overshoot_f_above_burn_he_shell
         step_overshoot_f_below_burn_he_shell = s% step_overshoot_f_below_burn_he_shell
         step_overshoot_f_above_burn_z_core = s% step_overshoot_f_above_burn_z_core
         step_overshoot_f_above_burn_z_shell = s% step_overshoot_f_above_burn_z_shell
         step_overshoot_f_below_burn_z_shell = s% step_overshoot_f_below_burn_z_shell

         overshoot_f0_above_nonburn_core = s% overshoot_f0_above_nonburn_core
         overshoot_f0_above_nonburn_shell = s% overshoot_f0_above_nonburn_shell
         overshoot_f0_below_nonburn_shell = s% overshoot_f0_below_nonburn_shell
         overshoot_f0_above_burn_h_core = s% overshoot_f0_above_burn_h_core
         overshoot_f0_above_burn_h_shell = s% overshoot_f0_above_burn_h_shell
         overshoot_f0_below_burn_h_shell = s% overshoot_f0_below_burn_h_shell
         overshoot_f0_above_burn_he_core = s% overshoot_f0_above_burn_he_core
         overshoot_f0_above_burn_he_shell = s% overshoot_f0_above_burn_he_shell
         overshoot_f0_below_burn_he_shell = s% overshoot_f0_below_burn_he_shell
         overshoot_f0_above_burn_z_core = s% overshoot_f0_above_burn_z_core
         overshoot_f0_above_burn_z_shell = s% overshoot_f0_above_burn_z_shell
         overshoot_f0_below_burn_z_shell = s% overshoot_f0_below_burn_z_shell
         
         step_overshoot_D = s% step_overshoot_D
         step_overshoot_D0_coeff = s% step_overshoot_D0_coeff
         
         overshoot_below_noburn_shell_factor = s% overshoot_below_noburn_shell_factor
         max_DUP_counter = s% max_DUP_counter
         
         ovr_below_burn_he_shell_factor = s% ovr_below_burn_he_shell_factor

         overshoot_D2_above_nonburn = s% overshoot_D2_above_nonburn
         overshoot_D2_below_nonburn = s% overshoot_D2_below_nonburn
         overshoot_D2_above_burn_h = s% overshoot_D2_above_burn_h
         overshoot_D2_below_burn_h = s% overshoot_D2_below_burn_h
         overshoot_D2_above_burn_he = s% overshoot_D2_above_burn_he
         overshoot_D2_below_burn_he = s% overshoot_D2_below_burn_he
         overshoot_D2_above_burn_z = s% overshoot_D2_above_burn_z
         overshoot_D2_below_burn_z = s% overshoot_D2_below_burn_z

         overshoot_f2_above_nonburn = s% overshoot_f2_above_nonburn
         overshoot_f2_below_nonburn = s% overshoot_f2_below_nonburn
         overshoot_f2_above_burn_h = s% overshoot_f2_above_burn_h
         overshoot_f2_below_burn_h = s% overshoot_f2_below_burn_h
         overshoot_f2_above_burn_he = s% overshoot_f2_above_burn_he
         overshoot_f2_below_burn_he = s% overshoot_f2_below_burn_he
         overshoot_f2_above_burn_z = s% overshoot_f2_above_burn_z
         overshoot_f2_below_burn_z = s% overshoot_f2_below_burn_z
         
         mass_for_overshoot_full_on = s% mass_for_overshoot_full_on
         mass_for_overshoot_full_off = s% mass_for_overshoot_full_off
         
         smooth_convective_bdy = s% smooth_convective_bdy
         max_dR_div_Hp_for_smooth = s% max_dR_div_Hp_for_smooth
         max_delta_limit_for_smooth = s% max_delta_limit_for_smooth
         min_T_for_acceleration_limited_conv_velocity = s% min_T_for_acceleration_limited_conv_velocity
         mlt_accel_g_theta = s% mlt_accel_g_theta
         max_conv_vel_div_csound = s% max_conv_vel_div_csound

         calculate_Brunt_N2 = s% calculate_Brunt_N2
         brunt_N2_coefficient = s% brunt_N2_coefficient
         num_cells_for_smooth_brunt_B = s% num_cells_for_smooth_brunt_B
         use_brunt_dlnRho_form = s% use_brunt_dlnRho_form
         use_brunt_gradmuX_form = s% use_brunt_gradmuX_form
         interpolate_rho_for_pulsation_info = s% interpolate_rho_for_pulsation_info
         min_magnitude_brunt_B = s% min_magnitude_brunt_B

         min_overshoot_q = s% min_overshoot_q
         D_mix_ov_limit = s% D_mix_ov_limit
         max_brunt_B_for_overshoot = s% max_brunt_B_for_overshoot
         overshoot_alpha = s% overshoot_alpha
         
         radiation_turbulence_coeff = s% radiation_turbulence_coeff
         turbulent_diffusion_D0 = s% turbulent_diffusion_D0
         turbulent_diffusion_rho_max = s% turbulent_diffusion_rho_max
         
         T_mix_limit = s% T_mix_limit
         conv_dP_term_factor = s% conv_dP_term_factor
         
         ! atmosphere -- surface boundary conditions
         which_atm_option = s% which_atm_option
         which_atm_off_table_option = s% which_atm_off_table_option
         atm_switch_to_grey_as_backup = s% atm_switch_to_grey_as_backup
         Pextra_factor = s% Pextra_factor
         atm_fixed_Teff = s% atm_fixed_Teff
         atm_fixed_Psurf = s% atm_fixed_Psurf
         atm_fixed_Tsurf = s% atm_fixed_Tsurf
         
         atm_grey_and_kap_atol = s% atm_grey_and_kap_atol
         atm_grey_and_kap_rtol = s% atm_grey_and_kap_rtol
         atm_grey_and_kap_max_tries = s% atm_grey_and_kap_max_tries
         trace_atm_grey_and_kap = s% trace_atm_grey_and_kap

         atm_grey_irradiated_atol = s% atm_grey_irradiated_atol
         atm_grey_irradiated_rtol = s% atm_grey_irradiated_rtol
         atm_grey_irradiated_T_eq = s% atm_grey_irradiated_T_eq
         atm_grey_irradiated_kap_v = s% atm_grey_irradiated_kap_v
         atm_grey_irradiated_simple_kap_th = s% atm_grey_irradiated_simple_kap_th
         atm_grey_irr_kap_v_div_kap_th = s% atm_grey_irr_kap_v_div_kap_th
         atm_grey_irradiated_P_surf = s% atm_grey_irradiated_P_surf
         atm_grey_irradiated_max_tries = s% atm_grey_irradiated_max_tries
         trace_atm_grey_irradiated = s% trace_atm_grey_irradiated
         
         atm_int_errtol = s% atm_int_errtol
         dump_int_atm_info_model_number = s% dump_int_atm_info_model_number

         surface_extra_Pgas = s% surface_extra_Pgas
         use_atm_PT_at_center_of_surface_cell = s% use_atm_PT_at_center_of_surface_cell
         use_hydrodynamic_surface_BCs = s% use_hydrodynamic_surface_BCs
         use_momentum_eqn_outer_BC = s% use_momentum_eqn_outer_BC
         
         create_atm_max_step_size = s% create_atm_max_step_size
         Paczynski_atm_R_surf_errtol = s% Paczynski_atm_R_surf_errtol
         trace_atm_Paczynski_grey = s% trace_atm_Paczynski_grey

         
         ! extra heat near surface to model irradiation         
         irradiation_flux = s% irradiation_flux
         column_depth_for_irradiation = s% column_depth_for_irradiation
         
         ! extra heat
         inject_uniform_extra_heat = s% inject_uniform_extra_heat
         min_q_for_uniform_extra_heat = s% min_q_for_uniform_extra_heat
         max_q_for_uniform_extra_heat = s% max_q_for_uniform_extra_heat
         inject_extra_ergs_sec = s% inject_extra_ergs_sec
         base_of_inject_extra_ergs_sec = s% base_of_inject_extra_ergs_sec
         total_mass_for_inject_extra_ergs_sec = s% total_mass_for_inject_extra_ergs_sec
         start_time_for_inject_extra_ergs_sec = s% start_time_for_inject_extra_ergs_sec
         duration_for_inject_extra_ergs_sec = s% duration_for_inject_extra_ergs_sec
         inject_until_reach_delta_total_energy = s% inject_until_reach_delta_total_energy
         
         ! mass gain or loss
         mass_change = s% mass_change
         mass_change_full_off_dt = s% mass_change_full_off_dt
         mass_change_full_on_dt = s% mass_change_full_on_dt
         trace_dt_control_mass_change = s% trace_dt_control_mass_change
         no_wind_if_no_rotation = s% no_wind_if_no_rotation
         
         min_abs_mdot_for_change_limits = s% min_abs_mdot_for_change_limits
         max_abs_mdot_factor = s% max_abs_mdot_factor
         min_abs_mdot_factor = s% min_abs_mdot_factor
         min_wind = s% min_wind
         max_wind = s% max_wind
         use_accreted_material_j = s% use_accreted_material_j
         accreted_material_j = s% accreted_material_j
         mdot_omega_power = s% mdot_omega_power
         max_rotational_mdot_boost = s% max_rotational_mdot_boost
         max_mdot_jump_for_rotation = s% max_mdot_jump_for_rotation
         lim_trace_rotational_mdot_boost = s% lim_trace_rotational_mdot_boost
         rotational_mdot_boost_fac = s% rotational_mdot_boost_fac
         rotational_mdot_kh_fac = s% rotational_mdot_kh_fac
         surf_avg_tau = s% surf_avg_tau
         surf_avg_tau_min = s% surf_avg_tau_min
         
         remove_H_wind_mdot = s% remove_H_wind_mdot
         remove_H_wind_H_mass_limit = s% remove_H_wind_H_mass_limit
         super_eddington_wind_eta = s% super_eddington_wind_eta
         super_eddington_wind_Ledd_factor = s% super_eddington_wind_Ledd_factor
         wind_boost_full_off_L_div_Ledd = s% wind_boost_full_off_L_div_Ledd
         wind_boost_full_on_L_div_Ledd = s% wind_boost_full_on_L_div_Ledd
         super_eddington_wind_max_boost = s% super_eddington_wind_max_boost
         trace_super_eddington_wind_boost = s% trace_super_eddington_wind_boost
         
         flash_wind_mdot = s% flash_wind_mdot
         flash_wind_starts = s% flash_wind_starts
         flash_wind_declines = s% flash_wind_declines
         flash_wind_full_off = s% flash_wind_full_off

         rlo_wind_eta = s% rlo_wind_eta
         rlo_wind_min_L = s% rlo_wind_min_L
         rlo_wind_max_Teff = s% rlo_wind_max_Teff
         rlo_wind_roche_lobe_radius = s% rlo_wind_roche_lobe_radius
         roche_lobe_xfer_full_on = s% roche_lobe_xfer_full_on
         roche_lobe_xfer_full_off = s% roche_lobe_xfer_full_off
         rlo_wind_base_mdot = s% rlo_wind_base_mdot
         rlo_wind_scale_height = s% rlo_wind_scale_height
         
         nova_wind_eta = s% nova_wind_eta
         nova_wind_b = s% nova_wind_b
         nova_wind_max_Teff = s% nova_wind_max_Teff
         nova_wind_min_L = s% nova_wind_min_L
         nova_min_Teff_for_accretion = s% nova_min_Teff_for_accretion
         nova_roche_lobe_radius = s% nova_roche_lobe_radius
         nova_RLO_mdot = s% nova_RLO_mdot
         
         RGB_wind_scheme = s% RGB_wind_scheme
         AGB_wind_scheme = s% AGB_wind_scheme
         RGB_to_AGB_wind_switch = s% RGB_to_AGB_wind_switch
         Reimers_wind_eta = s% Reimers_wind_eta
         Blocker_wind_eta = s% Blocker_wind_eta
         de_Jager_wind_eta = s% de_Jager_wind_eta
         van_Loon_wind_eta = s% van_Loon_wind_eta
         Nieuwenhuijzen_wind_eta = s% Nieuwenhuijzen_wind_eta
         Vink_wind_eta = s% Vink_wind_eta
         Grafener_wind_eta = s% Grafener_wind_eta
         Kudritzki_wind_eta = s% Kudritzki_wind_eta
         Dutch_wind_eta = s% Dutch_wind_eta
         Dutch_wind_lowT_scheme = s% Dutch_wind_lowT_scheme
         Stern51_wind_eta = s% Stern51_wind_eta
         
         wind_envelope_limit = s% wind_envelope_limit
         clip_small_mdots = s% clip_small_mdots
         
         max_logT_for_k_below_const_q = s% max_logT_for_k_below_const_q
         max_q_for_k_below_const_q = s% max_q_for_k_below_const_q
         min_q_for_k_below_const_q = s% min_q_for_k_below_const_q
         max_logT_for_k_const_mass = s% max_logT_for_k_const_mass
         min_q_for_k_const_mass = s% min_q_for_k_const_mass
         max_q_for_k_const_mass = s% max_q_for_k_const_mass
         
         ! composition of added mass
         accrete_same_as_surface = s% accrete_same_as_surface
         
         accrete_given_mass_fractions = s% accrete_given_mass_fractions
         num_accretion_species = s% num_accretion_species
         accretion_species_id = s% accretion_species_id
         accretion_species_xa = s% accretion_species_xa
         
         accretion_h1 = s% accretion_h1
         accretion_h2 = s% accretion_h2
         accretion_he3 = s% accretion_he3
         accretion_he4 = s% accretion_he4
         accretion_zfracs = s% accretion_zfracs
         accretion_dump_missing_metals_into_heaviest = s% accretion_dump_missing_metals_into_heaviest
         
         ! special list of z fractions
         z_fraction_li = s% z_fraction_li
         z_fraction_be = s% z_fraction_be
         z_fraction_b  = s% z_fraction_b
         z_fraction_c  = s% z_fraction_c
         z_fraction_n  = s% z_fraction_n
         z_fraction_o  = s% z_fraction_o
         z_fraction_f  = s% z_fraction_f
         z_fraction_ne = s% z_fraction_ne
         z_fraction_na = s% z_fraction_na
         z_fraction_mg = s% z_fraction_mg
         z_fraction_al = s% z_fraction_al
         z_fraction_si = s% z_fraction_si
         z_fraction_p  = s% z_fraction_p
         z_fraction_s  = s% z_fraction_s
         z_fraction_cl = s% z_fraction_cl
         z_fraction_ar = s% z_fraction_ar
         z_fraction_k  = s% z_fraction_k
         z_fraction_ca = s% z_fraction_ca
         z_fraction_sc = s% z_fraction_sc
         z_fraction_ti = s% z_fraction_ti
         z_fraction_v  = s% z_fraction_v
         z_fraction_cr = s% z_fraction_cr
         z_fraction_mn = s% z_fraction_mn
         z_fraction_fe = s% z_fraction_fe
         z_fraction_co = s% z_fraction_co
         z_fraction_ni = s% z_fraction_ni
         z_fraction_cu = s% z_fraction_cu
         z_fraction_zn = s% z_fraction_zn
         
         pure_fe56_limit = s% pure_fe56_limit
         lgT_lo_for_set_new_abundances = s% lgT_lo_for_set_new_abundances
         lgT_hi_for_set_new_abundances = s% lgT_hi_for_set_new_abundances
   
         ! automatic stops for mass loss/gain
         max_star_mass_for_gain = s% max_star_mass_for_gain
         min_star_mass_for_loss = s% min_star_mass_for_loss
         max_T_center_for_any_mass_loss = s% max_T_center_for_any_mass_loss
         max_T_center_for_full_mass_loss = s% max_T_center_for_full_mass_loss
         
         ! relaxation parameters
         extra_power_source = s% extra_power_source
         relax_dlnZ = s% relax_dlnZ
         relax_dY = s% relax_dY
         
         ! mesh adjustment
         remesh_log_L_nuc_burn_min = s% remesh_log_L_nuc_burn_min
         show_mesh_changes = s% show_mesh_changes
         okay_to_remesh = s% okay_to_remesh
         trace_mesh_adjust_error_in_conservation = &
            s% trace_mesh_adjust_error_in_conservation
         remesh_max_brunt_N2_composition_term = s% remesh_max_brunt_N2_composition_term
         remesh_cnt = s% remesh_cnt
         max_allowed_nz = s% max_allowed_nz
         mesh_max_allowed_ratio = s% mesh_max_allowed_ratio
         remesh_max_allowed_logT = s% remesh_max_allowed_logT
         max_delta_x_for_merge = s% max_delta_x_for_merge
         mesh_dump_call_number = s% mesh_dump_call_number
         
         mesh_adjust_use_quadratic = s% mesh_adjust_use_quadratic
         mesh_adjust_get_T_from_E = s% mesh_adjust_get_T_from_E

         max_dq = s% max_dq
         min_dq = s% min_dq
         min_dq_for_xa = s% min_dq_for_xa
         mesh_min_dlnR = s% mesh_min_dlnR
         merge_if_dlnR_too_small = s% merge_if_dlnR_too_small
         mesh_min_dr_div_cs = s% mesh_min_dr_div_cs
         merge_if_dr_div_cs_too_small = s% merge_if_dr_div_cs_too_small

         max_center_cell_dq = s% max_center_cell_dq
         max_surface_cell_dq = s% max_surface_cell_dq
         max_num_subcells = s% max_num_subcells
         max_num_merge_cells = s% max_num_merge_cells

         mesh_delta_coeff = s% mesh_delta_coeff
         mesh_delta_coeff_pre_ms = s% mesh_delta_coeff_pre_ms
         mesh_delta_coeff_for_highT = s% mesh_delta_coeff_for_highT
         logT_max_for_standard_mesh_delta_coeff = s% logT_max_for_standard_mesh_delta_coeff
         logT_min_for_highT_mesh_delta_coeff = s% logT_min_for_highT_mesh_delta_coeff
         
         mesh_Pgas_div_P_exponent = s% mesh_Pgas_div_P_exponent
         
         remesh_dt_limit = s% remesh_dt_limit

   		P_function_weight = s% P_function_weight
         
         xtra_coef_above_xtrans = s% xtra_coef_above_xtrans
         xtra_coef_below_xtrans = s% xtra_coef_below_xtrans
         xtra_dist_above_xtrans = s% xtra_dist_above_xtrans
         
         xtra_coef_czb_full_on = s% xtra_coef_czb_full_on
         xtra_coef_czb_full_off = s% xtra_coef_czb_full_off         
   		   		
         xtra_coef_a_l_nb_czb = s% xtra_coef_a_l_nb_czb
         xtra_coef_a_l_hb_czb = s% xtra_coef_a_l_hb_czb
         xtra_coef_a_l_heb_czb = s% xtra_coef_a_l_heb_czb
         xtra_coef_a_l_zb_czb = s% xtra_coef_a_l_zb_czb

         xtra_coef_b_l_nb_czb = s% xtra_coef_b_l_nb_czb
         xtra_coef_b_l_hb_czb = s% xtra_coef_b_l_hb_czb
         xtra_coef_b_l_heb_czb = s% xtra_coef_b_l_heb_czb
         xtra_coef_b_l_zb_czb = s% xtra_coef_b_l_zb_czb

         xtra_coef_a_u_nb_czb = s% xtra_coef_a_u_nb_czb
         xtra_coef_a_u_hb_czb = s% xtra_coef_a_u_hb_czb
         xtra_coef_a_u_heb_czb = s% xtra_coef_a_u_heb_czb
         xtra_coef_a_u_zb_czb = s% xtra_coef_a_u_zb_czb

         xtra_coef_b_u_nb_czb = s% xtra_coef_b_u_nb_czb
         xtra_coef_b_u_hb_czb = s% xtra_coef_b_u_hb_czb
         xtra_coef_b_u_heb_czb = s% xtra_coef_b_u_heb_czb
         xtra_coef_b_u_zb_czb = s% xtra_coef_b_u_zb_czb

         xtra_dist_a_l_nb_czb = s% xtra_dist_a_l_nb_czb
         xtra_dist_a_l_hb_czb = s% xtra_dist_a_l_hb_czb
         xtra_dist_a_l_heb_czb = s% xtra_dist_a_l_heb_czb
         xtra_dist_a_l_zb_czb = s% xtra_dist_a_l_zb_czb

         xtra_dist_b_l_nb_czb = s% xtra_dist_b_l_nb_czb
         xtra_dist_b_l_hb_czb = s% xtra_dist_b_l_hb_czb
         xtra_dist_b_l_heb_czb = s% xtra_dist_b_l_heb_czb
         xtra_dist_b_l_zb_czb = s% xtra_dist_b_l_zb_czb

         xtra_dist_a_u_nb_czb = s% xtra_dist_a_u_nb_czb
         xtra_dist_a_u_hb_czb = s% xtra_dist_a_u_hb_czb
         xtra_dist_a_u_heb_czb = s% xtra_dist_a_u_heb_czb
         xtra_dist_a_u_zb_czb = s% xtra_dist_a_u_zb_czb

         xtra_dist_b_u_nb_czb = s% xtra_dist_b_u_nb_czb
         xtra_dist_b_u_hb_czb = s% xtra_dist_b_u_hb_czb
         xtra_dist_b_u_heb_czb = s% xtra_dist_b_u_heb_czb
         xtra_dist_b_u_zb_czb = s% xtra_dist_b_u_zb_czb
         
         xtra_coef_scz_above_nb_cz = s% xtra_coef_scz_above_nb_cz
         xtra_coef_scz_above_hb_cz = s% xtra_coef_scz_above_hb_cz
         xtra_coef_scz_above_heb_cz = s% xtra_coef_scz_above_heb_cz
         xtra_coef_scz_above_zb_cz = s% xtra_coef_scz_above_zb_cz
         
         xtra_coef_os_full_on = s% xtra_coef_os_full_on
         xtra_coef_os_full_off = s% xtra_coef_os_full_off

         xtra_coef_os_above_nonburn = s% xtra_coef_os_above_nonburn
         xtra_coef_os_below_nonburn = s% xtra_coef_os_below_nonburn
         xtra_coef_os_above_burn_h = s% xtra_coef_os_above_burn_h
         xtra_coef_os_below_burn_h = s% xtra_coef_os_below_burn_h
         xtra_coef_os_above_burn_he = s% xtra_coef_os_above_burn_he
         xtra_coef_os_below_burn_he = s% xtra_coef_os_below_burn_he
         xtra_coef_os_above_burn_z = s% xtra_coef_os_above_burn_z
         xtra_coef_os_below_burn_z = s% xtra_coef_os_below_burn_z
         
         xtra_dist_os_above_nonburn = s% xtra_dist_os_above_nonburn
         xtra_dist_os_below_nonburn = s% xtra_dist_os_below_nonburn
         xtra_dist_os_above_burn_h = s% xtra_dist_os_above_burn_h
         xtra_dist_os_below_burn_h = s% xtra_dist_os_below_burn_h
         xtra_dist_os_above_burn_he = s% xtra_dist_os_above_burn_he
         xtra_dist_os_below_burn_he = s% xtra_dist_os_below_burn_he
         xtra_dist_os_above_burn_z = s% xtra_dist_os_above_burn_z
         xtra_dist_os_below_burn_z = s% xtra_dist_os_below_burn_z


         mesh_logX_species = s% mesh_logX_species
         mesh_logX_min_for_extra = s% mesh_logX_min_for_extra
         mesh_dlogX_dlogP_extra = s% mesh_dlogX_dlogP_extra
         mesh_dlogX_dlogP_full_on = s% mesh_dlogX_dlogP_full_on
         mesh_dlogX_dlogP_full_off = s% mesh_dlogX_dlogP_full_off

         convective_bdy_min_dt_yrs = s% convective_bdy_min_dt_yrs
         convective_bdy_weight = s% convective_bdy_weight
         convective_bdy_dq_limit = s% convective_bdy_dq_limit
         
         mesh_dlog_eps_min_for_extra = s% mesh_dlog_eps_min_for_extra
         mesh_dlog_eps_dlogP_full_on = s% mesh_dlog_eps_dlogP_full_on
         mesh_dlog_eps_dlogP_full_off = s% mesh_dlog_eps_dlogP_full_off

         mesh_dlog_pp_dlogP_extra = s% mesh_dlog_pp_dlogP_extra
         mesh_dlog_cno_dlogP_extra = s% mesh_dlog_cno_dlogP_extra
         mesh_dlog_3alf_dlogP_extra = s% mesh_dlog_3alf_dlogP_extra
      
         mesh_dlog_burn_c_dlogP_extra = s% mesh_dlog_burn_c_dlogP_extra
         mesh_dlog_burn_n_dlogP_extra = s% mesh_dlog_burn_n_dlogP_extra
         mesh_dlog_burn_o_dlogP_extra = s% mesh_dlog_burn_o_dlogP_extra
         mesh_dlog_burn_ne_dlogP_extra = s% mesh_dlog_burn_ne_dlogP_extra
         mesh_dlog_burn_na_dlogP_extra = s% mesh_dlog_burn_na_dlogP_extra
         mesh_dlog_burn_mg_dlogP_extra = s% mesh_dlog_burn_mg_dlogP_extra
         mesh_dlog_burn_si_dlogP_extra = s% mesh_dlog_burn_si_dlogP_extra
         mesh_dlog_burn_s_dlogP_extra = s% mesh_dlog_burn_s_dlogP_extra
         mesh_dlog_burn_ar_dlogP_extra = s% mesh_dlog_burn_ar_dlogP_extra
         mesh_dlog_burn_ca_dlogP_extra = s% mesh_dlog_burn_ca_dlogP_extra
         mesh_dlog_burn_ti_dlogP_extra = s% mesh_dlog_burn_ti_dlogP_extra
         mesh_dlog_burn_cr_dlogP_extra = s% mesh_dlog_burn_cr_dlogP_extra
         mesh_dlog_burn_fe_dlogP_extra = s% mesh_dlog_burn_fe_dlogP_extra
      
         mesh_dlog_cc_dlogP_extra = s% mesh_dlog_cc_dlogP_extra
         mesh_dlog_co_dlogP_extra = s% mesh_dlog_co_dlogP_extra
         mesh_dlog_oo_dlogP_extra = s% mesh_dlog_oo_dlogP_extra
      
         mesh_dlog_pnhe4_dlogP_extra = s% mesh_dlog_pnhe4_dlogP_extra
         mesh_dlog_photo_dlogP_extra = s% mesh_dlog_photo_dlogP_extra
         mesh_dlog_other_dlogP_extra = s% mesh_dlog_other_dlogP_extra

   		T_function1_weight = s% T_function1_weight
   		T_function2_weight = s% T_function2_weight
   		T_function2_param = s% T_function2_param
      
   		R_function_weight = s% R_function_weight
   		R_function_param = s% R_function_param
      
   		R_function2_weight = s% R_function2_weight
   		R_function2_param1 = s% R_function2_param1
   		R_function2_param2 = s% R_function2_param2
      
   		M_function_weight = s% M_function_weight
   		M_function_param = s% M_function_param
   		
   		gradT_function_weight = s% gradT_function_weight
   		log_tau_function_weight = s% log_tau_function_weight
   		log_kap_function_weight = s% log_kap_function_weight
   		omega_function_weight = s% omega_function_weight

   		gam_function_weight = s% gam_function_weight
   		gam_function_param1 = s% gam_function_param1
   		gam_function_param2 = s% gam_function_param2
         
   		xa_function_species = s% xa_function_species
   		xa_function_weight = s% xa_function_weight
   		xa_function_param = s% xa_function_param
   		xa_mesh_delta_coeff = s% xa_mesh_delta_coeff


         ! nuclear reaction parameters
         screening_mode = s% screening_mode
         default_net_name = s% default_net_name
         
         net_logTcut_lo = s% net_logTcut_lo
         net_logTcut_lim = s% net_logTcut_lim

         eps_nuc_factor = s% eps_nuc_factor
         max_abs_eps_nuc = s% max_abs_eps_nuc
         dxdt_nuc_factor = s% dxdt_nuc_factor
         max_abar_for_burning = s% max_abar_for_burning
         fe56ec_fake_factor = s% fe56ec_fake_factor
         weak_rate_factor = s% weak_rate_factor
         
         mix_factor = s% mix_factor
         
         sig_term_limit = s% sig_term_limit

         sig_min_factor_for_high_Tcenter = s% sig_min_factor_for_high_Tcenter
         Tcenter_min_for_sig_min_factor_full_on = s% Tcenter_min_for_sig_min_factor_full_on
         Tcenter_max_for_sig_min_factor_full_off = s% Tcenter_max_for_sig_min_factor_full_off
         max_delta_m_to_bdy_for_sig_min_factor = s% max_delta_m_to_bdy_for_sig_min_factor
         delta_m_lower_for_sig_min_factor = s% delta_m_lower_for_sig_min_factor
         delta_m_upper_for_sig_min_factor = s% delta_m_upper_for_sig_min_factor
         Tcenter_max_for_dble_bcyclic = s% Tcenter_max_for_dble_bcyclic
         
         am_sig_term_limit = s% am_sig_term_limit
         am_D_mix_factor = s% am_D_mix_factor
         am_gradmu_factor = s% am_gradmu_factor
         am_nu_factor = s% am_nu_factor
         
         D_visc_factor = s% D_visc_factor
         D_DSI_factor = s% D_DSI_factor
         D_SH_factor = s% D_SH_factor
         D_SSI_factor = s% D_SSI_factor
         D_ES_factor = s% D_ES_factor
         D_GSF_factor = s% D_GSF_factor
         D_ST_factor = s% D_ST_factor

         am_nu_non_rotation_factor = s% am_nu_non_rotation_factor
         skip_rotation_in_convection_zones = s% skip_rotation_in_convection_zones
         am_nu_DSI_factor = s% am_nu_DSI_factor
         am_nu_SH_factor = s% am_nu_SH_factor
         am_nu_SSI_factor = s% am_nu_SSI_factor
         am_nu_ES_factor = s% am_nu_ES_factor
         am_nu_GSF_factor = s% am_nu_GSF_factor
         am_nu_ST_factor = s% am_nu_ST_factor
         am_nu_visc_factor = s% am_nu_visc_factor
         
         am_nu_omega_rot_factor = s% am_nu_omega_rot_factor
         am_nu_omega_non_rot_factor = s% am_nu_omega_non_rot_factor
         am_nu_j_rot_factor = s% am_nu_j_rot_factor
         am_nu_j_non_rot_factor = s% am_nu_j_non_rot_factor
         
         smooth_nu_ST = s% smooth_nu_ST
         smooth_D_ST = s% smooth_D_ST
         smooth_D_DSI = s% smooth_D_DSI
         smooth_D_SSI = s% smooth_D_SSI
         smooth_D_SH = s% smooth_D_SH
         smooth_D_GSF = s% smooth_D_GSF
         smooth_D_ES = s% smooth_D_ES
         
         angsmt_D_DSI = s% angsmt_D_DSI
         angsmt_D_SH = s% angsmt_D_SH
         angsmt_D_SSI = s% angsmt_D_SSI
         angsmt_D_ES = s% angsmt_D_ES
         angsmt_D_GSF = s% angsmt_D_GSF
         angsmt_D_ST = s% angsmt_D_ST
         angsmt_nu_ST = s% angsmt_nu_ST
         angsml = s% angsml
         am_time_average = s% am_time_average
         simple_i_rot_flag = s% simple_i_rot_flag
         do_adjust_J_lost = s% do_adjust_J_lost
         premix_omega = s% premix_omega
         adjust_J_fraction = s% adjust_J_fraction
         max_mdot_redo_cnt = s% max_mdot_redo_cnt
         mdot_revise_factor = s% mdot_revise_factor
         implicit_mdot_boost = s% implicit_mdot_boost
         min_years_dt_for_redo_mdot = s% min_years_dt_for_redo_mdot
         surf_w_div_w_crit_limit = s% surf_w_div_w_crit_limit
         surf_w_div_w_crit_tol = S% surf_w_div_w_crit_tol
         fp_min = s% fp_min
         ft_min = s% ft_min
         fp_error_limit = s% fp_error_limit
         ft_error_limit = s% ft_error_limit

         D_mix_rotation_max_logT_full_on = s% D_mix_rotation_max_logT_full_on
         D_mix_rotation_min_logT_full_off = s% D_mix_rotation_min_logT_full_off
         
         set_uniform_am_nu_non_rot = s% set_uniform_am_nu_non_rot
         uniform_am_nu_non_rot = s% uniform_am_nu_non_rot
         
         set_min_am_nu_non_rot = s% set_min_am_nu_non_rot
         min_am_nu_non_rot = s% min_am_nu_non_rot
         min_center_Ye_for_min_am_nu_non_rot = s% min_center_Ye_for_min_am_nu_non_rot
         
         set_min_D_mix = s% set_min_D_mix
         min_D_mix = s% min_D_mix
         min_center_Ye_for_min_D_mix = s% min_center_Ye_for_min_D_mix
         reaction_neuQs_factor = s% reaction_neuQs_factor
         
         op_split_gradT_fraction_grada = s% op_split_gradT_fraction_grada

         smooth_outer_xa_big = s% smooth_outer_xa_big
         smooth_outer_xa_small = s% smooth_outer_xa_small

         ! element diffusion parameters
         diffusion_use_iben_macdonald = s% diffusion_use_iben_macdonald
         do_element_diffusion = s% do_element_diffusion
         diffusion_min_dq_at_surface = s% diffusion_min_dq_at_surface
         diffusion_min_T_at_surface = s% diffusion_min_T_at_surface
         diffusion_min_dq_ratio_at_surface = s% diffusion_min_dq_ratio_at_surface
         diffusion_dt_limit = s% diffusion_dt_limit

         diffusion_min_X_hard_limit = s% diffusion_min_X_hard_limit
         diffusion_X_total_atol = s% diffusion_X_total_atol
         diffusion_X_total_rtol = s% diffusion_X_total_rtol
         diffusion_upwind_abs_v_limit = s% diffusion_upwind_abs_v_limit
         diffusion_dt_div_timescale = s% diffusion_dt_div_timescale
         diffusion_min_num_substeps = s% diffusion_min_num_substeps
         diffusion_max_iters_per_substep = s% diffusion_max_iters_per_substep
         diffusion_max_retries_per_substep = s% diffusion_max_retries_per_substep
         diffusion_v_max = s% diffusion_v_max
         diffusion_gamma_full_off = s% diffusion_gamma_full_off
         diffusion_gamma_full_on = s% diffusion_gamma_full_on
         diffusion_T_full_off = s% diffusion_T_full_off
         diffusion_T_full_on = s% diffusion_T_full_on
         diffusion_calculates_ionization = s% diffusion_calculates_ionization
         diffusion_nsmooth_typical_charge = s% diffusion_nsmooth_typical_charge
         diffusion_tol_correction_max = s% diffusion_tol_correction_max
         diffusion_tol_correction_norm = s% diffusion_tol_correction_norm
         
         diffusion_AD_dm_full_on = s% diffusion_AD_dm_full_on
         diffusion_AD_dm_full_off = s% diffusion_AD_dm_full_off
         diffusion_AD_boost_factor = s% diffusion_AD_boost_factor
         
         diffusion_SIG_factor = s% diffusion_SIG_factor
         diffusion_GT_factor = s% diffusion_GT_factor
         
         diffusion_Vlimit_dm_full_on = s% diffusion_Vlimit_dm_full_on
         diffusion_Vlimit_dm_full_off = s% diffusion_Vlimit_dm_full_off
         diffusion_Vlimit = s% diffusion_Vlimit

         diffusion_max_T_for_radaccel = s% diffusion_max_T_for_radaccel
         diffusion_min_T_for_radaccel = s% diffusion_min_T_for_radaccel
         diffusion_screening_for_radaccel = s% diffusion_screening_for_radaccel
         op_mono_data_path = s% op_mono_data_path
         op_mono_data_cache_filename = s% op_mono_data_cache_filename
         
         show_diffusion_info = s% show_diffusion_info
         show_diffusion_substep_info = s% show_diffusion_substep_info
         show_diffusion_timing = s% show_diffusion_timing
         
         diffusion_num_classes = s% diffusion_num_classes
         diffusion_class_representative = s% diffusion_class_representative
         diffusion_class_A_max = s% diffusion_class_A_max
         diffusion_class_typical_charge = s% diffusion_class_typical_charge
         diffusion_class_factor = s% diffusion_class_factor
         
         diffusion_use_isolve = s% diffusion_use_isolve
         diffusion_rtol_for_isolve = s% diffusion_rtol_for_isolve
         diffusion_atol_for_isolve = s% diffusion_atol_for_isolve
         diffusion_maxsteps_for_isolve = s% diffusion_maxsteps_for_isolve
         diffusion_isolve_solver = s% diffusion_isolve_solver

         ! eos controls
         use_fixed_XZ_for_eos = s% use_fixed_XZ_for_eos
         fixed_X_for_eos = s% fixed_X_for_eos
         fixed_Z_for_eos = s% fixed_Z_for_eos
         
         use_eosDE_get = s% use_eosDE_get
         
         use_eosDT_ideal_gas = s% use_eosDT_ideal_gas
         use_eosDT_HELMEOS = s% use_eosDT_HELMEOS        
         eosDT_HELMEOS_include_radiation = s% eosDT_HELMEOS_include_radiation
         eosDT_HELMEOS_always_skip_elec_pos = s% eosDT_HELMEOS_always_skip_elec_pos

         ! opacity controls
         
         cubic_interpolation_in_X = s% cubic_interpolation_in_X
         cubic_interpolation_in_Z = s% cubic_interpolation_in_Z
         include_electron_conduction = s% include_electron_conduction
         
         use_simple_es_for_kap = s% use_simple_es_for_kap
         Zbase = s% Zbase
         use_Type2_opacities = s% use_Type2_opacities
         kap_Type2_full_off_X = s% kap_Type2_full_off_X
         kap_Type2_full_on_X = s% kap_Type2_full_on_X
         kap_Type2_full_off_dZ = s% kap_Type2_full_off_dZ
         kap_Type2_full_on_dZ = s% kap_Type2_full_on_dZ
         low_logT_op_mono_full_off = s% low_logT_op_mono_full_off
         low_logT_op_mono_full_on = s% low_logT_op_mono_full_on
         high_logT_op_mono_full_off = s% high_logT_op_mono_full_off
         high_logT_op_mono_full_on = s% high_logT_op_mono_full_on
         op_mono_min_X_to_include = s% op_mono_min_X_to_include
         use_op_mono_alt_get_kap = s% use_op_mono_alt_get_kap

         include_L_in_error_est = s% include_L_in_error_est
         include_v_in_error_est = s% include_v_in_error_est
         just_use_energy_resid = s% just_use_energy_resid
            
         ! asteroseismology controls
         
         get_delta_nu_from_scaled_solar = s% get_delta_nu_from_scaled_solar
         nu_max_sun = s% nu_max_sun
         delta_nu_sun = s% delta_nu_sun
         Teff_sun = s% Teff_sun
         delta_Pg_mode_freq = s% delta_Pg_mode_freq
                  
         ! hydro parameters
         opacity_max = s% opacity_max
         opacity_factor = s% opacity_factor
         min_logT_for_opacity_factor_off = s% min_logT_for_opacity_factor_off
         min_logT_for_opacity_factor_on = s% min_logT_for_opacity_factor_on
         max_logT_for_opacity_factor_on = s% max_logT_for_opacity_factor_on
         max_logT_for_opacity_factor_off = s% max_logT_for_opacity_factor_off
         
         non_nuc_neu_factor = s% non_nuc_neu_factor
         accel_factor = s% accel_factor
         use_gr_factors = s% use_gr_factors
         use_dvdt_form_of_momentum_eqn = s% use_dvdt_form_of_momentum_eqn
         use_dlnddt_form_of_density_eqn = s% use_dlnddt_form_of_density_eqn
         use_dedt_form_of_energy_eqn = s% use_dedt_form_of_energy_eqn
         use_sr_sound_speed = s% use_sr_sound_speed
         use_mass_corrections = s% use_mass_corrections
         use_dP_dm_rotation_correction = s% use_dP_dm_rotation_correction
         eps_grav_factor = s% eps_grav_factor
         eps_grav_dt_use_start_values = s% eps_grav_dt_use_start_values
         use_lnS_for_eps_grav = s% use_lnS_for_eps_grav
         use_dEdRho_form_for_eps_grav = s% use_dEdRho_form_for_eps_grav
         use_dlnd_dt_form_for_eps_grav = s% use_dlnd_dt_form_for_eps_grav
         use_PdVdt_form_for_eps_grav = s% use_PdVdt_form_for_eps_grav
         include_dmu_dt_in_eps_grav = s% include_dmu_dt_in_eps_grav
         factor_for_test_CpT_absMdot_div_L = s% factor_for_test_CpT_absMdot_div_L
         eps_grav_time_deriv_separation = s% eps_grav_time_deriv_separation        
         zero_eps_grav_in_just_added_material = s% zero_eps_grav_in_just_added_material
         min_del_T_div_dt = s% min_del_T_div_dt
         max_abs_rel_change_surf_lnS = s% max_abs_rel_change_surf_lnS
         trace_force_another_iteration = s% trace_force_another_iteration
         max_num_surf_revisions = s% max_num_surf_revisions
         Gamma_lnS_eps_grav_full_off = s% Gamma_lnS_eps_grav_full_off
         Gamma_lnS_eps_grav_full_on = s% Gamma_lnS_eps_grav_full_on
         use_artificial_viscosity = s% use_artificial_viscosity
         hold_artificial_viscosity_const_during_step = &
            s% hold_artificial_viscosity_const_during_step
         artificial_viscosity_Q_shift = s% artificial_viscosity_Q_shift
         art_visc_full_off_logRho_le_this = s% art_visc_full_off_logRho_le_this
         art_visc_full_on_logRho_ge_this = s% art_visc_full_on_logRho_ge_this
         post_shock_viscosity_decay_factor = s% post_shock_viscosity_decay_factor
         pre_shock_viscosity_decay_factor = s% pre_shock_viscosity_decay_factor
         use_dPrad_dm_form_of_T_gradient_eqn = s% use_dPrad_dm_form_of_T_gradient_eqn
         use_energy_conservation_form = s% use_energy_conservation_form
         theta_P = s% theta_P
         use_ODE_var_eqn_pairing = s% use_ODE_var_eqn_pairing
         use_bdf_instead_of_ebdf = s% use_bdf_instead_of_ebdf
         use_sdirk_instead_of_ebdf = s% use_sdirk_instead_of_ebdf
         use_symplectic_instead_of_ebdf = s% use_symplectic_instead_of_ebdf
         max_ebdf_order = s% max_ebdf_order
         min_ebdf_order = s% min_ebdf_order
         steps_before_try_higher_ebdf_order = s% steps_before_try_higher_ebdf_order
         factor_for_ebdf_order_tests = s% factor_for_ebdf_order_tests
         ebdf_redo_mix_coeffs_other_stages = s% ebdf_redo_mix_coeffs_other_stages
         ebdf_redo_mix_for_comparison_stage = s% ebdf_redo_mix_for_comparison_stage
         ebdf_redo_mix_for_final_stage = s% ebdf_redo_mix_for_final_stage
         trace_truncation_ratio = s% trace_truncation_ratio
         qmin_freeze_non_radiative_luminosity = s% qmin_freeze_non_radiative_luminosity
         qmax_zero_non_radiative_luminosity = s% qmax_zero_non_radiative_luminosity
         eps_visc_factor = s% eps_visc_factor
         dvdt_visc_factor = s% dvdt_visc_factor
         shock_spread_quadratic = s% shock_spread_quadratic
         shock_spread_linear = s% shock_spread_linear

         center_flash_total_time = s% center_flash_total_time
         center_flash_ramp_up_duration = s% center_flash_ramp_up_duration
         center_flash_ramp_down_duration = s% center_flash_ramp_down_duration
         center_flash_total_ergs = s% center_flash_total_ergs
         
         use_piston = s% use_piston
         piston_period = s% piston_period
         periodic_piston_max_displacement = s% periodic_piston_max_displacement
         periodic_piston_number_of_cycles = s% periodic_piston_number_of_cycles
         periodic_piston_done_delay = s% periodic_piston_done_delay
         piston_inward_time = s% piston_inward_time
         piston_Rmin = s% piston_Rmin
         piston_v0 = s% piston_v0
         piston_Rmax = s% piston_Rmax
         reset_total_energy_initial_when_done_with_piston = &
            s% reset_total_energy_initial_when_done_with_piston

         
         velocity_logT_lower_bound = s% velocity_logT_lower_bound
         max_dt_yrs_for_velocity_logT_lower_bound = s% max_dt_yrs_for_velocity_logT_lower_bound
         velocity_q_upper_bound = s% velocity_q_upper_bound

         min_dxm_Eulerian_div_dxm_CpTMdot_lt_L = s% min_dxm_Eulerian_div_dxm_CpTMdot_lt_L
         min_dxm_Eulerian_div_dxm_removed = s% min_dxm_Eulerian_div_dxm_removed
         min_dxm_Eulerian_div_dxm_added = s% min_dxm_Eulerian_div_dxm_added
         min_cells_for_Eulerian_to_Lagrangian_transition = &
            s% min_cells_for_Eulerian_to_Lagrangian_transition

         ! solvers

         split_mixing_choice = s% split_mixing_choice
         split_mix_do_burn = s% split_mix_do_burn
         op_split_burn_mix_num_passes = s% op_split_burn_mix_num_passes

         op_split_burn_trace = s% op_split_burn_trace
         op_split_burn_tol_max_correction = s% op_split_burn_tol_max_correction
         op_split_burn_tol_avg_correction = s% op_split_burn_tol_avg_correction
         op_split_burn_lambda_undercorrection = s% op_split_burn_lambda_undercorrection
         op_split_burn_tol_hi_logT_limit = s% op_split_burn_tol_hi_logT_limit
         op_split_burn_tol_hi_logT_factor = s% op_split_burn_tol_hi_logT_factor
         
         op_split_burn_sparse_limit = s% op_split_burn_sparse_limit
         op_split_burn_use_net_info_for_sparsity = s% op_split_burn_use_net_info_for_sparsity
         op_split_burn_min_lambda = s% op_split_burn_min_lambda
         op_split_burn_use_pivoting = s% op_split_burn_use_pivoting
         reset_mixing_info_before_final_mix = s% reset_mixing_info_before_final_mix
         
         op_split_burn_max_iterations = s% op_split_burn_max_iterations
         burn_maxabs_dt_d_dxdt_dt = s% burn_maxabs_dt_d_dxdt_dt
         burn_try_substeps_if_BE_fails = s% burn_try_substeps_if_BE_fails
         burn_reuse_given_rates = s% burn_reuse_given_rates
         burn_pause_for_failure = s% burn_pause_for_failure
         
         op_split_burn_refine_min_T = s% op_split_burn_refine_min_T
         op_split_burn_refine_maxerr_limit = s% op_split_burn_refine_maxerr_limit
         op_split_burn_use_quad_min_T = s% op_split_burn_use_quad_min_T
         op_split_burn_use_DGESVX_min_T = s% op_split_burn_use_DGESVX_min_T
         
         op_split_mix_trace = s% op_split_mix_trace
         op_split_mix_atol = s% op_split_mix_atol
         op_split_mix_rtol = s% op_split_mix_rtol

         op_split_burn_mix_trace = s% op_split_burn_mix_trace
         op_split_burn_k_dbg = s% op_split_burn_k_dbg
         op_split_burn_dbg_model_number = s% op_split_burn_dbg_model_number

         op_split_burn_min_logT_for_partials = s% op_split_burn_min_logT_for_partials
         op_split_burn_partials_dlogRho = s% op_split_burn_partials_dlogRho
         op_split_burn_partials_dlogT = s% op_split_burn_partials_dlogT
         
         substep_min_T = s% substep_min_T
         burn_stptry = s% burn_stptry
         burn_max_steps = s% burn_max_steps
         burn_eps = s% burn_eps
         burn_odescal = s% burn_odescal

         substep_burn_solver = s% substep_burn_solver
         substep_burn_decsol = s% substep_burn_decsol
         substep_burn_max_steps = s% substep_burn_max_steps
         substep_burn_rtol = s% substep_burn_rtol
         substep_burn_atol = s% substep_burn_atol
         substep_burn_xmin = s% substep_burn_xmin
         substep_burn_xmax = s% substep_burn_xmax
         substep_burn_clip = s% substep_burn_clip
         substep_burn_use_eps_binding = s% substep_burn_use_eps_binding

         tol_correction_norm = s% tol_correction_norm
         tol_max_correction = s% tol_max_correction
         tol_correction_norm_alt = s% tol_correction_norm_alt
         tol_max_correction_alt = s% tol_max_correction_alt
         sizeB_gam0 = s% sizeB_gam0
         size_del_gam = s% size_del_gam
         correction_xa_limit = s% correction_xa_limit
         
         tol_correction_high_T_limit = s% tol_correction_high_T_limit
         tol_correction_norm_high_T = s% tol_correction_norm_high_T
         tol_max_correction_high_T = s% tol_max_correction_high_T
         
         tol_correction_extreme_T_limit = s% tol_correction_extreme_T_limit
         tol_correction_norm_extreme_T = s% tol_correction_norm_extreme_T
         tol_max_correction_extreme_T = s% tol_max_correction_extreme_T
         
         tol_residual_norm1 = s% tol_residual_norm1
         tol_max_residual1 = s% tol_max_residual1
         tol_residual_norm2 = s% tol_residual_norm2
         tol_max_residual2 = s% tol_max_residual2
         tol_residual_norm3 = s% tol_residual_norm3
         tol_max_residual3 = s% tol_max_residual3
         
         trace_newton_damping = s% trace_newton_damping
         
         max_iterations_for_jacobian = s% max_iterations_for_jacobian
         refine_solution = s% refine_solution
         refine_mtx_solution = s% refine_mtx_solution
         
         star_bcyclic_do_pivot = s% star_bcyclic_do_pivot
         sparse_min_refactor_rgrowth = s% sparse_min_refactor_rgrowth

         small_mtx_decsol = s% small_mtx_decsol
         large_mtx_decsol = s% large_mtx_decsol
         hydro_decsol_switch = s% hydro_decsol_switch
         sparse_non_zero_max_factor = s% sparse_non_zero_max_factor

         iter_for_resid_tol2 = s% iter_for_resid_tol2
         iter_for_resid_tol3 = s% iter_for_resid_tol3
         
         newton_itermin = s% newton_itermin
         newton_itermin_until_reduce_min_corr_coeff = &
            s% newton_itermin_until_reduce_min_corr_coeff
         newton_reduced_min_corr_coeff = s% newton_reduced_min_corr_coeff
         do_newton_damping_for_neg_xa = s% do_newton_damping_for_neg_xa
         hydro_mtx_max_allowed_abs_dlogT = s% hydro_mtx_max_allowed_abs_dlogT
         hydro_mtx_max_allowed_abs_dlogRho = s% hydro_mtx_max_allowed_abs_dlogRho
         hydro_mtx_max_allowed_abs_dlogPgas = s% hydro_mtx_max_allowed_abs_dlogPgas
         min_logT_for_hydro_mtx_max_allowed = s% min_logT_for_hydro_mtx_max_allowed
         hydro_mtx_max_allowed_logT = s% hydro_mtx_max_allowed_logT
         hydro_mtx_max_allowed_logRho = s% hydro_mtx_max_allowed_logRho
         hydro_mtx_max_allowed_logPgas = s% hydro_mtx_max_allowed_logPgas
         
         hydro_solver_name = s% hydro_solver_name

         tiny_corr_coeff_limit = s% tiny_corr_coeff_limit
         scale_correction_norm = s% scale_correction_norm
         corr_param_factor = s% corr_param_factor
         scale_max_correction = s% scale_max_correction
         
         corr_norm_jump_limit = s% corr_norm_jump_limit
         max_corr_jump_limit = s% max_corr_jump_limit
         resid_norm_jump_limit = s% resid_norm_jump_limit
         max_resid_jump_limit = s% max_resid_jump_limit
         
         corr_coeff_limit = s% corr_coeff_limit
         tiny_corr_factor = s% tiny_corr_factor
         matrix_type = s% matrix_type

         max_tries = s% max_tries
         max_tries1 = s% max_tries1
         max_tries_for_retry = s% max_tries_for_retry
         max_tries_after_5_retries = s% max_tries_after_5_retries
         max_tries_after_10_retries = s% max_tries_after_10_retries
         max_tries_after_20_retries = s% max_tries_after_20_retries
         max_tries_after_backup = s% max_tries_after_backup
         max_tries_after_backup2 = s% max_tries_after_backup2
         retry_limit = s% retry_limit
         redo_limit = s% redo_limit
         
         min_xa_hard_limit = s% min_xa_hard_limit
         min_xa_hard_limit_for_highT = s% min_xa_hard_limit_for_highT
         logT_max_for_min_xa_hard_limit = s% logT_max_for_min_xa_hard_limit
         logT_min_for_min_xa_hard_limit_for_highT = s% logT_min_for_min_xa_hard_limit_for_highT
         
         sum_xa_hard_limit = s% sum_xa_hard_limit
         sum_xa_hard_limit_for_highT = s% sum_xa_hard_limit_for_highT
         logT_max_for_sum_xa_hard_limit = s% logT_max_for_sum_xa_hard_limit
         logT_min_for_sum_xa_hard_limit_for_highT = s% logT_min_for_sum_xa_hard_limit_for_highT
         
         xa_clip_limit = s% xa_clip_limit
         report_hydro_solver_progress = s% report_hydro_solver_progress
         hydro_dump_call_number = s% hydro_dump_call_number
         hydro_dump_iter_number = s% hydro_dump_iter_number
         hydro_numerical_jacobian = s% hydro_numerical_jacobian
         hydro_jacobian_nzlo = s% hydro_jacobian_nzlo
         hydro_jacobian_nzhi = s% hydro_jacobian_nzhi
         hydro_check_everything = s% hydro_check_everything
         hydro_inspectB_flag = s% hydro_inspectB_flag
         hydro_show_correction_info = s% hydro_show_correction_info
         hydro_save_numjac_plot_data = s% hydro_save_numjac_plot_data
         trace_k = s% trace_k

         ! timestep
         max_timestep = s% max_timestep
         max_years_for_timestep = s% max_years_for_timestep

         hi_T_max_years_for_timestep = s% hi_T_max_years_for_timestep
         max_timestep_hi_T_limit = s% max_timestep_hi_T_limit

         min_timestep_factor = s% min_timestep_factor
         max_timestep_factor = s% max_timestep_factor
         timestep_factor_for_backups = s% timestep_factor_for_backups
         timestep_factor_for_retries = s% timestep_factor_for_retries
         backup_hold = s% backup_hold
         retry_hold = s% retry_hold
         neg_mass_fraction_hold = s% neg_mass_fraction_hold
         DUP_varcontrol_factor = s% DUP_varcontrol_factor
         timestep_dt_factor = s% timestep_dt_factor
         dt_limit_ratio_target = s% dt_limit_ratio_target
         use_dt_low_pass_controller = s% use_dt_low_pass_controller

         varcontrol_target = s% varcontrol_target
         varcontrol_dt_limit_ratio_hard_max = s% varcontrol_dt_limit_ratio_hard_max
         xa_scale = s% xa_scale

         truncation_ratio_xh_atol = s% truncation_ratio_xh_atol
         truncation_ratio_xh_rtol = s% truncation_ratio_xh_rtol
         truncation_ratio_xa_atol = s% truncation_ratio_xa_atol
         truncation_ratio_xa_rtol = s% truncation_ratio_xa_rtol
         truncation_ratio_limit = s% truncation_ratio_limit
         truncation_ratio_hard_limit = s% truncation_ratio_hard_limit
         eval_truncation_ratio_do_max = s% eval_truncation_ratio_do_max
         use_truncation_ratio_limit = s% use_truncation_ratio_limit
         
         newton_iterations_limit = s% newton_iterations_limit
         newton_iterations_hard_limit = s% newton_iterations_hard_limit
         
         rotation_steps_limit = s% rotation_steps_limit
         rotation_steps_hard_limit = s% rotation_steps_hard_limit
         
         diffusion_steps_limit = s% diffusion_steps_limit
         diffusion_steps_hard_limit = s% diffusion_steps_hard_limit
         diffusion_iters_limit = s% diffusion_iters_limit
         diffusion_iters_hard_limit = s% diffusion_iters_hard_limit
         
         dt_div_dt_Courant_limit = s% dt_div_dt_Courant_limit
         dt_div_dt_Courant_hard_limit = s% dt_div_dt_Courant_hard_limit
         dt_div_dt_cell_collapse_limit = s% dt_div_dt_cell_collapse_limit
         dt_div_dt_cell_collapse_hard_limit = s% dt_div_dt_cell_collapse_hard_limit
         dt_div_dt_thermal_limit = s% dt_div_dt_thermal_limit
         dt_div_dt_thermal_hard_limit = s% dt_div_dt_thermal_hard_limit
         dt_div_dt_dynamic_limit = s% dt_div_dt_dynamic_limit
         dt_div_dt_dynamic_hard_limit = s% dt_div_dt_dynamic_hard_limit
         dt_div_dt_acoustic_limit = s% dt_div_dt_acoustic_limit
         dt_div_dt_acoustic_hard_limit = s% dt_div_dt_acoustic_hard_limit
         dt_div_dt_mass_loss_limit = s% dt_div_dt_mass_loss_limit
         dt_div_dt_mass_loss_hard_limit = s% dt_div_dt_mass_loss_hard_limit
         
         burn_max_iters_limit = s% burn_max_iters_limit
         burn_max_iters_hard_limit = s% burn_max_iters_hard_limit

         burn_max_substeps_limit = s% burn_max_substeps_limit
         burn_max_substeps_hard_limit = s% burn_max_substeps_hard_limit
         
         max_fixup_for_mix_limit = s% max_fixup_for_mix_limit
         max_fixup_for_mix_hard_limit = s% max_fixup_for_mix_hard_limit
         
         dX_mix_dist_limit = s% dX_mix_dist_limit
         
         dH_limit_min_H = s% dH_limit_min_H
         dH_limit = s% dH_limit
         dH_hard_limit = s% dH_hard_limit
         dH_div_H_limit_min_H = s% dH_div_H_limit_min_H
         dH_div_H_limit = s% dH_div_H_limit
         dH_div_H_hard_limit = s% dH_div_H_hard_limit
         dH_decreases_only = s% dH_decreases_only

         dHe_limit_min_He = s% dHe_limit_min_He
         dHe_limit = s% dHe_limit
         dHe_hard_limit = s% dHe_hard_limit
         dHe_div_He_limit_min_He = s% dHe_div_He_limit_min_He
         dHe_div_He_limit = s% dHe_div_He_limit
         dHe_div_He_hard_limit = s% dHe_div_He_hard_limit
         dHe_decreases_only = s% dHe_decreases_only

         dHe3_limit_min_He3 = s% dHe3_limit_min_He3
         dHe3_limit = s% dHe3_limit
         dHe3_hard_limit = s% dHe3_hard_limit
         dHe3_div_He3_limit_min_He3 = s% dHe3_div_He3_limit_min_He3
         dHe3_div_He3_limit = s% dHe3_div_He3_limit
         dHe3_div_He3_hard_limit = s% dHe3_div_He3_hard_limit
         dHe3_decreases_only = s% dHe3_decreases_only

         dX_limit_min_X = s% dX_limit_min_X
         dX_limit = s% dX_limit
         dX_hard_limit = s% dX_hard_limit
         dX_div_X_limit_min_X = s% dX_div_X_limit_min_X
         dX_div_X_limit = s% dX_div_X_limit
         dX_div_X_hard_limit = s% dX_div_X_hard_limit
         dX_decreases_only = s% dX_decreases_only
         
         dX_nuc_drop_min_X_limit = s% dX_nuc_drop_min_X_limit
         dX_nuc_drop_max_A_limit = s% dX_nuc_drop_max_A_limit
         dX_nuc_drop_limit = s% dX_nuc_drop_limit
         dX_nuc_drop_limit_at_high_T = s% dX_nuc_drop_limit_at_high_T
         dX_nuc_drop_hard_limit = s% dX_nuc_drop_hard_limit
         dX_nuc_drop_min_yrs_for_dt = s% dX_nuc_drop_min_yrs_for_dt
         
         dL_div_L_limit_min_L = s% dL_div_L_limit_min_L
         dL_div_L_limit = s% dL_div_L_limit
         dL_div_L_hard_limit = s% dL_div_L_hard_limit

         delta_lgP_limit = s% delta_lgP_limit
         delta_lgP_hard_limit = s% delta_lgP_hard_limit
         delta_lgP_limit_min_lgP = s% delta_lgP_limit_min_lgP
         
         delta_lgRho_limit = s% delta_lgRho_limit
         delta_lgRho_hard_limit = s% delta_lgRho_hard_limit
         delta_lgRho_limit_min_lgRho = s% delta_lgRho_limit_min_lgRho
         
         delta_lgT_limit = s% delta_lgT_limit
         delta_lgT_hard_limit = s% delta_lgT_hard_limit
         delta_lgT_limit_min_lgT = s% delta_lgT_limit_min_lgT
         
         delta_lgE_limit = s% delta_lgE_limit
         delta_lgE_hard_limit = s% delta_lgE_hard_limit
         delta_lgE_limit_min_lgE = s% delta_lgE_limit_min_lgE
         
         delta_lgR_limit = s% delta_lgR_limit
         delta_lgR_hard_limit = s% delta_lgR_hard_limit
         delta_lgR_limit_min_lgR = s% delta_lgR_limit_min_lgR
         
         delta_Ye_limit = s% delta_Ye_limit
         delta_Ye_hard_limit = s% delta_Ye_hard_limit
         delta_Ye_highT_limit = s% delta_Ye_highT_limit
         delta_Ye_highT_hard_limit = s% delta_Ye_highT_hard_limit
         minT_for_highT_Ye_limit = s% minT_for_highT_Ye_limit
         
         d_deltaR_shrink_limit = s% d_deltaR_shrink_limit
         d_deltaR_shrink_hard_limit = s% d_deltaR_shrink_hard_limit
         d_deltaR_grow_limit = s% d_deltaR_grow_limit
         d_deltaR_grow_hard_limit = s% d_deltaR_grow_hard_limit

         delta_lgL_nuc_cat_limit = s% delta_lgL_nuc_cat_limit
         delta_lgL_nuc_cat_hard_limit = s% delta_lgL_nuc_cat_hard_limit
         lgL_nuc_cat_burn_min = s% lgL_nuc_cat_burn_min
         lgL_nuc_mix_dist_limit = s% lgL_nuc_mix_dist_limit
         
         check_delta_lgL_pp = s% check_delta_lgL_pp
         check_delta_lgL_cno = s% check_delta_lgL_cno
         check_delta_lgL_3alf = s% check_delta_lgL_3alf
            
         check_delta_lgL_burn_c = s% check_delta_lgL_burn_c
         check_delta_lgL_burn_n = s% check_delta_lgL_burn_n
         check_delta_lgL_burn_o = s% check_delta_lgL_burn_o
         check_delta_lgL_burn_ne = s% check_delta_lgL_burn_ne
         check_delta_lgL_burn_na = s% check_delta_lgL_burn_na
         check_delta_lgL_burn_mg = s% check_delta_lgL_burn_mg
         check_delta_lgL_burn_si = s% check_delta_lgL_burn_si
         check_delta_lgL_burn_s = s% check_delta_lgL_burn_s
         check_delta_lgL_burn_ar = s% check_delta_lgL_burn_ar
         check_delta_lgL_burn_ca = s% check_delta_lgL_burn_ca
         check_delta_lgL_burn_ti = s% check_delta_lgL_burn_ti
         check_delta_lgL_burn_cr = s% check_delta_lgL_burn_cr
         check_delta_lgL_burn_fe = s% check_delta_lgL_burn_fe
         
         check_delta_lgL_cc = s% check_delta_lgL_cc
         check_delta_lgL_co = s% check_delta_lgL_co
         check_delta_lgL_oo = s% check_delta_lgL_oo

         delta_lgL_H_limit = s% delta_lgL_H_limit
         delta_lgL_H_hard_limit = s% delta_lgL_H_hard_limit
         lgL_H_burn_min = s% lgL_H_burn_min
         lgL_H_drop_factor = s% lgL_H_drop_factor
         lgL_H_burn_relative_limit = s% lgL_H_burn_relative_limit

         delta_lgL_He_limit = s% delta_lgL_He_limit
         delta_lgL_He_hard_limit = s% delta_lgL_He_hard_limit
         lgL_He_burn_min = s% lgL_He_burn_min
         lgL_He_drop_factor = s% lgL_He_drop_factor
         lgL_He_burn_relative_limit = s% lgL_He_burn_relative_limit

         delta_lgL_z_limit = s% delta_lgL_z_limit
         delta_lgL_z_hard_limit = s% delta_lgL_z_hard_limit
         lgL_z_burn_min = s% lgL_z_burn_min
         lgL_z_drop_factor = s% lgL_z_drop_factor
         lgL_z_burn_relative_limit = s% lgL_z_burn_relative_limit

         delta_lgL_photo_limit = s% delta_lgL_photo_limit
         delta_lgL_photo_hard_limit = s% delta_lgL_photo_hard_limit
         lgL_photo_burn_min = s% lgL_photo_burn_min
         lgL_photo_drop_factor = s% lgL_photo_drop_factor

         delta_lgL_nuc_limit = s% delta_lgL_nuc_limit
         delta_lgL_nuc_hard_limit = s% delta_lgL_nuc_hard_limit
         lgL_nuc_burn_min = s% lgL_nuc_burn_min
         lgL_nuc_drop_factor = s% lgL_nuc_drop_factor
                   
         delta_lgRho_cntr_limit = s% delta_lgRho_cntr_limit
         delta_lgRho_cntr_hard_limit = s% delta_lgRho_cntr_hard_limit
         
         delta_lgT_cntr_limit = s% delta_lgT_cntr_limit
         delta_lgT_cntr_hard_limit = s% delta_lgT_cntr_hard_limit
         
         delta_lgT_max_limit = s% delta_lgT_max_limit
         delta_lgT_max_hard_limit = s% delta_lgT_max_hard_limit
         
         delta_lgRho_max_limit = s% delta_lgRho_max_limit
         delta_lgRho_max_hard_limit = s% delta_lgRho_max_hard_limit
         
         delta_log_eps_nuc_cntr_limit = s% delta_log_eps_nuc_cntr_limit
         delta_log_eps_nuc_cntr_hard_limit = s% delta_log_eps_nuc_cntr_hard_limit
         
         delta_log_eps_nuc_limit = s% delta_log_eps_nuc_limit
         delta_log_eps_nuc_hard_limit = s% delta_log_eps_nuc_hard_limit
                   
         delta_lg_XH_cntr_min = s% delta_lg_XH_cntr_min
         delta_lg_XH_cntr_max = s% delta_lg_XH_cntr_max
         delta_lg_XH_cntr_limit = s% delta_lg_XH_cntr_limit
         delta_lg_XH_cntr_hard_limit = s% delta_lg_XH_cntr_hard_limit
                   
         delta_lg_XHe_cntr_min = s% delta_lg_XHe_cntr_min
         delta_lg_XHe_cntr_max = s% delta_lg_XHe_cntr_max
         delta_lg_XHe_cntr_limit = s% delta_lg_XHe_cntr_limit
         delta_lg_XHe_cntr_hard_limit = s% delta_lg_XHe_cntr_hard_limit
                   
         delta_lg_XC_cntr_min = s% delta_lg_XC_cntr_min
         delta_lg_XC_cntr_max = s% delta_lg_XC_cntr_max
         delta_lg_XC_cntr_limit = s% delta_lg_XC_cntr_limit
         delta_lg_XC_cntr_hard_limit = s% delta_lg_XC_cntr_hard_limit
         
         delta_lg_XNe_cntr_limit = s% delta_lg_XNe_cntr_limit
         delta_lg_XNe_cntr_hard_limit = s% delta_lg_XNe_cntr_hard_limit
         delta_lg_XNe_cntr_min = s% delta_lg_XNe_cntr_min
         delta_lg_XNe_cntr_max = s% delta_lg_XNe_cntr_max
         
         delta_lg_XO_cntr_limit = s% delta_lg_XO_cntr_limit
         delta_lg_XO_cntr_hard_limit = s% delta_lg_XO_cntr_hard_limit
         delta_lg_XO_cntr_min = s% delta_lg_XO_cntr_min 
         delta_lg_XO_cntr_max = s% delta_lg_XO_cntr_max          
         
         delta_lg_XSi_cntr_limit = s% delta_lg_XSi_cntr_limit
         delta_lg_XSi_cntr_hard_limit = s% delta_lg_XSi_cntr_hard_limit
         delta_lg_XSi_cntr_min = s% delta_lg_XSi_cntr_min 
         delta_lg_XSi_cntr_max = s% delta_lg_XSi_cntr_max
      
         delta_lgTeff_limit = s% delta_lgTeff_limit
         delta_lgTeff_hard_limit = s% delta_lgTeff_hard_limit
         
         v_div_v_crit_limit = s% v_div_v_crit_limit
         v_div_v_crit_hard_limit = s% v_div_v_crit_hard_limit
         
         delta_lgL_limit = s% delta_lgL_limit
         delta_lgL_limit_L_min = s% delta_lgL_limit_L_min
         delta_lgL_hard_limit = s% delta_lgL_hard_limit
         
         delta_HR_ds_L = s% delta_HR_ds_L
         delta_HR_ds_Teff = s% delta_HR_ds_Teff
         delta_HR_limit = s% delta_HR_limit
         delta_HR_hard_limit = s% delta_HR_hard_limit
         
         delta_lg_total_J_limit = s% delta_lg_total_J_limit
         delta_lg_total_J_hard_limit = s% delta_lg_total_J_hard_limit
         
         delta_lg_star_mass_limit = s% delta_lg_star_mass_limit
         delta_lg_star_mass_hard_limit = s% delta_lg_star_mass_hard_limit 
         
         delta_mdot_atol = s% delta_mdot_atol
         delta_mdot_rtol = s% delta_mdot_rtol
         delta_mdot_limit = s% delta_mdot_limit
         delta_mdot_hard_limit = s% delta_mdot_hard_limit
         
         CpT_absMdot_div_L_limit = s% CpT_absMdot_div_L_limit 
         CpT_absMdot_div_L_hard_limit = s% CpT_absMdot_div_L_hard_limit

         relax_hard_limits_after_backup = s% relax_hard_limits_after_backup
         relax_hard_limits_after_retry = s% relax_hard_limits_after_retry
         report_all_dt_limits = s% report_all_dt_limits
         report_why_dt_limits = s% report_why_dt_limits
         report_hydro_dt_info = s% report_hydro_dt_info
         report_dX_nuc_drop_dt_limits = s% report_dX_nuc_drop_dt_limits

         limit_for_rel_error_in_energy_conservation =  &
            s% limit_for_rel_error_in_energy_conservation
         hard_limit_for_rel_error_in_energy_conservation =  &
            s% hard_limit_for_rel_error_in_energy_conservation

         limit_for_rel_rate_in_energy_conservation =  &
            s% limit_for_rel_rate_in_energy_conservation
         hard_limit_for_rel_rate_in_energy_conservation =  &
            s% hard_limit_for_rel_rate_in_energy_conservation

         limit_for_avg_E_residual = s% limit_for_avg_E_residual
         hard_limit_for_avg_E_residual = s% hard_limit_for_avg_E_residual
         limit_for_max_E_residual = s% limit_for_max_E_residual
         hard_limit_for_max_E_residual = s% hard_limit_for_max_E_residual

         trace_newton_bcyclic_solve_input = s% trace_newton_bcyclic_solve_input
         trace_newton_bcyclic_solve_output = s% trace_newton_bcyclic_solve_output
         trace_newton_bcyclic_matrix_input = s% trace_newton_bcyclic_matrix_input
         trace_newton_bcyclic_matrix_output = s% trace_newton_bcyclic_matrix_output
         trace_newton_bcyclic_steplo = s% trace_newton_bcyclic_steplo
         trace_newton_bcyclic_stephi = s% trace_newton_bcyclic_stephi
         trace_newton_bcyclic_iterlo = s% trace_newton_bcyclic_iterlo
         trace_newton_bcyclic_iterhi = s% trace_newton_bcyclic_iterhi
         trace_newton_bcyclic_nzlo = s% trace_newton_bcyclic_nzlo
         trace_newton_bcyclic_nzhi = s% trace_newton_bcyclic_nzhi
         trace_newton_bcyclic_jlo = s% trace_newton_bcyclic_jlo
         trace_newton_bcyclic_jhi = trace_newton_bcyclic_jhi
         write_varcontrol_internals = s% write_varcontrol_internals
         
         min_logT_for_quad = s% min_logT_for_quad
         
         ! controls for the evolve routine
         trace_evolve = s% trace_evolve

         
         ! misc
         zams_filename = s% zams_filename
         
         use_other_eos = s% use_other_eos
         use_other_surface_PT = s% use_other_surface_PT
         use_other_kap = s% use_other_kap
         use_other_atm = s% use_other_atm
         use_other_diffusion = s% use_other_diffusion
         use_other_mlt = s% use_other_mlt
         use_other_adjust_mdot = s% use_other_adjust_mdot
         use_other_am_mixing = s% use_other_am_mixing
         use_other_brunt = s% use_other_brunt
         use_other_brunt_smoothing = s% use_other_brunt_smoothing
         use_other_newton_monitor = s% use_other_newton_monitor
         use_other_build_initial_model = s% use_other_build_initial_model
         use_other_cgrav = s% use_other_cgrav
         use_other_energy_implicit = s% use_other_energy_implicit
         use_other_momentum = s% use_other_momentum
         use_other_energy = s% use_other_energy
         use_other_mesh_functions = s% use_other_mesh_functions
         use_other_eps_grav = s% use_other_eps_grav
         use_other_D_mix = s% use_other_D_mix
         use_other_split_mix = s% use_other_split_mix
         use_other_neu = s% use_other_neu
         use_other_opacity_factor = s% use_other_opacity_factor
         use_other_paquette_coefficients = s% use_other_paquette_coefficients
         use_other_pgstar_plots = s% use_other_pgstar_plots
         use_other_torque = s% use_other_torque
         use_other_torque_implicit = s% use_other_torque_implicit
         use_other_wind = s% use_other_wind
         use_other_after_struct_burn_mix = s% use_other_after_struct_burn_mix
         use_other_before_struct_burn_mix = s% use_other_before_struct_burn_mix
         use_other_get_pulsation_info = s% use_other_get_pulsation_info
         use_other_write_pulsation_info = s% use_other_write_pulsation_info
         use_other_edit_pulsation_info = s% use_other_edit_pulsation_info
         use_other_edit_gyre_info = s% use_other_edit_gyre_info
         use_other_get_gyre_model = s% use_other_get_gyre_model
         use_other_adjust_net = s% use_other_adjust_net
         use_other_astero_freq_corr = s% use_other_astero_freq_corr

         trace_solar_neutrinos = s% trace_solar_neutrinos
         
         x_ctrl = s% x_ctrl
         x_integer_ctrl = s% x_integer_ctrl
         x_logical_ctrl = s% x_logical_ctrl
         x_character_ctrl = s% x_character_ctrl

         ! info for debugging
         stop_for_bugs = s% stop_for_bugs
         report_ierr = s% report_ierr

         diffusion_dump_call_number = s% diffusion_dump_call_number

         
      end subroutine set_controls_for_writing
      
      
      subroutine write_controls(io,ierr)
         integer, intent(in) :: io
         integer, intent(out) :: ierr
         write(io, nml=controls, iostat=ierr)  
      end subroutine write_controls

      end module ctrls_io

