! ***********************************************************************
!
!   Copyright (C) 2014  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 
      module other_split_mix

      ! NOTE: remember to set use_other_split_mix = .true. to enable this.

      use star_def

      implicit none
      
      contains
      
      
      subroutine null_other_split_mix( &
            id, dt_total, species, pass, num_passes, result_code, ierr)
         use const_def, only: dp
         integer, intent(in) :: id
         real(dp), intent(in) :: dt_total 
         integer, intent(in) :: species, pass, num_passes
         integer, intent(out) :: result_code, ierr
         result_code = keep_going
         ierr = 0
      end subroutine null_other_split_mix


      end module other_split_mix
      
      

!   On Mar 4, 2014, at 1:23 AM, Sashin Moonsamy wrote:
!
!   Thanks for this extremely interesting and important addition to the code. I've just downloaded a fresh copy of 6022 and will have a look at the test suite cases with the new split_mixing_choice options. I'm quite eager to play around with it and would appreciate any advice you can give me.
!
!   Hi,
!
!   Here's a sketch of how to experiment with your own implementation of split mixing.
!
!   Looking at star/other/other_split_mix, you'll see that your routine will be like this:
!      
!         subroutine other_split_mix( &
!               id, dt_total, species, pass, num_passes, result_code, ierr)
!            use const_def, only: dp
!            integer, intent(in) :: id
!            real(dp), intent(in) :: dt_total 
!            integer, intent(in) :: species, pass, num_passes
!            integer, intent(out) :: result_code, ierr
!            result_code = keep_going
!            ierr = 0
!   	..............
!         end subroutine other_split_mix
!
!   Set s% other_split_mix => other_split_mix in your run_star_extras, extras_controls.
!
!   In your other_split_mix routine, use the id arg to get a pointer, s, to the star_info record:
!
!            type (star_info), pointer :: s
!            call star_ptr(id, s, ierr)
!            if (ierr /= 0) return
!
!   The "dt_total" is the number of seconds for mixing.
!
!   The "pass" and "num_passes" args are only for the split_mixing_choice = -4 case.  Ignore them otherwise.
!
!   The output "result_code" is usually set to keep_going, but can also be retry, backup, or terminate.
!
!   The output "ierr" is usually 0; anything else indicates an error.
!
!   Once you have the pointer s, you can read or write anything about the star, including abundances.
!
!   s% nz is the number of cells, numbered from 1 at the surface to nz at the center.
!
!   s% species is the number of species.
!
!   s% xa(j,k) is the mass fraction for species j in cell k.
!
!   Your other_split_mix is free to change the s% xa values as it pleases.
!   Just be careful to conserve species (i.e., don't change sum(s% xa(j,1:nz)) for any j)
!   and make the sum(s% xa(1:species,k)) = 1 for each k.
!
!   Set the control use_other_split_mix = .true. to enable your routine.
!
!   The control split_mixing_choice determines when your split_mix routine will be called.
!
!   Good luck!
!
!   -Bill

      

!   On Mar 4, 2014, at 9:38 AM, Bill Paxton wrote:
!
!   Your other_split_mix is free to change the s% xa values as it pleases.
!   Just be careful to conserve species (i.e., don't change sum(s% xa(j,1:nz)) for any j)
!   and make the sum(s% xa(1:species,k)) = 1 for each k.
!
!
!   I my previous email, I mentioned these requirements but didn't say anything about the challenge of satisfying them.
!
!   Ideally, there wouldn't be any issue here, but in reality there are always deviations, hopefully small, but too big to ignore.
!
!   I've made an attempt to deal with such problems in subroutine fixup_after_mix found in star/private/solve_mix.
!
!   If you'd like to use it, let me know and I'll add a public interface.  Even if you want to do your own, you might want to read mine.
!
!   Cheers,
!   Bill



