! ***********************************************************************
!
!   Copyright (C) 2012  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 
      module other_get_gyre_model

      ! NOTE: remember to set use_other_get_gyre_model = .true. to enable this.

      
      use star_def

      implicit none
      
            
      contains
      
      
      subroutine default_other_get_gyre_model( &
            id, nn, keep_surface_point, add_atmosphere, &
            M_star, R_star, L_star, r, w, L, p, rho, T, &
            N2, Gamma_1, nabla_ad, delta, nabla,  &
            kappa, kappa_rho, kappa_T, &
            epsilon, epsilon_rho, epsilon_T, omega, ierr)
         use const_def, only: dp
         integer, intent(in) :: id, nn ! nn is number of points
         logical, intent(in) :: keep_surface_point, add_atmosphere
         real(dp), intent(in) :: M_star, R_star, L_star
         real(dP), intent(inout), dimension(:) :: &
            r, w, L, p, rho, T, &
            N2, Gamma_1, nabla_ad, delta, nabla,  &
            kappa, kappa_rho, kappa_T, &
            epsilon, epsilon_rho, epsilon_T, omega
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine default_other_get_gyre_model


      end module other_get_gyre_model
      
      
      
      
