! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 
      module other_atm

      ! NOTE: remember to set use_other_atm = .true. to enable this.
      
      ! you can add your own atm routine for use instead of the standard module
      ! this routine is called if s% use_other_atm is true
      ! don't edit this file -- instead copy null_other_atm from below and edit it.
      ! it goes in your src/run_star_extras file.
      ! edit the extras_controls routine to set s% other_atm
      ! e.g.,
         !    s% other_atm => my_atm_routine
         
         
      ! NOTE: if you'd like to have some inlist controls for your routine,
      ! you can use the x_ctrl array of real(dp) variables that is in &controls
      ! e.g., in the &controls inlist, you can set
      !     x_ctrl(1) = my_special_param
      ! then in your routine, you can access that by
      !     s% x_ctrl(1)
      ! of course before you can use s, you need to get it using the id argument.
      ! here's an example of how to do that -- add these lines at the start of your routine:
      !         use star_lib, only: star_ptr
      !         type (star_info), pointer :: s
      !         call star_ptr(id, s, ierr)
      !         if (ierr /= 0) then ! OOPS
      !            return
      !         end if
      ! 
      ! for integer control values, you can use x_integer_ctrl
      ! for logical control values, you can use x_logical_ctrl

      use star_def

      implicit none
      
            
      contains
      
      
      subroutine null_other_atm( &
            id, M, R, L, X, Z, kap, Teff, &
            lnT, dlnT_dL, dlnT_dlnR, dlnT_dlnM, dlnT_dlnkap, &
            lnP, dlnP_dL, dlnP_dlnR, dlnP_dlnM, dlnP_dlnkap, &
            which_atm_option, switch_to_grey_as_backup, ierr)
         integer, intent(in) :: id ! star id if available; 0 otherwise
         ! cgs units
         real(dp), intent(in) :: M ! enclosed mass at photosphere
         real(dp), intent(in) :: R ! radius at photosphere
         real(dp), intent(in) :: L ! luminosity at photosphere
         real(dp), intent(in) :: X ! hydrogen mass fraction
         real(dp), intent(in) :: Z ! metallicity
         real(dp), intent(in) :: kap 
            ! opacity above photosphere (average by mass)
            ! only used for grey atm approximation.
         
         real(dp), intent(out) :: Teff ! temperature at photosphere
         real(dp), intent(out) :: lnT ! natural log of temperature at base of atmosphere
         real(dp), intent(out) :: lnP ! natural log of pressure at base of atmosphere (Pgas + Prad)
         
         ! partial derivatives of lnT and lnP
         real(dp), intent(out) :: dlnT_dL, dlnT_dlnR, dlnT_dlnM, dlnT_dlnkap
         real(dp), intent(out) :: dlnP_dL, dlnP_dlnR, dlnP_dlnM, dlnP_dlnkap
         
         integer, intent(in) :: which_atm_option
            ! atm_simple_photosphere or one of the options for tables
            ! T(tau) integration is not supported in this routine -- call atm_int_T_tau instead
         logical, intent(in) :: switch_to_grey_as_backup
            ! if you select a table option, but the args are out of the range of the tables,
            ! then this flag determines whether you get an error or the code automatically
            ! switches to option = atm_simple_photosphere as a backup.

         integer, intent(out) :: ierr  ! == 0 means AOK
         
         Teff = 0; lnT = 0; lnP = 0
         dlnT_dL = 0; dlnT_dlnR = 0; dlnT_dlnM = 0; dlnT_dlnkap = 0
         dlnP_dL = 0; dlnP_dlnR = 0; dlnP_dlnM = 0; dlnP_dlnkap = 0
         
         write(*,*) 'no implementation for other_atm'
         ierr = -1

      end subroutine null_other_atm


      end module other_atm
      
      
      
      
