      module test_weak
      use rates_lib
      use rates_def
      use crlibm_lib
      use const_def
      
      implicit none
      
      contains
      
      subroutine do_test_weak
         use const_lib
         use chem_lib
         use chem_def, only: iso_name_length, chem_isos
         use rates_def, only: Coulomb_Info
         integer :: ierr, i, ir, nr
         integer, pointer :: ids(:)
         type(Coulomb_Info), pointer :: cc
         double precision, dimension(:), pointer :: &
		      ldecay, d_ldecay_dT9, d_ldecay_dlYeRho, &
		      lcapture, d_lcapture_dT9, d_lcapture_dlYeRho, &
		      lneutrino, d_lneutrino_dT9, d_lneutrino_dlYeRho, &
		      lambda, dlambda_dlnT, dlambda_dlnRho, &
		      Q, dQ_dlnT, dQ_dlnRho, &
		      Qneu, dQneu_dlnT, dQneu_dlnRho
         double precision, dimension(:), pointer :: &
		      ldecay2, d_ldecay_dT92, d_ldecay_dlYeRho2, &
		      lcapture2, d_lcapture_dT92, d_lcapture_dlYeRho2, &
		      lneutrino2, d_lneutrino_dT92, d_lneutrino_dlYeRho2, &
		      lambda2, dlambda_dlnT2, dlambda_dlnRho2, &
		      Q2, dQ_dlnT2, dQ_dlnRho2, &
		      Qneu2, dQneu_dlnT2, dQneu_dlnRho2
		   double precision :: logT, T, T9, dT9, dlnT, YeRho, &
		      ye, rho, logRho, dlogRho, eta, d_eta_dlnT, d_eta_dlnRho
	      character(len=iso_name_length) :: weak_lhs, weak_rhs
	      character(len=2*iso_name_length+1) :: key
         
         include 'formats.dek'

         ierr = 0
                  
         write(*,*) 'check weak_info_list'
         weak_lhs = 'o14'
         weak_rhs = 'n14'
         i = get_weak_info_list_id(weak_lhs, weak_rhs)
         if (i <= 0 .or. i > num_weak_info_list_reactions) then
            write(*,*) 'get_weak_info_list_id failed'
            stop 1
         end if
         call create_weak_dict_key(weak_lhs, weak_rhs, key)
         write(*,1) trim(key)
         write(*,1) 'halflife', weak_info_list_halflife(i)
         write(*,1) 'Qneu', weak_info_list_Qneu(i)
         write(*,*)
         
         d_eta_dlnT = 0
         d_eta_dlnRho = 0
         
         if (.false.) then ! TESTING
            logT =     7.5904236599874348D+00
            logRho =     1.0657946486820271D+00
            ye =     8.2724691280321605D-01
            eta =    -5.3262903257381922D+00
            d_eta_dlnT =    -1.5299344982339016D+00
            d_eta_dlnRho =     9.9482489248846617D-01
         else if (.true.) then ! TESTING
            logT =  log10_cr(9.0d8)
            ye =    0.5
            logRho =  log10_cr(4.5d5)
            eta =    10d0
         else
            logT = 7.5d0
            logRho = 4d0
            Ye = 0.5d0
            eta = 0d0
        end if
         
         T = exp10_cr(logT)
         T9 = T*1d-9
         rho = exp10_cr(logRho)
         YeRho = Ye*rho


         write(*,1) 'logT', logT
         write(*,1) 'logRho', logRho
         write(*,1) 'ye', ye
         write(*,1) 'eta', eta
         write(*,1) 'T9', T9
         write(*,1) 'lYeRho', log10_cr(YeRho)
         write(*,*)
         
         ! table vals      ldecay      lcapture    lneutrino
         ! n => p          -10.135     -11.356     -10.416
         ! p => n          -100        0.859       1.381
         ! ni56 => co56    -6.019      1.104       1.578
         ! co56 => ni56    -14.680     -17.520     -14.866
         
         nr = num_weak_reactions
         allocate( &
		      ids(nr), ldecay(nr), d_ldecay_dT9(nr), d_ldecay_dlYeRho(nr), &
		      lcapture(nr), d_lcapture_dT9(nr), d_lcapture_dlYeRho(nr), &
		      lneutrino(nr), d_lneutrino_dT9(nr), d_lneutrino_dlYeRho(nr), &
		      lambda(nr), dlambda_dlnT(nr), dlambda_dlnRho(nr), &
		      Q(nr), dQ_dlnT(nr), dQ_dlnRho(nr), &
		      Qneu(nr), dQneu_dlnT(nr), dQneu_dlnRho(nr), &
		      ldecay2(nr), d_ldecay_dT92(nr), d_ldecay_dlYeRho2(nr), &
		      lcapture2(nr), d_lcapture_dT92(nr), d_lcapture_dlYeRho2(nr), &
		      lneutrino2(nr), d_lneutrino_dT92(nr), d_lneutrino_dlYeRho2(nr), &
		      lambda2(nr), dlambda_dlnT2(nr), dlambda_dlnRho2(nr), &
		      Q2(nr), dQ_dlnT2(nr), dQ_dlnRho2(nr), &
		      Qneu2(nr), dQneu_dlnT2(nr), dQneu_dlnRho2(nr), &
		      stat=ierr)
		   if (ierr /= 0) return
         do i = 1, nr
            ids(i) = i
         end do
         
         write(*,*)
         write(*,2) 'nr', nr
         write(*,*)
         
         call eval_weak_reaction_info( &
            nr, ids, cc, T9, YeRho, -1d0, &
		      eta, d_eta_dlnT, d_eta_dlnRho, &
		      ldecay, d_ldecay_dT9, d_ldecay_dlYeRho, &
		      lcapture, d_lcapture_dT9, d_lcapture_dlYeRho, &
		      lneutrino, d_lneutrino_dT9, d_lneutrino_dlYeRho, &
		      lambda, dlambda_dlnT, dlambda_dlnRho, &
		      Q, dQ_dlnT, dQ_dlnRho, &
		      Qneu, dQneu_dlnT, dQneu_dlnRho, &
		      ierr)
		   if (ierr /= 0) then
		      write(*,*) 'failed in eval_weak_reaction_info'
		      stop 1
		   end if
		   
		   if (.true.) then
   		   write(*,'(30x,99a16)') &
   		      'halflife', 'Qneu', 'Qtotal'!, 'lambda', 'ldecay', 'lcapture', 'lneutrino'
   		   do i = 1, nr
   		      ir = ids(i)
   		      if (ir <= 0 .or. ir > size(weak_lhs_nuclide_id)) then
   		         write(*,*) 'ir', ir
   		         stop 1
   		      end if
   		      if (Qneu(i) < 1d-20) cycle
   		      if (ldecay(i) < -20) cycle
   		      weak_lhs = chem_isos% name(weak_lhs_nuclide_id(ir))
   		      weak_rhs = chem_isos% name(weak_rhs_nuclide_id(ir))
   		      write(*,'(a30,99(1pe16.6))') weak_lhs // weak_rhs, &
   		         ln2/exp10_cr(ldecay(i)), Qneu(i), Q(i)!, &
   		         !lambda(i), ldecay(i), lcapture(i), lneutrino(i)
   		   end do
   		   write(*,*)
		   else
   		   write(*,'(30x,5a12,a20)') 'ldecay', 'lcapture', 'lneutrino', 'Q', 'Qneu', 'lambda'
   		   do i = 1, nr
   		      ir = ids(i)
   		      if (ir <= 0 .or. ir > size(weak_lhs_nuclide_id)) then
   		         write(*,*) 'ir', ir
   		         stop 1
   		      end if
   		      weak_lhs = chem_isos% name(weak_lhs_nuclide_id(ir))
   		      weak_rhs = chem_isos% name(weak_rhs_nuclide_id(ir))
   		      write(*,'(a30,5f12.6,e20.12)') weak_lhs // weak_rhs, &
   		         ldecay(i), lcapture(i), lneutrino(i), Q(i), Qneu(i), lambda(i)
   		   end do
   		   write(*,*)
   		   
   		   if (.false.) then
   		   write(*,'(a30,5a12,a20)') 'd_dT9', 'ldecay', 'lcapture', 'lneutrino', 'Q', 'Qneu', 'lambda'
   		   do i = 1, nr
   		      ir = ids(i)
   		      weak_lhs = chem_isos% name(weak_lhs_nuclide_id(ir))
   		      weak_rhs = chem_isos% name(weak_rhs_nuclide_id(ir))
   		      write(*,'(a30,5f12.6,e20.12)') weak_lhs // weak_rhs, &
   		         d_ldecay_dT9(i), d_lcapture_dT9(i), d_lneutrino_dT9(i), &
   		         dQ_dlnT(i), dQneu_dlnT(i), dlambda_dlnT(i)
   		   end do
   		   write(*,*)
   		   end if
		   
   		   if (.false.) then
   		   write(*,'(a30,5a12,a20)') 'd_d_rho', 'ldecay', 'lcapture', 'lneutrino', 'Q', 'Qneu', 'lambda'
   		   do i = 1, nr
   		      ir = ids(i)
   		      weak_lhs = chem_isos% name(weak_lhs_nuclide_id(ir))
   		      weak_rhs = chem_isos% name(weak_rhs_nuclide_id(ir))
   		      write(*,'(a30,5f12.6,e20.12)') weak_lhs // weak_rhs, &
   		         d_ldecay_dlYeRho(i), d_lcapture_dlYeRho(i), d_lneutrino_dlYeRho(i), &
   		         dQ_dlnRho(i), dQneu_dlnRho(i), dlambda_dlnRho(i)
   		   end do
   		   write(*,*)
   		   end if

		   end if
         
         write(*,*) 'done'
         
         deallocate( &
		      ids, ldecay, d_ldecay_dT9, d_ldecay_dlYeRho, &
		      lcapture, d_lcapture_dT9, d_lcapture_dlYeRho, &
		      lneutrino, d_lneutrino_dT9, d_lneutrino_dlYeRho, &
		      lambda, dlambda_dlnT, dlambda_dlnRho, &
		      Q, dQ_dlnT, dQ_dlnRho, &
		      Qneu, dQneu_dlnT, dQneu_dlnRho, &
		      ldecay2, d_ldecay_dT92, d_ldecay_dlYeRho2, &
		      lcapture2, d_lcapture_dT92, d_lcapture_dlYeRho2, &
		      lneutrino2, d_lneutrino_dT92, d_lneutrino_dlYeRho2, &
		      lambda2, dlambda_dlnT2, dlambda_dlnRho2, &
		      Q2, dQ_dlnT2, dQ_dlnRho2, &
		      Qneu2, dQneu_dlnT2, dQneu_dlnRho2)


      end subroutine do_test_weak 


      end module test_weak

