! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 
      module reaclib_support_mic
      use rates_def_mic
      use crlibm_lib
      use chem_def, only: nuclide_data
      
      implicit none

      contains
      
#ifdef offload
      !dir$ options /offload_attribute_target=mic
#endif

      subroutine do_parse_reaction_handle(handle, num_in, num_out, iso_ids, op, ierr)
         use chem_def
         use chem_lib
      	character (len=*), intent(in) :: handle
      	integer, intent(out) :: num_in, num_out
      	integer, intent(out) :: iso_ids(:) ! holds chem_ids for input and output species
      	character (len=*), intent(out) :: op ! e.g., 'pg', 'wk', 'to', or ...
      	integer, intent(out) :: ierr
      	
      	integer :: len, i, j, cnt, cid, extra_in, extra_out
      	logical :: doing_inputs
      	
      	num_in = 0; num_out = 0; op = ''
      	ierr = -1
      	len = len_trim(handle)
      	if (handle(1:2) /= 'r_') return
      	i = 3
      	cnt = 0
      	doing_inputs = .true.
      	do while (i <= len)
      	   call nxt ! set j to last char of token
      	   cid = chem_get_iso_id(handle(i:j))
      	   if (cid == nuclide_not_found) then
      	      if (doing_inputs) then
      	         op = handle(i:j)
      	         extra_in = -1
      	         extra_out = -1
      	         if (j == i+1) then ! check 2 character ops
         	         select case (op(1:1))
         	            case ('p')
         	               extra_in = ih1
         	            case ('a')
         	               extra_in = ihe4
         	            case ('n')
         	               extra_in = ineut
         	            case ('g')
         	               extra_in = 0
         	            case default
         	         end select
         	         if (extra_in >= 0) then
         	            if (extra_in > 0) then
         	               cnt = cnt+1
         	               if (cnt /= 2) then
         	                  !write(*,*) 'failed to parse ' // &
         	                  !   trim(handle) // ' -- problem with ' // handle(i:j)
         	                  return
         	               end if
         	               if (chem_isos% Z(iso_ids(1)) >= chem_isos% Z(extra_in)) then
            	               iso_ids(2) = iso_ids(1)
            	               iso_ids(1) = extra_in
         	               else
            	               iso_ids(2) = extra_in
         	               end if
         	            end if
            	         select case (op(2:2))
            	            case ('p')
            	               extra_out = ih1
            	            case ('a')
            	               extra_out = ihe4
            	            case ('n')
            	               extra_out = ineut
            	            case ('g')
            	               extra_out = 0
            	            case default
         	                  !write(*,*) 'failed to parse ' // &
         	                  !   trim(handle) // ' -- problem with ' // handle(i:j)
         	                  return
            	         end select
            	      end if   	         
      	         end if
      	         num_in = cnt
      	         doing_inputs = .false.
   	            if (extra_out > 0) then
   	               cnt = cnt+1
   	               iso_ids(cnt) = extra_out
   	            end if
      	      else
      	         !write(*,*) 'failed to parse ' // &
      	         !   trim(handle) // ' -- problem with ' // handle(i:j)
      	         return
      	      end if
      	   else
      	      cnt = cnt+1
      	      iso_ids(cnt) = cid
      	   end if
      	   i = j+2
      	end do
      	num_out = cnt - num_in
      	ierr = 0
      	
      	contains
      	
#ifdef offload
         !dir$ attributes offload: mic :: nxt
#endif
      	subroutine nxt
      	   j = i
      	   do
      	      if (j >= len) return
      	      j = j+1
      	      if (handle(j:j) == '_') then
      	         j = j-1; return
      	      end if
      	   end do
      	end subroutine nxt
      	

      end subroutine do_parse_reaction_handle

      subroutine reaction_handle(num_in, num_out, iso_ids, reaction_flag, handle)
         use chem_def, only: chem_isos
      	integer, intent(in) :: num_in, num_out
      	integer, intent(in) :: iso_ids(:)
      	character (len=*), intent(in) :: reaction_flag
      	character (len=*), intent(out) :: handle
      	logical, parameter :: reverse = .false.
         call get1_reaction_handle(num_in, num_out, iso_ids, chem_isos, reverse, reaction_flag, handle)
      end subroutine reaction_handle
      
      subroutine reverse_reaction_handle(num_in, num_out, iso_ids, handle)
         use chem_def, only: chem_isos
      	integer, intent(in) :: num_in, num_out
      	integer, intent(in) :: iso_ids(:)
      	character (len=*), intent(out) :: handle
      	logical, parameter :: reverse = .true.
      	character (len=1) :: reaction_flag = '-'
         call get1_reaction_handle(num_in, num_out, iso_ids, chem_isos, reverse, reaction_flag, handle)
      end subroutine reverse_reaction_handle         
      
      subroutine get_reaction_handle(num_in, num_out, pspecies, nuclides, reaction_flag, handle)
      	integer, intent(in) :: num_in, num_out
      	integer, intent(in) :: pspecies(:)
      	type(nuclide_data), intent(in) :: nuclides
      	character (len=*), intent(in) :: reaction_flag
      	character (len=*), intent(out) :: handle
      	logical, parameter :: reverse = .false.
         call get1_reaction_handle(num_in, num_out, pspecies, nuclides, reverse, reaction_flag, handle)
      end subroutine get_reaction_handle
      
      subroutine get_reverse_reaction_handle(num_in, num_out, pspecies, nuclides, handle)
      	integer, intent(in) :: num_in, num_out
      	integer, intent(in) :: pspecies(:)
      	type(nuclide_data), intent(in) :: nuclides
      	character (len=*), intent(out) :: handle
      	logical, parameter :: reverse = .true.
      	character (len=1) :: reaction_flag = '-'
         call get1_reaction_handle(num_in, num_out, pspecies, nuclides, reverse, reaction_flag, handle)
      end subroutine get_reverse_reaction_handle
      
      subroutine get1_reaction_handle( &
            num_in, num_out, pspecies_in, nuclides, reverse, reaction_flag, handle)
         use chem_def, only: ih1, ih2, ih3, ihe3, ihe4, ibe7, ili7, chem_isos
      	integer, intent(in) :: num_in, num_out
      	integer, intent(in) :: pspecies_in(:)
      	type(nuclide_data), intent(in) :: nuclides
      	logical, intent(in) :: reverse
      	character (len=*), intent(in) :: reaction_flag
      	character (len=*), intent(out) :: handle

      	integer :: in1, in2, out1, out2, num, pspecies(num_in + num_out)
      	logical :: do_long_form, ec_flag, wk_flag
      	
      	include 'formats.dek'
      	
      	num = num_in + num_out
      	pspecies(1:num) = pspecies_in(1:num)
      	call sort(num_in, pspecies(1:num_in))
      	call sort(num_out, pspecies(num_in+1:num))
      	ec_flag = (reaction_flag == 'e')
      	wk_flag = (reaction_flag == 'w')
      	
			if (ec_flag) then ! special cases
			   if (reverse) then
			      handle = ''
			      return
			   end if
   			if (num_in == 2 .and. num_out == 1) then
   			   if (nuclides% chem_id(pspecies(1)) == ih1 .and. &
   			       nuclides% chem_id(pspecies(2)) == ih1 .and. &
   			       nuclides% chem_id(pspecies(3)) == ih2) then
   			      handle = 'r_h1_h1_ec_h2'
   			      return
   			   end if
   			else if (num_in == 1 .and. num_out == 1) then
   			   if (nuclides% chem_id(pspecies(1)) == ihe3 .and. &
   			       nuclides% chem_id(pspecies(2)) == ih3) then
   			      handle = 'r_he3_ec_h3'
   			      return
   			   end if
   			   if (nuclides% chem_id(pspecies(1)) == ibe7 .and. &
   			       nuclides% chem_id(pspecies(2)) == ili7) then
   			      handle = 'r_be7_wk_li7'
   			      return 
   			   end if
   			end if
   		else if (wk_flag) then
			   if (reverse) then
			      handle = ''
			      return
			   end if
   			if (num_in == 2 .and. num_out == 1) then
   			   if (nuclides% chem_id(pspecies(1)) == ih1 .and. &
   			       nuclides% chem_id(pspecies(2)) == ih1 .and. &
   			       nuclides% chem_id(pspecies(3)) == ih2) then
   			      handle = 'r_h1_h1_wk_h2'
   			      return
   			   end if
   			else if (num_in == 2 .and. num_out == 1) then
   			   if (nuclides% chem_id(pspecies(1)) == ih1 .and. &
   			       nuclides% chem_id(pspecies(2)) == ihe3 .and. &
   			       nuclides% chem_id(pspecies(3)) == ihe4) then
   			      handle = 'r_h1_he3_wk_he4'
   			      return
   			   end if
   			end if
			end if

      	in1 = 0; in2 = 0; out1 = 0; out2 = 0
      	do_long_form = .true.
      	if (num_in == 1 .and. num_out == 1) then
			   call do_n_to_m(1,1)
			   do_long_form = one_one()
      	else if (num_in == 1 .and. num_out == 2) then
			   call do_n_to_m(1,2)
			   if (reverse) then
			      do_long_form = two_one()
			   else
			      do_long_form = one_two()
			   end if
      	else if (num_in == 2 .and. num_out == 1) then
			   call do_n_to_m(2,1)
			   if (reverse) then
			      do_long_form = one_two()
			   else
			      do_long_form = two_one()
			   end if
      	else if (num_in == 2 .and. num_out == 2) then
			   call do_n_to_m(2,2)
			   do_long_form = two_two()			   
			end if

         if (do_long_form) then
            call long_form
			else if (out2 /= 0) then
			   handle = trim(handle) // '_' // nuclides% name(out2)
			else
			   handle = trim(handle) // '_' // nuclides% name(out1)
			end if

			
			contains
			
#ifdef offload
      !dir$ attributes offload: mic :: sort
#endif
			subroutine sort(n, species)
			   integer :: n
			   integer :: species(n)
			   integer :: i, j, Zi, Ni, Zj, Nj, isomer_j, isomer_i, cid
			   include 'formats.dek'
			   do i=1,n-1
			      cid = species(i)
			      if (cid <= 0) cycle
			      Zi = chem_isos% Z(cid)
			      Ni = chem_isos% N(cid)
			      isomer_i = chem_isos% isomeric_state(cid)
			      do j=i+1,n
			         cid = species(j)
			         if (cid <= 0) cycle
			         Zj = chem_isos% Z(cid)
		            Nj = chem_isos% N(cid)
	               isomer_j = chem_isos% isomeric_state(cid)
			         if (Zj > Zi) cycle
			         if (Zj == Zi) then
			            if (Nj > Ni) cycle
			            if (Nj == Ni) then
			               if (isomer_j >= isomer_i) cycle
			            end if
			         end if
			         ! exchange i and j
			         species(j) = species(i)
			         species(i) = cid
			         Zi = Zj
			         Ni = Nj
			         isomer_i = isomer_j
			      end do
			   end do
			end subroutine sort
			
#ifdef offload
      !dir$ attributes offload: mic :: long_form
#endif
			subroutine long_form
			   integer :: i, cid
			   character (len=3) :: op
            handle = 'r_'
         	if (wk_flag) then
         	   op = 'wk_'
         	else if (ec_flag) then
         	   op = 'ec_'
         	else
         	   op = 'to_'
         	end if
            if (reverse) then
            	do i = num_in+1,num_in+num_out
            	   cid = pspecies(i)
            		handle = trim(handle) // trim(nuclides% name(cid)) // '_'
            	end do
            	handle = trim(handle) // op
            	do i = 1,num_in
            	   cid = pspecies(i)
            		handle = trim(handle) // trim(nuclides% name(cid))
            		if (i < num_in) handle = trim(handle) // '_'
            	end do
            else
            	do i = 1,num_in
            	   cid = pspecies(i)
            		handle = trim(handle) // trim(nuclides% name(cid)) // '_'
            	end do
            	handle = trim(handle) // op
            	do i = num_in+1,num_in+num_out
            	   cid = pspecies(i)
            		handle = trim(handle) // trim(nuclides% name(cid))
            		if (i < num_in+num_out) handle = trim(handle) // '_'
            	end do
            end if
			end subroutine long_form
			
#ifdef offload
      !dir$ attributes offload: mic :: one_one
#endif
			logical function one_one()
			   one_one = .true.
			   if (in1 == 0 .or. out1 == 0) return
			   one_one = .false.
			   if (nuclides% Z(out1) == nuclides% Z(in1) - 1 .and. &
			       nuclides% N(out1) == nuclides% N(in1) + 1) then
			      handle = trim(handle) // '_wk'
			   else if (nuclides% Z(out1) == nuclides% Z(in1) + 1 .and. &
			            nuclides% N(out1) == nuclides% N(in1) - 1) then
			      handle = trim(handle) // '_wk-minus'
			   else
   			   one_one = .true.
			   end if
			end function one_one
			
#ifdef offload
      !dir$ attributes offload: mic :: one_two
#endif
			logical function one_two()
			   one_two = .true.
			   if (in1 == 0 .or. out1 == 0 .or. out2 == 0 .or. out1 == out2) return
			   one_two = .false.
			   if (nuclides% Z(out1) == 0 .and. nuclides% N(out1) == 1 .and. &
			            nuclides% Z(out2) == nuclides% Z(in1) .and. &
			            nuclides% N(out2) == nuclides% N(in1) - 1) then
			      handle = trim(handle) // '_gn'
			   else if (nuclides% Z(out1) == 1 .and. nuclides% N(out1) == 0 .and. &
			            nuclides% Z(out2) == nuclides% Z(in1) - 1 .and. &
			            nuclides% N(out2) == nuclides% N(in1)) then
			      handle = trim(handle) // '_gp'
			   else if (nuclides% Z(out1) == 2 .and. nuclides% N(out1) == 2 .and. &
			            nuclides% Z(out2) == nuclides% Z(in1) - 2 .and. &
			            nuclides% N(out2) == nuclides% N(in1) - 2) then
			      handle = trim(handle) // '_ga'
			   else if (nuclides% Z(out1) == 1 .and. nuclides% N(out1) == 0 .and. &
			            nuclides% Z(out2) == nuclides% Z(in1) - 2 .and. &
			            nuclides% N(out2) == nuclides% N(in1) + 1) then
			      handle = trim(handle) // '_wk_h1'
			   else if (nuclides% Z(out1) == 2 .and. nuclides% N(out1) == 2 .and. &
			            nuclides% Z(out2) == nuclides% Z(in1) - 3 .and. &
			            nuclides% N(out2) == nuclides% N(in1) - 1) then
			      handle = trim(handle) // '_wk_he4'
			   else
			      one_two = .true.
			   end if
			end function one_two
			
#ifdef offload
      !dir$ attributes offload: mic :: two_one
#endif
			logical function two_one()
			   include 'formats.dek'
			   two_one = .true.
			   if (in1 == 0 .or. in2 == 0 .or. out1 == 0 .or. in1 == in2) return
			   two_one = .false.
			   if (nuclides% Z(in1) == 0 .and. nuclides% N(in1) == 1 .and. &
			            nuclides% Z(out1) == nuclides% Z(in2) .and. &
			            nuclides% N(out1) == nuclides% N(in2) + 1) then
			      handle = trim(handle) // '_ng'
			   else if (nuclides% Z(in1) == 1 .and. nuclides% N(in1) == 0 .and. &
			            nuclides% Z(out1) == nuclides% Z(in2) + 1 .and. &
			            nuclides% N(out1) == nuclides% N(in2)) then
			      handle = trim(handle) // '_pg'
			   else if (nuclides% Z(in1) == 2 .and. nuclides% N(in1) == 2 .and. &
			            nuclides% Z(out1) == nuclides% Z(in2) + 2 .and. &
			            nuclides% N(out1) == nuclides% N(in2) + 2) then
			      handle = trim(handle) // '_ag'
			   else
			      two_one = .true.
			   end if
			end function two_one
			
#ifdef offload
      !dir$ attributes offload: mic :: two_two
#endif
			logical function two_two()
			   two_two = .true.
			   if (in1 == 0 .or. in2 == 0 .or. out1 == 0 .or. out2 == 0 .or. &
			       in1 == in2 .or. out1 == out2) return
			   two_two = .false.
			   if (nuclides% Z(in1) == 2 .and. nuclides% N(in1) == 2 .and. &
			            nuclides% Z(out1) == 1 .and. nuclides% N(out1) == 0 .and. &
			            nuclides% Z(out2) == nuclides% Z(in2) + 1 .and. &
			            nuclides% N(out2) == nuclides% N(in2) + 2) then
			      handle = trim(handle) // '_ap'
			   else if (nuclides% Z(in1) == 1 .and. nuclides% N(in1) == 0 .and. &
			            nuclides% Z(out1) == 2 .and. nuclides% N(out1) == 2 .and. &
			            nuclides% Z(out2) == nuclides% Z(in2) - 1 .and. &
			            nuclides% N(out2) == nuclides% N(in2) - 2) then
			       handle = trim(handle) // '_pa'
			   else if (nuclides% Z(in1) == 2 .and. nuclides% N(in1) == 2 .and. &
			            nuclides% Z(out1) == 0 .and. nuclides% N(out1) == 1 .and. &
			            nuclides% Z(out2) == nuclides% Z(in2) + 2 .and. &
			            nuclides% N(out2) == nuclides% N(in2) + 1) then
			       handle = trim(handle) // '_an'
			   else if (nuclides% Z(in1) == 0 .and. nuclides% N(in1) == 1 .and. &
			            nuclides% Z(out1) == 2 .and. nuclides% N(out1) == 2 .and. &
			            nuclides% Z(out2) == nuclides% Z(in2) - 2 .and. &
			            nuclides% N(out2) == nuclides% N(in2) - 1) then
			       handle = trim(handle) // '_na'
			   else if (nuclides% Z(in1) == 1 .and. nuclides% N(in1) == 0 .and. &
			            nuclides% Z(out1) == 0 .and. nuclides% N(out1) == 1 .and. &
			            nuclides% Z(out2) == nuclides% Z(in2) + 1 .and. &
			            nuclides% N(out2) == nuclides% N(in2) - 1) then
			       handle = trim(handle) // '_pn'
			   else if (nuclides% Z(in1) == 0 .and. nuclides% N(in1) == 1 .and. &
			            nuclides% Z(out1) == 1 .and. nuclides% N(out1) == 0 .and. &
			            nuclides% Z(out2) == nuclides% Z(in2) - 1 .and. &
			            nuclides% N(out2) == nuclides% N(in2) + 1) then
			       handle = trim(handle) // '_np'
			   else
			      two_two = .true.
			   end if
			end function two_two
			
#ifdef offload
      !dir$ attributes offload: mic :: do_n_to_m
#endif
			subroutine do_n_to_m(n,m)
			   integer, intent(in) :: n, m ! each is either 1 or 2
			   integer :: j
			   in1 = 0; in2 = 0; out1 = 0; out2 = 0
			   if (.not. reverse) then
			      in1 = pspecies(1)
   			   if (n == 2) then
   			      in2 = pspecies(2)
   			      if (in2 == 0) then
   			         in1 = 0; return
   			      end if
   			      call switch_if_necessary(in1,in2)
   			      handle = 'r_' // nuclides% name(in2)
   			   else if (n == 1) then
      			   handle = 'r_' // nuclides% name(in1)
      			else
      			   in1 = 0
      			   return
   			   end if
   			   out1 = pspecies(n+1)
   			   if (m == 2) then
   			      out2 = pspecies(n+2)
   			      call switch_if_necessary(out1,out2)
   			   end if
   			else
			      in1 = pspecies(n+1)
   			   if (m == 2) then
   			      in2 = pspecies(n+2)
   			      if (in2 == 0) then
   			         in1 = 0; return
   			      end if
   			      call switch_if_necessary(in1,in2)
   			      handle = 'r_' // nuclides% name(in2)
   			   else if (m == 1) then
   			      handle = 'r_' // nuclides% name(in1)
   			   else
   			      in1 = 0
   			      return
   			   end if
   			   out1 = pspecies(1)
   			   if (n == 2) then
   			      out2 = pspecies(2)
   			      call switch_if_necessary(out1,out2)
   			   end if
   			end if
			end subroutine do_n_to_m
			
#ifdef offload
      !dir$ attributes offload: mic :: switch_if_necessary
#endif
			subroutine switch_if_necessary(iso1,iso2)
			   integer, intent(inout) :: iso1, iso2
			   integer :: j
			   if (nuclides% Z(iso2) == 1 .and. nuclides% N(iso2) == 0) then ! iso2 is ih1
			      j = iso1; iso1 = iso2; iso2 = j; return
			   end if
			   if (nuclides% Z(iso2) == 2 .and. nuclides% N(iso2) == 2) then ! iso2 is ihe4
			      if (nuclides% Z(iso1) == 1 .and. nuclides% N(iso1) == 0) return ! iso1 is ih1
			      j = iso1; iso1 = iso2; iso2 = j; return
			   end if
			end subroutine switch_if_necessary
			
			
		end subroutine get1_reaction_handle
		
#ifdef offload
      !dir$ end options
#endif

      end module reaclib_support_mic
