! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module rates_initialize_mic
      use const_def
      use crlibm_lib
      use rates_def_mic
      
      implicit none
            
      
      contains
      
      
      integer function lookup_rate_name(str) ! -1 if not found
         use rates_def_mic
         character (len=*), intent(in) :: str
         integer :: i
         lookup_rate_name = -1
         do i = 1, rates_reaction_id_max
            if (trim(str) == trim(reaction_Name(i))) then
               lookup_rate_name = i
               return
            end if
         end do
      end function lookup_rate_name

#ifdef offload
      !dir$ attributes offload: mic :: grow_reactions_arrays
#endif         
      subroutine grow_reactions_arrays(old_max, new_max, ierr)
         use utils_lib
         integer, intent(in) :: old_max, new_max
         integer, intent(out) :: ierr

         character (len=maxlen_reaction_Name), pointer :: new_reaction_Name(:)
         character (len=maxlen_reaction_Info), pointer :: new_reaction_Info(:)
         integer :: i
         
         include 'formats'
         
         allocate(new_reaction_Name(new_max))
         do i=1,old_max
            new_reaction_Name(i) = reaction_Name(i)
         end do
         deallocate(reaction_Name)
         reaction_Name => new_reaction_Name

         allocate(new_reaction_Info(new_max))
         do i=1,old_max
            new_reaction_Info(i) = reaction_Info(i)
         end do
         deallocate(reaction_Info)
         reaction_Info => new_reaction_Info

         call realloc_integer(reaction_categories,new_max,ierr); if (ierr /= 0) return
         call realloc_integer(reaction_is_reverse,new_max,ierr); if (ierr /= 0) return
         call realloc_integer(reaction_reaclib_lo,new_max,ierr); if (ierr /= 0) return
         call realloc_integer(reaction_reaclib_hi,new_max,ierr); if (ierr /= 0) return
         call realloc_integer(reverse_reaction_id,new_max,ierr); if (ierr /= 0) return

         call realloc_double(std_reaction_Qs,new_max,ierr); if (ierr /= 0) return
         call realloc_double(std_reaction_neuQs,new_max,ierr); if (ierr /= 0) return
         
         call realloc_double(weak_lowT_rate,new_max,ierr); if (ierr /= 0) return
         
         call realloc_integer2( &
            reaction_screening_info,size( &
            reaction_screening_info,dim=1),new_max,ierr); if (ierr /= 0) return
         call realloc_integer2( &
            weak_reaction_info,2,new_max,ierr); if (ierr /= 0) return
         call realloc_integer2( &
            reaction_ye_rho_exponents,2,new_max,ierr); if (ierr /= 0) return
         call realloc_integer2( &
            reaction_inputs,2*max_num_reaction_inputs,new_max,ierr); if (ierr /= 0) return
         call realloc_integer2( &
            reaction_outputs,2*max_num_reaction_outputs,new_max,ierr); if (ierr /= 0) return
         
         reaction_Info(rates_reaction_id_max:new_max) = ''
         reaction_categories(rates_reaction_id_max:new_max) = -1

         reaction_is_reverse(rates_reaction_id_max:new_max) = 0
         reaction_reaclib_lo(rates_reaction_id_max:new_max) = 0
         reaction_reaclib_hi(rates_reaction_id_max:new_max) = 0
         reverse_reaction_id(rates_reaction_id_max:new_max) = 0

         reaction_screening_info(:,rates_reaction_id_max:new_max) = 0
         weak_reaction_info(:,rates_reaction_id_max:new_max) = 0
         reaction_ye_rho_exponents(:,rates_reaction_id_max:new_max) = 0
         reaction_inputs(:,rates_reaction_id_max:new_max) = 0
         reaction_outputs(:,rates_reaction_id_max:new_max) = 0
         std_reaction_Qs(rates_reaction_id_max:new_max) = -1d99
         std_reaction_neuQs(rates_reaction_id_max:new_max) = -1d99
         weak_lowT_rate(rates_reaction_id_max:new_max) = -1d99
      
      end subroutine grow_reactions_arrays

#ifdef offload
      !dir$ attributes offload: mic :: do_copy_rates_info_to_coprocessor
#endif
      subroutine do_copy_rates_info_to_coprocessor( & ! on mic
            new_max, rates_max, &
            reaction_Name_in, &
            reaction_Info_in, &
            reaction_categories_in, &
            reaction_is_reverse_in, &
            reaction_reaclib_lo_in, &
            reaction_reaclib_hi_in, &
            reverse_reaction_id_in, &
            reaction_screening_info_in, &
            weak_reaction_info_in, &
            reaction_ye_rho_exponents_in, &
            reaction_inputs_in, &
            reaction_outputs_in, &
            std_reaction_Qs_in, &
            std_reaction_neuQs_in, &
            weak_lowT_rate_in, &
            names_dict_keys, &
            names_dict_values, &
            ierr)
         use utils_lib, only: integer_dict_define
         use utils_def, only: maxlen_key_string

         integer, intent(in) :: new_max, rates_max
         character (len=maxlen_reaction_Name), pointer, intent(in) :: reaction_Name_in(:) 
            ! (rates_reaction_id_max)
         character (len=maxlen_reaction_Info), pointer, intent(in) :: reaction_Info_in(:) 
            ! (rates_reaction_id_max)
         integer, pointer, intent(in) :: reaction_categories_in(:) 
            ! (rates_reaction_id_max) set by net using reactions.list info
         integer, pointer, intent(in) :: reaction_is_reverse_in(:)
         integer, pointer, intent(in) :: reaction_reaclib_lo_in(:)
         integer, pointer, intent(in) :: reaction_reaclib_hi_in(:)
         integer, pointer, intent(in) :: reverse_reaction_id_in(:)
         integer, pointer, intent(in) :: reaction_screening_info_in(:,:) 
            !(3,rates_reaction_id_max)
         integer, pointer, intent(in) :: weak_reaction_info_in(:,:) 
            ! (2,rates_reaction_id_max)
         integer, pointer, intent(in) :: reaction_ye_rho_exponents_in(:,:) 
            ! (2,rates_reaction_id_max)
         integer, pointer, intent(in) :: reaction_inputs_in(:,:) 
            ! (2*max_num_reaction_inputs,rates_reaction_id_max)
         integer, pointer, intent(in) :: reaction_outputs_in(:,:) 
            ! (2*max_num_reaction_outputs,rates_reaction_id_max)
         real(dp), pointer, intent(in) :: std_reaction_Qs_in(:) ! (rates_reaction_id_max) 
         real(dp), pointer, intent(in) :: std_reaction_neuQs_in(:) ! (rates_reaction_id_max) 
         real(dp), pointer, intent(in) :: weak_lowT_rate_in(:) ! (rates_reaction_id_max) 
         character (len=maxlen_key_string), pointer, intent(in) :: names_dict_keys(:)
         integer, pointer, intent(in) :: names_dict_values(:)
         integer, intent(out) :: ierr

         integer :: i, sz
         include 'formats'
         
         ierr = 0         

         call do_start_rates_def_init(ierr)
         if (ierr /= 0) return
         call do_rates_init(ierr)  ! for mazurek
         if (ierr /= 0) return
         
         rates_reaction_id_max = rates_max
         allocate( &
            reaction_Name(new_max),  &
            reaction_Info(new_max),  &
            reaction_categories(new_max),  &
            reaction_is_reverse(new_max),  &
            reaction_reaclib_lo(new_max),  &
            reaction_reaclib_hi(new_max),  &
            reverse_reaction_id(new_max),  &
            std_reaction_Qs(new_max),  &
            std_reaction_neuQs(new_max),   &
            weak_lowT_rate(new_max),   &
            reaction_screening_info(3,new_max),  &
            weak_reaction_info(2,new_max),  &
            reaction_ye_rho_exponents(2,new_max),  &
            reaction_inputs(2*max_num_reaction_inputs,new_max),  &
            reaction_outputs(2*max_num_reaction_outputs,new_max),  &
            stat=ierr)
         if (ierr /= 0) return
         
         do i=1,new_max
            reaction_Name(i) = reaction_Name_in(i)
            reaction_Info(i) = reaction_Info_in(i)
            reaction_categories(i) = reaction_categories_in(i)
            reaction_is_reverse(i) = reaction_is_reverse_in(i)
            reaction_reaclib_lo(i) = reaction_reaclib_lo_in(i)
            reaction_reaclib_hi(i) = reaction_reaclib_hi_in(i)
            reverse_reaction_id(i) = reverse_reaction_id_in(i)
            std_reaction_Qs(i) = std_reaction_Qs_in(i)
            std_reaction_neuQs(i) = std_reaction_neuQs_in(i)
            weak_lowT_rate(i) = weak_lowT_rate_in(i)
            reaction_screening_info(:,i) = reaction_screening_info_in(:,i)
            weak_reaction_info(:,i) = weak_reaction_info_in(:,i)
            reaction_ye_rho_exponents(:,i) = reaction_ye_rho_exponents_in(:,i)
            reaction_inputs(:,i) = reaction_inputs_in(:,i)
            reaction_outputs(:,i) = reaction_outputs_in(:,i)
         end do

         ! copy reaction_names_dict
         nullify(reaction_names_dict)
         sz = size(names_dict_values,dim=1)
         do i=1,sz
            call integer_dict_define(reaction_names_dict, &
               names_dict_keys(i), names_dict_values(i), ierr)
            if (ierr /= 0) return
         end do

         have_finished_initialization = .true.
         
      end subroutine do_copy_rates_info_to_coprocessor
      
#ifdef offload
      !dir$ attributes offload: mic :: do_rates_init
#endif         
      subroutine do_rates_init(ierr)
         use ratelib_mic, only: mazurek_init
         integer, intent(out) :: ierr
         ierr = 0
         ! setup interpolation info for mazurek's 1973 fits for the ni56 electron capture rate
         call mazurek_init(ierr)
         if (ierr /= 0) return
      end subroutine do_rates_init

#ifdef offload
      subroutine copy_rates_info_to_coprocessor(ierr) ! on host, after init_rates_info
         use rates_def_mic
         use utils_lib, only: integer_dict_size, get_dict_entries
         use utils_def, only: maxlen_key_string
         integer, intent(out) :: ierr
         
         integer :: rates_max
         character (len=maxlen_reaction_Name), pointer :: reaction_Name_in(:) 
            ! (rates_reaction_id_max)
         character (len=maxlen_reaction_Info), pointer :: reaction_Info_in(:) 
            ! (rates_reaction_id_max)
         integer, pointer :: reaction_categories_in(:) 
            ! (rates_reaction_id_max) set by net using reactions.list info
         integer, pointer :: reaction_is_reverse_in(:)
         integer, pointer :: reaction_reaclib_lo_in(:)
         integer, pointer :: reaction_reaclib_hi_in(:)
         integer, pointer :: reverse_reaction_id_in(:)
         integer, pointer :: reaction_screening_info_in(:,:) 
            !(3,rates_reaction_id_max)
         integer, pointer :: weak_reaction_info_in(:,:) 
            ! (2,rates_reaction_id_max)
         integer, pointer :: reaction_ye_rho_exponents_in(:,:) 
            ! (2,rates_reaction_id_max)
         integer, pointer :: reaction_inputs_in(:,:) 
            ! (2*max_num_reaction_inputs,rates_reaction_id_max)
         integer, pointer :: reaction_outputs_in(:,:) 
            ! (2*max_num_reaction_outputs,rates_reaction_id_max)
         real(dp), pointer :: std_reaction_Qs_in(:) ! (rates_reaction_id_max) 
         real(dp), pointer :: std_reaction_neuQs_in(:) ! (rates_reaction_id_max) 
         real(dp), pointer :: weak_lowT_rate_in(:) ! (rates_reaction_id_max)          
         character (len=maxlen_key_string), pointer :: reaction_names_dict_keys(:)
         integer, pointer :: reaction_names_dict_values(:)
         
         integer :: new_max, sz
         
         include 'formats'
         
         ierr = 0
         rates_max = rates_reaction_id_max
         reaction_Name_in => reaction_Name
         reaction_Info_in => reaction_Info
         reaction_categories_in => reaction_categories
         reaction_is_reverse_in => reaction_is_reverse
         reaction_reaclib_lo_in => reaction_reaclib_lo
         reaction_reaclib_hi_in => reaction_reaclib_hi
         reverse_reaction_id_in => reverse_reaction_id
         reaction_screening_info_in => reaction_screening_info
         weak_reaction_info_in => weak_reaction_info
         reaction_ye_rho_exponents_in => reaction_ye_rho_exponents
         reaction_inputs_in => reaction_inputs
         reaction_outputs_in => reaction_outputs
         std_reaction_Qs_in => std_reaction_Qs
         std_reaction_neuQs_in => std_reaction_neuQs
         weak_lowT_rate_in => weak_lowT_rate
         
         ! copy reaction_names_dict
         sz = integer_dict_size(reaction_names_dict)
         allocate(reaction_names_dict_keys(sz), reaction_names_dict_values(sz))
         call get_dict_entries( &
            reaction_names_dict, reaction_names_dict_keys, reaction_names_dict_values)
            
         new_max = size(reaction_Name,dim=1)
         !dir$ offload target(mic) out(ierr) in( &
            new_max, rates_max, &
            reaction_Name_in, &
            reaction_Info_in, &
            reaction_categories_in, &
            reaction_is_reverse_in, &
            reaction_reaclib_lo_in, &
            reaction_reaclib_hi_in, &
            reverse_reaction_id_in, &
            reaction_screening_info_in, &
            weak_reaction_info_in, &
            reaction_ye_rho_exponents_in, &
            reaction_inputs_in, &
            reaction_outputs_in, &
            std_reaction_Qs_in, &
            std_reaction_neuQs_in, &
            weak_lowT_rate_in, &
            reaction_names_dict_keys, &
            reaction_names_dict_values)
         call do_copy_rates_info_to_coprocessor( &
            new_max, rates_max, &
            reaction_Name_in, &
            reaction_Info_in, &
            reaction_categories_in, &
            reaction_is_reverse_in, &
            reaction_reaclib_lo_in, &
            reaction_reaclib_hi_in, &
            reverse_reaction_id_in, &
            reaction_screening_info_in, &
            weak_reaction_info_in, &
            reaction_ye_rho_exponents_in, &
            reaction_inputs_in, &
            reaction_outputs_in, &
            std_reaction_Qs_in, &
            std_reaction_neuQs_in, &
            weak_lowT_rate_in, &
            reaction_names_dict_keys, &
            reaction_names_dict_values, &
            ierr)
         if (ierr /= 0) return

         deallocate(reaction_names_dict_keys, reaction_names_dict_values)
                  
      end subroutine copy_rates_info_to_coprocessor      
      
         
      subroutine copy1_reaction_info_to_coprocessor(ir, ierr) ! runs on host
         integer, intent(in) :: ir
         integer, intent(out) :: ierr

         integer :: rates_max
         character (len=maxlen_reaction_Name) :: reaction_Name_in
         character (len=maxlen_reaction_Info) :: reaction_Info_in
         integer :: reaction_category_in
         integer :: reaction_is_reverse_in
         integer :: reaction_reaclib_lo_in
         integer :: reaction_reaclib_hi_in
         integer :: reverse_reaction_id_in
         integer :: reaction_screening_info_in(3) 
         integer :: weak_reaction_info_in(2) 
         integer :: reaction_ye_rho_exponents_in(2) 
         integer :: reaction_inputs_in(2*max_num_reaction_inputs) 
         integer :: reaction_outputs_in(2*max_num_reaction_outputs) 
         real(dp) :: std_reaction_Q_in
         real(dp) :: std_reaction_neuQ_in
         real(dp) :: weak_lowT_rate_in
      
         rates_max = rates_reaction_id_max
         reaction_Name_in = reaction_Name(ir)
         reaction_Info_in = reaction_Info(ir)
         reaction_category_in = reaction_categories(ir)
         reaction_is_reverse_in = reaction_is_reverse(ir)
         reaction_reaclib_lo_in = reaction_reaclib_lo(ir)
         reaction_reaclib_hi_in = reaction_reaclib_hi(ir)
         reverse_reaction_id_in = reverse_reaction_id(ir)
         std_reaction_Q_in = std_reaction_Qs(ir)
         std_reaction_neuQ_in = std_reaction_neuQs(ir)
         weak_lowT_rate_in = weak_lowT_rate(ir)
         reaction_screening_info_in(:) = reaction_screening_info(:,ir)
         weak_reaction_info_in(:) = weak_reaction_info(:,ir)
         reaction_ye_rho_exponents_in(:) = reaction_ye_rho_exponents(:,ir)
         reaction_inputs_in(:) = reaction_inputs(:,ir)
         reaction_outputs_in(:) = reaction_outputs(:,ir)
      
         !dir$ offload target(mic) out(ierr) in( &
            ir, rates_max, &
            reaction_Name_in, &
            reaction_Info_in, &
            reaction_category_in, &
            reaction_is_reverse_in, &
            reaction_reaclib_lo_in, &
            reaction_reaclib_hi_in, &
            reverse_reaction_id_in, &
            std_reaction_Q_in, &
            std_reaction_neuQ_in, &
            weak_lowT_rate_in, &
            reaction_screening_info_in, &
            weak_reaction_info_in, &
            reaction_ye_rho_exponents_in, &
            reaction_inputs_in, &
            reaction_outputs_in)
         call do_copy1_reaction_info_to_coprocessor( &
            ir, rates_max, &
            reaction_Name_in, &
            reaction_Info_in, &
            reaction_category_in, &
            reaction_is_reverse_in, &
            reaction_reaclib_lo_in, &
            reaction_reaclib_hi_in, &
            reverse_reaction_id_in, &
            std_reaction_Q_in, &
            std_reaction_neuQ_in, &
            weak_lowT_rate_in, &
            reaction_screening_info_in, &
            weak_reaction_info_in, &
            reaction_ye_rho_exponents_in, &
            reaction_inputs_in, &
            reaction_outputs_in, &
            ierr)
         
      
      end subroutine copy1_reaction_info_to_coprocessor

#endif         
      
      end module rates_initialize_mic


