! ***********************************************************************
!
!   Copyright (C) 2006, 2007, 2008  Bill Paxton, Frank Timmes
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful, 
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************


These routines are not currently being included in mesa net.
But they can be added when needed.



















      subroutine rate_aan(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, bb, dbb, cc, dcc, dd, ddd

! he4(an, g)be9
      aa  = 1.0d0 + 0.344*(tf% t9)
      bb  = (tf% t92) * aa
      dbb = 2.0d0 * (tf% t9) * aa + (tf% t92)*0.344

      cc  = 1.0d0/bb
      dcc = -cc*cc*dbb

      dd  = 2.59e-6 * exp(-1.062*(tf% t9i))
      ddd = dd*1.062*(tf% t9i2)

      term    = cc * dd
      dtermdt = dcc*dd + cc*ddd



      fr    = den * den * term 
      dfrdt = den * den * dtermdt * 1.0d-9
      dfrdd = 2.0d0 * den * term

      rev      = 5.84e19 * (tf% t93) * exp(-18.260*(tf% t9i))
      drevdt   = rev*(3.0d0*(tf% t9i) + 18.260*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_aan





      subroutine rate_be9pn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, daa, bb, dbb, cc, dcc, zz, dzz


! be9(p, n)b9
      aa  = 5.58e7*(1.0d0 + 0.042*(tf% t912) + 0.985*(tf% t9))
      daa = 5.58e7*(0.5d0*0.042*(tf% t9i12) + 0.985)
    
      zz  = exp(-21.473*(tf% t9i))
      dzz = zz*21.473*(tf% t9i2)

      bb  = aa * zz
      dbb = daa*zz + aa*dzz

      cc  = 1.02e+09 * (tf% t9i32) * exp(-26.725*(tf% t9i))
      dcc = cc*(-1.5d0*(tf% t9i) + 26.725*(tf% t9i2))

      term    = bb + cc
      dtermdt = dbb + dcc


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term


      bb  = 0.998 * aa 
      dbb = 0.998 * daa  

      cc  = 0.998 * 1.02e+09 * (tf% t9i32) * exp(-5.252*(tf% t9i))
      dcc = cc*(-1.5d0*(tf% t9i) + 5.252*(tf% t9i2))

      term    = bb + cc
      dtermdt = dbb + dcc

      rr    = den * term
      drrdt = den * dtermdt * 1.0d-9
      drrdd = term

      end subroutine rate_be9pn





      subroutine rate_b10an(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, q1
      parameter        (q1 = 1.0d0/91.948921d0)


! b10(a, n)n13
      term    = 1.20e+13 * (tf% t9i23) * exp(-27.989*(tf% t9i13) - (tf% t92)*q1)
      dtermdt = -twoth*term*(tf% t9i) 
     1          + term*(oneth*27.989*(tf% t9i43) - 2.0d0*(tf% t9)*q1)


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 9.34 * exp(-12.287*(tf% t9i))
      drevdt   = rev*12.287*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev*term

      end subroutine rate_b10an





      subroutine rate_b11an_cf88(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, ff, dff, q1
      parameter        (q1 = 1.0d0/0.0196d0)


! b11(a, n)n14
      aa  = 6.97e+12 * (tf% t9i23) * exp(-28.234*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*28.234*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.015*(tf% t913) + 8.115*(tf% t923) + 0.838*(tf% t9)  
     1      + 39.804*(tf% t943) + 10.456*(tf% t953)
      dbb = oneth*0.015*(tf% t9i23) + twoth*8.115*(tf% t9i13) + 0.838
     1      + fourth*39.804*(tf% t913) + fiveth*10.456*(tf% t923) 

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 1.79 * (tf% t9i32) * exp(-2.827*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 2.827*(tf% t9i2))

      ee   = 1.71e+03 * (tf% t9i32) * exp(-5.178*(tf% t9i))
      dee  = ee*(-1.5d0*(tf% t9i) + 5.178*(tf% t9i2))

      ff   = 4.49e+06 * (tf% t935) * exp(-8.596*(tf% t9i))
      dff  = ff*(0.6d0*(tf% t9i) + 8.596*(tf% t9i2))

      term    = cc + dd + ee + ff
      dtermdt = dcc + ddd + dee + dff


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 3.67 * exp(-1.835*(tf% t9i))
      drevdt   = rev*1.835*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev*term

      end subroutine rate_b11an_cf88





      subroutine rate_n14pa(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, bb, dbb, cc, dcc, dd, ddd, 
     1                 t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56, zz


! n14(p, a)c11
       aa     = 1.0d0 + 0.0478*(tf% t9)
       bb     = aa**twoth
       dbb    = twoth*bb/aa*0.0478

       zz     = 1.0d0/bb
       cc     = aa + 7.56e-03*(tf% t953)*zz
       dcc    = 0.0478 + (fiveth*7.56e-3*(tf% t923) - 7.56e-3*(tf% t953)*zz*dbb)*zz

       zz     = 1.0d0/cc
       t9a    = (tf% t9) *zz
       dt9a   = (1.0d0 - t9a*dcc)*zz

       zz      = dt9a/t9a
       t9a13   = t9a**oneth
       dt9a13  = oneth*t9a13*zz

       t9a56   = t9a**fivsix
       dt9a56  = fivsix*t9a56*zz

       dd      = 2.63e+16 * t9a56 * (tf% t9i32) * exp(-31.883/t9a13)
       ddd     = dd*(dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1           + 31.883/t9a13**2 * dt9a13)

       term    = dd * exp(-33.915*(tf% t9i))
       dtermdt = term*(ddd/dd + 33.915*(tf% t9i2))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 0.272 * dd
      drevdt   = 0.272 * ddd

      rr    = den * rev 
      drrdt = den * drevdt * 1.0d-9
      drrdd = rev 

      end subroutine rate_n14pa





      subroutine rate_c11pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, q1
      parameter        (q1 = 1.0d0/2.647129d0)


! c11(p, g)n12
      aa  = 4.24e+04 * (tf% t9i23) * exp(-13.658*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*13.658*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0  + 0.031*(tf% t913) + 3.11*(tf% t923) + 0.665*(tf% t9)
     1      + 4.61*(tf% t943) + 2.50*(tf% t953)
      dbb = oneth*0.031*(tf% t9i23) + twoth*3.11*(tf% t9i13) + 0.665
     1      + fourth*4.61*(tf% t913) + fiveth*2.50*(tf% t923) 

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 8.84e+03 * (tf% t9i32) * exp(-7.021*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 7.021*(tf% t9i2))

      term    = cc + dd 
      dtermdt = dcc + ddd 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 2.33e+10 * (tf% t932) * exp(-6.975*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 6.975*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_c11pg






      subroutine rate_c12an(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, daa, bb, dbb


! c12(a, n)o15
      aa  = 2.48e7 * (1.0d0 + 0.188*(tf% t912) + 0.015*(tf% t9))
      daa = 2.48e7 * (0.5d0*0.188*(tf% t9i12) + 0.015)

      bb  = exp(-98.661*(tf% t9i))
      dbb = bb*98.661*(tf% t9i2)

      term    = aa * bb
      dtermdt = daa*bb + aa*dbb
      


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = den * 1.41 * aa
      drrdt = den * 1.41 * daa  * 1.0d-9
      drrdd = 1.41 * aa

      end subroutine rate_c12an








      subroutine rate_c13pn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, daa, bb, dbb

! c13(p, n)n13
      aa  = 1.88e+08*(1.0d0 - 0.167*(tf% t912) + 0.037*(tf% t9))
      daa = 1.88e+08*(0.037 - 0.5d0*0.167*(tf% t9i12))

      bb  = exp(-34.846*(tf% t9i))
      dbb = bb*34.846*(tf% t9i2)

      term    = aa * bb
      dtermdt = daa*bb + aa*dbb


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = den * 0.998 * aa
      drrdt = den * 0.998 * daa * 1.0d-9
      drrdd = 0.998 * aa

      end subroutine rate_c13pn



      subroutine rate_c14ag(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rc14ag

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, ff, dff, q1
      parameter        (q1 = 1.0d0/7.086244d0)


! c14(a, g)o18
      aa  = 1.528e+09 * (tf% t9i23) * exp(-32.513*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*32.513*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.0128*(tf% t913) - 0.869*(tf% t923) - 0.0779*(tf% t9)
     1      + 0.321*(tf% t943) + 0.0732*(tf% t953)
      dbb = oneth*0.0128*(tf% t9i23) - twoth*0.869*(tf% t9i13) - 0.0779
     1      + fourth*0.321*(tf% t913) + fiveth*0.0732*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 3.375e+08 * (tf% t9i2) * exp(-32.513*(tf% t9i13))
      ddd  = dd*(-2.0d0*(tf% t9i) + oneth*32.513*(tf% t9i43))

      ee   = 9.29e-08 * (tf% t9i32) * exp(-2.048*(tf% t9i))
      dee  = ee*(-1.5d0*(tf% t9i) + 2.048*(tf% t9i2))

      ff   = 2.77e+03 * (tf% t9i45) * exp(-9.876*(tf% t9i))
      dff  = ff*(-0.8d0*(tf% t9i) + 9.876*(tf% t9i2))

      term    = cc + dd + ee + ff 
      dtermdt = dcc + ddd + dee + dff 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 5.42e+10 * (tf% t932) * exp(-72.262*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 72.262*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_c14ag






      subroutine rate_c14pn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, daa, bb, dbb, cc, dcc, zz, dzz


! c14(p, n)n14
      aa  = 7.19e+05*(1.0d0 + 0.361*(tf% t912) + 0.502*(tf% t9))
      daa = 7.19e+05*(0.5d0*0.361*(tf% t9i12) + 0.502)

      zz  = exp(-7.263*(tf% t9i))
      dzz = zz*7.263*(tf% t9i2)

      bb  = aa * zz
      dbb = daa*zz + aa*dzz

      cc  = 3.34e+08 * (tf% t9i12) * exp(-12.246*(tf% t9i))
      dcc = cc*(-0.5d0*(tf% t9i) + 12.246*(tf% t9i2))

      term    = bb + cc
      dtermdt = dbb + dcc  


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      cc  = 3.34e+08 * (tf% t9i12) * exp(-4.983*(tf% t9i))
      dcc = cc*(-0.5d0*(tf% t9i) + 4.983*(tf% t9i2))

      rr    = den * 0.333 * (aa + cc)
      drrdt = den * 0.333 * (daa + dcc) * 1.0d-9
      drrdd = 0.333 * (aa + cc)

      end subroutine rate_c14pn






      subroutine rate_c14pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rc14pg

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, q1
      parameter        (q1 = 1.0d0/32.729841d0)


! c14(p, g)n15
      aa  = 6.80e+06 * (tf% t9i23) * exp(-13.741*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*13.741*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.03*(tf% t913) + 0.503*(tf% t923) + 0.107*(tf% t9)
     1      + 0.213*(tf% t943) + 0.115*(tf% t953)
      dbb = oneth*0.03*(tf% t9i23) + twoth*0.503*(tf% t9i13) + 0.107
     1      + fourth*0.213*(tf% t913) + fiveth*0.115*(tf% t923) 

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 5.36e+03 * (tf% t9i32) * exp(-3.811*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 3.811*(tf% t9i2))

      ee   = 9.82e+04 * (tf% t9i13) * exp(-4.739*(tf% t9i))
      dee  = ee*(-oneth*(tf% t9i) + 4.739*(tf% t9i2))

      term    = cc + dd + ee
      dtermdt = dcc + ddd + dee


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 9.00e+09 * (tf% t932) * exp(-118.452*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 118.452*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_c14pg






      subroutine rate_o16pa(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, bb, dbb, cc, dcc, dd, ddd, 
     1                 t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56, zz


! o16(p, a)n13
       aa     = 1.0d0 + 0.0776*(tf% t9)
       bb     = aa**twoth
       dbb    = twoth*bb/aa*0.0776

       zz     = 1.0d0/bb
       cc     = aa + 0.0264*(tf% t953)*zz
       dcc    = 0.0776 + (fiveth*0.0264*(tf% t923) - 0.0264*(tf% t953)*zz*dbb)*zz

       zz     = 1.0d0/cc
       t9a    = (tf% t9) *zz
       dt9a   = (1.0d0 - t9a*dcc)*zz

       zz      = dt9a/t9a
       t9a13   = t9a**oneth
       dt9a13  = oneth*t9a13*zz

       t9a56   = t9a**fivsix
       dt9a56  = fivsix * t9a56*zz

       dd      = 1.88e+18 * t9a56 * (tf% t9i32) * exp(-35.829/t9a13) 
       ddd     = dd*(dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1           + 35.829/t9a13**2 * dt9a13)

       term    = dd * exp(-60.561*(tf% t9i))
       dtermdt = term*(ddd/dd + 60.561*(tf% t9i2))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 0.172 * dd
      drevdt   = 0.172 * ddd

      rr    = den * rev 
      drrdt = den * drevdt * 1.0d-9
      drrdd = rev 

      end subroutine rate_o16pa





      subroutine rate_n14pn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, daa, bb, dbb

! n14(p, n)o14
      aa  = 6.74e+07 * (1.0d0 + 0.658*(tf% t912) + 0.379*(tf% t9))
      daa = 6.74e+07 * (0.5d0*0.658*(tf% t9i12) + 0.379)

      bb  = exp(-68.762*(tf% t9i))
      dbb = bb*68.762*(tf% t9i2)

      term    = aa * bb
      dtermdt = daa*bb + aa*dbb


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = den * 2.99 * aa
      drrdt = den * 2.99 * daa * 1.0d-9
      drrdd = 2.99 * aa 

      end subroutine rate_n14pn





      subroutine rate_n14an(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, daa, bb, dbb, cc, dcc, zz, dzz, q1
      parameter        (q1 = 1.0d0/7.828804d0) 

! n14(a, n)f17
      aa  = 5.24e9*(1.0d0 - 1.15*(tf% t912) + 0.365*(tf% t9)) 
      daa = 5.24e9*(0.365 - 0.5d0*1.15*(tf% t9i12)) 

      zz  = exp(-(tf% t92)*q1)
      dzz = -zz*2.0d0*(tf% t9)*q1

      bb  = aa * zz
      dbb = daa*zz + aa*dzz

      cc   = 3.28e10 * (tf% t9i32) * exp(-1.5766e1*(tf% t9i))
      dcc  = cc*(-1.5d0*(tf% t9i) + 1.5766e1*(tf% t9i2))

      term     = (bb + cc) * exp(-54.942*(tf% t9i))
      dtermdt  = term*((dbb+dcc)/(bb+cc) + 54.942*(tf% t9i2))


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      term     = 1.48 * (bb + cc)
      dtermdt  = 1.48 * (dbb + dcc)

      rr    = den * term
      drrdt = den * dtermdt * 1.0d-9
      drrdd = term

      end subroutine rate_n14an




      subroutine rate_n15pn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, t9a, aa, daa, bb, dbb

! n15(p, n)o15
      t9a = min((tf% t9), 10.0d0)
      aa  = 3.51e+08 * (1.0d0 + 0.452*(tf% t912) - 0.191*t9a)
      if (t9a .eq. 10.0) then
       daa = 3.51e+08 * 0.5d0*0.452*(tf% t9i12) 
      else 
       daa = 3.51e+08 * (0.5d0*0.452*(tf% t9i12) - 0.191)
      end if

      bb  = exp(-41.032*(tf% t9i))
      dbb = bb*41.032*(tf% t9i2)

      term    = aa * bb
      dtermdt = daa*bb + aa*dbb


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      term    = 0.998 * aa
      dtermdt = 0.998 * daa 

      rr    = den * term
      drrdt = den * dtermdt * 1.0d-9
      drrdd = term

      end subroutine rate_n15pn




      subroutine rate_n15an(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, daa, bb, dbb


! n15(a, n)f18
      aa  = 3.14e8 * (1.0d0 - 0.641*(tf% t912) + 0.108*(tf% t9))
      daa = 3.14e8 * (0.108 - 0.5d0*0.641*(tf% t9i12))

      bb  = exp(-74.479*(tf% t9i))
      dbb = bb*74.479*(tf% t9i2)

      term     = aa * bb
      dtermdt  = daa*bb + aa*dbb


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      term     = 2.0d0 * aa
      dtermdt  = 2.0d0 * daa

      rr    = den * term
      drrdt = den * dtermdt * 1.0d-9
      drrdd = term

      end subroutine rate_n15an





      subroutine rate_n15ag_nacre(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rn15ag [check]
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, q1
      parameter        (q1 = 1.0d0/0.379456d0)


! n15(a, g)f19
   
      ! a0 t9i23 exp(-a1 t9i13 - (t9*a2)^2) 
      !     * (1 + b0 t9 + b1 t92 + b2 t93 + b3 t94 + b4 t95) 
      ! + c0 t9i32 exp(-c1/t9)
      ! + d0 t9i32 exp(-d1/t9)
      ! + e0 t9^e1 exp(-e2/t9)
      call rnacre(tf, 
     >      1.10d11, 36.214d0, 1d0/0.06d0, ! a0, a1, a2
     >      0d0, 0d0, 0d0, 0d0, 0d0, ! b0, b1, b2, b3, b4
     >      1.65d-4, 4.224d0, ! c0, c1     
     >      2.66d0, 6.220d0, ! d0, d1     
     >      0d0, 0d0, 0d0, ! e0, e1, e2    
     >      term, dtermdt)         

      aa   = 1.56d2 * (tf% t9i32) * exp(-7.764d0*(tf% t9i)) 
      daa  = aa*(-1.50d0*(tf% t9i) + 7.764d0*(tf% t9i2))
      
      term = term + aa
      dtermdt = dtermdt + daa
      
      call rnacre_rev(tf,  ! a0 t932 exp(-a1/t9)
     >      5.542d10, 46.577d0, ! a0, a1
     >      rev, drevdt)     

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_n15ag_nacre



      subroutine rate_n15ag(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, q1
      parameter        (q1 = 1.0d0/0.379456d0)


! n15(a, g)f19
      aa  = 2.54e+10 * (tf% t9i23) * exp(-36.211*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*36.211*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.012*(tf% t913) + 1.69*(tf% t923) + 0.136*(tf% t9)
     1      + 1.91*(tf% t943) + 0.391*(tf% t953)
      dbb = oneth*0.012*(tf% t9i23) + twoth*1.69*(tf% t9i13) + 0.136
     1      + fourth*1.91*(tf% t913) + fiveth*0.391*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 9.83e-03 * (tf% t9i32) * exp(-4.232*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 4.232*(tf% t9i2))

      ee   = 1.52e+03 * (tf% t9) * exp(-9.747*(tf% t9i))
      dee  = ee*((tf% t9i) + 9.747*(tf% t9i2))

      term    = cc + dd + ee 
      dtermdt = dcc + ddd + dee 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev    = 5.54e+10 * (tf% t932) * exp(-46.578*(tf% t9i))
      drevdt = rev*(1.5d0*(tf% t9i) + 46.578*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_n15ag





      subroutine rate_o14ag(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, ff, dff, q1
      parameter        (q1 = 1.0d0/0.514089d0)


! o14(a, g)ne18
      aa  = 9.47e+08 * (tf% t9i23) * exp(-39.388*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*39.388*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.011*(tf% t913) + 1.974*(tf% t923) + 0.146*(tf% t9)
     1      + 3.036*(tf% t943) + 0.572*(tf% t953)
      dbb = oneth*0.011*(tf% t9i23) + twoth*1.974*(tf% t9i13) + 0.146
     1      + fourth*3.036*(tf% t913) + fiveth*0.572*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 1.16e-01 * (tf% t9i32) * exp(-11.733*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 11.733*(tf% t9i2))

      ee   = 3.39e+01 * (tf% t9i32) * exp(-22.609*(tf% t9i))
      dee  = ee*(-1.5d0*(tf% t9i) + 22.609*(tf% t9i2))

      ff   = 9.10e-03 * (tf% t95) * exp(-12.159*(tf% t9i))
      dff  = ff*(5.0d0*(tf% t9i) + 12.159*(tf% t9i2))

      term    = cc + dd + ee + ff
      dtermdt = dcc + ddd + dee + dff


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev    = 5.42e+10 * (tf% t932) * exp(-59.328*(tf% t9i))
      drevdt = rev*(1.5d0*(tf% t9i) + 59.328*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_o14ag





      subroutine rate_o17ag(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56, 
     2                 ft9a, dft9a, fpt9a, dfpt9a, gt9x, dgt9x, zz 


! o17(a, g)ne21
       aa    = 1.0d0 + 0.1646*(tf% t9)
       zz    = 1.0d0/aa 
       t9a   = (tf% t9) *zz
       dt9a  = (1.0d0 - t9a*0.1646)*zz

       zz     = dt9a/t9a
       t9a13  = t9a**oneth
       dt9a13 = oneth*t9a13*zz

       t9a56  = t9a**fivsix
       dt9a56 = fivsix * t9a56*zz

       aa     = 0.786/t9a
       daa    = -aa*zz
       bb     = aa**3.51
       dbb    = 3.51*bb/aa * daa
       ft9a   = exp(-bb)
       dft9a  = -ft9a*dbb

       aa     = t9a/1.084
       bb     = aa**1.69
       dbb    = 1.69*bb/aa * dt9a/1.084 
       fpt9a  = exp(-bb)
       dfpt9a = -fpt9a*dbb

       aa     = oneth*exp(-10.106*(tf% t9i))
       daa    = aa*10.106*(tf% t9i2)
       gt9x   = 1.0d0 + aa
       dgt9x  = daa

       zz     = 1.0d0/gt9x
       aa     = 1.73e17 * fpt9a*zz
       daa    = (1.73e17*dfpt9a - aa*dgt9x)*zz

       bb     = 3.50e15 * ft9a*zz
       dbb    = (3.50e15*dft9a - bb*dgt9x)*zz

       term    = (aa+bb) * t9a56 * (tf% t9i32) * exp(-39.914/t9a13)
       dtermdt = term*((daa+dbb)/(aa+bb) + dt9a56/t9a56 
     1           - 1.5d0*(tf% t9i) + 39.914/t9a13**2 * dt9a13)


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 8.63e+10 * (tf% t932) * exp(-85.305*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 85.305*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_o17ag





      subroutine rate_o17an(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, bb, dbb, cc, dcc, dd, 
     1                 t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56, gt9x, dgt9x, zz 

! o17(a, n)ne20
       aa     = 1.0d0 + 0.0268*(tf% t9)
       bb     = aa**twoth
       dbb    = twoth*bb/aa*0.0268

       zz     = 1.0d0/bb
       cc     = aa + 0.0232*(tf% t953)*zz
       dcc    = 0.0268 + (fiveth*0.0232*(tf% t923) - 0.0232*(tf% t953)*zz*dbb)*zz

       zz     = 1.0d0/cc
       t9a    = (tf% t9) *zz
       dt9a   = (1.0d0 - t9a*dcc)*zz

       zz      = dt9a/t9a
       t9a13   = t9a**oneth
       dt9a13  = oneth*t9a13*zz

       t9a56   = t9a**fivsix
       dt9a56  = fivsix * t9a56*zz

       dd     = oneth*exp(-10.106*(tf% t9i))
       gt9x   = 1.0d0 + dd
       dgt9x  = dd*10.106*(tf% t9i2)

       term      = 1.03e+18/gt9x * t9a56 * (tf% t9i32) * exp(-39.914/t9a13)
       dtermdt   = term*(-dgt9x/gt9x + dt9a56/t9a56 
     1             - 1.5d0*(tf% t9i) + 39.914/t9a13**2 * dt9a13)


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 1.86e+01 * exp(-6.852*(tf% t9i))
      drevdt   = rev*6.852*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_o17an







      subroutine rate_o18ag(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! o18(a, g)ne22

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, ff, dff, gg, dgg, hh, dhh, theta, q1
      parameter        (theta = 0.1d0, 
     1                  q1    = 1.0d0/0.117649d0)


! giessen et al 1994 nuc phys a 567, 146 for t9 less than 0.3
! cf88 otherwise

      if ((tf% t9).lt.0.3) then
       aa   = 1.066d-41 * (tf% t9i32) * exp(-5.507d-01*(tf% t9i))
       daa  = aa*(-1.5d0*(tf% t9i) + 5.507d-1*(tf% t9i2))

       bb   = 1.852d-13 * (tf% t9i32) * exp(-2.070*(tf% t9i))
       dbb  = bb*(-1.5d0*(tf% t9i) + 2.070*(tf% t9i2))

       cc   = 1.431d-02 * (tf% t9i32) * exp(-4.462*(tf% t9i))
       dcc  = cc*(-1.5d0*(tf% t9i) + 4.462*(tf% t9i2))

       dd   = 2.055d-04 * (tf% t9i32) * exp(-5.374*(tf% t9i))
       ddd  = dd*(-1.5d0*(tf% t9i) + 5.374*(tf% t9i2))

       ee   = 5.332d+00 * (tf% t9i32) * exp(-6.285*(tf% t9i))
       dee  = ee*(-1.5d0*(tf% t9i) + 6.285*(tf% t9i2))

       ff   = 1.457d+00 * (tf% t9i32) * exp(-7.121*(tf% t9i))
       dff  = ff*(-1.5d0*(tf% t9i) + 7.121*(tf% t9i2))

       gg   = 3.121d-02 * (tf% t9i32) * exp(-7.292*(tf% t9i))
       dgg  = gg*(-1.5d0*(tf% t9i) + 7.292*(tf% t9i2))

       hh   = 6.23d+03 * (tf% t9) * exp(-16.987*(tf% t9i))
       dhh  = hh*((tf% t9i) + 16.987*(tf% t9i2))

       term    = aa + bb + cc + dd + ee + ff + gg + hh
       dtermdt = daa + dbb + dcc + ddd + dee + dff + dgg + dhh


      else 
       aa  = 1.82d+12 * (tf% t9i23) * exp(-40.057*(tf% t9i13) - (tf% t92)*q1)
       daa = aa*(-twoth*(tf% t9i) + oneth*40.057*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

       bb  = 1.0d0 + 0.01*(tf% t913) + 0.988*(tf% t923) + 0.072*(tf% t9) 
     1       + 3.17*(tf% t943) + 0.586*(tf% t953)
       dbb = oneth*0.01*(tf% t9i23) + twoth*0.988*(tf% t9i13) + 0.072
     1      + fourth*3.17*(tf% t913) + fiveth*0.586*(tf% t923)

       cc   = aa * bb
       dcc  = daa*bb + aa*dbb

       dd   = 7.54 * (tf% t9i32) * exp(-6.228*(tf% t9i))
       ddd  = dd*(-1.5d0*(tf% t9i) + 6.228*(tf% t9i2))

       ee   = 34.8 * (tf% t9i32) * exp(-7.301*(tf% t9i))
       dee  = ee*(-1.5d0*(tf% t9i) + 7.301*(tf% t9i2))

       ff   = 6.23d+03 * (tf% t9) * exp(-16.987*(tf% t9i))
       dff  = ff*((tf% t9i) + 16.987*(tf% t9i2))

       gg   = theta * 1.0d-11 * (tf% t9i32) * exp(-1.994*(tf% t9i))
       dgg  = gg*(-1.5d0*(tf% t9i) + 1.994*(tf% t9i2))

       term    = cc + dd + ee + ff + gg
       dtermdt = dcc + ddd + dee + dff + dgg
      end if


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 5.85d+10 * (tf% t932) * exp(-112.208*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 112.208*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_o18ag







      subroutine rate_o18an(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, bb, dbb, cc, dcc, dd, 
     1                 ee, dee, ff, dff, gg, dgg, hh, dhh, ft9a, dft9a, gt9, dgt9, 
     2                 t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56, gt9i, zz

! o18(a, n)ne21
      aa     = 1.0d0 + 0.0483*(tf% t9)
      bb     = aa**twoth
      dbb    = twoth*bb/aa*0.0483

      zz     = 1.0d0/bb
      cc     = aa + 0.00569*(tf% t953)*zz
      dcc    = 0.0483 + (fiveth*0.00569*(tf% t923) - 0.00569*(tf% t953)*zz*dbb)*zz

      zz     = 1.0d0/cc
      t9a    = (tf% t9) *zz
      dt9a   = (1.0d0 - t9a*dcc)*zz

      zz      = dt9a/t9a
      t9a13   = t9a**oneth
      dt9a13  = oneth*t9a13*zz

      t9a56   = t9a**fivsix
      dt9a56  = fivsix * t9a56*zz

      dd     = 5.0d0 * exp(-23.002*(tf% t9i))
      gt9    = 1.0d0 + dd
      gt9i   = 1.0d0/gt9
      dgt9   = dd*23.002*(tf% t9i2)

      ee     = 0.431/t9a
      dee    = -ee*zz
      ff     = ee**3.89
      dff    = 3.89*ff/ee*dee
      ft9a   = exp(-ff)
      dft9a  = -ft9a*dff

      gg     = 7.22e+17 * ft9a*gt9i * t9a56 * (tf% t9i32) * exp(-40.056/t9a13)
      dgg    = gg*(-dff - gt9i*dgt9 + dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1         + 40.056/t9a13**2 *dt9a13) 

      hh     = 150.31 / gt9 * exp(-8.045*(tf% t9i))
      dhh    = hh*(-gt9i*dgt9 + 8.045*(tf% t9i2))

      term     = gg + hh
      dtermdt  = dgg + dhh


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

! must protect the 8.045*(tf% t9i) from overflow, so write it this way

      gg     = 7.22e+17*gt9i * t9a56 * (tf% t9i32) 
     1         * exp(-ff - 40.056/t9a13 + 8.045*(tf% t9i))
      dgg    = gg*(-gt9i*dgt9 + dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1          - dff + 40.056/t9a13**2*dt9a13 - 8.045*(tf% t9i2))

      hh     = 150.31 * gt9i 
      dhh    = -hh*gt9i*dgt9 

      term    = 0.784 * (gg + hh)
      dtermdt = 0.784 * (dgg + dhh)

      rr    = den * term
      drrdt = den * dtermdt * 1.0d-9
      drrdd = term

      end subroutine rate_o18an






      subroutine rate_ne20pa(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, bb, dbb, cc, dcc, dd, ddd, 
     1                 ee, dee, ff, dff, t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56, 
     2                 zz, t9b

! ne20(p, a)f17
       aa     = 1.0d0 + 0.0612*(tf% t9)
       bb     = aa**twoth
       dbb    = twoth*bb/aa*0.0612

       zz     = 1.0d0/bb
       cc     = aa + 0.013*(tf% t953)*zz
       dcc    = 0.0612 + (fiveth*0.013*(tf% t923) - 0.013*(tf% t953)*zz*dbb)*zz

       zz     = 1.0d0/cc
       t9a    = (tf% t9) *zz
       dt9a   = (1.0d0 - t9a*dcc)*zz

       zz      = dt9a/t9a
       t9a13   = t9a**oneth
       dt9a13  = oneth*t9a13*zz

       t9a56   = t9a**fivsix
       dt9a56  = fivsix * t9a56*zz

       t9b     = min((tf% t9), 10.0d0)
       dd      = 5.31 + 0.544*t9b - 0.0523*t9b*t9b
       ddd     = 0.544 - 2.0d0*0.0523*t9b 
       if (t9b .eq. 10.0) ddd     = 0.0d0
       
       ee      = 3.25e19 * dd * t9a56 * (tf% t9i32) * exp(-43.176/t9a13)
       dee     = ee*(ddd/dd + dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1           +   43.176/t9a13**2 * dt9a13)

       ff      = exp(-47.969*(tf% t9i))
       dff     = ff*47.969*(tf% t9i2)

       term    = ee * ff
       dtermdt = dee*ff + ee*dff


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 0.0537 * ee
      drevdt   = 0.0537 * dee

      rr    = den * rev 
      drrdt = den * drevdt * 1.0d-9
      drrdd = rev 

      end subroutine rate_ne20pa







      subroutine rate_f19pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rf19pg 
! f19(p, g)ne20

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, ff, dff, gg, dgg, hh, dhh, zz, q1, gs, dgs
      parameter        (q1 = 1.0d0/0.173056d0)


      aa  = 6.04e+07 * (tf% t9i23) * exp(-18.113*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*18.113*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.023*(tf% t913) + 2.06*(tf% t923) + 0.332*(tf% t9)  
     1      + 3.16*(tf% t943) + 1.30*(tf% t953)
      dbb = oneth*0.023*(tf% t9i23) + twoth*2.06*(tf% t9i13) + 0.332
     1      + fourth*3.16*(tf% t913) + fiveth*1.30*(tf% t923) 

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 6.32e+02 * (tf% t9i32) * exp(-3.752*(tf% t9i))  
      ddd  = dd*(-1.5d0*(tf% t9i) + 3.752*(tf% t9i2))

      ee   = 7.56e+04 * (tf% t9i27) * exp(-5.722*(tf% t9i))
      dee  = ee*(-twosev*(tf% t9i) + 5.722*(tf% t9i2))

      ff   = 7.0*exp(-16.44*(tf% t9i))
      dff  = ff*16.44*(tf% t9i2)

      gg   = 4.0 * exp(-2.09*(tf% t9i)) 
      dgg  = gg*2.09*(tf% t9i2)

      hh   = 1.0d0 + ff + gg
      dhh  = dff + dgg

      zz      = 1.0d0/hh
      term    = (cc + dd + ee)*zz
      dtermdt = (dcc + ddd + dee - term*dhh)*zz

      rev      = 3.7e+10 * (tf% t932) * exp(-149.093*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 149.093*(tf% t9i2))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_f19pg





      subroutine rate_f19pn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, daa, bb, dbb

! f19(p, n)ne19
      aa  = 1.27e+08 * (1.0d0 - 0.147*(tf% t912) + 0.069*(tf% t9))
      daa = 1.27e+08 * (0.069 - 0.5d0*0.147*(tf% t9i12))

      bb  = exp(-46.659*(tf% t9i))
      dbb = bb*46.659*(tf% t9i2)

      term    = aa * bb
      dtermdt = daa*bb + aa*dbb


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      term    = 0.998 * aa
      dtermdt = 0.998 * daa 

      rr    = den * term
      drrdt = den * dtermdt * 1.0d-9
      drrdd = term

      end subroutine rate_f19pn





      subroutine rate_f19ap(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, q1
      parameter        (q1 = 1.0d0/0.405769)


! f19(a, p)ne22
      aa  = 4.50e+18 * (tf% t9i23) * exp(-43.467*(tf% t9i13)  - (tf% t92)*q1)
      daa = -twoth*aa*(tf% t9i) + aa*(oneth*43.467*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 7.98e+04 * (tf% t932) * exp(-12.760*(tf% t9i))
      dbb  = 1.5d0*bb*(tf% t9i) + bb*12.760*(tf% t9i2)

      term    = aa + bb
      dtermdt = daa + dbb 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 6.36 * exp(-19.439*(tf% t9i))
      drevdt   = rev*19.439*(tf% t9i2)

      rr    = den * rev * term 
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_f19ap





      subroutine rate_na22na(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, 
     1                 t9b, t9b2, t9b3


! na22(n, a)f19
      t9b  = min((tf% t9), 10.0d0)
      t9b2 = t9b*t9b
      t9b3 = t9b2*t9b
      aa  = 1.0d0 + 0.8955*t9b - 0.05645*t9b2 + 7.302e-04*t9b3
      daa = 0.8955 - 2.0d0*0.05645*t9b + 3.0d0*7.302e-4*t9b2
      if (t9b .eq. 10.0) daa = 0.0d0

      term     = 1.21e6 * exp(aa)
      dtermdt  = term*daa


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 1.10 * exp(-22.620*(tf% t9i))
      drevdt   = rev*22.620*(tf% t9i2)

      rr    = den * rev * term 
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_na22na


      subroutine rate_ne20pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rne20pg
! ne20(p, g)na21
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ff, gg, dgg, zz, gs, dgs

      aa  = 9.55e+06 * exp(-19.447*(tf% t9i13)) 
      daa = aa*oneth*19.447*(tf% t9i43)

      bb  = 1.0d0 + 0.0127*(tf% t9i23)
      dbb = -twoth*0.0127*(tf% t9i53)

      cc  = (tf% t92) * bb * bb
      dcc = 2.0d0*cc*(tf% t9i) + 2.0d0*(tf% t92)*bb*dbb

      zz  = 1.0d0/cc 
      dd  = aa*zz
      ddd = (daa - dd*dcc)*zz

      aa  = 2.05e+08 * (tf% t9i23) * exp(-19.447*(tf% t9i13))  
      daa = aa*(-twoth*(tf% t9i) + oneth*19.447*(tf% t9i43))

      bb  = sqrt ((tf% t9)/0.21)
      dbb = 0.5d0/(bb * 0.21)

      cc  = 2.67 * exp(-bb)
      dcc = -cc*dbb

      ff  = 1.0d0 + cc
   
      gg  = aa*ff
      dgg = daa*ff + aa*dcc 

      aa  = 18.0 * (tf% t9i32) * exp(-4.242*(tf% t9i))  
      daa = aa*(-1.5d0*(tf% t9i) + 4.242*(tf% t9i2))

      bb  = 10.2 * (tf% t9i32) * exp(-4.607*(tf% t9i))
      dbb = bb*(-1.5d0*(tf% t9i) + 4.607*(tf% t9i2))

      cc  = 3.6e+04 * (tf% t9i14) * exp(-11.249*(tf% t9i))
      dcc = cc*(-0.25d0*(tf% t9i) + 11.249*(tf% t9i2))

      term    = dd + gg + aa + bb + cc
      dtermdt = ddd + dgg + daa + dbb + dcc

      rev      = 4.63e+09 * (tf% t932) * exp(-28.216*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 28.216*(tf% t9i2))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_ne20pg








      subroutine rate_ne20ng(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc


! ne20(n, g)ne21
! wm88 Apj 239, 943; fit over range of experimental data, constant otherwise

      if ((tf% t9) .lt. 5.8025d-2) then
       term    = 5.449d+03
       dtermdt = 0.0d0

      else if ((tf% t9) .gt. 1.1605) then
       term    = 6.977d+04
       dtermdt = 0.0d0
  
      else if ((tf% t9) .ge. 5.8025d-2 .and. (tf% t9)  <=  2.9012d-1) then
       term    = 4.7219d+3 + 2.5248d+4*(tf% t9) - 2.7448d+5*(tf% t92)
     1           + 9.2848d+5*(tf% t93)
       dtermdt = 2.5248d+4 - 2.0d0*2.7448d+5*(tf% t9)
     1           + 3.0d0*9.2848d+5*(tf% t92)
       
      else

       aa  = 1.802d+04 * ((tf% t9)/0.348)**4.43
       daa = 4.43 * aa * (tf% t9i)

       bb  = -5.931 * ((tf% t9)-0.348) + 1.268 * ((tf% t9)-0.348)**2
       dbb = -5.931 + 2.0d0*1.268*((tf% t9) - 0.348)

       cc  = exp(bb)
       dcc = cc*dbb

       term    = aa * cc
       dtermdt = daa*cc + aa*dcc

      end if

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      =  4.650d+09 * (tf% t932) * exp(-78.46*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 78.46*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_ne20ng




      subroutine rate_ne21pg_nacre(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rne21pg [check]
! ne21(p, g)na22
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ff, gg, dgg, zz, gs, dgs
      
      ! a0 t9i23 exp(-a1 t9i13 - (t9*a2)^2) 
      !     * (1 + b0 t9 + b1 t92 + b2 t93 + b3 t94 + b4 t95) 
      ! + c0 t9i32 exp(-c1/t9)
      ! + d0 t9i32 exp(-d1/t9)
      ! + e0 t9^e1 exp(-e2/t9)
      call rnacre(tf, 
     >      4.68d8, 1.5d0*1.84d0, 1d0/0.2d0, ! a0, a1, a2
     >      10.80d0, 0d0, 0d0, 0d0, 0d0, ! b0, b1, b2, b3, b4
     >      18.0d0, 4.247d0, ! c0, c1     
     >      9.83d0, 4.619d0, ! d0, d1     
     >      6.76d4, -0.641d0, 11.922d0, ! e0, e1, e2
     >      gs, dgs)         
      
      bb   = 7.929d0 * exp(-20.108d0*(tf% t9i) - 0.327d0*(tf% t9))
      dbb  = bb*(20.108d0*(tf% t9i2) - 0.327d0)

      if (bb > 1) then ! guard against rate going negative
         bb  = 1
         dbb = 0
      end if
      
      term    = gs * (1 - bb)
      dtermdt = dgs - bb * dgs - dbb * gs

      call rnacre_rev(tf,  ! a0 t932 exp(-a1/t9)
     >      4.637d9, 28.214d0, ! a0, a1
     >      rev, drevdt)     

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_ne21pg_nacre



      subroutine rate_ne21pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, ff, dff, gg, dgg, hh, dhh, xx, dxx, zz, 
     2                 theta, q1
      parameter        (theta = 0.1d0, 
     1                  q1    = 1.0d0/0.003364d0)

! ne21(p, g)na22

! el eid & champagne 1995 

      if ((tf% t9) <= 2.0) then
       aa  = 3.4d+08 * (tf% t9i23) * exp(-19.41*(tf% t9i13))
       daa = aa*(-twoth*(tf% t9i) + oneth*19.41*(tf% t9i43))

       bb  = (16.7*(tf% t9) - 1.0)**2
       dbb = 2.0d0*(16.7*(tf% t9) - 1.0)*16.7

       cc  = 0.56 * exp(-bb)
       dcc = -cc*dbb

       dd  = 1.0d0 + cc
       ddd = dcc

       ee   = aa * dd
       dee  = daa*dd + aa*ddd

       ff   = 6.12 * (tf% t9i32) * exp(-1.403*(tf% t9i))
       dff  = ff*(-1.5d0*(tf% t9i) + 1.403*(tf% t9i2))

       gg   = 1.35d+04 * (tf% t9i32) * exp(-3.008*(tf% t9i))
       dgg  = gg*(-1.5d0*(tf% t9i) + 3.008*(tf% t9i2))      

       aa   = (tf% t9) **0.67
       daa  = 0.67*aa*(tf% t9i)
       zz   = 1.0d0/aa

       hh   = 3.12d+06 * (tf% t9) **(-0.72) * exp(-8.268*zz)
       dhh  = hh*(-0.72d0*(tf% t9i) + 8.268*zz*zz*daa)

       xx   = theta * 1.1d-03 * (tf% t9i32) * exp(-1.114*(tf% t9i))
       dxx  = xx*(-1.5d0*(tf% t9i) + 1.114*(tf% t9i2))      

       term    = ee + ff + gg + hh + xx
       dtermdt = dee + dff + dgg + dhh + dxx


! cf88 
      else 

       aa  = theta * 2.95d+08 * (tf% t9i23) * exp(-19.462*(tf% t9i13) -(tf% t92)*q1)
       daa = aa*(-twoth*(tf% t9i) + oneth*19.462*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

       bb  = 1.0d0 + 0.021*(tf% t913) + 13.29*(tf% t923) + 1.99*(tf% t9) 
     1       + 124.1*(tf% t943) + 47.29*(tf% t953)
       dbb = oneth*0.021*(tf% t9i23) + twoth*13.29*(tf% t9i13) + 1.99
     1       + fourth*124.1*(tf% t913) + fiveth*47.29*(tf% t923)

       cc   = aa * bb
       dcc  = daa*bb + aa*dbb

       dd   = theta * 7.80d-01 * (tf% t9i32) * exp(-1.085*(tf% t9i))
       ddd  = dd*(-1.5d0*(tf% t9i) + 1.085*(tf% t9i2))

       ee   = 4.37d+08 * (tf% t9i23) * exp(-19.462*(tf% t9i13))
       dee  = ee*(-twoth*(tf% t9i) + oneth*19.462*(tf% t9i43))

       ff   = 5.85 * (tf% t9i32) * exp(-1.399*(tf% t9i))
       dff  = ff*(-1.5d0*(tf% t9i) + 1.399*(tf% t9i2))

       gg   = 1.29d+04 * (tf% t9i32) * exp(-3.009*(tf% t9i))
       dgg  = gg*(-1.5d0*(tf% t9i) + 3.009*(tf% t9i2))

       hh   = 3.15d+05 * (tf% t9i35) * exp(-5.763*(tf% t9i))
       dhh  = hh*(-0.6d0*(tf% t9i) + 5.763*(tf% t9i2))

       term    = cc + dd + ee + ff + gg + hh
       dtermdt = dcc + ddd + dee + dff + dgg + dhh
      end if



      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 1.06d+10 * (tf% t932) * exp(-78.194*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 78.194*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_ne21pg






      subroutine rate_ne21ag(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, gg, dgg, hh, dhh, zz, 
     2                 t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56


! ne21(a, g)mg25
       aa    = 1.0d0 + 0.0537*(tf% t9)
       zz    = 1.0d0/aa

       t9a   = (tf% t9) *zz
       dt9a  = (1.0d0 - t9a*0.0537)*zz

       zz     = dt9a/t9a
       t9a13  = t9a**oneth
       dt9a13 = oneth*t9a13*zz

       t9a56  = t9a**fivsix
       dt9a56 = fivsix * t9a56*zz

       aa     = 8.72e-03*(tf% t9) - 6.87e-04*(tf% t92) + 2.15e-05*(tf% t93)
       daa    = 8.72e-3 - 2.0d0*6.87e-4*(tf% t9) + 3.0d0*2.15e-5*(tf% t92)

       bb     = 1.52e-04 * exp(-46.90*(tf% t9i13)*aa)
       dbb    = bb*46.90*(oneth*(tf% t9i43)*aa - (tf% t9i13)*daa) 

       cc     = 1.5*exp(-4.068*(tf% t9i))
       dcc    =  cc*4.068*(tf% t9i2)

       gg     = 2.0 * exp(-20.258*(tf% t9i))
       dgg    = gg*20.258*(tf% t9i2)

       hh     = 1.0d0 + cc + gg
       dhh    = dcc + dgg

       zz     = 1.0d0/hh
       dd     = bb*zz
       ddd    = (dbb - dd*dhh)*zz

       aa     = 4.94e+19 * t9a56 * (tf% t9i32) * exp(-46.89/t9a13)
       daa    = aa*(dt9a56/t9a56 - 1.5d0*(tf% t9i)  
     1              + 46.89/t9a13**2 * dt9a13)

       bb     =  2.66e+07 * (tf% t9i32) * exp(-22.049*(tf% t9i))
       dbb    = bb*(-1.5d0*(tf% t9i) + 22.049*(tf% t9i2))

       cc     = aa + bb
       dcc    = daa + dbb

       term    = dd * cc
       dtermdt = ddd*cc + dd*dcc 



      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev    = 4.06e+10 * (tf% t932) * exp(-114.676*(tf% t9i))
      drevdt = rev*(1.5d0*(tf% t9i) + 114.676*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_ne21ag







      subroutine rate_ne21an(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, zz, 
     2                 t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56

! ne21(a, n)mg24
       aa    = 1.0d0 + 0.0537*(tf% t9)
       zz    = 1.0d0/aa

       t9a   = (tf% t9) *zz
       dt9a  = (1.0d0 - t9a*0.0537)*zz

       zz     = dt9a/t9a
       t9a13  = t9a**oneth
       dt9a13 = oneth*t9a13*zz

       t9a56  = t9a**fivsix
       dt9a56 = fivsix * t9a56*zz

       aa     = 4.94e+19 * t9a56 * (tf% t9i32) * exp(-46.89/t9a13)
       daa    = aa*(dt9a56/t9a56 - 1.5d0*(tf% t9i)  
     1              + 46.89/t9a13**2 * dt9a13)

       bb     =  2.66e+07 * (tf% t9i32) * exp(-22.049*(tf% t9i))
       dbb    = bb*(-1.5d0*(tf% t9i) + 22.049*(tf% t9i2))

       cc     = 2.0d0*exp(-20.258*(tf% t9i))
       dcc    = cc*20.258*(tf% t9i2)
   
       dd     = 1.5*exp(-4.068*(tf% t9i))
       ddd    = dd*4.068*(tf% t9i2)

       ee     = 1.0d0 + cc + dd
       dee    = dcc + ddd

       zz      = 1.0d0/ee
       term    = (aa + bb)*zz
       dtermdt = (daa + dbb - term*dee)*zz



      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 12.9 * exp(-29.606*(tf% t9i))
      drevdt   = rev*29.606*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_ne21an


      

      subroutine rate_ne22pg_ec95(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, ff, dff, gg, dgg, theta
      parameter        (theta = 0.1d0)

! ne22(p, g)na23

! el eid & champagne 1995 

      if ((tf% t9) <= 2.0) then
       aa  = 1.05d+09 * (tf% t9i23) * exp(-19.431*(tf% t9i13))
       daa = aa*(-twoth*(tf% t9i) + oneth*19.431*(tf% t9i43))

       bb  = 1.24d-09 * (tf% t9i32) * exp(-0.414*(tf% t9i))
       dbb = bb*(-1.5d0*(tf% t9i) + 0.414*(tf% t9i2))

       cc  = 2.90d-02 * (tf% t9i32) * exp(-1.752*(tf% t9i))
       dcc = cc*(-1.5d0*(tf% t9i) + 1.752*(tf% t9i2))

       dd  = 9.30d+04 * (tf% t9) **(-1.174) * exp(-5.100*(tf% t9i))
       ddd = dd*(-1.174*(tf% t9i) + 5.100*(tf% t9i2))

       ee   = 5.71d+05 * (tf% t9) **(0.249) * exp(-7.117*(tf% t9i))
       dee  = ee*(0.249*(tf% t9i) + 7.117*(tf% t9i2))

       ff   = theta * 3.25d-04 * (tf% t9i32) * exp(-0.789*(tf% t9i))
       dff  = ff*(-1.5d0*(tf% t9i) + 0.789*(tf% t9i2))

       gg   = theta * 0.10 * (tf% t9i32) * exp(-1.161*(tf% t9i))
       dgg  = gg*(-1.5d0*(tf% t9i) + 1.161*(tf% t9i2))      

       term    = aa + bb + cc + dd + ee + ff + gg
       dtermdt = daa + dbb + dcc + ddd + dee + dff + dgg


! cf88 
      else 

       aa  = 1.15d+09 * (tf% t9i23) * exp(-19.475*(tf% t9i13))
       daa = aa*(-twoth*(tf% t9i) + oneth*19.475*(tf% t9i43))

       bb  = 9.77d-12 * (tf% t9i32) * exp(-0.348*(tf% t9i))
       dbb = bb*(-1.5d0*(tf% t9i) + 0.348*(tf% t9i2))

       cc   = 8.96d+03 * (tf% t9i32) * exp(-4.84*(tf% t9i))
       dcc  = cc*(-1.5d0*(tf% t9i) + 4.84*(tf% t9i2))

       dd   = 6.52d+04 * (tf% t9i32) * exp(-5.319*(tf% t9i))
       ddd  = dd*(-1.5d0*(tf% t9i) + 5.319*(tf% t9i2))

       ee   = 7.97d+05 * (tf% t9i12) * exp(-7.418*(tf% t9i))
       dee  = ee*(-0.5d0*(tf% t9i) + 7.418*(tf% t9i2))

       ff   = theta * 1.63d-01 * (tf% t9i32) * exp(-1.775*(tf% t9i))
       dff  = ff*(-1.5d0*(tf% t9i) + 1.775*(tf% t9i2))

       term    = aa + bb + cc + dd + ee + ff 
       dtermdt = daa + dbb + dcc + ddd + dee + dff 

      end if



      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 4.67d+09 * (tf% t932) * exp(-102.048*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 102.048*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_ne22pg_ec95








      subroutine rate_na22np(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa


! na22(n, p)ne22
      aa  = 1.0d0 - 3.037e-02*(tf% t9) + 8.380e-03*(tf% t92) - 7.101e-04*(tf% t93)
      daa =  -3.037e-02 + 2.0d0*8.380e-03*(tf% t9) - 3.0d0*7.101e-04*(tf% t92)

      term    = 1.24e+08 * exp(aa)
      dtermdt = term*daa


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev     = 7.01*exp(-42.059*(tf% t9i))
      drevdt  = rev*42.059*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_na22np








      subroutine rate_na21pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, q1
      parameter        (q1 = 1.0d0/0.133956d0)


! na21(p, g)mg22
      aa  = 1.41e+05 * (tf% t9i23) * exp(-20.739*(tf% t9i13) -  (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*20.739*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.020*(tf% t913) + 4.741*(tf% t923) + 0.667*(tf% t9)
     1      + 16.380*(tf% t943) + 5.858*(tf% t953)
      dbb = oneth*0.020*(tf% t9i23) + twoth*4.741*(tf% t9i13) + 0.667
     1      + fourth*16.380*(tf% t913) + fiveth*5.858*(tf% t923) 

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 6.72e+02 * (tf% t9i34) * exp(-2.436*(tf% t9i))
      ddd  = dd*(-0.75d0*(tf% t9i) + 2.436*(tf% t9i2))

      term    = cc + dd 
      dtermdt = dcc + ddd 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 7.44e+10 * (tf% t932) * exp(-63.790*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 63.790*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_na21pg




      subroutine rate_mg21em(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rmg21enu

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision lntwo, halflife, con
      parameter        (lntwo    = 0.6931471805599453d0, 
     1                  halflife = 122d-3,  ! from http://wwwndc.jaea.go.jp/CN04/index.html
     2                  con      = lntwo/halflife)

! mg21(e-nu)na21
      fr    = con
      dfrdt = 0.0d0
      dfrdd = 0.0d0

      rr    = 0.0d0
      drrdt = 0.0d0
      drrdd = 0.0d0

      end subroutine rate_mg21em





      subroutine rate_mg24pa(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, gg, t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56, zz

! mg24(p, a)na21
       aa     = 1.0d0 + 0.127*(tf% t9)
       zz     = 1.0d0/aa

       t9a    = (tf% t9) *zz
       dt9a   = (1.0d0 - t9a*0.127)*zz

       zz      = dt9a/t9a
       t9a13   = t9a**oneth
       dt9a13  = oneth*t9a13*zz

       t9a56   = t9a**fivsix
       dt9a56  = fivsix * t9a56*zz

       gg      = min((tf% t9), 12.0d0)
       aa      = 4.43 + 3.31*gg - 0.229*gg*gg
       daa     = 3.31 - 2.0d0*0.229*gg
       if (gg .eq. 12.0) daa = 0.0d0

       bb      = 1.81e21 * t9a56 * (tf% t9i32) * exp(-49.967/t9a13)
       dbb     = bb*(dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1               + 49.967/t9a13**2 * dt9a13)

       cc      = aa*bb
       dcc     = daa*bb + aa*dbb

       dd      = exp(-79.843*(tf% t9i))
       ddd     = dd*79.843*(tf% t9i2)

       term    = cc * dd
       dtermdt = dcc*dd + cc*ddd

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 0.0771 * cc
      drevdt   = 0.0771 * dcc

      rr    = den * rev 
      drrdt = den * drevdt * 1.0d-9
      drrdd = rev 

      end subroutine rate_mg24pa






      subroutine rate_na22pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb


! na22(p, g)mg23
      aa  = 9.63e-05 * (tf% t932) * exp(-0.517*(tf% t9i))
      daa = aa*(1.5d0*(tf% t9i) + 0.517*(tf% t9i2))

      bb  = 2.51e+04 * (tf% t9) * exp(-2.013*(tf% t9i))
      dbb = bb*((tf% t9i) + 2.013*(tf% t9i2))

      term    = aa + bb 
      dtermdt = daa + dbb 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 3.27e+10 * (tf% t932) * exp(-87.933*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 87.933*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_na22pg







      subroutine rate_na23pn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, bb, dbb, cc, dcc, 
     1                 t9a, dt9a, t9a32, dt9a32, zz

! na23(p, n)mg23
      aa  = 1.0d0 + 0.141*(tf% t9)
      zz  = 1.0d0/aa

      t9a = (tf% t9) *zz
      dt9a = (1.0d0 - t9a*0.141)*zz

      aa    = sqrt(t9a)
      t9a32 = t9a * aa
      dt9a32 = 1.5d0 * aa * dt9a

      bb   = 9.29d8 * (1.0d0 - 0.881d0 * t9a32 * (tf% t9i32))
      dbb  = -9.29d8 * 0.881d0 * (tf% t9i32)*(dt9a32 - 1.5d0*t9a32*(tf% t9i))

      cc   = exp(-56.173*(tf% t9i))
      dcc  = cc*56.173*(tf% t9i2)

      term    = bb * cc
      dtermdt = dbb*cc + bb*dcc


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      term    = 0.998 * bb
      dtermdt = 0.998 * dbb

      rr    = den * term
      drrdt = den * dtermdt * 1.0d-9
      drrdd = term

      end subroutine rate_na23pn








      subroutine rate_mg25ap(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc


! mg25(a, p)si28
      aa  = -23.271*(tf% t9i13) + 6.46*(tf% t9) - 2.39*(tf% t92) + 0.506*(tf% t93) 
     1      - 6.04e-2*(tf% t94) + 3.75e-3*(tf% t95) - 9.38e-5*(tf% t96) 
 
      daa = oneth*23.271*(tf% t9i43) + 6.46 - 2.0d0*2.39*(tf% t9) + 3.0d0*0.506*(tf% t92) 
     1      - 4.0d0*6.04e-2*(tf% t93) + 5.0d0*3.75e-3*(tf% t94) - 6.0d0*9.38e-5*(tf% t95) 

      bb  = 3.23e8 * (tf% t9i23) * exp(aa)
      dbb  = -twoth*bb*(tf% t9i) + bb*daa

! dbb/bb
      cc   = -twoth*(tf% t9i) + daa

      term    = bb * exp(-13.995*(tf% t9i))
      dtermdt = term*cc + term*13.995*(tf% t9i2)

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 2.86 * bb
      drevdt   = 2.86 * dbb

      rr    = den * rev 
      drrdt = den * drevdt * 1.0d-9
      drrdd = rev

      end subroutine rate_mg25ap





      subroutine rate_mg25ag(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, gt9x, dgt9x, t9a, dt9a, t9a13, dt9a13, 
     2                 t9a56, dt9a56, zz


! mg25(a, g)si29
      aa    = 1.0d0 + 0.0630*(tf% t9)
      zz    = 1.0d0/aa

      t9a   = (tf% t9) *zz
      dt9a  = (1.0d0 - t9a*0.0630)*zz

      zz     = dt9a/t9a
      t9a13  = t9a**oneth
      dt9a13 = oneth*t9a13*zz

      t9a56  = t9a**fivsix
      dt9a56 = fivsix * t9a56*zz

      aa     = oneth*10.0d0*exp(-13.180*(tf% t9i))
      daa    = aa*13.180*(tf% t9i2)
      gt9x   = 1.0d0 + aa
      dgt9x  = daa

      bb     = 1.0d0/gt9x
      dbb    = -bb*bb*dgt9x

      cc     = 3.59e+20 * bb * t9a56 * (tf% t9i32) * exp(-53.41/t9a13)
      dcc    = cc*(dbb*gt9x + dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1             + 53.41/t9a13**2 * dt9a13) 

      dd     = 0.0156*(tf% t9) - 1.79e-03*(tf% t92) + 9.08e-05*(tf% t93)
      ddd    = 0.0156 - 2.0d0*1.79e-03*(tf% t9) + 3.0d0*9.08e-05*(tf% t92)

      ee     = 5.87e-04*exp(-53.42*(tf% t9i13)*dd)
      dee    = ee*53.42*(oneth*(tf% t9i43)*dd - (tf% t9i13)*ddd)

      term    = cc * ee
      dtermdt = dcc*ee + cc*dee


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev    = 1.90e+11 * (tf% t932) * exp(-129.128*(tf% t9i))
      drevdt = rev*(1.5d0*(tf% t9i) + 129.128*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_mg25ag





      subroutine rate_mg25an(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, zz, 
     1                 gt9x, dgt9x, t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56


! mg25(a, n)si28
      aa    = 1.0d0 + 0.0630*(tf% t9)
      zz    = 1.0d0/aa

      t9a   = (tf% t9) *zz
      dt9a  = (1.0d0 - t9a*0.0630)*zz

      zz     = dt9a/t9a
      t9a13  = t9a**oneth
      dt9a13 = oneth*t9a13*zz

      t9a56  = t9a**fivsix
      dt9a56 = fivsix * t9a56*zz

      aa     = oneth*10.0d0*exp(-13.180*(tf% t9i))
      daa    = aa*13.180*(tf% t9i2)
      gt9x   = 1.0d0 + aa
      dgt9x  = daa

      bb     = 1.0d0/gt9x
      dbb    = -bb*bb*dgt9x

      term    = 3.59e+20 * bb * t9a56 * (tf% t9i32) * exp(-53.41/t9a13)
      dtermdt = term*(dbb*gt9x + dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1          + 53.41/t9a13**2 * dt9a13) 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 20.0*exp(-30.792*(tf% t9i))
      drevdt   = rev*30.792*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_mg25an





      subroutine rate_mg26an(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, zz, 
     1                 gt9x, dgt9x, t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56


! mg26(a, n)si29
      aa    = 1.0d0 + 0.0628*(tf% t9)
      zz    = 1.0d0/aa

      t9a   = (tf% t9) *zz
      dt9a  = (1.0d0 - t9a*0.0628)*zz

      zz     = dt9a/t9a
      t9a13  = t9a**oneth
      dt9a13 = oneth*t9a13*zz

      t9a56  = t9a**fivsix
      dt9a56 = fivsix * t9a56*zz

      aa     = 5.0d0*exp(-20.990*(tf% t9i))
      daa    = aa*20.990*(tf% t9i2)
      gt9x   = 1.0d0 + aa
      dgt9x  = daa

      bb     = 1.0d0/gt9x
      dbb    = -bb*bb*dgt9x

      term   = 2.93e+20 * bb * t9a56 * (tf% t9i32) * exp(-53.505/t9a13)
      dtermdt= term*(dbb*gt9x + dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1         + 53.505/t9a13**2 * dt9a13) 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 1.68*exp(-0.401*(tf% t9i))
      drevdt   = rev*0.401*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_mg26an





      subroutine rate_al25pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee

! al25(p, g)si26
! coc et al 1995 a&a 299, 479 , case b

      aa  = 8.98d+1 * (tf% t9i32) * exp(-4.874*(tf% t9i))
      daa = aa*(-1.5d0*(tf% t9i) + 4.874*(tf% t9i2))

      bb  = 1.568d+3 * (tf% t9i32) * exp(-9.632*(tf% t9i))
      dbb = bb*(-1.5d0*(tf% t9i) + 9.632*(tf% t9i2))

      cc  = 2.42d+8 * (tf% t9i23) * exp(-23.18*(tf% t9i13))
      dcc = cc*(-twoth*(tf% t9i) + oneth*23.18*(tf% t9i43))

      dd  = 4.10d-02 * (tf% t9i32) * exp(-1.741*(tf% t9i))
      ddd = dd*(-1.5d0*(tf% t9i) + 1.741*(tf% t9i2))

      ee  = 2.193d+3 * (tf% t9i32) * exp(-4.642*(tf% t9i))
      dee = ee*(-1.5d0*(tf% t9i) + 4.642*(tf% t9i2))

      term    = aa + bb + cc + dd + ee 
      dtermdt = daa + dbb + dcc + ddd + dee 



      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 1.117d+11 * (tf% t932) * exp(-64.048*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 64.048*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_al25pg







      subroutine rate_al26pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, ff, dff, theta
      parameter        (theta = 0.1d0)


! al26(p, g)si27
! coc et al 1995 a&a 299, 479 

      aa  = 1.53d+9 * (tf% t9) **(-1.75) * exp(-23.19*(tf% t9i13))
      daa = aa*(-1.75*(tf% t9i) + oneth*23.19*(tf% t9i43))

      bb  = theta*8.7d-7 * (tf% t9i32) * exp(-0.7845*(tf% t9i))
      dbb = bb*(-1.5d0*(tf% t9i) + 0.7845*(tf% t9i2))

      cc  = theta*1.00d-3 * (tf% t9i32) * exp(-1.075*(tf% t9i))
      dcc = cc*(-1.5d0*(tf% t9i) + 1.075*(tf% t9i2))

      dd  = 9.00d+00 * (tf% t9i32) * exp(-2.186*(tf% t9i))
      ddd = dd*(-1.5d0*(tf% t9i) + 2.186*(tf% t9i2))

      ee  = 5.05d+02 * (tf% t9i32) * exp(-3.209*(tf% t9i))
      dee = ee*(-1.5d0*(tf% t9i) + 3.209*(tf% t9i2))

      ff  = 9.45d+03 * (tf% t9i) * exp(-4.008*(tf% t9i))
      dff = ff*(-(tf% t9i) + 4.008*(tf% t9i2))

      term    = aa + bb + cc + dd + ee + ff
      dtermdt = daa + dbb + dcc + ddd + dee + dff 



      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 3.46d+10 * (tf% t932) * exp(-86.621*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 86.621*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_al26pg





      subroutine rate_al27an(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb


! al27(a, n)p30

      aa    = 8.2e+04*exp(-30.588*(tf% t9i))
      daa   = aa*30.588*(tf% t9i2)

      bb    = 5.21e+05 * (tf% t974) * exp(-33.554*(tf% t9i))
      dbb   = 1.75d0*bb*(tf% t9i) + bb*33.554*(tf% t9i2)

      term    = aa + bb
      dtermdt = daa + dbb


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term


      aa  = 5.21e+05 * (tf% t974) * exp(-2.966*(tf% t9i))
      daa = aa*(1.75d0*(tf% t9i) + 2.966*(tf% t9i2)) 

      rev      = 6.75d0 * (8.20e4 + aa)
      drevdt   = 6.75d0 * daa

      rr    = den * rev 
      drrdt = den * drevdt * 1.0d-9
      drrdd = rev 

      end subroutine rate_al27an





      subroutine rate_si27pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd


! si27(p, g)p28

      aa  = 1.64e+09 * (tf% t9i23) * exp(-24.439*(tf% t9i13))
      daa = aa*(-twoth*(tf% t9i) + oneth*24.439*(tf% t9i43))

      bb  = 2.00e-08 * (tf% t9i32) * exp(-0.928*(tf% t9i)) 
      dbb = bb*(-1.5d0*(tf% t9i) + 0.928*(tf% t9i2))

      cc  = 1.95e-02 * (tf% t9i32) * exp(-1.857*(tf% t9i))
      dcc = cc*(-1.5d0*(tf% t9i) + 1.857*(tf% t9i2))

      dd  = 3.70e+02 * (tf% t9i47) * exp(-3.817*(tf% t9i))
      ddd = dd*(-foursev*(tf% t9i) + 3.817*(tf% t9i2))

      term    = aa + bb + cc + dd 
      dtermdt = daa + dbb + dcc + ddd 



      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 1.62e+10 * (tf% t932) * exp(-23.960*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 23.960*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_si27pg


      subroutine rate_si28pg_nacre(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, xx, dxx, q1
      parameter        (q1 = 1.0d0/8.4681d0)

! si28(p, g)p29

      if ((tf% t9) <= 3) then
      
         ! a0 t9i23 exp(-a1 t9i13 - (t9*a2)^2) 
         !     * (1 + b0 t9 + b1 t92 + b2 t93 + b3 t94 + b4 t95) 
         ! + c0 t9i32 exp(-c1/t9)
         ! + d0 t9i32 exp(-d1/t9)
         ! + e0 t9^e1 exp(-e2/t9)
         call rnacre(tf, 
     >      0d0, 0d0, 0d0, ! a0, a1, a2
     >      0d0, 0d0, 0d0, 0d0, 0d0, ! b0, b1, b2, b3, b4
     >      0d0, 0d0, ! c0, c1     
     >      0d0, 0d0, ! d0, d1     
     >      0d0, 0d0, 0d0, ! e0, e1, e2
     >      term, dtermdt)         

      else 
   

      end if

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 9.468d+09 * (tf% t932) * exp(-31.889*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 31.889*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_si28pg_nacre



      subroutine rate_si28pg_c96(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, xx, dxx, q1
      parameter        (q1 = 1.0d0/8.4681d0)



! si28(p, g)p29

! champagne et al 96  

      if ((tf% t9) <= 5.0) then

         ! a0 t9m13 exp(-a1 t9m13 - (t9*a2)^2) 
         !     * (1 + b0 t9i3 + b1 t923 + b2 t9 + b3 t943 + b4 t953) 
         ! + c0 t9m32 exp(-c1/t9)
         ! + d0 t9m32 exp(-d1/t9)
         ! + e0 t9m32 exp(-e1/t9)
         call rcf88(tf, 
     >      8.44d8, 24.389d0, 1d0/2.91d0, ! a0, a1, a2 
     >      0.17d0, 0.113d0, 0.0135d0, 0.194d0, 0.0591d0, ! b0, b1, b2, b3, b4
     >      2.92d2, 4.157d0, ! c0, c1 
     >      4.30d5, 18.51d0, ! d0, d1
     >      6.05d3, 18.17d0, ! e0, e1
     >      term, dtermdt)

! cf88 
      else 

         ! a0 t9m13 exp(-a1 t9m13 - (t9*a2)^2) 
         !     * (1 + b0 t9i3 + b1 t923 + b2 t9 + b3 t943 + b4 t953) 
         ! + c0 t9m32 exp(-c1/t9)
         ! + d0 t9m32 exp(-d1/t9)
         ! + e0 t9m32 exp(-e1/t9)
         call rcf88(tf, 
     >      1.64d8, 24.449d0, 1d0/2.91d0, ! a0, a1, a2
     >      0.17d0, -4.11d0, -0.491d0, 0.194d0, 0.0591d0, ! b0, b1, b2, b3, b4
     >      3.52d2, 4.152d0, ! c0, c1
     >      6.3d5, 18.505d0, ! d0, d1
     >      1.69d3, 14.518d0, ! e0, e1
     >      term, dtermdt)

      end if



      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 9.46d+09 * (tf% t932) * exp(-31.879*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 31.879*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_si28pg_c96





      subroutine rate_si29pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, xx, dxx, q1
      parameter        (q1 = 1.0d0/0.065536d0)



! si29(p, g)p30

      aa  = 3.26e+09 * (tf% t9i23) * exp(-24.459*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*24.459*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.017*(tf% t913) + 4.27*(tf% t923) + 0.509*(tf% t9)
     1      + 15.40*(tf% t943) + 4.67*(tf% t953)
      dbb = oneth*0.017*(tf% t9i23) + twoth*4.27*(tf% t9i13) + 0.509
     1     + fourth*15.40*(tf% t913) + fiveth*4.67*(tf% t923) 

      xx  = aa * bb
      dxx = daa*bb + aa*dbb

      cc   = 2.98e+03 * (tf% t9i32) * exp(-3.667*(tf% t9i)) 
      dcc  = cc*(-1.5d0*(tf% t9i) + 3.667*(tf% t9i2))

      dd   = 3.94e+04 * (tf% t9i32) * exp(-4.665*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 4.665*(tf% t9i2))

      ee   = 2.08e+04 * (tf% t912) * exp(-8.657*(tf% t9i))
      dee  = ee*(0.5d0*(tf% t9i) + 8.657*(tf% t9i2))

      term    = xx + cc + dd + ee 
      dtermdt = dxx + dcc + ddd + dee 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 1.26e+10 * (tf% t932) * exp(-65.002*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 65.002*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_si29pg









      subroutine rate_weaknp(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision aa, daa, bb, dbb, cc, dcc, 
     1                 zm1, zm2, zm3, zm4, zm5, 
     2                 c1, c2
      parameter        (c1 = 1.0d0/5.93d0, 
     1                  c2 = 0.98d0/886.7d0)


! free decay of neutrons, n(e-nu)p and p(e-,nu)n
! fit formula from schramm and wagoner annual review 1977
! currently accepted best value for the neutron lifetime, 
! 886.7 (+/- 1.9) seconds. P.R. Huffman et al., Nature, 6 January 2000.

      zm1   = (tf% t9) * c1
      zm2   = zm1*zm1 
      zm3   = zm1*zm2 
      zm4   = zm1*zm3 
      zm5   = zm1*zm4 

      aa   = 27.512*zm5 + 36.492*zm4 + 11.108*zm3 
     1       - 6.382*zm2 + 0.565*zm1 + 1.0d0
      daa  = (5.0d0*27.512*zm4 + 4.0d0*36.492*zm3 + 3.0d0*11.108*zm2
     1       - 2.0d0*6.382*zm1 + 0.565)*c1

! n=>p 
      fr    = c2 * aa
      dfrdt = c2 * daa * 1.0d-9
      dfrdd = 0.0d0


      aa  = 27.617*zm5 + 34.181*zm4 + 18.059*zm3 
     1      - 16.229*zm2 + 5.252*zm1
      daa = (5.0d0*27.617*zm4 + 4.0d0*34.181*zm3 + 3.0d0*18.059*zm2
     1      - 2.0d0*16.229*zm1 + 5.252)*c1

      bb = exp(-2.531d0/zm1)
      dbb = bb*2.531d0/zm2*c1

      cc  = aa*bb
      dcc = daa*bb + aa*dbb

! p=>n
      rr    = c2 * cc
      drrdt = c2 * dcc * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_weaknp





      subroutine rate_dpn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc


! d(p, n)2p
       aa   = 3.35e7 * exp(-3.720*(tf% t9i13))
       daa  = aa*oneth*3.720d0*(tf% t9i43) 

       bb   = 1.0d0 + 0.784*(tf% t913) + 0.346*(tf% t923) + 0.690*(tf% t9) 
       dbb  = oneth*0.784*(tf% t9i23) + twoth*0.346*(tf% t9i13) + 0.690

       term    = aa * bb
       dtermdt = daa * bb + aa * dbb

      cc = exp(-25.815*(tf% t9i))
      dcc = cc*25.815*(tf% t9i2)

      fr    = den * cc * term 
      dfrdt = den * (dcc*term + cc*dtermdt) * 1.0d-9
      dfrdd = cc * term 

      rev      =  4.24e-10 * (tf% t9i32)
      drevdt   = -1.5d0*rev*(tf% t9i)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_dpn




      subroutine rate_dng(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, c1
      parameter        (c1 = 66.2d0*18.9d0)


! d(n, g)t
      term    = 66.2 * (1.0d0  + 18.9*(tf% t9))
      dtermdt = c1

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      =  1.63e+10 * (tf% t9i32) * exp(-72.62*(tf% t9i))
      drevdt   = rev*(-1.5d0*(tf% t9i) + 72.62*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_dng




      subroutine rate_ddp(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb



! d(d, p)t
      aa  = 4.13e8 * (tf% t9i23) * exp(-4.258*(tf% t9i13))
      daa = -twoth*aa*(tf% t9i) + oneth*aa*4.258*(tf% t9i43)

      bb  = 1.0d0 + 0.098*(tf% t913) + 4.39e-2*(tf% t923) + 3.01e-2*(tf% t9)
     1      + 0.543*(tf% t943) + 0.946*(tf% t953)
      dbb = oneth*0.098*(tf% t9i23) + twoth*4.39e-2*(tf% t9i13) + 3.01e-2
     1      + fourth*0.543*(tf% t913) + fiveth*0.946*(tf% t923) 

      term    = aa * bb
      dtermdt = daa*bb + aa*dbb

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 1.73 * exp(-46.798*(tf% t9i)) 
      drevdt   = rev*46.798*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_ddp





      subroutine rate_ddn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb



! d(d, n)he3
      aa  = 3.88e8 * (tf% t9i23) * exp(-4.258*(tf% t9i13))  
      daa = -twoth*aa*(tf% t9i) + oneth*aa*4.258*(tf% t9i43)

      bb  = 1.0d0 + 0.098*(tf% t913) + 0.418*(tf% t923) + 0.287*(tf% t9)  
     1      + 0.638*(tf% t943) + 1.112*(tf% t953) 
      dbb = oneth*0.098*(tf% t9i23) + twoth*0.418*(tf% t9i13) + 0.287
     1      + fourth*0.638*(tf% t913) + fiveth*1.112*(tf% t923) 

      term    = aa * bb
      dtermdt = daa*bb + aa*dbb

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 1.730 * exp(-37.935*(tf% t9i)) 
      drevdt   = rev*37.935*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_ddn




      subroutine rate_tpn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa


! t(p, n)he3
      term    = 7.07e8 * (1.0d0 - 0.15*(tf% t912) + 0.098*(tf% t9))
      dtermdt = 7.07e8 * (-0.5d0*0.15*(tf% t9i12) + 0.098)

      aa  = exp(-8.863*(tf% t9i))
      daa = aa*8.863*(tf% t9i2)

      fr    = den * aa * term 
      dfrdt = den * (daa*term + aa*dtermdt) * 1.0d-9
      dfrdd = aa * term 

      rev      = 0.998
      drevdt   = 0.0d0

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_tpn




      subroutine rate_ddg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb
    
! d(d, g)he4
      aa  = 4.84e+01 * (tf% t9i23) * exp(-4.258*(tf% t9i13))  
      daa = aa*(-twoth*(tf% t9i) + oneth*4.258*(tf% t9i43))

      bb  = 1.0d0 + 0.098*(tf% t913) - 0.203*(tf% t923) - 0.139*(tf% t9)  
     1      + 0.106*(tf% t943) + 0.185*(tf% t953) 
      dbb = oneth*0.098*(tf% t9i23) - twoth*0.203*(tf% t9i13) - 0.139
     1      + fourth*0.106*(tf% t913) + fiveth*0.185*(tf% t923) 

      term    = aa * bb
      dtermdt = daa*bb + aa*dbb

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 4.53e+10 * (tf% t932) * exp(-276.729*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 276.729*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_ddg




      subroutine rate_tpg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb


! t(p, g)he4
      aa  = 2.20e+04 * (tf% t9i23) * exp(-3.869*(tf% t9i13))
      daa = aa*(-twoth*(tf% t9i) + oneth*3.869*(tf% t9i43))

      bb  = 1. + 0.108*(tf% t913) + 1.68*(tf% t923) + 1.26*(tf% t9)
     1      + 0.551*(tf% t943) + 1.06*(tf% t953) 
      dbb = oneth*0.108*(tf% t9i23) + twoth*1.68*(tf% t9i13) + 1.26
     1      + fourth*0.551*(tf% t913) + fiveth*1.06*(tf% t923) 

      term    = aa * bb
      dtermdt = daa*bb + aa*dbb

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 2.61e+10 * (tf% t932) * exp(-229.932*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 229.932*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_tpg





      subroutine rate_tdn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, q1
      parameter        (q1 = 1.0d0/0.0144d0)


! t(d, n)he4 ; the "dt" reaction
      aa  = 8.09e+10 * (tf% t9i23) * exp(-4.524*(tf% t9i13) - (tf% t92)*q1)
      daa = -twoth*aa*(tf% t9i) + aa*(oneth*4.524*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.092*(tf% t913) + 1.80*(tf% t923) + 1.16*(tf% t9)
     1      + 10.52*(tf% t943) + 17.24*(tf% t953)
      dbb = oneth*0.092*(tf% t9i23) + twoth*1.80*(tf% t9i13) + 1.16
     1      + fourth*10.52*(tf% t913) + fiveth*17.24*(tf% t923) 

      cc  = 8.73e+08 * (tf% t9i23) * exp(-0.523*(tf% t9i))
      dcc = -twoth*cc*(tf% t9i) + cc*0.523*(tf% t9i2)
      
      term    = aa * bb + cc
      dtermdt = daa*bb + aa*dbb + dcc

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 5.54*exp(-204.117*(tf% t9i))   
      drevdt   = rev*204.117*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_tdn





      subroutine rate_tt2n(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb


! t(t, 2n)he4 
      aa  = 1.67e+09 * (tf% t9i23) * exp(-4.872*(tf% t9i13))  
      daa = aa*(-twoth*(tf% t9i) + oneth*4.872*(tf% t9i43))

      bb  = 1.0d0 + 0.086*(tf% t913) - 0.455*(tf% t923) - 0.272*(tf% t9)  
     1      + 0.148*(tf% t943) + 0.225*(tf% t953)
      dbb = oneth*0.086*(tf% t9i23) - twoth*0.455*(tf% t9i13) - 0.272
     1      + fourth*0.148*(tf% t913) + fiveth*0.225*(tf% t923) 

      term    = aa * bb 
      dtermdt = daa*bb + aa*dbb 

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 3.38e-10 * (tf% t9i32) * exp(-131.504*(tf% t9i))
      drevdt   = rev*(-1.5d0*(tf% t9i) + 131.504*(tf% t9i2))

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_tt2n





      subroutine rate_he3dp(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, q1
      parameter        (q1 = 1.0d0/0.099225d0)


! he3(d, p)he4 
      aa  = 5.86e+10 * (tf% t9i23) * exp(-7.181*(tf% t9i13) - (tf% t92)*q1)
      daa = -twoth*aa*(tf% t9i) + aa*(oneth*7.181*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.058*(tf% t913) + 0.142*(tf% t923) + 0.0578*(tf% t9)
     1      + 2.25*(tf% t943) + 2.32*(tf% t953)
      dbb = oneth*0.058*(tf% t9i23) + twoth*0.142*(tf% t9i13) + 0.0578
     1      + fourth*2.25*(tf% t913) + fiveth*2.32*(tf% t923) 

      cc  = 4.36e+08 * (tf% t9i12) * exp(-1.72*(tf% t9i))
      dcc = -0.5d0*cc*(tf% t9i) + cc*1.72*(tf% t9i2)
      
      term    = aa * bb + cc
      dtermdt = daa*bb + aa*dbb + dcc

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 5.55*exp(-212.980*(tf% t9i))   
      drevdt   = rev*212.980*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_he3dp




      subroutine rate_he3td(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, t9a, dt9a, 
     1                 t9a13, dt9a13, t9a56, dt9a56, zz


! he3(t, d)he4 
      aa       = 1.0d0 + 0.128*(tf% t9)
      zz       = 1.0d0/aa

      t9a      = (tf% t9) *zz
      dt9a     = (1.0d0 - t9a*0.128)*zz

      zz      = dt9a/t9a
      t9a13   = t9a**oneth
      dt9a13  = oneth*t9a13*zz

      t9a56    = t9a**fivsix
      dt9a56   = fivsix*t9a56*zz

      term     = 5.46e+09 * t9a56 * (tf% t9i32) * exp(-7.733/t9a13)
      dtermdt = term*(dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1                + 7.733/t9a13**2 * dt9a13)

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 1.60*exp(-166.182*(tf% t9i))
      drevdt   = rev*166.182*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_he3td




      subroutine rate_he3tnp(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, t9a, dt9a, 
     1                 t9a13, dt9a13, t9a56, dt9a56, zz


! he3(t, np)he4 
      aa       = 1.0d0 + 0.115*(tf% t9)
      zz       = 1.0d0/aa

      t9a      = (tf% t9) *zz
      dt9a     = (1.0d0 - t9a*0.115)*zz

      zz      = dt9a/t9a
      t9a13   = t9a**oneth
      dt9a13  = oneth*t9a13*zz

      t9a56    = t9a**fivsix
      dt9a56   = fivsix*t9a56*zz

      term     = 7.71e+09 * t9a56 * (tf% t9i32) * exp(-7.733/t9a13)
      dtermdt = term*(dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1                + 7.733/t9a13**2 * dt9a13)

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 3.39e-10*(tf% t9i32) * exp(-140.367*(tf% t9i))
      drevdt   = rev*(-1.5d0*(tf% t9i) + 140.367*(tf% t9i2))

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_he3tnp




      subroutine rate_he4npg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb


! he4(np, g)li6
      aa  = 4.62e-6 * (tf% t9i2) * exp(-19.353*(tf% t9i))
      daa = aa*(-2.0d0*(tf% t9i) + 19.353*(tf% t9i2))

      bb  = 1.0d0 + 0.075*(tf% t9)
      dbb = 0.075

      term    = aa * bb 
      dtermdt = daa*bb + aa*dbb 

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 7.22e19 * (tf% t93) * exp(-42.933*(tf% t9i))
      drevdt   = rev*(3.0d0*(tf% t9i) + 42.933*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_he4npg




      subroutine rate_he4dg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc


! he4(d, g)li6
      aa  = 3.01e1 * (tf% t9i23) * exp(-7.423*(tf% t9i13)) 
      daa = aa*(-twoth*(tf% t9i) + oneth*7.423*(tf% t9i43))

      bb  = 1.0d0 + 0.056*(tf% t913) - 4.85*(tf% t923) + 8.85*(tf% t9) 
     1      - 0.585*(tf% t943) - 0.584*(tf% t953) 
      dbb = oneth*0.056*(tf% t9i23) - twoth*4.85*(tf% t9i13) + 8.850
     1      - fourth*0.585*(tf% t913) - fiveth*0.584*(tf% t923)

! rate goes negative for t9 greater than about 15, so try this 
      if (bb  <=  0.0) then
       bb = 0.0d0
       dbb = 0.0d0
      end if

      cc =  8.55e1 * (tf% t9i32) * exp(-8.228*(tf% t9i))
      dcc = cc*(-1.5d0*(tf% t9i) + 8.228*(tf% t9i2))

      term    = aa * bb + cc
      dtermdt = daa*bb + aa*dbb + dcc


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 1.53e10 * (tf% t932) * exp(-17.1180*(tf% t9i))  
      drevdt   = rev*(1.5d0*(tf% t9i) + 17.1180*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_he4dg





      subroutine rate_he4tn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, t9a, dt9a, t9a32, dt9a32, zz


! he4(t, n)li6
      aa     = 1.0d0 + 49.180*(tf% t9)   
      zz     = 1.0d0/aa
     
      t9a   = (tf% t9) *zz
      dt9a   = (1.0d0 - t9a*49.180)*zz

      t9a32  = t9a * sqrt(t9a) 
      dt9a32 = 1.5d0*t9a32/t9a * dt9a 

      aa     = 1.80e8 * exp(-55.4940*(tf% t9i)) 
      daa    = aa*55.4940*(tf% t9i2)

      bb     = 1.0d0 - 0.2610 * t9a32 * (tf% t9i32)  
      dbb    = -0.2610*(-1.5d0*t9a32*(tf% t9i52) + dt9a32*(tf% t9i32)) 

      cc     = aa*bb
      dcc    = daa*bb + aa*dbb 

      dd     = 2.72e9 * (tf% t9i32) * exp(-57.8840*(tf% t9i))   
      ddd    = dd*(-1.5d0*(tf% t9i) + 57.8840*(tf% t9i2))

      term    = cc + dd
      dtermdt = dcc + ddd

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 2.72e9 * (tf% t9i32) * exp(-2.39*(tf% t9i)) 
      drevdt   = rev*(-1.5d0*(tf% t9i) + 2.39*(tf% t9i2))

      term = 0.935*(1.80e8*bb + rev)
      dtermdt = 0.935*(1.80e8*dbb + drevdt)

      rr    = den * term
      drrdt = den * dtermdt * 1.0d-9
      drrdd = term

      end subroutine rate_he4tn




      subroutine rate_li6phe3(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, q1
      parameter        (q1 = 1.0d0/30.25d0)  


! li6(p, he3)he4 
      aa  = 3.73e10 * (tf% t9i23) * exp(-8.413*(tf% t9i13) - (tf% t92)*q1)
      daa = -twoth*aa*(tf% t9i) + aa*(oneth*8.413*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.050*(tf% t913) - 0.061*(tf% t923) - 0.0210*(tf% t9)  
     1      + 0.0060*(tf% t943) + 0.0050*(tf% t953)  
      dbb = oneth*0.050*(tf% t9i23) - twoth*0.061*(tf% t9i13) - 0.0210
     1      + fourth*0.0060*(tf% t913) + fiveth*0.0050*(tf% t923) 

      cc  = 1.33e10 * (tf% t9i32) * exp(-17.7630*(tf% t9i)) 
      dcc = -1.5d0*cc*(tf% t9i) + cc*17.7630*(tf% t9i2)

      dd  =  1.29e9 * (tf% t9i) * exp(-21.82*(tf% t9i))
      ddd = -dd*(tf% t9i) + dd*21.82*(tf% t9i2)
      
      term    = aa * bb + cc + dd
      dtermdt = daa*bb + aa*dbb + dcc + ddd

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 1.070 * exp(-46.6310*(tf% t9i))
      drevdt   = rev*46.6310*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_li6phe3





      subroutine rate_li6ng(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt


! li6(n, g)li7
! malaney-fowler 1989

      term    = 5.10e3
      dtermdt = 0.0d0

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 1.19e10 * (tf% t932) * exp(-84.17*(tf% t9i)) 
      drevdt   = rev*(1.5d0*(tf% t9i) + 84.17*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_li6ng




      subroutine rate_he4tg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb


! he4(t, g)li7
      aa  = 8.67e5 * (tf% t9i23) * exp(-8.08*(tf% t9i13)) 
      daa = aa*(-twoth*(tf% t9i) + oneth*8.08*(tf% t9i43))

      bb  = 1.0d0 + 0.052*(tf% t913) - 0.448*(tf% t923) - 0.165*(tf% t9)   
     1      + 0.144*(tf% t943) + 0.134*(tf% t953)  
      dbb = oneth*0.052*(tf% t9i23) - twoth*0.448*(tf% t9i13) - 0.165
     1      + fourth*0.144*(tf% t913) + fiveth*0.134*(tf% t923) 

      term    = aa * bb
      dtermdt = daa*bb + aa*dbb

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 1.11e10 * (tf% t932) * exp(-28.64*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 28.64*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_he4tg



      subroutine rate_li7dn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt


! li7(d, n)2a
      term    = 2.92e11 * (tf% t9i23) * exp(-10.259*(tf% t9i13))
      dtermdt = term*(-twoth*(tf% t9i) + oneth*10.259*(tf% t9i43))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 9.95e-10 * (tf% t9i32) * exp(-175.476*(tf% t9i))
      drevdt   = rev*(-1.5d0*(tf% t9i) + 175.476*(tf% t9i2))

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_li7dn




      subroutine rate_li7tn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt


! li7(t, n)be9
! malaney and fowler (apjl, 345, l5, 1989)
      term    = 1.46d+11 * (tf% t9i23) * exp(-11.333*(tf% t9i13))
      dtermdt = -twoth*term*(tf% t9i) + oneth*term*11.333*(tf% t9i43)

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 0.0d0
      drevdt   = 0.0d0

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_li7tn





      subroutine rate_li7t2n(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt


! li7(t, 2n)2a
      term    = 8.81e11 * (tf% t9i23) * exp(-11.333*(tf% t9i13))
      dtermdt = term*(-twoth*(tf% t9i) + oneth*11.333*(tf% t9i43))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 1.22e-19 * (tf% t9i3) * exp(-102.864*(tf% t9i))
      drevdt   = rev*(-3.0d0*(tf% t9i) + 102.864*(tf% t9i2))

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_li7t2n




      subroutine rate_li7he3np(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt


! li7(he3, np)2a
      term    = 1.11e13 * (tf% t9i23) * exp(-17.989*(tf% t9i13))
      dtermdt = term*(-twoth*(tf% t9i) + oneth*17.989*(tf% t9i43))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 6.09e-20 * (tf% t9i3) * exp(-111.727*(tf% t9i))
      drevdt   = rev*(-3.0d0*(tf% t9i) + 111.727*(tf% t9i2))

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_li7he3np




      subroutine rate_li6pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, bb, dbb, cc, dcc, 
     1                 t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56, zz


! li6(p, g)be7
      if ((tf% t9) .gt. 10.0) then
       t9a  = 1.0d0
       dt9a = 0.0d0
      else  
       aa   = 1.0d0 - 0.0969*(tf% t9)

       bb   = aa**(-twoth)
       dbb  = twoth*bb/aa*0.0969

       cc   = aa + 0.0284*(tf% t953)*bb
       dcc  = -0.0969 + 0.0284*(fiveth*(tf% t923)*bb + (tf% t953)*dbb)

       zz   = 1.0d0/cc
       t9a  = (tf% t9) *zz
       dt9a = (1.0d0 - t9a*dcc)*zz
      end if

      zz     = dt9a/t9a
      t9a13  = t9a**oneth
      dt9a13 = oneth*t9a13*zz

      t9a56  = t9a**fivsix
      dt9a56 = fivsix*t9a56*zz

      term    = 6.69e+05 * t9a56 * (tf% t9i32) * exp(-8.413/t9a13)
      dtermdt = term*(dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1                + 8.413/t9a13**2 * dt9a13)

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 1.19e+10 * (tf% t932) * exp(-65.054*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 65.054*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0


      end subroutine rate_li6pg




      subroutine rate_li7pn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, daa, bb, dbb


! li7(p, n)be7
      aa  = 5.15e+09 * exp(-1.167*(tf% t913) - 19.081*(tf% t9i)) 
      daa = aa*(-oneth*1.167*(tf% t9i23) + 19.081*(tf% t9i2))

      bb  = 7.84e+09 * (tf% t9i32) * exp(-22.832*(tf% t9i))
      dbb = -1.5d0*bb*(tf% t9i) + bb*22.832*(tf% t9i2)

      term    = aa + bb
      dtermdt = daa + dbb

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      aa  = 5.15e+09 * exp(-1.167*(tf% t913)) 
      daa = -aa*oneth*1.167*(tf% t9i23)

      bb  = 0.998 * 7.84e+09 * (tf% t9i32) * exp(-3.751*(tf% t9i))
      dbb = -1.5d0*bb*(tf% t9i) + bb*3.751*(tf% t9i2)

      term    = aa + bb
      dtermdt = daa + dbb
      rr    = den * term
      drrdt = den * dtermdt * 1.0d-9
      drrdd = term

      end subroutine rate_li7pn




      subroutine rate_li7ng(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa


! li7(n, g)li8
! apj 372, 1
      aa      = 4.26d+03 * (tf% t9i32) * exp(-2.576*(tf% t9i))
      daa     = aa*(-1.5d0*(tf% t9i) + 2.576*(tf% t9i2))

      term    = 3.144d+03 + aa
      dtermdt = daa

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev    = 1.2923d+10 * (tf% t932) * exp(-2.359d+01*(tf% t9i))
      drevdt = rev*(1.5d0*(tf% t9i) + 2.359d+01*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_li7ng





      subroutine rate_be7dp(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt


! be7(d, p)2a
      term    = 1.07e12 * (tf% t9i23) * exp(-12.428*(tf% t9i13))
      dtermdt = term*(-twoth*(tf% t9i) + oneth*12.428*(tf% t9i43))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 9.97e-10 * (tf% t9i32) * exp(-194.557*(tf% t9i))
      drevdt   = rev*(-1.5d0*(tf% t9i) + 194.557*(tf% t9i2))

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_be7dp




      subroutine rate_be7tnp(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt


! be7(t, np)2a
      term    = 2.91e12 * (tf% t9i23) * exp(-13.729*(tf% t9i13))
      dtermdt = term*(-twoth*(tf% t9i) + oneth*13.729*(tf% t9i43))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 6.09e-20 * (tf% t9i3) * exp(-121.944*(tf% t9i))
      drevdt   = rev*(-3.0d0*(tf% t9i) + 121.944*(tf% t9i2))

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_be7tnp



      subroutine rate_be7he32p(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt


! be7(he3, 2p)2a
      term    = 6.11e13 * (tf% t9i23) * exp(-21.793*(tf% t9i13))
      dtermdt = term*(-twoth*(tf% t9i) + oneth*21.793*(tf% t9i43))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 1.22e-19 * (tf% t9i3) * exp(-130.807*(tf% t9i))
      drevdt   = rev*(-3.0d0*(tf% t9i) + 130.807*(tf% t9i2))

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_be7he32p




      subroutine rate_be9pa(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, q1
      parameter        (q1 = 1.0d0/0.2704d0)  


! be9(p, a)li6
      aa  = 2.11e11 * (tf% t9i23) * exp(-10.359*(tf% t9i13) - (tf% t92)*q1)
      daa = -twoth*aa*(tf% t9i) + aa*(oneth*10.359*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.04*(tf% t913) + 1.09*(tf% t923) + 0.307*(tf% t9) 
     1      + 3.21*(tf% t943) + 2.30*(tf% t953)
      dbb  = oneth*0.04*(tf% t9i23) + twoth*1.09*(tf% t9i13) + 0.307
     1       + fourth*3.21*(tf% t913) + fiveth*2.30*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 4.51e8 * (tf% t9i) * exp(-3.046*(tf% t9i))  
      ddd  = -dd*(tf% t9i) + dd*3.046*(tf% t9i2)

      ee   = 6.70e8 * (tf% t9i34) * exp(-5.160*(tf% t9i))
      dee  = -0.75d0*ee*(tf% t9i) + ee*5.160*(tf% t9i2)

      term    = cc + dd + ee 
      dtermdt = dcc + ddd + dee 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 6.18e-1 * exp(-24.674*(tf% t9i)) 
      drevdt   = rev*24.674*(tf% t9i2)

      rr    = den * rev * term 
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_be9pa




      subroutine rate_li6ag(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, q1
      parameter        (q1 = 1.0d0/1.758276d0)


! li6(a, g)b10
      aa  = 4.06e6 * (tf% t9i23) * exp(-18.790*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*18.790*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.022*(tf% t913) + 1.54*(tf% t923) + 0.239*(tf% t9)  
     1       +  2.20*(tf% t943) + 0.869*(tf% t953) 
      dbb  = oneth*0.022*(tf% t9i23) + twoth*1.54*(tf% t9i13) + 0.239
     1       + fourth*2.20*(tf% t913) + fiveth*0.869*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 1910.0 * (tf% t9i32) * exp(-3.484*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 3.484*(tf% t9i2))

      ee   = 1.01e4 * (tf% t9i) * exp(-7.269*(tf% t9i))
      dee  = ee*(-(tf% t9i) + 7.269*(tf% t9i2))

      term    = cc + dd + ee 
      dtermdt = dcc + ddd + dee 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 1.58e10 * (tf% t932) * exp(-51.753*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 51.753*(tf% t9i2))

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_li6ag





      subroutine rate_li7an(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt

! li7(a, n)b10
      term    = 3.84e8 * exp(-32.382*(tf% t9i))  
      dtermdt = term*32.382*(tf% t9i2)


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 3.84e8*1.32
      drevdt   = 0.0d0

      rr    = den * rev 
      drrdt = 0.0d0
      drrdd = rev

      end subroutine rate_li7an





      subroutine rate_be9pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, q1
      parameter        (q1 = 1.0d0/0.715716d0)


! be9(p, g)b10
      aa  = 1.33e7 * (tf% t9i23) * exp(-10.359*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*10.359*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.04*(tf% t913) + 1.52*(tf% t923) + 0.428*(tf% t9)  
     1       + 2.15*(tf% t943) + 1.54*(tf% t953)
      dbb  = oneth*0.04*(tf% t9i23) + twoth*1.52*(tf% t9i13) + 0.428
     1       + fourth*2.15*(tf% t913) + fiveth*1.54*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 9.64e4 * (tf% t9i32) * exp(-3.445*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 3.445*(tf% t9i2))

      ee   = 2.72e6 * (tf% t9i32) * exp(-10.62*(tf% t9i))
      dee  = ee*(-1.5d0*(tf% t9i) + 10.62*(tf% t9i2))

      term    = cc + dd + ee 
      dtermdt = dcc + ddd + dee 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 9.73e9 * (tf% t932) * exp(-76.427*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 76.427*(tf% t9i2))

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_be9pg




      subroutine rate_b10pa(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, q1
      parameter        (q1 = 1.0d0/19.377604d0)

! b10(p, a)li7
      aa  = 1.26e11 * (tf% t9i23) * exp(-12.062*(tf% t9i13) - (tf% t92)*q1)
      daa = -twoth*aa*(tf% t9i) + aa*(oneth*12.062*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.035*(tf% t913) - 0.498*(tf% t923) - 0.121*(tf% t9)  
     1       + 0.3*(tf% t943) + 0.184*(tf% t953)
      dbb  = oneth*0.035*(tf% t9i23) - twoth*0.498*(tf% t9i13) - 0.121
     1       + fourth*0.3*(tf% t913) + fiveth*0.184*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 2.59e9 * (tf% t9i) * exp(-12.260*(tf% t9i))
      ddd  = -dd*(tf% t9i) + dd*12.260*(tf% t9i2)

      term    = cc + dd 
      dtermdt = dcc + ddd 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 7.54e-01 * exp(-13.301*(tf% t9i))
      drevdt   = rev*13.301*(tf% t9i2)

      rr    = den * rev * term 
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      return
      end   subroutine rate_b10pa




!      subroutine rate_li7ag_nacre(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)!
!
!      type (T_Factors), pointer :: tf
!      double precision, intent(in) :: temp, den
!      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

!      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
!     1                 cc, dcc, dd, ddd, ee, dee, q1
!      parameter        (q1 = 1.0d0/17.598025d0)
!

! li7(a, g)b11


!      end subroutine rate_li7ag_nacre
      
      
      

      subroutine rate_li7ag_cf88(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, q1
      parameter        (q1 = 1.0d0/17.598025d0)


! li7(a, g)b11
      aa  = 3.55e7 * (tf% t9i23) * exp(-19.161*(tf% t9i13) -(tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*19.161*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.022*(tf% t913) + 0.775*(tf% t923) + 0.118*(tf% t9)
     1       + 0.884*(tf% t943) + 0.342*(tf% t953)
      dbb  = oneth*0.022*(tf% t9i23) + twoth*0.775*(tf% t9i13) + 0.118
     1       + fourth*0.884*(tf% t913) + fiveth*0.342*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 3.33e2 * (tf% t9i32) * exp(-2.977*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 2.977*(tf% t9i2))

      ee   = 4.10e4 * (tf% t9i) * exp(-6.227*(tf% t9i))
      dee  = ee*(-(tf% t9i) + 6.227*(tf% t9i2))

      term    = cc + dd + ee
      dtermdt = dcc + ddd + dee


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 4.02e10 * (tf% t932) * exp(-100.538*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 100.538*(tf% t9i2))

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_li7ag_cf88




!      subroutine rate_b11pa_nacre(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
!
!      type (T_Factors), pointer :: tf
!      double precision, intent(in) :: temp, den
!      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd
!
!      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
!     1                 cc, dcc, dd, ddd, ee, dee, ff, dff, q1
!      parameter        (q1 = 1.0d0/2.702736d0)
!
!! b11(p, a)be8=>2a
!
!      end subroutine rate_b11pa_nacre
      


      subroutine rate_b11pa_cf88(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, ff, dff, q1
      parameter        (q1 = 1.0d0/2.702736d0)

! b11(p, a)be8=>2a
      aa  = 2.20e12 * (tf% t9i23) * exp(-12.095*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*12.095*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0  + 0.034*(tf% t913) + 0.14*(tf% t923) + 0.034*(tf% t9)
     1       + 0.19*(tf% t943) + 0.116*(tf% t953)
      dbb  = oneth*0.034*(tf% t9i23) + twoth*0.14*(tf% t9i13) + 0.034
     1       + fourth*0.19*(tf% t913) + fiveth*0.116*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 4.03e6 * (tf% t9i32) * exp(-1.734*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 1.734*(tf% t9i2))

      ee   = 6.73e9 * (tf% t9i32) * exp(-6.262*(tf% t9i))
      dee  = ee*(-1.5d0*(tf% t9i) + 6.262*(tf% t9i2))

      ff   = 3.88e9*(tf% t9i) * exp(-14.154*(tf% t9i))
      dff  = ff*(-(tf% t9i) + 14.154*(tf% t9i2))

      term    = cc + dd + ee + ff
      dtermdt = dcc + ddd +dee + dff


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 3.5e-10* (tf% t9i32) *exp(-100.753*(tf% t9i))
      drevdt   = rev*(-1.5d0*(tf% t9i) + 100.753*(tf% t9i2))

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_b11pa_cf88




      subroutine rate_be7ag_nacre(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, q1
      parameter        (q1 = 1.0d0/22.743361d0)

! be7(a, g)c11

      end subroutine rate_be7ag_nacre



      subroutine rate_be7ag_cf88(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, q1
      parameter        (q1 = 1.0d0/22.743361d0)

! be7(a, g)c11
      aa  = 8.45e+07 * (tf% t9i23) * exp(-23.212*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*23.212*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.018*(tf% t913) + 0.488*(tf% t923) + 0.061*(tf% t9)
     1       + 0.296*(tf% t943) + 0.095*(tf% t953)
      dbb  = oneth*0.018*(tf% t9i23) + twoth*0.488*(tf% t9i13) + 0.061
     1       + fourth*0.296*(tf% t913) + fiveth*0.095*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 1.25e+04 * (tf% t9i32) * exp(-6.510*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 6.510*(tf% t9i2))

      ee   = 1.29e+05 * (tf% t9i54) * exp(-10.039*(tf% t9i))
      dee  = ee*(-1.25d0*(tf% t9i) + 10.039*(tf% t9i2))

      term    = cc + dd + ee
      dtermdt = dcc + ddd + dee


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 4.02e+10 * (tf% t932) * exp(-87.539*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 87.539*(tf% t9i2))

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_be7ag_cf88



      subroutine rate_b11pn(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, daa, bb, dbb


! b11(p, n)c11
      aa  = 1.69e8*(1.0d0 - 0.048*(tf% t912) + 0.010*(tf% t9))  
      daa = 1.69e8*(-0.5d0*0.048*(tf% t9i12) + 0.010)

      bb  = exp(-32.080*(tf% t9i))
      dbb = bb*32.080*(tf% t9i2)

      term    = aa*bb
      dtermdt = daa*bb + aa*dbb

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      term     = 0.998*aa
      dtermdt  = 0.998*daa

      rr    = den * term
      drrdt = den * dtermdt * 1.0d-9
      drrdd = term

      end subroutine rate_b11pn





      subroutine rate_b8ap(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, ff, dff, gg, dgg, hh, dhh, 
     2                 pp, dpp, qq, dqq, drr 


! b8(a, p)c11
      aa  = 1.67e-09 * (tf% t9i32) * exp(-1.079*(tf% t9i)) 
      daa = -1.5d0*aa*(tf% t9i) + aa*1.079*(tf% t9i2)

      bb  = 9.55e-08 * (tf% t9i32) * exp(-1.311*(tf% t9i))
      dbb = -1.5d0*bb*(tf% t9i) + bb*1.311*(tf% t9i2)

      cc  = 1.98e-01 * (tf% t9i32) * exp(-2.704*(tf% t9i)) 
      dcc = -1.5d0*cc*(tf% t9i) + cc*2.704*(tf% t9i2)

      dd  = 1.34e+00 * (tf% t9i32) * exp(-4.282*(tf% t9i))
      ddd = -1.5d0*dd*(tf% t9i) + dd*4.282*(tf% t9i2)

      ee  = 3.22e+04 * (tf% t9i32) * exp(-6.650*(tf% t9i)) 
      dee = -1.5d0*ee*(tf% t9i) + ee*6.650*(tf% t9i2)

      ff  = 2.33e+05 * (tf% t9i32) * exp(-8.123*(tf% t9i))
      dff = -1.5d0*ff*(tf% t9i) + ff*8.123*(tf% t9i2)

      gg  = 2.55e+06 * (tf% t9i32) * exp(-11.99*(tf% t9i)) 
      dgg = -1.5d0*gg*(tf% t9i) + gg*11.99*(tf% t9i2)

      hh  = 9.90e+06 * (tf% t9i32) * exp(-13.50*(tf% t9i))
      dhh = -1.5d0*hh*(tf% t9i) + hh*13.50*(tf% t9i2)

      pp  = 1.41e+06 * (tf% t9i32) * exp(-16.51*(tf% t9i)) 
      dpp = -1.5d0*pp*(tf% t9i) + pp*16.51*(tf% t9i2)

      qq  = 1.99e+07 * (tf% t9i32) * exp(-18.31*(tf% t9i))
      dqq = -1.5d0*qq*(tf% t9i) + qq*18.31*(tf% t9i2)

      rr  = 6.01e+07 * (tf% t9i32) * exp(-20.63*(tf% t9i)) 
      drr = -1.5d0*rr*(tf% t9i) + rr*20.63*(tf% t9i2)

      term    = aa + bb + cc + dd + ee + ff + gg + hh + pp + qq + rr
      dtermdt = daa + dbb + dcc + ddd + dee + dff + dgg + dhh 
     1          + dpp + dqq + drr

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 3.101 * exp(-85.95*(tf% t9i))
      drevdt   = rev*85.95*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev*term

      end subroutine rate_b8ap





      subroutine rate_b10pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, q1
      parameter        (q1 = 1.0d0/19.377604d0)


! b10(p, g)c11
      aa  = 4.61e+05 * (tf% t9i23) * exp(-12.062*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*12.062*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.035*(tf% t913) + 0.426*(tf% t923) + 0.103*(tf% t9)
     1       + 0.281*(tf% t943) + 0.173*(tf% t953)
      dbb  = oneth*0.035*(tf% t9i23) + twoth*0.426*(tf% t9i13) + 0.103
     1       + fourth*0.281*(tf% t913) + fiveth*0.173*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 1.93e+05 * (tf% t9i32) * exp(-12.041*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 12.041*(tf% t9i2))

      ee   = 1.14e+04 * (tf% t9i32) * exp(-16.164*(tf% t9i))
      dee  = ee*(-1.5d0*(tf% t9i) + 16.164*(tf% t9i2))

      term    = cc + dd + ee 
      dtermdt = dcc + ddd + dee 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 3.03e+10 * (tf% t932) * exp(-100.840*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 100.840*(tf% t9i2))

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_b10pg





      subroutine rate_c11na(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd


! c11(n, a)be8=>2a
! hauser feshbach calculation by woosley on aug 26, 1988.

      fr    = den * 7.0e4
      dfrdt = 0.0d0
      dfrdd = 7.0e4

      rr    = 0.0d0
      drrdt = 0.0d0
      drrdd = 0.0d0

      end subroutine rate_c11na





      subroutine rate_be9an(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, cc, dcc, 
     1                 dd, ddd, ee, dee, ff, dff, gg, dgg, hh, dhh


! be9(a, n)c12
! Wrean 94 Phys Rev C (1994) vol 49, #2, 1205
      aa  = 6.476d+13 * (tf% t9i23) * exp(-23.8702*(tf% t9i13))
      daa = -twoth*aa*(tf% t9i) + oneth*aa*23.8702*(tf% t9i43)

      bb  = (1.0d0 - 0.3270*(tf% t913))
      dbb = -oneth*0.3270*(tf% t9i23)

! rate goes negative for t9 greater than about 15, so try this 
      if (bb  <=  0.0) then
       bb  = 0.0d0
       dbb = 0.0d0
      end if

      cc  = aa*bb
      dcc = daa*bb + aa*dbb

      dd  = 6.044d-3*(tf% t9i32)*exp(-1.401*(tf% t9i)) 
      ddd = -1.5d0*dd*(tf% t9i) + dd*1.401*(tf% t9i2)

      ee  = 7.268*(tf% t9i32)*exp(-2.063*(tf% t9i)) 
      dee = -1.5d0*ee*(tf% t9i) + ee*2.063*(tf% t9i2)

      ff  = 3.256d+4*(tf% t9i32)*exp(-3.873*(tf% t9i)) 
      dff = -1.5d0*ff*(tf% t9i) + ff*3.873*(tf% t9i2)

      gg  = 1.946d+5*(tf% t9i32)*exp(-4.966*(tf% t9i)) 
      dgg = -1.5d0*gg*(tf% t9i) + gg*4.966*(tf% t9i2)

      hh  = 1.838e9*(tf% t9i32)*exp(-15.39*(tf% t9i)) 
      dhh = -1.5d0*hh*(tf% t9i) + hh*15.39*(tf% t9i2)

      term    = cc + dd + ee + ff + gg + hh
      dtermdt = dcc + ddd + dee + dff + dgg + dhh


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term 

      rev      = 10.3 * exp(-66.160*(tf% t9i))
      drevdt   = rev*66.160*(tf% t9i2)

      rr    = den * rev * term
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term


      end subroutine rate_be9an




      subroutine rate_b11pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, q1
      parameter        (q1 = 1.0d0/0.57121d0)


! b11(p, g)c12
      aa  = 4.62e+07 * (tf% t9i23) * exp(-12.095*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*12.095*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.035*(tf% t913) + 3.0*(tf% t923) + 0.723*(tf% t9)
     1       + 9.91*(tf% t943) + 6.07*(tf% t953)
      dbb  = oneth*0.035*(tf% t9i23) + twoth*3.0*(tf% t9i13) + 0.723
     1       + fourth*9.91*(tf% t913) + fiveth*6.07*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 7.89e+03 * (tf% t9i32) * exp(-1.733*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 1.733*(tf% t9i2))

      ee   = 9.68e+04 * (tf% t9i15) * exp(-5.617*(tf% t9i))
      dee  = ee*(-0.2d0*(tf% t9i) + 5.617*(tf% t9i2))

      term    = cc + dd + ee 
      dtermdt = dcc + ddd + dee 


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 7.01e+10 * (tf% t932) * exp(-185.173*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 185.173*(tf% t9i2))

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_b11pg





      subroutine rate_b11ap(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, ff, dff, q1
      parameter        (q1 = 1.0d0/0.120409d0)


! b11(a, p)c14
      aa  = 5.37e+11 * (tf% t9i23) * exp(-28.234*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*28.234*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.015*(tf% t913) + 5.575*(tf% t923) + 0.576*(tf% t9)
     1       + 15.888*(tf% t943) + 4.174*(tf% t953)
      dbb  = oneth*0.015*(tf% t9i23) + twoth*5.575*(tf% t9i13) + 0.576
     1       + fourth*15.888*(tf% t913) + fiveth*4.174*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 5.44e-03 * (tf% t9i32) * exp(-2.827*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 2.827*(tf% t9i2))

      ee   = 3.36e+02 * (tf% t9i32) * exp(-5.178*(tf% t9i))
      dee  = ee*(-1.5d0*(tf% t9i) + 5.178*(tf% t9i2))

      ff   = 5.32e+06 * (tf% t9i38) * exp(-11.617*(tf% t9i))
      dff  = ff*(-0.375*(tf% t9i) + 11.617*(tf% t9i2))

      term    = cc + dd + ee + ff
      dtermdt = dcc + ddd + dee + dff


      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 1.10e+01 * exp(-9.098*(tf% t9i))
      drevdt   = rev*9.098*(tf% t9i2)

      rr    = den * rev * term 
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_b11ap
































      subroutine rate_li7pag(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rli7pa

      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, daa, bb, dbb, cc, dcc, dd, ddd, 
     1                 t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56, zz, 
     2                 term1, dterm1, term2, dterm2, rev, drevdt, q1
      parameter        (q1 = 1.0d0/2.876416d0)

! 7li(p, g)be8=>2a  
      aa   = 1.56e+05 * (tf% t9i23) * exp(-8.472*(tf% t9i13) - (tf% t92)*q1)
      daa  = aa*(-twoth*(tf% t9i) + oneth*8.472*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.049*(tf% t913) + 2.498*(tf% t923) + 0.86*(tf% t9)
     1       + 3.518*(tf% t943) + 3.08*(tf% t953)
      dbb  = oneth*0.049*(tf% t9i23) + twoth*2.498*(tf% t9i13) + 0.86
     1       + fourth*3.518*(tf% t913) + fiveth*3.08*(tf% t923)

      cc   = aa*bb
      dcc  = daa*bb + aa*dbb

      dd   =  1.55e+06 * (tf% t9i32) * exp(-4.478*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 4.478*(tf% t9i2))

      term1  = cc + dd
      dterm1 = dcc + ddd

      rev    = 6.55e+10 * (tf% t932) * exp(-200.225*(tf% t9i))
      drevdt = rev*(1.5d0*(tf% t9i) + 200.225*(tf% t9i2)) 

! 7li(p, a)a 
      aa     = 1.0d0 + 0.759*(tf% t9)

      zz     = 1.0d0/aa
      t9a    = (tf% t9) *zz
      dt9a   = (1.0d0 - t9a*0.759)*zz

      zz     = dt9a/t9a
      t9a13  = t9a**oneth
      dt9a13 = oneth*t9a13*zz

      t9a56  = t9a**fivsix
      dt9a56 = fivsix*t9a56*zz

      aa     = 1.096e+09 * (tf% t9i23) * exp(-8.472*(tf% t9i13))
      daa    = aa*(-twoth*(tf% t9i) + oneth*8.472*(tf% t9i43))

      bb     = -4.830e+08 * t9a56 * (tf% t9i32) * exp(-8.472/t9a13)
      dbb    = bb*(dt9a56/t9a56 - 1.5d0*(tf% t9i) + 8.472/t9a13**2*dt9a13) 
 
      cc     = 1.06e+10 * (tf% t9i32) * exp(-30.442*(tf% t9i)) 
      dcc    = cc*(-1.5d0*(tf% t9i) + 30.442*(tf% t9i2)) 

      term2   = aa + bb + cc
      dterm2  = daa + dbb + dcc 

      rev    = 4.69 * exp(-201.291*(tf% t9i))
      drevdt = aa*201.291*(tf% t9i2) 

! sum of these two rates
      term = term1 + term2
      dtermdt = dterm1 + dterm2 

      fr    = den * term
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = 0.0d0
      drrdt = 0.0d0
      drrdd = 0.0d0

      end subroutine rate_li7pag








      subroutine rate_c12pg_cf88(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rc12pg rn13gp
! c12(p, g)n13
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, q1
      parameter        (q1 = 1.0d0/2.25d0)

      aa   = 2.04e+07 * (tf% t9i23) * exp(-13.69*(tf% t9i13) - (tf% t92)*q1)
      daa  = aa*(-twoth*(tf% t9i) + oneth*13.69*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.03*(tf% t913) + 1.19*(tf% t923) + 0.254*(tf% t9) 
     1       + 2.06*(tf% t943) + 1.12*(tf% t953)
      dbb  = oneth*0.03*(tf% t9i23) + twoth*1.19*(tf% t9i13) + 0.254
     1       + fourth*2.06*(tf% t913) + fiveth*1.12*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 1.08e+05 * (tf% t9i32) * exp(-4.925*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 4.925*(tf% t9i2))

      ee   = 2.15e+05 * (tf% t9i32) * exp(-18.179*(tf% t9i))
      dee  = ee*(-1.5d0*(tf% t9i) + 18.179*(tf% t9i2))

      term    = cc + dd + ee
      dtermdt = dcc + ddd + dee

      rev      = 8.84e+09 * (tf% t932) * exp(-22.553*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 22.553*(tf% t9i2))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_c12pg_cf88


   
   
! r1212g, c12(c12,g)mg24*  --- NB: not to mg24 stable.

      subroutine rate_c12c12g_cf88(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
         type (T_Factors), pointer :: tf
         double precision, intent(in) :: temp, den
         double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd
         double precision term, dtermdt, t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56, 
     1                 aa, zz
         aa      = 1.0d0 + 0.0396*(tf% t9)
         zz      = 1.0d0/aa
         t9a     = (tf% t9) *zz
         dt9a    = (1.0d0 -  t9a*0.0396)*zz
         zz      = dt9a/t9a
         t9a13   = t9a**oneth
         dt9a13  = oneth*t9a13*zz
         t9a56   = t9a**fivsix
         dt9a56  = fivsix*t9a56*zz
         term    = 4.27d+26 * t9a56 * (tf% t9i32) * 
     1          exp(-84.165/t9a13 - 2.12d-03*(tf% t93))
         dtermdt = term*(dt9a56/t9a56 - 1.5d0*(tf% t9i)
     1                + 84.165/t9a13**2*dt9a13 - 6.36d-3*(tf% t92))
         fr    = den * term
         dfrdt = den * dtermdt * 1.0d-9
         dfrdd = term
         rr    = 0.0d0
         drrdt = 0.0d0
         drrdd = 0.0d0 
      end subroutine rate_c12c12g_cf88





      subroutine rate_c13pg_cf88(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rc13pg rn14gp 
! c13(p, g)14n
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, q1, gs, dgs
      parameter        (q1 = 1.0d0/4.0d0)
      
      aa   = 8.01e+07 * (tf% t9i23) * exp(-13.717*(tf% t9i13) - (tf% t92)*q1)
      daa  = aa*(-twoth*(tf% t9i) + oneth*13.717*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.030*(tf% t913) + 0.958*(tf% t923) + 0.204*(tf% t9)
     1       + 1.39*(tf% t943) + 0.753*(tf% t953)
      dbb  = oneth*0.030*(tf% t9i23) + twoth*0.958*(tf% t9i13) + 0.204
     1       + fourth*1.39*(tf% t913) + fiveth*0.753*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 1.21e+06 * (tf% t9i65) * exp(-5.701*(tf% t9i))
      ddd  = dd*(-sixfif*(tf% t9i) + 5.701*(tf% t9i2))

      term    = cc + dd 
      dtermdt = dcc + ddd 

      rev      = 1.19e+10 * (tf% t932) * exp(-87.621*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 87.621*(tf% t9i2))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_c13pg_cf88












      subroutine rate_n15pg_cf88(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rn15pg ro16gp
! n15(p, g)o16
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, ff, dff, q1
      parameter        (q1 = 1.0d0/0.2025d0) 

      aa  = 9.78e+08 * (tf% t9i23) * exp(-15.251*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*15.251*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0  + 0.027*(tf% t913) + 0.219*(tf% t923) + 0.042*(tf% t9) 
     1       + 6.83*(tf% t943) + 3.32*(tf% t953)
      dbb  = oneth*0.027*(tf% t9i23) + twoth*0.219*(tf% t9i13) + 0.042
     1       + fourth*6.83*(tf% t913) + fiveth*3.32*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 1.11e+04*(tf% t9i32)*exp(-3.328*(tf% t9i))
      ddd  = dd*(-1.5d0*(tf% t9i) + 3.328*(tf% t9i2))

      ee   = 1.49e+04*(tf% t9i32)*exp(-4.665*(tf% t9i))
      dee  = ee*(-1.5d0*(tf% t9i) + 4.665*(tf% t9i2))

      ff   = 3.8e+06*(tf% t9i32)*exp(-11.048*(tf% t9i))
      dff  = ff*(-1.5d0*(tf% t9i) + 11.048*(tf% t9i2))

      term    = cc + dd + ee + ff
      dtermdt = dcc + ddd + dee + dff

      rev      = 3.62e+10 * (tf% t932) * exp(-140.734*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 140.734*(tf% t9i2))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_n15pg_cf88



      subroutine rate_n15pa_cf88(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rn15pa rc12ap
! n15(p, a)c12
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, ff, dff, gg, dgg, 
     2                 theta, q1
      parameter        (theta = 0.1d0, 
     1                  q1    = 1.0d0/0.272484d0)

      aa  = 1.08d+12*(tf% t9i23)*exp(-15.251*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*15.251*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.027*(tf% t913) + 2.62*(tf% t923) + 0.501*(tf% t9)
     1       + 5.36*(tf% t943) + 2.60*(tf% t953)
      dbb  = oneth*0.027*(tf% t9i23) + twoth*2.62*(tf% t9i13) + 0.501
     1       + fourth*5.36*(tf% t913) + fiveth*2.60*(tf% t923)

      cc   = aa * bb
      dcc  = daa*bb + aa*dbb

      dd   = 1.19d+08 * (tf% t9i32) * exp(-3.676*(tf% t9i)) 
      ddd  = dd*(-1.5d0*(tf% t9i) + 3.676*(tf% t9i2))

      ee   = 5.41d+08 * (tf% t9i12) * exp(-8.926*(tf% t9i))
      dee  = ee*(-0.5d0*(tf% t9i) + 8.926*(tf% t9i2))

      ff   = theta * 4.72d+08 * (tf% t9i32) * exp(-7.721*(tf% t9i)) 
      dff  = ff*(-1.5d0*(tf% t9i) + 7.721*(tf% t9i2))

      gg   = theta * 2.20d+09 * (tf% t9i32) * exp(-11.418*(tf% t9i))
      dgg  = gg*(-1.5d0*(tf% t9i) + 11.418*(tf% t9i2))

      term    = cc + dd + ee + ff + gg
      dtermdt = dcc + ddd + dee + dff + dgg

      rev      = 7.06d-01*exp(-57.625*(tf% t9i))
      drevdt   = rev*57.625*(tf% t9i2)

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = den * rev * term 
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_n15pa_cf88




      subroutine rate_o16pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! ro16pg rf17gp
! o16(p, g)f17
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, zz

      aa  = exp(-0.728*(tf% t923))
      daa = -twoth*aa*0.728*(tf% t9i13)

      bb  = 1.0d0 + 2.13 * (1.0d0 - aa)
      dbb = -2.13*daa

      cc  = (tf% t923) * bb
      dcc = twoth*cc*(tf% t9i) + (tf% t923)*dbb

      dd   = exp(-16.692*(tf% t9i13))
      ddd  = oneth*dd*16.692*(tf% t9i43)

      zz   = 1.0d0/cc
      ee   = dd*zz
      dee  = (ddd - ee*dcc)*zz

      term    = 1.50d+08 * ee
      dtermdt = 1.50d+08 * dee

      rev      = 3.03e+09*(tf% t932)*exp(-6.968*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 6.968*(tf% t9i2))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_o16pg





      subroutine rate_o17pa_fxt(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! ro17pa rn14ap
! o17(p, a)n14
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, res1, dres1, res2, dres2, res3, dres3, 
     2                 res4, dres4, res5, dres5, res6, dres6, zz, 
     3                 theta, q1, q2, dd, ddd, gs, dgs
      parameter        (theta = 0.1d0, 
     1                  q1    = 1.0d0/0.319225d0, 
     2                  q2    = 1.0d0/0.0016d0)

! rate from jeff blackmons thesis, includes terms from fowler 75, 
! landre 1990 (a&a 240, 85), and new results
! use rev factor from cf88 rate

      aa  = 1.53d+07 * (tf% t9i23) * exp(-16.712*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*16.712*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb   = 1.0d0 + 0.025*(tf% t913) + 5.39*(tf% t923) + 0.940*(tf% t9)
     1       + 13.5*(tf% t943) + 5.98*(tf% t953)
      dbb  = oneth*0.025*(tf% t9i23) + twoth*5.39*(tf% t9i13) + 0.940
     1       + fourth*13.5*(tf% t913) + fiveth*5.98*(tf% t923)

      res1  = aa * bb
      dres1 = daa*bb + aa*dbb

      res2  = 2.92d+06 * (tf% t9) * exp(-4.247*(tf% t9i))
      dres2 = res2*((tf% t9i) + 4.247*(tf% t9i2))


      aa    = 0.479 * (tf% t923) + 0.00312
      daa   = twoth*0.479*(tf% t9i13)

      bb    = aa*aa
      dbb   = 2.0d0 * aa * daa

      cc    =  1.78d+05 * (tf% t9i23) * exp(-16.669*(tf% t9i13))
      dcc   = cc*(-twoth*(tf% t9i) + oneth*16.669*(tf% t9i43))

      zz    = 1.0d0/bb 
      res3  = cc*zz
      dres3 = (dcc - res3*dbb)*zz

      res4  = 8.68d+10 * (tf% t9) * exp(-16.667*(tf% t9i13) - (tf% t92)*q2)
      dres4 = res4*((tf% t9i) + oneth*16.667*(tf% t9i43) - 2.0d0*(tf% t9)*q2)

      res5  = 9.22d-04 * (tf% t9i32) * exp(-0.767*(tf% t9i))
      dres5 = res5*(-1.5d0*(tf% t9i) + 0.767*(tf% t9i2))

      res6  = theta * 98.0 * (tf% t9i32) * exp(-2.077*(tf% t9i))
      dres6 = res6*(-1.5d0*(tf% t9i) + 2.077*(tf% t9i2))

      term    = res1 + res2 + res3 + res4 + res5 + res6
      dtermdt = dres1 + dres2 + dres3 + dres4 + dres5 + dres6

      rev      = 0.676 * exp(-13.825*(tf% t9i))
      drevdt   = rev*13.825*(tf% t9i2)

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = den * rev * term 
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_o17pa_fxt







      subroutine rate_o17pg_landre90(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! ro17pg rf18gp
! o17(p, g)18f
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, ff, dff, gg, dgg, 
     2                 t9a, dt9a, t9a13, dt9a13, t9a56, dt9a56, 
     3                 zz, theta, gs, dgs
      parameter        (theta = 0.1d0)

! from landre et al 1990 a&a 240, 85
      aa     = 1.0d0 + 2.69*(tf% t9)
      zz     = 1.0d0/aa

      t9a    = (tf% t9) *zz
      dt9a   = (1.0d0 - t9a*2.69)*zz

      zz     = dt9a/t9a
      t9a13  = t9a**oneth
      dt9a13 = oneth*t9a13*zz

      t9a56  = t9a**fivsix
      dt9a56 = fivsix*t9a56*zz

      aa  = 7.97d+07 * t9a56 * (tf% t9i32) * exp(-16.712/t9a13)
      daa = aa*(dt9a56/t9a56 - 1.5d0*(tf% t9i) + 16.712/t9a13**2*dt9a13)

      bb  = 1.0d0  + 0.025*(tf% t913) - 0.051*(tf% t923) - 8.82d-3*(tf% t9)
      dbb = oneth*0.025*(tf% t9i23) - twoth*0.051*(tf% t9i13) - 8.82d-3
      if (bb  <=  0.0) then
       bb  = 0.0d0
       dbb = 0.0d0
      end if

      cc  = 1.51d+08 * (tf% t9i23) * exp(-16.712*(tf% t9i13))
      dcc = cc*(-twoth*(tf% t9i) + oneth*16.712*(tf% t9i43))

      dd  = bb*cc
      ddd = dbb*cc + bb*dcc  

      ee  = 1.56d+5 * (tf% t9i) * exp(-6.272*(tf% t9i))
      dee = ee*(-(tf% t9i) + 6.272*(tf% t9i2))

      ff  = 2.0d0 * theta * 3.16d-05 * (tf% t9i32) * exp(-0.767*(tf% t9i))
      dff = ff*(-1.5d0*(tf% t9i) + 0.767*(tf% t9i2))

      gg  = theta * 98.0 * (tf% t9i32) * exp(-2.077*(tf% t9i))
      dgg = gg*(-1.5d0*(tf% t9i) + 2.077*(tf% t9i2))

      term    = aa + dd + ee + ff + gg
      dtermdt = daa + ddd + dee + dff + dgg

      rev      = 3.66d+10 * (tf% t932) * exp(-65.061*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 65.061*(tf% t9i2))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_o17pg_landre90




      subroutine rate_o18pa_cf88(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! ro18pa rn15ap
! o18(p, a)n15 and n15(a, p)o18
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, ff, dff, gg, dgg, q1, gs, dgs
      parameter        (q1 = 1.0d0/1.852321d0)

      aa  = 3.63e+11 * (tf% t9i23) * exp(-16.729*(tf% t9i13) - (tf% t92)*q1)
      daa = -twoth*aa*(tf% t9i) + aa*(oneth*16.729*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.025*(tf% t913) + 1.88*(tf% t923) + 0.327*(tf% t9)
     1      + 4.66*(tf% t943) + 2.06*(tf% t953)
      dbb = oneth*0.025*(tf% t9i23) + twoth*1.88*(tf% t9i13) + 0.327
     1      + fourth*4.66*(tf% t913) + fiveth*2.06*(tf% t923)

      cc  = aa * bb
      dcc = daa*bb + aa*dbb

      dd  = 9.90e-14 * (tf% t9i32) * exp(-0.231*(tf% t9i))
      ddd = -1.5d0*dd*(tf% t9i) + dd*0.231*(tf% t9i2)

      ee  = 2.66e+04 * (tf% t9i32) * exp(-1.670*(tf% t9i))
      dee = -1.5d0*ee*(tf% t9i) + ee*1.670*(tf% t9i2)

      ff  = 2.41e+09 * (tf% t9i32) * exp(-7.638*(tf% t9i))
      dff = -1.5d0*ff*(tf% t9i) + ff*7.638*(tf% t9i2)

      gg  = 1.46e+09 * (tf% t9i) * exp(-8.310*(tf% t9i))
      dgg = -gg*(tf% t9i) + gg*8.310*(tf% t9i2)

      term    = cc + dd + ee + ff + gg
      dtermdt = dcc + ddd + dee + dff + dgg

      rev      = 1.66e-01 * exp(-46.191*(tf% t9i))
      drevdt   = rev*46.191*(tf% t9i2)

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = den * rev * term 
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_o18pa_cf88





      subroutine rate_o18pg(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! ro18pg
! o18(p, g)f19
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, ff, dff, q1, gs, dgs
      parameter        (q1 = 1.0d0/0.019321d0)

      aa  = 3.45e+08 * (tf% t9i23) * exp(-16.729*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*16.729*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.025*(tf% t913) + 2.26*(tf% t923) + 0.394*(tf% t9)
     1      + 30.56*(tf% t943) + 13.55*(tf% t953)
      dbb = oneth*0.025*(tf% t9i23) + twoth*2.26*(tf% t9i13) + 0.394
     1      + fourth*30.56*(tf% t913) + fiveth*13.55*(tf% t923)

      cc  = aa*bb
      dcc = daa*bb + aa*dbb  

      dd  = 1.25e-15 * (tf% t9i32) * exp(-0.231*(tf% t9i)) 
      ddd = dd*(-1.5d0*(tf% t9i) + 0.231*(tf% t9i2))

      ee  = 1.64e+02 * (tf% t9i32) * exp(-1.670*(tf% t9i))
      dee = ee*(-1.5d0*(tf% t9i) + 1.670*(tf% t9i2))

      ff  = 1.28e+04 * (tf% t912) * exp(-5.098*(tf% t9i))
      dff = ff*(0.5d0*(tf% t9i) + 5.098*(tf% t9i2))

      term    = cc + dd + ee + ff 
      dtermdt = dcc + ddd + dee + dff 

      rev      = 9.20e+09 * (tf% t932) * exp(-92.769*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 92.769*(tf% t9i2))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_o18pg














      subroutine rate_f19pa(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rf19pa ro16ap
! f19(p, a)o16
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, ee, dee, ff, dff, gg, dgg, hh, dhh, q1, gs, dgs
      parameter        (q1 = 1.0d0/0.714025d0)

      aa  = 3.55d+11 * (tf% t9i23) * exp(-18.113*(tf% t9i13) - (tf% t92)*q1)
      daa = -twoth*aa*(tf% t9i) + aa*(oneth*18.113*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.023*(tf% t913) + 1.96*(tf% t923) + 0.316*(tf% t9)
     1      + 2.86*(tf% t943) + 1.17*(tf% t953)
      dbb = oneth*0.023*(tf% t9i23) + twoth*1.96*(tf% t9i13) + 0.316
     1      + fourth*2.86*(tf% t913) + fiveth*1.17*(tf% t923)

      cc  = aa * bb
      dcc = daa*bb + aa*dbb

      dd  = 3.67d+06 * (tf% t9i32) * exp(-3.752*(tf% t9i)) 
      ddd = -1.5d0*dd*(tf% t9i) + dd*3.752*(tf% t9i2)

      ee  = 3.07d+08 * exp(-6.019*(tf% t9i))
      dee = ee*6.019*(tf% t9i2)

      ff  = 4.0*exp(-2.090*(tf% t9i)) 
      dff = ff*2.090*(tf% t9i2)

      gg  = 7.0*exp(-16.440*(tf% t9i))
      dgg = gg*16.440*(tf% t9i2)

      hh  = 1.0d0 + ff + gg
      dhh = dff + dgg

      term    = (cc + dd + ee)/hh
      dtermdt = ((dcc + ddd + dee) - term*dhh)/hh

      rev      = 6.54e-01 * exp(-94.159*(tf% t9i))
      drevdt   = rev*94.159*(tf% t9i2)

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = den * rev * term 
      drrdt = den * (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = rev * term

      end subroutine rate_f19pa






      subroutine rate_n13pg_keiner93(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)
! rn13pg ro14gp
! n13(p, g)o14
      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, rev, drevdt, aa, daa, bb, dbb, 
     1                 cc, dcc, dd, ddd, q1
      parameter        (q1 = 1.0d0/0.69288976d0)

! Keiner et al 1993 Nucl Phys A552, 66
      aa  = -1.727d+7 * (tf% t9i23) * exp(-15.168*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*15.168*(tf% t9i43) -2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.027*(tf% t913) - 17.54*(tf% t923) - 3.373*(tf% t9)
     1      + 0.0176*(tf% t943) + 0.766d-2*(tf% t953)
      dbb = oneth*0.027*(tf% t9i23) - twoth*17.54*(tf% t9i13) - 3.373
     1      + fourth*0.0176*(tf% t913) + fiveth*0.766d-2*(tf% t923)

      cc  = aa*bb
      dcc = daa*bb + aa*dbb  

      dd  = 3.1d+05 * (tf% t9i32) * exp(-6.348*(tf% t9i))
      ddd = dd*(-1.5d0*(tf% t9i) + 6.348*(tf% t9i2))

      term    = cc + dd
      dtermdt = dcc + ddd

! goes negative below about t7=1.5
! note cf88 rate stays positive
      if (term .lt. 0.0) then
       term    = 0.0d0
       dtermdt = 0.0d0
      end if 

      rev      = 3.57d+10*(tf% t932)*exp(-53.706*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 53.706*(tf% t9i2))

      fr    = den * term 
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rr    = rev * term 
      drrdt = (drevdt*term + rev*dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_n13pg_keiner93














      


















































      subroutine rate_al27pg_old(tf, temp, den, fr, dfrdt, dfrdd, rr, drrdt, drrdd)


      type (T_Factors), pointer :: tf
      double precision, intent(in) :: temp, den
      double precision, intent(out) :: fr, dfrdt, dfrdd, rr, drrdt, drrdd

      double precision term, dtermdt, aa, daa, bb, dbb, cc, dcc, dd, ddd, ee, dee, 
     1                 ff, dff, gg, dgg, hh, dhh, xx, dxx, yy, dyy, zz, dzz, pp, 
     2                 rev, drevdt, rc147, q1
      parameter        (rc147 = 0.1d0, 
     1                  q1    = 1.0d0/0.024025d0)   



! 27al(p, g)si28  cf88

      aa  = 1.67d+08 * (tf% t9i23) * exp(-23.261*(tf% t9i13) - (tf% t92)*q1)
      daa = aa*(-twoth*(tf% t9i) + oneth*23.261*(tf% t9i43) - 2.0d0*(tf% t9)*q1)

      bb  = 1.0d0 + 0.018*(tf% t913) + 5.81*(tf% t923) + 0.728*(tf% t9) 
     1      + 27.31*(tf% t943) + 8.71*(tf% t953)  
      dbb = oneth*0.018*(tf% t9i23) + twoth*5.81*(tf% t9i13) + 0.728
     1      + fourth*27.31*(tf% t913) + fiveth*8.71*(tf% t923)

      cc  = aa*bb
      dcc = daa*bb + aa*dbb 

      dd  = 2.20d+00 * (tf% t9i32) * exp(-2.269*(tf% t9i))  
      ddd = dd*(-1.5d0*(tf% t9i) + 2.269*(tf% t9i2))

      ee  = 1.22d+01 * (tf% t9i32) * exp(-2.491*(tf% t9i)) 
      dee = ee*(-1.5d0*(tf% t9i) + 2.491*(tf% t9i2))

      ff  =  1.50d+04 * (tf% t9) * exp(-4.112*(tf% t9i))  
      dff = ff*((tf% t9i) + 4.112*(tf% t9i2))

      gg  = rc147 * 6.50d-10 * (tf% t9i32) * exp(-0.853*(tf% t9i)) 
      dgg = gg*(-1.5d0*(tf% t9i) + 0.853*(tf% t9i2))

      hh  = rc147 * 1.63d-10 * (tf% t9i32) * exp(-1.001*(tf% t9i))
      dhh = hh*(-1.5d0*(tf% t9i) + 1.001*(tf% t9i2))

      xx     = oneth*exp(-9.792*(tf% t9i))
      dxx    = xx*9.792*(tf% t9i2)

      yy     =  twoth * exp(-11.773*(tf% t9i))
      dyy    = yy*11.773*(tf% t9i2)

      zz     = 1.0d0 + xx + yy
      dzz    = dxx + dyy 

      pp      = 1.0d0/zz
      term    = (cc + dd + ee + ff + gg + hh)*pp
      dtermdt = ((dcc + ddd + dee + dff + dgg + dhh) - term*dzz)*pp


! the rates 
      fr    = den * term
      dfrdt = den * dtermdt * 1.0d-9
      dfrdd = term

      rev      = 1.13d+11*(tf% t932)*exp(-134.434*(tf% t9i))
      drevdt   = rev*(1.5d0*(tf% t9i) + 134.434*(tf% t9i2))

      rr    = rev * term
      drrdt = (drevdt * term + rev * dtermdt) * 1.0d-9
      drrdd = 0.0d0

      end subroutine rate_al27pg_old

















































