# jacobian.rb

load "../../utils/image_plot.rb"
    
class Jac_data < Image_data

    attr_accessor :zs

    def initialize(data_dir, name, which_case)        
      read_image_Xs(data_dir, 'jacobian_cols.data', 'cell')
      read_image_Ys(data_dir, 'jacobian_rows.data', '')
      @zs = read_image_data(data_dir, name)
    end

end # class Jac_data


class Jac_plot

    include Math
    include Tioga
    include FigureConstants
    include Image_plot
    
    def initialize(data_dir,namesfilename)

        @data_dir = data_dir
        @figure_maker = FigureMaker.default
        t.def_eval_function { |str| eval(str) }
        t.save_dir = 'plot_out'

        read_names(data_dir + '/' + namesfilename)
        @num_values=@names.size
        @image_array = []
        
        @num_values.times { |i|
           @image_array << Jac_data.new(data_dir, @names[i], @which_case)
        }
        
        @num_values.times do |i|
            if (i+1) != @xaxis_column
               eval(sprintf("t.def_figure(\"%s\") { plot %i }", @names[i], i))
            end
         end
        
        @no_clipping = true
        
        @z_upper = nil
        @z_lower = nil
        
        t.def_enter_page_function { enter_page }    
    end
    
    
    def enter_page
        t.yaxis_numeric_label_angle = -90
        t.page_setup(11*72/2,8.5*72/2)
        t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords  
    end
    
    
    def read_names(names_filename)
        f = File.open(names_filename)
        max_number_of_names = 1000
        @names = []
        max_number_of_names.times {|i| 
            begin
                namestr = f.readline.strip # remove whitespace
            rescue
                namestr = ''
            end
            break if namestr.size == 0
            @names << namestr
        }
        f.close
    end

    def t
        @figure_maker
    end
    
    def d
        @image_data
    end

    # plot routines
    
    def special_yaxis_for_image
        t.yaxis_numeric_label_angle = -90
        num_majors = 5
        dy = (d.image_ymax - d.image_ymin) / num_majors
        t.yaxis_locations_for_major_ticks = []
        num_majors.times {|i| 
           t.yaxis_locations_for_major_ticks << d.image_ymin + (i + 0.5)*dy }
        t.yaxis_locations_for_major_ticks = [ -4.0/5, 0, 4.0/5 ]
        t.yaxis_tick_labels = [ '-', '0', '+' ]
        t.yaxis_numeric_label_justification = RIGHT_JUSTIFIED
        t.yaxis_number_of_minor_intervals = 2
        t.yaxis_numeric_label_scale = 1.2
        t.yaxis_minor_tick_length = 1
        t.yaxis_major_tick_length = 0.2
    end
    
    def plot(i)
        @image_data = @image_array[i]
        d.image_ymax = 1
        d.image_ymin = -1
        image_plot('d' => d, 'zs' => d.zs, 'title' => @names[i], 
                  'z_lower' => @z_lower, 'z_upper' => @z_upper,
                  'z_limits_symmetric' => true, 'interpolate' => false)
    end
    
end


Jac_plot.new('plot_data','jacobian.names')
