! ***********************************************************************
!
!   copyright (c) 2008  bill paxton
!
!   this file is part of mesa.
!
!   mesa is free software; you can redistribute it and/or modify
!   it under the terms of the gnu general library public license as published
!   by the free software foundation; either version 2 of the license, or
!   (at your option) any later version.
!
!   mesa is distributed in the hope that it will be useful,
!   but without any warranty; without even the implied warranty of
!   merchantability or fitness for a particular purpose.  see the
!   gnu library general public license for more details.
!
!   you should have received a copy of the gnu library general public license
!   along with this software; if not, write to the free software
!   foundation, inc., 59 temple place, suite 330, boston, ma 02111-1307 usa
!
! ***********************************************************************

! the following is the copyright for seulex

! copyright (c) 2004, ernst hairer

! redistribution and use in source and binary forms, with or without 
! modification, are permitted provided that the following conditions are 
! met:

! - redistributions of source code must retain the above copyright 
! notice, this list of conditions and the following disclaimer.

! - redistributions in binary form must reproduce the above copyright 
! notice, this list of conditions and the following disclaimer in the 
! documentation and/or other materials provided with the distribution.

! this software is provided by the copyright holders and contributors “as 
! is” and any express or implied warranties, including, but not limited 
! to, the implied warranties of merchantability and fitness for a 
! particular purpose are disclaimed. in no event shall the regents or 
! contributors be liable for any direct, indirect, incidental, special, 
! exemplary, or consequential damages (including, but not limited to, 
! procurement of substitute goods or services; loss of use, data, or 
! profits; or business interruption) however caused and on any theory of 
! liability, whether in contract, strict liability, or tort (including 
! negligence or otherwise) arising in any way out of the use of this 
! software, even if advised of the possibility of such damage.


      module mod_seulex
      use mod_dc_decsol
      
      contains

      subroutine do_seulex(
     >      n,fcn,ifcn,x,y,xend,
     >      h,max_step_size,max_steps,
     >      rtol,atol,itol,y_min,y_max,
     >      jac,ijac,sjac,nzmax,isparse,mljac_in,mujac_in,
     >      mas,imas,mlmas,mumas,
     >      solout,iout,
     >      decsol, decsols, decsolblk, 
     >      lrd, rpar_decsol, lid, ipar_decsol,  
     >      caller_id, nvar, nz, lblk, dblk, ublk, uf_lblk, uf_dblk, uf_ublk, 
     >      fcn_blk_dble, jac_blk_dble,
     >      work,lwork,iwork,liwork,
     >      lrpar,rpar,lipar,ipar,
     >      lout,idid)

! *** *** *** *** *** *** *** *** *** *** *** *** ***
!          declarations 
! *** *** *** *** *** *** *** *** *** *** *** *** ***
         implicit double precision (a-h,o-z)
         integer, intent(in) :: n ! the dimension of the system
         interface ! subroutine for computing the value of f(x,y)
            include "num_fcn.dek"
            include "num_fcn_blk_dble.dek"
         end interface
         integer, intent(in) :: ifcn ! gives information on fcn:
         double precision, intent(inout) :: x 
         double precision, intent(inout), pointer :: y(:) ! (n) 
         double precision, intent(in) :: xend ! desired final x value (positive or negative)
         double precision, intent(inout) :: h 
         double precision, intent(in) :: max_step_size
         integer, intent(in) :: max_steps
         double precision, intent(in) :: rtol(*) ! relative error tolerance(s)
         double precision, intent(in) :: atol(*) ! absolute error tolerance(s)
         integer, intent(in) :: itol ! switch for rtol and atol
         double precision, intent(in) :: y_min, y_max
         interface ! subroutine for computing the jacobian
            include "num_jac.dek"
            include "num_jac_blk_dble.dek" ! for double block tridiagonal matrix
            include "num_sjac.dek" ! for sparse matrix
         end interface
         integer, intent(in) :: ijac, nzmax, isparse, mljac_in, mujac_in
         interface ! subroutine for computing the mass matrix
            include "num_mas.dek"
         end interface
         integer, intent(in) :: imas ! gives information on the mass-matrix:
         integer, intent(in) :: mlmas
         integer, intent(in) :: mumas
         interface ! subroutine called after each successful step
            include "num_solout.dek"
         end interface
         integer, intent(in)  :: iout ! switch for calling the subroutine solout:
         interface
            include "mtx_decsol.dek"
            include "mtx_decsols.dek"
            include "mtx_decsolblk.dek"
         end interface
         integer, intent(in) :: caller_id, nvar, nz
         real(dp), dimension(:), pointer, intent(inout) :: lblk, dblk, ublk ! =(nvar,nvar,nz)
         real(dp), dimension(:), pointer, intent(inout) :: uf_lblk, uf_dblk, uf_ublk ! =(nvar,nvar,nz)
            
         integer, intent(in) :: lrd, lid
         integer, intent(inout), pointer :: ipar_decsol(:) ! (lid)
         double precision, intent(inout), pointer :: rpar_decsol(:) ! (lrd)
         
         integer, intent(in) :: lwork, liwork
         double precision, pointer :: work(:) ! (lwork)
         integer, pointer :: iwork(:) ! (liwork)
         
         integer, intent(in) :: lrpar, lipar
         integer, intent(inout), pointer :: ipar(:) ! (lipar)
         double precision, intent(inout), pointer :: rpar(:) ! (lrpar)
         
         integer, intent(in)  :: lout
         integer, intent(out)  :: idid

      real(dp), pointer, dimension(:) :: p1, p2, p3, p4, p5, p6, p7, p8
      integer, pointer, dimension(:) :: ip1
      logical autnms,implct,arret,jband
      integer :: mujac,mljac
      mujac=mujac_in; mljac=mljac_in
! *** *** *** *** *** *** ***
!        setting the parameters 
! *** *** *** *** *** *** ***
      nfcn=0
      njac=0
      nstep=0
      naccpt=0
      nrejct=0
      ndec=0
      nsol=0
      arret=.false.
! -------- nmax , the maximal number of steps -----
      if(max_steps.eq.0)then
         nmax=100000
      else
         nmax=max_steps
         if(nmax.le.0)then
            if (lout > 0) write(lout,*)' wrong input max_steps=',max_steps
            arret=.true.
         end if
      end if
! -------- km     maximum number of columns in the extrapolation 
      if(iwork(3).eq.0)then
         km=12
      else
         km=iwork(3)
         if(km.le.2)then
            if (lout > 0) write(lout,*)' curious input iwork(3)=',iwork(3)
            arret=.true.
         end if
      end if
! -------- nsequ     choice of step size sequence
      nsequ=iwork(4)
      if(iwork(4).eq.0) nsequ=2
      if(nsequ.le.0.or.nsequ.ge.5)then
         if (lout > 0) write(lout,*)' curious input iwork(4)=',iwork(4)
         arret=.true.
      end if 
! -------- lambda   parameter for dense output
      lambda=iwork(5)
      if(lambda.lt.0.or.lambda.ge.2)then
         if (lout > 0) write(lout,*)' curious input iwork(5)=',iwork(5)
         arret=.true.
      end if 
! -------- nrdens   number of dense output components
      nrdens=iwork(6)
      if(nrdens.lt.0.or.nrdens.gt.n)then
         if (lout > 0) write(lout,*)' curious input iwork(6)=',iwork(6)
         arret=.true.
      end if
! -------- parameter for second order equations
      m1=iwork(9)
      m2=iwork(10)
      nm1=n-m1
      if (m1.eq.0) m2=n
      if (m2.eq.0) m2=m1
      if (m1.lt.0.or.m2.lt.0.or.m1+m2.gt.n) then
       if (lout > 0) write(lout,*)' curious input for iwork(9,10)=',m1,m2
       arret=.true.
      end if
      nerror=iwork(11) ! number of variables to use for tolerances
      if (nerror.eq.0) nerror=n
! -------- uround   smallest number satisfying 1.d0+uround>1.d0  
      if(work(1).eq.0.d0)then
         uround=1.d-16
      else
         uround=work(1)
         if(uround.le.0.d0.or.uround.ge.1.d0)then
            if (lout > 0) write(lout,*)'  uround=',work(1)
            arret=.true.
         end if
      end if
! -------- maximal step size
      if(max_step_size.eq.0.d0)then
         hmax=xend-x
      else
         hmax=max_step_size
      end if
! ------ thet     decides whether the jacobian should be recomputed;
      if(work(3).eq.0.d0)then
         thet=min(1.0d-4,rtol(1))
      else
         thet=work(3)
      end if
! -------  fac1,fac2     parameters for step size selection
      if(work(4).eq.0.d0)then
         fac1=0.1d0
      else
         fac1=work(4)
      end if
      if(work(5).eq.0.d0)then
         fac2=4.0d0
      else
         fac2=work(5)
      end if
! -------  fac3, fac4   parameters for the order selection
      if(work(6).eq.0.d0)then
         fac3=0.7d0
      else
         fac3=work(6)
      end if
      if(work(7).eq.0.d0)then
         fac4=0.9d0
      else
         fac4=work(7)
      end if
! ------- safe1, safe2 safety factors for step size prediction
      if(work(8).eq.0.d0)then
         safe1=0.6d0
      else
         safe1=work(8)
      end if
      if(work(9).eq.0.d0)then
         safe2=0.93d0
      else
         safe2=work(9)
      end if
! ------- wkfcn,wkjac,wkdec,wksol  estimated work for  fcn,jac,dec,sol
      if(work(10).eq.0.d0)then
         wkfcn=1.d0
      else
         wkfcn=work(10)
      end if
      if(work(11).eq.0.d0)then
         wkjac=5.d0
      else
         wkjac=work(11)
      end if
      if(work(12).eq.0.d0)then
         wkdec=1.d0
      else
         wkdec=work(12)
      end if
      if(work(13).eq.0.d0)then
         wksol=1.d0
      else
         wksol=work(13)
      end if
      wkrow=wkfcn+wksol
! --------- check if tolerances are o.k.
      if (itol.eq.0) then
          if (atol(1).le.0.d0.or.rtol(1).le.10.d0*uround) then
              write (6,*) ' tolerances are too small'
              arret=.true.
          end if
      else
        do i=1,n
          if (atol(i).le.0.d0.or.rtol(i).le.10.d0*uround) then
              write (6,*) ' tolerances(',i,') are too small'
              arret=.true.
          end if
        end do
      end if
! *** *** *** *** *** *** *** *** *** *** *** *** ***
!         computation of array entries
! *** *** *** *** *** *** *** *** *** *** *** *** ***
! ---- autonomous, implicit, banded or not ?
      autnms=ifcn.eq.0
      implct=imas.ne.0
      jband=mljac.lt.nm1 .and. nzmax == 0
      if ((nzmax > 0) .and. (jband .or. ijac==0 .or. m1 /= 0)) then
         if (lout > 0) write(lout,*) 'sparse matrix -- nzmax > 0 -- requires ijac=1, m1=0, mljac=n'
         arret=.true.
      end if
! -------- computation of the row-dimensions of the 2-arrays ---
! -- jacobian and matrix e
      if(jband)then
         ldjac=mljac+mujac+1
         lde=mljac+ldjac
      else
         mljac=nm1
         mujac=nm1
         ldjac=nm1
         lde=nm1
      end if
! -- mass matrix
      if (implct) then
          if (mlmas.ne.nm1) then
              ldmas=mlmas+mumas+1
              if (nzmax > 0) then ! sparse jacobian
                 ijob=9
              else if (jband) then
                 ijob=4
              else
                 ijob=3
              end if
          else
              ldmas=nm1
              ijob=5
          end if
! ------ bandwith of "mas" not larger than bandwith of "jac"
          if (mlmas.gt.mljac.or.mumas.gt.mujac) then
              if (lout > 0) then
                  write(lout,*) 'bandwith of "mas" must not be larger than bandwith of "jac"'
                  write(lout,*) 'mlmas', mlmas
                  write(lout,*) 'mljac', mljac
                  write(lout,*) 'mumas', mumas 
                  write(lout,*) 'mujac', mujac
              end if
              arret=.true.
          end if
      else
          ldmas=0
          if (nzmax > 0) then
             ijob=8
          else if (jband) then
             ijob=2
          else
             ijob=1
          end if
      end if
      ldmas2=max(1,ldmas)
! ------- prepare the entry-points for the arrays in work ----- 
      km2=(km*(km+1))/2
      ieyh=21
      iedy=ieyh+n
      iefx=iedy+n
      ieyhh=iefx+n
      iedyh=ieyhh+n
      iedel=iedyh+n
      iewh =iedel+n
      iescal=iewh+n
      iehh =iescal+n
      iew  =iehh+km
      iea  =iew+km
      iejac =iea+km
      iee  =iejac+n*ldjac
      iemas=iee+nm1*lde
      iet=iemas+nm1*ldmas
      ifac=iet+n*km  
      iede=ifac+km
      ifsafe=iede+2+(km+2)*nrdens
      iesj=ifsafe+km2*nrdens
      iesa=iesj+nzmax
! ------ total storage requirement -----------
      istore=iesa+nzmax-1
      if(istore.gt.lwork)then
         if (lout > 0) write(lout,*)' insufficient storage for work, min. lwork=',istore,lwork
         arret=.true.
      end if
! ------- entry points for integer workspace -----
      ieco=20
      ieip=ieco+nrdens+5
      ienj=ieip+n 
      ieiph=ienj+km
      ieia=ieiph+n
      ieja=ieia+n+1
! --------- total requirement ---------------
      istore=ieja+nzmax-1
      if(istore.gt.liwork)then
         if (lout > 0) write(lout,*)' insuff. storage for iwork, min. liwork=',istore,liwork
         arret=.true.
      end if
! ------ when a fail has occured, we return with idid=-1
      if (arret) then
         idid=-1
         return
      end if 
      nrd=max(1,nrdens)
! -------- call to core integrator ------------
      p1(1:n) => work(iedel:iedel-1+n)
      p2(1:n*ldjac) => work(iee:iee-1+n*ldjac) 
      p3(1:n) => work(iedyh:iedyh-1+n) 
      p4(1:n) => work(ieyh:ieyh-1+n)
      p5(1:n) => work(iedy:iedy-1+n)
      p6(1:n) => work(iefx:iefx-1+n)
      p7(1:n) => work(ieyhh:ieyhh-1+n)
      p8(1:n) => work(iewh:iewh-1+n)
            
      ip1(1:nrdens+5) => iwork(ieip:ieip-1+nrdens+5)
      call seucor(n,fcn,x,y,xend,hmax,h,km,rtol,atol,itol,y_min,y_max,
     &   jac,ijac,sjac,nzmax,isparse,mljac,mujac,mas,mlmas,mumas,solout,iout,idid,
     &   decsol,decsols,decsolblk,
     &   caller_id, nvar, nz, lblk, dblk, ublk, uf_lblk, uf_dblk, uf_ublk,
     &   fcn_blk_dble, jac_blk_dble,
     &   iwork(ieia:liwork),iwork(ieja:liwork),
     &   work(iesj:lwork),work(iesa:lwork),lrd,rpar_decsol,lid,ipar_decsol,
     &   ijob,m1,m2,nm1,nerror,nmax,uround,nsequ,autnms,implct,jband,ldjac,lde,ldmas2,
     &   p4,p5,p6,p7,p3,
     &   p1,p8,work(iescal:lwork),work(iehh:lwork),
     &   work(iew:lwork),work(iea:lwork),work(iejac:lwork),p2,work(iemas:lwork),
     &   work(iet:lwork),ip1,iwork(ienj:liwork),iwork(ieiph:liwork),fac1,fac2,fac3,
     &   fac4,thet,safe1,safe2,wkjac,wkdec,wkrow,km2,nrd,work(ifac:liwork),
     &   work(ifsafe:lwork),lambda,nfcn,njac,nstep,naccpt,nrejct,ndec,nsol,
     &   lout,lrpar,rpar,lipar,ipar,work(iede:lwork),iwork(ieco:liwork))
      iwork(14)=nfcn
      iwork(15)=njac
      iwork(16)=nstep
      iwork(17)=naccpt
      iwork(18)=nrejct
      iwork(19)=ndec
      iwork(20)=nsol
! ----------- return -----------
      return
      end subroutine do_seulex

!
!  ----- ... and here is the core integrator  ----------
!
      subroutine seucor(n,fcn,x,y,xend,hmax,h,km,rtol,atol,itol,y_min,y_max,
     &  jac,ijac,sjac,nzmax,isparse,mljac,mujac,mas,mlb,mub,solout,iout,idid,
     &  decsol,decsols,decsolblk,
     &  caller_id, nvar, nz, lblk, dblk, ublk, uf_lblk, uf_dblk, uf_ublk,
     &  fcn_blk_dble, jac_blk_dble,
     &  ia,ja,sparse_jac,sa,lrd,rpar_decsol,lid,ipar_decsol,
     &  ijob,m1,m2,nm1,nerror,nmax,uround,nsequ,autnms,implct,banded,lfjac,le,ldmas,
     &  yh,dy,fx,yhh,dyh,del,wh,scal,hh,w,a,fjac,e,fmas,t,ip,
     &  nj,iphes,fac1,fac2,fac3,fac4,thet,safe1,safe2,wkjac,wkdec,wkrow,
     &  km2,nrd,facul,fsafe,lambda,nfcn,njac,nstep,naccpt,nrejct,ndec,nsol,
     &  lout,lrpar,rpar,lipar,ipar,rwork,iwork)
! ----------------------------------------------------------
!     core integrator for seulex
!     parameters same as in seulex with workspace added 
! ---------------------------------------------------------- 
!         declarations 
! ---------------------------------------------------------- 
       implicit double precision (a-h,o-z)
       interface
         include "num_solout.dek"
         include "num_mas.dek"
         include "num_fcn.dek"
         include "num_fcn_blk_dble.dek"
         include "num_jac.dek"
         include "num_jac_blk_dble.dek" ! for double block tridiagonal matrix
         include "num_sjac.dek"
         include "mtx_decsol.dek"
         include "mtx_decsols.dek"
         include "mtx_decsolblk.dek"
       end interface
       integer, intent(in) :: nzmax, lrpar, lipar, lrd, lid
       integer :: ia(:) ! (n+1)
       integer :: ja(:) ! (nzmax)
       real(dp) :: sparse_jac(:), sa(:) ! (nzmax)
       integer, intent(in) :: caller_id, nvar, nz
       real(dp), dimension(:), pointer, intent(inout) :: lblk, dblk, ublk ! =(nvar,nvar,nz)
       real(dp), dimension(:), pointer, intent(inout) :: uf_lblk, uf_dblk, uf_ublk ! =(nvar,nvar,nz)
 
       ! args
       double precision, intent(inout), pointer, dimension(:) :: y, dy, yh, yhh, fx, wh ! (n) 
       dimension scal(n),hh(km),w(km),a(km),fjac(lfjac,n)
       dimension fmas(ldmas,nm1),t(km,n),nj(km)
       dimension rtol(*),atol(*)
       dimension iphes(n),fsafe(km2,nrd),facul(km)
       
      real(dp), pointer :: del(:), dyh(:)
      real(dp), pointer :: e(:)
      integer, pointer :: ip(:)
       
       
      real(dp), intent(inout), pointer :: rpar_decsol(:) ! (lrd)
      integer, intent(inout), pointer :: ipar_decsol(:) ! (lid)
      !dimension rpar_decsol(lrd),ipar_decsol(lid)
      
      integer, intent(inout), pointer :: ipar(:) ! (lipar)
      real(dp), intent(inout), pointer :: rpar(:) ! (lrpar)
      !dimension rpar(lrpar),ipar(lipar)
       
       
       double precision, target :: rwork(2+(km+2)*nrd)
       integer, target :: iwork(5+nrd)
       
       
       
       logical reject,last,atov,caljac,calhes,autnms,implct,banded
       !common /coseu/xoldd,hhh,nnrd,kright
       !common/linal/mle,mue,mbjac,mbb,mdiag,mdiff,mbdiag
       double precision, pointer :: dens(:)
       integer, pointer :: icomp(:)
       
       iwork(1) = nrd
       icomp => iwork(2:1+nrd)
       dens => rwork(1:(km+2)*nrd)
       nnrd = nrd
       kright = 1
       xoldd = 0
       hhh = 0
! --- compute coefficients for dense output
       if (iout.eq.2) then
! --- compute the factorials --------
          facul(1)=1.d0
          do i=1,km-1
             facul(i+1)=i*facul(i)
          end do
       end if
! ------- compute mass matrix for implicit case ----------
      if (implct) call mas(nm1,fmas,ldmas,lrpar,rpar,lipar,ipar)
! *** *** *** *** *** *** ***
!  initialisations
! *** *** *** *** *** *** ***
       ierr=0
       lrde=(km+2)*nrd
       mle=mljac
       mue=mujac
       mbjac=mljac+mujac+1
       mbb=mlb+mub+1
       mdiag=mle+mue+1
       mdiff=mle+mue-mub
       mbdiag=mub+1
       if (m1.gt.0) ijob=ijob+10       
! --- define the step size sequence
       if (nsequ.eq.1) then
           nj(1)=1
           nj(2)=2
           nj(3)=3
           do i=4,km
              nj(i)=2*nj(i-2)
           end do
       end if
       if (nsequ.eq.2) then
           nj(1)=2
           nj(2)=3
           do i=3,km
              nj(i)=2*nj(i-2)
           end do
       end if
       do i=1,km
          if (nsequ.eq.3) nj(i)=i
          if (nsequ.eq.4) nj(i)=i+1
       end do
       a(1)=wkjac+nj(1)*wkrow+wkdec
       do i=2,km
          a(i)=a(i-1)+(nj(i)-1)*wkrow+wkdec
       end do
       posneg=sign(1.d0,xend-x) 
       k=max0(2,min0(km-2,int(-dlog10(rtol(1)+atol(1))*.6d0+1.5d0))) 
       hmaxn=min(abs(hmax),abs(xend-x)) 
       h=max(abs(h),1.d-12) 
       h=posneg*min(h,hmaxn)
       theta=2*abs(thet)
       if (iout.ne.0) then
          irtrn=1
          nrsol=1
          xsol=x
          do i=1,n
            yh(i)=y(i)
          end do
          nsolu=n
          xold=x
          iwork(2+nrd) = lrde
          iwork(3+nrd) = nrd
          iwork(4+nrd) = nnrd
          iwork(5+nrd) = kright
          !iwork(5:4+nrd) = icomp(1:nrd)
          j=1+lrde
          rwork(j) = xoldd; j=j+1
          rwork(j) = hhh
          call solout(nrsol,xold,xsol,nsolu,yh,rwork,iwork,contex,lrpar,rpar,lipar,ipar,irtrn)
          if (irtrn.lt.0) goto 111
          ipt=0
       end if
       err=0.d0
       w(1)=1.d30  
       do i=1,n
          if (itol.eq.0) then
            scal(i)=atol(1)+rtol(1)*dabs(y(i))
          else
            scal(i)=atol(i)+rtol(i)*dabs(y(i))
          end if
       end do
       caljac=.false.
       reject=.false.
       last=.false.
  10   continue
       if (reject) theta=2*abs(thet)
       atov=.false.
! *** *** *** *** *** *** ***
! --- is xend reached in the next step?
! *** *** *** *** *** *** ***
       if (0.1d0*abs(xend-x).le.abs(x)*uround) go to 110
       hopt=h
       h=posneg*min(abs(h),abs(xend-x),hmaxn)       
       if ((x+1.01d0*h-xend)*posneg.gt.0.d0) then
          h=xend-x 
          last=.true.
       end if       
       if (autnms) then
          if (ijac == 0 .or. .not.(theta.gt.thet.and..not.caljac)) then
             if (nvar > 0) then
               call fcn_blk_dble(n,caller_id,nvar,nz,x,y,dy,lrpar,rpar,lipar,ipar,ierr)
             else
               call fcn(n,x,y,dy,lrpar,rpar,lipar,ipar,ierr)
             endif                
             if (ierr /= 0) goto 120
             nfcn=nfcn+1
          end if
       end if
       if (theta.gt.thet.and..not.caljac) then
! *** *** *** *** *** *** ***
!  computation of the jacobian
! *** *** *** *** *** *** ***
          njac=njac+1
          if (ijac.eq.0) then
! --- compute jacobian matrix numerically
              if (.not.autnms) then
                if (nvar > 0) then
                  call fcn_blk_dble(n,caller_id,nvar,nz,x,y,dy,lrpar,rpar,lipar,ipar,ierr)
                else
                  call fcn(n,x,y,dy,lrpar,rpar,lipar,ipar,ierr)
                endif                
                if (ierr /= 0) goto 120
                nfcn=nfcn+1
              end if
              if (banded) then
! --- jacobian is banded
                  mujacp=mujac+1
                  md=min(mbjac,n)
                  do mm=1,m1/m2+1
                     do kx=1,md
                        j=kx+(mm-1)*m2
 12                     yhh(j)=y(j)
                        del(j)=dsqrt(uround*max(1.d-5,abs(y(j))))
                        y(j)=y(j)+del(j)
                        j=j+md
                        if (j.le.mm*m2) goto 12 
                        if (nvar > 0) then
                           call fcn_blk_dble(n,caller_id,nvar,nz,x,y,yh,lrpar,rpar,lipar,ipar,ierr)
                        else
                           call fcn(n,x,y,yh,lrpar,rpar,lipar,ipar,ierr)
                        endif                
                        if (ierr /= 0) goto 120
                        j=kx+(mm-1)*m2
                        j1=kx
                        lbeg=max(1,j1-mujac)+m1
 14                     lend=min(m2,j1+mljac)+m1
                        y(j)=yhh(j)
                        mujacj=mujacp-j1-m1
                        do l=lbeg,lend
                           fjac(l+mujacj,j)=(yh(l)-dy(l))/del(j) 
                        end do
                        j=j+md
                        j1=j1+md
                        lbeg=lend+1
                        if (j.le.mm*m2) goto 14
                     end do
                  end do
               else
! --- jacobian is full
                  do i=1,n
                     ysafe=y(i)
                     delt=dsqrt(uround*max(1.d-5,abs(ysafe)))
                     y(i)=ysafe+delt
                     if (nvar > 0) then
                        call fcn_blk_dble(n,caller_id,nvar,nz,x,y,yh,lrpar,rpar,lipar,ipar,ierr)
                     else
                        call fcn(n,x,y,yh,lrpar,rpar,lipar,ipar,ierr)
                     endif                
                     if (ierr /= 0) goto 120
                     do j=m1+1,n
                       fjac(j-m1,i)=(yh(j)-dy(j))/delt
                     end do
                     y(i)=ysafe
                     mljac=nm1
                  end do
               end if
            else
! --- compute jacobian matrix analytically
               if (nzmax == 0) then
                  if (nvar > 0) then
                     call jac_blk_dble(n,caller_id,nvar,nz,x,y,dy,uf_lblk,uf_dblk,uf_ublk,lrpar,rpar,lipar,ipar,ierr)
                  else
                     call jac(n,x,y,dy,fjac,lfjac,lrpar,rpar,lipar,ipar,ierr)
                  end if
               else
                  call sjac(n,x,y,dy,nzmax,ia,ja,sparse_jac,lrpar,rpar,lipar,ipar,ierr)
               end if
               if (ierr /= 0) goto 120
           end if
           caljac=.true.
           calhes=.true.
       end if
! *** *** *** *** *** *** ***
! --- the first and last step 
! *** *** *** *** *** *** ***
      if (nstep.eq.0.or.last) then 
        ipt=0
        nstep=nstep+1 
        do j=1,k
         kc=j
         call seul(j,n,nerror,fcn,x,y,dy,fx,fjac,lfjac,fmas,ldmas,e,le,ip,h,km,
     &             y_min,y_max,
     &             decsol,decsols,decsolblk,
     &             caller_id, nvar, nz, lblk, dblk, ublk, uf_lblk, uf_dblk, uf_ublk,
     &             fcn_blk_dble,
     &             nzmax,isparse,ia,ja,sparse_jac,sa,
     &             lrd,rpar_decsol,lid,ipar_decsol,
     &             hmaxn,t,scal,nj,hh,w,a,yhh,dyh,del,wh,err,safe1,fac,
     &             fac1,fac2,safe2,theta,mljac,mujac,nfcn,ndec,nsol,mlb,
     &             mub,errold,iphes,icomp,autnms,implct,banded,reject,
     &             atov,fsafe,km2,nrd,iout,
     &             mle,mue,mbjac,mbb,mdiag,mdiff,mbdiag,
     &             ipt,m1,m2,nm1,ijob,calhes,lrpar,rpar,lipar,ipar,ierr)
         if (ierr /= 0) goto 120
         if (atov) goto 10
         if (j.gt.1.and.err.le.1.d0) go to 60
        end do
        go to 55
      end if
! --- basic integration step  
  30  continue
      ipt=0
      nstep=nstep+1
      if (nstep.ge.nmax) go to 120 
      kc=k-1
      do j=1,kc
       call seul(j,n,nerror,fcn,x,y,dy,fx,fjac,lfjac,fmas,ldmas,e,le,ip,h,km,
     &           y_min,y_max,
     &           decsol,decsols,decsolblk,
     &           caller_id, nvar, nz, lblk, dblk, ublk, uf_lblk, uf_dblk, uf_ublk,
     &           fcn_blk_dble, 
     &           nzmax,isparse,ia,ja,sparse_jac,sa,
     &           lrd,rpar_decsol,lid,ipar_decsol,
     &           hmaxn,t,scal,nj,hh,w,a,yhh,dyh,del,wh,err,safe1,fac,
     &           fac1,fac2,safe2,theta,mljac,mujac,nfcn,ndec,nsol,
     &           mlb,mub,errold,iphes,icomp,autnms,implct,banded,reject,
     &           atov,fsafe,km2,nrd,iout,
     &           mle,mue,mbjac,mbb,mdiag,mdiff,mbdiag,
     &           ipt,m1,m2,nm1,ijob,calhes,lrpar,rpar,lipar,ipar,ierr)
       if (ierr /= 0) goto 120
       if (atov) goto 10
      end do
! *** *** *** *** *** *** ***
! --- convergence monitor
! *** *** *** *** *** *** ***
      if (k.eq.2.or.reject) go to 50
      if (err.le.1.d0) go to 60
      if (err.gt.dble(nj(k+1)*nj(k))*4.d0) go to 100  
  50  call seul(k,n,nerror,fcn,x,y,dy,fx,fjac,lfjac,fmas,ldmas,e,le,ip,h,km,
     &           y_min,y_max,
     &           decsol,decsols,decsolblk,
     &           caller_id, nvar, nz, lblk, dblk, ublk, uf_lblk, uf_dblk, uf_ublk,
     &           fcn_blk_dble, 
     &           nzmax,isparse,ia,ja,sparse_jac,sa,
     &           lrd,rpar_decsol,lid,ipar_decsol,
     &           hmaxn,t,scal,nj,hh,w,a,yhh,dyh,del,wh,err,safe1,
     &           fac,fac1,fac2,safe2,theta,mljac,mujac,nfcn,ndec,nsol,
     &           mlb,mub,errold,iphes,icomp,autnms,implct,banded,reject,
     &           atov,fsafe,km2,nrd,iout,
     &           mle,mue,mbjac,mbb,mdiag,mdiff,mbdiag,
     &           ipt,m1,m2,nm1,ijob,calhes,lrpar,rpar,lipar,ipar,ierr)
      if (ierr /= 0) goto 120
      if (atov) goto 10
      kc=k 
      if (err.le.1.d0) go to 60
! --- hope for convergence in line k+1
  55  if (err.gt.dble(nj(k+1))*2.d0) go to 100  
      kc=k+1
      call seul(kc,n,nerror,fcn,x,y,dy,fx,fjac,lfjac,fmas,ldmas,e,le,ip,h,km,
     &           y_min,y_max,
     &           decsol,decsols,decsolblk,
     &           caller_id, nvar, nz, lblk, dblk, ublk, uf_lblk, uf_dblk, uf_ublk,
     &           fcn_blk_dble, 
     &           nzmax,isparse,ia,ja,sparse_jac,sa,
     &           lrd,rpar_decsol,lid,ipar_decsol,
     &           hmaxn,t,scal,nj,hh,w,a,yhh,dyh,del,wh,err,safe1,
     &           fac,fac1,fac2,safe2,theta,mljac,mujac,nfcn,ndec,nsol,
     &           mlb,mub,errold,iphes,icomp,autnms,implct,banded,reject,
     &           atov,fsafe,km2,nrd,iout,
     &           mle,mue,mbjac,mbb,mdiag,mdiff,mbdiag,
     &           ipt,m1,m2,nm1,ijob,calhes,lrpar,rpar,lipar,ipar,ierr)
      if (ierr /= 0) goto 120
      if (atov) then
         goto 10
      end if
      if (err.gt.1.d0) go to 100
! *** *** *** *** *** *** ***
! --- step is accepted  
! *** *** *** *** *** *** ***
  60  xold=x 
      x=x+h
  99  format(a30,i6,1pe26.16)
      if (iout.eq.2) then 
         kright=kc
         do i=1,nrd
            dens(i)=y(icomp(i))
         end do
      end if
      do i=1,n
         t1i=t(1,i)
         if (itol.eq.0) then
            scal(i)=atol(1)+rtol(1)*dabs(t1i)
         else
            scal(i)=atol(i)+rtol(i)*dabs(t1i)
         end if
         y(i)=t1i
      end do
      naccpt=naccpt+1 
      caljac=.false.  
      if (iout.eq.2) then
         xoldd=xold
         hhh=h
         do i=1,nrd
            dens(nrd+i)=y(icomp(i))
         end do
         do klr=1,kright-1 
! --- compute differences
            if (klr.ge.2) then  
               do kk=klr,kc
                  lbeg=((kk+1)*kk)/2 
                  lend=lbeg-kk+2
                  do l=lbeg,lend,-1
                     do i=1,nrd
                        fsafe(l,i)=fsafe(l,i)-fsafe(l-1,i)
                     end do
                  end do
               end do
             end if
! --- compute derivatives at right end ----
             do kk=klr+lambda,kc
                facnj=nj(kk)
                facnj=facnj**klr/facul(klr+1)
                ipt=((kk+1)*kk)/2
                do  i=1,nrd   
                   krn=(kk-lambda+1)*nrd
                   dens(krn+i)=fsafe(ipt,i)*facnj
                end do
             end do
             do j=klr+lambda+1,kc
               dblenj=nj(j)
               do l=j,klr+lambda+1,-1
                 factor=dblenj/nj(l-1)-1.d0
                 do i=1,nrd
                   krn=(l-lambda+1)*nrd+i
                   dens(krn-nrd)=dens(krn)
     &                          +(dens(krn)-dens(krn-nrd))/factor
                 end do  
               end do  
             end do  
         end do  
! ---  compute the coefficients of the interpolation polynomial
         do in=1,nrd
            do j=1,kright 
               ii=nrd*j+in
               dens(ii)=dens(ii)-dens(ii-nrd)
            end do
         end do
      end if
      if (iout.ne.0) then
         irtrn=1
         nrsol=naccpt+1
         xsol=x
         do i=1,n
            yh(i)=y(i)
         end do
         nsolu=n
         iwork(2+nrd) = lrde
         iwork(3+nrd) = nrd
         iwork(4+nrd) = nnrd
         iwork(5+nrd) = kright
         j=1+lrde
         rwork(j) = xoldd; j=j+1
         rwork(j) = hhh
         call solout(nrsol,xold,xsol,nsolu,yh,rwork,iwork,contex,lrpar,rpar,lipar,ipar,irtrn)         
         if (irtrn.lt.0) goto 111
      end if
! --- compute optimal order
      if (kc.eq.2) then
         kopt=min(3,km-1)  
         if (reject) kopt=2  
         go to 80
      end if
      if (kc.le.k) then
         kopt=kc 
         if (w(kc-1).lt.w(kc)*fac3) kopt=kc-1  
         if (w(kc).lt.w(kc-1)*fac4) kopt=min0(kc+1,km-1)
      else 
         kopt=kc-1
         if (kc.gt.3.and.w(kc-2).lt.w(kc-1)*fac3) kopt=kc-2
         if (w(kc).lt.w(kopt)*fac4) kopt=min0(kc,km-1)
      end if
! --- after a rejected step
  80  if (reject) then 
         k=min0(kopt,kc)
         h=posneg*min(abs(h),abs(hh(k)))
         reject=.false.
         go to 10
      end if
! --- compute step size for next step
      if (kopt.le.kc) then
         h=hh(kopt)
      else 
         if (kc.lt.k.and.w(kc).lt.w(kc-1)*fac4) then 
            h=hh(kc)*a(kopt+1)/a(kc)
         else
            h=hh(kc)*a(kopt)/a(kc) 
         end if  
      end if
      k=kopt
      h=posneg*abs(h)
      go to 10
! *** *** *** *** *** *** ***
! --- step is rejected  
! *** *** *** *** *** *** ***
 100  k=min(k,kc,km-1)
      if (k.gt.2.and.w(k-1).lt.w(k)*fac3) k=k-1
      nrejct=nrejct+1  
      h=posneg*hh(k)
      last=.false.
      reject=.true.
      if (caljac) goto 30
      go to 10
! --- solution exit
 110  continue
      idid=1
      return
! --- solout says stop now exit
 111  continue
      idid=2
      return
! --- fail exit
 120  idid=-1
      return
      end subroutine seucor


! *** *** *** *** *** *** ***
!     s u b r o u t i n e    s e u l
! *** *** *** *** *** *** ***

      subroutine seul(
     &          jj,n,nerror,fcn,x,y,dy,fx,fjac,lfjac,fmas,ldmas,e,le,ip,h,km,
     &          y_min,y_max,
     &          decsol,decsols,decsolblk,
     &          caller_id, nvar, nz, lblk, dblk, ublk, uf_lblk, uf_dblk, uf_ublk,
     &          fcn_blk_dble,
     &          nzmax,isparse,ia,ja,sparse_jac,sa,
     &          lrd,rpar_decsol,lid,ipar_decsol,
     &          hmaxn,t,scal,nj,hh,w,a,yh,dyh,del,wh,err,safe1,
     &          fac,fac1,fac2,safe2,theta,mljac,mujac,nfcn,ndec,nsol,
     &          mlb,mub,errold,iphes,icomp,
     &          autnms,implct,banded,reject,atov,fsafe,km2,nrd,iout,
     &          mle,mue,mbjac,mbb,mdiag,mdiff,mbdiag,
     &          ipt,m1,m2,nm1,ijob,calhes,lrpar,rpar,lipar,ipar,ierr)
! --- this subroutine computes the j-th line of the
! --- extrapolation table and provides an estimate  
! --- of the optimal step size 
      use utils_lib,only:is_bad_num
      implicit double precision (a-h,o-z)
       interface
         include "num_fcn.dek"
         include "num_fcn_blk_dble.dek"
         include "mtx_decsol.dek"
         include "mtx_decsols.dek"
         include "mtx_decsolblk.dek"
       end interface
      integer, intent(in) :: nzmax, lrpar, lipar, lrd, lid
      integer :: ia(:) ! (n+1)
      integer :: ja(:) ! (nzmax)
      real(dp) :: sparse_jac(:), sa(:) ! (nzmax)
      integer, intent(in) :: caller_id, nvar, nz
      real(dp), dimension(:), pointer, intent(inout) :: lblk, dblk, ublk ! =(nvar,nvar,nz)
      real(dp), dimension(:), pointer, intent(inout) :: uf_lblk, uf_dblk, uf_ublk ! =(nvar,nvar,nz)

      ! args
      integer, intent(inout), pointer :: ipar(:) ! (lipar)
      double precision, intent(inout), pointer :: rpar(:) ! (lrpar)
      integer, intent(inout), pointer :: ipar_decsol(:) ! (lid)
      double precision, intent(inout), pointer :: rpar_decsol(:) ! (lrd)
      real(dp), pointer :: del(:)
      real(dp), pointer :: dyh(:)
      real(dp), pointer :: e(:) ! =(lde,nm1)
      integer, pointer :: ip(:)
      
      double precision, intent(inout), pointer, dimension(:) :: y, dy, yh, fx, wh ! (n) 
      dimension scal(n),hh(km),w(km),a(km),fjac(lfjac,n)
      dimension fmas(ldmas,n),t(km,n),nj(km),iphes(n)
      dimension fsafe(km2,nrd),icomp(nrd)
      logical atov,reject,autnms,implct,banded,calhes
      !common/linal/mle,mue,mbjac,mbb,mdiag,mdiff,mbdiag
      ierr=0
! *** *** *** *** *** *** ***
!  compute the matrix e and its decomposition
! *** *** *** *** *** *** ***
      hj=h/nj(jj)
      hji=1.d0/hj
      call decomr(n,fjac,lfjac,fmas,ldmas,mlb,mub,
     &            m1,m2,nm1,hji,e,le,ip,del,ierr,ijob,calhes,iphes,
     &            mle,mue,mbjac,mbb,mdiag,mdiff,mbdiag,
     &            decsol,decsols,decsolblk,
     &            caller_id, nvar, nz, lblk, dblk, ublk, uf_lblk, uf_dblk, uf_ublk,
     &            sparse_jac,nzmax,isparse,ia,ja,sa,lrd,rpar_decsol,lid,ipar_decsol)
      if (ierr.ne.0) goto 79
      ndec=ndec+1
! *** *** *** *** *** *** ***
! --- starting procedure
! *** *** *** *** *** *** ***
       if (.not.autnms) then
            if (nvar > 0) then
               call fcn_blk_dble(n,caller_id,nvar,nz,x+hj,y,dy,lrpar,rpar,lipar,ipar,ierr)
            else
               call fcn(n,x+hj,y,dy,lrpar,rpar,lipar,ipar,ierr)
            endif
            if (ierr /= 0) goto 79
            nfcn=nfcn+1   
       end if
       do i=1,n
          yh(i)=y(i)
          del(i)=dy(i)
       end do
       call slvseu(n,fjac,lfjac,mljac,mujac,fmas,ldmas,mlmas,mumas,
     &          m1,m2,nm1,hji,e,le,ip,iphes,del,ijob,
     &          mle,mue,mbjac,mbb,mdiag,mdiff,mbdiag,
     &          decsol,decsols,decsolblk,
     &          caller_id, nvar, nz, lblk, dblk, ublk,
     &          nzmax,isparse,ia,ja,sa,lrd,rpar_decsol,lid,ipar_decsol,ierr)
       if (ierr /= 0) goto 79
       nsol=nsol+1
       m=nj(jj)
       if (iout.eq.2.and.m.eq.jj) then 
          ipt=ipt+1
          do i=1,nrd
             fsafe(ipt,i)=del(icomp(i))
          end do
       end if
! *** *** *** *** *** *** ***
! --- semi-implicit euler method
! *** *** *** *** *** *** ***
       if (m.gt.1) then
          do mm=1,m-1
             do i=1,n
                yh(i)=yh(i)+del(i)
                if (yh(i) < y_min .or. yh(i) > y_max) then
                  if (.false.) write(*,*) 'yh(i) < y_min .or. yh(i) > y_max', i, yh(i)
                  goto 799
                end if
             end do
             if (autnms) then
                  if (nvar > 0) then
                     call fcn_blk_dble(n,caller_id,nvar,nz,x+hj*mm,yh,dyh,lrpar,rpar,lipar,ipar,ierr)
                  else
                     call fcn(n,x+hj*mm,yh,dyh,lrpar,rpar,lipar,ipar,ierr)
                  endif
                  if (ierr /= 0) goto 79
             else
                  if (nvar > 0) then
                     call fcn_blk_dble(n,caller_id,nvar,nz,x+hj*(mm+1),yh,dyh,lrpar,rpar,lipar,ipar,ierr)
                  else
                     call fcn(n,x+hj*(mm+1),yh,dyh,lrpar,rpar,lipar,ipar,ierr)
                  endif                
                  if (ierr /= 0) goto 79
             end if
             nfcn=nfcn+1
             if (mm.eq.1.and.jj.le.2) then
             
! --- stability check
                del1=0.d0
                do i=1,n
                   del1=del1+(del(i)/scal(i))**2
                end do
                del1=dsqrt(del1)
                if (implct) then
                   do i=1,nm1
                      wh(i)=del(i+m1)
                   end do
                   if (mlb.eq.nm1) then
                      do i=1,nm1
                         sum=0.d0
                         do j=1,nm1
                            sum=sum+fmas(i,j)*wh(j)
                         end do
                         del(i+m1)=sum
                      end do
                   else
                      do i=1,nm1
                         sum=0.d0
                         do j=max(1,i-mlb),min(nm1,i+mub)
                            sum=sum+fmas(i-j+mbdiag,j)*wh(j)
                         end do
                         del(i+m1)=sum
                      end do
                   end if
                end if
                
                if (.not.autnms) then
                   if (nvar > 0) then
                     call fcn_blk_dble(n,caller_id,nvar,nz,x+hj,yh,wh,lrpar,rpar,lipar,ipar,ierr)
                   else
                     call fcn(n,x+hj,yh,wh,lrpar,rpar,lipar,ipar,ierr)
                   endif                
                   if (ierr /= 0) goto 79  
                   nfcn=nfcn+1
                   do i=1,n
                      del(i)=wh(i)-del(i)*hji
                   end do
                else
                   do i=1,n
                      del(i)=dyh(i)-del(i)*hji
                   end do
                end if
                
                call slvseu(n,fjac,lfjac,mljac,mujac,fmas,ldmas,
     &            mlmas,mumas,m1,m2,nm1,hji,e,le,ip,iphes,del,ijob,
     &            mle,mue,mbjac,mbb,mdiag,mdiff,mbdiag,
     &            decsol,decsols,decsolblk,
     &            caller_id, nvar, nz, lblk, dblk, ublk,
     &            nzmax,isparse,ia,ja,sa,lrd,rpar_decsol,lid,ipar_decsol,ierr)
                if (ierr /= 0) goto 79
                nsol=nsol+1
                del2=0.d0
                do i=1,n
                   del2=del2+(del(i)/scal(i))**2
                end do
                del2=dsqrt(del2)
                theta=del2/max(1.d0,del1)
                if (theta.gt.1.d0) goto 79
             end if
             
             call slvseu(n,fjac,lfjac,mljac,mujac,fmas,ldmas,
     &          mlmas,mumas,m1,m2,nm1,hji,e,le,ip,iphes,dyh,ijob,
     &          mle,mue,mbjac,mbb,mdiag,mdiff,mbdiag,
     &          decsol,decsols,decsolblk,
     &          caller_id, nvar, nz, lblk, dblk, ublk,
     &          nzmax,isparse,ia,ja,sa,lrd,rpar_decsol,lid,ipar_decsol,ierr)
             if (ierr /= 0) goto 79
             nsol=nsol+1
             do i=1,n
                del(i)=dyh(i)
             end do
             if (iout.eq.2.and.mm.ge.m-jj) then 
                ipt=ipt+1
                do i=1,nrd
                   fsafe(ipt,i)=del(icomp(i))
                end do
             end if
             
          end do ! mm=1,m-1
          
       end if ! (m.gt.1)
       
       do i=1,n
         t(jj,i) = yh(i)+dyh(i)
         if (t(jj,i) < y_min .or. t(jj,i) > y_max) then
            if (.false.) write(*,*) 't(jj,i) < y_min .or. t(jj,i) > y_max', jj, i, t(jj,i)
         end if
       end do
       
       
! *** *** *** *** *** *** ***
! --- polynomial extrapolation
! *** *** *** *** *** *** ***
       if (jj.eq.1) return
       do l=jj,2,-1
          fac=(dble(nj(jj))/dble(nj(l-1)))-1.d0
          do i=1,n
             t(l-1,i)=t(l,i)+(t(l,i)-t(l-1,i))/fac
             if (t(l-1,i) < y_min .or. t(l-1,i) > y_max) then
               if (.false.) write(*,*) 't(l-1,i) < y_min .or. t(l-1,i) > y_max', l-1, i, t(l-1,i)
               goto 799
             end if
          end do
       end do
       err=0.d0
       do i=1,nerror
          err=err+min(abs((t(1,i)-t(2,i)))/scal(i),1.d15)**2 
       end do
       if (is_bad_num(err)) goto 79 ! watch out for extrapolation failures
       if (err.ge.1.d30) goto 79
       err=dsqrt(err/dble(nerror))
       if (jj.gt.2.and.err.ge.errold) goto 79
       errold=max(4*err,1.d0)
! --- compute optimal step sizes
       expo=1.d0/jj
       facmin=fac1**expo
       fac=min(fac2/facmin,dmax1(facmin,(err/safe1)**expo/safe2))
       fac=1.d0/fac
       hh(jj)=min(abs(h)*fac,hmaxn)
       w(jj)=a(jj)/hh(jj)  
       return
  79   atov=.true.
       h=h*0.5d0
       reject=.true.
       return
799   atov=.true.
       h=h*0.1d0
       reject=.true.
       return
       end subroutine seul



      double precision function contex(ii,x,rwork,iwork,ierr)
! ----------------------------------------------------------
!     this function can be used for coninuous output in conection
!     with the output-subroutine for seulex. it provides an
!     approximation to the ii-th component of the solution at x.
! ----------------------------------------------------------
      integer, intent(in) :: ii
      double precision, intent(in) :: x
      double precision, intent(inout), target :: rwork(*)
      integer, intent(inout), target :: iwork(*)
      integer, intent(out) :: ierr
      
      double precision :: xold, h, theta
      double precision, pointer :: rc(:)
      integer :: lrc, lic, nrd, ir, j, i
      integer, pointer :: ic(:)
      ierr=0

      nrd = iwork(1)
      ic => iwork(2:1+nrd)
      lrc = iwork(2+nrd)
      lic = iwork(3+nrd)
      nrd = iwork(4+nrd)
      ir = iwork(5+nrd)
      
      rc => rwork(1:lrc)
      j=1+lrc
      xold = rwork(j); j=j+1
      h = rwork(j)
! ----- compute place of ii-th component 
      i=0
      contex=0
      do j=1,nrd
        if (ic(j).eq.ii) then
         i=j; exit
        end if
      end do
      if (i.eq.0) then
         ierr = -1
         return
      end if  
! ----- compute the interpolated value 
      theta=(x-xold)/h 
      contex=rc(ir*nrd+i)
      do j=2,ir
         contex=rc((1+ir-j)*nrd+i)+contex*(theta-1.d0)
      end do
      contex=rc(i)+contex*theta
      return
      end function contex


      end module mod_seulex
      

 
