      module test_nse_mod
      
      use nse_def
      use nse_lib
      use const_def
      use const_lib
      use crlibm_lib
      use chem_def
      use chem_lib
      use net_def
      use net_lib
      
      implicit none



      contains


      subroutine do_test
         integer :: ierr, species, net_handle, newt_imax, maxiters
         real(dp) :: T, logT, Rho, logRho, ye, eta, zbar, atol, &
            eps_nuc_nse, ye_nse_final, dt, nse_eps_nuc_total, nse_eps_neu
         real(dp), pointer, dimension(:) :: X_nse, X_nse_final, X_net
         integer, pointer, dimension(:) :: net_isos, chem_id
         character (len=256) :: net_name
      
         include 'formats.dek'

         write(*,*)            
         write(*,*) 'test nse' 
         write(*,*)            
      
         call setup_for_nse
         
         net_handle = alloc_net_handle(ierr)
         if (ierr /= 0) return   
         
         call net_start_def(net_handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in net_start_def'
            return
         end if
         
         net_name = trim(mesa_data_dir) // '/net_data/nets/approx21.net'
         call read_net_file(net_name, net_handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in read_net_file ' // trim(net_name)
            return
         end if
         
         call net_finish_def(net_handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in net_finish_def'
            return
         end if
         
         species = net_num_isos(net_handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in net_num_isos'
            return
         end if
         
         call get_chem_id_table_ptr(net_handle, chem_id, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in get_chem_id_table_ptr'
            return
         end if
         
         call get_net_iso_table_ptr(net_handle, net_isos, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in get_net_iso_table_ptr'
            return
         end if

         allocate(X_nse(nse_species), X_nse_final(nse_species), X_net(species))
         
         T = 5d9; logT = log10_cr(T)
         Rho = 1d9; logRho = log10_cr(Rho)
         ye = 0.5d0
         
         dt = 1
         eta = 0
         zbar = -1
         
         if (.false.) then ! TESTING SPECIAL VALUES
            T = 9.6d9; logT = log10(T)
            Rho = 6.0d9; logRho = log10(Rho)
            !logT = 9.5061974429931499D+00; T = exp10_cr(logT)
            !logRho = 7.7690291619761904D+00; Rho = exp10_cr(logRho)
            ye = 3.8515844667483845D-01
            eta = 0d0
            dt = 0d0
            write(*,*) 'call get_nse_abundances with test values'
            stop
         end if
         
         call get_nse_abundances( &
            logT, logRho, ye, X_nse, ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'get_nse_abundances failed'
      	   stop 1
      	end if
      	
         call show(X_nse, nse_species, nse_chem_id, 'initial X_nse')
         
         call convert_from_nse_abundances( &
            X_nse, species, net_isos, chem_id, &
            X_net, ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'convert_from_nse_abundances failed'
      	   stop 1
      	end if
      	
         call show(X_net, species, chem_id, 'initial X_net')

         atol = 1d-10
         newt_imax = 15
         maxiters = 100
         call advance_nse( &
            dt, X_nse, ye, logT, logRho, eta, zbar, &
            atol, newt_imax, maxiters, &
            X_nse_final, nse_eps_nuc_total, nse_eps_neu, ye_nse_final, &
            ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'advance_nse failed'
      	   stop 1
      	end if
      	
      	eps_nuc_nse = nse_eps_nuc_total - nse_eps_neu
      	
         call show(X_nse_final, nse_species, nse_chem_id, 'final X_nse')
         
         call convert_from_nse_abundances( &
            X_nse_final, species, net_isos, chem_id, &
            X_net, ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'convert_from_nse_abundances failed'
      	   stop 1
      	end if
      	
         call show(X_net, species, chem_id, 'final X_net')
      	
      	write(*,1) 'nse_eps_nuc_total', nse_eps_nuc_total
      	write(*,1) 'nse_eps_neu', nse_eps_neu
      	write(*,1) 'eps_nuc_nse', eps_nuc_nse

         deallocate(X_nse, X_nse_final, X_net)
         
         
         contains
         
         subroutine show(X, species, chem_id, str)
            use num_lib, only: qsort
            real(dp), intent(in) :: X(:)
            integer, intent(in) :: species, chem_id(:)
            character (len=*) :: str
            integer :: index(species), i
            real(dp) :: xh, xhe, abar, zbar, z2bar, ye, mass_correction, sumx          
            include 'formats.dek'            
            call basic_composition_info( &
               species, chem_id, X, xh, xhe, & 
               abar, zbar, z2bar, ye, mass_correction, sumx)
      	   write(*,1) trim(str) // ' ye', ye
            call qsort(index, species, X)
      	   write(*,1) 'top 10 by mass fraction'
53          format(1x,a6,'=',1pe14.7,'  ',a6,'=',1pe14.7,'  ', &
                a6,'=',1pe14.7,'  ',a6,'=',1pe14.7,'  ', &
                a6,'=',1pe14.7,'  ',a6,'=',1pe14.7)               
            write(*,53) (chem_isos% name(chem_id(index(i))), X(index(i)), &
                        i=species,max(1,species-9),-1)
            write(*,*)            
         end subroutine show
         

      end subroutine do_test


      subroutine setup_for_nse
         use rates_lib, only: rates_init

         character (len=32) :: my_mesa_dir
         integer :: ierr
         ierr = 0         
         
         my_mesa_dir = '../..'         
         call const_init(my_mesa_dir,ierr)     
      	if (ierr /= 0) then
      	   write(*,*) 'const_init failed'
      	   stop 1
      	end if        

         call crlibm_init

      	ierr = 0
      	call chem_init('isotopes.data', ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'chem_init failed'
      	   stop 1
      	end if

        call rates_init('reactions.list', '', .false., '', '', '', ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'rates_init failed'
      	   stop 1
      	end if
                  
         call net_init(ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'net_init failed'
      	   stop 1
      	end if
          	
         call nse_init(ierr) 
      	if (ierr /= 0) then
      	   write(*,*) 'nse_init failed'
      	   stop 1
      	end if
         
      end subroutine setup_for_nse 


      end module test_nse_mod




      program test_nse
      use test_nse_mod
      implicit none
      call do_test
      end program
