! ***********************************************************************
!
!   Copyright (C) 2013  Frank Timmes, Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 
      module nse_lib
      
      use nse_def
      use const_def, only: dp
      
      implicit none


      contains
      
      
      subroutine nse_init(ierr)      
         use nse_def, only : nse_def_init
         use mod_nse_init, only : init_nse
         integer, intent(out) :: ierr ! 0 means AOK.  
         logical, parameter :: trace = .false.    
         ierr = 0   
         call nse_def_init(trace, ierr)
         if (ierr /= 0) return
         call init_nse(ierr)
      end subroutine nse_init
      
#ifdef offload
      !dir$ options /offload_attribute_target=mic
#endif            
      
      ! sets X_nse to mass fractions for given T, Rho, ye
      subroutine get_nse_abundances( &
            ! inputs
            log10_T, log10_Rho, ye, &
            ! outputs
            X_nse, ierr)
         use mod_nse, only : do_get_nse_abundances
         real(dp), intent(in) :: log10_T, log10_Rho, ye
         real(dp), pointer, intent(out) :: X_nse(:) ! (nse_species)
         integer, intent(out) :: ierr
         call do_get_nse_abundances(log10_T, log10_Rho, ye, X_nse, ierr)
      end subroutine get_nse_abundances

      
      ! sets X_nse_final to new abundances resulting from time dt
      ! at given T and Rho and initial abundances X_nse_init.
      subroutine advance_nse( &
            ! inputs
            dt, X_nse_init, ye_nse_init, log10_T, log10_Rho, eta, zbar, &
            atol, newt_imax, maxiters, &
            ! outputs
            X_nse_final, nse_eps_nuc_total, nse_eps_neu, nse_ye_final, &
            ierr)
         use mod_nse, only : do_advance_nse
         real(dp), intent(in) :: dt ! in seconds
         real(dp), pointer, intent(in) :: X_nse_init(:) ! needed for eps_nuc
            ! baryonic mass fractions (nse_species)
         real(dp), intent(in) :: ye_nse_init ! ye of X_nse_init
         real(dp), intent(in) :: log10_T, log10_Rho, eta, zbar, atol
            ! eta is electron degeneracy parameter from eos
         integer, intent(in) :: newt_imax, maxiters
         real(dp), pointer, intent(out) :: X_nse_final(:) ! (nse_species)
         real(dp), intent(out) :: nse_eps_nuc_total, nse_eps_neu ! erg g^-1 s^-1
            ! eps_nuc_nse = nse_eps_nuc_total - nse_eps_neu
               ! nse_eps_nuc_total = rate of energy production
               ! nse_eps_neu = rate lost to neutrinos from weak reactions.
            ! does not include thermal neutrinos.
            ! uses weaklib for information about the nse net weak reactions.
         real(dp), intent(out) :: nse_ye_final ! ye of X_nse_final
         integer, intent(out) :: ierr
         call do_advance_nse( &
            dt, X_nse_init, ye_nse_init, log10_T, log10_Rho, eta, zbar, &
            atol, newt_imax, maxiters, &
            X_nse_final, nse_eps_nuc_total, nse_eps_neu, nse_ye_final, &
            ierr)
      end subroutine advance_nse

      
      subroutine get_nse_eps_info( &
            X_nse, ye, log10_T, log10_Rho, eta, zbar, &
            nse_eps_nuc_total, nse_eps_neu, &
            ierr)
         use mod_nse, only : do_get_nse_eps_info
         real(dp), pointer, intent(in) :: X_nse(:) ! (nse_species)
         real(dp), intent(in) :: ye, log10_T, log10_Rho, eta, zbar
         real(dp), intent(out) :: nse_eps_nuc_total, nse_eps_neu ! erg g^-1 s^-1
         integer, intent(out) :: ierr
         call do_get_nse_eps_info( &
            X_nse, ye, log10_T, log10_Rho, eta, zbar, &
            nse_eps_nuc_total, nse_eps_neu, &
            ierr)
      end subroutine get_nse_eps_info
      
     
      ! sets X_net from X_nse while preserving ye
      subroutine convert_from_nse_abundances( &
            ! inputs
            X_nse, species, net_isos, chem_id, &
            ! outputs
            X_net, ierr)
         use mod_nse, only : do_convert_from_nse_abundances
         real(dp), pointer, intent(in) :: X_nse(:) ! (nse_species)
         integer, intent(in) :: species
         integer, pointer, intent(in) :: net_isos(:) ! (num_chem_isos)
            ! maps chem id to net iso number
         integer, pointer, intent(in) :: chem_id(:) ! (species)
            ! maps net iso number to chem id
         real(dp), pointer, intent(out) :: X_net(:) ! (species)
            ! net mass fractions
         integer, intent(out) :: ierr
         call do_convert_from_nse_abundances( &
            X_nse, species, net_isos, chem_id, X_net, ierr)
      end subroutine convert_from_nse_abundances

#ifdef offload
      !dir$ end options
#endif

      end module nse_lib

