! ***********************************************************************
!
!   Copyright (C) 2013  Frank Timmes, Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************
 

      module nse_def_mic
      use const_def, only: dp
      
      implicit none

#ifdef offload
      !dir$ options /offload_attribute_target=mic
#endif              
         
      real(dp), parameter :: min_T_for_NSE = 2d9 ! logT ~= 9.3
      real(dp), parameter :: min_lnT_for_NSE = 21.4164130175064d0 ! log(2d9)

      
      integer :: nse_net_handle, nse_species, nse_num_reactions, &
         nse_num_weaklib_rates, max_nse_Z
      integer, pointer, dimension(:) :: &
         nse_chem_id, nse_net_iso, nse_reaction_id, nse_index, &
         nse_weak_reaction_num, nse_weak_reaction_index, nse_weaklib_ids
      character (len=256) :: nse_net_name

! NOTE: any changes to the following must be reflected in the routines that read/write the cache


! ionmax is the number is isotopes in the network - sets the size of all allocatable arrays
! ionbeg is the location of the first isotope
! ionend is the location of the last isotope

      integer :: ionmax,ionbeg,ionend

! mass fractions, other composition variables
! ionam     = name of the isotope in the network
! wion      = atomic weight or molar mass of isotope
! aion      = number of nucleons
! zion      = number of protons
! nion      = number of neutrons
! bion      = binding energies

      logical :: have_allocated = .false.

      character*5, allocatable :: ionam(:)
      real(dp), allocatable :: mion(:),wion(:),aion(:),zion(:),nion(:),bion(:)
      integer, allocatable :: torch_chem_id(:),torch_net_iso(:)


! for the links between isotopes
      integer, allocatable :: nrr(:,:), nrrneut(:,:)

! for the temperature dependent partition functions
      integer, allocatable :: ist(:)
      real(dp), allocatable  :: as(:),gs(:)

! for easy identification of key isotopes
      integer :: &
          ih1,iprot,ineut,ihe4,ih2,ih3,ihe3,ili6,ili7,ili8, &
          ibe7,ibe9,ib8,ib9,ib10,ib11,ic11,ic12,ic13,ic14, &
          in12,in13,in14,in15,io14,io15,io16,io17,io18,if17, &
          if18,if19,ine18,ine19,ine20,ine21,ine22,ine23,ina20,ina21,ina22, &
          ina23,img22,img23,img24,img25,img26,ial25,ial26,ial27,ial28, &
          isi26,isi27,isi28,isi29,isi30,ip28,ip29,ip30,ip31,is30, &
          is31,is32,icl35,iar36,ik39,ica40,isc43,isc45,iti44,iti46, &
          iti48,iti50,iv46,iv47,iv48,iv51,icr47,icr48,icr49,icr50, &
          icr51,icr52,icr53,icr54,imn50,imn51,imn52,imn55,ife52,ife54, &
          ife55,ife56,ife57,ife58,ico54,ico55,ico56,ico59,ini56,ini58, &
          ini59,ini64,ini66,icu63,izn60,izn64

            


      contains   


      subroutine nse_def_init_mic(ierr)
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine nse_def_init_mic

#ifdef offload
      !dir$ end options
#endif

      end module nse_def_mic

